/*
 * (c) ELCUS,  2010,2014
 *
 * Part of this code comes from the book "Linux Device Drivers"
 * by Alessandro Rubini and Jonathan Corbet, published
 * by O'Reilly & Associates.
*/
/*
kernel 3.8.0-35-generic

	make  -C /usr/src/linux SUBDIRS=$PWD modules

	./pci104Load

*/


#include <linux/init.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/fs.h>
#include <asm/uaccess.h>
#include <linux/types.h>
#include <linux/pci.h>
#include <linux/unistd.h>
#include <linux/interrupt.h>
#include <linux/spinlock.h> 
#include <linux/ioctl.h> 
#include <linux/version.h>

#include "pci104LNXioctl.h"

#ifndef CONFIG_PCI
#  error "This driver needs PCI support to be available"
#endif

MODULE_LICENSE("GPL");
MODULE_AUTHOR("VERA KOURIANOVA");
MODULE_DESCRIPTION("PCI104-429-1 device driver ver 3.8.0");
MODULE_VERSION("3.8.0-15-generic");


/* The name for our device, as it will appear 
 * in /proc/devices */
#define DEVICE_NAME "pci104_"


#define DEVICE_NUMBER 8




typedef struct
{
 unsigned short int 		p,
			      	rfi,
			      	rfiINT ,
			      	bSN ,
			      	PLX ,
				hSEM,
	       			sigN,
	       			busy;
 unsigned char		      	r;
 struct task_struct * pp;
}PCI429_3_Info,*pPCI429_3;

static PCI429_3_Info aPCI429_3_Info[DEVICE_NUMBER];

spinlock_t pci429_3_lock, pci429_3_IRQlock;


static irqreturn_t irq_handler(int irq, 
                 void *dev_id)
{ 
	PCI429_3_Info* dev;
	spin_lock(&pci429_3_IRQlock);
	dev = dev_id;

	if (inw(dev->PLX)&4)
	{	
		dev->rfiINT = inw(dev->rfi);
		send_sig(dev->sigN,dev->pp,0);
		spin_unlock(&pci429_3_IRQlock);
		return IRQ_HANDLED; 	
	}
	spin_unlock(&pci429_3_IRQlock);
	return IRQ_NONE; 
}
					 

				 
static int pci429_open(struct inode *inode, struct file *filp)
{
  unsigned int i;
  int result;

	spin_lock(&pci429_3_lock);
	i = MINOR(inode->i_rdev);

	if(aPCI429_3_Info[i].busy==0)
	{
		aPCI429_3_Info[i].busy= 1;
		try_module_get(THIS_MODULE);
     		result = request_irq(aPCI429_3_Info[i].r,irq_handler,IRQF_SHARED, "pci429_", &aPCI429_3_Info[i]);
		spin_unlock(&pci429_3_lock);
		return 0;  
	}
	else
	
	{
		spin_unlock(&pci429_3_lock);
		return -1;  
	}
}






static int pci429_release(struct inode *inode, struct file *filp)
{

  unsigned int i;
	spin_lock(&pci429_3_lock);

	i = MINOR(inode->i_rdev);

	free_irq( aPCI429_3_Info[i].r,&aPCI429_3_Info[i]);
	aPCI429_3_Info[i].busy= 0;
	module_put(THIS_MODULE);

	spin_unlock(&pci429_3_lock);
	return 0;
}


long pci429_ioctl (struct file *filp,
         unsigned int cmd, unsigned long arg)

{
  unsigned short int port,portA, portD,
  			tmp, rmod, addr, ii, work;
  unsigned int i;
		spin_lock(&pci429_3_lock);

	i = MINOR(filp->f_dentry->d_inode->i_rdev);

		
switch(cmd) 
 {
	case IOCTL_INT:
		{
		__get_user(aPCI429_3_Info[i].hSEM,(int *)(arg+0x1900*2));
		#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
		aPCI429_3_Info[i].pp = find_task_by_pid(aPCI429_3_Info[i].hSEM);
		#elif LINUX_VERSION_CODE < KERNEL_VERSION(2,6,31)
		aPCI429_3_Info[i].pp = find_task_by_vpid(aPCI429_3_Info[i].hSEM);
		#else
		aPCI429_3_Info[i].pp = pid_task(find_vpid(aPCI429_3_Info[i].hSEM), PIDTYPE_PID );
		#endif
		aPCI429_3_Info[i].sigN=SIGUSR1;

		spin_unlock(&pci429_3_lock);
		break;
		}
		
	case IOCTL_RJ:
		{

		port = aPCI429_3_Info[i].p;


		__put_user( port,(unsigned short *)(arg+0x2000));
		__put_user( port+2,(unsigned short *)(arg+0x2002));
		__put_user( port+4,(unsigned short *)(arg+0x2004));
		__put_user( port+6,(unsigned short *)(arg+0x2006));
		__put_user( port+8,(unsigned short *)(arg+0x2008));
		__put_user( port+10,(unsigned short *)(arg+0x200a));

		outw( 0, port);
		port+=2;
		for (i=0;i<0x8000;i++)
		{
			outw( 0, port);
		}

		port+=2;
		outw( 7, port);
		__put_user( 7,(unsigned short *)(arg+0x2200));

		tmp=inw(port);
		__put_user ( tmp,(unsigned short *)(arg+0x2202));
		
		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_INIT: 
		{
		
		__get_user(port, (unsigned short *)(arg+0x2004));
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));
		__get_user(rmod, (unsigned short *)(arg+0x2200));
		
		rmod=rmod|0x1;

		outw( rmod, port);

		
		outw( 0, portA);
		for (i=0;i<0x1000;i++)
		{
			outw( 0, portD);
		}

		outw( 0, portA);

		for (i=0;i<0x10;i++)
		{
			__get_user(work, (unsigned short *)(arg+i*2));
			outw( work, portD);
		}

		addr=0;
		for (i=0;i<8; i++)
		{		
			__get_user(work, (unsigned short *)(arg+0x2020+i*2));
			addr+=work;
		}
		addr=addr*0x200;
		for  (i=0;i<8; i++)
		{
		__get_user(work, (unsigned short *)(arg+0x2020+i*2));
			if ( work==0)
			{
			__put_user ( addr,(unsigned short *)(arg+0x2030+i*2));
				addr+=0x200;
			}
			else
			{
			__put_user ( 0,(unsigned short *)(arg+0x2030+i*2));
			}
		}

		outw( rmod&0xfffe, port);


		spin_unlock(&pci429_3_lock);
		break;
		}

 	case IOCTL_STOP:
		{
		__get_user(port, (unsigned short *)(arg+0x2004));
		outw( 7, port);
		__put_user( 7,(unsigned short *)(arg+0x2200));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_DAN_SO:
		{

		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(addr, (unsigned short *)(arg+0x2220));
		outw( addr, portA);

		__get_user(work, (unsigned short *)(arg+addr*2));
		outw( work, portD);

		addr++;
		__get_user(work, (unsigned short *)(arg+addr*2));
		outw( work, portD);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_WRITE_PRM_G:
		{

		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(addr, (unsigned short *)(arg+0x2220));
		outw( addr+1, portA);
		outw( 0, portD);

		outw( addr, portA);

		__get_user(work, (unsigned short *)(arg+addr*2));
		outw( work, portD);

		addr++;
		__get_user(work, (unsigned short *)(arg+addr*2));
		outw( work, portD);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_READ_PRM_SS:
		{

		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(addr, (unsigned short *)(arg+0x2220));
		__get_user(work, (unsigned short *)(arg+0x2218));
		
		work=work+0xf;	//
		outw( work, portA);

		ii=inw(portD)&0xff;
	
		do 
		{
			i=ii;
			outw( addr, portA);
			tmp=inw(portD);
			__put_user ( tmp,(unsigned short *)(arg+addr*2));
			tmp=inw(portD);
			__put_user ( tmp,(unsigned short *)(arg+addr*2+2));

			outw( work, portA);
			ii=inw(portD)&0xff;
		}while (i!=ii);

		spin_unlock(&pci429_3_lock);
		break;
		}



	case IOCTL_READ_PRM_BT:  
		{

		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(addr, (unsigned short *)(arg+0x2220));
		outw( addr, portA);

		work=inw(portD);

		do
		{
			__put_user ( work,(unsigned short *)(arg+addr*2));
			outw( addr, portA);
			outw( 0, portD);
			work=inw(portD);
			__put_user ( work,(unsigned short *)(arg+addr*2+2));

			outw( addr, portA);
			work =inw(portD);
		}while (work!=0);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_DAN_SI:  
		{

		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(addr, (unsigned short *)(arg+0x2220));
		outw( addr, portA);

		tmp=inw(portD);
		__put_user ( tmp,(unsigned short *)(arg+addr*2));
		tmp=inw(portD);
		__put_user ( tmp,(unsigned short *)(arg+addr*2+2));

		spin_unlock(&pci429_3_lock);
		break;
		}
		
		
	case IOCTL_READ_Z:
		{
		__get_user(port, (unsigned short *)(arg+0x2004));
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(addr, (unsigned short *)(arg+0x2220));
		__get_user(rmod, (unsigned short *)(arg+0x2200));
		i=rmod&0x80;
		outw( addr, portA);
		outw( 0, portD);
		if(i==0)
			work=0x8000;
		else
			work=0;

		outw( work, portD);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_SET_DO:	                    
		{
		__get_user(port, (unsigned short *)(arg+0x2008));
		__get_user(work, (unsigned short *)(arg+0x220c));
		outw( work, port);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_GET_DI:		               
		{
		__get_user(port, (unsigned short *)(arg+0x2008));
		work=inw(port);
		__put_user ( work,(unsigned short *)(arg+0x220e));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_SET_RI:
		{
		__get_user(port, (unsigned short *)(arg+0x2006));
		outw( 0, port);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_GET_RI:  
		{
		work=inw(aPCI429_3_Info[i].p+6);

		__put_user ( work,(unsigned short *)(arg+0x2208));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_GET_RFI:  
		{
		__get_user(port, (unsigned short *)(arg+0x200a));
		work=inw(port);
		__put_user ( work,(unsigned short *)(arg+0x2e00));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_GET_RFI_INT:  
		{
		i  &=0xff;
		__put_user ( aPCI429_3_Info[i].rfiINT,(unsigned short *)(arg+0x2e02));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_SET_RD:
		{
		__get_user(port, (unsigned short *)(arg+0x2002));
		__get_user(work, (unsigned short *)(arg+0x220a));
		outw( work, port);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_GET_RD:
		{
		__get_user(port, (unsigned short *)(arg+0x2002));
		work=inw(port);
		__put_user ( work,(unsigned short *)(arg+0x220a));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_SET_RA:
		{
		__get_user(port, (unsigned short *)(arg+0x2000));
		__get_user(work, (unsigned short *)(arg+0x220a));
		outw( work, port);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_GET_RJ:   
		{
		__get_user(port, (unsigned short *)(arg+0x2004));
		work=inw(port);
		__put_user ( work,(unsigned short *)(arg+0x2202));

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_SET_RM:
		{
		__get_user(port, (unsigned short *)(arg+0x2004));
		__get_user(work, (unsigned short *)(arg+0x2200));
		outw( work, port);

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_READ_MEM:  
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));
		__get_user(addr, (unsigned short *)(arg+0x2210));
		__get_user(work, (unsigned short *)(arg+0x2212));

		outw( addr, portA);

		for (i=0; i<work; i++)
		{
		tmp=inw(portD);
		__put_user ( tmp,(unsigned short *)(arg+addr*2+i*2));
		
}

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_WRITE_MEM:
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));
		__get_user(addr, (unsigned short *)(arg+0x2214));
		__get_user(work, (unsigned short *)(arg+0x2216));


		outw( addr, portA);

		for (i=0; i<work; i++)
		{
		__get_user(tmp, (unsigned short *)(arg+addr*2+i*2));
		outw( tmp, portD);
		}

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_TAB_SO_G:
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		
		__get_user(tmp, (unsigned short *)(arg+0x2218));
		
		outw( (tmp+0x17), portA);
		work=(inw(portD))&0x100;		//

		if (work!=0x100)
		{
		addr=0x2800+(tmp-1)*0x100;		//
		__get_user(work, (unsigned short *)(arg+0x2216));
		outw( addr, portA);
		
		for (i=0; i<work; i++)
			{
			__get_user(ii, (unsigned short *)(arg+(addr+i)*2));
			outw( ii, portD);
			}
			
		__put_user ( 0,(unsigned short *)(arg+0x2204));	//not error

		}
		else
		{
		__put_user ( 1,(unsigned short *)(arg+0x2204));	//error
		}

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_TAB_SO_F:
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(tmp, (unsigned short *)(arg+0x2218));  //NC
		outw( (tmp+0x17), portA);
		work=(inw(portD));	
			
		i= (work&0x2000)>>13;	// NB  RS
		work=work&0x100;		// ES  RS

		__get_user(ii, (unsigned short *)(arg+0x221a));
		if ((work==0x100)&&(i==ii))	//
		{
			__put_user ( 1,(unsigned short *)(arg+0x2204));	//error
		}
		else
		{
			i=tmp-1;
			addr=0x2800+ii*0x1000+i*0x100;
			__get_user(work, (unsigned short *)(arg+0x2030+i*2));
				
			outw( addr, portA);

			for (i=0; i<256; i++)
			{
			__get_user(tmp, (unsigned short *)(arg+(addr+i)*2)); 
			tmp=tmp|0x1000|i*0x2|work ;
			outw( tmp, portD);
			}
			
			__put_user ( 0,(unsigned short *)(arg+0x2204));	//not error

		}


		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_TAB_SI:
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));

		__get_user(tmp, (unsigned short *)(arg+0x2218));  //NC
		outw( (tmp+0xf), portA);
		work=(inw(portD));	

		i= (work&0x2000)>>13;	//  NB 
		work=work&0x100;		//  ES  RS

		__get_user(ii, (unsigned short *)(arg+0x221a));    //nb
		if ((work==0x100)&&(i==ii))	
		{
			__put_user ( 1,(unsigned short *)(arg+0x2204));	//error
		}
		else
		{
			addr=0x2000+ii*0x1000+(tmp-1)*0x100;
			
			outw( addr, portA);

			for (i=0; i<256; i++)
			{
			__get_user(work, (unsigned short *)(arg+(addr+i)*2)); 
			work=work|i*2|((tmp-1)*0x200);
			outw( work, portD);
			
}
			
			__put_user ( 0,(unsigned short *)(arg+0x2204));	//not error

		}


		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_STOP_CH:	 
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));
		
		
		__get_user(work, (unsigned short *)(arg+0x221c));
		work =work+0x20;
		outw( (work), portA);
		outw( 0x400, portD);

		__put_user ( 0x400,(unsigned short *)(arg+work*2));	//

		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_PUSK_SO:	  
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));
		__get_user(addr, (unsigned short *)(arg+0x221c));  //nc
		addr--;
		__get_user(work, (unsigned short *)(arg+0x221e));  //nb


		outw( (addr+0x28), portA);

		i =(inw(portD))&0x400;	//

		if ( i==0x400 )
			__put_user ( 1,(unsigned short *)(arg+0x2204));	//error
		else
		{
			__get_user(i, (unsigned short *)(arg+0x2040+(addr*3+work*24)*2));
			
			if (i==0)
			__put_user ( 2,(unsigned short *)(arg+0x2204));	//error
			else
			{
			outw( (addr+0x28), portA);
			__get_user(tmp, (unsigned short *)(arg+(addr+0x28)*2));  
			outw( tmp, portD);
			__put_user ( 0,(unsigned short *)(arg+0x2204));	//not error

			}
		}


		spin_unlock(&pci429_3_lock);
		break;
		}

	case IOCTL_PUSK_SI:
		{
		__get_user(portA, (unsigned short *)(arg+0x2000));
		__get_user(portD, (unsigned short *)(arg+0x2002));
		__get_user(addr, (unsigned short *)(arg+0x221c));  //nc
		addr--;
		__get_user(work, (unsigned short *)(arg+0x221e));  //nb

		outw( (addr+0x20), portA);
		i =(inw(portD))&0x400;	//

		if ( i==0x400 )
			__put_user ( 1,(unsigned short *)(arg+0x2204));	//error
		else
		{
			__get_user(i, (unsigned short *)(arg+0x20a0+(addr+work
			
			*8)*2));
			
			if (i==0)
			__put_user ( 2,(unsigned short *)(arg+0x2204));	//error
			else
			{
			outw( (addr+0x20), portA);
			__get_user(tmp, (unsigned short *)(arg+(addr+0x20)*2));  
			outw( tmp, portD);
			__put_user ( 0,(unsigned short *)(arg+0x2204));	//not error

			}
		}



		spin_unlock(&pci429_3_lock);
		break;
		}
	case IOCTL_GET_SER_NUMBER:
	
		{
		__put_user ( aPCI429_3_Info[i].bSN,(unsigned short *)(arg+0x30a0));

		spin_unlock(&pci429_3_lock);
		break;
		}

 }
	return 0;  
}



/* Module Declarations ***************************** */

/* The major device number for the device. This is 
 * global (well, static, which in this context is global
 * within this file) because it has to be accessible 
 * both for registration and for release. */

static int Major = 0;

/* This structure will hold the functions to be 
 * called when a process does something to the device 
 * we created.*/

static struct file_operations pci429_fops = {
 .unlocked_ioctl   = pci429_ioctl,
 .open    = pci429_open,
 .release = pci429_release
};




	unsigned short ptr, SN[6];
	
	
	
static int __init  pci429_3_initialization(void)

{
   unsigned long int  ch1,sss;
   unsigned short  m, number = 0, temp;
   int i;
     
   struct pci_dev *dev = NULL;
 
   	spin_lock_init(&pci429_3_lock);
   	spin_lock_init(&pci429_3_IRQlock);



 /* Register the character device (atleast try) */
  Major = register_chrdev(0, 
                          DEVICE_NAME,
                          &pci429_fops);
   if (Major < 0)
   {
    printk ("%s device pci429 failed with %d\n",
	    "Sorry, registering the character",
	    Major);
    return Major;
   }
  
    printk ("%s The major pci429 device number is %d.\n",
          "Registeration is a success.",
          Major);
          
          
    dev = pci_get_device(0x10b5,0x9030, dev);
 
    while (dev)
	{
		pci_enable_device(dev);

		pci_read_config_word(dev, 0x2c, &ptr);

	    	if (ptr==0xe1c5) 
	    	{
			pci_read_config_word(dev, 0x2e, &ptr);
 
	    		if (ptr==0x0203) 
	    		{

				pci_read_config_word(dev, 0x14, &temp);
				temp = (temp & 0xfffe) + 0x4c;
				aPCI429_3_Info[number].PLX =  temp;

				pci_read_config_word(dev, 0x18, &temp);	
				temp &=0xfffe;
				aPCI429_3_Info[number].p =  temp;
 				aPCI429_3_Info[number].rfi = temp+0xa;

				aPCI429_3_Info[number].r=dev-> irq;

				ptr=0;
				pci_write_config_word(dev, 0x4e, 0xcc);
	
				m=0; ch1=0;
	
				while(!(m&0x8000))
				{
					pci_read_config_word(dev, 0x4e, (u16*)&m);
					ch1++;
					if(ch1==0xfff)
					{
						ch1=0;
						pci_write_config_word(dev, 0x4e, 0xcc);
					}
				};
	
		
				pci_read_config_dword(dev, 0x50,(u32 *) &sss);

				SN[0]=(sss>>16)&0xff;
				SN[1]=(sss>>24)&0xff;


				pci_write_config_word(dev, 0x4e, 0xd0);
				m=0; ch1=0;
	
				while(!(m&0x8000))
				{
					pci_read_config_word(dev, 0x4e, (u16*)&m);
					ch1++;
					if(ch1==0xfff)
					{
						ch1=0;
						pci_write_config_word(dev, 0x4e, 0xd0);
					}
				};
	
				pci_read_config_dword(dev, 0x50, (u32 *)&sss);

     				SN[2]=sss&0xff;
     				SN[3]=(sss>>8)&0xff;
     				SN[4]=(sss>>16)&0xff;
				aPCI429_3_Info[number].bSN =(SN[0]-0x30)*10000+(SN[1]-0x30)*1000+(SN[2]-0x30)*100+(SN[3]-0x30)*10+(SN[4]-0x30);

				number++;

			}
		}
 	    	dev = pci_get_device(0x10b5,0x9030, dev);
 	}
	for (i=0; i<DEVICE_NUMBER; i++)
		 aPCI429_3_Info[i].busy= 0;


 	return 0; 
}


static void __exit pci429_3_cleanup(void) 
 {  

  	/* Unregister the device */
  	unregister_chrdev(Major, DEVICE_NAME);
 
  }
 
module_init(pci429_3_initialization);
module_exit(pci429_3_cleanup);
