#include <signal.h>
#include <stdio.h>
#include "../pci104LNXmacro.h"
#include <sys/time.h>

	int  hARINC;
	short unsigned int Data[32768],inpBuf[5];

 	char txt1[100];
	long int receivedCode
		,expectedCode
		,numberOfINT1=0
		,numberOfINT2=0
		,cycleNumber=0;
	
	int 	numberSI=0
		,numberSO=0
		,i
		,dii=0
		,err_rk=0
		,ii[16]
		,err_si=0
		,i1;

 	struct sigaction action;
 	struct itimerval timer;
    
	
void hINT (int signo)
{
 	short unsigned int w;
	READ_RFI_INT(hARINC,Data,w) ;
	if(w&0x1000)
	{
		do
		{
			READ_RI(hARINC,Data,ii[15],ii[14],ii[13],ii[12]
				,ii[11],ii[10],ii[9],ii[8],ii[7],ii[6]
				,ii[5],ii[4],ii[3],ii[2],ii[1],ii[0]);
			numberOfINT2+=ii[8];
		 }while (ii[8]!=0);
 	}
	if(w&0xf00)	numberOfINT1++;
	WRITE_RI(hARINC,Data);
	return ;
}
	
void timerNonstop (int signo)

{
   int	delta=numberSI-numberSO, err_SI;
	
	err_SI=err_si;
	

   if(timer.it_value.tv_usec == 500000)
   {

	GET_DI(hARINC,Data,dii);
	if( (cycleNumber&0x3ff)!=dii)
		err_rk++;
	cycleNumber++;

	SET_DO(hARINC,Data,(short unsigned int) cycleNumber);


	for (i1=1; i1<=numberSI/2; i1++)
	{
	    for (i=255;i>=0;i--)
	    {
		    READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
		    expectedCode=((i)&0xff)|((i1&0xff)<<8)
			|(((~(i))&0xff)<<16)|(((~i1)&0xff)<<24);
		    if ( receivedCode!=expectedCode)
			err_si++;
 	    }
	}
	
	
	for (i1=numberSI/2+1; i1<=numberSI; i1++)
	{
	    for (i=255;i>=0;i--)
	    {
		    READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
		    expectedCode=((i)&0xff)|(((i1-delta)&0xff)<<8)
			|(((~(i))&0xff)<<16)|(((~(i1-delta))&0xff)<<24);
		    if ( receivedCode!=expectedCode)
			err_si++;
	    }
	}
	
	
	if(err_SI!=err_si)
	{
    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 0;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 0;
      		setitimer(ITIMER_REAL, &timer, NULL);

    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 950000;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 950000;
      		setitimer(ITIMER_REAL, &timer, NULL);
		SET_DO(hARINC,Data,(short unsigned int) 0);
	}

  	printf(" \r");
  	printf("cycle #=%5ld di=%2d err_di=%3d err_si=%3d INT2 #=%5ld INT1 #=%5ld\r",cycleNumber,dii,err_rk,err_si,numberOfINT2,numberOfINT1);
	
	
   }//if(timer.it_value.tv_usec == 500000)

   else
	{
		err_si++;
    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 0;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 0;
      		setitimer(ITIMER_REAL, &timer, NULL);
     		
		for( i=1; i<=numberSO;i++)
			STOP_SO(hARINC,Data,i);
	
		for( i=1; i<=numberSI;i++)
			STOP_SI(hARINC,Data,i);
	
		ARINC_STOP(hARINC,Data);
	
		Start();
    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 500000;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 500000;
      		setitimer(ITIMER_REAL, &timer, NULL);
	}
}



void timerErrorstop (int signo)

{
	int	delta=numberSI-numberSO,ch, param;
	
	GET_DI(hARINC,Data,dii);

	cycleNumber++;

	SET_DO(hARINC,Data,(short unsigned int) cycleNumber);


	for (i1=1; i1<=numberSI/2; i1++)
	{
		for (i=0;i<=255;i++)
		{
			READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
			expectedCode=((i)&0xff)|((i1&0xff)<<8)
				|(((~(i))&0xff)<<16)|(((~i1)&0xff)<<24);

			if ( receivedCode!=expectedCode)
			{
				ch=i1;
				param=i;
				i=256;
				i1=256;
		   		timer.it_value.tv_sec = 0;
		    		timer.it_value.tv_usec = 0;
		      		timer.it_interval.tv_sec = 0;
		    		timer.it_interval.tv_usec = 0;
		      		setitimer(ITIMER_REAL, &timer, NULL);
			}
		}
	}


	if(i1<256)	
	{
	for (i1=numberSI/2+1; i1<=numberSI; i1++)
	{
		for (i=0;i<=255;i++)
		{
			READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
			expectedCode=((i)&0xff)|(((i1-delta)&0xff)<<8)
				|(((~(i))&0xff)<<16)|(((~(i1-delta))&0xff)<<24);
			if ( receivedCode!=expectedCode)
			{
				ch=i1;
				param=i;
				i=256;
				i1=256;
		  		timer.it_value.tv_sec = 0;
		    		timer.it_value.tv_usec = 0;
		      		timer.it_interval.tv_sec = 0;
		    		timer.it_interval.tv_usec = 0;
		      		setitimer(ITIMER_REAL, &timer, NULL);
			}
		}
	}
	}

  	printf(" \r");
  	
 	if(i1<256)	
	{
	 	printf("cycle #=%5ld di=%2d  INT2 #=%5ld INT1 #=%5ld\r"
			,cycleNumber,dii,numberOfINT2,numberOfINT1);
 	}
 	else
 	{
	  	printf("cycle #=%5ld di=%2d  INT2 #=%5ld INT1 #=%5ld\n"
			,cycleNumber,dii,numberOfINT2,numberOfINT1);
	  	printf("chanal #=%5d param #=%3d  wait =%8lxh rec =%8lxh\n"
			,ch,param,expectedCode,receivedCode);
	  	printf("Press ENTER for quit");
 	}

}



main ()
{int rj, ind1, sn, snI;
 char msg[15]={'/','d','e','v','/','p','c','i','1','0','4','_'};
 int TestType;
	
	printf("enter serial # :")	;
	scanf("%5d",&snI);
	msg[13]='\0';
      	while(getchar()!=0xa);

	ind1 = 0;
	msg[12]='0';
	do
	{
		hARINC=open(msg,0);
		msg[12]++;
		ind1++;
		if(hARINC!=-1)
		{
			GET_SN(hARINC,Data,sn);
			if(sn == snI) ind1 = 9;
 		}
	}while (ind1 < 8);

	if(hARINC==-1)
	{
		printf("open error \n")	;
		return;
	}

	ioctl(hARINC,IOCTL_RJ ,Data);
	
	GET_RJ_M(Data,rj);
	printf("RID = 0x%x\n",rj)	;

	numberSI = (rj&0xf00)>>8;
	numberSO = (rj&0xf0)>>4;
	printf("numberSI = %x\n",numberSI)	;
	printf("numberSO = %x\n",numberSO)	;

	action.sa_handler = hINT;
	action.sa_flags = 0;
	sigaction(SIGUSR1, &action, NULL);

	INT_SET(hARINC,Data);

	printf("Test mode (without stub).\n")	;
	printf("Test Type [0-nonstop / 1-error stop]:")	;
	scanf("%1d",&TestType);

       	while(getchar()!=0xa);
	printf("Press ENTER for quit \n")	;

	Start();
	timer.it_value.tv_sec = 0;
    	timer.it_value.tv_usec = 500000;
    	timer.it_interval.tv_sec = 0;
    	timer.it_interval.tv_usec = 500000;
							
	if(TestType==0)
	{
		action.sa_handler = &timerNonstop;
		action.sa_flags = 0;
		sigaction(SIGALRM, &action, NULL);
        
     		setitimer(ITIMER_REAL, &timer, NULL);
	}
	else
	{
		action.sa_handler = &timerErrorstop;
		action.sa_flags = 0;
		sigaction(SIGALRM, &action, NULL);
    
		setitimer(ITIMER_REAL, &timer, NULL);
	}
						
	while(getchar()!=0xa);
      							
	timer.it_value.tv_sec = 0;
	timer.it_value.tv_usec = 0;
	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL, &timer, NULL);
     		
	for( i=1; i<=numberSO;i++)
		STOP_SO(hARINC,Data,i);
 	
	for( i=1; i<=numberSI;i++)
		STOP_SI(hARINC,Data,i);
 							
	ARINC_STOP(hARINC,Data);
	
	close(hARINC);
}


Start()
{
	dii=0;
	numberOfINT2=0;
	numberOfINT1=0;
	cycleNumber=0;

	SET_RM(Data,0x0088);

	SET_RF_SO_N(Data,2,2,2,2,2,2,2,2);
	SET_RF_SI_N(Data,2,2,2,2,2,2,2,2);

	INIT_ARINC(hARINC,Data);

	for (i1=1; i1<=numberSO; i1++)
	{
		SET_SO_TAB_Z(Data,i1,0,i);
		SET_SO_DAN_RC_F(hARINC,Data,i1,0,0,1,256);
	}

	for (i1=1; i1<=numberSI; i1++)
	{
		SET_SI_TAB_Z(Data,i1,0,i);
		SET_SI_TAB(hARINC,Data,i1,0);
	}

	for (i1=1; i1<=numberSO; i1++)
	{
		for (i=1;i<=256;i++)
		{
			receivedCode=((i-1)&0xff)|((i1&0xff)<<8)
				|(((~(i-1))&0xff)<<16)|(((~i1)&0xff)<<24);
			WRITE_PRM(hARINC,Data,i1,0,i,receivedCode);
		}
	}

 	for (i1=2; i1<=numberSO; i1++)
	{
		PUSK_SO(hARINC,Data,i1,0,1,0);
	}
	PUSK_SO(hARINC,Data,1,0,0,0);

	for (i1=1; i1<=numberSI; i1++)
	{
		PUSK_SI(hARINC,Data,i1,0,1,1);
	}

}





