
#ifndef __INTRFACE_H__
#define __INTRFACE_H__

#define FILE_DEVICE_ECE0206_1  0x8000

// Define Interface reference/dereference routines for
// Interfaces exported by IRP_MN_QUERY_INTERFACE

#define ECE0206_1_IOCTL(index) \
    CTL_CODE(FILE_DEVICE_ECE0206_1, index, METHOD_BUFFERED, FILE_READ_DATA)

#define ECE02061_XP_WRITE_PARAM_1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_SO_PUSK1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_SO_STOP1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_SO_STATE1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_WRITE_ARRAY_1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_CLEAR_ARRAY_1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x823, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ECE02061_XP_SI_PUSK \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_SI_STOP \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_CLEAR_SI_ARRAY \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ECE02061_XP_READ_ARRAY_AP1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x80a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_CC1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x80b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_AP2 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x80c, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_CC2 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x80d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_AP3 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x80e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_CC3 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x80f, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_AP4 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_ARRAY_CC4 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x811, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_AP1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x81b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_AP2 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x81c, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_AP3 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x81d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_AP4 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x81e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_CC1 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x81f, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_CC2 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x820, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_CC3 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x821, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_READ_PARAM_CC4 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x822, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ECE02061_XP_SET_SHORT_MODE \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x827, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_SET_LONG_MODE \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x828, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ECE02061_XP_GET_TIMER \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x82a, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ECE02061_XP_DO_CLR \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x824, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_DO_SET \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x825, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_DO_SPRT \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x826, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_DO_PULSE \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x82c, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define IOCTL_803 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x812, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_804 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x813, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_807 \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define ECE02061_XP_GET_DRIVER_VERSION \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x816, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_GET_PRODUCT_NAME \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x817, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_GET_MANUFACTURER_NAME \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x818, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_GET_SERIAL_NUMBER \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x819, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_GET_DEVICE_PARAM \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x81a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define ECE02061_XP_GET_DEVICE_VERSION \
    CTL_CODE(FILE_DEVICE_ECE0206_1, 0x82b, METHOD_BUFFERED, FILE_ANY_ACCESS)


typedef struct _ECE02061_XP_DRIVER_VERSION
{
	USHORT MajorVersion;
	USHORT MinorVersion;
	USHORT BuildVersion;

} ECE02061_XP_DRIVER_VERSION, *PECE02061_XP_DRIVER_VERSION;

#define ECE02061_XP_MAJOR_VERSION		02
#define ECE02061_XP_MINOR_VERSION		01
#define ECE02061_XP_BUILD_VERSION		0002

typedef struct _ECE02061_XP_DEVICE_PARAM
{
	UCHAR  bDeviceClass;		//   
	UCHAR  bDeviceSubClass;		//   
	USHORT idVendor;			//   (Vendor ID)
	USHORT idProduct;			//   (Product ID)
	USHORT bcdDevice;			//    BCD-

} ECE02061_XP_DEVICE_PARAM, *PECE02061_XP_DEVICE_PARAM;

#endif // __INTRFACE_H__
