﻿//==============================================
//
//	SO - Циклическая выдача
//	SI - Файловый прием
//==============================================

#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <linux/types.h>

#include <signal.h>
#include <sys/time.h>
#include "pci429LNX.h"

#define   SO_CHANNEL_NUMBER	3
#define   SI_CHANNEL_NUMBER	3
#define   SI_ARRAY_NUMBER	2
#define   PARAM_NUMBER		25


#define   USHORT	__u16
#define   ULONG		__u32

 	struct BufInput2421{
		USHORT  ChanNumber;	//номер канала (1..8) 
		USHORT  ArrayDim;	//размерность массива параметров (1..256);
		USHORT  Period;		//переменная, определяющая период выдачи массива . 
		USHORT  InterrMask;	//=0(1) без прерывания (с прерыванием) по концу выдачи массива
		ULONG   param [256];	//массив выходных параметров
		} ;
	union{ 
		struct 	BufInput2421 bufInput; 
 		USHORT	 bufOutput; 
	}buff2421; 

 	struct BufInput2422{
		USHORT  ChanNumber;	//номер канала (1..8) 
		USHORT  paramNumber;	//номер параметра (0..255)  в выходном массиве;
		ULONG     param ;	//значение выходного параметра
		} ;
	union{ 
 		struct 	BufInput2422 bufInput; 
		USHORT	bufOutput; 
	}buff2422; 


	struct BufOutput2515{
		USHORT  error;		//код ошибки 
		USHORT  reserved;	//
		ULONG   param [256];	//массив параметров
		} ;
	union { 
 		USHORT	bufInput[2]; 
		struct 	BufOutput2515 bufOutput; 
	}buff2515; 

 
	struct BufOutput2524{
		USHORT  error;          // переменная, в которой драйвер возвращает код 
					//ошибки :   1 – ошибочный номер канала
					//    	     2 – ошибочный номер массива 
					//    	     3 – ошибочный адрес параметра 
					//                   0 – без ошибки
		USHORT  reserved;	//
		ULONG Param; 		//переменная, в который драйвер возвращает код
					//параметра		
		};
	union{ 
		USHORT	bufInput[3]; 
 		struct 	BufOutput2524 bufOutput; 
	}buff2524; 



	int  hARINC;
	unsigned short int	buff[16];
	int interruptNumber;
	int taskPID;

	struct sigaction action;
	struct	timeval start,end;

 
	
void hINT (int signo)
{
 	USHORT  flagIntr[5], codRI;
	ioctl ( hARINC, LNX_PCI429_RFI_INT, &flagIntr );
	if(flagIntr[0])	
	{
		ioctl ( hARINC, LNX_PCI429_GET_INT2, &codRI );
		while(codRI)
		{
			interruptNumber++;
			ioctl ( hARINC, LNX_PCI429_GET_INT2, &codRI );
		}
	}
	
	ioctl ( hARINC, LNX_PCI429_RESET_INT, NULL); 

 	return ;
}

void main ()
{
	int 	i;

	printf("=========================================================================\n");


	hARINC=open("/dev/pci429_0",0);
	if(hARINC==-1)
	{
	   	printf("open error\n");
		return;	
	}

	//2.1. Инициализация адаптера.

	for(i=0; i<16; i++)
		buff[i] = 1;
	ioctl(hARINC,LNX_PCI429_INIT,&buff);
	printf("                              PCI429-3-%d%d\n",buff[0],buff[1]);
	printf("SI number = %d\n",buff[0]);
	printf("SO number = %d\n",buff[1]);


	//2.7.2. Чтение серийного номера адаптера.

	ioctl(hARINC,LNX_PCI429_GET_SN,&buff);
	printf("Serial # = %d\n",buff[0]);


	//2.7.1. Чтение параметров адаптера.

	ioctl(hARINC,LNX_PCI429_GET_PARAM,&buff);
	printf("PLX  = 0x%x\n",buff[0]);
	printf("port = 0x%x\n",buff[1]);
	printf("IRQ  = 0x%x\n",buff[2]);


	
	action.sa_handler = hINT;
	action.sa_flags = 0;
	sigaction(SIGUSR1, &action, NULL);
	taskPID = getpid();
	ioctl(hARINC,LNX_PCI429_INIT_INT,&taskPID);



	//2.5.2 Файловый прием (п.3.2.2.ИП).
	//2.5.2.1.Пуск приема 

	buff[0] = SI_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff[1]	= SI_ARRAY_NUMBER;	//номер массива (1 или 2)
	buff[2]	= 0xfff;		//ап, при поступлении которого формируется 
					//прерывание (0..0xff) или иной код , если 
					//прерывание не используется
	buff[3]	= 0xfff;		//адрес параметра, при поступлении которого 
					//прием по каналу останавливается (0..0xff) 
					//или иной код , если останов не требуется
	ioctl ( hARINC, LNX_PCI429_SI_F_PUSK, &buff );
	printf("LNX_PCI429_SI_F_PUSK:  0x%x\n",buff[0]);


	//2.4.2. Циклическая выдача (п.3.1.2. ИП).
	//2.4.2.1.Пуск выдачи 
	
	buff2421.bufInput.ChanNumber = SO_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff2421.bufInput.ArrayDim = 256;	//размерность массива параметров (1..256);
	buff2421.bufInput.Period = 256;		//переменная, определяющая период выдачи массива . 
	buff2421.bufInput.InterrMask = 1;	//=0(1) без(с) прерывания  по концу выдачи массива
	
	for(i=0; i<256;i++)
		buff2421.bufInput.param[i] = 0x80000f00+((255-i)<<16)+
			(SO_CHANNEL_NUMBER<<12)+i;	//массив выходных параметров
	ioctl ( hARINC, LNX_PCI429_SO_C_PUSK, &buff2421 );
	printf("LNX_PCI429_SO_C_PUSK:  0x%x\n",buff2421.bufOutput);

	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<5);

	

	//2.4.1.3.Опрос состояния выходного канала.

	buff[0] = SO_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SO_STATE,&buff );
	printf("LNX_PCI429_SO_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SO_STATE:#param 0x%x\n",buff[1]);

	
	//2.5.1.3.Опрос состояния входного канала.
	
	buff[0] = SI_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_STATE,&buff );	
	printf("LNX_PCI429_SI_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SI_STATE:#param 0x%x\n",buff[1]);


	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.5.2.4.Чтение принятого слова ПК 

	buff2524.bufInput[0] = SI_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff2524.bufInput[1] = SI_ARRAY_NUMBER;	//номер массива (1 или 2)
	buff2524.bufInput[2] = PARAM_NUMBER;	//номер слова ПК во входном буфере (0..255)
	ioctl ( hARINC, LNX_PCI429_SI_PARAM, &buff2524 );	
	printf("LNX_PCI429_SI_PARAM:error 0x%x\n",buff2524.bufOutput.error);
	printf("LNX_PCI429_SI_PARAM:param 0x%08x\n",buff2524.bufOutput.Param);


	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.4.2.2.Передача параметра в канал.

	buff2422.bufInput.ChanNumber = SO_CHANNEL_NUMBER;	
	buff2422.bufInput.paramNumber = PARAM_NUMBER;	
	buff2422.bufInput.param = 0x98765432;
	ioctl ( hARINC, LNX_PCI429_SO_C_PARAM, &buff2422 );
	printf("LNX_PCI429_SO_C_PARAM: 0x%x\n",buff2422.bufOutput);


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<2);

	//2.5.2.4.Чтение принятого слова ПК 

	buff2524.bufInput[0] = SI_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff2524.bufInput[1] = SI_ARRAY_NUMBER;	//номер массива (1 или 2)
	buff2524.bufInput[2] = PARAM_NUMBER;	//номер слова ПК во входном буфере (0..255)
	ioctl ( hARINC, LNX_PCI429_SI_PARAM, &buff2524 );	
	printf("LNX_PCI429_SI_PARAM:error 0x%x\n",buff2524.bufOutput.error);
	printf("LNX_PCI429_SI_PARAM:param 0x%08x\n",buff2524.bufOutput.Param);


	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<2);

	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.4.2.3.Останов выдачи 

	buff[0] = SO_CHANNEL_NUMBER;	
	ioctl ( hARINC, LNX_PCI429_SO_STOP, &buff );	
	printf("LNX_PCI429_SO_STOP: 0x%x\n",buff[0]);

	//2.5.1.2.Останов приема 

	buff[0] = SI_CHANNEL_NUMBER;	
	ioctl ( hARINC, LNX_PCI429_SI_STOP,&buff );
	printf("LNX_PCI429_SI_STOP: 0x%x\n",buff[0]);


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<2);

	
	//2.5.1.3.Опрос состояния входного канала.
	
	buff[0] = SI_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_STATE,&buff );	
	printf("LNX_PCI429_SI_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SI_STATE:#param 0x%x\n",buff[1]);

	
	ioctl(hARINC,LNX_PCI429_STOP,NULL);
	
 	printf("interrupt number =  %d\n",interruptNumber);


 	close(hARINC);
   

}
