#include "../pci429-4.h"

void kvp(int hDevice,unsigned short int adr)
{
unsigned short int Data[2];

	Data[0] =0x2;	
	Data[1] = adr;
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,Data);
}


void kpp(int hDevice,unsigned short int adr, unsigned long int prm)
{
unsigned short int Data[4];

	Data[0] =0x3;	
	Data[1] = adr;
	Data[2] = (unsigned short)(prm&0xffff);
	Data[3] = (unsigned short)(((prm)>>16)&0xffff);
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_3,Data);

}

void kmp(int hDevice)
{
unsigned short int Data;

	Data =0x4;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kcb(int hDevice,unsigned short int msk)
{
unsigned short int Data[2];

	Data[0] =0x5;	
	Data[1] = msk;
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,Data);
}

void kct(int hDevice)
{
unsigned short int Data;
 
	Data =0x6;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpt(int hDevice,unsigned short int tmr)
{
unsigned short int Data[2];
 
	Data[0] =0x7;	
	Data[1] = tmr;
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,Data);

}

void kvm0(int hDevice)
{
unsigned short int Data;

	Data =0x8;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm1(int hDevice)
{
unsigned short int Data;
 
	Data =0x9;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm2(int hDevice)
{
unsigned short int Data;
 
	Data =0xA;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm3(int hDevice)
{
unsigned short int Data;

	Data =0xB;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm4(int hDevice)
{
unsigned short int Data;

	Data =0xC;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm5(int hDevice)
{
unsigned short int Data;

	Data =0xD;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm6(int hDevice)
{
unsigned short int Data;

	Data =0xE;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kvm7(int hDevice)
{
unsigned short int Data;

	Data =0xF;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kom(int hDevice,unsigned short int am, unsigned short int ch)

{
unsigned short int Data[3];
 

	Data[0] =0x30;	
	Data[1] = am;
	Data[2] = ch;
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}
void komp(int hDevice,unsigned short int am, unsigned short int ch)

{
unsigned short int Data[3];
 

	Data[0] =0x31;	
	Data[1] = am;
	Data[2] = ch;
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}

void kpm0(int hDevice)
{
unsigned short int Data;
 

	Data =0x38;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm1(int hDevice)
{
unsigned short int Data;
 

	Data =0x39;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm2(int hDevice)
{
unsigned short int Data;
 

	Data =0x3A;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm3(int hDevice)
{
unsigned short int Data;
 

	Data =0x3B;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm4(int hDevice)
{
unsigned short int Data;
 

	Data =0x3C;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm5(int hDevice)
{
unsigned short int Data;
 

	Data =0x3D;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm6(int hDevice)
{
unsigned short int Data;
 

	Data =0x3E;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kpm7(int hDevice)
{
unsigned short int Data;
 

	Data =0x3F;	
	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_0,&Data);

}

void kp_pfa_bkp(int hDevice,unsigned short int nc, unsigned short int ch,unsigned short int m_ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];

	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = ((m_ch&1)<<15)|(ch&0x3ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);
}

void kp_pfa_bkp2(int hDevice,unsigned short int nc, unsigned short int ch,unsigned short int m_ch, unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];
 
	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = ((m_ch&1)<<15)|(0x400)|(ch&0x1ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}

void kp_pfr_bkp(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m_ch)

{
unsigned short int Data[2];

	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = ((m_ch&1)<<15)|(0x1000)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kp_pfr_bkp2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m_ch)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = ((m_ch&1)<<15)|(0x1400)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kp_pfc_bkp(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];
 

	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = (0x1800)|(ch&0x3ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}

void kp_pfc_bkp2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];
 

	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = (0x1C00)|(ch&0x1ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}

void kp_pa_bkp1(int hDevice,unsigned short int nc,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];

	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = 0x2000;
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}

void kp_pa_bkp2(int hDevice,unsigned short int nc,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];
 
	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = 0x2400;
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_2,&Data);

}
void kp_pg(int hDevice,unsigned short int nc)

{
unsigned short int Data[2];
 
	Data[0] =((nc-1)&0xF)+0x10;	
	Data[1] = 0x3000;

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kv_vr_bkv(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 
	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kv_vr_bkv2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 
	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(0x400)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kv_vc_bkv(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];

	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(0x800)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kv_vc_bkv2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(0xC00)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}


void kv_vo_bkv(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 
	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(0x1800)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kv_vo_bkv2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(0x1C00)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}

void kv_vg(int hDevice,unsigned short int nc,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+0x20;	
	Data[1] = ((m&1)<<15)|(0x2000);

	ioctl(hDevice,LNXioctl_PCI429_4_writeKOP_1,&Data);

}
void  pfa_bkp(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m_ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m_ch&1)<<15)|(ch&0x3ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,	LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pfa_bkp2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m_ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m_ch&1)<<15)|(0x400)|(ch&0x1ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pfr_bkp(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m_ch)

{
unsigned short int Data[3];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m_ch&1)<<15)|(0x1000)|(ch&0x3ff);
	Data[2] = 0;

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pfr_bkp2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m_ch)

{
unsigned short int Data[3];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m_ch&1)<<15)|(0x1400)|(ch&0x1ff);
	Data[2] = 0;

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pfc_bkp(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];
 
	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = (0x1800)|(ch&0x3ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pfc_bkp2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = (0x1C00)|(ch&0x1ff);
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pa_bkp1(int hDevice,unsigned short int nc,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];
 
	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = 0x2000;
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void  pa_bkp2(int hDevice,unsigned short int nc,unsigned short int ap,unsigned short int m_ap)

{
unsigned short int Data[3];

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = 0x2400;
	Data[2] = (unsigned short)(((m_ap&1)<<13)|(ap&0xff));

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}
void  pg(int hDevice,unsigned short int nc)

{
unsigned short int Data[3];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = 0x3000;
	Data[2] = 0;

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_I,Data);

}

void vr_bkv(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}

void vr_bkv2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(0x400)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}

void vc_bkv(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(0x800)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}

void vc_bkv2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(0xC00)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}


void vo_bkv(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(0x1800)|(ch&0x3ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}

void vo_bkv2(int hDevice,unsigned short int nc,unsigned short int ch,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(0x1C00)|(ch&0x1ff);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}

void vg(int hDevice,unsigned short int nc,unsigned short int m)

{
unsigned short int Data[2];
 

	Data[0] =((nc-1)&0xF)+1;	
	Data[1] = ((m&1)<<15)|(0x2000);

	ioctl(hDevice,LNXioctl_PCI429_4_writeBU_O,Data);

}


void tab_vg_word(unsigned short int *Data,unsigned short int ss,unsigned short int adr,unsigned short int km,unsigned short int nl)

{

	Data[ss+2] =((km&0x1)<<14)+((nl&0x1)<<13)+(adr&0x1fff);
}

void tab_vg_pause(unsigned short int *Data,unsigned short int ss,unsigned short int ch_p)

{

	Data[ss+2] =(ch_p&0x1FF)+0x8000;
;
}
void tab_pg_word(unsigned short int *Data,unsigned short int ap,unsigned short int adr,unsigned short int m)

{

	Data[ap+2] =((m&0x1)<<15)+0x2000+(adr&0x1fff);
}

void tab_pg_pause(unsigned short int *Data,unsigned short int ap)

{

	Data[ap+2] = 0;
;
}



/*
gcc -c -fPIC  lib_pci429_4_LNX.c
gcc -shared -fPIC -o lib_pci429_4_LNX.so lib_pci429_4_LNX.o



gcc testDLLpci429-4.c -o testDLLpci429-4 -L. -l_pci429_4_LNX -Wl,-rpath,/home/vera/Devices/PCI429-4/ver38/libraryPCI4
 ./testDLLpci429-4
*/


/*
gcc -c lib_pci429_4_LNX.c -o lib_pci429_4_LNX.o
ar rcs lib_pci429_4_LNX.a lib_pci429_4_LNX.o

gcc -static testDLLpci429-4.c -L. -l_pci429_4_LNX -o testDLLpci429-4

 ./testDLLpci429-4
*/

