﻿
#include <signal.h>
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include "pci429-4.h"


	int  hARINC;
	short unsigned int Data[0x300], RID, numberSI, numberSO, nk, ap;
	short unsigned int codeTMR[2];

	struct sigaction action;
	struct itimerval timer;

	long int li,lo,ncikl,errors, IntNumber, IntNumberTimer;
 



   
void hINT (int signo)
{
 unsigned short int	codeRV
	,codeTMRinterrupt[2]
	,siWithInterruptNumber;


	ioctl(hARINC,LNXioctl_PCI429_4_readRV ,&codeRV);

	do
	{
		if((codeRV&0xfff)==0x840)
		{
			IntNumber++;
			siWithInterruptNumber=1;
			ioctl(hARINC,LNXioctl_PCI429_4_readFL_I ,&siWithInterruptNumber);
		}
		if((codeRV&0xfff)==0x807)
		{
			IntNumberTimer++;
		
			codeTMRinterrupt[0]=7;
			codeTMRinterrupt[1]=65000;
			ioctl(hARINC,LNXioctl_PCI429_4_writeKOP_1 ,&codeTMRinterrupt);
			
		}
		ioctl(hARINC,LNXioctl_PCI429_4_readRV ,&codeRV);
	
	}while(codeRV&0x800);

}



void timerNonstop (int signo)

{
	short unsigned int	NKtemp;

	ncikl++;
	for( nk=0;nk<numberSI;nk++)    	
		for( ap=0;ap<256;ap++)
		{ 
			Data[0] = 0x4000+(nk)*0x400+ap*2;
			ioctl(hARINC,LNXioctl_PCI429_4_readPK ,&Data);
			li = ((Data[2])<<16)|(Data[1]);

			Data[0]++ ;
			Data[1] = 0;
			ioctl(hARINC,LNXioctl_PCI429_4_writeWord ,&Data);

				
			NKtemp = nk;
			if((RID==0x4020)&&(nk>=8)) NKtemp -= 8;
			lo = ((0x8000+(NKtemp<<8)+(0xFF&(~ap)))<<16)|((NKtemp<<12)+ap);

			if  (li!=lo)
				errors++;
		}
 	//PCI429-4 timer code
	codeTMR[0] = 0x3007;
	codeTMR[1] = 0;
	ioctl(hARINC,LNXioctl_PCI429_4_readWord ,&codeTMR);

  	printf(" \r");
 	printf("Test cycle=%ld errors=%ld Interrupt=%ld  test time = %ld ms      \r",ncikl
			,errors,IntNumber,(65000-codeTMR[1]+IntNumberTimer*65000)*5);

	
}





void timerErrorstop (int signo)

{
short unsigned int	NKtemp;
  if(errors==0)
    {
	ncikl++;
	for( nk=0;(nk<numberSI)&&(!errors);nk++)    	
		for( ap=0;ap<256;ap++)
		{ 
			Data[0] = 0x4000+(nk)*0x400+ap*2;
			ioctl(hARINC,LNXioctl_PCI429_4_readPK ,&Data);
			li = ((Data[2])<<16)|(Data[1]);

			Data[0]++ ;
			Data[1] = 0;
			ioctl(hARINC,LNXioctl_PCI429_4_writeWord ,&Data);

				
			NKtemp = nk;
			if((RID==0x4020)&&(nk>=8)) NKtemp -= 8;
			lo = ((0x8000+(NKtemp<<8)+(0xFF&(~ap)))<<16)|((NKtemp<<12)+ap);

			if  (li!=lo)
			{
				errors++;
 				printf("Test cycle=%ld SI=%d param=%2d observed value=%8lx expected value=%8lx\n",ncikl,nk,ap,li,lo);
				break;
			}
			 
		 }
 	//PCI429-4 timer code
	codeTMR[0] = 0x3007;
	codeTMR[1] = 0;
	ioctl(hARINC,LNXioctl_PCI429_4_readWord ,&codeTMR);


 	if(errors==0)
	 	printf("Test cycle =%ld  Interrupt =%ld  test time = %ld ms      \r",ncikl
				,IntNumber,(65000-codeTMR[1]+IntNumberTimer*65000)*5);
	else
		printf("\ntest time = %ld ms\n", (65000-codeTMR[1]+IntNumberTimer*65000)*5);

   }
   
}

void main ()
{unsigned int ind1, sn, snI, i;
 char msg[16]={'/','d','e','v','/','p','c','i','4','2','9','_','4'};
 int TestType, TestTypeStub;
	
	printf("\n\n=======PCI429-4 test ===========\n");
	printf("enter serial # :")	;
	scanf("%5d",&snI);
	msg[14]='\0';
      	while(getchar()!=0xa);

	ind1 = 0;
//	msg[13]='\0';
	msg[13]='0';
	do
	{
		hARINC=open(msg,0);
		msg[13]++;
		ind1++;
		if(hARINC!=-1)
		{
			ioctl(hARINC,LNXioctl_PCI429_4_getSN,&Data);
			sn = Data[0];
//	printf("sn number = %d\n",sn);	
			if(sn != snI)
				close(hARINC);

 		}
	}while ((ind1 < 8)&(sn != snI));

	if(hARINC==-1)
	{
		printf("open error \n")	;
		return;
	}

	printf("enter test type [0-nonstop / 1-error stop]:")	;
	scanf("%1d",&TestType);
      	while(getchar()!=0xa);

	printf("                [0-internal / 1-with stub]:")	;
	scanf("%1d",&TestTypeStub);
      	while(getchar()!=0xa);


	printf("\n\n  PCI429-4 parameters.\n");
	printf("  ====================\n\n");
	printf("serial number = %d\n",sn);	

	ioctl(hARINC,LNXioctl_PCI429_4_readRID ,&Data);
	RID = Data[0];
	printf("RID = 0x%x\n",RID)	;

	switch (RID)
	{
		case 0x4030:
			numberSI = 16;
			numberSO = 16;
			break;

		case 0x4020:
			numberSI = 16;
			numberSO = 8;
			break;

		case 0x4010:
			numberSI = 8;
			numberSO = 8;
			break;

		default: break;

	}
	printf("SI  number = %d\n",numberSI);
	printf("SO  number = %d\n",numberSO);


	ioctl(hARINC,LNXioctl_PCI429_4_getPRM ,&Data);
	printf("PLX address = 0x%04x\n",Data[0]);
	printf("IO address = 0x%04x\n",Data[1]);
	printf("IRQ # = 0x%x\n",Data[2]);
	printf("\n");

	//
	i = 0;
	do
	{
		ioctl(hARINC,LNXioctl_PCI429_4_getState ,&Data);
		i++;
	}while ((Data[0]!=0xbcc)&&(i<2000));

	if(Data[0]!=0xbcc)
	{
		printf("getState = %xh %xh %xh %xh %d\n",Data[0],Data[1],Data[2],Data[3],i);
		close(hARINC);
		return;

	}

	//
	Data[0] = 0x6000;
	ioctl(hARINC,LNXioctl_PCI429_4_writeRM ,&Data);



	if (TestTypeStub==0)
	{
		for(i = 0; i<numberSI; i++)
			Data[i] = 3;
		for(i = numberSI; i<16; i++)
			Data[i] = 0;
		for(i = 16; i<numberSO+16; i++)
			Data[i] = 3;
		for(i = numberSO+16; i<32; i++)
			Data[i] = 0;
		ioctl(hARINC,LNXioctl_PCI429_4_setFreq ,&Data);
	
		Data[0] = 0x89;
		ioctl(hARINC,LNXioctl_PCI429_4_setKCR ,&Data);
	}
	else
	{
		for(i = 0; i<numberSI; i++)
			Data[i] = 2;
		for(i = numberSI; i<16; i++)
			Data[i] = 0;
		for(i = 16; i<numberSO+16; i++)
			Data[i] = 2;
		for(i = numberSO+16; i<32; i++)
			Data[i] = 0;
		ioctl(hARINC,LNXioctl_PCI429_4_setFreq ,&Data);
	

		Data[0] = 0x80;
		ioctl(hARINC,LNXioctl_PCI429_4_setKCR ,&Data);
	}

	//SO channels
	for(nk=1;nk<=numberSO; nk++)
	{
		Data[0] = nk;
		Data[1] = 0x900;
		ioctl(hARINC,LNXioctl_PCI429_4_writeBU_O ,&Data);
	}

	//SI channels
	Data[0] = 1;
	Data[1] = 0x2000;
	Data[2] = 0x20ff;
	ioctl(hARINC,LNXioctl_PCI429_4_writeBU_I ,&Data);
	for(nk=2;nk<=numberSI; nk++)
	{
		Data[0] = nk;
		Data[1] = 0x1900;
		Data[2] = 0x100;
		ioctl(hARINC,LNXioctl_PCI429_4_writeBU_I ,&Data);
	}

	//output data
	Data[1] = 0x100;
	for(nk=0;nk<numberSO; nk++)
	{
		for(ap=0; ap<0x100; ap++)
		{
			Data[2+ap*2] = (nk<<12)+ap;
			Data[3+ap*2] = 0x8000+(nk<<8)+(0xFF&(~ap));
		}
		Data[0] = nk+1;
		ioctl(hARINC,LNXioctl_PCI429_4_writeBKV ,&Data);
	}

	//interrupts reset
	Data[0] = 1;
	ioctl(hARINC,LNXioctl_PCI429_4_writeRV ,&Data);

  	//memset(&action, 0, sizeof(action));

	action.sa_handler = &hINT;
	action.sa_flags = 0;
	sigaction(SIGUSR1, &action, NULL);

	Data[0] = (short unsigned int) getpid();
 	ioctl(hARINC,LNXioctl_PCI429_4_IntInit ,&Data);


   	timer.it_value.tv_sec = 0;
    	timer.it_value.tv_usec = 800000;
    	timer.it_interval.tv_sec = 0;
    	timer.it_interval.tv_usec = 800000;
 



	if(TestType==0)
	{
		printf("\n\n  Nonstop    ");
 		
		action.sa_handler = &timerNonstop;
	}
	else
	{
		printf("\n\n  Error Stop ");
 		
		action.sa_handler = &timerErrorstop;
	}

	action.sa_flags = 0;
	sigaction(SIGALRM, &action, NULL);



	if (TestTypeStub==0)
		printf("Internal Test.\n");
	else
		printf("Test With Stub.\n");
	printf("  ==========================\n\n");


	printf("Press ENTER for quit\n\n")	;


	//"WORK" mode
	Data[0] = 0x8310;
	ioctl(hARINC,LNXioctl_PCI429_4_setKCI ,&Data);

	i = 0;
	do
	{
		ioctl(hARINC,LNXioctl_PCI429_4_getState ,&Data);
		i++;
	}while ((Data[0]!=0xbce)&&(i<1000));

	if((Data[0]!=0xbce)||(Data[1]!=0x8310)||(Data[3]!=0))
	{
		printf("getState = %xh %xh %xh %xh %d\n",Data[0],Data[1],Data[2],Data[3],i);
		ioctl(hARINC,LNXioctl_PCI429_4_readRID ,&Data);
		ioctl(hARINC,LNXioctl_PCI429_4_IntRst ,&Data);
		close(hARINC);
		return;
	}

	//PCI429-4 timer start
	codeTMR[0] = 7;
	codeTMR[1] = 65000;
	ioctl(hARINC,LNXioctl_PCI429_4_writeKOP_1 ,&codeTMR);

	//system timer start
	setitimer(ITIMER_REAL, &timer, NULL);
 
  	while(getchar()!=0xa);

      							
	//system timer stop
	timer.it_value.tv_sec = 0;
	timer.it_value.tv_usec = 0;
	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 0;      
	setitimer(ITIMER_REAL, &timer, NULL);


	ioctl(hARINC,LNXioctl_PCI429_4_readRID ,&Data);
	ioctl(hARINC,LNXioctl_PCI429_4_IntRst ,&Data);
	close(hARINC);

	printf("\n\n")	;
}
/*
[home]# gcc tpsPCI429-4.c -o tpsPCI429-4
[home]# ./tpsPCI429-4
*/
