// mini2_PCI3_W2KDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mini2_PCI3_W2K.h"
#include "mini2_PCI3_W2KDlg.h"
#include "ioctlPCI3.h"
#include <winioctl.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

DWORD	Error;
HANDLE  hARINC;	
char txt1[100];
 DWORD   nOutput;

HANDLE OpenDeviceBySN(   USHORT SerialNumber, PDWORD pError );

#pragma pack( 2)

/////////////////////////////////////////////////////////////////////////////
// CMini2_PCI3_W2KDlg dialog

CMini2_PCI3_W2KDlg::CMini2_PCI3_W2KDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMini2_PCI3_W2KDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMini2_PCI3_W2KDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMini2_PCI3_W2KDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMini2_PCI3_W2KDlg)
	DDX_Control(pDX, IDC_PUSK, m_pusk);
	DDX_Control(pDX, IDC_LIST2, m_w);
	DDX_Control(pDX, IDC_LIST, m_txt);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMini2_PCI3_W2KDlg, CDialog)
	//{{AFX_MSG_MAP(CMini2_PCI3_W2KDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PUSK, OnPusk)
	ON_BN_CLICKED(IDC_READ, OnRead)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMini2_PCI3_W2KDlg message handlers

BOOL CMini2_PCI3_W2KDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMini2_PCI3_W2KDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMini2_PCI3_W2KDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMini2_PCI3_W2KDlg::OnOK() 
{
	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_STOP,
		NULL,                                                       
		0 ,                                               
		NULL,                                                    
		0,                            		
		&nOutput ,
		NULL  );

	CloseHandle(hARINC);
	
	
	CDialog::OnOK();
}

void CMini2_PCI3_W2KDlg::OnCancel() 
{
	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_STOP,
		NULL,                                                       
		0 ,                                               
		NULL,                                                    
		0,                            		
		&nOutput ,
		NULL  );

	CloseHandle(hARINC);
	
	
	CDialog::OnCancel();
}
void CMini2_PCI3_W2KDlg::OnRead() 
{
 struct {
	USHORT  ChanNumber;	//  (1..8) 
	USHORT  ArrayNumber;	//  (1  2)
	} bufInput;

 struct {
	USHORT  error;             	 // ,      
								// :   1 -   
								//    	     2 -    
								//                   0 -  
	ULONG Param[256];             	 //,            
	}bufOutput;

	bufInput.ChanNumber =1;
	bufInput.ArrayNumber = 2;


	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SI_BUFER,
		&bufInput,                                         
		4 ,                                  
		&bufOutput,                                        
		1026,                            	
		&nOutput ,
		NULL  );

 
	 for (int i=0;i<256;i++)
			m_w.DeleteString(0);
	
	for (i=0;i<256;i++)
	{
		wsprintf(txt1,"%08X ",bufOutput.Param[i]);
		m_w.AddString(txt1);
	}
}

void CMini2_PCI3_W2KDlg::OnPusk() 
{
USHORT iSN = 11628;
	
	hARINC  = OpenDeviceBySN(  iSN, &Error);

	m_txt.AddString("hARINC  = OpenDeviceBySN( 11628,...");

	wsprintf(txt1,"hARINC = 0x%X ",hARINC);
	m_txt.AddString(txt1);

			
	m_pusk.ModifyStyle(0,WS_DISABLED,0);
	m_pusk.InvalidateRect(NULL,TRUE);


//


 struct {
	UCHAR  freqSI[8];		//    
	UCHAR  freqSO[8];		//    
	} bufInputI;

 struct {
	UCHAR SI;	//,        
	UCHAR  SO;	//,           
	} bufOutputI;

		for(int i=0; i<8; i++)
		{
			bufInputI.freqSI[i] = 1;
			bufInputI.freqSO[i] = 1;
		}

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_INIT,
		&bufInputI,                                         
		16 ,                                  
		&bufOutputI,                                       
		2,                            	
		&nOutput ,
		NULL  );

		wsprintf(txt1,"SI = %X,SO = %X ",bufOutputI.SI,bufOutputI.SO);
		m_txt.AddString(txt1);

//4.5.2   (.3.2.2.).
//4.5.2.1.  

 struct {
		USHORT  ChanNumber;	//  (1..8) 
		USHORT  ArrayNumber;	//  (1  2)
		USHORT  InterrParamAddr;	// ,      (0..0xff)    ,    
		USHORT  StopParamAddr;	// ,        (0..0xff)    ,    
		} bufInputP;

 USHORT bufOutput; 

	bufInputP.ChanNumber = 1;
	bufInputP.ArrayNumber = 2;
	bufInputP.InterrParamAddr =0xfff;
	bufInputP.StopParamAddr =0xfff;

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SI_F_PUSK,
		&bufInputP,                                         
		8 ,                                  
		&bufOutput,                                        
		2,                            	
		&nOutput ,
		NULL  );


	wsprintf(txt1,"DRV2K_PCI429_3_SI_F_PUSK = %X ",bufOutput);
	m_txt.AddString(txt1);


	// 4.4.2.1.  (.3.1.2. ).
 struct {
	USHORT  ChanNumber;	//  (1..8) 
	USHORT  ArrayDim;	//   (1..256);
	USHORT  Period;	//,     .     ArrayDim  256.      Period*,            360, 720, 2880     100, 50, 12.5  .
	USHORT  InterrMask;	//=0(1)   ( )    
	ULONG     param [5];	//  
	} bufInputF;

DWORD nbufInputSizeF = sizeof (bufInputF);

	bufInputF.ChanNumber = 1;
	bufInputF.ArrayDim = 5;
	bufInputF.Period = 256;
	bufInputF.InterrMask = 0;

	for(int ii=0; ii<5; ii++)
		bufInputF.param[ii] = 0x8000f000 +(((ULONG)ii)<<16) + ii;

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SO_C_PUSK,
		&bufInputF,                                          
		nbufInputSizeF ,                                   
		&bufOutput,                                       
		2,                            	
		&nOutput ,
		NULL  );

	wsprintf(txt1,"DRV2K_PCI429_3_SO_C_PUSK = %X ",bufOutput);
	m_txt.AddString(txt1);

}

	

