// mini3_PCI3_W2KDlg.cpp : implementation file
//

#include "stdafx.h"
#include "mini3_PCI3_W2K.h"
#include "mini3_PCI3_W2KDlg.h"
#include <winioctl.h>
#include "ioctlPCI3.h"

#define CHANNUMBER 3


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

DWORD	Error;
HANDLE  hARINC;	
char txt1[100];
 DWORD   nOutput;

HANDLE  hEvent, hThread;	//   
DWORD dwThreadID;	//,      
DWORD WINAPI   f_INT(LPVOID);    //       

USHORT ch=0;

HANDLE OpenDeviceByIndex(  DWORD Index, PDWORD pError );

#pragma pack( 2)

/////////////////////////////////////////////////////////////////////////////
// CMini3_PCI3_W2KDlg dialog

CMini3_PCI3_W2KDlg::CMini3_PCI3_W2KDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMini3_PCI3_W2KDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMini3_PCI3_W2KDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMini3_PCI3_W2KDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMini3_PCI3_W2KDlg)
	DDX_Control(pDX, IDC_PUSK, m_pusk);
	DDX_Control(pDX, IDC_LIST2, m_w);
	DDX_Control(pDX, IDC_LIST, m_txt);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMini3_PCI3_W2KDlg, CDialog)
	//{{AFX_MSG_MAP(CMini3_PCI3_W2KDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_PUSK, OnPusk)
	ON_BN_CLICKED(IDC_READ, OnRead)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMini3_PCI3_W2KDlg message handlers

BOOL CMini3_PCI3_W2KDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CMini3_PCI3_W2KDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CMini3_PCI3_W2KDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMini3_PCI3_W2KDlg::OnOK() 
{
	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_STOP,
		NULL,                                                       
		0 ,                                               
		NULL,                                                    
		0,                            		
		&nOutput ,
		NULL  );

	DeviceIoControl ( hARINC , DRV2K_PCI429_3_STOP_INT, NULL, 0 ,  NULL,  0, &nOutput , NULL  ); 

	CloseHandle(hARINC);
	
	
	CDialog::OnOK();
}

void CMini3_PCI3_W2KDlg::OnCancel() 
{
	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_STOP,
		NULL,                                                       
		0 ,                                               
		NULL,                                                    
		0,                            		
		&nOutput ,
		NULL  );

	DeviceIoControl ( hARINC , DRV2K_PCI429_3_STOP_INT, NULL, 0 ,  NULL,  0, &nOutput , NULL  ); 

	CloseHandle(hARINC);
	
	
	CDialog::OnCancel();
}

void CMini3_PCI3_W2KDlg::OnRead() 
{
 struct {
	USHORT  ChanNumber;	//  (1..8) 
	USHORT  ArrayNumber;	//  (1  2)
	} bufInput;

 struct {
	USHORT  error;             	 // ,      
								// :   1 -   
								//    	     2 -    
								//                   0 -  
	ULONG Param[256];             	 //,            
	}bufOutput;

	bufInput.ChanNumber =CHANNUMBER;
	bufInput.ArrayNumber = 2;


	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SI_BUFER,
		&bufInput,                                         
		4 ,                                  
		&bufOutput,                                        
		1026,                            	
		&nOutput ,
		NULL  );

 
	 for (int i=0;i<256;i++)
			m_w.DeleteString(0);
	
	for (i=0;i<256;i++)
	{
		wsprintf(txt1,"%08X ",bufOutput.Param[i]);
		m_w.AddString(txt1);
	}
	
}

void CMini3_PCI3_W2KDlg::OnPusk() 
{
			
	m_pusk.ModifyStyle(0,WS_DISABLED,0);
	m_pusk.InvalidateRect(NULL,TRUE);

	hARINC  = OpenDeviceByIndex( 0, &Error);

	m_txt.AddString("hARINC  = OpenDeviceByIndex( 0,...");


	wsprintf(txt1,"hARINC = 0x%X ",hARINC);
	m_txt.AddString(txt1);


	hEvent=CreateEvent(NULL, TRUE,FALSE, "SignalEvent1");   

	wsprintf(txt1,"hEvent = 0x%X ",hEvent);
	m_txt.AddString(txt1);
	wsprintf(txt1,"sizeof = 0x%X ",sizeof(hEvent));
	m_txt.AddString(txt1);

	DeviceIoControl ( hARINC , DRV2K_PCI429_3_INIT_INT, &hEvent, 4 ,  NULL,  0, &nOutput , NULL  );

	hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE) f_INT, NULL, 0, &dwThreadID);
//
	wsprintf(txt1,"hThread = 0x%X ",hThread);
	m_txt.AddString(txt1);


 struct {
	UCHAR  freqSI[8];		//    
	UCHAR  freqSO[8];		//    
	} bufInputI;

 struct {
	UCHAR SI;	//,        
	UCHAR  SO;	//,           
	} bufOutputI;

		for(int i=0; i<8; i++)
		{
			bufInputI.freqSI[i] = 2;
			bufInputI.freqSO[i] = 2;
		}

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_INIT,
		&bufInputI,                                         
		16 ,                                  
		&bufOutputI,                                       
		2,                            	
		&nOutput ,
		NULL  );

		wsprintf(txt1,"SI = %X,SO = %X ",bufOutputI.SI,bufOutputI.SO);
		m_txt.AddString(txt1);

//4.5.2   (.3.2.2.).
//4.5.2.1.  

 struct {
		USHORT  ChanNumber;	//  (1..8) 
		USHORT  ArrayNumber;	//  (1  2)
		USHORT  InterrParamAddr;	// ,      (0..0xff)    ,    
		USHORT  StopParamAddr;	// ,        (0..0xff)    ,    
		} bufInputP;

 USHORT bufOutput; 

	bufInputP.ChanNumber = CHANNUMBER;
	bufInputP.ArrayNumber = 2;
	bufInputP.InterrParamAddr =0xfff;
	bufInputP.StopParamAddr =0xfff;

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SI_F_PUSK,
		&bufInputP,                                         
		8 ,                                  
		&bufOutput,                                        
		2,                            	
		&nOutput ,
		NULL  );


	wsprintf(txt1,"DRV2K_PCI429_3_SI_F_PUSK = %X ",bufOutput);
	m_txt.AddString(txt1);

//	4.4.3.      (.3.1.3. ).
//4.4.3.1.  ,     .
	
 struct {
	USHORT  ArrayDim;	// ,      (1..8);
	USHORT  chanalNumber [3];	//  ,     
	 } bufInputC;

DWORD nbufInputSizeC = sizeof (bufInputC);

	bufInputC.ArrayDim=3;
	bufInputC.chanalNumber[0]=2;
	bufInputC.chanalNumber[1]=1;
	bufInputC.chanalNumber[2]=CHANNUMBER;
	

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SO_G_CHANAL,
		&bufInputC,                                         
		nbufInputSizeC ,                                 
		&bufOutput,                                       
		2,                            	
		&nOutput ,
		NULL  );

	wsprintf(txt1,"DRV2K_PCI429_3_SO_G_CHANAL = %X ",bufOutput);
	m_txt.AddString(txt1);

//
//4.4.3.2.     


 struct {
	USHORT  ArrayDim;	//    1  (256*N-1),  N- ,      ;
	ULONG     param [767];	//  
	} bufInputB;


DWORD nbufInputSizeB = sizeof (bufInputB);	//   (  ).

	bufInputB.ArrayDim = 767;
	for(int ii=0; ii<767; ii++)
		bufInputB.param[ii] = 0x80000000+ii+(ii<<16);

	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SO_G_PARAM_B,
		&bufInputB,                                         
		nbufInputSizeB ,                                   
		&bufOutput,                                       
		2,                            	
		&nOutput ,
		NULL  );


	wsprintf(txt1,"DRV2K_PCI429_3_SO_G_PARAM_B = %X ",bufOutput);
	m_txt.AddString(txt1);
//
//4.4.3.4.  

 struct {
	USHORT  ChanNumber;	//  (1..8) 
	USHORT  ArrayDim;	//    (1..256);
	USHORT  Period;	//,     .     ArrayDim  256.      Period*,            360, 720, 2880     100, 50, 12.5  .
	USHORT  InterrMask;	//=0(1)   ( )      
	USHORT  param [5];	//      .      0  256*N-2.
	} bufInput1;

DWORD nbufInputSize1 = sizeof (bufInput1);

	bufInput1.ChanNumber=CHANNUMBER;
	bufInput1.ArrayDim=5;
	bufInput1.Period=250;
	bufInput1.InterrMask=1;

	for( ii=0; ii<5; ii++)
		bufInput1.param[ii] =  ii*16;
/**/
	DeviceIoControl (
		hARINC ,
		DRV2K_PCI429_3_SO_G_PUSK,
		&bufInput1,                                        
		nbufInputSize1 ,                                
		&bufOutput,                                  
		2,                           
		&nOutput ,
		NULL  );


	wsprintf(txt1,"DRV2K_PCI429_3_SO_G_PUSK = %X ",bufOutput);
	m_txt.AddString(txt1);

	do{}while (ch<10);

	wsprintf(txt1,"   = 10 ");
	m_txt.AddString(txt1);

  struct {
	UCHAR  SIstate ;	 //,     :            //0 -  ,                                                                 //1 -   ,                                                                   //(-1) -    .
	UCHAR  pkNumber;              	//,        
	}bufOutput2;
	 USHORT  ChanNumber = CHANNUMBER;


	DeviceIoControl (
			hARINC ,
			DRV2K_PCI429_3_SI_STATE,
			&ChanNumber,                                 
			2 ,                                      	 
			&bufOutput2,                                       
			2,                            	
			&nOutput ,
			NULL  );
				
	wsprintf(txt1,"SI: SIstate= %X pkNumber= %X ",bufOutput2.SIstate,bufOutput2.pkNumber );
	m_txt.AddString(txt1);




}

DWORD WINAPI   f_INT(LPVOID)
{
	 struct {
		USHORT  Chan;	// 1/0 /   () 
		USHORT  DI1;	// 1/0 /   1
		USHORT  DI2;	// 1/0 /   2
		USHORT  DI3;	// 1/0 /   3
		USHORT  DI4;	// 1/0 /   4
		 } bufOutput;

	 USHORT bufOutput1;  
	 DWORD	nOutput;
	 USHORT  ChanNumber = CHANNUMBER;
	 
	for(;;)
	{
		WaitForSingleObject(hEvent, INFINITE);
		 ResetEvent(hEvent);  

		 DeviceIoControl ( hARINC ,DRV2K_PCI429_3_RFI_INT,  NULL, 0, &bufOutput, 10, &nOutput , NULL  );

		 if(bufOutput.Chan)

		 {
			  DeviceIoControl ( hARINC ,DRV2K_PCI429_3_GET_INT2, NULL, 0, &bufOutput1, 2, &nOutput , NULL  ); 

			  if(bufOutput1&0x400) ch++;

			  if(ch==10)
			  {
				  DeviceIoControl (
						hARINC ,
						DRV2K_PCI429_3_SO_STOP,
						&ChanNumber,                                             
						2 ,                                       
						&bufOutput1,                                        
						2,                            	
						&nOutput ,
						NULL  );



			  }
/**/
		 }
		 DeviceIoControl ( hARINC ,DRV2K_PCI429_3_RESET_INT, NULL, 0,NULL, 0, &nOutput , NULL  );  
	}
}