﻿#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdio.h>
#include <linux/types.h>

//#include <signal.h>
//#include <sys/time.h>
#include "pex429LNX.h"
#include "pex429LNX.h"
#include "pex429LNXmacro.h"


	int  hARINC;
	unsigned short int Data[32768];


void main ()
{
	int 	rid, i1, errorNumber = 0;
	long int outputParam,receivedParam;


	hARINC=open("/dev/pex429_0",0);
	if(hARINC==-1)
	{
	   	printf("open error\n");
		return;	
	}

	//3.2.4. Определение серийного номера.

	ioctl(hARINC,IOCTL_GET_SER_NUMBER ,Data);
	printf("=========================================================================\n");
	printf("                              PEX429-1 serial # = %d\n",Data[0x1850]);


	//3.1. Взаимодействие драйвера с пользовательской программой.
	//функция  первоначальной настройки параметров адаптера

	ioctl(hARINC,IOCTL_RJ ,Data);
	GET_RJ_M(Data,rid);
	printf("RID code = 0x%x\n",rid);
	
	
	//Подготовка кода регистра режимов в буфере обмена.
	
	SET_RM(Data,0x0f0a);
	
	//Подготовка кода регистра режимов в буфере обмена.

	SET_RF_SI_N(Data,2,2,2,2,2,2,2,2);
	SET_RF_SO_N(Data,2,2,2,2,2,2,2,2);

 
	//3.3.2.4. Инициализация адаптера.
	
	INIT_ARINC(hARINC,Data);
	

	//3.3.2.7. Задание последовательности выдачи параметров 
	//выходным каналом (файловый режим).
	
	SET_SO_TAB_Z(Data,1,1,i1);
	SET_SO_DAN_RC_F(hARINC,Data,1,1,0,1,256);
	
	
	//3.3.2.8. Задание последовательности приема параметров входным каналом.
	
	SET_SI_TAB_Z(Data,1,1,i1);
	SET_SI_TAB(hARINC,Data,1,1);
	
	
	//3.3.2.11. Запись параметра .

	for (i1=1;i1<=256;i1++)
	{
		outputParam=0xffff0000+i1-1;
		WRITE_PRM(hARINC,Data,1,1,i1,outputParam);
	}


	//3.3.2.9. Пуск канала/ установка задания в канале .

	PUSK_SI(hARINC,Data,1,1,1,0);
	PUSK_SO(hARINC,Data,1,1,1,0);
	
	printf("Press ENTER  \n")	;
     	while(getchar()!=0xa);
		
	
	//3.3.2.12. Чтение параметра входного канала ПК.

	for(i1=0;i1<=255;i1++)
	{
		READ_PRM_SS(hARINC,Data,1,1,i1,receivedParam);
		outputParam=0x7fff0000+i1;
		if(receivedParam!=outputParam)
		{
			printf("parameter #%3d: expected=0x%08lx  received=0x%08lx\n",i1,outputParam,receivedParam);
			errorNumber++;
		}
	}  
	

	printf("errors number = %3d\n",errorNumber);
	

	//3.3.2.10. Останов канала .

	 STOP_SO(hARINC,Data,1);
	 STOP_SI(hARINC,Data,1);


	//3.3.2.5.Останов адаптера.
	
	ARINC_STOP(hARINC,Data);


	//*********************

  	close(hARINC);
   

}
