﻿#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include "pex429LNX.h"


void  Set_Rm(unsigned short int *Data,int cod )

{
	Data[0x1100]=(unsigned short)cod;
	
}

void  Set_Rm_Bits(unsigned short int *Data,int  k4, int  k3, int  k2, int  k1,int m4, int m3, int m2, int m1, int s , int t ,int e ,int m ,int r  )

{
	Data[0x1100]=((k4<<15)|(k3<<14)|(k2<<13)|(k1<<12)|\
	(m4<<11)|(m3<<10)|(m2<<9)|(m1<<8)|(s<<7)|\
	(t<<3)|(e<<2)|(m<<1)|(r));
}


void  Set_Rm_Bit_R(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|1);

}
void  Set_Rm_Bit_M(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|2);

}
void  Set_Rm_Bit_E(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|4);

}
void  Set_Rm_Bit_T(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|8);

}
void  Set_Rm_Bit_S(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|128);

}
void  Clr_Rm_Bit_R(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfffe);

}
void  Clr_Rm_Bit_M(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfffd);

}
void  Clr_Rm_Bit_E(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfffb);

}
void  Clr_Rm_Bit_T(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfff7);

}
void  Clr_Rm_Bit_S(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xff7f);

}
void  Set_Rm_Bit_M1(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|256);

}
void  Set_Rm_Bit_M2(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|512);

}
void  Set_Rm_Bit_M3(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|1024);

}
void  Set_Rm_Bit_M4(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|2048);

}
void  Clr_Rm_Bit_M1(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfeff);

}
void  Clr_Rm_Bit_M2(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfdff);

}
void  Clr_Rm_Bit_M3(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xfbff);

}
void  Clr_Rm_Bit_M4(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xf7ff);

}
void  Set_Rm_Bit_K1(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|4096 );

}
void  Set_Rm_Bit_K2(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|8192 );

}
void  Set_Rm_Bit_K3(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|16384 );

}
void  Set_Rm_Bit_K4(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]|32768 );

}
void  Clr_Rm_Bit_K1(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xefff);

}
void  Clr_Rm_Bit_K2(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xdfff);

}
void  Clr_Rm_Bit_K3(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0xbfff);

}
void  Clr_Rm_Bit_K4(unsigned short int *Data )
{
	Data[0x1100]=(unsigned short)(Data[0x1100]&0x7fff);

}

void  Write_Rm( int hARINC,unsigned short int *Data )
{
	ioctl(hARINC,IOCTL_SET_RM,Data);
}


void   Get_Rm(unsigned short int *Data,int *ii )
{
	*ii=Data[0x1100];
}
//
void  Get_Sn( int hARINC,unsigned short int *Data ,int *ii)
{
		ioctl(hARINC,IOCTL_GET_SER_NUMBER,Data);
		*ii=Data[0x1850];
}

//
void  Get_Rj( int hARINC,unsigned short int *Data ,int *ii)
{
		ioctl(hARINC,IOCTL_GET_RJ,Data);
		*ii=Data[0x1101];
}



void  Get_Rj_M(unsigned short int *Data,int *ii)
{
		*ii=Data[0x1101];
}
//
void Get_Rd( int hARINC,unsigned short int *Data ,int *ii)
	{
		ioctl(hARINC,IOCTL_GET_RD,Data);
		*ii=Data[0x1105];
    }

void Set_Rd( int hARINC,unsigned short int *Data ,int ii)
	{
		ii=Data[0x1105];
		ioctl(hARINC,IOCTL_SET_RD,Data);
    }
					

//
void Set_Ra( int hARINC,unsigned short int *Data ,int ii)
	{
		ii=Data[0x1105];
		ioctl(hARINC,IOCTL_SET_RA,Data);
	}

//		
// 
void Read_Ra_Ch( int hARINC,unsigned short int *Data ,int adr,int ch)
{
   		Data[0x1108]=adr;
		Data[0x1109]=ch;
		ioctl(hARINC,IOCTL_READ_MEM,Data);
}



// 
void Write_Ra_Ch( int hARINC,unsigned short int *Data ,int adr,int ch)
{
   		Data[0x110a]=adr;
		Data[0x110b]=ch;
		ioctl(hARINC,IOCTL_WRITE_MEM,Data);
}

//  
void Get_Rc_Si_M( int hARINC,unsigned short int *Data ,int nc,int *ii)
	{
		Data[0x1108]=0x1f+nc;
		Data[0x1109]=1;
		ioctl(hARINC,IOCTL_READ_MEM,Data);
		*ii=Data[0x1f+nc];
   }

//  
void Get_Rc_So_M( int hARINC,unsigned short int *Data ,int nc,int *ii)
	{
		Data[0x1108]=0x27+nc;
		Data[0x1109]=1;
		ioctl(hARINC,IOCTL_READ_MEM,Data);
		*ii=Data[0x27+nc];
	}

//		
//  
void Get_Rs_Si_M( int hARINC,unsigned short int *Data ,int nc,int *ii)
	{
		Data[0x1108]=0xf+nc;
		Data[0x1109]=1;
		ioctl(hARINC,IOCTL_READ_MEM,Data);
		*ii=Data[0xf+nc];
	}

//   
void Get_Rs_So_M( int hARINC,unsigned short int *Data ,int nc,int *ii)
	{
		Data[0x1108]=0x17+nc;
		Data[0x1109]=1;
		ioctl(hARINC,IOCTL_READ_MEM,Data);
		*ii=Data[0x17+nc];

	}




//		
//  
void    Set_Rf_Si(unsigned short int *Data,int i1,int i2,int i3,int i4,
		int i5,int i6,int i7,int i8,int o1,int o2,int o3,int o4,int o5,int o6,int o7,int o8)
{
  	Data[0]=i1|(o1<<2);
  Data[1]=i2|(o2<<2); Data[2]=i3|(o3<<2); Data[3]=i4|(o4<<2);
  Data[4]=i5|(o5<<2); Data[5]=i6|(o6<<2); Data[6]=i7|(o7<<2); Data[7]=i8|(o8<<2);
}

//  
void   Set_Rf_So(unsigned short int *Data,int i1,int i2,int i3,int i4,
		int i5,int i6,int i7,int i8,int o1,int o2,int o3,int o4,int o5,int o6,int o7,int o8)
{
  Data[8]=i1|(o1<<2);
  Data[9]=i2|(o2<<2); Data[10]=i3|(o3<<2); Data[11]=i4|(o4<<2);
  Data[12]=i5|(o5<<2); Data[13]=i6|(o6<<2); Data[14]=i7|(o7<<2); Data[15]=i8|(o8<<2);
}


void    Set_Rf_Si_N(unsigned short int *Data,int i1,int i2,int i3,int i4,
		int i5,int i6,int i7,int i8)
{
  	Data[0]=i1;
  Data[1]=i2; Data[2]=i3; Data[3]=i4;
  Data[4]=i5; Data[5]=i6; Data[6]=i7; Data[7]=i8;
}
 
// 
void   Set_Rf_So_N(unsigned short int *Data,int i1,int i2,int i3,int i4,
		int i5,int i6,int i7,int i8)
{
  Data[8]=i1;
  Data[9]=i2; Data[10]=i3; Data[11]=i4;
  Data[12]=i5; Data[13]=i6; Data[14]=i7; Data[15]=i8;
}


//
//
void    Get_Rf_Si(unsigned short int *Data,int *i1,int *i2,int *i3,int *i4,
		int *i5,int *i6,int *i7,int *i8,int *o1,int *o2,int *o3,int *o4,int *o5,int *o6,int *o7,int *o8)
{
  *i1=Data[0]&3; *o1=Data[0]>>2&1;
  *i2=Data[1]&3; *o2=Data[1]>>2&1; *i3=Data[2]&3; *o3=Data[2]>>2&1; *i4=Data[3]&3; *o4=Data[3]>>2&1;
  *i5=Data[4]&3; *o5=Data[4]>>2&1; *i6=Data[5]&3; *o6=Data[5]>>2&1;
  *i7=Data[6]&3; *o7=Data[6]>>2&1; *i8=Data[7]&3; *o8=Data[7]>>2&1;
}

//
void    Get_Rf_So(unsigned short int *Data,int *i1,int *i2,int *i3,int *i4,
		int *i5,int *i6,int *i7,int *i8,int *o1,int *o2,int *o3,int *o4,int *o5,int *o6,int *o7,int *o8)
{
  *i1=Data[8]&3; *o1=Data[8]>>2&1;
  *i2=Data[9]&3; *o2=Data[9]>>2&1; *i3=Data[10]&3; *o3=Data[10]>>2&1; *i4=Data[11]&3; *o4=Data[11]>>2&1;
  *i5=Data[12]&3; *o5=Data[12]>>2&1; *i6=Data[13]&3; *o6=Data[13]>>2&1;
  *i7=Data[14]&3; *o7=Data[14]>>2&1; *i8=Data[15]&3; *o8=Data[15]>>2&1;
}


//
void  Set_So_Glbl(unsigned short int *Data,int i1,int i2,int i3,int i4,
								int i5,int i6,int i7,int i8)
{
   Data[0x1010]=i1&1;
   Data[0x1011]=i2&1;Data[0x1012]=i3&1;Data[0x1013]=i4&1;Data[0x1014]=i5&1;
   Data[0x1015]=i6&1;Data[0x1016]=i7&1;Data[0x1017]=i8&1;
}


//
void  Get_So_Glbl(unsigned short int *Data,int nc,int *i)
{
   *i=Data[0x100f+nc];
}

//
void  Init_Arinc( int hARINC,unsigned short int *Data)
{
   	ioctl(hARINC,IOCTL_INIT,Data);
}


//
void  Arinc_Stop( int hARINC,unsigned short int *Data)
{
	ioctl(hARINC,IOCTL_STOP,Data);
}

//
void  Write_Prm_G( int hARINC,unsigned short int *Data ,int np,long int li)
{
    		Data[0x5001+(np-1)*2]=(unsigned short)(((li)>>16)&0xffff);
		Data[0x5000+(np-1)*2]=(unsigned short)(li&0xffff); Data[0x1110]=(unsigned short)(0x5000+(np-1)*2);
		ioctl(hARINC,IOCTL_WRITE_PRM_G,Data);
}



//
void  Write_Prm_F( int hARINC,unsigned short int *Data ,int nc,int nb, int np,long int li)
{
		Data[0x5001+nb*0x2000+Data[0x1018+(nc-1)]+(np-1)*2]=(unsigned short)(((li)>>16)&0xffff);
		Data[0x5000+nb*0x2000+Data[0x1018+(nc-1)]+(np-1)*2]=(unsigned short)(li&0xffff);
		Data[0x1110]=(unsigned short)(0x5000+nb*0x2000+Data[0x1018+(nc-1)]+(np-1)*2);
		ioctl(hARINC,IOCTL_WRITE_PRM_G,Data);
}




//
void  Write_Prm( int hARINC,unsigned short int *Data ,int nc,int nb,int np,long int li)
{
		Data[0x5001+nb*0x2000+Data[0x1018+(nc-1)]+(np-1)*2]=(unsigned short)(((li)>>16)&0xffff);
		Data[0x5000+nb*0x2000+Data[0x1018+(nc-1)]+(np-1)*2]=(unsigned short)(li&0xffff);
		Data[0x1110]=(unsigned short)(0x5000+nb*0x2000+Data[0x1018+(nc-1)]+(np-1)*2);
		ioctl(hARINC,IOCTL_DAN_SO,Data);
}




//
void  Read_Prm_Bt( int hARINC,unsigned short int *Data ,int nc,int nb,int np,long int *li)
{
   		Data[0x1110]=(unsigned short)(0x4000+nb*0x2000+(nc-1)*0x200+(np)*2);
		ioctl(hARINC,IOCTL_READ_PRM_BT,Data);
		*li=((Data[0x4001+nb*0x2000+(nc-1)*0x200+(np)*2]&0xffff)<<16)|
   			(Data[0x4000+nb*0x2000+(nc-1)*0x200+(np)*2]&0xffff);
}





//
void  Read_Prm_Ss( int hARINC,unsigned short int *Data ,int nc,int nb,int np,long int *li)
{
   		Data[0x1110]=(unsigned short)(0x4000+nb*0x2000+(nc-1)*0x200+(np)*2);
   		Data[0x110c]=(unsigned short)nc;
		ioctl(hARINC,IOCTL_READ_PRM_SS,Data);
		*li=((Data[0x4001+nb*0x2000+(nc-1)*0x200+(np)*2]&0xffff)<<16)|
   			(Data[0x4000+nb*0x2000+(nc-1)*0x200+(np)*2]&0xffff);
}


//
void  Read_Prm( int hARINC,unsigned short int *Data ,int nc,int nb,int np,long int *li)
{
   		Data[0x1110]=(unsigned short)(0x4000+nb*0x2000+(nc-1)*0x200+(np)*2);
    		Data[0x110c]=(unsigned short)nc;
		ioctl(hARINC,IOCTL_DAN_SI,Data);
		*li=((Data[0x4001+nb*0x2000+(nc-1)*0x200+(np)*2]&0xffff)<<16)|
   			(Data[0x4000+nb*0x2000+(nc-1)*0x200+(np)*2]&0xffff);
}


// 
void  Read_Prm_Z( int hARINC,unsigned short int *Data ,int nc,int nb,int np)
{
		Data[0x1110]=(unsigned short)(0x4000+nb*0x2000+(nc-1)*0x200+(np)*2);
		ioctl(hARINC,IOCTL_READ_Z,Data);
}


// 
void Set_Do( int hARINC,unsigned short int *Data ,int ii)
{
    		Data[0x1106]=ii;
		ioctl(hARINC,IOCTL_SET_DO,Data);
}



void Get_Di( int hARINC,unsigned short int *Data ,int *ii)
{
 		ioctl(hARINC,IOCTL_GET_DI,Data);
		*ii=Data[0x1107];
}




//
void Write_Ri( int hARINC,unsigned short int *Data )
{
		ioctl(hARINC,IOCTL_SET_RI,Data);
}



//
void Read_Ri( int hARINC,unsigned short int *Data ,int *i16,int *i15,int *i14,
	int *i13,int *i12,int *i11,int *i10,int *i9,int *i8,int *i7,int *i6,int *i5,int *i4,int *i3,int *i2,int *i1)
{
		ioctl(hARINC,IOCTL_GET_RI,Data);
   		*i16=Data[0x1104]>>15&1; *i15=Data[0x1104]>>14&1; *i14=Data[0x1104]>>13&1;
		*i13=Data[0x1104]>>12&1; *i12=Data[0x1104]>>11&1; *i11=Data[0x1104]>>10&1;
		*i10=Data[0x1104]>>9&1; *i9=Data[0x1104]>>8&1; *i8=Data[0x1104]>>7&1;
		*i7=Data[0x1104]>>6&1; *i6=Data[0x1104]>>5&1; *i5=Data[0x1104]>>4&1;
		*i4=Data[0x1104]>>3&1; *i3=Data[0x1104]>>2&1; *i2=Data[0x1104]>>1&1; *i1=Data[0x1104]&1;
}


//
void Read_Ri_Word( int hARINC,unsigned short int *Data ,int *i)
{
		ioctl(hARINC,IOCTL_GET_RI,Data);
 		*i=Data[0x1104]&1;
}




//
void  Set_So_Tab_Z(unsigned short int *Data,int nc,int nb)
{
	int	i;
	for (i=0;i<256;i++)
	{
   	    Data[0x2800+nb*0x1000+(nc-1)*0x100+i]=0;
	}
}


void Set_So_Tab_F(unsigned short int *Data,int nc,int nb,int i,int i1)
{
 	Data[0x2800+(nb)*0x1000+(nc-1)*0x100+(i-1)]=i1<<13;
}



void Set_So_Dan_Rc_F( int hARINC,unsigned short int *Data ,int nc,int nb,int cikl,int start,int number)
{
     	if(number<1) 
     		Data[0x1102]=3;
		else 
		{   
    		Data[0x1020+nb*0x18+(nc-1)*3+1]=cikl;Data[0x1020+nb*0x18+(nc-1)*3+2]=start;
		Data[0x2800+nb*0x1000+(nc-1)*0x100+(start-1)+(number-1)]=
    		Data[0x2800+nb*0x1000+(nc-1)*0x100+(start-1)+(number-1)]|0x8001;
	 	Data[0x110c]=nc;Data[0x110d]=nb;
 		ioctl(hARINC,IOCTL_TAB_SO_F,Data);
		if(Data[0x1102]==0)
		{Data[0x1020+nb*0x18+(nc-1)*3]=1;}
	 	}
}



void Set_So_Tab_G(unsigned short int *Data,int nc,int i,int i1,int i2)
{
    		Data[0x2800+(nc-1)*0x100+(i-1)]=(i2<<13)|0x1000|((i1-1)<<1);
}



void Set_So_Dan_Rc_G( int hARINC,unsigned short int *Data ,int nc,int number)
{ 
		if(number<1)
     		Data[0x1102]=3;
		else
      		{
     		Data[0x1020+(nc-1)*3+1]=0;Data[0x1020+(nc-1)*3+2]=1;
		Data[0x2800+(nc-1)*0x100+(number-1)]=(unsigned short)(Data[0x2800+(nc-1)*0x100+(number-1)]|(0x8001));
		Data[0x110c]=nc; Data[0x110b]=number;
		ioctl(hARINC,IOCTL_TAB_SO_G,Data);
		if(Data[0x1102]==0){ Data[0x1020+(nc-1)*3]=1;}
		}
}



//
void Get_So_Dan_Rc(unsigned short int *Data,int *nc,int *nb,int *cikl,int *start)
{
	 	*cikl=Data[0x1020+(*nb)*0x18+(*nc-1)*3+1];*start=Data[0x1020+(*nb)*0x18+(*nc-1)*3+2];
}




//
void  Set_Si_Tab_Z(unsigned short int *Data,int nc,int nb)
{
	int	i;
		for (i=0;i<256;i++)
		{
   		Data[0x2000+nb*0x1000+(nc-1)*0x100+i]=0;
		}
}



void  Set_Si_Tab_E(unsigned short int *Data,int nc,int nb,int i,int e)
{
   		Data[0x2000+nb*0x1000+(nc-1)*0x100+(i)]=(e&1)<<14;
}



void  Set_Si_Tab_M(unsigned short int *Data,int nc,int nb,int i,int m)
{
   		Data[0x2000+nb*0x1000+(nc-1)*0x100+(i)]=(unsigned short)(Data[0x2000+nb*0x1000+
   				(nc-1)*0x100+(i)]|((m&1)<<15));
}



void  Set_Si_Tab_Km(unsigned short int *Data,int nc,int nb,int i,int km)
{
   		Data[0x2000+nb*0x1000+(nc-1)*0x100+(i)]=(unsigned short)(Data[0x2000+nb*0x1000+
   				(nc-1)*0x100+(i)]|(km&1));
}


void  Set_Si_Tab( int hARINC,unsigned short int *Data ,int nc,int nb)
{
   		Data[0x1050+nb*0x8+(nc-1)]=1;
		Data[0x110c]=nc;
   		Data[0x110d]=nb;
		ioctl(hARINC,IOCTL_TAB_SI,Data);
}



//
void  Pusk_So( int hARINC,unsigned short int *Data ,int nc,int nb,int m,int e)
{
   		Data[0x27+nc]=(unsigned short)(((m&1)<<15)|((e&1)<<14)|
		((nb&1)<<13)|((nb&1)<<12)|0x500|((Data[0x1020+nb*0x18+(nc-1)*3+1]&1)<<9)|
   		(Data[0x1020+(nb)*0x18+(nc-1)*3+2]&0xff-1));
		Data[0x110e]=(unsigned short)nc; Data[0x110f]=(unsigned short)nb;
		ioctl(hARINC,IOCTL_PUSK_SO,Data);
		if(Data[0x1102]==0)Data[0x1020+nb*24+(nc-1)*3]=0;
}


//
void  Pusk_So_St( int hARINC,unsigned short int *Data ,int nc,int nb,int m, int cikl,int start,int number)
{
	int	i;
		for (i=0;i<256;i++)
		{
		Data[0x2800+nb*0x1000+(nc-1)*0x100+i]=0;
		}
		
     		if(number<1) {Data[0x1102]=2;}
		else 
		{
      		Data[0x1020+nb*0x18+(nc-1)*3+1]=cikl;
		Data[0x1020+nb*0x18+(nc-1)*3+2]=start;
		Data[0x2800+nb*0x1000+(nc-1)*0x100+(start-1)+(number-1)]=
		Data[0x2800+nb*0x1000+(nc-1)*0x100+(start-1)+(number-1)]|0x8001;
		Data[0x110c]=(unsigned short)nc;
		Data[0x110d]=(unsigned short)nb;
 		ioctl(hARINC,IOCTL_TAB_SO_F,Data);
	
		if(Data[0x1102]==0){Data[0x1020+nb*0x18+(nc-1)*3]=1;

		Data[0x27+nc]=(unsigned short)(((m&1)<<15)|
		((nb&1)<<13)|((nb&1)<<12)|0x500|((Data[0x1020+nb*0x18+(nc-1)*3+1]&1)<<9)|
		(Data[0x1020+(nb)*0x18+(nc-1)*3+2]&0xff-1));

		Data[0x110e]=(unsigned short)nc;
		Data[0x110f]=(unsigned short)nb;
		ioctl(hARINC,IOCTL_PUSK_SO,Data);
		if(Data[0x1102]==0)Data[0x1020+nb*24+(nc-1)*3]=0;
		}
		}
}



// 
void  Pusk_Si( int hARINC,unsigned short int *Data ,int nc,int nb,int m,int ap)
{
		Data[0x1f+nc]=(unsigned short)(((m&1)<<15)|((ap&1)<<9)|
					((nb&1)<<13)|((nb&1)<<12)|0x500);
		Data[0x110e]=(unsigned short)nc; 
		Data[0x110f]=(unsigned short)nb;
		ioctl(hARINC,IOCTL_PUSK_SI,Data);
		if(Data[0x1102]==0)Data[0x1050+nb*8+nc-1]=0;
}




void  Pusk_Si_St( int hARINC,unsigned short int *Data ,int nc,int nb,int ap)
{
	int	i;
		for (i=0;i<256;i++)
		{
		Data[0x2000+nb*0x1000+(nc-1)*0x100+i]=0;
		}

		Data[0x1050+nb*0x8+(nc-1)]=1;
		Data[0x110c]=(unsigned short)nc;
		Data[0x110d]=(unsigned short)nb;
		ioctl(hARINC,IOCTL_TAB_SI,Data);
		if(Data[0x1102]==0){Data[0x1f+nc]=(unsigned short)(((ap&1)<<9)|((nb&1)<<13)|((nb&1)<<12)|0x500);
		Data[0x110e]=(unsigned short)nc; Data[0x110f]=(unsigned short)nb;
		ioctl(hARINC,IOCTL_PUSK_SI,Data);
		if(Data[0x1102]==0)Data[0x1050+nb*8+nc-1]=0;}
}


//
void Stop_So( int hARINC,unsigned short int *Data ,int nc)
{
   		Data[0x110e]=(unsigned short)((nc-1)|8);
		ioctl(hARINC,IOCTL_STOP_CH,Data);
}



//
void Stop_Si( int hARINC,unsigned short int *Data ,int nc)
{
   		Data[0x110e]=(unsigned short)(nc-1);
		ioctl(hARINC,IOCTL_STOP_CH,Data);
}


//
void  Get_Error(unsigned short int *Data,int *err)
{
   		*err=Data[0x1102];
}


//
void Int__Set(int hARINC,unsigned short int *Data)
{
 		Data[0x1900]= (unsigned short)getpid();
 		ioctl(hARINC,IOCTL_INT,Data);
}											

void Read_Rfi_Word( int hARINC,unsigned short int *Data ,int *ii)
{
 		ioctl(hARINC,IOCTL_GET_RFI,Data);
		*ii=Data[0x1700];
}

void Read_Rfi_Int( int hARINC,unsigned short int *Data ,int *ii)
{
 		ioctl(hARINC,IOCTL_GET_RFI_INT,Data);
		*ii=Data[0x1701];
}





/*
gcc -c -fPIC  lib_pex429.c
gcc -shared -fPIC -o lib_pex429.so lib_pex429.o

gcc mini.c -o  mini -L. -l_pex429 -Wl,-rpath,/home/DEVICES/PEX429-1/ver42
*/
