//==============================================
//
//	SO - Выдача в режиме программного расписания
//	SI - Файловый прием
//==============================================


#include <signal.h>
#include <stdio.h>
#include <linux/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "pex429LNX.h"

#define   SO_CHANNEL_NUMBER	4
#define   SI_CHANNEL_NUMBER	4
#define   SI_ARRAY_NUMBER	2
#define   SO_PARAM_NUMBER	6
#define   SI_PARAM_NUMBER	9
#define   DS_NUMBER		4


#define   USHORT	__u16
#define   ULONG		__u32

  	struct BufInput2432{
		USHORT  ArrayDim;	//размерность массива параметров от 1 до (256*N-1),
					//где N-количество каналов, работающих в режиме 
					//программного расписания ;
		USHORT  reserved;	//
		ULONG     param [512];	//массив выходных параметров; 
						//индекс параметра в этом массиве равен 
						//номеру параметра в глобальном буфере.
		};
	union{ 
		struct 	BufInput2432 bufInput; 
 		USHORT	 bufOutput; 
	}buff2432; 


 	struct BufInput2434{
		USHORT  ChanNumber;//номер канала (1..8) 
		USHORT  ArrayDim;  //размерность массива номеров параметров (1..256);
		USHORT  Period;	   //переменная, определяющая период выдачи массива . 
				//Может принимать значение от ArrayDim до 256. Период 
				//выдачи массива будет равен Period*Т, где значение Т 
				//зависит от рабочей частоты канала и равно  360, 720, 
				//2880 мксек  для частот 100, 50, 12.5КГц  соответственно.
		USHORT  InterrMask;//=0(1) без прерывания (с прерыванием) по концу выдачи 
				//массива
		USHORT  param [8];//массив номеров выходных параметров в глобальном 
				//буфере. Элементы массива принимают значения от 0 до 256*N-2.
		} ;
	union{ 
		struct 	BufInput2434 bufInput; 
 		USHORT	 bufOutput; 
	}buff2434; 


 	struct BufInput2433{
		USHORT  paramNumber;	//номер параметра в глобальном  буфере от 0 до (256*N-2 ), 
					//где N-количество каналов, работающих в глобальном режиме;
		USHORT  reserved;	//
		ULONG     param;	//значение выходного параметра
		};
	union{ 
		struct 	BufInput2433 bufInput; 
 		USHORT	bufOutput; 
	}buff2433; 



	struct BufOutput2515{
		USHORT  error;		//код ошибки 
		USHORT  reserved;	//
		ULONG   param [256];	//массив параметров
		} ;
	union { 
 		USHORT	bufInput[2]; 
		struct 	BufOutput2515 bufOutput; 
	}buff2515; 

 
	struct BufOutput2524{
		USHORT  error;          // переменная, в которой драйвер возвращает код 
					//ошибки :   1 – ошибочный номер канала
					//    	     2 – ошибочный номер массива 
					//    	     3 – ошибочный адрес параметра 
					//                   0 – без ошибки
		USHORT  reserved;	//
		ULONG Param; 		//переменная, в который драйвер возвращает код
					//параметра		
		};
	union{ 
		USHORT	bufInput[3]; 
 		struct 	BufOutput2524 bufOutput; 
	}buff2524; 



	int  hARINC;
	USHORT	buff[16];
	int interruptPKnumber;
	int interruptDSnumber;
	int taskPID;
	USHORT dsNumber;

	struct sigaction action;
	struct	timeval start,end;

 
	
void hINT (int signo)
{
 	USHORT  flagIntr[5], codRI;
	ioctl ( hARINC, LNX_PCI429_RFI_INT, &flagIntr );
	if(flagIntr[0])	
	{
		ioctl ( hARINC, LNX_PCI429_GET_INT2, &codRI );
		while(codRI)
		{
			interruptPKnumber++;
			ioctl ( hARINC, LNX_PCI429_GET_INT2, &codRI );
		}
		ioctl ( hARINC, LNX_PCI429_CLR_DO, &dsNumber );	
	}
	if(flagIntr[4])
	{
		interruptDSnumber++;
		ioctl ( hARINC, LNX_PCI429_SET_DO, &dsNumber );	
	}
	
	ioctl ( hARINC, LNX_PCI429_RESET_INT, NULL); 

 	return ;
}

int main ()
{
	int 	i;

	dsNumber = DS_NUMBER;

	printf("=========================================================================\n");


	hARINC=open("/dev/pex429_0",0);
	if(hARINC==-1)
	{
	   	printf("open error\n");
		return 0;	
	}

	//2.1. Инициализация адаптера.

	for(i=0; i<16; i++)
		buff[i] = 1;
	ioctl(hARINC,LNX_PCI429_INIT,&buff);
	printf("                              PEX429-1-%d%d\n",buff[0],buff[1]);
	printf("SI number = %d\n",buff[0]);
	printf("SO number = %d\n",buff[1]);


	//2.7.2. Чтение серийного номера адаптера.

	ioctl(hARINC,LNX_PCI429_GET_SN,&buff);
	printf("Serial # = %d\n",buff[0]);


	//2.7.1. Чтение параметров адаптера.

	ioctl(hARINC,LNX_PCI429_GET_PARAM,&buff);
	printf("PLX  = 0x%x\n",buff[0]);
	printf("port = 0x%x\n",buff[1]);
	printf("IRQ  = 0x%x\n",buff[2]);

	
	//2.3. Обслуживание  прерываний.
	//2.3. Обслуживание  прерываний.передача  в драйвер идентификатора пользовательского процесса
	action.sa_handler = hINT;
	action.sa_flags = 0;
	sigaction(SIGUSR1, &action, NULL);
	taskPID = getpid();
	ioctl(hARINC,LNX_PCI429_INIT_INT,&taskPID);


	//2.6.2. Установка РК.

	ioctl ( hARINC, LNX_PCI429_SET_DO, &dsNumber );	


	//2.6.1. Чтение состояния РК.

	ioctl ( hARINC, LNX_PCI429_GET_DI, &buff );	
	printf(" LNX_PCI429_GET_DI:  0x%x\n",buff[0]);


	//2.6.4. Разрешение прерывания РК.

	buff [0] = DS_NUMBER;   // номер выходной РК (1..4)
	buff [1] = 1;           // 0-й бит задает режим флагов прерывания:  0(1)- по логической 1(0)
	ioctl ( hARINC, LNX_PCI429_SET_DI_INTR, &buff);	


	//2.5.2 Файловый прием (п.3.2.2.ИП).
	//2.5.2.1.Пуск приема 

	buff[0] = SI_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff[1]	= SI_ARRAY_NUMBER;	//номер массива (1 или 2)
	buff[2]	= 0xfff;		//ап, при поступлении которого формируется 
					//прерывание (0..0xff) или иной код , если 
					//прерывание не используется
	buff[3]	= 0xfff;		//адрес параметра, при поступлении которого 
					//прием по каналу останавливается (0..0xff) 
					//или иной код , если останов не требуется
	ioctl ( hARINC, LNX_PCI429_SI_F_PUSK, &buff );
	printf("LNX_PCI429_SI_F_PUSK:  0x%x\n",buff[0]);



	//2.4.3. Выдача в режиме программного расписания (п.3.1.3. ИП).
	//2.4.3.1.Задание номеров каналов, работающих в режиме программного расписания.

	buff[0] = 2;	//количество каналов, работающих в режиме программного расписания (N =1..8);
	buff[1]	= 2;	//массив номеров каналов,
	buff[2]	= 4;	//..
	ioctl ( hARINC, LNX_PCI429_SO_G_CHANAL, &buff );	
	printf("LNX_PCI429_SO_G_CHANAL:  0x%x\n",buff[0]);


	//2.4.3.2.Заполнение глобального буфера первоначальными значениями параметров
	
	buff2432.bufInput.ArrayDim = 8;	 
	for(i=0; i<8;i++)
		buff2432.bufInput.param[i] = 0xab00cd00+((255-i)<<16)+i;//массив выходных параметров
	ioctl ( hARINC, LNX_PCI429_SO_G_PARAM_B, &buff2432 );
	printf("LNX_PCI429_SO_G_PARAM_B:  0x%x\n",buff2432.bufOutput);

	//2.4.3.4.Пуск выдачи 

	buff2434.bufInput.ChanNumber = SO_CHANNEL_NUMBER;	 
	buff2434.bufInput.ArrayDim = 8;	 
	buff2434.bufInput.Period = 128;	 
	buff2434.bufInput.InterrMask = 1;	 
	for(i=0; i<8;i++)
		buff2434.bufInput.param[i] = 7-i;//массив номеров выходных параметров
	ioctl ( hARINC, LNX_PCI429_SO_G_PUSK, &buff2434 );	
	printf("LNX_PCI429_SO_G_PUSK:  0x%x\n",buff2434.bufOutput);


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<5);


	//2.4.1.3.Опрос состояния выходного канала.

	buff[0] = SO_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SO_STATE,&buff );
	printf("LNX_PCI429_SO_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SO_STATE:#param 0x%x\n",buff[1]);

	
	//2.5.1.3.Опрос состояния входного канала.
	
	buff[0] = SI_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_STATE,&buff );	
	printf("LNX_PCI429_SI_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SI_STATE:#param 0x%x\n",buff[1]);


	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.5.2.4.Чтение принятого слова ПК 

	buff2524.bufInput[0] = SI_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff2524.bufInput[1] = SI_ARRAY_NUMBER;	//номер массива (1 или 2)
	buff2524.bufInput[2] = SI_PARAM_NUMBER;	//номер слова ПК во входном буфере (0..255)
	ioctl ( hARINC, LNX_PCI429_SI_PARAM, &buff2524 );	
	printf("LNX_PCI429_SI_PARAM:error 0x%x\n",buff2524.bufOutput.error);
	printf("LNX_PCI429_SI_PARAM:param 0x%08x\n",buff2524.bufOutput.Param);


	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.4.3.3.Запись параметра в глобальный буфер.
	buff2433.bufInput.paramNumber = SO_PARAM_NUMBER;	 
	buff2433.bufInput.param = 0x86427531;
	ioctl ( hARINC, LNX_PCI429_SO_G_PARAM, &buff2433 );
	printf("LNX_PCI429_SO_G_PARAM:  0x%x\n",buff2433.bufOutput);


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<3);

	//2.5.2.4.Чтение принятого слова ПК 

	buff2524.bufInput[0] = SI_CHANNEL_NUMBER;	//номер канала (1..8) 
	buff2524.bufInput[1] = SI_ARRAY_NUMBER;	//номер массива (1 или 2)
	buff2524.bufInput[2] = SI_PARAM_NUMBER;	//номер слова ПК во входном буфере (0..255)
	ioctl ( hARINC, LNX_PCI429_SI_PARAM, &buff2524 );	
	printf("LNX_PCI429_SI_PARAM:error 0x%x\n",buff2524.bufOutput.error);
	printf("LNX_PCI429_SI_PARAM:param 0x%08x\n",buff2524.bufOutput.Param);


	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<2);

	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<32;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.4.2.3.Останов выдачи 

	buff[0] = SO_CHANNEL_NUMBER;	
	ioctl ( hARINC, LNX_PCI429_SO_STOP, &buff );	
	printf("LNX_PCI429_SO_STOP: 0x%x\n",buff[0]);

	//2.5.1.2.Останов приема 

	buff[0] = SI_CHANNEL_NUMBER;	
	ioctl ( hARINC, LNX_PCI429_SI_STOP,&buff );
	printf("LNX_PCI429_SI_STOP: 0x%x\n",buff[0]);


	gettimeofday(&start,NULL);
	do
	{
		gettimeofday(&end,NULL);
	}while((end.tv_sec-start.tv_sec)<2);

	
	//2.5.1.3.Опрос состояния входного канала.
	
	buff[0] = SI_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_STATE,&buff );	
	printf("LNX_PCI429_SI_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SI_STATE:#param 0x%x\n",buff[1]);

	//2.6.5. Запрет прерывания РК.

	buff [0] = DS_NUMBER;   // номер выходной РК (1..4)
	ioctl ( hARINC, LNX_PCI429_CLEAR_DI_INTR, &buff );	


	ioctl(hARINC,LNX_PCI429_STOP,NULL);
	
 	printf("interrupt PK number =  %d\n",interruptPKnumber);
 	printf("interrupt DS number =  %d\n",interruptDSnumber);


 	close(hARINC);
   

}
