//==============================================
//
//	SO - Однократная выдача
//	SI - Адресный прием
//==============================================


#include <signal.h>
#include <stdio.h>
#include <linux/types.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#include "pex429LNX.h"

#define   SO_CHANNEL_NUMBER	4
#define   SI_CHANNEL_NUMBER	4
#define   SO_ARRAY_NUMBER	2
#define   SI_ARRAY_NUMBER	1


#define   USHORT	__u16
#define   ULONG		__u32


	int  hARINC;
	unsigned short int	buff[16];
 
	struct BufInput2411{
		USHORT  ChanNumber;	//номер канала (1..8) 
		USHORT  ArrayNumber;	//номер массива (1 или 2)
		USHORT  InterrMask;	//=0(1) без прерывания (с прерыванием) по концу выдачи массива
		USHORT  ArrayDim;	//размерность массива параметров (1..256);
		ULONG   param [256];	//массив выходных параметров
		} ;
	
	union { 
		struct 	BufInput2411 bufInput; 
 		USHORT	bufOutput; 
	}buff2411; 
 
	struct BufOutput2515{
		USHORT  error;		//код ошибки 
		USHORT  reserved;	//
		ULONG   param [256];	//массив параметров
		} ;
	
	union { 
 		USHORT	bufInput[2]; 
		struct 	BufOutput2515 bufOutput; 
	}buff2515; 


int main ()
{
	int 	i;

	printf("=========================================================================\n");


	hARINC=open("/dev/pex429_0",0);
	if(hARINC==-1)
	{
	   	printf("open error\n");
		return 0;	
	}

	//2.1. Инициализация адаптера.

	for(i=0; i<16; i++)
		buff[i] = 2;
	ioctl(hARINC,LNX_PCI429_INIT,&buff);
	printf("                              PEX429-1-%d%d\n",buff[0],buff[1]);
	printf("SI number = %d\n",buff[0]);
	printf("SO number = %d\n",buff[1]);

	//2.7.2. Чтение серийного номера адаптера.

	ioctl(hARINC,LNX_PCI429_GET_SN,&buff);
	printf("Serial # = %d\n",buff[0]);

	//2.7.1. Чтение параметров адаптера.

	ioctl(hARINC,LNX_PCI429_GET_PARAM,&buff);
	printf("PLX  = 0x%x\n",buff[0]);
	printf("port = 0x%x\n",buff[1]);
	printf("IRQ  = 0x%x\n",buff[2]);

	//2.5.1 Адресный прием (п.3.2.1.ИП).
	//2.5.1.1.Пуск приема 

	buff[0] = SI_CHANNEL_NUMBER;
	buff[1] = SI_ARRAY_NUMBER;
	buff[2] = 0xfff;
	buff[3] = 0xfff;
	ioctl ( hARINC, LNX_PCI429_SI_A_PUSK, &buff );
	printf("LNX_PCI429_SI_A_PUSK: 0x%x\n",buff[0]);

	sleep(1);
	
	//2.5.1.3.Опрос состояния входного канала.
	
	buff[0] = SI_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_STATE,&buff );	
	printf("LNX_PCI429_SI_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SI_STATE:#param 0x%x\n",buff[1]);

	//2.4.1. Однократная выдача (п.3.1.1. ИП).
	//2.4.1.1 Подготовка выходного массива.

	buff2411.bufInput.ChanNumber = SO_CHANNEL_NUMBER;
	buff2411.bufInput.ArrayNumber = SO_ARRAY_NUMBER;
	buff2411.bufInput.InterrMask = 0;
	buff2411.bufInput.ArrayDim = 256;
	for(i=0; i<256;i++)
		buff2411.bufInput.param[i] = 0x80000000+(i<<16)+
			(SO_CHANNEL_NUMBER<<12)+(SO_ARRAY_NUMBER<<8)+(255-i);
	ioctl ( hARINC, LNX_PCI429_SO_O_PARAM,&buff2411);
	printf("LNX_PCI429_SO_O_PARAM: 0x%x\n",buff2411.bufOutput);

	//2.4.1.2.Пуск выдачи 

	buff[0] = SO_CHANNEL_NUMBER;
	buff[1] = SO_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SO_O_PUSK,&buff );
	printf("LNX_PCI429_SO_O_PUSK: 0x%x\n",buff[0]);

	sleep(1);

	//2.4.1.3.Опрос состояния выходного канала.

	buff[0] = SO_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SO_STATE,&buff );
	printf("LNX_PCI429_SO_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SO_STATE:#param 0x%x\n",buff[1]);

	//2.5.1.5.Чтение массива входных параметров

	buff2515.bufInput[0] = SI_CHANNEL_NUMBER;
	buff2515.bufInput[1] = SI_ARRAY_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_BUFER,&buff2515 );
	printf("LNX_PCI429_SI_BUFER:error 0x%x\n",buff2515.bufOutput.error);
	for(i=0; i<256;i++)
		printf("  %08x",buff2515.bufOutput.param[i]);
	printf("\n");


	//2.5.1.2.Останов приема 

	buff[0] = SI_CHANNEL_NUMBER;	
	ioctl ( hARINC, LNX_PCI429_SI_STOP,&buff );

	sleep(1);
	
	//2.5.1.3.Опрос состояния входного канала.
	
	buff[0] = SI_CHANNEL_NUMBER;
	ioctl ( hARINC, LNX_PCI429_SI_STATE,&buff );	
	printf("LNX_PCI429_SI_STATE:state 0x%x\n",buff[0]);
	printf("LNX_PCI429_SI_STATE:#param 0x%x\n",buff[1]);

	
	ioctl(hARINC,LNX_PCI429_STOP,NULL);
	
  	close(hARINC);
   

}
