#include <signal.h>
#include <stdio.h>
#include <sys/time.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "pex429LNX.h"
#include "pex429LNXmacro.h"

	int  hARINC;
	short unsigned int Data[32768];

 	int testMode;
	long int receivedCode
		,expectedCode
		,outputCode
		,numberOfINT1=0
		,numberOfINT2=0
		,cycleNumber=0;
	
	int 	numberSI=0
		,numberSO=0
		,i
		,dii=0
		,err_rk=0
		,err_si=0
		,i1;

 	struct sigaction action;
 	struct itimerval timer;
    
	void Start();


//********************************************************
//** 		обработчик прерываний			**
//********************************************************

	
void hINT (int signo)
{
 	short unsigned int w,ii[16];

	READ_RFI_INT(hARINC,Data,w) ;

	if(w&0x1000)
	{
		do
		{
			READ_RI(hARINC,Data,ii[15],ii[14],ii[13],ii[12]
				,ii[11],ii[10],ii[9],ii[8],ii[7],ii[6]
				,ii[5],ii[4],ii[3],ii[2],ii[1],ii[0]);
			numberOfINT2+=ii[8];
		 }while (ii[8]!=0);
 	}

	if(w&0xf00)	numberOfINT1++;

	WRITE_RI(hARINC,Data);

	return ;
}



//********************************************************
//** 			timerNonstop			**
//********************************************************

void timerNonstop (int signo)

{
   int	delta=numberSI-numberSO, err_SI;
	
	err_SI=err_si;
	

   if(timer.it_value.tv_usec == 200000)
   {

	GET_DI(hARINC,Data,dii);
	if( (cycleNumber&0xf-dii)!=0)
		err_rk++;
	cycleNumber++;

	SET_DO(hARINC,Data,(short unsigned int) cycleNumber);


	for (i1=1; i1<=numberSI/2; i1++)
	{
	    for (i=255;i>=0;i--)
	    {
		    READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
		    expectedCode=((i)&0xff)|((i1&0xff)<<8)
			|(((~(i))&0xff)<<16)|(((~i1)&0xff)<<24);
		    if ( receivedCode!=expectedCode)
			err_si++;
 	    }
	}
	
	
	for (i1=numberSI/2+1; i1<=numberSI; i1++)
	{
	    for (i=255;i>=0;i--)
	    {
		    READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
		    expectedCode=((i)&0xff)|(((i1-delta)&0xff)<<8)
			|(((~(i))&0xff)<<16)|(((~(i1-delta))&0xff)<<24);
		    if ( receivedCode!=expectedCode)
			err_si++;
	    }
	}
	
	
	if(err_SI!=err_si)
	{
    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 0;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 0;
      		setitimer(ITIMER_REAL, &timer, NULL);

    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 950000;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 950000;
      		setitimer(ITIMER_REAL, &timer, NULL);
		SET_DO(hARINC,Data,(short unsigned int) 0);
	}

  	printf(" \r");
  	printf("count=%5ld di=%2d err_rk=%3d err_si=%3d INT2 #=%5ld INT1 #=%5ld\r",cycleNumber,dii,err_rk,err_si,numberOfINT2,numberOfINT1);
	
	
   }//if(timer.it_value.tv_usec == 200000)

   else
	{
		err_si++;
    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 0;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 0;
      		setitimer(ITIMER_REAL, &timer, NULL);
     		
		for( i=1; i<=numberSO;i++)
			STOP_SO(hARINC,Data,i);
	
		for( i=1; i<=numberSI;i++)
			STOP_SI(hARINC,Data,i);
	
		ARINC_STOP(hARINC,Data);
	
		Start();
    		timer.it_value.tv_sec = 0;
    		timer.it_value.tv_usec = 200000;
      		timer.it_interval.tv_sec = 0;
    		timer.it_interval.tv_usec = 200000;
      		setitimer(ITIMER_REAL, &timer, NULL);
	}
}





//************************************************
//** 		timerErrorstop			**
//************************************************

void timerErrorstop (int signo)

{
	int	delta=numberSI-numberSO,ch, param;
	
	GET_DI(hARINC,Data,dii);

	cycleNumber++;

	SET_DO(hARINC,Data,(short unsigned int) cycleNumber);


	for (i1=1; i1<=numberSI/2; i1++)
	{
		for (i=0;i<=255;i++)
		{
			READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
			expectedCode=((i)&0xff)|((i1&0xff)<<8)
				|(((~(i))&0xff)<<16)|(((~i1)&0xff)<<24);

			if ( receivedCode!=expectedCode)
			{
				ch=i1;
				param=i;
				i=256;
				i1=256;
		   		timer.it_value.tv_sec = 0;
		    		timer.it_value.tv_usec = 0;
		      		timer.it_interval.tv_sec = 0;
		    		timer.it_interval.tv_usec = 0;
		      		setitimer(ITIMER_REAL, &timer, NULL);
			}
		}
	}


	if(i1<256)	
	{
	for (i1=numberSI/2+1; i1<=numberSI; i1++)
	{
		for (i=0;i<=255;i++)
		{
			READ_PRM_SS(hARINC,Data,i1,0,i,receivedCode);
			expectedCode=((i)&0xff)|(((i1-delta)&0xff)<<8)
				|(((~(i))&0xff)<<16)|(((~(i1-delta))&0xff)<<24);
			if ( receivedCode!=expectedCode)
			{
				ch=i1;
				param=i;
				i=256;
				i1=256;
		  		timer.it_value.tv_sec = 0;
		    		timer.it_value.tv_usec = 0;
		      		timer.it_interval.tv_sec = 0;
		    		timer.it_interval.tv_usec = 0;
		      		setitimer(ITIMER_REAL, &timer, NULL);
			}
		}
	}
	}

  	printf(" \r");
  	
 	if(i1<256)	
	{
	 	printf("cycleNumber=%5ld dii=%2d  INT2 #=%5ld INT1 #=%5ld\r"
			,cycleNumber,dii,numberOfINT2,numberOfINT1);
 	}
 	else
 	{
	  	printf("count=%5ld di=%2d  INT2 #=%5ld INT1 #=%5ld\n"
			,cycleNumber,dii,numberOfINT2,numberOfINT1);
	  	printf("chanal #=%5d param #=%3d  wait =%8lxh rec =%8lxh\n"
			,ch,param,expectedCode,receivedCode);
	  	printf("Press ENTER for quit");
 	}

}



//********************************************************
//** 			main				**
//********************************************************

int main (){	
	int rj, ind1, currentSN, neededSN;
 	char msg[15]={'/','d','e','v','/','p','e','x','4','2','9','_'};
 	int testType;
	
	printf("enter serial # :")	;
	scanf("%5d",&neededSN);
	msg[13]='\0';
      	while(getchar()!=0xa);


	printf					  ("=========================================================================\n");
	printf("                              PEX429-1 serial # %d\n\n",neededSN);

	//1.1. Открытие устройства

	ind1 = 0;
	msg[12]='0';
	hARINC=open(msg,0);
	while ((ind1 < 8)&&(hARINC!=-1))
	{
		GET_SN(hARINC,Data,currentSN);
		if(currentSN == neededSN)
			break;
		else
		{
			close(hARINC);
			msg[12]++;
			ind1++;
			hARINC=open(msg,0);
		}
	}
	if(currentSN != neededSN)
	{
		printf("open error\n\n")	;
		return 0;
	}

	
	//первоначальной настройки параметров адаптера.

	ioctl(hARINC,IOCTL_RJ ,Data);
	GET_RJ_M(Data,rj);
	printf("RID = 0x%04x\n",rj);

	numberSI = (rj&0xf00)>>8;
	numberSO = (rj&0xf0)>>4;
	printf("SI number = %d\n",numberSI);
	printf("SO number = %d\n",numberSO);

	//3.3.3. Обслуживание прерываний 

	action.sa_handler = hINT;
	action.sa_flags = 0;
	sigaction(SIGUSR1, &action, NULL);

	INT_SET(hARINC,Data);


	// режимы теста(ТЕСТ/с заглушкой, без/с остановкой по ошибке)

	printf("Test mode [0-with stub / 1-TEST]:")	;
	scanf("%1d",&testMode);
       	while(getchar()!=0xa);

	printf("Test type [0-nonstop / 1-error stop]:")	;
	scanf("%1d",&testType);
       	while(getchar()!=0xa);


	//timer

	timer.it_value.tv_sec = 0;
    	timer.it_value.tv_usec = 200000;
    	timer.it_interval.tv_sec = 0;
    	timer.it_interval.tv_usec = 200000;
							
	if(testType==0)
	{
		action.sa_handler = &timerNonstop;
		action.sa_flags = 0;
		sigaction(SIGALRM, &action, NULL);
        
     		setitimer(ITIMER_REAL, &timer, NULL);
	}
	else
	{
		action.sa_handler = &timerErrorstop;
		action.sa_flags = 0;
		sigaction(SIGALRM, &action, NULL);
    
		setitimer(ITIMER_REAL, &timer, NULL);
	}
	
					
	// запуск каналов

	printf("Press ENTER for quit \n")	;

	cycleNumber=0;
	Start();

	while(getchar()!=0xa);
      							

	//
	timer.it_value.tv_sec = 0;
	timer.it_value.tv_usec = 0;
	timer.it_interval.tv_sec = 0;
	timer.it_interval.tv_usec = 0;
	setitimer(ITIMER_REAL, &timer, NULL);
     	

	//3.3.2.10. Останов канала .
	
	for( i=1; i<=numberSO;i++)
		STOP_SO(hARINC,Data,i);
 	
	for( i=1; i<=numberSI;i++)
		STOP_SI(hARINC,Data,i);

 							
	//3.3.2.5.Останов адаптера.
	
	ARINC_STOP(hARINC,Data);

	
	//1.2. Закрытие устройства

	close(hARINC);
	
	return 0;
	
}


//********************************************************
//** 		запуск/перезапуск каналов		**
//********************************************************

void Start(){
	
	dii=0;
	numberOfINT2=0;
	numberOfINT1=0;
	
	
	//Подготовка кода регистра режимов в буфере обмена.
	
	testMode = ((testMode&1)<<3)+0x80;
	SET_RM(Data,testMode);
	
	//Подготовка кода регистра режимов в буфере обмена.

	SET_RF_SO_N(Data,2,2,2,2,2,2,2,2);
	SET_RF_SI_N(Data,2,2,2,2,2,2,2,2);
 
	//3.3.2.4. Инициализация адаптера.

	INIT_ARINC(hARINC,Data);
	

	//3.3.2.7. Задание последовательности выдачи параметров 
	//выходным каналом (файловый режим).
	
	for (i1=1; i1<=numberSO; i1++)
	{
		SET_SO_TAB_Z(Data,i1,0,i);
		SET_SO_DAN_RC_F(hARINC,Data,i1,0,0,1,256);
	}
	
	
	//3.3.2.8. Задание последовательности приема параметров входным каналом.
	
	
	for (i1=1; i1<=numberSI; i1++)
	{
		SET_SI_TAB_Z(Data,i1,0,i);
		SET_SI_TAB(hARINC,Data,i1,0);
	}
	
	
	//3.3.2.11. Запись параметра .

	for (i1=1; i1<=numberSO; i1++)
	{
		for (i=1;i<=256;i++)
		{
			outputCode=((i-1)&0xff)|((i1&0xff)<<8)
				|(((~(i-1))&0xff)<<16)|(((~i1)&0xff)<<24);
			WRITE_PRM(hARINC,Data,i1,0,i,outputCode);
		}
	}

	//3.3.2.9. Пуск канала/ установка задания в канале .

	for (i1=1; i1<=numberSI; i1++)
	{
		PUSK_SI(hARINC,Data,i1,0,1,1);
	}

 	for (i1=2; i1<=numberSO; i1++)
	{
		PUSK_SO(hARINC,Data,i1,0,1,0);
	}
	PUSK_SO(hARINC,Data,1,0,0,0);
}





