#include <signal.h>
#include <stdio.h>
#include <string.h>
#include "MPC429_QNX.h"
#include <time.h>
#include <sys/siginfo.h>

 	int hARINC;     
	long int  Nint1=0, ri=0, ch_prv=0, lii;
  	int numberSI, numberSO, i, i1, dii=0,
  			err_rk=0, err_si=0;
  
union buffer
{
	unsigned char dataChar[0x400];
	unsigned short int dataInt[0x200];
	unsigned long int dataUlong[  0x100];
}  ;                  
 union buffer  u;  
 
  	struct sigaction		action;
  	struct	itimerspec	timer;
  
  	timer_t					hTimer;
	
	int pid;
	void hINT1 (int signo)
 	{
		Nint1++;
		devctl(hARINC,mpc429_resetDI , NULL , 0, NULL);
  		return ;
	}

 	void hINT2(int signo)
 	{
		unsigned char  inRI;
		do{
				devctl(hARINC,mpc429_getRI , &inRI ,1, NULL);
				ri++;
				}while ( inRI!=0);
 		ri--;
		inRI = 0xff;
		devctl(hARINC,mpc429_setRI , &inRI ,1, NULL);
  		return ;
	}
 
 	
void  readOZU ( unsigned short int  addr, unsigned short int ch)
{
	unsigned short int  inb[0x200];
	unsigned short int  * outb = (unsigned short int  *) inb;

  	inb[0]=addr;
	if (ch<4) 
		inb[1]=4;
	else
		inb[1]=ch;
	
 	devctl(hARINC,mpc429_readMEM , inb , ch, NULL);
			printf ("\n");
	for (i=0; i<ch/2; i++)
			printf ("-%4x", *(outb+i));
}


void timerNonstop (int signo)
{
	int		delta=numberSI-numberSO, err_SI;
	
	err_SI=err_si;
	

   if(timer.it_value.tv_nsec == 200000000)
   {

 		devctl(hARINC,mpc429_getDI , &dii , 1, NULL);
		if( (ch_prv&0xff-dii&0xff)!=0)
		{
			err_rk++;
		}
		
		ch_prv++;

		u.dataChar[0] = ( unsigned char) ch_prv;
 		devctl(hARINC,mpc429_setDO , &u , 1, NULL);


		for (i1=1; i1<=numberSI/2; i1++)
		{
		    for (i=255;i>=0;i--)
		    {
				u.dataChar[0] = i1;
				u.dataChar[1] = 1;
				u.dataChar[2] = i;
 				devctl(hARINC,mpc429_READ_PRM_SS_nc, &u , 4, NULL);
			    lii=((i)&0xff)|((i1&0xff)<<8)|(((~(i))&0xff)<<16)|(((~i1)&0xff)<<24);
				if (  u.dataUlong[0]!=lii)
				{
					err_si++;
     			}
			  }//for (i=255;i>=0;i--)
		}//for (i1=1; i1<=numberSI/2; i1++)
	
	
	
		for (i1=numberSI/2+1; i1<=numberSI; i1++)
		{
	 	  	for (i=255;i>=0;i--)
	  		{
					u.dataChar[0] = i1;
					u.dataChar[1] = 1;
					u.dataChar[2] = i;
 					devctl(hARINC,mpc429_READ_PRM_SS_nc, &u , 4, NULL);
        		    lii=((i)&0xff)|(((i1-delta)&0xff)<<8)|(((~(i))&0xff)<<16)|(((~(i1-delta))&0xff)<<24);
				if (  u.dataUlong[0]!=lii)
				{
					err_si++;
				}
	 	  	}//for (i=255;i>=0;i--)
		}//for (i1=numberSI/2+1; i1<=numberSI; i1++)
	
	
		if(err_SI!=err_si)
		{
    			timer.it_value.tv_sec = 0;
    			timer.it_value.tv_nsec = 0;
      		timer.it_interval.tv_sec = 0;
    			timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);

    			timer.it_value.tv_sec = 0;
    			timer.it_value.tv_nsec = 950000000;
      		timer.it_interval.tv_sec = 0;
    			timer.it_interval.tv_nsec = 950000000;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
		u.dataChar[0] = 0;
 		devctl(hARINC,mpc429_setDO , &u , 1, NULL);
		
		}

  		printf(" \r");
  		printf("count=%5d di=%2d err_rk=%3d err_si=%3d INT2 #=%5d INT1 #=%5d    \r",ch_prv,dii,err_rk,err_si,ri,Nint1);
	
	
   }//if(timer.it_value.tv_usec == 200000000)

   else
	{
							err_si++;
    							timer.it_value.tv_sec = 0;
    							timer.it_value.tv_nsec = 0;
      						timer.it_interval.tv_sec = 0;
    							timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
      		
      		
							for( i=1; i<=numberSO;i++)
							{
								u.dataChar[0] = i;
							 	devctl(hARINC,mpc429_stopSO , &u , 1, NULL);
							 }
	 	
							for( i=1; i<=numberSI;i++)
						 	{
								u.dataChar[0] = i;
						 		devctl(hARINC,mpc429_stopSI , &u , 1, NULL);
						 	}	
 		
							devctl(hARINC,mpc429_STOP , NULL , 0, NULL);
	
	
							Start();
  					 		timer.it_value.tv_sec = 0;
 					  		timer.it_value.tv_nsec = 200000000;
 					    		timer.it_interval.tv_sec = 0;
   							timer.it_interval.tv_nsec = 200000000;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
	}


}

void timerErrorstop (int signo)
{
	int 	delta=numberSI-numberSO,ch, param;
	
	
 		devctl(hARINC,mpc429_getDI , &dii , 1, NULL);
		if( (ch_prv&0xff-dii&0xff)!=0)
		{
   						timer.it_value.tv_sec = 0;
   						timer.it_value.tv_nsec = 0;
      					timer.it_interval.tv_sec = 0;
    						timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
  	printf("count=%5d di=%2d  INT2 #=%5d INT1 #=%5d                 \n",ch_prv,dii,ri,Nint1);
  	printf("RK:  wait =%8xh rec =%8xh\n", ch_prv&0xf, dii );
  	printf("Press ENTER for quit");
  	return;
		}

		ch_prv++;
		
		u.dataChar[0] = ( unsigned char) ch_prv;
 		devctl(hARINC,mpc429_setDO , &u , 1, NULL);

		for (i1=1; i1<=numberSI/2; i1++)
		{
			for (i=0;i<=255;i++)
			{
				u.dataChar[0] = i1;
				u.dataChar[1] = 1;
				u.dataChar[2] = i;
 				devctl(hARINC,mpc429_READ_PRM_SS_nc, &u , 4, NULL);
				lii=((i)&0xff)|((i1&0xff)<<8)|(((~(i))&0xff)<<16)|(((~i1)&0xff)<<24);

				if (  u.dataUlong[0]!=lii)
				{
					ch=i1;
					param=i;
					i=256;
					i1=256;
   					timer.it_value.tv_sec = 0;
    					timer.it_value.tv_nsec = 0;
      				timer.it_interval.tv_sec = 0;
    					timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
				}

			}
		}


		if(i1<256)	
		{
			for (i1=numberSI/2+1; i1<=numberSI; i1++)
			{
				for (i=0;i<=255;i++)
				{
					lii=((i)&0xff)|(((i1-delta)&0xff)<<8)|(((~(i))&0xff)<<16)|(((~(i1-delta))&0xff)<<24);
					u.dataChar[0] = i1;
					u.dataChar[1] = 1;
					u.dataChar[2] = i;
 					devctl(hARINC,mpc429_READ_PRM_SS_nc, &u , 4, NULL);

					if (  u.dataUlong[0]!=lii)
					{
						ch=i1;
						param=i;
						i=256;
						i1=256;
   						timer.it_value.tv_sec = 0;
   						timer.it_value.tv_nsec = 0;
      					timer.it_interval.tv_sec = 0;
    						timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
					}
				}
			}
		}

  	printf(" \r");
  	
 	if(i1<256)	
	{
 	printf("count=%5d di=%2d  INT2 #=%5d INT1 #=%5d              \r",ch_prv,dii,ri,Nint1);
 	}
 	else
 	{
  	printf("count=%5d di=%2d  INT2 #=%5d INT1 #=%5d                 \n",ch_prv,dii,ri,Nint1);
  	printf("chanal #=%5d param #=%3d  wait =%8xh rec =%8xh\n",ch,param,lii, u.dataUlong[0]);
	readOZU(0x4000, 0x400);
	readOZU(0x5000, 0x400);
 	printf("Press ENTER for quit");
	}
}

 

main ()
{
	int  sn, snI, ind1;
	int TestType;

    char msg[14]={'/','d','e','v','/','M','P','C','4','2','9','_'};
    
    	printf("enter  # [0..7] :")	;
	scanf("%1d",&snI);
     	while(getchar()!=0xa);
	msg[13]='\0';

	msg[12]='0'+snI;
	hARINC=open(msg,0);

	printf (" hARINC  =  %x \n", hARINC);
	
	if (hARINC == -1)
	{
		printf("open error \n")	;
		return 0;
	}
	
 	devctl(hARINC,mpc429_getRID , &u , 1, NULL);
 		printf("RJ = %xh\n",u.dataChar[0])	;

	numberSI = (u.dataChar[0] & 0x38)>>3;
	numberSO = u.dataChar[0] & 0x7;
 		printf("number SI = %xh\n",numberSI)	;
 		printf("number SO = %xh\n",numberSO)	;
	
	numberSI = 2;
	numberSO = 2;

    memset(&action, 0, sizeof(action));
 	action.sa_handler = hINT1;
    sigaction(SIGUSR1, &action, NULL);
    

 	action.sa_handler = hINT2;
    sigaction(SIGUSR2, &action, NULL);

    //передача драйверу идентификатора процесса
    
	pid = getpid();
	devctl(hARINC,mpc429_setEvent , &pid , sizeof( pid ), NULL);


	printf("Test Type [0-nonstop / 1-error stop]:\n")	;
	scanf("%1d",&TestType);
       while(getchar()!=0xa);
	printf("Press ENTER for quit \n")	;
//return 0;	
	
	timer_create ( CLOCK_REALTIME,  NULL, &hTimer);
	
	
	Start();
							
   	timer.it_value.tv_sec = 0;
    	timer.it_value.tv_nsec = 200000000;
    	timer.it_interval.tv_sec = 0;
    	timer.it_interval.tv_nsec = 200000000;

		if(TestType==0)
						{
							action.sa_handler = &timerNonstop;
    							action.sa_flags = 0;
    							sigaction(SIGALRM, &action, NULL);
        
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
    
 						}
						else
						{
							
							action.sa_handler = &timerErrorstop;
    							action.sa_flags = 0;
    							sigaction(SIGALRM, &action, NULL);
    
        					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
						}

  	while(getchar()!=0xa);
  
	
	for( i=1; i<=numberSO;i++)
	{
		u.dataChar[0] = i;
	 	devctl(hARINC,mpc429_stopSO , &u , 1, NULL);
	 }
	 	
	for( i=1; i<=numberSI;i++)
 	{
		u.dataChar[0] = i;
 		devctl(hARINC,mpc429_stopSI , &u , 1, NULL);
 	}	
 		
 	devctl(hARINC,mpc429_STOP , NULL , 0, NULL);
 	printf("\n count=%5d di=%2d  INT2 #=%5d INT1 #=%5d              \n",ch_prv,dii,ri,Nint1);


//	printf ("-%4xh\n", ri);
 // 	readOZU(0x0, 0x40);

  	close(hARINC);
}






	Start()
{
	dii=0;
	ri=0;
	Nint1=0;
	ch_prv=0;
   
    	devctl(hARINC,mpc429_RESET , &u , 1, NULL);
// 	readOZU(0x0, 0x20);
//printf("\n\n\n");

//*****
	u.dataChar[0] = 0xa8;
	u.dataChar[1] = 0;
	for(i = 0; i<numberSI+numberSO; i++)
	{
		u.dataChar[2+i] = 2;
	}
 devctl(hARINC,mpc429_INIT , &u , 10, NULL);
//*****

//  	readOZU(0x0, 0x20);
printf("\n\n\n");

	for (i1=1; i1<=numberSO; i1++)
	{
		u.dataChar[0] = i1;
		u.dataChar[1] = 1;
		u.dataChar[2] = 255;
		u.dataChar[3] = 1;
		u.dataChar[4] = 0;
		u.dataChar[5] = 0;
		u.dataChar[6] = 0;
		u.dataChar[7] = 255;

	devctl(hARINC,mpc429_TAB_SO_F , &u , 8, NULL);
	}

//	readOZU(0x2400, 0x200);
/* 	readOZU(0x2600, 0x200);
 	readOZU(0x2c00, 0x200);
 	readOZU(0x2e00, 0x200);
*/
	for (i1=1; i1<=numberSI; i1++)
	{
		u.dataChar[0] = i1;
		u.dataChar[1] = 1;
		u.dataChar[2] = 0;
		u.dataChar[3] = 0;
		u.dataInt[2] = 256;                  
		for (i = 0; i<256; i++)
			u.dataChar[6+i] = i;

 		devctl(hARINC,mpc429_TAB_SI_SS , &u , 262, NULL);
	}
/*
  	readOZU(0x2000, 0x200);
 	readOZU(0x2200, 0x200);
 	readOZU(0x2800, 0x200);
 	readOZU(0x2a00, 0x200);

*/
	for (i1=1; i1<=numberSO; i1++)
	{
		for (i=1;i<=256;i++)
		{
		u.dataChar[0] = i1;
		u.dataChar[1] = 1;
		u.dataChar[2] = i-1;
		u.dataUlong[1]=((i-1)&0xff)|((i1&0xff)<<8)|(((~(i-1))&0xff)<<16)|(((~i1)&0xff)<<24);
		devctl(hARINC,mpc429_WRITE_PRM_F, &u , 12, NULL);
		}
	}
/*
  	readOZU(0x5800, 0x400);
 	readOZU(0x5c00, 0x400);
*/

	for (i1=1; i1<=numberSI; i1++)
	{
	u.dataChar[0] = i1;
	u.dataChar[1] =0x82;
 	devctl(hARINC,mpc429_puskSI , &u , 2, NULL);
	}
	u.dataChar[0] = 1;
	u.dataChar[1] =0;
	u.dataChar[2] =0;
	 devctl(hARINC,mpc429_puskSO , &u , 3, NULL);

 	for (i1=2; i1<=numberSO; i1++)
	{
	u.dataChar[0] = i1;
	u.dataChar[1] =0x80;
	u.dataChar[2] =0;
	 devctl(hARINC,mpc429_puskSO , &u , 3, NULL);
	}

// 

// 	readOZU(0x5400, 0x200);

 //	readOZU(0x0, 0x40);
//	readOZU(0x4000, 0x400);
}






/*	
cd ../home/vera/MPC
gcc TVK_mpc429QNX.c  -o TVK_mpc429QNX.out
 ./TVK_mpc429QNX.out
*/
#/** PhEDIT attribute block
#-11:16777215
#0:39:TextFont9:0:-3:0
#39:669:TextFont9:0:-1:0
#669:673:TextFont10:0:-1:0
#673:685:TextFont9:0:-1:0
#685:730:TextFont10:0:-1:0
#730:754:TextFont9:0:-1:0
#754:758:TextFont10:0:-1:0
#758:790:TextFont9:0:-1:0
#790:834:TextFont10:0:-1:0
#834:855:TextFont9:0:-1:0
#855:1235:TextFont10:0:-1:0
#1235:1346:TextFont9:0:-1:0
#1346:1379:TextFont9:160:-1:0
#1379:1382:TextFont9:0:-1:0
#1382:1396:TextFont9:160:-1:0
#1396:1483:TextFont9:0:-1:0
#1483:1484:TextFont9:160:-1:0
#1484:1508:TextFont9:0:-1:0
#1508:1555:TextFont9:160:-1:0
#1555:1635:TextFont9:0:-1:0
#1635:1637:TextFont9:160:-1:0
#1637:1645:TextFont9:0:-1:0
#1645:1654:TextFont9:160:-1:0
#1654:1659:TextFont9:0:-1:0
#1659:1661:TextFont9:160:-1:0
#1661:1669:TextFont9:0:-1:0
#1669:1677:TextFont9:160:-1:0
#1677:1682:TextFont9:0:-1:0
#1682:1684:TextFont9:160:-1:0
#1684:1692:TextFont9:0:-1:0
#1692:1700:TextFont9:160:-1:0
#1700:1701:TextFont9:0:-1:0
#1701:1758:TextFont9:160:-1:0
#1758:1844:TextFont9:0:-1:0
#1844:1859:TextFont9:160:-1:0
#1859:2057:TextFont9:0:-1:0
#2057:2059:TextFont9:160:-1:0
#2059:2067:TextFont9:0:-1:0
#2067:2076:TextFont9:160:-1:0
#2076:2082:TextFont9:0:-1:0
#2082:2084:TextFont9:160:-1:0
#2084:2092:TextFont9:0:-1:0
#2092:2100:TextFont9:160:-1:0
#2100:2106:TextFont9:0:-1:0
#2106:2108:TextFont9:160:-1:0
#2108:2116:TextFont9:0:-1:0
#2116:2124:TextFont9:160:-1:0
#2124:2125:TextFont9:0:-1:0
#2125:2183:TextFont9:160:-1:0
#2183:2292:TextFont9:0:-1:0
#2292:2307:TextFont9:160:-1:0
#2307:3005:TextFont9:0:-1:0
#3005:3052:TextFont9:160:-1:0
#3052:3645:TextFont9:0:-1:0
#3645:3756:TextFont9:160:-1:0
#3756:3783:TextFont9:0:-1:0
#3783:3898:TextFont9:160:-1:0
#3898:4294:TextFont9:0:-1:0
#4294:4327:TextFont9:160:-1:0
#4327:4330:TextFont9:0:-1:0
#4330:4344:TextFont9:160:-1:0
#4344:4887:TextFont9:0:-1:0
#4887:4888:TextFont9:160:-1:0
#4888:4912:TextFont9:0:-1:0
#4912:4959:TextFont9:160:-1:0
#4959:5032:TextFont9:0:-1:0
#5032:5034:TextFont9:160:-1:0
#5034:5042:TextFont9:0:-1:0
#5042:5051:TextFont9:160:-1:0
#5051:5056:TextFont9:0:-1:0
#5056:5058:TextFont9:160:-1:0
#5058:5066:TextFont9:0:-1:0
#5066:5074:TextFont9:160:-1:0
#5074:5079:TextFont9:0:-1:0
#5079:5081:TextFont9:160:-1:0
#5081:5089:TextFont9:0:-1:0
#5089:5097:TextFont9:160:-1:0
#5097:5098:TextFont9:0:-1:0
#5098:5155:TextFont9:160:-1:0
#5155:5239:TextFont9:0:-1:0
#5239:5254:TextFont9:160:-1:0
#5254:5702:TextFont9:0:-1:0
#5702:5705:TextFont9:160:-1:0
#5705:5798:TextFont9:0:-1:0
#5798:5800:TextFont9:160:-1:0
#5800:5808:TextFont9:0:-1:0
#5808:5817:TextFont9:160:-1:0
#5817:5823:TextFont9:0:-1:0
#5823:5825:TextFont9:160:-1:0
#5825:5833:TextFont9:0:-1:0
#5833:5841:TextFont9:160:-1:0
#5841:5847:TextFont9:0:-1:0
#5847:5849:TextFont9:160:-1:0
#5849:5857:TextFont9:0:-1:0
#5857:5865:TextFont9:160:-1:0
#5865:5866:TextFont9:0:-1:0
#5866:5924:TextFont9:160:-1:0
#5924:5935:TextFont9:0:-1:0
#5935:5950:TextFont9:160:-1:0
#5950:6622:TextFont9:0:-1:0
#6622:6637:TextFont9:160:-1:0
#6637:6640:TextFont9:0:-1:0
#6640:6690:TextFont10:0:-1:0
#6690:8723:TextFont9:0:-1:0
#8723:8810:TextFont9:160:-1:0
#8810:8831:TextFont9:0:-1:0
#8831:8935:TextFont9:160:-1:0
#8935:9027:TextFont9:0:-1:0
#9027:9031:TextFont9:160:-1:0
#9031:9082:TextFont10:0:-1:0
#9082:9210:TextFont9:0:-1:0
#9210:9252:TextFont10:0:-1:0
#9252:9427:TextFont9:0:-1:0
#9427:9468:TextFont10:0:-1:0
#9468:9732:TextFont9:0:-1:0
#9732:9838:TextFont10:0:-1:0
#9838:10110:TextFont9:0:-1:0
#10110:10215:TextFont10:0:-1:0
#10215:10496:TextFont9:0:-1:0
#10496:10552:TextFont10:0:-1:0
#10552:10943:TextFont9:0:-1:0
#10943:11021:TextFont10:0:-1:0
#11021:11118:TextFont9:0:-1:0
#11118:11156:default:-3:-3:0
#**  PhEDIT attribute block ends (-0003659)**/
