#ifndef RMPCI4294IOCTL_H_
#define RMPCI4294IOCTL_H_
#include <devctl.h>

#define	PCI4294_CMD_CODE		1
#define	PCI4294_getSN					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+0, unsigned short int )
#define	PCI4294_getPRM					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+1, unsigned short int )
#define	PCI4294_getState				__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+2, unsigned short int )

#define	PCI4294_setFreq					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+3, unsigned short int )
#define	PCI4294_setKCR					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+4, unsigned short int )
#define	PCI4294_setKCI					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+5, unsigned short int )

#define	PCI4294_writeKOP_0				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+6, unsigned short int )
#define	PCI4294_writeKOP_1				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+7, unsigned short int )
#define	PCI4294_writeKOP_2				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+8, unsigned short int )
#define	PCI4294_writeKOP_3				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+9, unsigned short int )

#define	PCI4294_read_BKOP				__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+10, unsigned short int )

#define	PCI4294_read_KPM				__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+11, unsigned short int )
#define	PCI4294_read_KVM				__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+12, unsigned short int )
#define	PCI4294_read_KMP				__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+13, unsigned short int )
#define	PCI4294_read_KOMP				__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+14, unsigned short int )

#define	PCI4294_write_KPM_blAdr1		__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+15, unsigned short int )
#define	PCI4294_write_KPM_blAdr2		__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+16, unsigned short int )
#define	PCI4294_write_KPM_blDat1		__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+17, unsigned short int )
#define	PCI4294_write_KPM_blDat2		__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+52, unsigned short int )
#define	PCI4294_write_KVM_blAdr1		__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+53, unsigned short int )
#define	PCI4294_write_KVM_blAdr2		__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+54, unsigned short int )
#define	PCI4294_write_KMP_blAdr			__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+55, unsigned short int )

#define	PCI4294_read_KVM_blDat1			__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+56, unsigned short int )
#define	PCI4294_read_KVM_blDat2			__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+57, unsigned short int )

#define	PCI4294_writeBU_I				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+18, unsigned short int )
#define	PCI4294_writeBU_O				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+19, unsigned short int )
#define	PCI4294_readBU_I				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+20, unsigned short int )
#define	PCI4294_readBU_O				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+21, unsigned short int )
#define	PCI4294_readFL_I				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+22, unsigned short int )
#define	PCI4294_readFL_O				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+23, unsigned short int )

#define	PCI4294_writeTab_I				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+24, unsigned short int )
#define	PCI4294_writeTab_O				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+25, unsigned short int )

#define	PCI4294_writeBKV				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+26, unsigned short int )
#define	PCI4294_writeBKV2				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+27, unsigned short int )
#define	PCI4294_writeBG				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+28, unsigned short int )

#define	PCI4294_readMem					__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+29, unsigned short int )
#define	PCI4294_writeMem				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+30, unsigned short int )
#define	PCI4294_readWord				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+33, unsigned short int )
#define	PCI4294_writeWord				__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+34, unsigned short int )
#define	PCI4294_readPK					__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+35, unsigned short int )
#define	PCI4294_writePK					__DIOTF  (_DCMD_CHR, PCI4294_CMD_CODE+36, unsigned short int )

#define	PCI4294_readRA					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+37, unsigned short int )
#define	PCI4294_writeRA					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+38, unsigned short int )
#define	PCI4294_readRD					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+39, unsigned short int )
#define	PCI4294_writeRD					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+40, unsigned short int )
#define	PCI4294_readRID					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+41, unsigned short int )
#define	PCI4294_writeRM					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+42, unsigned short int )
#define	PCI4294_readRDP					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+43, unsigned short int )
#define	PCI4294_readDP2					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+44, unsigned short int )
#define	PCI4294_writeRDV				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+45, unsigned short int )
#define	PCI4294_readRV					__DIOF  (_DCMD_CHR, PCI4294_CMD_CODE+46, unsigned short int )
#define	PCI4294_writeRV					__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+47, unsigned short int )
#define	PCI4294_writeRCA				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+58, unsigned short int )
#define	PCI4294_writeDV1				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+59, unsigned short int )
#define	PCI4294_writeDV2				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+60, unsigned short int )


#define	PCI4294_interruptReset			__DION  (_DCMD_CHR, PCI4294_CMD_CODE+48)
#define	PCI4294_FIFOreset				__DION  (_DCMD_CHR, PCI4294_CMD_CODE+49)
#define	PCI4294_ISPR					__DION  (_DCMD_CHR, PCI4294_CMD_CODE+50)

#define	PCI4294_interrConn				__DIOT  (_DCMD_CHR, PCI4294_CMD_CODE+51, unsigned short int )


#endif /*RMPCI4294IOCTL_H_*/
