#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include <time.h>

#include "rmPCI429_4ioctl.h"
#include  "libpci4294.h"

#define	USHORT	unsigned short int

int  hARINC;

USHORT  RID
	,numberSI
	,numberSO
	,nk
	,ap
	,interruptCode[32]
	;

long int li
		,lo
		,cycleNumber
		,errorsNonStop
		,errorsStop
	,interruptSOnumber
	,interruptTMRnumber
		;

struct sigaction action;
struct itimerspec timer;
timer_t	hTimer;

union buffer
{
	USHORT dataInt[0x808];
	unsigned long int dataUlong[0x404];
}u;



void hINT (int signo)
{
	USHORT codeRV, tmrKOP[2], chanN = 1;
	tmrKOP[0] = 7;
	tmrKOP[1] = 10;

	devctl(hARINC,PCI4294_readRV , &codeRV ,2, NULL);
	while(codeRV&0x800)
	{
		if(codeRV == 0x807
)
		{
			devctl(hARINC, PCI4294_writeKOP_1, &tmrKOP , 4, NULL);
			interruptTMRnumber ++;
		}
		else
			if(codeRV == 0x870
)
			{
				interruptSOnumber++;
				devctl(hARINC,PCI4294_readFL_O , &chanN ,2, NULL);
			}
		devctl(hARINC,PCI4294_readRV , &codeRV ,2, NULL);
	}

	devctl(hARINC,PCI4294_interruptReset , NULL , 0, NULL);


	return ;
}



void timerNonstop (int signo)
{
	short unsigned int	NKtemp;

	cycleNumber++;

	for( nk=0;nk<numberSI;nk++)
		for( ap=0;ap<256;ap++)
		{

			u.dataInt[0] = 2;
			u.dataInt[1] = 0x4000+(nk)*0x400+ap*2;
			devctl(hARINC, PCI4294_writeKOP_1, &u , 4, NULL);

			int tim = 0;
			u.dataInt[0]=1;
			do
			{
				devctl(hARINC, PCI4294_read_BKOP, &u , 10, NULL);
				tim++;
			}while((u.dataInt[0]!=0)&&(tim<2000));

			NKtemp = nk;
			if((RID==0x4020)&&(nk>=8)) NKtemp=nk-8;
			lo = ((0x8000+(NKtemp<<8)+(0xFF&(~ap)))<<16)|((NKtemp<<12)+ap);
		//expected code
			li = ((u.dataInt[3])<<16)|(u.dataInt[2]);
															//received code


			if  (li!=lo)
				errorsNonStop++;
		 }

  	printf(" \r");
 	printf("cycle#=%5ld;  errors=%3ld;  SO interrupts=%8d;  TMR interrupts=%8d\r",
 						cycleNumber,errorsNonStop,interruptSOnumber,interruptTMRnumber);

}

void timerErrorstop (int signo)
{
	USHORT	NKtemp;
	if(errorsStop==0)
  	{	
		cycleNumber++;

	  	for( nk=0;(nk<numberSI)&&(!errorsStop);nk++)
			for( ap=0;ap<256;ap++)
			{	
				u.dataInt[0] = 0x4000+(nk)*0x400+ap*2;
				devctl(hARINC, PCI4294_readPK, &u , 4, NULL);


				NKtemp = nk;
				if((RID==0x4020)&&(nk>=8)) NKtemp=nk-8;
				lo = ((0x8000+(NKtemp<<8)+(0xFF&(~ap)))<<16)|((NKtemp<<12)+ap);
		//expected code
				li = ((u.dataInt[1])<<16)|(u.dataInt[0]);
															//received code



				u.dataInt[0] = 0x4000+(nk)*0x400+ap*2;
				u.dataInt[1] = 0xaaaa;
				u.dataInt[2] = 0;
				devctl(hARINC, PCI4294_writePK, &u , 6, NULL);

				if  (li!=lo)
				{
 					printf("cycle#=%5ld  channel #=%2d  ap=%2d   lo=%8lx  li=%8lx\n",cycleNumber,nk,ap,lo,li);
					errorsStop++;
					break;
				}	

		 }
   		if(errorsStop==0) 	
   		//	printf("cycle#=%5ld interrupts=%10d =%10d\r",cycleNumber,interruptSOnumber,interruptTMRnumber);
 			printf("cycle#=%5ld;  SO interrupts=%8d;  TMR interrupts=%8d\r",
 						cycleNumber, interruptSOnumber,interruptTMRnumber);


  }

}



//**********************************************************************
//						MAIN 
//
int main(int argc, char *argv[])
{
	USHORT  ind1, sn, snI, i, tmpUshort;
	char msg[15]={'/','d','e','v','/','p','c','i','4','2','9','_','4','0'};
	int testWithErrorStop, testWithStub;
	int pid;

	printf("Enter serial # (decimal):")	;
	scanf("%5d",&snI);
	while(getchar()!=0xa);

	ind1 = 0;
	msg[13]='0';
	msg[14]='\0';
	do
	{
		hARINC=open(msg,0);
		if(hARINC!=-1)
		{
			devctl(hARINC, PCI4294_getSN , &u , 2, NULL);
			sn = u.dataInt[0];
			if(sn != snI)
				close(hARINC);
 		}
		else
		{
			printf("open error \n")	;
			return EXIT_SUCCESS;
		}
		msg[13]++;
		ind1++;
	}while ((ind1 < 8)&&(sn != snI));

	interruptSOnumber = 0;
	cycleNumber=0;
	errorsNonStop =0;
	errorsStop =0;

	//    
	memset (&action, 0, sizeof(action));
	action.sa_handler = hINT;
	sigaction (SIGUSR1, &action, NULL);

	//   
	pid = getpid();
	devctl(hARINC,PCI4294_interrConn , &pid , sizeof( pid ), NULL);

	//3.6.15.     
	devctl(hARINC,PCI4294_interruptReset , NULL , 0, NULL);

	// 
	printf("\nPCI429-4 parameters:\n");
	printf("  Serial Number - %d\n",sn);

	devctl(hARINC, PCI4294_readRID , &u , 2, NULL);
	RID = u.dataInt[0];
	printf("  ID - 0x%04x\n",RID)	;
		devctl(hARINC, PCI4294_interruptReset , &u , 0, NULL);
	
	devctl(hARINC, PCI4294_getPRM , &u , 6, NULL);
	printf("  PLX ports - 0x%04x\n  IO ports - 0x%04x\n  IRQ - 0x%x\n",u.dataInt[0],u.dataInt[1],u.dataInt[2]);

	switch (RID)
	{
	case 0x4010:
		numberSI = 8;
		numberSO = 8;
		break;

	case 0x4020:
		numberSI = 16;
		numberSO = 8;
		break;

	case 0x4030:
		numberSI = 16;
		numberSO = 16;
		break;

	default:
		break;
	}
	printf("  number of input channels - %d\n",numberSI)	;
	printf("  number of output channels - %d\n",numberSO)	;


	//
	printf("\nEnter test type [0-nonstop / 1-error stop]:\n")	;
	scanf("%1d",&testWithErrorStop);
	while(getchar()!=0xa);

	printf("                [0-internal / 1-with stub]:\n")	;
	scanf("%1d",&testWithStub);
	while(getchar()!=0xa);


	i = 0;
	do
	{
		devctl(hARINC, PCI4294_getState , &u , 8, NULL);
		i++;
	}while ((u.dataInt[0]!=0xbcc)&&(i<2000));

	if(u.dataInt[0]!=0xbcc)
	{
		printf("getState = %xh %xh %xh %xh %d\n",u.dataInt[0],u.dataInt[1],u.dataInt[2],u.dataInt[3],i);
		close(hARINC);
		return EXIT_SUCCESS;
	}

	//
	u.dataInt[0] = 0x6000;
	devctl(hARINC, PCI4294_writeRM , &u , 2, NULL);

	tmpUshort = numberSO + 16;
	if (testWithStub==0)
	{
		for(i = 0; i<numberSI; i++)
			u.dataInt[i] = 3;
		for(i = numberSI; i<16; i++)
			u.dataInt[i] = 0;
		for(i = 16; i<tmpUshort; i++)
			u.dataInt[i] = 3;
		for(i = tmpUshort; i<32; i++)
			u.dataInt[i] = 0;
		devctl(hARINC, PCI4294_setFreq , &u , 64, NULL);

		u.dataInt[0] = 0x89;
	}
	else
	{
		for(i = 0; i<numberSI; i++)
			u.dataInt[i] = 2;
		for(i = numberSI; i<16; i++)
			u.dataInt[i] = 0;
		for(i = 16; i<tmpUshort; i++)
			u.dataInt[i] = 2;
		for(i = tmpUshort; i<32; i++)
			u.dataInt[i] = 0;
		devctl(hARINC, PCI4294_setFreq , &u , 64, NULL);

		u.dataInt[0] = 0x80;
	}
	devctl(hARINC, PCI4294_setKCR, &u , 2, NULL);


	//cyclic output
	for(nk=2;nk<=numberSO; nk++)
	{
		u.dataInt[0] = nk;
		u.dataInt[1] = 0x900;
		devctl(hARINC, PCI4294_writeBU_O, &u , 4, NULL);
	}
	u.dataInt[0] = 1;
	u.dataInt[1] = 0x8900;       //with interrupts
	devctl(hARINC, PCI4294_writeBU_O, &u , 4, NULL);

	//cyclic input
	for(nk=1;nk<=numberSI; nk++)
	{
		u.dataInt[0] = nk;
		u.dataInt[1] = 0x1900;
		u.dataInt[2] = 0x10;
		devctl(hARINC, PCI4294_writeBU_I, &u , 6, NULL);
	}

	//output data
	u.dataInt[1] = 0x100;
	for(nk=0;nk<numberSO; nk++)
	{
		for(ap=0; ap<0x100; ap++)
		{
			u.dataInt[2+ap*2] = (nk<<12)+ap;
			u.dataInt[3+ap*2] = 0x8000+(nk<<8)+(0xFF&(~ap));
		}
		u.dataInt[0] = nk+1;
		devctl(hARINC, PCI4294_writeBKV, &u , 0x404, NULL);
	}


	//3.2.3.     (  KCI).
	u.dataInt[0] = 0xf310;
	devctl(hARINC, PCI4294_setKCI, &u , 2, NULL);

	i = 0;
	do
	{
		devctl(hARINC, PCI4294_getState , &u , 8, NULL);
		i++;
	}while ((u.dataInt[0]!=0xbce)&&(i<2000));

	if((u.dataInt[0]!=0xbce)||(u.dataInt[1]!=0xf310)||(u.dataInt[3]!=0))
	{
		printf("getState = 0x%04x 0x%04x 0x%04x 0x%04x %d\n",u.dataInt[0],u.dataInt[1],u.dataInt[2],u.dataInt[3],i);
		devctl(hARINC, PCI4294_readRID , &u , 2, NULL);
		devctl(hARINC, PCI4294_interruptReset , &u , 0, NULL);
		close(hARINC);
		return EXIT_SUCCESS;
	}

		devctl(hARINC,PCI4294_interruptReset , NULL , 0, NULL);

	//     10*5
/*
	u.dataInt[0] = 7;
	u.dataInt[1] = 10;
	devctl(hARINC, PCI4294_writeKOP_1, &u , 4, NULL);
	
	identical :

*/

	tmpUshort = 10;
	kpt(hARINC,tmpUshort );			

	printf("\nPress ENTER for quit \n")	;
	timer_create ( CLOCK_REALTIME,  NULL, &hTimer);

   	timer.it_value.tv_sec = 0;
    timer.it_value.tv_nsec = 200000000;
    timer.it_interval.tv_sec = 0;
    timer.it_interval.tv_nsec = 200000000;


	if(testWithErrorStop==0)
	{
		action.sa_handler = &timerNonstop;
		action.sa_flags = 0;
	}
	else
	{
		action.sa_handler = &timerErrorstop;
		action.sa_flags = 0;
	}

	sigaction(SIGALRM, &action, NULL);

	timer_settime(	hTimer,
					0,
					&timer,
					NULL);

	while((getchar()!=0xa)&&(!errorsStop));


	

   	timer.it_value.tv_sec = 0;
    timer.it_value.tv_nsec = 0;
    timer.it_interval.tv_sec = 0;
    timer.it_interval.tv_nsec = 0;
	timer_settime(	hTimer,
					0,
					&timer,
					NULL);

	devctl(hARINC, PCI4294_readRID , &u , 2, NULL);

	close(hARINC);

	return EXIT_SUCCESS;
}
/*
# gcc -c pci429_4func.c
# ar rc libpci4294.a pci429_4func.o

# gcc -c tpsPCI429_4.c
# gcc  tpsPCI429_4.o -L. -lpci4294 -o tpsPCI429_4.out
# ./tpsPCI429_4.out
*/
