#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "rmPEX429.h"

int hARINC, ri;
union buffer
{
	unsigned short int dataInt[0x210 ];
	unsigned long int dataUlong[ 0x100];
}  ;
 union buffer  u;
unsigned long int receivedParameter[ 0x100];

void hINT (int signo)
{
 		short unsigned int w, inRI;

		devctl(hARINC,pci429_getRGF_int ,&w, 2, NULL);
		if(w&0x1000)
		{
			do{
					devctl(hARINC,pci429_getRI , &inRI ,2, NULL);
					ri++;
	 			}while ( inRI!=0);
	 		ri--;

 		}
 		devctl(hARINC,pci429_resetInt , NULL , 0, NULL);
  		return ;
}

int
main(int argc, char**argv)
{
	int i, i1, nbytes;
 	struct sigaction action;
	int pid;

//1.1  .
 	hARINC=open("/dev/PEX429_0",0);
	printf (" hARINC = %xh \n", hARINC);

	if (hARINC == -1)
			return 0;

//    

    memset(&action, 0, sizeof(action));
 	action.sa_handler = hINT;
    sigaction(SIGUSR1, &action, NULL);

//   

	pid = getpid();
   devctl(hARINC,pci429_setEvent , &pid , sizeof( pid ), NULL);

//3.2.1.   .
 	devctl(hARINC, pci429_RESET , &u , 2, NULL);
		printf (" rid = %xh   \n", u.dataInt[0] );

//3.2.2. .
	u.dataInt[0] = 0xf88;
	u.dataInt[1] = 0;
	for (i=0; i<16; i++)
		u.dataInt[2+i] = 2;
	devctl(hARINC, pci429_INIT , &u ,36, NULL);

//3.4.1.     ( )
	u.dataInt[0] = 8;
	u.dataInt[1] = 1;
	u.dataInt[2] = 255;
	u.dataInt[3] = 1;
	u.dataInt[4] = 0;
	u.dataInt[5] = 0;
	u.dataInt[6] = 0;
	u.dataInt[7] = 0x55;

	nbytes = (7+1)*2;
	devctl(hARINC, pci429_TAB_SO_F , &u , nbytes, NULL);

//3.4.5.   (   )
	u.dataInt[0] = 8;
	u.dataInt[1] = 1;
	for (i=1; i<=0x100; i++)
	{
		u.dataInt[2] = i;
		u.dataUlong[2] =((i-1)&0xff)|((4)<<8)|(((~(i-1))&0xff)<<16)|(((~4)&0xff)<<24);
		devctl(hARINC,pci429_WRITE_PRM_F, &u , 12, NULL);
//		printf (" %8x ", u.dataUlong[2] );
	}


//3.3.2.        
	u.dataInt[0] = 8;
	u.dataInt[1] = 2;
	u.dataInt[2] = 0;
	u.dataInt[3] = 0;
	u.dataInt[4] = 0x100;
	for (i=0; i<0x100; i++)
		u.dataInt[5+i] = i;

	nbytes =(5+0x100)*2;
	devctl(hARINC, pci429_TAB_SI_SS , &u , nbytes, NULL);

//3.4.3.  
	u.dataInt[0] = 8;
	u.dataInt[1] = 0x0;
	u.dataInt[2] = 0;
	devctl(hARINC, pci429_puskSO , &u , 6, NULL);

//3.3.3.  
	u.dataInt[0] = 8;
	u.dataInt[1] = 0xb2;
	devctl(hARINC, pci429_puskSI , &u , 4, NULL);


//3.3.6.      (1- )
	for (i1=0; ri<2; i1++)
	{
		for (i=0; i<0x100; i++)
		{
			u.dataInt[0] = 8;
			u.dataInt[1] = 2;
			u.dataInt[2] = i;
			devctl(hARINC, pci429_READ_PRM_SS_nc, &u , 6, NULL);
			receivedParameter[i] = u.dataUlong[0];
		}
	}

	for (i=0; i<0x100; i++)
		printf (" %8lx ",receivedParameter[i] );
	printf ("\n" );

	printf ("ri = %d \n",ri);

//3.3.4.  
	u.dataInt[0] = 8;
	devctl(hARINC, pci429_stopSI , &u , 2, NULL);

//3.4.4.  
	u.dataInt[0] = 8;
	devctl(hARINC, pci429_stopSO , &u , 2, NULL);

//3.2.3.  .
 	devctl(hARINC, pci429_STOP , NULL , 0, NULL);

	devctl(hARINC,pci429_interruptStop,NULL,0,NULL );


	//1.2.  .
	close(hARINC);
 	return 0;
}

