//
//ioctlDD64.h
//

#ifndef __INTRFACE_H__
#define __INTRFACE_H__

#define FILE_DEVICE_DD64_PCI  0x8000

// Define Interface reference/dereference routines for
// Interfaces exported by IRP_MN_QUERY_INTERFACE

#define DD64_PCI_IOCTL(index) \
    CTL_CODE(FILE_DEVICE_DD64_PCI, index, METHOD_BUFFERED, FILE_READ_DATA)

#define DD64PCI_GET_RI \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_TIMER \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_SET_TIMER \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_SET_RA \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_RD \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_SET_RD \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_INDIRECT_REGISTR \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_SET_INDIRECT_REGISTR \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_CONFIG_DO \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CONFIG_DI \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CONFIG_DS \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x80a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_MODE_DO \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x80b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_SET_MODE_DO \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x80c, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_SET_DO \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x80d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CLEAR_DO \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x80e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_WRITE_DO_GROUP \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x80f, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_GET_MATRIX_HD_NUMBER \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_SET_ACTIVE_MATRIX \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x811, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_ACTIVE_MATRIX \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x812, METHOD_BUFFERED, FILE_ANY_ACCESS)
	
#define DD64PCI_GET_DS \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x814, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_DS_GROUP \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x815, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_CREATE_FILTER1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x816, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CREATE_FILTER2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x817, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CREATE_FILTER3 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x818, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_CONFIG_FILTER1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x819, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_CONFIG_FILTER2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x81a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_CONFIG_FILTER3 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x81b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CREATE_EXTERNAL_FILTER1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x81c, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CREATE_EXTERNAL_FILTER2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x81d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_CREATE_EXTERNAL_FILTER3 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x81e, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_CONFIG_EXTERNAL_FILTER1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x81f, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_CONFIG_EXTERNAL_FILTER2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x820, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_CONFIG_EXTERNAL_FILTER3 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x821, METHOD_BUFFERED, FILE_ANY_ACCESS)
	

#define DD64PCI_WRITE_RDIVT \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x822, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_RDIVT \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x823, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_WRITE_TMRCMP \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x824, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_WRITE_DACDATA \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x825, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_WRITE_DACADR \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x826, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_WRITE_DACCTRL \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x827, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_DACST \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x828, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_WRITE_ADCDATA1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x829, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_ADCDATA1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x82a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_WRITE_ADCCTRL1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x82b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_ADCSTATE1 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x82c, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_START_INT \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x82d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_STOP_INT \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x82e, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_ADC1_RANGE_CHANNELS_0_3 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x82f, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC1_RANGE_CHANNELS_4_7 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x830, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC1_RANGE_ONE_CHANNEL \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x831, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC1_CHANNELS_NUMBER_AND_MODE \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x832, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC1_CHANNEL_PUSK \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x833, METHOD_BUFFERED, FILE_ANY_ACCESS)


#define DD64PCI_WRITE_ADCDATA2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x834, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_ADCDATA2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x835, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_WRITE_ADCCTRL2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x836, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_ADCSTATE2 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x837, METHOD_BUFFERED, FILE_ANY_ACCESS)


#define DD64PCI_ADC2_RANGE_CHANNELS_0_3 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x838, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC2_RANGE_CHANNELS_4_7 \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x839, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC2_RANGE_ONE_CHANNEL \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x83a, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC2_CHANNELS_NUMBER_AND_MODE \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x83b, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_ADC2_CHANNEL_PUSK \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x83c, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define  DD64PCI_GET_SN \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x83d, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_GET_PARAM \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x83e, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_INIT_TIMER \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x83f, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define DD64PCI_READ_DACCFG \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x840, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define DD64PCI_READ_ADCCFG \
    CTL_CODE(FILE_DEVICE_DD64_PCI, 0x841, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif // __INTRFACE_H__
