// testMD64.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "testMD64.h"


int main(int argc, char* argv[])
{
	if(argc<2)
	{

		printf("\n");
		printf("arguments error\n\n");
		printf("call:\n\n");
		printf("   testMD64.exe sn\n");
		printf("\n");
		printf("            sn  - md64-PCI serial number\n");
		printf("\n");
		printf("Description:\n");
		printf("Test writes '1' sequentially into all  digital output \n");
		printf("channels. States of all DS are printed on the screen.\n");
		printf("The stub is needed for this test.\n");
		printf("\n");
		printf("\n");

		printf("in Russian:\n");
		printf(":\n\n");
		printf("   testMD64.exe sn\n");
		printf("\n");
		printf("            sn  -   \n");
		printf("\n");
		printf(":\n");
		printf(" '1'       \n");
		printf(".         \n");
		printf(" .\n");
		printf("   .\n");
		printf("\n");

		return 0;
	}
	sscanf(argv[1],"%d",&serialNumber);

	
	hMD64 =  OpenDeviceBySN ( serialNumber, &Error);

	if(hMD64==INVALID_HANDLE_VALUE )
	{
		printf("\nModule MD64-PCI (serial # %d)  wasn't detected.\n\n", serialNumber);
		return 0;
	}

	printf("\n\n=======MD64-PCI: DO-DI test======\n");


	// 
	DeviceIoControl (
		hMD64 ,
		DRVNT_MD64_IOCTL_READ_RID,
		NULL,     
		0 ,                                  
		&bufOutputUSHORT,
		2 ,                                  
		&nOutput ,
		NULL  );
	printf("\nRID = 0x%x \n", bufOutputUSHORT);

	//printf("\nDevice reset\n\n");


	hEvent=CreateEvent(NULL,TRUE,FALSE,"testMD64event");
	hThread=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)interruptService,
              NULL,0,&dwThreadID);

	DeviceIoControl (
		hMD64 ,
		DRVNT_MD64_IOCTL_INT_INIT,
		&hEvent,
		sizeof(hEvent) ,
		NULL,
		0,
		&nOutput ,
		NULL  );

	
	bufInputUSHORT = 0x2400;
	DeviceIoControl (
		hMD64 ,
		DRVNT_MD64_IOCTL_WRITE_RM,
		&bufInputUSHORT,
		2 ,
		NULL,
		0,
		&nOutput ,
		NULL  );
	printf("\nInterrupt sources: RIK#3 and RIK#6\n\n");



	printf("\n");
	printf("16                             1 ");
	printf("16                             1\n");
	printf("===============DOK============== ");
	printf("===============DIK==============\n");

	interruptNumber=0;

	for(i = 16; i>0; i--)
	{



			bufInputUSHORT = i;
			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_set_bit_RDOK,
				&bufInputUSHORT,
				2 ,
				NULL,
				0,
				&nOutput ,
				NULL  );
			for(ii=16; ii>0; ii--)
			{
				if(i==ii)
					printf(" 1");
				else
					printf(" 0");
			}
	
			printf(" ");

			Sleep(20);

			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_READ_RDIK,
				NULL,     
				0 ,                                  
				&bufOutputUSHORT,
				2 ,                                  
				&nOutput ,
				NULL  );

			for(ii=16; ii>0; ii--)
			{
				if(bufOutputUSHORT&0x8000)
					printf(" 1");
				else
					printf(" 0");
				bufOutputUSHORT=bufOutputUSHORT<<1;
			}


			printf("\n");

			bufInputUSHORT = i;
			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_clr_bit_RDOK,
				&bufInputUSHORT,
				1 ,
				NULL,
				0,
				&nOutput ,
				NULL  );
	}


	
	
	//	printf("\n");
	printf("===============DOT============== ");
	printf("===============DIT==============\n");
	for(i = 16; i>0; i--)
	{


			bufInputUSHORT = i;
			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_set_bit_RDOT,
				&bufInputUSHORT,
				2 ,
				NULL,
				0,
				&nOutput ,
				NULL  );
			for(ii=16; ii>0; ii--)
			{
				if(i==ii)
					printf(" 1");
				else
					printf(" 0");
			}
	
			printf(" ");

			Sleep(20);

			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_READ_RDIT,
				NULL,     
				0 ,                                  
				&bufOutputUSHORT,
				2 ,                                  
				&nOutput ,
				NULL  );

			for(ii=16; ii>0; ii--)
			{
				if(bufOutputUSHORT&0x8000)
					printf(" 1");
				else
					printf(" 0");
				bufOutputUSHORT=bufOutputUSHORT<<1;
			}


			printf("\n");

			bufInputUSHORT = i;
			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_clr_bit_RDOT,
				&bufInputUSHORT,
				2 ,
				NULL,
				0,
				&nOutput ,
				NULL  );
	}

	printf("\n");

	printf("\ninterrupt number = %d (2)\n", interruptNumber);
	printf("last code RINT in interrupt = 0x%x (0x1c00)\n", codeRINTinterrupt);

	printf("\n");


	printf("===============DOK============== ");
	printf("===============DIK==============\n");

	bufInputUSHORT = 1;
	for(i = 1; i<17; i++)
	{
			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_WRITE_RDOK,
				&bufInputUSHORT,
				2 ,
				NULL,
				0,
				&nOutput ,
				NULL  );
			for(ii=16; ii>0; ii--)
			{
				if(i==ii)
					printf(" 1");
				else
					printf(" 0");
			}
	
			printf(" ");

			Sleep(20);

			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_READ_RDIK,
				NULL,     
				0 ,                                  
				&bufOutputUSHORT,
				2 ,                                  
				&nOutput ,
				NULL  );

			for(ii=16; ii>0; ii--)
			{
				if(bufOutputUSHORT&0x8000)
					printf(" 1");
				else
					printf(" 0");
				bufOutputUSHORT=bufOutputUSHORT<<1;
			}

			bufInputUSHORT=bufInputUSHORT<<1;

			printf("\n");

	}


	printf("===============DOT============== ");
	printf("===============DIT==============\n");

	bufInputUSHORT = 1;
	for(i = 1; i<17; i++)
	{
			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_WRITE_RDOT,
				&bufInputUSHORT,
				2 ,
				NULL,
				0,
				&nOutput ,
				NULL  );
			for(ii=16; ii>0; ii--)
			{
				if(i==ii)
					printf(" 1");
				else
					printf(" 0");
			}
	
			printf(" ");

			Sleep(20);

			DeviceIoControl (
				hMD64 ,
				DRVNT_MD64_IOCTL_READ_RDIT,
				NULL,     
				0 ,                                  
				&bufOutputUSHORT,
				2 ,                                  
				&nOutput ,
				NULL  );

			for(ii=16; ii>0; ii--)
			{
				if(bufOutputUSHORT&0x8000)
					printf(" 1");
				else
					printf(" 0");
				bufOutputUSHORT=bufOutputUSHORT<<1;
			}

			bufInputUSHORT=bufInputUSHORT<<1;

			printf("\n");

	}

	printf("\n");

	printf("\ninterrupt number = %d (4)\n", interruptNumber);
	printf("last code RINT in interrupt = 0x%x (0x3800)\n", codeRINTinterrupt);

	printf("\n");

	return 0;
}

DWORD WINAPI interruptService(LPVOID)
{
	for(;;)
	{
		WaitForSingleObject(hEvent,INFINITE);
		ResetEvent(hEvent);
		interruptNumber++;

		DeviceIoControl (
			hMD64 ,
			DRVNT_MD64_IOCTL_INT_RINT,
			NULL,     
			0 ,                                  
			&codeRINTinterrupt,
			2 ,                                  
			&nOutput ,
			NULL  );

	}

  return 0;

}