#include <signal.h>
#include <stdio.h>
#include <string.h>
#include "MD64_qnx.h"
#include <time.h>

#define BIT       //bit operation enable

 	int hMD64;     
	long int   ri=0, ch_prv=0;

	unsigned short int	rintr, rdok, rdot, rdk, rdt, rdik, rdit, int16, dataInt[3];
 
  	struct sigaction		action;
  	struct	itimerspec	timer;
  
  	timer_t					hTimer;
	
	int pid;

	void hINT (int signo)
 	{
	 	devctl(hMD64,md64_getRINT_int ,&rintr, 2, NULL);
 		ri++;
  		return ;
	}
 

void timerErrorstop (int signo)
{
	ch_prv++;

 	devctl(hMD64, md64_getRDIK , &rdik , 2, NULL);
 	devctl(hMD64, md64_getRDIT , &rdit, 2, NULL);

	if((rdik!=rdok)||(rdit!=rdot))
	{
 						timer.it_value.tv_sec = 0;
   						timer.it_value.tv_nsec = 0;
      					timer.it_interval.tv_sec = 0;
    						timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
	printf(" \r");
  	printf("count=%5d rdik=%x  rdok =%x rdit =%x rdot =%x                 \n",ch_prv,rdik,rdok,rdit,rdot);
  	printf("Press ENTER for quit");
  	return;
	}


 devctl(hMD64, md64_readRDOK, &rdk , 2, NULL);
 devctl(hMD64, md64_readRDOT, &rdt , 2, NULL);
 

	if((rdk!=rdok)||(rdt!=rdot))
	{
   						timer.it_value.tv_sec = 0;
   						timer.it_value.tv_nsec = 0;
      					timer.it_interval.tv_sec = 0;
    						timer.it_interval.tv_nsec = 0;
         					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);
	printf(" \r");
  	printf("count=%5d rdk=%x  rdok =%x rdt =%x rdot =%x                 \n",ch_prv,rdk,rdok,rdt,rdot);
  	printf("Press ENTER for quit");
  	return;
	}

	printf(" \r");
  	printf("count=%6d ri=%6d  rint_K = %4x   rint_T = %4x            ",ch_prv,ri, (rintr&0xff00)>>8, rintr&0xff);

#ifdef  BIT
	 dataInt[0] =17- int16;
		devctl(hMD64, md64_clr_bit_RDOK , &dataInt , 2, NULL);

	 dataInt[0] = int16;
		devctl(hMD64, md64_clr_bit_RDOT , &dataInt , 2, NULL);

#endif

	int16 --;

	if(int16 == 0)
	{
		int16 = 16;
		rdok = 1;
		rdot = 0x8000;
	}
else
{
	rdok = rdok<<1;
	rdot  = rdot>>1;
}

#ifdef BIT

	 dataInt[0] = 17 - int16;
		devctl(hMD64, md64_set_bit_RDOK , &dataInt , 2, NULL);

	 dataInt[0] = int16;
		devctl(hMD64, md64_set_bit_RDOT , &dataInt , 2, NULL);

#else

 	devctl(hMD64, md64_setRDOK , &rdok , 2, NULL);
 	devctl(hMD64, md64_setRDOT , &rdot , 2, NULL);

#endif
 }

 
main ()
{
	int  snI, ind1;

    	char msg[14]={'/','d','e','v','/','M','D','6','4','_'};
    
    	printf("enter serial # :")	;
		scanf("%5d",&snI);
     	while(getchar()!=0xa);
		msg[11]='\0';

		ind1 = 0;
		msg[10]='0';
		do
		{
			hMD64=open(msg,0);
			msg[10]++;
			ind1++;
			if(hMD64!=-1)
			{
 					devctl(hMD64, md64_getSN , &dataInt , 2, NULL);
 			}
		}while ( (ind1 < 8)&&( dataInt[0] != snI));

	
	if( (hMD64 == -1)||(ind1 >= 8))
	{
		printf("open error \n")	;
		return 0;
	}
	printf (" hMD64 = %x \n", hMD64);
	
 devctl(hMD64,md64_getRID , &dataInt , 2, NULL);
 		printf("RID = %xh\n", dataInt[0])	;

 devctl(hMD64, md64_getRSRC , &dataInt , 6, NULL);
 		printf("= %xh  = %xh  = %xh\n", dataInt[0], dataInt[1], dataInt[2])	;

    memset(&action, 0, sizeof(action));
 	action.sa_handler = hINT;
    sigaction(SIGUSR1, &action, NULL);
    
    //передача драйверу идентификатора процесса
    
	pid = getpid();
   	devctl(hMD64,md64_setEvent , &pid , sizeof( pid ), NULL);

	printf("Press ENTER for quit \n")	;
	
	
	timer_create ( CLOCK_REALTIME,  NULL, &hTimer);
	
	

	dataInt[0] = 0;  //0xffff;
 	devctl(hMD64,md64_setRMOD , &dataInt , 2, NULL);
	dataInt[0] = 0xffff;
 	devctl(hMD64, md64_setRM , &dataInt , 2, NULL);
  

	int16 = 16;
	rdok = 1;
	rdot = 0x8000;

	devctl(hMD64, md64_setRDOK , &rdok , 2, NULL);
	devctl(hMD64, md64_setRDOT , &rdot , 2, NULL);

							
   	timer.it_value.tv_sec = 0;
    	timer.it_value.tv_nsec = 200000000;
    	timer.it_interval.tv_sec = 0;
    	timer.it_interval.tv_nsec = 200000000;

							
							action.sa_handler = &timerErrorstop;
    							action.sa_flags = 0;
    							sigaction(SIGALRM, &action, NULL);
    
	        					timer_settime(	hTimer,
         											0,
         											&timer,
         											NULL);

  	while(getchar()!=0xa);
  
  	
 		

  	close(hMD64);
}


/*	
cd ../home/vera/MD64
gcc TVK_md64QNX.c -o TVK_md64QNX.out
./TVK_md64QNX.out
*/
#/** PhEDIT attribute block
#-11:16777215
#0:39:TextFont9:0:-3:0
#39:426:TextFont9:0:-1:0
#426:436:TextFont10:0:-1:0
#436:437:TextFont9:0:-1:0
#437:446:TextFont09:0:-1:0
#446:3027:TextFont9:0:-1:0
#3027:3035:TextFont09:0:-1:0
#3035:3298:TextFont9:0:-1:0
#3298:3376:TextFont10:0:-1:0
#3376:4213:TextFont9:0:-1:0
#4213:4214:TextFont10:0:-1:0
#4214:4317:TextFont9:0:-1:0
#4317:4355:default:-3:-3:0
#**  PhEDIT attribute block ends (-0000442)**/
