#include <ncurses.h>
#include "ltmk.c"
#define RT_ADDR 10 /*   */

TTmkConfigData tmkCfg;
TTmkEventData tmkEvD;
int hTmk;
int events;
unsigned int  awBuf[32];
unsigned int i;

int main(int argc, char *argv[])
{

  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;
  initscr();
  timeout(0);		
  if (TmkOpen())
  {
    printw("TmkOpen() failed!\n");    
    goto stop;
  }
  printw("TmkOpen() successfull!\n");

  if (tmkconfig(hTmk) != 0)
  {
    printw("tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",hTmk);
    goto stop;   
  }

  tmkselect(hTmk);
  tmkgetevd(&tmkEvD);
/*          */
  rtreset();
  rtdefaddress(RT_ADDR);

  
/*      */
  printw("For an exit from a cycle press any key\n");

  while (getch()==ERR)
  {
    events = tmkwaitevents(1<<hTmk, 0);
    tmkgetevd(&tmkEvD);
    if (events==(1<<hTmk))
    {	
      if (tmkEvD.nInt==1)
      {	
        if (tmkEvD.rt.wCmd == CMD_SYNCHRONIZE)
        {
          printw("The command of control mode ' Synchronization is received\n");
          rtdefsubaddr(RT_RECEIVE, 16);
          printw("Zero word 16 address: %04X\n",rtgetw(0));
        }
        else
        {
          printw("The command of control mode is received: %04X\n");		
        }
      }

      if (tmkEvD.nInt==2)
      {
        printw("RT has found out a error in the command addressed to it\n");
        printw("Word of a condition RT: %04X\n");
      }  
    }   
  }
 
  stop:
  timeout(-1);
  getch();
  endwin();
  tmkdone(hTmk);
  TmkClose();
  return 0;
}
