#include <ncurses.h>
#include "ltmk.c"
#define RT_ADDR 10 /*   */

unsigned short int i;
TTmkEventData tmkEvD,tmkEvD1 ;
unsigned short int awRTBuf[32];
unsigned short int awBCBuf[64];
int kb=ERR;  
int bc=0;
int rt=1;
int events;
char c;

int main()
{
  initscr();
  noecho();
  timeout(0);
  keypad(stdscr,TRUE);
  bool flag=TRUE;

  if (TmkOpen())
  {
    printw("TmkOpen() failed!\n");
    goto stop;    
  }
  printw("TmkOpen() successfull!\n");

  mvprintw (2,2,"Number BC? (UP-DOWN-Q)\n");
  mvprintw(3,2,"0\n");
  while (flag)
  {
    c=getch();
    switch(c)
    {
      case KEY_UP:
        if (bc<8) {bc++;}
      break;
      case KEY_DOWN:
        if (bc>0) {bc--;}
      break;
      case 'q':
        flag=false;
      break;
      case 'Q':
        flag=false;
      break;
    }
  mvprintw (3,2,"%d\n",bc);
  }

  flag=TRUE;
  mvprintw (4,2,"Number RT? (UP-DOWN-Q)\n");
  mvprintw(5,2,"1\n");

  while (flag)
  {
    c=getch();
    switch(c)
    {
      case KEY_UP:
        if (rt<8) {rt++;}
      break;
      case KEY_DOWN:
        if (rt>0) {rt--;}
      break;
      case 'q':
        flag=false;
      break;
      case 'Q':
        flag=false;
      break;
    }
  mvprintw (5,2,"%d\n",rt);
  }


  if (tmkconfig(bc) != 0)
  {
    printw( "tmkconfig() failed!\n") ;
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",bc);
    goto stop;
  }


  if (tmkconfig(rt) != 0)
  {
    printw("tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",rt );
    goto stop;
   
  }

/*          */
  tmkselect(rt);
  tmkgetevd(&tmkEvD1);
  rtreset();
  rtdefaddress(RT_ADDR);
  for (i = 0; i < 32; ++i)
    awRTBuf[i] = ~i;
/*    17    */
/*     rtunlock()    rtdefsubaddr() */
  rtlock(RT_TRANSMIT, 17);
  while (rtbusy());
  rtputblk(0, awRTBuf, 32);
  rtdefsubaddr(RT_RECEIVE, 16);
  
/*      */  
  tmkselect(bc);
  tmkgetevd(&tmkEvD);  
  bcreset();

/*   0    32   16   */
  bcdefbase(0);
  awBCBuf[0] = CW(RT_ADDR, RT_RECEIVE, 16, 32);
  for (i = 1; i <= 32; ++i)
    awBCBuf[i] = i;
  bcputblk(0, awBCBuf, 64);

/*   1    32   17   */
  bcdefbase(1);
  bcputw(0, CW(RT_ADDR, RT_TRANSMIT, 17, 32));

 
/*    0    ,    */
/*   */
  bcdefbus(BUS_A);
  bcstart(0, DATA_BC_RT);

  tmkselect(rt);
/*      16 */  
  printw("For an exit from a cycle press any key\n");
 
  while (!rtbusy() && kb==ERR)
  {
    kb=getch();
  }
  if (kb!=ERR) {printw("No Data Receive\n");goto stop;}

/*      16 */
  while (rtbusy());
  rtdefsubaddr(RT_TRANSMIT, 17); 
  tmkselect(bc);
  events=tmkwaitevents(1<<bc, -1);
  tmkgetevd(&tmkEvD);

  if (events==(1<<bc))
  {
    if (tmkEvD.nInt==1)    
      printw ("The command of transfer of data BC-RT is executed sucessfully\n");

    if (tmkEvD.nInt==2)
    {
      printw("At performance of transfer of the data BC-RT:\n");
	
      if (tmkEvD.bc.wResult & S_ERAO_MASK)		
        printw("The error in a field of the address received RW is found out\n");
				
      if (tmkEvD.bc.wResult & S_MEO_MASK)
        printw("The error of a code 'Manchester - 2' is found out at answer RT\n");
				
      if (tmkEvD.bc.wResult & S_EBC_MASK)		
        printw("The error of the echo - control over transfer BC is found out\n");			
		
      if (tmkEvD.bc.wResult & S_TO_MASK)		
        printw("It is not received the answer from RT\n");
				
      if (tmkEvD.bc.wResult & S_IB_MASK)		
        printw("The established bits in received RW are found out\n");
	    				
    }	 
  }
  
  
/*    1    ,    */
/*   */
  bcdefbus(BUS_A);
  bcstart(1, DATA_RT_BC);
  tmkselect(rt);
/*      17 */ 		
  kb=ERR;
  while (!rtbusy() && kb==ERR)
  {
    kb=getch();
  }
  if (kb!=ERR) {printw("No Data Transmit\n");goto stop;}

/*      17 */
  while (rtbusy());  
  
  tmkselect(bc);
  events=tmkwaitevents(1<<bc, -1);
  tmkgetevd(&tmkEvD);
  if (events==(1<<bc))
  {
    if (tmkEvD.nInt==1)
    {
      printw ("The command of transfer of data RT-BC is executed sucessfully\n");
      bcgetblk(2, awBCBuf, 32);
      printw("BC The data are received:\n");
      for (i = 0; i < 32; ++i)
      { 
        if ((i & 3) == 0)
          printw("\n");
        printw(" %04X", awBCBuf[i]);
      }	
    }

    if (tmkEvD.nInt==2)
    {
      printw("At performance of transfer of the data RT-BC:\n");
	
      if (tmkEvD.bc.wResult & S_ERAO_MASK)		
        printw("The error in a field of the address received RW is found out\n");
				
      if (tmkEvD.bc.wResult & S_MEO_MASK)		
        printw("The error of a code 'Manchester - 2' is found out at answer RT\n");
				
      if (tmkEvD.bc.wResult & S_EBC_MASK)		
        printw("The error of the echo - control over transfer BC is found out\n");			
		
      if (tmkEvD.bc.wResult & S_TO_MASK)		
        printw("It is not received the answer from RT\n");
				
      if (tmkEvD.bc.wResult & S_IB_MASK)		
        printw("The established bits in received RW are found out\n");
	    				
    }	
  }
  printw("\n");
  tmkselect(rt);
/*     16     */
  rtdefsubaddr(RT_RECEIVE, 16);
  rtgetblk(0, awRTBuf, 32);
  printw("RT: The data are received:\n");
 
  for (i = 0; i < 32; ++i)
  {
    if ((i & 3) == 0)
      printw("\n");
    printw(" %04X", awRTBuf[i]);
  }
  stop:
  timeout(-1);
  getch();


/*     */
  endwin();
  tmkdone(ALL_TMKS);
  TmkClose();
  return 0;
}  
 
