/*
         ⫠稪 騥  ஬.
*/

void tt_buf_mode_chg(char *str)               /*  ०  */
{
  unsigned i;

  if (sscanf(str, "%x", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
  if (i!=1 && i!=0)
  {
    msg_out(" ० ");
    return;
  }
  tt_buf_mode=1;
  if (tt_buf_mode) { tt_buf_size=2048; tt_buf_adr=tt_ram_adr; }
    else tt_buf_size=32;
  tt_out_buffer(tt_base);
}

void tt_buf_fill(char *str)                     /*   ⠭⮩ */
{
  unsigned tt_start, end, constant;

  while (*str=='\t' || *str==' ') str++;
  if (sscanf(str, "%u", &tt_start)!=1) { msg_out(mark_err); return; }
  if (tt_start>TT_SEQ_RAM_SIZE-1) { msg_out(mark_err); return; }
  while (*str!=' ' && *str!=',') str++;
  while (*str==' ' || *str==',') str++;
  if (sscanf(str, "%u", &end)!=1) { msg_out(mark_err); return; }
  if (end<tt_start || end>TT_SEQ_RAM_SIZE-1) { msg_out(mark_err); return; }
  while (*str!=' ' && *str!=',') str++;
  while (*str==' ' || *str==',') str++;
  if (sscanf(str, "%x", &constant)!=1) { msg_out(const_err); return; }
  while (end>=tt_start) tt_putw(tt_start++,constant);
  tt_out_buffer(tt_base);
}

void tt_buf_fill_FFFF(unsigned tt_start)
{
  unsigned i;

  for (i=tt_start; i<TT_SEQ_RAM_SIZE; i++)
    tt_putw(i,0xFFFF);
  tt_out_buffer(tt_base);
}

void tt_buf_clear(char *str)                                  /* ⪠  */
{
  int i;

  if (end_ctrl(str)) return;
  for (i=tt_buf_size; i--!=0; tt_putw(i,0));
  tt_buf_mark=0;
  tt_in_ed_word=3;
  tt_out_buffer(tt_base);
}

void tt_ram_to_buf(char *str)               /* ஢ ࠭    */
{
  if (end_ctrl(str)) return;
  tt_read_ram(tt_buf_size, tt_base*TT_PAGE_SIZE, tt_buffer); /* 2048*/
  tt_out_buffer(tt_base);
}

void tt_buf_to_ram(char *str)                       /* ஢    */
{
  if (end_ctrl(str)) return;
  tt_write_ram(tt_buf_size, tt_ram_adr=tt_base*TT_PAGE_SIZE, tt_buffer);
  tt_out_buffer(tt_base);
}

void tt_buf_edit(char *str)                   /* ।஢ ୮  */
{
  #define TAB 0x09

  static int tt_in_word;    /*  ⥪饩 ࠤ  ।஢ */
  static int tt_edit_mode=0;  /* ⥪騩 ० ।஢: 0 - HEX, 1 - BIN */
  static int tt_bit_num;   /* ⥪騩   ।஢ */
  unsigned key, tetrada, tetrada1, bit, bit1, ba, tmpw;
  char ch;

  tt_in_word=tt_maxbit/4;
  tt_bit_num=tt_maxbit;
  while (*str=='\t' || *str==' ') str++;
  if (tt_mark_set(str, &tt_buf_mark)) return;
  {
    int cx, cy;
    cx=wherex(); cy=wherey();
    gotoxy(x0+1, y0+22);
    puts("  \x1E      -  ࠤ ࠢ, \x11--(BACKSPACE) -  ࠤ ,");
    puts("\x11   \x10 - ६饭  ᫮, HOME -  砫 , END -   ,");
    puts("  \x1F     TAB - HEX/BIN ०, Z - , Q(F10) -  ।஢.");
    gotoxy(cx, cy);
  }
  do
  {
    gotoxy(x0+1,y0+21);
    if (!tt_fullword)
      cprintf("         ।஢  ᨥ ⮢");
    else
      cprintf("         ।஢  ⮢       ");
    ba = tt_base*TT_PAGE_SIZE;
    if (tt_edit_mode)
    {
      tt_bin_unpack(62, TT_BDUMP_Y, ba+tt_buf_mark, tt_getw(ba+tt_buf_mark), TT_COLOR_DATA);
      gotoxy(TT_BDUMP_X+5*(tt_buf_mark%TT_DUMP_WIDE)-3, TT_BDUMP_Y+tt_buf_mark/TT_DUMP_WIDE);
      printf("%04X", tt_getw(ba+tt_buf_mark));
      gotoxy(61+(16-tt_bit_num), TT_BDUMP_Y+1);
    }
    else
    {
      tt_bin_unpack(62, TT_BDUMP_Y, ba+tt_buf_mark, tt_getw(ba+tt_buf_mark), TT_COLOR_DATA);
      gotoxy(TT_BDUMP_X+5*(tt_buf_mark%TT_DUMP_WIDE)-tt_in_word, TT_BDUMP_Y+tt_buf_mark/TT_DUMP_WIDE);
    }
    key=bioskey(0);
    if (key&0x00FF)
    {
      switch (key=toupper(key&0x00FF))       /*   ᨬ ࠢ */
      {
      case 'Q':
      case ESCAPE: key='Q'; break;
      case 'Z': if (tt_fullword)
                {
                  tt_maxbit=7;
                  tt_minbit=0;
                  tt_fullword=0;
                  if (tt_bit_num>tt_maxbit)
                  {
                    tt_in_word=tt_maxbit/4;
                    tt_bit_num=tt_maxbit;
                  }
                }
                else
                {
                  tt_maxbit=15;
                  tt_minbit=0;
                  tt_fullword=1;
                }
                break;
      case TAB: if (tt_edit_mode)
                {
                  tt_edit_mode=0;
                  tt_in_word=tt_bit_num/4;
                }
                else
                {
                  tt_edit_mode=1;
                  tt_bit_num=tt_in_word*4+3;
                }
                break;
      case CR:  tt_edit_mode=0;
                if (tt_buf_mark!=TT_DUMP_SIZE-1) ++tt_buf_mark;
                else tt_buf_mark=0;
                break;
      case ' ':
                if (tt_edit_mode) break;
                if (tt_in_word==0)
                {
                  if (tt_buf_mark!=TT_DUMP_SIZE-1) { tt_in_word=3; tt_buf_mark++; }
                }
                else tt_in_word--;
                break;
      case BACKSPACE:
                if (tt_edit_mode) break;
                if (tt_in_word==tt_maxbit/4)
                {
                  if (tt_buf_mark!=0) { tt_in_word=tt_minbit/4; tt_buf_mark--; }
                }
                else tt_in_word++;
                break;
      default:
               if (tt_edit_mode)
               {
                 if (key!='0' && key!='1' && !(key=='P' && !tt_fullword)) break;
                 if (key=='P')
                 {
                   bit=1; bit1=1;
                 }
                 else
                 {
                   bit=key-'0'; bit1=!bit;
                 }
                 tmpw=(tt_getw(ba+tt_buf_mark)&(~(0x0001<<tt_bit_num)))|(bit<<tt_bit_num);
                 if (key=='P' || !tt_fullword)
                   tmpw=(tmpw&(~(0x0001<<tt_bit_num+8)))|(bit1<<tt_bit_num+8);
                 tt_putw(ba+tt_buf_mark, tmpw);
                 if (tt_bit_num>tt_minbit) tt_bit_num--;
                 break;
               }
               if (key>='0' && key<='9')
               { tetrada=key-'0'; tetrada1=~tetrada&0xF; }
               else if (key>='A' &&  key<='F')
               { tetrada=key-'A'+10; tetrada1=~tetrada&0xF; }
               else if (key=='P' && !tt_fullword)
                 tetrada = tetrada1 = 0xF;
               else break;
               tmpw=(tt_getw(ba+tt_buf_mark)&(~(0x000F<<tt_in_word*4)))|(tetrada<<tt_in_word*4);
               if (key=='P' || !tt_fullword)
                 tmpw=(tmpw&(~(0x000F<<(tt_in_word+2)*4)))|(tetrada1<<(tt_in_word+2)*4);
               tt_putw(ba+tt_buf_mark,tmpw);
               if (key=='P')
               {
                 gotoxy(wherex()-2,wherey());
                 putchar('F');
                 gotoxy(wherex()+1,wherey());
                 putchar('F');
               }
               else if (!tt_fullword)
               {
                 gotoxy(wherex()-2,wherey());
                 cprintf("%1X",tetrada1);
                 gotoxy(wherex()+1,wherey());
                 cprintf("%1X",tetrada);
               }
               else
                 putchar(key);
               if (tt_in_word==tt_minbit/4)
               {
                 if (tt_buf_mark!=TT_DUMP_SIZE-1)
                 { tt_in_word=tt_maxbit/4; tt_buf_mark++; }
               }
               else tt_in_word--;
               break;
      }
    }
    else
    {
      switch (key>>8)                            /* 㭪樮  */
      {
      case LEFT:
                 if (tt_edit_mode)
                 {
                   if (tt_bit_num<tt_maxbit) tt_bit_num++;
                   break;
                 }
                 if (tt_buf_mark!=0) --tt_buf_mark;
                 else tt_buf_mark=TT_DUMP_SIZE-1;
                 break;
      case RIGHT:
                 if (tt_edit_mode)
                 {
                   if (tt_bit_num>tt_minbit) tt_bit_num--;
                   break;
                 }
                 if (tt_buf_mark!=TT_DUMP_SIZE-1) ++tt_buf_mark;
                 else tt_buf_mark=0;
                 break;
      case UP:
                 if (tt_edit_mode)
                 {
                   if (tt_buf_mark!=0) --tt_buf_mark;
                   else tt_buf_mark=TT_DUMP_SIZE-1;
                   break;
                 }
                 if (tt_buf_mark-TT_DUMP_WIDE>=0) tt_buf_mark-=TT_DUMP_WIDE;
                 else
                 {
                   tt_buf_mark+=(TT_DUMP_WIDE*(TT_DUMP_STRINGS-1));
                   if (tt_buf_mark>TT_DUMP_SIZE-1) tt_buf_mark-=TT_DUMP_WIDE;
                 }
                 break;
      case DOWN:
                 if (tt_edit_mode)
                 {
                   if (tt_buf_mark!=TT_DUMP_SIZE-1) ++tt_buf_mark;
                   else tt_buf_mark=0;
                   break;
                 }
                 if (tt_buf_mark+TT_DUMP_WIDE<=TT_DUMP_SIZE-1) tt_buf_mark+=TT_DUMP_WIDE;
                 else
                 {
                   tt_buf_mark-=(TT_DUMP_WIDE*(TT_DUMP_STRINGS-1));
                   if (tt_buf_mark<0) tt_buf_mark+=TT_DUMP_WIDE;
                 }
                 break;
      case HOME:
                 if (tt_edit_mode)
                 {
                   tt_bit_num=tt_maxbit;
                   break;
                 }
                 tt_buf_mark=0;
                 break;
      case END:
                 if (tt_edit_mode)
                 {
                   tt_bit_num=tt_minbit;
                   break;
                 }
                 tt_buf_mark=TT_DUMP_SIZE-1;
                 break;
      case PGUP: if (tt_base==0) break;
                 tt_base--;
                 tt_out_base();
                 tt_out_buffer(tt_base);
                 break;
      case PGDN: if (tt_base==(TT_SEQ_RAM_SIZE/TT_PAGE_SIZE-1)) break;
                 tt_base++;
                 tt_out_base();
                 tt_out_buffer(tt_base);
                 break;
      case F10:  key='Q'; break;
      }
      continue;
    }
  }
  while (key!='Q');
  gotoxy(x0+1, y0+21); clreol();       /* ࠭ ᪠ */
  gotoxy(x0+1, y0+22); clreol();
  gotoxy(x0+1, y0+23); clreol();
  gotoxy(x0+1, y0+24); clreol();
}

int tt_mark_set(char *str, int *mark)
/*   ⥪饣 ᫮  ।஢
1 - 訡, 0 -   浪
*/
{
  unsigned i, constant;

  if (*str=='\0') return 0;
  if ((sscanf(str, "%u", &i))!=1)
  {
    msg_out(inp_err);
    return 1;
  }
  if (i>TT_DUMP_SIZE-1)
  {
    msg_out(mark_err);
    return 1;
  }
  *mark=i;
  while (*str!=' ' && *str!=',' && *str!='\0') str++;
  if (!*str) return 0;
  while (*str==' ' || *str==',') str++;
  if (sscanf(str, "%x", &constant)!=1) { msg_out(const_err); return 1; }
  tt_putw(tt_buf_adr+(*mark),constant);
  tt_out_buffer(tt_base);
  return 1;
}

void tt_reg_view(char *str)              /* ᬮ  ॣ */
{
  #define TAB 0x09

  unsigned key, ba, tmpw, sw;
  char ch;
  int bin_color;
  int fCmdColor=1;
  unsigned wRegDumpSize, wRegRamSize;
  int mark_sav;

  while (*str=='\t' || *str==' ') str++;
  if (tt_mark_set(str, &tt_reg_buf_mark)) return;
  {
    int cx, cy;
    cx=wherex(); cy=wherey();
    gotoxy(x0+1, y0+22);
    puts("  \x1E     Z - ⮢ 뤥 /");
    puts("\x11   \x10 - ६饭  ᫮, HOME -  砫 , END -   ,");
    puts("  \x1F     Q(F10) -  ।஢.");
    gotoxy(cx, cy);
  }
  wRegRamSize=(tt_stop_adr<=TT_REG_RAM_SIZE)?tt_stop_adr+1:TT_REG_RAM_SIZE;
  wRegDumpSize=(tt_stop_adr<=TT_REG_DUMP_SIZE)?tt_stop_adr+1:TT_REG_DUMP_SIZE;
  do
  {
    ba = tt_base*TT_REG_PAGE_SIZE;
    sw=tt_getsw(ba+tt_reg_buf_mark);
    if (sw&0x80)
      if (fCmdColor)
        bin_color=TT_COLOR_CMD;
      else
        bin_color=TT_COLOR_STAT;
    else
      bin_color=TT_COLOR_DATA;
    tt_bin_unpack(62, TT_BDUMP_Y-1, ba+tt_reg_buf_mark, tt_getdw(ba+tt_reg_buf_mark), bin_color);
    gotoxy(x0+1, TT_BDUMP_Y-1);
    printf("ந:");
    if (sw&0x80)
      printf("/");
    else
      printf("   ");
    printf(" :");
    if (sw&0x40)
      printf("B");
    else
      printf("A");
    if (sw&0x20)
      printf(" 뢭 ।.");
    else
      printf("                      ");
    printf("\n");
    if (sw&0x10)
      printf("訡  '-2'.");
    if (sw&0x08)
      printf("訡 ⭮.");
    while(wherex()<60)
      putch(' ');
    printf("\n");
    if (sw&0x04)
      printf("㯯 .");
    if (sw&0x01)
      printf("।   .");
    while(wherex()<60)
      putch(' ');
    gotoxy(15+40*(tt_reg_buf_mark/(TT_REG_DUMP_SIZE/TT_REG_DUMP_WIDE)), TT_BDUMP_Y+2+tt_reg_buf_mark%(TT_REG_DUMP_SIZE/TT_REG_DUMP_WIDE));
    key=bioskey(0);
    if (key&0x00FF)
    {
      switch (key=toupper(key&0x00FF))       /*   ᨬ ࠢ */
      {
      case 'Z': fCmdColor=!fCmdColor; break;
      case 'Q':
      case ESCAPE: key='Q'; break;
      }
    }
    else
    {
      mark_sav = tt_reg_buf_mark;
      switch (key>>8)                            /* 㭪樮  */
      {
      case LEFT:
                  tt_reg_buf_mark-=TT_REG_DUMP_SIZE/TT_REG_DUMP_WIDE;
                  if (tt_reg_buf_mark<0)
                    tt_reg_buf_mark+=TT_REG_DUMP_SIZE;
                  if (tt_reg_buf_mark>wRegDumpSize-1)
                    tt_reg_buf_mark=mark_sav;
                  break;
      case RIGHT:
                  tt_reg_buf_mark+=TT_REG_DUMP_SIZE/TT_REG_DUMP_WIDE;
                  if (tt_reg_buf_mark>wRegDumpSize-1)
                    tt_reg_buf_mark-=TT_REG_DUMP_SIZE;
                  if (tt_reg_buf_mark<0)
                    tt_reg_buf_mark=mark_sav;
                  break;
      case UP:
                  --tt_reg_buf_mark;
                  if (tt_reg_buf_mark<0)
                    tt_reg_buf_mark=wRegDumpSize-1;
                  break;
      case DOWN:
                  ++tt_reg_buf_mark;
                  if (tt_reg_buf_mark>=wRegDumpSize)
                    tt_reg_buf_mark=0;
                  break;
      case HOME:
                  tt_reg_buf_mark=0;
                  break;
      case END:
                  tt_reg_buf_mark=wRegDumpSize-1;
                  break;
      case PGUP:  if (tt_base==0) break;
                  tt_base--;
                  tt_out_base();
                  tt_out_buffer(tt_base);
                  break;
      case PGDN:  if (tt_base==(wRegRamSize/TT_REG_PAGE_SIZE)) break;
                  tt_base++;
                  tt_out_base();
                  tt_out_buffer(tt_base);
                  break;
      case F10:   key='Q'; break;
      }
      continue;
    }
  }
  while (key!='Q');
  gotoxy(x0+1, y0+21); clreol();       /* ࠭ ᪠ */
  gotoxy(x0+1, y0+22); clreol();
  gotoxy(x0+1, y0+23); clreol();
  gotoxy(x0+1, y0+24); clreol();
}
