unsigned a_save, s_save;
int fP, fS;

unsigned tt_getbit(unsigned long nBitNum)
{
  return ((tt_getw((unsigned)(nBitNum>>3))<<((unsigned)(nBitNum&0x7)))&T_11);
}

void tt_putbit(unsigned long nBitNum, unsigned nBit)
{
  unsigned tmpw;

  tmpw=tt_getw((unsigned)(nBitNum>>3))&(~(T_11>>(unsigned)(nBitNum&0x7)));
  tmpw|=nBit>>(unsigned)(nBitNum&0x7);
  tt_putw((unsigned)(nBitNum>>3), tmpw);
}

void tt_ram2text(char *str)
{
  unsigned long i, nTime1, nTime2, nDTime, nBits;

  nBits=(unsigned long)(tt_mode2&0x7FF)*8L;
  for (i=0;i<nBits;)
  {
    switch (tt_getbit(i++))
    {
    case T_00:
      *(str++)='_';
      nTime1=--i;
      while (++i<nBits)
        if (tt_getbit(i)!=T_00)
          break;
      nTime2=i;
      nDTime=nTime2-nTime1;
      sprintf(str,"%lu.%c;",nDTime>>1,(nDTime&1)?'5':'0');
      while (*(++str));
      break;
    case T_11:
      *(str++)='P';
      nTime1=--i;
      while (++i<nBits)
        if (tt_getbit(i)!=T_11)
          break;
      nTime2=i;
      nDTime=nTime2-nTime1;
      sprintf(str,"%lu.%c;",nDTime>>1,(nDTime&1)?'5':'0');
      while (*(++str));
      break;
    case T_01:
      switch (tt_getbit(i++))
      {
      case T_10:
        *(str++)='1';
        break;
      case T_01:
        *(str++)='H';
        break;
      case T_00:
      case T_11:
        *(str++)='h';
        i--;
        break;
      }
      break;
    case T_10:
      switch (tt_getbit(i++))
      {
      case T_01:
        *(str++)='0';
        break;
      case T_10:
        *(str++)='L';
        break;
      case T_00:
      case T_11:
        *(str++)='l';
        i--;
        break;
      }
      break;
    }
  }
  *str='\0';
}

void tt_text2ram(char *str)
{
  unsigned long i;
  unsigned a,b,c,d;

  i=0;
  fS=0;
  while (*str)
  {
    switch(*str++)
    {
    case 'K':
      s_save='K';
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_10);
      break;
    case 'U':
      s_save='U';
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_01);
      break;
    case 'H':
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_01);
      break;
    case 'L':
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_10);
      break;
    case '1':
      tt_putbit(i++,T_01);
      tt_putbit(i++,T_10);
      break;
    case '0':
      tt_putbit(i++,T_10);
      tt_putbit(i++,T_01);
      break;
    case 'h':
      tt_putbit(i++,T_01);
      break;
    case 'l':
      tt_putbit(i++,T_10);
      break;
    case '[':
      if (sscanf(str,"%X]",&a)!=1)
      {
        while (*(++str));
        break;
      }
      while (*(str++)!=']');
      a_save=a;
      fP=1;
      for (c=0,b=1;c<16;c++)
      {
        if (a&0x8000)
        {
          tt_putbit(i++,T_01);
          tt_putbit(i++,T_10);
          b^=1;
        }
        else
        {
          tt_putbit(i++,T_10);
          tt_putbit(i++,T_01);
        }
        a<<=1;
      }
      if (b)
      {
        tt_putbit(i++,T_01);
        tt_putbit(i++,T_10);
      }
      else
      {
        tt_putbit(i++,T_10);
        tt_putbit(i++,T_01);
      }
      break;
    case '{':
      if (sscanf(str,"%X]",&a)!=1)
      {
        while (*(++str));
        break;
      }
      while (*(str++)!='}');
      a_save=a;
      fP=0;
      for (c=0;c<16;c++)
      {
        if (a&0x8000)
        {
          tt_putbit(i++,T_01);
          tt_putbit(i++,T_10);
        }
        else
        {
          tt_putbit(i++,T_10);
          tt_putbit(i++,T_01);
        }
        a<<=1;
      }
      break;
    case 'X':
      fS=1;
    case 'x':
      a=a_save;
      if (sscanf(str,"%u;",&d)!=1)
      {
        while (*(++str));
        break;
      }
      while (*(str++)!=';');
      --d;
      for (;d>0;--d)
      {
        if (fS)
        {
          if (s_save == 'K')
          {
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_10);
          }
          else if (s_save == 'U')
          {
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_01);
          }
        }
        a=a_save;
        for (c=0,b=1;c<16;c++)
        {
          if (a&0x8000)
          {
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_10);
            b^=1;
          }
          else
          {
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_01);
          }
          a<<=1;
        }
        if (fP)
        {
          if (b)
          {
            tt_putbit(i++,T_01);
            tt_putbit(i++,T_10);
          }
          else
          {
            tt_putbit(i++,T_10);
            tt_putbit(i++,T_01);
          }
        }
      }
      fS=0;
      break;
    case 'P':
      if (sscanf(str,"%u.%u;",&a,&b)!=2)
      {
        while (*(++str));
        break;
      }
      while (*(str++)!=';');
      for (c=(a<<1)+b/5;c>0;c--)
        tt_putbit(i++,T_11);
      break;
    case '_':
      if (sscanf(str,"%u.%u;",&a,&b)!=2)
      {
        while (*(++str));
        break;
      }
      while (*(str++)!=';');
      for (c=(a<<1)+b/5;c>0;c--)
        tt_putbit(i++,T_00);
      break;
    }
  }
  while (i&0x7)
    tt_putbit(i++,T_11);
  tt_mode2=(tt_mode2&0xF800)+(i>>3);
}

int tt_istestchar(char ch)
{
  return ((ch>='0'&&ch<='9')||(ch>='A'&&ch<='F')||
          ch=='H'||ch=='L'||ch=='P'||ch=='_'||ch=='h'||ch=='l'||
          ch=='.'||ch==';'||ch=='['||ch==']'||ch=='K'||ch=='U'||
          ch=='{'||ch=='}'||ch=='x'||ch=='X');
}

char tt_edit_str(int (*is_good_char)(char ch),
              char *str,
              int outlen,
              int maxlen)
{
  int pos=0,
      pos0=0,
      xpos=0,
      dpos,
      len,
      dlen,
      s_mode=0,
      insmode=TRUE,
      ex=FALSE,
      changed=TRUE,
      i,
      x_0, y_0,
      timeh, timel, addh, addl, nword,
      fSkipMode, fHexMode, fConvert;
 
  unsigned w, par;
  char key;
  char *str_o, *str1, *str2;
  {
  int cx, cy;
  cx=wherex(); cy=wherey();
  gotoxy(x0+1, y0+22);
  puts(" 1 (.1) =10, 0 (.0) =01, H=11, h=1, L=00, l=0, [HHHH] -᫮(hex)");
  puts(" K () =H1L=111000, U () =L0H=000111, PDD.D; - 㧠(.)  ");
  puts(" F2 - ⮡ࠦ ᨭநᮢ, F3/F4/F5/AltF5 - ⮡ࠦ ᫮");
  gotoxy(cx, cy);
  }
  x_0=wherex();
  y_0=wherey();
  len=strlen(str);
  do
  {
    gotoxy(x_0,y_0-1);
    for (i=0,timeh=timel=nword=fSkipMode=fHexMode=0; i!=pos; ++i)
    {
      if (fSkipMode)
      {
        if (str[i] == ';')
          fSkipMode = 0;
        continue;
      }
      if (fHexMode)
      {
        if (str[i] == '}')
          fHexMode = 0;
        else if (str[i] == ']')
        {
          fHexMode = 0;
          ++timeh;
        }
        else
          timeh+=4;
        continue;
      }
      switch (str[i])
      {
      case 'P':
      case '_':
        if (sscanf(str+i+1,"%u.%u;",&addh,&addl) == 2)
        {
          timel+=addl;
          if (timel == 10)
          {
            timel = 0;
            ++timeh;
          }
          timeh+=addh;
        }
        fSkipMode = 1;
        break;
      case 'x':
        if (sscanf(str+i+1,"%u;",&addh) == 1)
        {
          --addh;
          timeh+=16*addh;
          nword+=addh;
        }
        fSkipMode = 1;
        break;
      case 'X':
        if (sscanf(str+i+1,"%u;",&addh) == 1)
        {
          --addh;
          timeh+=20*addh;
          nword+=addh;
        }
        fSkipMode = 1;
        break;
      case 'K':
      case 'U':
        timeh+=3;
        break;
      case '0':
      case '1':
      case 'H':
      case 'L':
        ++timeh;
        break;
      case 'h':
      case 'l':
        if (timel == 0)
          timel = 5;
        else
        {
          timel = 0;
          ++timeh;
        }
        break;
      case '[':
      case '{':
        ++nword;
        fHexMode = 1;
        break;
      }
    }
    if (str[i] == '[' || str[i] == '{')
      ++nword;
    printf("Time = %5u.%u us, Word %5u", timeh, timel, nword);
    if (changed)
    {
      gotoxy(x_0,y_0);
      str_o=&str[pos0];
      for (i=0; i<outlen && *str_o; i++)
        putch(*str_o++);
      for (; i<outlen; i++)
        putch(' ');
      changed=FALSE;
    }
    if (ex)
      break;
    gotoxy(x_0+xpos,y_0);
    key=getch();
    if ((key>='a' && key<='f') || key=='p' || key=='k' || key=='u')
      key = toupper(key);
    if (is_good_char(key))
    {
      if (pos<maxlen-1)
      {
        if ((insmode && len<maxlen-1) || pos==len)
        {
          for (i=maxlen-1; i>pos; i--)
            str[i]=str[i-1];
          len++;
        }
        str[pos++]=key;
        if (xpos>=outlen-8)
          pos0++;
        else
          xpos++;
        changed=TRUE;
      }
    }
    else
    {
      switch(key)
      {
      case ENTER:
      case ESC:
      case BS:
      case TAB:
        ungetch(key);
      case EXT_CODE:
        key=getch();
        switch(key)
        {
        case F03:
          changed=TRUE;
          for (str1=str; *str1; str1++)
          {
            if (*str1!='[' && *str1!='{')
              continue;
            if (sscanf(str1+1,"%x",&w)!=1)
            {
              msg_out("⨬ ⭠筮 ᫮");
              break;
            }
            str2=str1;
            if (*str1=='[')
            {
              fP=1;
              while (*(++str2)!=']' && *str2);
              str2++;
              dlen=17-(str2-str1);
            }
            else
            {
              fP=0;
              while (*(++str2)!='}' && *str2);
              str2++;
              dlen=16-(str2-str1);
            }
            memmove(str2+dlen,str2,len+1-(str2-str));
            len+=dlen;
            if (pos>=str2-str)
              pos+=dlen;
            else if (pos==((str2-str)-1))
              pos+=dlen+1;
            else if (pos>str1-str)
              pos=(str1-str)+((pos-(str1-str)-1)<<2);
            for (i=0,par=0;i<16;i++)
            {
              par^=w&0x8000;
              *(str1++)=(w&0x8000)?'1':'0';
              w<<=1;
            }
            if (fP)
              *(str1)=(par)?'0':'1';
            else
              --str1;
          }
          if ((xpos=pos-pos0)>outlen-8)
          {
            pos0=pos-(outlen-8);
            xpos=pos-pos0;
          }
          break;
        case F04:
          changed=TRUE;
          for (str1=str; *str1; str1++)
          {
            if (*str1!='0' && *str1!='1')
              continue;
            str2=str1;
            for (i=0,w=0,par=1;i<16;i++)
            {
              if (*str1!='0' && *str1!='1')
                break;
              w<<=1;
              w|=*(str1++)&1;
              par^=w&1;
            }
            if (i==16 && (*str1=='1' || *str1=='0') && (*str1&1)==par)
            {
              sprintf(str2,"[%04X]",w);
              memmove(str2+6,str1+1,len-(str1-str));
              len-=11;
              if (pos>str2-str+16)
              {
                pos-=11;
                if ((pos0-=11)<0)
                  pos0=0;
                xpos=pos-pos0;
              }
              str1=str2+5;
            }
          }
          break;
        case F05:
          changed=TRUE;
          for (str1=str; *str1; str1++)
          {
            if (*str1!='0' && *str1!='1')
              continue;
            str2=str1;
            for (i=0,w=0;i<16;i++)
            {
              if (*str1!='0' && *str1!='1')
                break;
              w<<=1;
              w|=*(str1++)&1;
            }
            --str1;
            if (i==16)
            {
              sprintf(str2,"{%04X}",w);
              memmove(str2+6,str1+1,len-(str1-str));
              len-=10;
              dpos=0;
              if (pos>str2-str+15)
                dpos=10;
              else if (pos>=str2-str)
                dpos=pos-((str2-str)+1+((pos-(str2-str))>>2));
              pos-=dpos;
              if (dpos>0 && (pos0-=dpos)<0)
                pos0=0;
              xpos=pos-pos0;
              str1=str2+5;
            }
          }
          break;
        case AltF05:
          changed=TRUE;
          fConvert=0;
          for (str1=str; *str1; str1++)
          {
            if (*str1=='K')
            {
              timeh=timel=0;
              fConvert=1;
              continue;
            }
            else if (*str1=='U' || !fConvert)
            {
              fConvert=0;
              continue;
            }
            if (timeh == 0 && timel == 0)
            {
              i=0;
              w=0;
              str2=str1;
            }
            switch (*str1)
            {
            case '1':
              w<<=1;
              w|=1;
              ++timeh;
              ++i;
              break;
            case '0':
              w<<=1;
              ++timeh;
              ++i;
              break;
            case 'H':
            case 'L':
              ++timeh;
              break;
            case 'h':
            case 'l':
              if (timel == 5)
              {
                timel=0;
                ++timeh;
              }
              else
                timel+=5;
              break;
            case 'P':
            case '_':
              if (sscanf(str1,"%u.%u;",&addh,&addl) == 2)
              {
                timel+=addl;
                if (timel == 10)
                {
                  timel = 0;
                  ++timeh;
                }
                timeh+=addh;
                while (*(++str1) != ';');
                if (timeh >= 16)
                {
                  timeh=timel=0;
                }
              }
              break;
            }
            if (timeh == 16 && timel == 0 && i == 16)
            {
              sprintf(str2,"{%04X}",w);
              memmove(str2+6,str1+1,len-(str1-str));
              len-=10;
              dpos=0;
              if (pos>str2-str+15)
                dpos=10;
              else if (pos>=str2-str)
                dpos=pos-((str2-str)+1+((pos-(str2-str))>>2));
              pos-=dpos;
              if (dpos>0 && (pos0-=dpos)<0)
                pos0=0;
              xpos=pos-pos0;
              str1=str2+4;
            }
            if (timeh == 16 && timel == 0)
              timeh=timel=0;
          }
          break;
        case F02:
          changed=TRUE;
          if ((s_mode=!s_mode)!=0)
          {
            for (str1=str; *str1; str1++ )
            {
              if (*str1!='H' && *str1!='L')
                continue;
              if (*str1=='H' && *(str1+1)=='1' && *(str1+2)=='L')
                *str1='K';
              else if (*str1=='L' && *(str1+1)=='0' && *(str1+2)=='H')
                *str1='U';
              else
                continue;
              str2=str1;
              str1+=2;
              memmove(str2+1,str1+1,len-(str1-str));
              len-=2;
              if (pos>str2-str+2)
              {
                pos-=2;
                if ((pos0-=2)<0)
                  pos0=0;
                xpos=pos-pos0;
              }
              str1=str2+1;
            }
          }
          else
          {
            for (str1=str; *str1; str1++)
            {
              if (*str1!='K' && *str1!='U')
                continue;
              str2=str1+1;
              dlen=2;
              memmove(str2+2,str2,len+1-(str2-str));
              len+=2;
              if (pos>=str2-str)
                pos+=2;
              if (*str1=='K')
              {
                *(str1++)='H';
                *(str1++)='1';
                *(str1)='L';
              }
              else
              {
                *(str1++)='L';
                *(str1++)='0';
                *(str1)='H';
              }
            }
            if ((xpos=pos-pos0)>outlen-8)
            {
              pos0=pos-(outlen-8);
              xpos=pos-pos0;
            }
          }
          break;
        case HOME:
          pos=0;
          xpos=0;
          changed=pos0;
          pos0=0;
          break;
        case END:
          pos=len;
          if ((changed=(len>outlen-8))!=0)
            pos0=len-(outlen-8);
          xpos=pos-pos0;
          break;
        case LEFT:
          if (pos>0)
          {
            pos--;
            if ((changed=(xpos<=8 && pos0))!=0)
              pos0--;
            else
              xpos--;
          }
          break;
        case RIGHT:
          if (pos<len)
          {
            pos++;
            if ((changed=((xpos>=outlen-8)&&(len-pos0>outlen)))!=0)
              pos0++;
            else
              xpos++;
          }
          break;
        case CTRLLEFT:
          do
          {
            if (pos>0)
            {
              pos--;
              if ((changed=(xpos<=8 && pos0))!=0)
                pos0--;
              else
                xpos--;
            }
            else
            {
              changed=1;
              break;
            }
          }
          while (str[pos] != '{' && str[pos] != '[');
          break;
        case CTRLRIGHT:
          do
          {
            if (pos<len)
            {
              pos++;
              if ((changed=((xpos>=outlen-8)&&(len-pos0>outlen)))!=0)
                pos0++;
              else
                xpos++;
            }
            else
            {
              changed=1;
              break;
            }
          }
          while (str[pos] != '{' && str[pos] != '[');
          break;
        case INS:
          insmode=!insmode;
          break;
        case BS:
          if (pos>0)
          {
            pos--;
            xpos--;
          }
        case DEL:
          if (pos<len)
          {
            if (pos0 && xpos<outlen-8)
            {
              pos0--;
              xpos++;
            }
            for (i=pos; i<maxlen-1; i++)
              str[i]=str[i+1];
            len--;
            changed=TRUE;
          }
          break;
        case ENTER:
        case ESC:
  /*
        case PGUP:
        case PGDN:
        case UP:
        case DOWN:
   */
          ex=TRUE;
          changed=TRUE;
        }
      }
    }
  }
  while (TRUE);
  {
  int cx, cy;
  cx=wherex(); cy=wherey();
  gotoxy(x0+1, y0+22);
  clreol();
  gotoxy(x0+1, y0+23);
  clreol();
  gotoxy(x0+1, y0+24);
  clreol();
  gotoxy(cx, cy);
  }
  return(key);
}
