
/****************************************************************************/
/*      TMKINIT v6.00 for TMKLL4 for MS-DOS. ELCUS, 1995,2006.              */
/*      Reads configuration text file for TMKLL4 (see ini&tst.doc).         */
/****************************************************************************/

#include "tmkll4.h"

#include <stdio.h>
#include <string.h>

#ifdef TMK_CONFIGURATION_TABLE
struct TTmkConfig
{
 int nType;
 char achName[10];
 unsigned wPorts1;
 unsigned wPorts2;
 unsigned wIrq1;
 unsigned wIrq2;
} aTmkConfig[4];
#endif

#define TMK_FILE_OPEN_ERROR 21
#define TMK_FILE_READ_ERROR 22
#define TMK_FILE_FORMAT_ERROR 23
#define TMK_UNKNOWN_TYPE 24

unsigned int SGetHexAddr(char **ppszCurParam)
{
 unsigned int Result;
 char szTemp[10];
 char *pParEnd;
 while (**ppszCurParam == ' ' || **ppszCurParam == '\t')
  *ppszCurParam++;
 for (pParEnd = *ppszCurParam;
       *pParEnd != ' ' && *pParEnd != '\t' && *pParEnd != '\0'
       && *pParEnd != '\n';
       pParEnd++);
 if (sscanf(*ppszCurParam, "%x", &Result) == 1)
 {
  *ppszCurParam = pParEnd;
  if (*pParEnd != '\0')
  {
   *pParEnd = '\0';
   (*ppszCurParam)++;
  }
 }
 else
  Result = 0;
 return Result;
}

unsigned char SGetIrq(char **ppszCurParam)
{
 unsigned int Result;
 char szTemp[10];
 char *pParEnd;
 while (**ppszCurParam == ' ' || **ppszCurParam == '\t')
  *ppszCurParam++;
 for (pParEnd = *ppszCurParam;
       *pParEnd != ' ' && *pParEnd != '\t' && *pParEnd != '\0'
       && *pParEnd != '\n';
       pParEnd++);
 if (*(*ppszCurParam)++ == 'I' &&
      *(*ppszCurParam)++ == 'R' &&
      *(*ppszCurParam)++ == 'Q' &&
      sscanf(*ppszCurParam, "%u", &Result) == 1)
 {
  *ppszCurParam = pParEnd;
  if (*pParEnd != '\0')
  {
   *pParEnd = '\0';
   (*ppszCurParam)++;
  }
 }
 else
  Result = 0;
 return Result;
}

int TmkInit(char *pszTMKFileName)
{
 char *apszTmkTypeName[MAX_TMK_TYPE+1] = { "",
                                           "",
                                           "TMK400",
                                           "TMKMPC",
                                           "RTMK400",
                                           "TMKX",
                                           "TMKXI",
                                           "MRTX",
                                           "MRTXI",
                                           "TA",
                                           "TAI" };
 int nResult;
 int hTMK;
 unsigned tmkPorts1, tmkPorts2;
 char tmkIrq1, tmkIrq2;
 char achParams[81];
 char *pCurParam, *pCurParamEnd;
 FILE *hTMKFile;
 unsigned iTMKType;

#ifdef TMK_CONFIGURATION_TABLE
 for (hTMK = 0; hTMK <= 3; hTMK++)
 {
  aTmkConfig[hTMK].nType = -1;
  aTmkConfig[hTMK].achName[0] = '\0';
  aTmkConfig[hTMK].wPorts1 = aTmkConfig[hTMK].wPorts2 = 0;
  aTmkConfig[hTMK].wIrq1 = aTmkConfig[hTMK].wIrq2 = 0;
 }
#endif
 if ((hTMKFile = fopen(pszTMKFileName, "r")) == NULL)
  return TMK_FILE_OPEN_ERROR;
 fseek(hTMKFile, 0L, SEEK_SET);
 while (1)
 {
  if (fgets(achParams, 80, hTMKFile) == NULL)
   if (feof(hTMKFile))
    break;
   else
   {
   nResult = TMK_FILE_READ_ERROR;
   goto ExitTmkInit;
   }
  if (achParams[0] == '*')
   break;
  if (sscanf(achParams, "%u", &hTMK) != 1)
   continue;
  if (hTMK > tmkgetmaxn())
  {
   nResult = TMK_FILE_FORMAT_ERROR;
   goto ExitTmkInit;
  }
  if ((pCurParam = strchr(achParams, ' ')) == NULL)
  {
   nResult = TMK_FILE_FORMAT_ERROR;
   goto ExitTmkInit;
  }
  pCurParam++;
  if ((pCurParamEnd = strchr(pCurParam, ' ')) == NULL)
  {
   nResult = TMK_FILE_FORMAT_ERROR;
   goto ExitTmkInit;
  }
  *pCurParamEnd = '\0';
  for (iTMKType = MIN_TMK_TYPE; iTMKType <= MAX_TMK_TYPE; iTMKType++)
   if (strcmp(apszTmkTypeName[iTMKType], pCurParam) == 0)
    break;
  if (iTMKType < MIN_TMK_TYPE || iTMKType > MAX_TMK_TYPE)
  {
   nResult = TMK_UNKNOWN_TYPE;
   goto ExitTmkInit;
  }
  pCurParam = ++pCurParamEnd;
  switch (iTMKType)
  {
  case TMK400:
   if ((tmkPorts1 = SGetHexAddr(&pCurParam)) == 0)
   {
    nResult = TMK_FILE_FORMAT_ERROR;
    goto ExitTmkInit;
   }
   if ((tmkPorts2 = SGetHexAddr(&pCurParam)) == 0)
   {
    nResult = TMK_FILE_FORMAT_ERROR;
    goto ExitTmkInit;
   }
   if ((tmkIrq1 = SGetIrq(&pCurParam)) == 0)
   {
    nResult = TMK_FILE_FORMAT_ERROR;
    goto ExitTmkInit;
   }
   tmkconfig(hTMK, iTMKType, tmkPorts1, tmkPorts2, tmkIrq1, 0xFF);
   tmkIrq2 = 0xFF;
   break;
  case TMKMPC:
  case RTMK400:
  case TMKX:
  case TA:
   if ((tmkPorts1 = SGetHexAddr(&pCurParam)) == 0)
   {
    nResult = TMK_FILE_FORMAT_ERROR;
    goto ExitTmkInit;
   }
   if ((tmkIrq1 = SGetIrq(&pCurParam)) == 0)
   {
    nResult = TMK_FILE_FORMAT_ERROR;
    goto ExitTmkInit;
   }
   tmkconfig(hTMK, iTMKType, tmkPorts1, 0xFFFF, tmkIrq1, 0xFF);
   tmkPorts2 = 0xFFFF;
   tmkIrq2 = 0xFF;
   break;
  case TMKXI:
  case TAI:
   if ((tmkPorts1 = SGetHexAddr(&pCurParam)) == 0)
   {
    nResult = TMK_FILE_FORMAT_ERROR;
    goto ExitTmkInit;
   }
   if ((tmkPorts2 = SGetHexAddr(&pCurParam)) == 0)
   {
    tmkPorts2 = 0xFFFF;
   }
   tmkIrq1 = tmkIrq2 = 0xFF;
   tmkconfig(hTMK, iTMKType, tmkPorts1, tmkPorts2, tmkIrq1, tmkIrq2);
   break;

  }
#ifdef TMK_CONFIGURATION_TABLE
  aTmkConfig[hTMK].nType = iTMKType;
  strcpy(aTmkConfig[hTMK].achName, apszTmkTypeName[iTMKType]);
  aTmkConfig[hTMK].wPorts1 = tmkPorts1;
  aTmkConfig[hTMK].wPorts2 = tmkPorts2;
  aTmkConfig[hTMK].wIrq1 = tmkIrq1;
  aTmkConfig[hTMK].wIrq2 = tmkIrq2;
#endif
  if (tmkError)
   break;
 } /* endwhile(!feof()) */
 nResult = tmkError;
 ExitTmkInit:
 fclose(hTMKFile);
 return nResult;
}
