
/****************************************************************************/
/*      TMKML v1.01 for MS-DOS. ELCUS, 1995.                                */
/****************************************************************************/

#include "tmkinit.c"
#include <dos.h>

#define PUSHF __emit__(0x9C);
#define POPF __emit__(0x9D);

#ifndef TMK_MAX_NUMBER
#define TMK_MAX_NUMBER 0
#endif

#ifdef BUS_CONTROLLER

/* ம।  ஫  */

#define HARD_BIT 1
#define NO_HARD_BIT 2

#ifndef BC_MAX_BASE
#define BC_MAX_BASE 127
#endif

#define BROADCAST 0x001F
#define BC_UNDEFINED_BASE 0xFFFF
#define FREE_BASE 1
#define ANY_BASE 2
#define REMOVE_AFTER_END 1
#define STAY_AFTER_END 2

#endif

#ifdef REMOTE_TERMINAL

/* ம।  筮 ன⢠ */

#ifndef RT_MAX_PAGE
#define RT_MAX_PAGE 0
#endif

#define RT_RECEIVE_ERROR 20
#define RT_BLKSIZE_ERROR 21
#define RT_OK 0

#if RT_MAX_PAGE > 0
#define RT_MANY_PAGES
#endif

#ifdef RT_MANY_PAGES
#define RTP aRT[wRT_Page]
#else
#define RTP RT
#endif

#endif

#ifdef REAL_TIME_CLOCK

/* ம।    ⥬ RTC  IBM PC AT */

#define TIMER_NOT_AVAILABLE 30

#define TICK_122us 0x23
#define TICK_244us 0x24
#define TICK_488us 0x25
#define TICK_1ms 0x26
#define TICK_2ms 0x27
#define TICK_4ms 0x28
#define TICK_8ms 0x29
#define TICK_16ms 0x2A
#define TICK_31ms 0x2B
#define TICK_63ms 0x2C
#define TICK_125ms 0x2D
#define TICK_250ms 0x2E
#define TICK_500ms 0x2F

#define MASK_ENABLE 1
#define MASK_DISABLE 0

#endif

/* । ⨯  */

#ifdef BUS_CONTROLLER

enum TFormat1553B { BC_RT, RT_BC, RT_RT, CTRL };

typedef union UMsg1553B /*  ᮮ饭 MIL-STD-1553B   */
{
 struct
 {
  int hTMK;
  enum TFormat1553B wFormat;
  unsigned wCC;
  unsigned wBase;
  unsigned fAfterEnd;
  void (* UserFunc)( union UMsg1553B *pMsg );
  unsigned wResult;
  unsigned wAns;
 } Any;
 struct
 {
  int hTMK;
  enum TFormat1553B wFormat;
  unsigned wCC;
  unsigned wBase;
  unsigned fAfterEnd;
  void (* UserFunc)( union UMsg1553B *pMsg );
  unsigned wResult;
  unsigned wAns;
  unsigned RT_A;
  unsigned RT_SA;
  unsigned cWords;
  void *pwBuf;
 } BC_RT;
 struct
 {
  int hTMK;
  enum TFormat1553B wFormat;
  unsigned wCC;
  unsigned wBase;
  unsigned fAfterEnd;
  void (* UserFunc)( union UMsg1553B *pMsg );
  unsigned wResult;
  unsigned wAns;
  unsigned RT_A;
  unsigned RT_SA;
  unsigned cWords;
  void *pwBuf;
 } RT_BC;
 struct
 {
  int hTMK;
  enum TFormat1553B wFormat;
  unsigned wCC;
  unsigned wBase;
  unsigned fAfterEnd;
  void (* UserFunc)( union UMsg1553B *pMsg );
  unsigned wResult;
  unsigned wAnsT;
  unsigned wAnsR;
  unsigned RTR_A;
  unsigned RTR_SA;
  unsigned RTT_A;
  unsigned RTT_SA;
  unsigned cWords;
  void *pwBuf;
 } RT_RT;
 struct
 {
  int hTMK;
  enum TFormat1553B wFormat;
  unsigned wCC;
  unsigned wBase;
  unsigned fAfterEnd;
  void (* UserFunc)( union UMsg1553B *pMsg );
  unsigned wResult;
  unsigned wAns;
  unsigned RT_A;
  unsigned RT_CMD;
  unsigned wData;
 } CTRL;
} TMsg1553B;

#endif

#ifdef REMOTE_TERMINAL

typedef struct /*  ᮮ饭   */
{
 int hTMK;
 int fDir;
 unsigned wSA;
 unsigned cBusWords;
 unsigned cWords;
 void *pwBuf;
 int wResult;
} TMsgRT;

#endif

typedef union /*  ᠭ ନ  MIL-STD-1553B */
{
#ifdef BUS_CONTROLLER
 struct
 {
  unsigned wMode;
  TMsg1553B* apBaseMsg[BC_MAX_BASE+1];
  TMsg1553B* pLastMsg;
  unsigned awNextBase[BC_MAX_BASE+1];
  unsigned wActiveBase;
  unsigned wMaxBase;
  unsigned wFirstFreeBase;
  unsigned wLastUsedBase;
  unsigned fHardBit;
  unsigned wCI;
 } BC;
#endif
#ifdef REMOTE_TERMINAL
 struct structRT
 {
  unsigned wMode;
  unsigned wMaxPage;
  unsigned wPage;
  unsigned wTimerTicks;
  unsigned wTick;
  unsigned wMinSAR, wMaxSAR; /* ᯮ㥬  ᮢ ਥ */
  unsigned wMinSAT, wMaxSAT; /* ᯮ㥬  ᮢ । */
  TMsgRT *apSARMsg[31];
  TMsgRT *apSATMsg[31];
  void (* UserRFunc[31])( TMsgRT *pMsg );
  void (* UserTFunc[31])( TMsgRT *pMsg );
 } RT;
#ifdef RT_MANY_PAGES
 struct structRT aRT[RT_MAX_PAGE+1];
#endif
#endif
} TMK1553B;

/* ।  */

int __tmkMaxNumber = 0xFF;
TMK1553B TMK[TMK_MAX_NUMBER+1];

#ifdef REMOTE_TERMINAL

int __fTestActive;
int __awFlags[31]; /* ᨢ  ⥭ 䫠 */
#ifdef RT_MANY_PAGES
unsigned wRT_Page;
#endif

#endif

#if defined(REAL_TIME_CLOCK) | defined(REMOTE_TERMINAL)

int TimerInterrupt = 0;

#endif

#ifdef REAL_TIME_CLOCK

int __fTimerActive = 0;
unsigned __fTimerMask;
void (* __UserTimer)();
#ifdef __cplusplus
void interrupt (* __OldRTC)(...);
#else
void interrupt (* __OldRTC)();
#endif

#endif

#ifdef BUS_CONTROLLER

/* 㭪樨  ஫  */

void BC_InitMessage( TMsg1553B *pMsg )
{
 pMsg->Any.hTMK = -1;
 pMsg->Any.wBase = BC_UNDEFINED_BASE;
}

void BC_UndefMessage( TMsg1553B *pMsg )
{
 register wBase;
 register TMK1553B *pTMK;

 pTMK = TMK + pMsg->Any.hTMK;
 if ( pTMK->BC.pLastMsg == pMsg )
  pTMK->BC.pLastMsg = NULL;
 wBase = pMsg->Any.wBase;
 pTMK->BC.awNextBase[wBase] = pTMK->BC.wFirstFreeBase;
 pTMK->BC.wFirstFreeBase = wBase;
 pMsg->Any.wBase = BC_UNDEFINED_BASE;
/*pTMK->BC.apBaseMsg[wBase] = NULL;*/
}

void BC_FormMessage( int hMsgTMK,
		     TMsg1553B *pMessage,
		     enum TFormat1553B wMsgFormat,
		     unsigned fMsgAfterEnd,
		     void (*MsgUserFunc)(TMsg1553B*) )
{
 register TMsg1553B *pMsg;

 pMsg = pMessage;
 if ( pMsg->Any.hTMK != -1 )
  if ( pMsg->Any.wBase != BC_UNDEFINED_BASE )
   BC_UndefMessage( pMsg );
  else
   TMK[pMsg->Any.hTMK].BC.pLastMsg = NULL;
 pMsg->Any.wFormat = wMsgFormat;
 pMsg->Any.hTMK =  hMsgTMK;
 pMsg->Any.wBase = BC_UNDEFINED_BASE;
 pMsg->Any.fAfterEnd = fMsgAfterEnd;
 pMsg->Any.UserFunc = MsgUserFunc;
}

unsigned int BC_GetFreeBase( int hTMK, int nSelector )
{
 register unsigned wBase;
 register TMK1553B *pTMK;

 pTMK = TMK + hTMK;
 if ( ( wBase = pTMK->BC.wFirstFreeBase ) != BC_UNDEFINED_BASE )
 {
  pTMK->BC.wLastUsedBase = wBase;
  pTMK->BC.wFirstFreeBase = pTMK->BC.awNextBase[wBase];
  pTMK->BC.pLastMsg = NULL;
 }
 else if ( nSelector == ANY_BASE )
 {
  do
   if ( ( wBase = ++pTMK->BC.wLastUsedBase ) > pTMK->BC.wMaxBase )
    wBase = pTMK->BC.wLastUsedBase = 0;
  while ( wBase == pTMK->BC.wActiveBase );
  pTMK->BC.apBaseMsg[wBase]->Any.wBase = BC_UNDEFINED_BASE;
/*pTMK->BC.apBaseMsg[wBase] = NULL;*/
 }
 return wBase;
}

int BC_PutMessage( TMsg1553B *pMessage, unsigned wBase )
{
 register TMsg1553B *pMsg;
#ifdef __cplusplus
 register union { int hTMK; unsigned cmd; } r;
#else
 union { int hTMK; unsigned cmd; } r;
#endif

 pMsg = pMessage;
 TMK[r.hTMK = pMsg->Any.hTMK].BC.apBaseMsg[wBase] = pMsg;
 pMsg->Any.wBase = wBase;
 if ( tmkselect( r.hTMK ) )
  return tmkError;
 if ( bcdefbase( wBase ) )
  return tmkError;
 switch ( pMsg->Any.wFormat )
 {
 case BC_RT:
  bcputw( 0, ( pMsg->BC_RT.RT_A<<6 | pMsg->BC_RT.RT_SA )<<5 |
	  ( pMsg->BC_RT.cWords & NWORDS_MASK ) | RT_RECEIVE |
	  TMK[r.hTMK].BC.fHardBit );
  bcputblk( 1, pMsg->BC_RT.pwBuf, pMsg->BC_RT.cWords );
  pMsg->BC_RT.wCC = ( pMsg->BC_RT.RT_A == BROADCAST ) ?
		    DATA_BC_RT_BRCST : DATA_BC_RT;
  break;
 case RT_BC:
  bcputw( 0, ( pMsg->RT_BC.RT_A<<6 | pMsg->RT_BC.RT_SA )<<5 |
	  ( pMsg->RT_BC.cWords & NWORDS_MASK ) | RT_TRANSMIT |
	  TMK[r.hTMK].BC.fHardBit );
  pMsg->RT_BC.wCC = DATA_RT_BC;
  break;
 case RT_RT:
  bcputw( 0, ( pMsg->RT_RT.RTR_A<<6 | pMsg->RT_RT.RTR_SA )<<5 |
	  ( pMsg->RT_RT.cWords & NWORDS_MASK ) | RT_TRANSMIT |
	  TMK[r.hTMK].BC.fHardBit );
  bcputw( 1, ( pMsg->RT_RT.RTT_A<<6 | pMsg->RT_RT.RTT_SA )<<5 |
	  ( pMsg->RT_RT.cWords & NWORDS_MASK ) | RT_RECEIVE |
	  TMK[r.hTMK].BC.fHardBit );
  pMsg->RT_BC.wCC = ( pMsg->RT_RT.RTR_A == BROADCAST ) ?
		    DATA_RT_RT_BRCST : DATA_RT_RT;
  break;
 case CTRL:
  r.cmd = pMsg->CTRL.RT_A<<11 | TMK[r.hTMK].BC.wCI | pMsg->CTRL.RT_CMD;
  if ( r.cmd & 0x10 )
  {
   bcputw( 0, r.cmd );
   if ( r.cmd & RT_TRANSMIT )
    pMsg->CTRL.wCC = CTRL_C_AD;
   else
   {
    bcputw( 1, pMsg->CTRL.wData );
    pMsg->CTRL.wCC = ( pMsg->CTRL.RT_A == BROADCAST ) ?
		     CTRL_CD_BRCST : CTRL_CD_A;
   }
  }
  else
  {
   r.cmd |= RT_TRANSMIT;
   bcputw( 0, r.cmd );
   pMsg->CTRL.wCC = ( pMsg->CTRL.RT_A == BROADCAST ) ?
		    CTRL_C_BRCST : CTRL_C_A;
  }
 }
 return tmkError;
}

int BC_DefMessage( TMsg1553B *pMessage )
{
 register unsigned wBase;
 register TMsg1553B *pMsg;
 register TMK1553B *pTMK;

 pMsg = pMessage;
 pTMK = TMK + pMsg->Any.hTMK;
 PUSHF
 disable();
 if ( pTMK->BC.pLastMsg == pMsg )
 {
  wBase = pMsg->Any.wBase = pTMK->BC.wFirstFreeBase;
  pTMK->BC.wFirstFreeBase = pTMK->BC.awNextBase[wBase];
  pTMK->BC.pLastMsg = NULL;
 }
 else
  wBase = pMsg->Any.wBase;
 if ( wBase == BC_UNDEFINED_BASE )
 {
  if ( ( wBase = BC_GetFreeBase( pMsg->Any.hTMK, FREE_BASE ) )
       != BC_UNDEFINED_BASE )
   if ( BC_PutMessage( pMsg, wBase ) )
   {
    POPF
    return tmkError;
   }
 }
 else
 {
  pTMK->BC.wLastUsedBase = wBase;
 }
 POPF
 return 0;
}

int BC_StartMessage( TMsg1553B *pMessage )
{
 register unsigned wBase;
 register TMsg1553B *pMsg;
 register TMK1553B *pTMK;

 pMsg = pMessage;
 pTMK = TMK + pMsg->Any.hTMK;
 PUSHF
 disable();
 if ( pTMK->BC.pLastMsg == pMsg )
 {
  wBase = pMsg->Any.wBase = pTMK->BC.wFirstFreeBase;
  pTMK->BC.wFirstFreeBase = pTMK->BC.awNextBase[wBase];
  pTMK->BC.pLastMsg = NULL;
 }
 else
 {
  wBase = pMsg->Any.wBase;
 }
 if ( wBase == BC_UNDEFINED_BASE )
 {
  wBase = BC_GetFreeBase( pMsg->Any.hTMK, ANY_BASE );
  if ( BC_PutMessage( pMsg, wBase ) )
  {
   POPF
   return tmkError;
  }
 }
 else
 {
  pTMK->BC.wLastUsedBase = wBase;
  if ( tmkselect( pMsg->Any.hTMK ) )
  {
   POPF
   return tmkError;
  }
 }
 pTMK->BC.wActiveBase = wBase;
 POPF
 bcstart( wBase, pMsg->Any.wCC );
 return tmkError;
}

void far BC_AnyEnd( unsigned wResult, unsigned wAns1, unsigned wAns2 )
{
 unsigned wBase;
 register TMsg1553B *pMsg;
 register TMK1553B *pTMK;

 pTMK = TMK + tmkselected();
 wBase = pTMK->BC.wActiveBase;
 pTMK->BC.wActiveBase = BC_UNDEFINED_BASE;
 pMsg = pTMK->BC.apBaseMsg[wBase];
 if ( pMsg->Any.fAfterEnd == REMOVE_AFTER_END )
 {
  pMsg->Any.wBase = BC_UNDEFINED_BASE;
/*pTMK->BC.apBaseMsg[wBase] = NULL;*/
  pTMK->BC.awNextBase[wBase] = pTMK->BC.wFirstFreeBase;
  pTMK->BC.wFirstFreeBase = wBase;
  pTMK->BC.pLastMsg = pMsg;
 }
 if ( pMsg->Any.wResult = wResult )
 {
  if ( pMsg->Any.wFormat == RT_RT )
  {
   pMsg->RT_RT.wAnsT = wAns1;
   pMsg->RT_RT.wAnsR = wAns2;
  }
  else
   pMsg->Any.wAns = wAns1;
 }
 else
 {
  if ( pMsg->Any.wFormat == RT_RT )
  {
   pMsg->RT_RT.wAnsT = 0;
   pMsg->RT_RT.wAnsR = 0;
  }
  else
   pMsg->Any.wAns = 0;
 }
 if ( ( wResult & ~( IB_MASK | DI_MASK ) ) == 0 )
 {
  switch ( pMsg->Any.wFormat )
  {
  case RT_BC:
   bcgetblk( 2, pMsg->RT_BC.pwBuf, pMsg->RT_BC.cWords );
   break;
  case RT_RT:
   if ( pMsg->RT_RT.pwBuf != NULL )
    bcgetblk( 3, pMsg->RT_RT.pwBuf, pMsg->RT_RT.cWords );
   break;
  case CTRL:
   if ( pMsg->CTRL.wCC == CTRL_C_AD )
    pMsg->CTRL.wData = bcgetw( 2 );
  }
 }
 pMsg->Any.UserFunc( pMsg );
 bcrestore();
}

int BC_Init( int hTMK, unsigned fHardBit )
{
 register wBase;
 unsigned wNextBase;
 register TMK1553B *pTMK;

 if ( __tmkMaxNumber == 0xFF )
 {
  if ( ( __tmkMaxNumber = tmkgetmaxn() ) > TMK_MAX_NUMBER )
   __tmkMaxNumber = TMK_MAX_NUMBER;
  for ( wBase = 0; wBase <= __tmkMaxNumber; wBase++ )
   TMK[wBase].BC.wMode = 0xFF;
 }
 pTMK = TMK + hTMK;
 pTMK->BC.wMode = BC_MODE;
 if ( tmkselect( hTMK ) )
  return tmkError;
 bcreset();
 if ( ( pTMK->BC.wMaxBase = bcgetmaxbase() ) > BC_MAX_BASE )
  pTMK->BC.wMaxBase = BC_MAX_BASE;
 wBase = pTMK->BC.wMaxBase;
 wNextBase = BC_UNDEFINED_BASE;
 do
 {
  pTMK->BC.apBaseMsg[wBase] = NULL;
  pTMK->BC.awNextBase[wBase] = wNextBase;
  wNextBase = wBase;
 }
 while ( wBase-- );
 pTMK->BC.pLastMsg = NULL;
 pTMK->BC.wFirstFreeBase = 0;
 pTMK->BC.wActiveBase = BC_UNDEFINED_BASE;
 if ( fHardBit == HARD_BIT )
 {
  pTMK->BC.fHardBit = 0x0200;
  pTMK->BC.wCI = 0x03E0;
 }
 else
 {
  pTMK->BC.fHardBit = 0;
  pTMK->BC.wCI = 0;
 }
 bcdefintnorm( BC_AnyEnd );
 bcdefintexc( BC_AnyEnd );
 return 0;
}

#endif /* BUS_CONTROLLER */

#ifdef REMOTE_TERMINAL

/* 㭪樨  筮 ன⢠ */

#ifdef RT_MANY_PAGES
int RT_SelectPage( int hTMK, unsigned wTMKPage )
{
 if ( tmkselect( hTMK ) )
  return tmkError;
 if ( TMK[hTMK].RT.wMaxPage >= wTMKPage )
 {
  if ( rtdefpage( wTMKPage ) )
   return tmkError;
  TMK[hTMK].RT.wPage = wTMKPage;
 }
 return 0;
}
#endif

int RT_Init( int hTMK,
	     unsigned wTimerTicks,
	     void (far* UserCmdFunc)( unsigned ),
	     void (far* UserErrFunc)( unsigned ),
	     void (* UserRFunc)( TMsgRT* ),
	     void (* UserTFunc)( TMsgRT* ) )
{
 register unsigned wSA;
 register TMK1553B *pTMK;
#ifdef RT_MANY_PAGES
 unsigned wPage;
#endif

 if ( __tmkMaxNumber == 0xFF )
 {
  if ( ( __tmkMaxNumber = tmkgetmaxn() ) > TMK_MAX_NUMBER )
   __tmkMaxNumber = TMK_MAX_NUMBER;
  for ( wSA = 0; wSA <= __tmkMaxNumber; wSA++ )
   TMK[wSA].RT.wMode = 0xFF;
 }
 pTMK = TMK + hTMK;
 if ( tmkselect( hTMK ) )
  return tmkError;
 rtreset();
 pTMK->RT.wMode = RT_MODE;
 if ( ( pTMK->RT.wMaxPage = rtgetmaxpage() ) > RT_MAX_PAGE )
  pTMK->RT.wMaxPage = RT_MAX_PAGE;
#ifdef RT_MANY_PAGES
 for ( wPage = 0; wPage <= pTMK->RT.wMaxPage; wPage++ )
 {
  RT_SelectPage( hTMK, wPage );
#endif
 for ( wSA = 1; wSA <= 30; wSA++ )
 {
  rtdefsubaddr( RT_RECEIVE, wSA );
  rtsetflag();
  pTMK->RTP.apSARMsg[wSA] = NULL;
  pTMK->RTP.UserRFunc[wSA] = UserRFunc;
  rtdefsubaddr( RT_TRANSMIT, wSA );
  rtclrflag();
  pTMK->RTP.apSATMsg[wSA] = NULL;
  pTMK->RTP.UserTFunc[wSA] = UserTFunc;
 }
 pTMK->RTP.wTimerTicks = wTimerTicks;
 pTMK->RTP.wTick = 0;
 pTMK->RTP.wMinSAR = 30;
 pTMK->RTP.wMaxSAR = 1;
 pTMK->RTP.wMinSAT = 30;
 pTMK->RTP.wMaxSAT = 1;
#ifdef RT_MANY_PAGES
 }
 RT_SelectPage( hTMK, 0 );
#endif
 rtdefintcmd( UserCmdFunc );
 rtdefinterr( UserErrFunc );
 return 0;
}

void RT_DefSARFunc( int hTMK, unsigned wSA, void (* UserFunc )( TMsgRT* ) )
{
 TMK[hTMK].RTP.UserRFunc[wSA] = UserFunc;
}

void RT_DefSATFunc( int hTMK, unsigned wSA, void (* UserFunc )( TMsgRT* ) )
{
 TMK[hTMK].RTP.UserTFunc[wSA] = UserFunc;
}

int RT_DefMessage( int hTMK, TMsgRT *pMsg )
{
 register unsigned wSA;
 register TMK1553B *pTMK;

 wSA = pMsg->wSA;
 pTMK = TMK + hTMK;
 if ( tmkselect( hTMK ) )
  return tmkError;
 pMsg->hTMK = hTMK;
 switch ( pMsg->fDir )
 {
 case RT_RECEIVE:
  pTMK->RTP.apSARMsg[wSA] = pMsg;
  rtdefsubaddr( RT_RECEIVE, wSA );
  rtclrflag();
  if ( pTMK->RTP.wMinSAR > wSA )
   pTMK->RTP.wMinSAR = wSA;
  if ( pTMK->RTP.wMaxSAR < wSA )
   pTMK->RTP.wMaxSAR = wSA;
  break;
 case RT_TRANSMIT:
  pTMK->RTP.apSATMsg[wSA] = pMsg;
  rtdefsubaddr( RT_TRANSMIT, pMsg->wSA );
  rtputblk( 0, pMsg->pwBuf, pMsg->cWords );
  rtsetflag();
  if ( pTMK->RTP.wMinSAT > wSA )
   pTMK->RTP.wMinSAT = wSA;
  if ( pTMK->RTP.wMaxSAT < wSA )
   pTMK->RTP.wMaxSAT = wSA;
 }
 return tmkError;
}

int RT_UndefMessage( TMsgRT *pMsg )
{
 register unsigned wSA;
 register TMK1553B *pTMK;

 wSA = pMsg->wSA;
 pTMK = TMK + pMsg->hTMK;
 if ( tmkselect( pMsg->hTMK ) )
  return tmkError;
 switch ( pMsg->fDir )
 {
 case RT_RECEIVE:
  pTMK->RTP.apSARMsg[wSA] = NULL;
  rtdefsubaddr( RT_RECEIVE, wSA );
  rtsetflag();
  if ( wSA == pTMK->RTP.wMaxSAR )
  {
   while ( --wSA && pTMK->RTP.apSARMsg[wSA] == NULL );
   if ( !wSA )
   {
    wSA++;
    pTMK->RTP.wMinSAR = 30;
   }
   pTMK->RTP.wMaxSAR = wSA;
  }
  else if ( wSA == pTMK->RTP.wMinSAR )
  {
   while ( pTMK->RTP.apSARMsg[++wSA] == NULL );
   pTMK->RTP.wMinSAR = wSA;
  }
  break;
 case RT_TRANSMIT:
  pTMK->RTP.apSATMsg[wSA] = NULL;
  rtdefsubaddr( RT_TRANSMIT, wSA );
  rtclrflag();
  if ( wSA == pTMK->RTP.wMaxSAT )
  {
   while ( --wSA && pTMK->RTP.apSATMsg[wSA] == NULL );
   if ( !wSA )
   {
    wSA++;
    pTMK->RTP.wMinSAT = 30;
   }
   pTMK->RTP.wMaxSAT = wSA;
  }
  else if ( wSA == pTMK->RTP.wMinSAT )
  {
   while ( pTMK->RTP.apSATMsg[++wSA] == NULL );
   pTMK->RTP.wMinSAT = wSA;
  }
 }
 return 0;
}

void RT_TestFlags()
{
 int hTMK, cWords;
 register unsigned wSA;
 register TMK1553B *pTMK;
 register TMsgRT *pMsg;

 if ( __fTestActive )
  return;
 __fTestActive = 1;
 enable();
 for ( hTMK = 0; hTMK <= __tmkMaxNumber; hTMK++ )
 {
  pTMK = TMK + hTMK;
  if ( pTMK->RT.wMode != RT_MODE )
   continue;
  if ( TimerInterrupt &&
     ( !pTMK->RTP.wTimerTicks || ++pTMK->RTP.wTick < pTMK->RTP.wTimerTicks ) )
   continue;
  pTMK->RTP.wTick = 0;
  tmkselect( hTMK );
  rtgetflags( __awFlags + pTMK->RTP.wMinSAR,
	      RT_RECEIVE, pTMK->RTP.wMinSAR, pTMK->RTP.wMaxSAR );
  for ( wSA = pTMK->RTP.wMinSAR; wSA <= pTMK->RTP.wMaxSAR; wSA++ )
  {
   if ( !( __awFlags[wSA] & RT_FLAG_MASK ) ||
	( ( pMsg = pTMK->RTP.apSARMsg[wSA] ) == NULL ) )
    continue;
   rtdefsubaddr( RT_RECEIVE, wSA );
   if ( __awFlags[wSA] & RT_ERROR_MASK )
    pMsg->wResult = RT_RECEIVE_ERROR;
   else
   {
    if ( ( cWords = __awFlags[wSA] & NWORDS_MASK ) == 0 )
     cWords = 32;
    pMsg->cBusWords = cWords;
    if ( pMsg->cWords == 0 || pMsg->cWords == cWords )
     pMsg->wResult = RT_OK;
    else
    {
     pMsg->wResult = RT_BLKSIZE_ERROR;
     if ( cWords > pMsg->cWords )
      cWords = pMsg->cWords;
    }
    rtgetblk( 0, pMsg->pwBuf, cWords );
   }
   pTMK->RTP.UserRFunc[wSA]( pMsg );
  }
  rtgetflags( __awFlags + pTMK->RTP.wMinSAT,
	      RT_TRANSMIT, pTMK->RTP.wMinSAT, pTMK->RTP.wMaxSAT );
  for ( wSA = pTMK->RTP.wMinSAT; wSA <= pTMK->RTP.wMaxSAT; wSA++ )
  {
   if ( ( __awFlags[wSA] & RT_FLAG_MASK ) ||
	( ( pMsg = pTMK->RTP.apSATMsg[wSA] ) == NULL ) )
    continue;
   if ( ( cWords = __awFlags[wSA] & NWORDS_MASK ) == 0 )
    cWords = 32;
   pMsg->cBusWords = cWords;
   if ( cWords == pMsg->cWords )
    pMsg->wResult = RT_OK;
   else
    pMsg->wResult = RT_BLKSIZE_ERROR;
   pTMK->RTP.UserTFunc[wSA]( pMsg );
  }
 }
 __fTestActive = 0;
}

#endif /* REMOTE_TERMINAL */

#ifdef REAL_TIME_CLOCK

/* 㭪樨    ⥬ RTC  IBM PC AT */

#ifdef __cplusplus
void interrupt RealTimeClock( ... )
#else
void interrupt RealTimeClock()
#endif

{
 register char r;

 outportb( 0x70, 0x0B );
 goto rtc1; rtc1:
 r = inportb( 0x71 );
 goto rtc2; rtc2:
 outportb( 0x70, 0x0C );
 goto rtc4; rtc4:
 if ( inportb( 0x71 ) & 0x20  &&  r & 0x20 )
  geninterrupt( 0x4A );
 if ( !__fTimerActive )
 {
  __fTimerActive = 1;
  if ( __fTimerMask )
  {
   tmksave();
   outportb( 0xA1, inportb( 0xA1 ) & 0xFE );
  }
  outportb( 0xA0, 0x20 );
  outportb( 0x20, 0x20 );
  TimerInterrupt = 1;
  __UserTimer();
  TimerInterrupt = 0;
  if ( __fTimerMask )
   tmkrestore();
  disable();
  __fTimerActive = 0;
 }
 else
 {
  outportb( 0xA0, 0x20 );
  outportb( 0x20, 0x20 );
 }
}

void TimerMask()
{
 outportb( 0xA1, inportb( 0xA1 ) | 0x01 );
}

void TimerUnmask()
{
 outportb( 0xA1, inportb( 0xA1 ) & 0xFE );
}

void TimerSetTick( char bTimerTick )
{
 PUSHF
 disable();
 outportb( 0x70, 0x0A );
 goto stt1;
 stt1:
 outportb( 0x71, bTimerTick );
 POPF
}

int TimerInit( char bTimerTick, unsigned fMask, void (* UserTimerFunc)() )
{
 struct REGPACK r86;
 static char flag;

 r86.r_ax = 0x8300;
 r86.r_bx = FP_OFF( &flag );
 r86.r_es = FP_SEG( &flag );
 r86.r_cx = 0;
 r86.r_dx = 10000;
 intr( 0x15, &r86 );
 if ( r86.r_flags & 1 )
  return TIMER_NOT_AVAILABLE;
 __fTimerMask = fMask;
 if ( fMask )
  tmkdefirq( 8 );
 __UserTimer = UserTimerFunc;
 TimerSetTick( bTimerTick );
 __OldRTC = getvect( 0x70 );
 setvect( 0x70, RealTimeClock );
 return 0;
}

void TimerRestore()
{
 struct REGPACK r86;

 TimerSetTick( TICK_1ms );
 setvect( 0x70, __OldRTC );
 if ( __fTimerMask )
  tmkundefirq( 8 );
 r86.r_ax = 0x8301;
 intr( 0x15, &r86 );
}

#endif /* REAL_TIME_CLOCK */
