/*
        ⫠稪 ⨯᭮    26765.52-87. 1997-2002.
*/

#include <conio.h>
#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <bios.h>
#include <dos.h>
#include <errno.h>
#include <process.h>
#include <stdlib.h>
//#include <malloc.h>

//#define TT 1
//#define TX 2
//#define TS 3
//#define TD 4

#define TRUE 1
#define FALSE 0

#define ESC 27
#define ENTER 13
#define TAB 0x09
#define SPACE 32
#define BS 8
#define EXT_CODE 0
/*
#define UP 72
#define DOWN 80
#define LEFT 75
#define RIGHT 77
#define PGDN 81
#define PGUP 73
*/
#define INS 82
#define DEL 83

#define CR 0x0D                 /*  ⪨ */
#define LF 0x0A
#define CTRL_C 0x03
#define ESCAPE 0x1B
#define BACKSPACE 0x08
                                /* ७  ASCII */
#define AltF03 0x6A
#define AltF04 0x6B
#define AltF05 0x6C
#define F01 0x3B
#define F02 0x3C
#define F03 0x3D
#define F04 0x3E
#define F05 0x3F
#define F06 0x40
#define F07 0x41
#define F08 0x42
#define F09 0x43
#define F10 0x44
#define PGUP 0x49
#define PGDN 0x51
#define HOME 0x47
#define END 0x4F
#define LEFT 0x4B
#define RIGHT 0x4D
#define UP 0x48
#define DOWN 0x50
#define GPLUS 0x4E
#define CTRLLEFT 0x73
#define CTRLRIGHT 0x74

#define DATA_N 1
#define DATA_ADR 2
#define DATA_DATA 3
#define CMD_FMT 1
#define DATA_FMT 2
#define READ_HEAD 1
#define READ_BODY 2


#define x0 0                           /* 窠 ਢ離 ⨭ */
#define y0 0

int make_cmd(char *str);                 /* ࠡ⪠  ப */
void make_quit(char *str);               /* প 室  ⫠稪 */

void comment(char *str);                 /* 뢮  */
void kbd_pause(char *str);               /* ணࠬ㥬 㧠 */
void interrupt prtscr_brk(...);         /* ࠡ稪 뢠 PrtScr */
void exe_open(char *str);                /*  㣮 ணࠬ */
void cmds_open(char *str);               /* ⨥  䠩 */
void cmds_open2(char *str);              /* 믮  䠩   横 */
void set_count(char *str);               /* ⠭ 横 ७  */
int end_ctrl(char *str);                 /* ஫  ப */
void msg_out(char *msg);                 /* 뢮 ப ᮮ饭 */
void in_cmd(char *str);                  /* ਥ  ப */
void make_func(unsigned key);            /* ࠡ⪠ 㭪樮  */
void make_ctrl(int key);                 /* ࠡ⪠ ࠢ  */
                                         /* ஢      */
void all_screen();                       /* 뢮 ᥣ ࠭ */
void set_mode(int mode);
void clear_statistic();

#define OLDS 10

char szcomment[80];
int fGoto = 0;
char szGoto[16];
int fAvt = 0;
int fCSG = 0;
int nExeResult;
long cmd_count = 1;               /* 稪 ७  */
long cur_count;                 /* ⥪騩 稪 横 ७ */
char cmd_str[80];               /*    */
int iOldCmd = 0;
int cOldCmds = 0;
char old_cmd[OLDS][80];           /*  ன  ப */
char ex_fname[80];              /*  横᪨ 믮塞 . 䠩 */
int str_ptr = 0;                  /* 㪠⥫     ᮫ */
volatile int prtscr_flag = 0;     /* 䫠  PrtScr */
void interrupt (*oldvect3)(...);   /* ஥ 祭  PrtScr */

unsigned wPort;
unsigned nIrq;
//char data_fname[16] = "";
FILE *in_file;                  /* 䠩     */
FILE *out_file;                 /* 䠩 뢮    */
FILE *cmd_file;                 /* 䠩   */
int enter_mode = 0;             /* ०  : 0 -  ᮫, 
                                                       1 -  䠩 */
char buf_str[100];              /*   ࠡ  䠩  */

                                /* 㪠⥫  ᮮ饭  訡 */
char *inp_err = "訡 ";
char *base_err = "୮ 祭 ";
char *stop_adr_err = "୮ 祭  ⠭";
char *stop_err = "୮ 祭 ० ⠭";
char *start_err = "୮ 祭 ० ᪠";
char *bad_mode2 = "訡   ࠢ";
char *bad_rt_addr = "訡   ";
char *cc_no_def = " ࠢ XXXX  ।";
char *mark_err = "४  ᫮";
char *undef_cmd = "  ";
char *const_err = "୮ 祭 ⠭";
char *cr_err = "訡 ᮧ 䠩";
char *open_err = "訡  䠩";
char *format_err = "訡 ଠ 室 䠩";
char *can_num_err = "訡  ";
char *bad_stop_mode = "訡   ० ⠭";
char *bad_mode = "ୠ   ⥪饣 ०";

char *reset_ok = "஫ 襭";
char *no_int = "室  ⠩-";
char *int_ok = "뢠";
char *kbd_break = " ࢠ";

int fStopCmd = 0;

int nDevices = 0;
int nMode = 0;

#ifdef TT
#include "tt.cpp"
#endif
#ifdef TX
#include "tx.cpp"
#endif
#ifdef TS
#include "ts.cpp"
#endif
#ifdef TD
#include "td.cpp"
#endif

void main(int argc, char *argv[])
{
  int i, fArgErr;

  textmode(C80);        /* ࠬ ࠭ */
  textcolor(LIGHTGRAY);
  textbackground(BLACK);
  clrscr();
  wPort = 0;
  nIrq = 0;
#ifdef TT
  tt_init_tt();
#endif
#ifdef TX
  tx_init_tx();
#endif
#ifdef TS
  ts_init_ts();
#endif
#ifdef TD
  td_init_td();
#endif
  fArgErr = 0;
  for (i = 1; i < argc && !fArgErr; ++i)
  {
    switch (*argv[i])
    {
    case 'p':
    case 'P':
      if (nDevices > 1 || sscanf(argv[i]+1, "%X", &wPort) != 1)
        fArgErr = 1;
      break;
    case 'i':
    case 'I':
      if (nDevices > 1 || sscanf(argv[i]+1, "%d", &nIrq) != 1)
        fArgErr = 1;
      break;
#ifdef TT
    case 't':
    case 'T':
      if (tt_args(argv[i]+1))
        fArgErr = 1;
      break;
#endif
#ifdef TX
    case 'x':
    case 'X':
      if (tx_args(argv[i]+1))
        fArgErr = 1;
      break;
#endif
#ifdef TS
    case 's':
    case 'S':
      if (ts_args(argv[i]+1))
        fArgErr = 1;
      break;
#endif
#ifdef TD
    case 'd':
    case 'D':
      if (td_args(argv[i]+1))
        fArgErr = 1;
      break;
#endif
    default:
      fArgErr = 1;
      break;     
    }
  }
  if (fArgErr)
  {
    printf("訡  ࠬ: %s\n", argv[i]);
    goto stop;
  }

#ifdef TT
  tt_setup();
#endif
#ifdef TX
  tx_setup();
#endif
#ifdef TS
  ts_setup();
#endif
#ifdef TD
  td_setup();
#endif
  
  oldvect3 = getvect(0x05);
  setvect(0x05, prtscr_brk);
  prtscr_flag = 0;

  nMode = 0;
#ifdef TT
  tt_init();
  if (nMode == 0)
    nMode = TT;
#endif
#ifdef TX
  tx_init();
  if (nMode == 0)
    nMode = TX;
#endif
#ifdef TS
  ts_init();
  if (nMode == 0)
    nMode = TS;
#endif
#ifdef TD
  td_init();
  if (nMode == 0)
    nMode = TD;
#endif

  all_screen();
  while (1)
  {                   /*   믮  */
    if (fAvt && !enter_mode)
    {
      fAvt = 0;
      all_screen();
      comment(szcomment);
    }
    in_cmd(cmd_str);
    make_cmd(cmd_str);
  }
  stop:
  exit(0);
}

void make_quit(char *str)      /* প 室  ⫠稪 */
{
  if (end_ctrl(str)) return;

#ifdef TT
  tt_make_quit("");
#endif
#ifdef TX
  tx_make_quit("");
#endif
#ifdef TS
  ts_make_quit("");
#endif
#ifdef TD
  td_make_quit("");
#endif

  setvect(0x05, oldvect3);
  clrscr();
  puts(" ⫠稪 祭.");
  exit(0);
}

int make_cmd(char *str)
/* ࠡ⪠  ப, 室  믮  */
{
  int i;

  if (*str == '\0')
    all_screen();
  else if (!enter_mode)
  {
    if (cOldCmds < OLDS)
      ++cOldCmds;
    for (i = cOldCmds-1; i > 0; --i)
      strcpy(old_cmd[i], old_cmd[i-1]);
    strcpy(old_cmd[0], cmd_str);
    iOldCmd = 0;
  }
  while (*str == ' ' || *str == '\t') str++;
  if (*str == ':')
  {
    if (enter_mode && fGoto && !strcmp(str+1, szGoto))
      fGoto = 0;
  }
  else if (fGoto)
    ;
  else if (!strcmp(str, "Q"))
    make_quit("");
  else if (!strncmp(str, "R< ", 3) && cmd_count == 1)
    cmds_open(str+3);
  else if (!strncmp(str, "R< ", 3) && cmd_count != 1)
    cmds_open2(str+3);
  else if (!strncmp(str, "RE ", 3))
    exe_open(str+3);
  else if (!strcmp(str, "P"))
    kbd_pause("");
  else if (!strncmp(str, "P ", 2))
    kbd_pause(str+2);
  else if (!strncmp(str, "C ", 2))
    set_count(str+2);
  else if (!strncmp(str, ";", 1))
    comment(str+1);
  else if (!strncmp(str, "GOTO ", 5))
  {
    if (enter_mode)
    {
      fseek(cmd_file, 0L, SEEK_SET);
      fGoto = 1;
      strcpy(szGoto, str+5);
    }
  }
  else if (!strcmp(str, "AVT"))
  {
    if (enter_mode)
      fAvt = 1;
  }
  else if (!strncmp(str, "#", 1))
    ;
  else if (!strcmp(str, "CSG+"))
    fCSG = 1;
  else if (!strcmp(str, "CSG-"))
    fCSG = 0;
#ifdef TT
  else if (!strcmp(str, "TT"))
    set_mode(TT);
#endif
#ifdef TX
  else if (!strcmp(str, "TX"))
    set_mode(TX);
#endif
#ifdef TS
  else if (!strcmp(str, "TS"))
    set_mode(TS);
#endif
#ifdef TD
  else if (!strcmp(str, "TD"))
    set_mode(TD);
#endif
#ifdef TT
  else if (!strncmp(str, "T_", 2))
    tt_make_cmd(str+2);
#endif
#ifdef TX
  else if (!strncmp(str, "X_", 2))
    tx_make_cmd(str+2);
#endif
#ifdef TS
  else if (!strncmp(str, "S_", 2))
    ts_make_cmd(str+2);
#endif
#ifdef TD
  else if (!strncmp(str, "D_", 2))
    td_make_cmd(str+2);
#endif
#ifdef TT
  else if (nMode == TT)
    tt_make_cmd(str);
#endif
#ifdef TX
  else if (nMode == TX)
    tx_make_cmd(str);
#endif
#ifdef TS
  else if (nMode == TS)
    ts_make_cmd(str);
#endif
#ifdef TD
  else if (nMode == TD)
    td_make_cmd(str);
#endif
  else if (*str != '\0') msg_out(undef_cmd);
  return 0;
}

int end_ctrl(char *str)
                           /* ஫  ப(   㬥⮢):
                              1 -  ப  - 饥 ,
                              0 -  ப                         */
{
  while (*str=='\t' || *str==' ') str++;
  if (*str)
  {
    msg_out(undef_cmd); return 1;
  }
  else return 0;
}

void exe_open(char *str)
{
  char *pszArg, *psz1;
  char *argv[10];
  int iarg;

  while (*str==' ' || *str=='\t') str++;
  if (*str=='\0')
  {
    msg_out(format_err);
    return;
  }
  iarg = 0;
  do
  {
    while (*str==' ' || *str=='\t') str++;
    if (*str!='\0')
    {
      argv[iarg] = new char[32];
      psz1 = argv[iarg];
      while (*str!=' ' && *str!='\t' && *str!='\0')
       *psz1++ = *str++;
      *psz1 = '\0';
      ++iarg;
    }
  }
  while (*str!='\0');
  clrscr();
  if (strstr(argv[0], ".BAT") != NULL || strstr(argv[0], ".bat") != NULL)
  {
    int i;
    argv[iarg++] = new char[32];
    argv[iarg++] = new char[32];
    for (i = iarg-3; i>=0; --i)
      strcpy(argv[i+2], argv[i]);
    strcpy(argv[1], "/C");
    strcpy(argv[0], "command.com");
    argv[iarg] = NULL;
    nExeResult = spawnvp(P_WAIT, argv[0], argv);
  }
  else
  {
    argv[iarg] = NULL;
    nExeResult = spawnv(P_WAIT, argv[0], argv);
  }
  do
    delete argv[--iarg];
  while (iarg>0);
  all_screen();
  if (nExeResult < 0)
  {
    msg_out(open_err);
    return;
  }
}

void cmds_open(char *str)                       /* ⨥  䠩 */
{
  while (*str==' ' || *str=='\t') str++;
  if (enter_mode)          /* ᫨  䠩 뢠   */
  {
    fclose(cmd_file);
    enter_mode=0;
  }
  if ((cmd_file=fopen(str, "rt"))==NULL)
  {
    msg_out(open_err);
    return;
  }
  enter_mode=1;
  fStopCmd = 0;
  prtscr_flag = 0;
}

void cmds_open2(char *str)           /* 믮  䠩   横 */
{
  if (cmd_count == 0) return;
  strcpy(ex_fname, str);
  cur_count = cmd_count;
  cmds_open(ex_fname);
}

void set_count(char *str)       /* ⠭ 横 ७  */
{
  unsigned long c;

  if (sscanf(str, "%U", &c)!=1)
  {
    msg_out(inp_err);
    return;
  }
  cmd_count=c;
#ifdef TT
  if (nMode == TT)
    tt_out_count();
#endif
#ifdef TX
  if (nMode == TX)
    tx_out_count();
#endif
#ifdef TS
  if (nMode == TS)
    ts_out_count();
#endif
#ifdef TD
  if (nMode == TD)
    td_out_count();
#endif
}

void comment(char *str)                          /* 뢮  */
{
  gotoxy(x0+1, y0+22);
  clreol();
  puts(str);
  strcpy(szcomment, str);
}

void kbd_pause(char *str)                        /* ணࠬ㥬 㧠 */
{
  unsigned long p;

  while (*str == '\t' || *str == ' ') str++;
  if (*str != '\0')
  {                                  /* 㧠 ணࠬ㥬 ⥫쭮 */
    if (sscanf(str, "%U", &p) != 1)
    {
      msg_out(inp_err);
      return;
    }
    for (; p-- ;);
    return;
  }
  gotoxy(x0+1, y0+24);                          /*    */
  textcolor(CYAN);
  cprintf("㧠. ESC -    ०, 㣠 - த 믮.");
  textcolor(LIGHTGRAY);
  while (kbhit() == 0);
  gotoxy(x0+1, y0+24);
  clreol();
  if ((bioskey(0)&0x00FF) == ESCAPE)
  {
    if (enter_mode)
    {
      fclose(cmd_file);
      enter_mode = 0;
    }
  }
}

void interrupt prtscr_brk(...)          /* ࠡ稪 뢠  PrtScr */
{
  prtscr_flag = 1;
}

void msg_out(char *msg)                  /* 뢮 ப ᮮ饭 */
{
  gotoxy(x0+1, y0+24);
  textcolor(CYAN);
  cprintf("%s.   ...", msg);
  textcolor(LIGHTGRAY);
  while (kbhit() == 0);
  bioskey(0);
  gotoxy(x0+1, y0+24);
  clreol();
}

void in_cmd(char *str)
/*   ப  str, ᥫ஢ ࠢ  㭪樮 */
{
  int key, cx, cy;                      /*  ਭ  , ... */
  char ch;

  gotoxy(x0+1, y0+20);
  clreol();
  printf(": ");
  str_ptr = 0;
  do
  {
    if (enter_mode)
    {
      if (prtscr_flag)
      {
        key = EOF;
        cur_count = 1;
        prtscr_flag = 0;
      }
      else
        key = fgetc(cmd_file);          /* ⥭ ᨬ   䠩 */
      if (key == EOF)
      {
        fclose(cmd_file);
        if (cmd_count != 1 && --cur_count != 0)
        {
          cx = wherex(); cy = wherey();       /* 横᪮ 믮 */
          gotoxy(x0+39, y0+1);
          printf("%010lu", cur_count);
          gotoxy(cx, cy);
          cmds_open(ex_fname);
          key = fgetc(cmd_file);
        }
        else
        {
          if (fAvt)
          {
            fAvt = 0;
            all_screen();
            comment(szcomment);
          }
          enter_mode = 0;                /* 襭 横 */
          cx = wherex(); cy = wherey();
          gotoxy(x0+39, y0+1);
          printf("%010lu", cmd_count);
          gotoxy(cx, cy);
          key = bioskey(0);
        }
      }
    }
    else
      key = bioskey(0);

    if (key&0x00FF)
    {
      if ((key &= 0x00FF) < 0x20 && key != CR && key != LF)
      {
        make_ctrl(key);
        continue;
      }
      key = str[str_ptr++] = toupper(key &= 0x00FF);
      putchar(key);
    }
    else
    {
      make_func(key >> 8);
      continue;
    }
  }
  while (key != CR && key != LF);
  str[--str_ptr] = '\0';
}

void make_ctrl(int key)
                /* ࠡ⪠ ࠢ , key - ࠢ騩 . */
{
  switch (key)
  {
    case BACKSPACE:
      if (str_ptr != 0)     /*  */
      {
        --str_ptr;
        printf("\b \b");
      }
      break;
    case ESCAPE:       /* ⬥ ᥩ ப */
      str_ptr = 0;
      iOldCmd = 0;
      gotoxy(x0+10, y0+20);
      clreol();
      break;
  }
}

void make_func(unsigned key)
/*
ࠡ⪠ 㭪樮 , F1..F10
key - ७  ASCII
*/
{
  int i;

  switch (key)
  {
  case UP:
    gotoxy(x0+1, y0+20);         /*   ।饩  */
    clreol();
    printf(": ");
    str_ptr = stpcpy(cmd_str, old_cmd[iOldCmd])-cmd_str;
    if (++iOldCmd >= cOldCmds)
      iOldCmd = 0;
    printf("%s", cmd_str);
    break;
  case F10:
    make_quit("");
    break;
  default:
    switch (nMode)
    {
#ifdef TT
    case TT:
      tt_make_func(key);
      break;
#endif
#ifdef TX
    case TX:
      tx_make_func(key);
      break;
#endif
#ifdef TS
    case TS:
      ts_make_func(key);
      break;
#endif
#ifdef TD
    case TD:
      td_make_func(key);
      break;
#endif
    }
  }
  gotoxy(x0+1, y0+20); /* ⠭  ப */
  clreol();
  printf(": ");
  cmd_str[str_ptr] = '\0';
  printf(cmd_str);
}

void all_screen()
{
  if (!fAvt)
  {
#ifdef TT
    if (nMode == TT)
      tt_all_screen();
#endif
#ifdef TX
    if (nMode == TX)
      tx_all_screen();
#endif
#ifdef TS
    if (nMode == TS)
      ts_all_screen();
#endif
#ifdef TD
    if (nMode == TD)
      td_all_screen();
#endif
  }
}

void set_mode(int mode)
{
  nMode = mode;
  all_screen();
}

void clear_statistic()
{
#ifdef TT
  tt_statistic_clear();
#endif
#ifdef TX
  tx_statistic_clear();
#endif
#ifdef TS
  ts_statistic_clear();
#endif
#ifdef TD
  td_statistic_clear();
#endif
}