void tt_set_mode_rt()
{
  tt_mode1=(tt_mode1&0x7FFF)|TT_RT_MODE;
  tt_mode2=(tt_mode2&0x07FF)|(tt_rt_addr<<11);
  tt_out_mode();
}
void tt_set_mode_bc()
{
  tt_mode1=(tt_mode1&0x7FFF)|TT_BC_MODE;
  tt_mode2=(tt_mode2&0x07FF)|(tt_bc_can<<15);
  tt_out_mode();
}

void tt_set_number(int can)     /*  ⠭   */
{
  if ((tt_mode1&0x8000)==TT_RT_MODE)
  {
    msg_out(bad_mode);
    return;
  }
  if (can==1)
  {
    tt_bc_can=0;
    tt_mode2&=0x7FFF;
  }
  else
  {
    tt_bc_can=1;
    tt_mode2|=0x8000;
  }
  tt_out_number();
}

void tt_set_rt_addr(char *str)
{
  char ch, *ptr;
  int mode22;

  if ((tt_mode1&0x8000)==TT_BC_MODE)
  {
    msg_out(bad_mode);
    return;
  }
  while (*str=='\t' || *str==' ') str++;
  ptr=str;
  while ((ch=*(ptr++))!='\0')
    if (ch!='0' && ch!='1')
    {
      msg_out(bad_rt_addr);
      return;
    }
  --ptr;
  if (ptr-str > 5)
  {
    msg_out(bad_rt_addr);
    return;
  }
  ptr=str;
  for (mode22=0; *ptr!='\0'; ptr++)
  {
    mode22<<=1;
    if (*ptr=='1') mode22++;
  }
  tt_mode2=(tt_mode2&0x07FF)|(mode22<<11);
  tt_rt_addr=mode22;
  tt_out_mode2();
}

void tt_set_stop_mode_reg(char *str)
{
  char ch, *ptr;
  int mode22;

  while (*str=='\t' || *str==' ') str++;
  ptr=str;
  while ((ch=*(ptr++))!='\0')
    if (ch!='0' && ch!='1')
    {
      msg_out(bad_stop_mode);
      return;
    }
  --ptr;
  if (ptr-str > 3)
  {
    msg_out(bad_stop_mode);
    return;
  }
  ptr=str;
  for (mode22=0; *ptr!='\0'; ptr++)
  {
    mode22<<=1;
    if (*ptr=='1') mode22++;
  }
  tt_mode1=(tt_mode1&0x8FFF)|(mode22<<12);
  tt_out_stop_mode();
}

void tt_set_stop_addr_reg(char *str)
{
  unsigned i;

  if (sscanf(str, "%x", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
  if (i>0x0FFF)
  {
    msg_out(base_err);
    return;
  }
  if (i<0x400)
    i += 0x400;
  tt_mode1=(tt_mode1&0xF000)|i;
  tt_out_stop_addr();
}

void tt_set_base(char *str)
/*     ப: 1 - 訡, 0 -   浪 */
{
  unsigned i;

  if (sscanf(str, "%x", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
  if (tt_DispMode==TT_DISP_GEN)
  {
    if (i>(TT_SEQ_RAM_SIZE/TT_PAGE_SIZE-1))
    {
      msg_out(base_err);
      return;
    }
  }
  else
  {
    if (i>(TT_REG_RAM_SIZE/TT_REG_PAGE_SIZE-1))
    {
      msg_out(base_err);
      return;
    }
  }
  tt_base=i;
  tt_out_base();
  tt_buf_mark=0;
  tt_in_ed_word=3;
  tt_buf_adr=tt_base*TT_PAGE_SIZE;
  tt_out_buffer(tt_base);
}

void tt_set_stop_addr_gen(char *str)
{
  unsigned i;

  if (sscanf(str, "%u", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
  if (i>=((unsigned)TT_SEQ_RAM_SIZE))
  {
    msg_out(inp_err);
    return;
  }
  tt_mode2 = (tt_mode2&0xF800)|i;
  tt_out_mode2();
}


void tt_set_time_gen(char *str)
/*  ६   ப */
{
  unsigned i;

  if (sscanf(str, "%u", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
  if (i>((unsigned)TT_SEQ_RAM_SIZE*4))
  {
    msg_out(inp_err);
    return;
  }
  tt_mode2 = (tt_mode2&0xF800)|(i/4);
  if (i&0x3)
   tt_mode2+=1;
  tt_out_mode2();
}

void tt_set_add_time_gen(char *str)
/*  ६   ப */
{
  int i;

  if (sscanf(str, "%d", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
//  if (i>((unsigned)TT_SEQ_RAM_SIZE*4))
//  {
//    msg_out(inp_err);
//    return;
//  }
  i += (int)(tt_mode2&0x7FF)*4;
  tt_mode2 = (tt_mode2&0xF800)|(i/4);
  if (i&0x3)
   tt_mode2+=1;
  tt_out_mode2();
}

void tt_set_global_add_time_gen(char *str)
/*  ६   ப */
{
  int i;

  if (sscanf(str, "%d", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
//  if (i>((unsigned)TT_SEQ_RAM_SIZE*4))
//  {
//    msg_out(inp_err);
//    return;
//  }
  tt_global_add_time = i;
}

void tt_set_mode2(char *str)           /*  ⠭  ࠢ */
{
  char ch, *ptr;
  int mode22;

  while (*str=='\t' || *str==' ') str++;
  ptr=str;
  while ((ch=*(ptr++))!='\0')
    if (ch!='0' && ch!='1')
    {
      msg_out(bad_mode2);
      return;
    }
  --ptr;
  if (ptr-str > TT_CC_SIZE)
  {
    msg_out(bad_mode2);
    return;
  }
  ptr=str;
  for (mode22=0; *ptr!='\0'; ptr++)
  {
    mode22<<=1;
    if (*ptr=='1') mode22++;
  }
  tt_mode2=mode22;
  tt_out_mode2();
}

void tt_set_pause(char *str)            /*  ⠭  ⠩- */
{
  unsigned long p;

  if (sscanf(str, "%U", &p)!=1)
  {
    msg_out(inp_err);
    return;
  }
  tt_pause=p;
  tt_out_pause();
}

void tt_set_thresold(char *str)
/*  ண ࠢ    ப */
{
  unsigned i;

  if (sscanf(str, "%u", &i)!=1)
  {
    msg_out(inp_err);
    return;
  }
  tt_thresold = i/5;
}
