#include <stdio.h>
#include "ltmk.c"
#define RT_ADDR 10 /*RT Address*/ /*   */ 

TTmkConfigData tmkCfg;
TTmkEventData tmkEvD;
int hTmk;
int events;

int main(int argc, char *argv[])
{
  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;
        
  if (TmkOpen())
  {
    printf("TmkOpen() failed!\n");
    goto stop;
  }
  printf("TmkOpen() successfull!\n");

  if (tmkconfig(hTmk) != 0)
  {
    printf("tmkconfig() failed!\n");
    printf("Somebody works with the card %d or the card doesn't exist in Registry\n",hTmk);
    goto stop;
  }
  tmkselect(hTmk);

  
/* init card in BC mode */
/*      */
  bcreset();

/* write the 'Tx 1 word to RT subaddr 16' message to the base 0 */
/*   0    1   16   */
  bcdefbase(0);
  bcputw(0, CW(RT_ADDR, RT_RECEIVE, 16, 1));
  bcputw(1, 0x1774);

/* write the 'Synchronize mode command' message to the base 1 */
/*   1      '' */
  bcdefbase(1);
  bcputw(0, CWM(RT_ADDR, CMD_SYNCHRONIZE));

/* start the message from the base 0, wait for interrupt, process results */
/*    0 ,      */
  bcstart(0, DATA_BC_RT);
  events = tmkwaitevents(1<<hTmk, -1);
  tmkgetevd(&tmkEvD);
  if (events < 0)
    printf("Error occured during interrupt waiting!\n");
  
  if (events == (1<<hTmk)) 
  {
    if (tmkEvD.nInt==1)
      printf ("The command of transfer of data BC-RT is executed sucessfully\n");
  
    if (tmkEvD.nInt==2)
    {
      printf("At performance of transfer of the data BC-RT:\n");
   
      if (tmkEvD.bc.wResult & S_ERAO_MASK)
        printf("The error in a field of the address received RW is found out\n");
      
      if (tmkEvD.bc.wResult & S_MEO_MASK)
        printf("The error of a code 'Manchester - 2' is found out at answer RT\n");
      
      if (tmkEvD.bc.wResult & S_EBC_MASK)
        printf("The error of the echo - control over transfer BC is found out\n");
      
      if (tmkEvD.bc.wResult & S_TO_MASK)       
        printf("It is not received the answer from RT\n");
      
      if (tmkEvD.bc.wResult & S_IB_MASK)      
        printf("The established bits in received RW are found out\n");                
    }       
  }
                        
  printf("\n");

/* start the message from the base 1, wait for interrupt, process results */
/*    1 ,      */
  bcstart(1, CTRL_C_A);
  events = tmkwaitevents(1<<hTmk, -1);
  tmkgetevd(&tmkEvD);

  if (events<0)
    printf("Error occured during interrupt waiting!\n");

  if (events==(1<<hTmk)) 
  {
    if (tmkEvD.nInt==1)
      printf ("The command of control mode 'Synchronization' is executed successfully\n");
   
    if (tmkEvD.nInt==2)
    {
      printf("At performance of a command of control mode 'Synchronization':\n");
        
      if (tmkEvD.bc.wResult & S_ERAO_MASK)
        printf("The error in a field of the address received RW is found out\n");
                                
      if (tmkEvD.bc.wResult & S_MEO_MASK)
        printf("The error of a code 'Manchester - 2' is found out at answer RT\n");
                                
      if (tmkEvD.bc.wResult & S_EBC_MASK)                
        printf("The error of the echo - control over transfer BC is found out\n");
                                        
      if (tmkEvD.bc.wResult & S_TO_MASK)                
        printf("It is not received the answer from RT\n");
                                
      if (tmkEvD.bc.wResult & S_IB_MASK)                
        printf("The established bits in received RW are found out\n");                        
    }
  }

  stop:     
  tmkdone(hTmk);
  TmkClose();
  return 0;
}
