#include <ncurses.h>
#include "ltmk.c"
#define RT_ADDR 10 /*   */

TTmkEventData tmkEvD;
TTmkEventData tmkEvD1;
int bc=0;
int rt=1;
int events;
char c;

int main()

{
  initscr();
  noecho();
  timeout(-1);
  keypad(stdscr,TRUE);
  bool flag=TRUE;

  if (TmkOpen())
  {
    printw("TmkOpen() failed!\n");goto stop;
    goto stop;    
  }
  printw("TmkOpen() successfull!\n");

  mvprintw(2,2,"Number BC? (UP-DOWN-Q)\n");
  mvprintw(3,2,"0\n");
  while (flag)
  {
    c=getch();
    switch(c)
    {
      case KEY_UP:
        if (bc<8) {bc++;}
      break;
      case KEY_DOWN:
        if (bc>0) {bc--;}
      break;
      case 'q':
        flag=false;
      break;
      case 'Q':
        flag=false;
      break;
    }
  mvprintw (3,2,"%d\n",bc);
  }

  flag=TRUE;
  mvprintw(4,2,"Number RT? (UP-DOWN-Q)\n");
  mvprintw(5,2,"1\n");

  while (flag)
  {
    c=getch();
    switch(c)
    { 
      case KEY_UP:
        if (rt<8) {rt++;}
      break;
      case KEY_DOWN:
        if (rt>0) {rt--;}
      break;
      case 'q':
        flag=false;
      break;
      case 'Q':
        flag=false;
      break;
    }
  mvprintw (5,2,"%d\n",rt);
  }


  if (tmkconfig(bc) != 0)
  {
    printw("tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",bc);
    goto stop;
  }


  if (tmkconfig(rt) != 0)
  {
    printw("tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",rt);
    goto stop;
   
  }

  tmkselect(rt);
  tmkgetevd(&tmkEvD1);

//          
  rtreset();
  rtdefaddress(RT_ADDR);


  tmkselect(bc);
  tmkgetevd(&tmkEvD);  

//      
  bcreset();

//   0    1   16   
  bcdefbase(0);
  bcputw(0, CW(RT_ADDR, RT_RECEIVE, 16, 1));
  bcputw(1, 0x1774);

//   1      '' 
  bcdefbase(1);
  bcputw(0, CWM(RT_ADDR, CMD_SYNCHRONIZE));

  printw(" \n");
  printw("BC\n"); 
  printw(" \n");

  bcstart(0, DATA_BC_RT);

  events = tmkwaitevents(1<<bc, -1);
  tmkgetevd(&tmkEvD);
  if(events==(1<<bc))
  {
    printw("Int: %d\n", tmkEvD.nInt);
    printw("wResult: %x\n", tmkEvD.bc.wResult);
    printw("wAW1: %x\n", tmkEvD.bc.wAW1);
    printw("wAW2: %x\n", tmkEvD.bc.wAW1);

    if (tmkEvD.nInt==1)
      printw("The command of transfer of data BC-RT is executed sucessfully\n");

    if (tmkEvD.nInt==2)	
    {    
      printw("At performance of transfer of the data BC-RT:\n");	

      if (tmkEvD.bc.wResult & S_ERAO_MASK)		
        printw("The error in a field of the address received RW is found out\n");
				
      if (tmkEvD.bc.wResult & S_MEO_MASK)		
        printw("The error of a code 'Manchester - 2' is found out at answer RT\n");
				
      if (tmkEvD.bc.wResult & S_EBC_MASK)		
        printw("The error of the echo - control over transfer BC is found out\n");			
		
      if (tmkEvD.bc.wResult & S_TO_MASK)		
        printw("It is not received the answer from RT\n");		
		
      if (tmkEvD.bc.wResult & S_IB_MASK)		
        printw("The established bits in received RW are found out\n");	    	
			
      goto stop;
    }
  }

  bcstart(1, CTRL_C_A);
  events = tmkwaitevents(1<<bc, -1);
  tmkgetevd(&tmkEvD);
  if(events==(1<<bc))
  {
    printw("Int: %d\n", tmkEvD.nInt);
    printw("wResult: %x\n", tmkEvD.bc.wResult);
    printw("wAW1: %x\n", tmkEvD.bc.wAW1);
    printw("wAW2: %x\n", tmkEvD.bc.wAW1);

    if (tmkEvD.nInt==1)	
      printw ("The command of control mode 'Synchronization' is executed successfully\n");
	
    if (tmkEvD.nInt==2)
    {
      printw("At performance of a command{team} of control mode 'Synchronization':\n");
	
      if (tmkEvD.bc.wResult & S_ERAO_MASK)
        printw("The error in a field of the address received RW is found out\n");
				
      if (tmkEvD.bc.wResult & S_MEO_MASK)		
        printw("The error of a code 'Manchester - 2' is found out at answer RT\n");
				
      if (tmkEvD.bc.wResult & S_EBC_MASK)		
        printw("The error of the echo - control over transfer BC is found out\n");
					
      if (tmkEvD.bc.wResult & S_TO_MASK)		
        printw("It is not received the answer from RT\n");
				
      if (tmkEvD.bc.wResult & S_IB_MASK)		
        printw("The established bits in received RW are found out\n");
			
      goto stop;
    }
  }


  printw(" \n");
  printw("RT\n");	
  printw(" \n");

  tmkselect(rt);
  tmkgetevd(&tmkEvD1);
  printw("Int: %d\n", tmkEvD1.nInt);
  printw("wStatus: %x\n", tmkEvD1.rt.wStatus);
  printw("wCmd: %x\n", tmkEvD1.rt.wCmd);
	
  if (tmkEvD1.nInt==0)	
    printw("Interruption from payment RT is not received\n");
	
  if (tmkEvD1.nInt==1)
  {	
    if (tmkEvD1.rt.wCmd == CMD_SYNCHRONIZE)
    {
      printw("The command of control mode ' Synchronization is received\n");
      rtdefsubaddr(RT_RECEIVE, 16);
      printw("Zero word 16 address: %04X\n",rtgetw(0));
    }
    else
    {
      printw("The command of control mode is received: %04X\n");	
    }
	
  }

  if (tmkEvD1.nInt==2)
  {
    printw("RT has found out a error in the command addressed to it\n");
    printw("Word of a condition RT: %04X\n");
  }

  stop:
  tmkdone(ALL_TMKS);
  endwin();
  TmkClose();
  getch();
  return 0;

}


