#include <stdio.h>
#include "ltmk.c"
#define RT_ADDR 10 /*   */

int events;
TTmkConfigData tmkCfg;
TTmkEventData tmkEvD;
int hTmk;
unsigned short int i;
unsigned short int awBuf[64];

int main(int argc, char *argv[])
{
  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;
	
  if (TmkOpen())
  {
    printf("TmkOpen() failed!\n");    
    goto stop;
  }

  printf("TmkOpen() successfull!\n");

  if (tmkconfig(hTmk) != 0)
  {
    printf("tmkconfig() failed!\n");
    printf("Somebody works with the card %d or this card doesn't exist in Registry\n",hTmk);
    goto stop;
  }

  tmkselect(hTmk);
  tmkgetevd(&tmkEvD);

/*      */
  bcreset();

/*   0    32   16   */
  bcdefbase(0);
  awBuf[0] = CW(RT_ADDR, RT_RECEIVE, 16, 32);
  for (i = 1; i <= 32; ++i)
    awBuf[i] = i;
  bcputblk(0, awBuf, 64);

/*   1    10   17   */
  bcdefbase(1);
  bcputw(0, CW(RT_ADDR, RT_TRANSMIT, 17, 10));

  bcstart(0, DATA_BC_RT);
  events=tmkwaitevents(1<<hTmk, -1);
  tmkgetevd(&tmkEvD);

  if (events==(1<<hTmk))
  {
    if (tmkEvD.nInt==1)    
      printf ("The command of transfer of data BC-RT is executed sucessfully\n");
	
    if (tmkEvD.nInt==2)
    {
      printf("At performance of transfer of the data BC-RT:\n");	

      if (tmkEvD.bc.wResult & S_ERAO_MASK)		
        printf("The error in a field of the address received RW is found out\n");		
		
      if (tmkEvD.bc.wResult & S_MEO_MASK)		
        printf("The error of a code 'Manchester - 2' is found out at answer RT\n");		
		
      if (tmkEvD.bc.wResult & S_EBC_MASK)		
        printf("The error of the echo - control over transfer BC is found out\n");
					
      if (tmkEvD.bc.wResult & S_TO_MASK)		
        printf("It is not received the answer from RT\n");		
		
      if (tmkEvD.bc.wResult & S_IB_MASK)		
        printf("The established bits in received RW are found out\n");
	    			
    }	 
  }

  
/*    1    ,    */
/*   */
  bcdefbus(BUS_A);
  bcstart(1, DATA_RT_BC);
  events=tmkwaitevents(1<<hTmk, -1);
  tmkgetevd(&tmkEvD);
  if (events==(1<<hTmk))
  {
    if (tmkEvD.nInt==1)
    {
      printf ("The command of transfer of data RT-BC is executed sucessfully\n");
      bcgetblk(2, awBuf, 10);
      printf("The data are received:");
      for (i = 0; i < 10; ++i)
      { 
        if ((i & 3) == 0)
          printf("\n");
	printf(" %04X", awBuf[i]);
      }	
    }

    if (tmkEvD.nInt==2)
    {
      printf("At performance of transfer of the data RT-BC:\n");
	
      if (tmkEvD.bc.wResult & S_ERAO_MASK)		
        printf("The error in a field of the address received RW is found out\n");		
		
      if (tmkEvD.bc.wResult & S_MEO_MASK)		
        printf("The error of a code 'Manchester - 2' is found out at answer RT\n");
				
      if (tmkEvD.bc.wResult & S_EBC_MASK)		
        printf("The error of the echo - control over transfer BC is found out\n");
					
      if (tmkEvD.bc.wResult & S_TO_MASK)		
        printf("It is not received the answer from RT\n");

      if (tmkEvD.bc.wResult & S_IB_MASK)		
        printf("The established bits in received RW are found out\n");
	    				
    }	
  } 

/*     */
  stop:
  tmkdone(hTmk);
  TmkClose();
  return 0;

}
