#include "ltmk.c"
#include <ncurses.h>
#define RT_ADDR 10 /*   */

TTmkConfigData tmkCfg;
int hTmk;
unsigned short int  awBuf[32];
unsigned short int i;
int kb=ERR;

int main(int argc, char *argv[])
{
  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;
	
  initscr();
  timeout(0);
	
  if (TmkOpen())
  {
    printw("TmkOpen() failed!\n");
    goto stop;    
  }
  printw("TmkOpen() successfull!\n");

  if (tmkconfig(hTmk) != 0)
  {
    printw("tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",hTmk);
    goto stop;   
  }

  tmkselect(hTmk);

/*          */ 
  rtreset();
  rtdefaddress(RT_ADDR); 
  for (i = 0; i < 10; ++i)
    awBuf[i] = ~i;

/*    17    */
/*    rtunlock()   rtdefsubaddr() */
  rtlock(RT_TRANSMIT, 17);
  while (rtbusy());
  rtputblk(0, awBuf, 10);

/*      16 */
  rtdefsubaddr(RT_RECEIVE, 16); 
  printw("For an exit from a cycle press any key\n"); 
  while (!rtbusy() && kb==ERR)
  {
    kb=getch();
  }
  if (kb!=ERR) {printw("No Data Receive\n");goto stop;}

/*      16 */
  while (rtbusy());

/*      17 */
		
  rtdefsubaddr(RT_TRANSMIT, 17);
  while (!rtbusy() && kb==ERR)
  {
    kb=getch();
  }
  if (kb!=ERR) {printw("No Data Transmit\n");goto stop;}

/*      17 */
  while (rtbusy());

/*     16     */
  rtdefsubaddr(RT_RECEIVE, 16);
  rtgetblk(0, awBuf, 32);
  printw("The data are received:");
 
  for (i = 0; i < 32; ++i)
  {
    if ((i & 3) == 0)
      printw("\n");
    printw(" %04X", awBuf[i]);
  }
  printw("\n");
  stop:
  timeout(-1);
  getch();

/*     */  
  endwin();
  tmkdone(hTmk);
  TmkClose();
  return 0;

}