#include <stdio.h>
#include "ltmk.c"
#define RT_ADDR 10 /*   */

TTmkConfigData tmkCfg;
TTmkEventData tmkEvD;
int hTmk;
int events;
unsigned short int i;
unsigned short int awBuf[64];

int main(int argc, char *argv[])
{
  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;
	
  if (TmkOpen())
  {
    printf("TmkOpen() failed!\n");    
    goto stop;
  }
  printf("TmkOpen() successfull!\n");

  if (tmkconfig(hTmk) != 0)
  {
    printf("tmkconfig() failed!\n");
    printf("Somebody works with the card %d or this card doesn't exist in Registry\n",hTmk);
    goto stop;   
  }

  tmkselect(hTmk);
  tmkgetevd(&tmkEvD);

/*      */
  bcreset();

/*   0    32   16   */
  bcdefbase(0);
  awBuf[0] = CW(RT_ADDR, RT_RECEIVE, 16, 32);
  for (i = 1; i <= 32; ++i)
    awBuf[i] = i;
  bcputblk(0, awBuf, 64);

/*   1    10   17   */
  bcdefbase(1);
  bcputw(0, CW(RT_ADDR, RT_TRANSMIT, 17, 10));

/*   2      '' */
  bcdefbase(2);
  bcputw(0, CWM(RT_ADDR, CMD_SYNCHRONIZE));

/*    */
  bcdefbase(0);
  bcdeflink(1, DATA_RT_BC|CX_CONT|CX_NOSIG|BUS_A);
  bcdefbase(1);
  bcdeflink(2, CTRL_C_A|CX_STOP|CX_NOSIG|BUS_A);
  
/*   ,   0 ,    */
/*   */
  
  bcstartx(0, DATA_BC_RT|CX_CONT|CX_NOSIG|BUS_A);
  events=tmkwaitevents(1<<hTmk, -1);
  tmkgetevd(&tmkEvD);
  if (events==(1<<hTmk))
  {
    if (tmkEvD.bcx.wResultX & SX_ERR_MASK)
    {
      printf("The chain of messages is interrupted in base %d\n",tmkEvD.bcx.wBase);	
      printf("At performance of a chain of messages:\n");
    }	
    switch (tmkEvD.bcx.wResultX & SX_ERR_MASK)
    {
      case SX_NOERR:
        printf("All chain of messages is executed successfully.\n");
        bcdefbase(1);
        bcgetblk(2, awBuf, 10);
        printf("The data are received:");

        for (i = 0; i < 10; ++i)
        {
          if ((i & 3) == 0)
            printf("\n");
        printf(" %04X", awBuf[i]);
        }
        printf("\n");
      break;
      
      case SX_ERAO:
        printf("The error in a field of the address received RW is found out\n");	
      break;
      case SX_MEO:
        printf("The error of a code 'Manchester - 2' is found out at answer RT'\n");	
      break;
      case SX_EBC:
        printf("The error of the echo - control over transfer BC is found out\n");	
      break;
      case SX_TOA:
        printf("It is not received the answer from RT\n");	
      break;
      case SX_TOD:
        printf("Number of the received words less set\n");
      break;
      case SX_ELN:
        printf("Number of the received words more set\n");
      break;
      case SX_ESYN:
        printf("The error such as sync signal is found out at answer \n");	
      break;
    }
  }

  stop:
  tmkdone(hTmk);
  TmkClose();
  return 0;
}

