#include <ncurses.h>
#include "ltmk.c"
#define RT_ADDR 10 /*   */

unsigned short int i;
TTmkEventData tmkEvD,tmkEvD1 ;
unsigned short int awRTBuf[32];
unsigned short int awBCBuf[64];
int kb=ERR;  
int bc=0;
int rt=1;
int events;
char c;
int dwInts3=0;

int main()
{
  initscr();
  noecho();
  timeout(0);
  keypad(stdscr,TRUE);
  bool flag=TRUE;

  if (TmkOpen())
  {
    printw("TmkOpen() failed!\n");
    goto stop;    
  }
  printw("TmkOpen() successfull!\n");

  mvprintw (2,2,"Number BC? (UP-DOWN-Q)\n");
  mvprintw(3,2,"0\n");
  while (flag)
  {
    c=getch();
    switch(c)
    {
      case KEY_UP:
        if (bc<8) {bc++;}
      break;
      case KEY_DOWN:
        if (bc>0) {bc--;}
      break;
      case 'q':
        flag=false;
      break;
      case 'Q':
        flag=false;
      break;
    }
  mvprintw (3,2,"%d\n",bc);
  }
 
  flag=TRUE;
  mvprintw (4,2,"Number RT? (UP-DOWN-Q)\n");
  mvprintw(5,2,"1\n");

  while (flag)
  {
    c=getch();
    switch(c)
    {
      case KEY_UP:
        if (rt<8) {rt++;}
      break;
      case KEY_DOWN:
       if (rt>0) {rt--;}
      break;
      case 'q':
       flag=false;
      break;
      case 'Q':
        flag=false;
      break;
    }
  mvprintw (5,2,"%d\n",rt);
  }

  if (tmkconfig(bc) != 0)
  {
    printw("tmkconfig() failed!\n") ;
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",bc);
    goto stop;
  }

  if (tmkconfig(rt) != 0)
  {
    printw( "tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",rt);
    goto stop;
  }


/*          */
  tmkselect(rt);
  rtreset();
  tmkgetevd(&tmkEvD1);  
  rtdefaddress(RT_ADDR);
  
/*    -  */
  rtdefirqmode(rtgetirqmode()&~RT_DATA_BL);

  for (i = 0; i < 10; ++i)
    awRTBuf[i] = ~i;

/*    17    */
/*    rtunlock()   rtdefsubaddr() */
  rtlock(RT_TRANSMIT, 17);
  while (rtbusy());
  rtputblk(0, awRTBuf, 10);

/*   */
  rtunlock();
 
/*      */
  tmkselect(bc);
  tmkgetevd(&tmkEvD);   
  bcreset();

/*   0    32   16   */
  bcdefbase(0);
  awBCBuf[0] = CW(RT_ADDR, RT_RECEIVE, 16, 32);
  for (i = 1; i <= 32; ++i)
    awBCBuf[i] = i;
  bcputblk(0, awBCBuf, 33);

/*   1    10   17   */
  bcdefbase(1);
  bcputw(0, CW(RT_ADDR, RT_TRANSMIT, 17, 10));

/*   2      '' */
  bcdefbase(2);
  bcputw(0, CWM(RT_ADDR, CMD_SYNCHRONIZE));

/*    */
  bcdefbase(0);
  bcdeflink(1, DATA_RT_BC|CX_CONT|CX_NOSIG|BUS_A);
  bcdefbase(1);
  bcdeflink(2, CTRL_C_A|CX_STOP|CX_NOSIG|BUS_A);

 
/*   ,   0 ,    */
/*   */
 
  bcstartx(0, DATA_BC_RT|CX_CONT|CX_NOSIG|BUS_A);
  tmkselect(rt);
  i=1;
  printw("For an exit from a cycle press any key\n");
  printw("RT\n");
  while (i && kb==ERR )
  {
    kb=getch();
    tmkgetevd(&tmkEvD1);
    if(tmkEvD1.nInt)
    {
      printw("Int: %d\n", tmkEvD1.nInt);
      if (tmkEvD1.nInt==1)
      {
        i=0;
        if (tmkEvD1.rt.wCmd == CMD_SYNCHRONIZE)
        {
          printw("The command of control mode ' Synchronization is received\n");	
        }
      else
        {
          printw("The command of control mode is received: %04X\n",tmkEvD.rt.wCmd);
        }
	
      }

      if (tmkEvD1.nInt==2)
      {
        printw("RT has found out a mistake in the command addressed to it.\n");	
        printw("Word of a condition RT: %04X\n",tmkEvD.rt.wStatus);
        printw("\n");
      }

      if (tmkEvD1.nInt==3)
        dwInts3++;
			
    }	
  }  

  printw("It is received %ld commands of 'receive - transmit' data\n",dwInts3);
  if (kb!=ERR) {printw("STOP\n"); goto stop;} 

//     16     
  if(dwInts3)
  {
    rtdefsubaddr(RT_RECEIVE, 16);
    rtgetblk(0, awRTBuf, 32);
    printw("The data are received:"); 
    for (i = 0; i < 32; ++i)
    {
      if ((i & 3) == 0)
        printw("\n");
      printw(" %04X", awRTBuf[i]);
    }
  }

  printw("\n");
  printw("BC\n");
  tmkselect(bc);
  events=tmkwaitevents(1<<bc, -1);
  tmkgetevd(&tmkEvD);
  if (events==(1<<bc))
  {
    if (tmkEvD.bcx.wResultX & SX_ERR_MASK)
    {
      printw("The chain of messages is interrupted in base %d\n",tmkEvD.bcx.wBase);	
      printw("At performance of a chain of messages:\n");
    }
    switch (tmkEvD.bcx.wResultX & SX_ERR_MASK)
    {
      case SX_NOERR:
        printw("All chain of messages is executed successfully.\n");
        bcdefbase(1);
        bcgetblk(2, awBCBuf, 10);
        printw("The data are received:");
        for (i = 0; i < 10; ++i)
        {
          if ((i & 3) == 0)
            printw("\n");
          printw(" %04X", awBCBuf[i]);
        }
        printw("\n");
      break;
      
      case SX_ERAO:
        printw("The error in a field of the address received RW is found out\n");	
      break;
      
      case SX_MEO:
        printw("The error of a code 'Manchester - 2' is found out at answer RT'\n");	
      break;
      
      case SX_EBC:
        printw("The error of the echo - control over transfer BC is found out\n");	
      break;
      
      case SX_TOA:
        printw("It is not received the answer from RT\n");	
      break;
      
      case SX_TOD:
        printw("Number of the received words less set\n");
      break;
      
      case SX_ELN:
        printw("Number of the received words more set\n");
      break;
      
      case SX_ESYN:
        printw("The error such as sync signal is found out at answer \n");	
      break;
    }		
  }
  

  stop:
  timeout(-1);
  getch();

/*     */
  endwin();
  tmkdone(ALL_TMKS);
  TmkClose();
  return 0;

}  



