#include "ltmk.c"
#include <ncurses.h>
#define RT_ADDR 10 /*   */

TTmkConfigData tmkCfg;
TTmkEventData tmkEvD;
int hTmk;
unsigned short int awBuf[32];
unsigned short int i;
unsigned short int dwInts3=0;
int kb=ERR;

int main(int argc, char *argv[])
{
  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;

  initscr();
  timeout(0);
		
  if (TmkOpen())
  {
    printw("TmkOpen() failed!\n");    
    goto stop;
  }
  printw("TmkOpen() successfull!\n");

  if (tmkconfig(hTmk) != 0)
  {
    printw("tmkconfig() failed!\n");
    printw("Somebody works with the card %d or this card doesn't exist in Registry\n",hTmk);
    goto stop;   
  }
  tmkselect(hTmk);

/*          */ 
  rtreset();
  rtdefaddress(RT_ADDR);
 
/*    -  */
  rtdefirqmode(rtgetirqmode()&~RT_DATA_BL);
  
  for (i = 0; i < 10; ++i)
    awBuf[i] = ~i;
/*    17    */
/*    rtunlock()   rtdefsubaddr() */
  rtlock(RT_TRANSMIT, 17);
  while (rtbusy());
  rtputblk(0, awBuf, 10);

/*   */
  rtunlock();
 
/*      */
  i=1;
  printw("For an exit from a cycle press any key\n");
  while (i && kb==ERR )
  {
    kb=getch();
    tmkgetevd(&tmkEvD);
    if(tmkEvD.nInt)
    {
      printw("Int: %d\n", tmkEvD.nInt);	
      if (tmkEvD.nInt==1)
      {
        i=0;
        if (tmkEvD.rt.wCmd == CMD_SYNCHRONIZE)
        {
          printw("The command of control mode ' Synchronization is received\n");	
        }
        else
        {
          printw("The command of control mode is received: %04X\n",tmkEvD.rt.wCmd);	
        }
        printw("\n");
      }

      if (tmkEvD.nInt==2)
      {
        printw("RT has found out a mistake in the command addressed to it.\n");	
	printw("Word of a condition RT: %04X\n",tmkEvD.rt.wStatus);
	printw("\n");
      }
	
      if (tmkEvD.nInt==3)
      {
      dwInts3++;
      }	

    }	
  }  

  printw("It is received %ld commands of 'receive - transmit' data\n",dwInts3);
  if (kb!=ERR) { goto stop;} 

//     16     
  if(dwInts3)
  {
    rtdefsubaddr(RT_RECEIVE, 16);
    rtgetblk(0, awBuf, 32);
    printw("The data are received:"); 
    for (i = 0; i < 32; ++i)
    {
      if ((i & 3) == 0)
        printw("\n");
      printw(" %04X", awBuf[i]);
    }
  }

stop:
timeout(-1);
getch();
endwin();
tmkdone(hTmk);
TmkClose();
return 0;
}
