/* v2.02 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#ifdef DOS
#include <conio.h>
#include <dos.h>
#include <alloc.h>
#endif
#if defined(WINDOWS) || defined(WINDOWSNT)
#include <conio.h>
#include <windows.h>
#endif
#ifdef QNX4
#include <conio.h>
#include <malloc.h>
#include <sys/console.h>
#include <fcntl.h>
#endif
#if defined(LINUX) || defined(QNX6)
#include <unistd.h>
#include <termios.h>
#endif

#ifdef DOS
/*#include "tmkll4.c"*/
#include "tmkinit.c"
#endif
#ifdef WINDOWS
#include "wdmtmkv2.cpp"
#endif
#ifdef WINDOWSNT
#include "ntmk.c"
#define WINDOWS
#endif
#ifdef LINUX
#include "ltmk.c"
#endif
#ifdef QNX4
#include "tmkll4.c"
#endif
#ifdef QNX6
#include "qnx6tmk.c"
#endif

#ifdef DOS
void wherexy(int *px, int *py)
{
 *px = wherex();
 *py = wherey();
}
#endif //DOS

#if defined(WINDOWS) || defined(LINUX) || defined(QNX6)
#define HUGE
#define disable()
#define enable()
#define farmalloc malloc
#define farfree free
#define far
#endif //WINDOWSLINUXQNX6

#if defined(LINUX) || defined(QNX6)
struct termios saved_attr, cur_attr;
int peek_character = -1;

void reset_input_mode()
{
  tcsetattr(STDIN_FILENO, TCSANOW, &saved_attr);
}

void set_input_mode()
{
  /* Make sure stdin is a terminal. */
  if (!isatty(STDIN_FILENO))
  {
    printf("Not a terminal.\n");
    exit(0);
  }

  tcgetattr(STDIN_FILENO, &saved_attr);
  atexit(reset_input_mode);

  cur_attr = saved_attr;
  cur_attr.c_lflag &= ~(ICANON|ECHO); /* Clear ICANON and ECHO. */
  cur_attr.c_cc[VMIN] = 1;
  cur_attr.c_cc[VTIME] = 0;
//  tcsetattr(STDIN_FILENO, TCSAFLUSH, &cur_attr);
  tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
}

int kbhit()
{
  unsigned char ch;
  int nread;

  if (peek_character != -1)
    return 1;
  cur_attr.c_cc[VMIN] = 0;
  tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
  nread = read(STDIN_FILENO, &ch, 1);
  cur_attr.c_cc[VMIN] = 1;
  tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
  if (nread == 1)
  {
    peek_character = ch;
    return 1;
  }
  return 0;
}

int getch()
{
  char ch;

  if (peek_character != -1)
  {
    ch = peek_character;
    peek_character = -1;
    return ch;
  }
  read(STDIN_FILENO, &ch, 1);
  return ch;
}

void gotoxy(int x, int y)
{
  printf("\x1B[%d;%dH", y, x);
}

int wherex()
{
 int x, y;
 printf("\x1B[6n");
 scanf("\x1B[%d;%dR", &y, &x);
 return x;
}

int wherey()
{
 int x, y;
 printf("\x1B[6n");
 scanf("\x1B[%d;%dR", &y, &x);
 return y;
}

void wherexy(int *px, int *py)
{
 printf("\x1B[6n");
 scanf("\x1B[%d;%dR", py, px);
}
#define cprintf printf
#endif //LINUXQNX6

#ifdef QNX4
#define HUGE
#define farmalloc malloc
#define farfree free
#define disable _disable
#define enable _enable

struct _console_ctrl *cc;

void gotoxy(int x, int y)
{
 printf("\x1B=%c%c", y+0x1F, x+0x1F);
}

int wherex()
{
 int x;
 console_read(cc, 0, 0, NULL, 0, NULL, &x, NULL);
 return x+1;
}

int wherey()
{
 int y;
 console_read(cc, 0, 0, NULL, 0, &y, NULL, NULL);
 return y+1;
}

void wherexy(int *px, int *py)
{
 console_read(cc, 0, 0, NULL, 0, py, px, NULL);
 ++(*px);
 ++(*py);
}
#endif //QNX4

#ifdef WINDOWS
HANDLE hIn, hOut;

void gotoxy(int x, int y)
{
 COORD xy;

 xy.X = x-1;
 xy.Y = y-1;
 SetConsoleCursorPosition(hOut, xy);
}

int wherex()
{
 CONSOLE_SCREEN_BUFFER_INFO csbi;

 GetConsoleScreenBufferInfo(hOut, &csbi);
 return csbi.dwCursorPosition.X+1;
}

int wherey()
{
 CONSOLE_SCREEN_BUFFER_INFO csbi;

 GetConsoleScreenBufferInfo(hOut, &csbi);
 return csbi.dwCursorPosition.Y+1;
}

void wherexy(int *px, int *py)
{
 CONSOLE_SCREEN_BUFFER_INFO csbi;

 GetConsoleScreenBufferInfo(hOut, &csbi);
 *px = csbi.dwCursorPosition.X+1;
 *py = csbi.dwCursorPosition.Y+1;
}
#endif //WINDOWS

#ifndef HUGE
#define HUGE huge
#endif

#ifdef DOS
#define LPT_INT_EXC
#define LPT_ERR

//#ifdef LPT_INT_EXC
//#define LPT
//#endif
#endif //DOS

#define WAITWITHKBHIT

//#define INTX

#define MAX_ERRLOG 10000L

#define RT_ADDR 10

#ifdef INTX
#define MY_BUS_A CX_BUS_A
#define MY_BUS_B CX_BUS_B
#define BUS_SHIFT 10
#else
#define MY_BUS_A BUS_A
#define MY_BUS_B BUS_B
#define BUS_SHIFT 15
#endif

#if defined(LINUX) || defined(QNX6)
int events, eventswait = 0;
TTmkEventData tmkEvD;
#endif //LINUXQNX6

#ifdef WINDOWS
HANDLE hEvent;
TTmkEventData tmkEvD;
#endif //WINDOWS

#ifdef QNX4
pid_t proxy, proxyMT;
TTmkProxyData TmkProxyData;
int msg[1];
#endif //QNX4

int fStop, fInt;

#ifdef LPT
unsigned lpt_data_port, lpt_status_port, lpt_ctrl_port;
int lpt_num = 1;
void init_lpt();
void set_lpt_data(unsigned char data);
#endif

#ifdef WAITWITHKBHIT
long dcWait;
#endif
volatile int nIntBC;
volatile int nIntRT[32];
volatile unsigned long dwIntRTs;
volatile int nIntMT;
volatile unsigned long cMtInts = 0L;
volatile unsigned long cRtInts = 0L;
volatile unsigned long cRTErrInts = 0L;
volatile unsigned long cInts = 0L;
volatile unsigned long cGoodInts = 0L;
volatile unsigned long cBadInts = 0L;
volatile unsigned wRes;
unsigned short wResP;
unsigned long dwWaitIntRTs, dwWaitIntRTsP, dwRTs;
unsigned long
  cDataBcRt = 0L, cDataBcRtBrcst = 0L,
  cDataRtBc = 0L,
  cDataRtRt = 0L,
  cDataRtRtBrcst = 0L,
  cCtrlCA = 0L, cCtrlCBrcst = 0L,
  cCtrlCDA = 0L, cCtrlCDBrcst = 0L,
  cCtrlCAD = 0L;
unsigned long cDataErrA = 0L;
unsigned long cDataErrB = 0L;

int fBus = 0, fBusP = 0, fBusPMT = 0;
int fBusA = 0;
int fBusB = 0;
int fBothBuses;
int fXBuses;
int fCmds;
int fBrcst;
int fInstr;
int fFlag;
unsigned short wFlagMask;
int fRtRt;
int fRtRtBrc;
int fArgErr;
int long nMsg, nMsgBeg, nMsgEnd;
unsigned short wSubAddr0, wSubAddrMask;
unsigned short wBcMaxBase, wMtMaxBase;
int fMtActive;

int nMaxErr;
int fTryMT;
int nbc, nrt[32], crt, irt, nmt, n, cn = 0;
#ifdef DOS
int n2i[NTMK+NRT];
#else
int n2i[MAX_TMK_NUMBER+1];
#endif
int nrt1, nrt1P, nrt2, nrt2P;
int irt1, irt1P, irt2, irt2P, irta, irtb;
int art[32], cart;
int res = -1;
char *psz;

int nStatusTimeOut;
int nBCTimeOut = 0;
int nRTTimeOut = 0;
int nMTTimeOut = 0;

int fTimer;
unsigned long dwTimerA, dwTimerR;
unsigned long cTimerErr = 0L;
unsigned long dwTimerBC, dwTimerRT[32], dwTimerMT, dwTimerDiff, dwTimerMax;
int fTimeMsg;
unsigned long dwTimeMsgA, dwTimeMsgR;
unsigned long cTimeMsgErr = 0L;
unsigned long dwTimeMsgBC, dwTimeMsgRT[32], dwTimeMsgMT, dwTimeMsgDiff, dwTimeMsgMax;
unsigned long dwTimeMsgBCP, dwTimeMsgRTP[32], dwTimeMsgMTP;
int fTimeMsgRT[32];

unsigned wTimerSubAddr;
int fTimerSyn;
unsigned long dwt;
unsigned long dwdrtt = 0L;
unsigned long dwdrtm = 0L;
unsigned long dwdrttd = 0L;
unsigned long dwdrtmd = 0L;
unsigned long dwtrtmsyng = 0L;

int fCmdSeparate;

int fMemTest;
unsigned long cMemErr = 0L;
unsigned short datat[64];
unsigned short wTestSA;

unsigned short wFlag;
unsigned short wBase, wBaseP, wCtrlCode, wCtrlCodeP, wSubAddr, wSubAddrP, wLen, wLenP;
unsigned short wMtBase, wMtBaseP, wResMT;
unsigned short buf[64], bufP[64], buf1[64];

int i, fError;
int nCheckDir;
unsigned short wCheckMode;
unsigned short wChecked;

FILE *fileOut = NULL;

#ifdef LPT
void init_lpt()
{
  lpt_data_port = peek(0x0040, 8 + (lpt_num - 1) * 2);
  lpt_status_port = lpt_data_port + 1;
  lpt_ctrl_port = lpt_data_port + 2;
}

void set_lpt_data(unsigned char data)
{
  outportb(lpt_data_port, data);
}
#endif

#ifdef INTX
void BCIntX(unsigned wBase, unsigned wResult)
#else
void BCInt(unsigned wResult, unsigned nothing1, unsigned nothing2)
#endif
{
  wRes = wResult;
  if (wRes == 0)
    ++cGoodInts;
  else
  {
    ++cBadInts;
#ifdef LPT_INT_EXC
    outportb(0x378, 0xff);
    outportb(0x378, 0);
//    set_lpt_data(0xff);
//    set_lpt_data(0);
#endif
  }
  ++cInts;
  nIntBC = 1;
#ifdef DOS
  bcrestore();
#endif //DOS
}

void MTIntSig(unsigned nothing)
{
  ++cMtInts;
  nIntMT = 1;
#ifdef DOS
  mtrestore();
#endif //DOS
}

void RTInt(unsigned nothing)
{
  int rti = n2i[tmkselected()];
  ++cRtInts;
  nIntRT[rti] = 1;
  dwIntRTs |= 1L << rti;
#ifdef DOS
  rtrestore();
#endif //DOS
}

void RTIntErr(unsigned nothing)
{
  int rti = n2i[tmkselected()];
  ++cRTErrInts;
  nIntRT[rti] = 1;
  dwIntRTs |= 1L << rti;
#ifdef DOS
  rtrestore();
#endif //DOS
}

void IncDataErrD(char *pszMsg, unsigned wData)
{
  fError = 1;
  if (fBusP == MY_BUS_A)
    ++cDataErrA;
  else
    ++cDataErrB;
  if ((cDataErrA + cDataErrB) > MAX_ERRLOG)
    return;
  fprintf(fileOut, "%ld: %04X:", cInts, wResP);
  switch (wCtrlCodeP)
  {
  case DATA_BC_RT:
    fprintf(fileOut, "BC->RT%d", art[irt1P]);
    break;
  case DATA_BC_RT_BRCST:
    fprintf(fileOut, "BC->allRT");
    break;
  case DATA_RT_BC:
    fprintf(fileOut, "RT%d->BC", art[irt1P]);
    break;
  case DATA_RT_RT:
    fprintf(fileOut, "RT%d->RT%d", art[irt1P], art[irt2P]);
    break;
  case DATA_RT_RT_BRCST:
    fprintf(fileOut, "RT%d->allRT", art[irt1P]);
    break;
  case CTRL_C_A:
    fprintf(fileOut, "C-A%d", art[irt1P]);
    break;
  case CTRL_C_BRCST:
    fprintf(fileOut, "C->AllRT");
    break;
  case CTRL_CD_A:
    fprintf(fileOut, "CD-A%d", art[irt1P]);
    break;
  case CTRL_CD_BRCST:
    fprintf(fileOut, "CD->AllRT");
    break;
  case CTRL_C_AD:
    fprintf(fileOut, "C-A%dD", art[irt1P]);
    break;
  default:
    break;
  }
  fprintf(fileOut, "(%d): %s: %04X\n", wLenP, pszMsg, wData);
}

void IncDataErr()
{
  int iP = i;

#ifdef LPT_ERR
  outportb(0x378, 0xff);
  outportb(0x378, 0);
#endif
  fError = 1;
  if (fBusP == MY_BUS_A)
    ++cDataErrA;
  else
    ++cDataErrB;
  if ((cDataErrA + cDataErrB) > MAX_ERRLOG)
    return;
  fprintf(fileOut, "%ld: %04X:", cInts, wResP);
  switch (wCheckMode)
  {
  case 0:
    fprintf(fileOut, "bc: ");
    break;
  case 1:
    if (crt == 1)
      fprintf(fileOut, "rt: ");
    else
      fprintf(fileOut, "%02d: ", art[irt]);
    break;
  case 2:
    fprintf(fileOut, "mt: ");
    break;
  default:
    fprintf(fileOut, "??: ");
    break;
  }
  switch (wCtrlCodeP)
  {
  case DATA_BC_RT:
    if (wCheckMode == 1)
      iP = i + 1; 
    fprintf(fileOut, "BC->RT%d(%d)", art[irt1P], wLenP);
    break;
  case DATA_BC_RT_BRCST:
    if (wCheckMode == 1)
      iP = i + 1;
    fprintf(fileOut, "BC->allRT(%d)", wLenP);
    break;
  case DATA_RT_BC:
    if (wCheckMode == 1)
      iP = i + 2;
    fprintf(fileOut, "RT%d->BC(%d)", art[irt1P], wLenP);
    break;
  case DATA_RT_RT:
    if (wCheckMode == 1)
      iP = i + 3;
    fprintf(fileOut, "RT%d->RT%d(%d)", art[irt1P], art[irt2P], wLenP);
    break;
  case DATA_RT_RT_BRCST:
    if (wCheckMode == 1)
      iP = i + 3;
    fprintf(fileOut, "RT%d->allRT(%d)", art[irt1P], wLenP);
    break;
  case CTRL_C_A:
    fprintf(fileOut, "C-A%d", art[irt1P]);
    break;
  case CTRL_C_BRCST:
    fprintf(fileOut, "C->AllRT");
    break;
  case CTRL_CD_A:
    if (wCheckMode == 1)
      iP = i + 1;
    fprintf(fileOut, "CD-A%d", art[irt1P]);
    break;
  case CTRL_CD_BRCST:
    if (wCheckMode == 1)
      iP = i + 1;
    fprintf(fileOut, "CD->AllRT");
    break;
  case CTRL_C_AD:
    fprintf(fileOut, "C-A%dD", art[irt1P]);
    break;
  default:
    fprintf(fileOut, "???");
    break;
  }
  fprintf(fileOut, ": %d: %04X %04X\n", i, bufP[iP], buf1[i]);
}

#define diff(a,b) (((a)==0L||(b)==0L)?0L:(((a)<(b))?(b-a):(a-b)))

void CheckTimer()
{
  int err = 0;
  disable();
  tmkselect(nbc);
  dwTimerBC = tmkgettimer();
  for (irt = 0; irt < crt; ++irt)
  {
    tmkselect(nrt[irt]);
    dwTimerRT[irt] = tmkgettimer() + dwdrtt;
  }
  if (fMtActive)
  {
    tmkselect(nmt);
    dwTimerMT = tmkgettimer();
  }
  enable();
  dwTimerMax = dwTimerBC;
  for (irt = 0; irt < crt; ++irt)
  {
    if (dwTimerMax < dwTimerRT[irt])
      dwTimerMax = dwTimerRT[irt];
  }
  if (fMtActive)
  {
    if (dwTimerMax < dwTimerMT)
      dwTimerMax = dwTimerMT;
  }
  dwTimerDiff = dwTimerA;
  if (dwTimerR != 0L) 
    dwTimerDiff += dwTimerMax/dwTimerR;
  if ((dwTimerMax - dwTimerBC) > dwTimerDiff)
  {
    fprintf(fileOut, "BC timer: %lu (%lu-%lu)\n", dwTimerBC, dwTimerMax-dwTimerDiff, dwTimerMax);
    err = 1;
  }
  for (irt = 0; irt < crt; ++irt)
  {
    if ((dwTimerMax - dwTimerRT[irt]) > dwTimerDiff)
    {
      fprintf(fileOut, "RT[%d] timer: %lu (%lu-%lu)\n", nrt[irt], dwTimerRT[irt], dwTimerMax-dwTimerDiff, dwTimerMax);
      err = 1;
    }
  }
  if (fMtActive)
  {
    if ((dwTimerMax - dwTimerMT) > dwTimerDiff)
    {
      fprintf(fileOut, "MT timer: %lu (%lu-%lu)\n", dwTimerMT, dwTimerMax-dwTimerDiff, dwTimerMax);
      err = 1;
    }
  }
  if (err)
  {
    ++cTimerErr;
    for (irt = 0; irt < crt; ++irt)
    {
      if (!fTimeMsgRT[irt])
        continue;
//      fprintf(fileOut, "bcp:%lu  rtp[%d]:%lu  mtp:%lu  dbrp:%lu dbmp:%lu dmrp:%lu\n", dwTimerBCP, nrt[irt], dwTimerRTP[irt], dwTimerMTP, diff(dwTimerBCP, dwTimerRTP[irt]), diff(dwTimerBCP, dwTimerMTP), diff(dwTimerMTP, dwTimerRTP[irt]));
      fprintf(fileOut, " bct:%lu   rtt[%d]:%lu   mtt:%lu   dbrt:%lu  dbmt:%lu  dmrt:%lu\n", dwTimerBC, nrt[irt], dwTimerRT[irt], dwTimerMT, diff(dwTimerBC, dwTimerRT[irt]), diff(dwTimerBC, dwTimerMT), diff(dwTimerMT, dwTimerRT[irt]));
//      fprintf(fileOut, "bcp:%lX  rtp[%d]:%lX  mtp:%lX  dbrp:%lX dbmp:%lX dmrp:%lX\n", dwTimerBCP, nrt[irt], dwTimerRTP[irt], dwTimerMTP, diff(dwTimerBCP, dwTimerRTP[irt]), diff(dwTimerBCP, dwTimerMTP), diff(dwTimerMTP, dwTimerRTP[irt]));
      fprintf(fileOut, " bct:%lX   rtt[%d]:%lX   mtt:%lX   dbrt:%lX  dbmt:%lX  dmrt:%lX\n", dwTimerBC, nrt[irt], dwTimerRT[irt], dwTimerMT, diff(dwTimerBC, dwTimerRT[irt]), diff(dwTimerBC, dwTimerMT), diff(dwTimerMT, dwTimerRT[irt]));
    }
    fprintf(fileOut, "ctrl:%X cmd:%04X bus:%c\n\n", wCtrlCodeP, bufP[0], (fBusP==MY_BUS_A)?'A':'B');
  }
}

void CheckTimeMsg()
{
  int err = 0;
  dwTimeMsgMax = dwTimeMsgBC;
  for (irt = 0; irt < crt; ++irt)
  {
    if (!fTimeMsgRT[irt])
      continue;
    if (dwTimeMsgMax < dwTimeMsgRT[irt])
      dwTimeMsgMax = dwTimeMsgRT[irt];
  }
  if (fMtActive)
  {
    if (dwTimeMsgMax < dwTimeMsgMT)
      dwTimeMsgMax = dwTimeMsgMT;
  }
  if (dwTimeMsgMax > dwtrtmsyng)
    return; //avoid undetermined result after SYN_G
  dwTimeMsgDiff = dwTimeMsgA;
  if (dwTimeMsgR != 0L) 
    dwTimeMsgDiff += dwTimeMsgMax/dwTimeMsgR;
  if ((dwTimeMsgMax - dwTimeMsgBC) > dwTimeMsgDiff)
  {
    fprintf(fileOut, "BC msg time: %lu (%lu-%lu)\n", dwTimeMsgBC, dwTimeMsgMax-dwTimeMsgDiff, dwTimeMsgMax);
    err = 1;
  }
  for (irt = 0; irt < crt; ++irt)
  {
    if (!fTimeMsgRT[irt])
      continue;
    if ((dwTimeMsgMax - dwTimeMsgRT[irt]) > (dwTimeMsgDiff + ((fTimeMsgRT[irt] == 2)?30:0))) // add gap+status=30us for transmitting RT
    {
      fprintf(fileOut, "RT[%d] msg time: %lu (%lu-%lu)\n", nrt[irt], dwTimeMsgRT[irt], dwTimeMsgMax-(dwTimeMsgDiff + ((fTimeMsgRT[irt] == 2)?30:0)), dwTimeMsgMax);
      err = 1;
    }
  }
  if (fMtActive)
  {
    if ((dwTimeMsgMax - dwTimeMsgMT) > dwTimeMsgDiff)
    {
      fprintf(fileOut, "MT msg time: %lu (%lu-%lu)\n", dwTimeMsgMT, dwTimeMsgMax-dwTimeMsgDiff, dwTimeMsgMax);
      err = 1;
    }
  }
  if (err)
  {
    ++cTimeMsgErr;
    for (irt = 0; irt < crt; ++irt)
    {
      if (!fTimeMsgRT[irt])
        continue;
      fprintf(fileOut, "bcp:%lu  rtp[%d]:%lu  mtp:%lu  dbrp:%lu dbmp:%lu dmrp:%lu\n", dwTimeMsgBCP, nrt[irt], dwTimeMsgRTP[irt], dwTimeMsgMTP, diff(dwTimeMsgBCP, dwTimeMsgRTP[irt]), diff(dwTimeMsgBCP, dwTimeMsgMTP), diff(dwTimeMsgMTP, dwTimeMsgRTP[irt]));
      fprintf(fileOut, " bc:%lu   rt[%d]:%lu   mt:%lu   dbr:%lu  dbm:%lu  dmr:%lu\n", dwTimeMsgBC, nrt[irt], dwTimeMsgRT[irt], dwTimeMsgMT, diff(dwTimeMsgBC, dwTimeMsgRT[irt]), diff(dwTimeMsgBC, dwTimeMsgMT), diff(dwTimeMsgMT, dwTimeMsgRT[irt]));
      fprintf(fileOut, "bcp:%lX  rtp[%d]:%lX  mtp:%lX  dbrp:%lX dbmp:%lX dmrp:%lX\n", dwTimeMsgBCP, nrt[irt], dwTimeMsgRTP[irt], dwTimeMsgMTP, diff(dwTimeMsgBCP, dwTimeMsgRTP[irt]), diff(dwTimeMsgBCP, dwTimeMsgMTP), diff(dwTimeMsgMTP, dwTimeMsgRTP[irt]));
      fprintf(fileOut, " bc:%lX   rt[%d]:%lX   mt:%lX   dbr:%lX  dbm:%lX  dmr:%lX\n", dwTimeMsgBC, nrt[irt], dwTimeMsgRT[irt], dwTimeMsgMT, diff(dwTimeMsgBC, dwTimeMsgRT[irt]), diff(dwTimeMsgBC, dwTimeMsgMT), diff(dwTimeMsgMT, dwTimeMsgRT[irt]));
    }
    fprintf(fileOut, "ctrl:%X cmd:%04X bus:%c\n\n", wCtrlCodeP, bufP[0], (fBusP==MY_BUS_A)?'A':'B');
  }
  dwTimeMsgBCP = dwTimeMsgBC;
  for (irt = 0; irt < crt; ++irt)
  {
    if (!fTimeMsgRT[irt])
      continue;
    dwTimeMsgRTP[irt] = dwTimeMsgRT[irt];
  }
  dwTimeMsgMTP = dwTimeMsgMT;
}

void testmembc(unsigned short len)
{
  int err;

  bcgetblk(len, buf1 + len, 58 - len);
  for (i = 0; i < 58; ++i)
    datat[i] = ~buf1[i];
  bcputblk(0, datat, 58);
  err = 0;
  bcgetblk(0, buf1, 58);
  for (i = 0; i < 58; ++i)
  {
    if (buf1[i] != datat[i])
    {
//      outportb(0x378,0xff);
//      outportb(0x378,0x00);
      printf("BC base %X memory%d test error1  r%04X %04X\n", bcgetbase(), i, buf1[i], datat[i]);
      ++cMemErr;
      err = 1;
      break;
    }
  }
  if (err)
  {
    bcgetblk(0, buf1, 58);
    for (i = 0; i < 58; ++i)
    {
      if (buf1[i] != datat[i])
      {
//        outportb(0x378,0xff);
//        outportb(0x378,0x00);
        printf("BC base %X memory%d test error1A r%04X %04X\n", bcgetbase(), i, buf1[i], datat[i]);
        ++cMemErr;
//        err = 1;
        break;
      }
    }
  }
}
  
void testmemmt(unsigned short len)
{
  int err;

  mtgetblk(len, buf1 + len, 58 - len);
  for (i = 0; i < 58; ++i)
    datat[i] = ~buf1[i];
  mtputblk(0, datat, 58);
  err = 0;
  mtgetblk(0, buf1, 58);
  for (i = 0; i < 58; ++i)
  {
    if (buf1[i] != datat[i])
    {
//      outportb(0x378,0xff);
//      outportb(0x378,0x00);
      printf("MT base %X memory%d test error1  r%04X %04X\n", mtgetbase(), i, buf1[i], datat[i]);
      ++cMemErr;
      err = 1;
      break;
    }
  }
  if (err)
  {
    mtgetblk(0, buf1, 58);
    for (i = 0; i < 58; ++i)
    {
      if (buf1[i] != datat[i])
      {
//        outportb(0x378,0xff);
//        outportb(0x378,0x00);
        printf("MT base %X memory%d test error1A r%04X %04X\n", mtgetbase(), i, buf1[i], datat[i]);
        ++cMemErr;
//        err = 1;
        break;
      }
    }
  }
}
  
void testmemrt(unsigned short len)
{
  int err;

  rtgetblk(len, buf1 + len, 32 - len);
  for (i = 0; i < 32; ++i)
    datat[i] = ~buf1[i];
  rtputblk(0, datat, 32);
  err = 0;
  rtgetblk(0, buf1, 32);
  for (i = 0; i < 32; ++i)
  {
    if (buf1[i] != datat[i])
    {
//      outportb(0x378,0xff);
//      outportb(0x378,0x00);
      printf("RT[%d] subaddr %X memory%d test error1  r%04X %04X\n", nrt[irt], rtgetsubaddr(), i, buf1[i], datat[i]);
      ++cMemErr;
      err = 1;
      break;
    }
  }
  if (err)
  {
    mtgetblk(0, buf1, 58);
    for (i = 0; i < 58; ++i)
    {
      if (buf1[i] != datat[i])
      {
//        outportb(0x378,0xff);
//        outportb(0x378,0x00);
        printf("RT[%d] subaddr %X memory%d test error1A r%04X %04X\n", nrt[irt], rtgetsubaddr(), i, buf1[i], datat[i]);
        ++cMemErr;
//        err = 1;
        break;
      }
    }
  }
}
  
int main(int argc, char *argv[])
{
#ifdef WINDOWS
  hIn = GetStdHandle(STD_INPUT_HANDLE);
  hOut = GetStdHandle(STD_OUTPUT_HANDLE);
#endif //WINDOWS
#if defined(LINUX) || defined(QNX6)
  set_input_mode();
#endif //LINUXQNX6
#ifdef QNX4
  if ((cc = console_open(fileno(stdout), O_RDWR)) == NULL)
  {
    printf("console_open error\n");
    exit(0);
  }
  strcpy(szDevName,"/dev/tmk");
#endif //QNX4
  if ((fileOut = fopen("errlog","wt")) == NULL)
  {
    printf("Can't open errlog\n");
    goto stop;
  }
  fCmds = 1;
  fBrcst = 1;
  fInstr = 1;
  fFlag = 1;
  wFlagMask = 0xFFFF;
  fRtRt = 1;
  fRtRtBrc = 1;
  fBothBuses = 1;
  fXBuses = 0;
  fArgErr = 0;
  fBusA = fBusB = 0;
  fMtActive = 0;
  nMsgBeg = 0L;
  nMsgEnd = -1L;
  nbc = 0;
  nrt[0] = 1;
  crt = 1;
  art[0] = RT_ADDR;
  cart = 1;
  nmt = 2;
  fTryMT = 0;
  nMaxErr = 0;
  nStatusTimeOut = 0;
  fTimer = 0;
  fTimeMsg = 0;
  fTimer = 0;
  wTimerSubAddr = 0;
  fCmdSeparate = 0;
  fMemTest = 1;
  for (i = 1; i < argc; ++i)
  {
    switch (argv[i][0])
    {
    case 'a':
    case 'A':
      fBothBuses = 0;
      fBusA = 1;
      break;
    case 'b':
    case 'B':
      fBothBuses = 0;
      fBusB = 1;
      break;
    case 'x':
    case 'X':
      switch (argv[i][1])
      {
      case '+':
        fXBuses = 1;
        break;
      case '-':
        fXBuses = 0;
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'c':
    case 'C':
      switch (argv[i][1])
      {
      case 's':
      case 'S':
        switch (argv[i][2])
        {
        case '+':
          fCmdSeparate = 1;
          break;
        case '-':
          fCmdSeparate = 0;
          break;
        default:
          fArgErr = 1;
          break;
        }
        break;
      case '+':
        fCmds = 1;
        break;
      case '-':
        fCmds = 0;
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'g':
    case 'G':
      switch (argv[i][1])
      {
      case '+':
        fBrcst = 1;
        break;
      case '-':
        fBrcst = 0;
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'i':
    case 'I':
      switch (argv[i][1])
      {
      case '+':
        fInstr = 1;
        break;
      case '-':
        fInstr = 0;
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'f':
    case 'F':
      switch (argv[i][1])
      {
      case '+':
        fFlag = 1;
        break;
      case '-':
        fFlag = 0;
        break;
      case 'm':
      case 'M':
        if (sscanf(&argv[i][2], "%x", &wFlagMask) != 1)
          fArgErr = 1;
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'r':
    case 'R':
      switch (argv[i][1])
      {
      case 'r':
      case 'R':
        switch (argv[i][2])
        {
        case '+':
          fRtRt = 1;
          break;
        case '-':
          fRtRt = 0;
          break;
        case 'g':
        case 'G':
          switch (argv[i][3])
          {
          case '+':
            fRtRtBrc = 1;
            break;
          case '-':
            fRtRtBrc = 0;
            break;
          default:
            fArgErr = 1;
            break;
          }
          break;
        default:
          fArgErr = 1;
          break;
        }
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'm':
    case 'M':
      if (sscanf(&argv[i][1], "%ld-%ld", &nMsgBeg, &nMsgEnd) != 2)
        fArgErr = 1;
      break;
    case 'e':
    case 'E':
      if (sscanf(&argv[i][1], "%d", &nMaxErr) != 1)
        fArgErr = 1;
      break;
    case 't':
    case 'T':
      switch (argv[i][1])
      {
      case 'r':
      case 'R':
        fTimerSyn = TIMER_SYN;
        break;
      case 'd':
      case 'D':
        if (sscanf(&argv[i][2], "%u", &wTimerSubAddr) != 1)
          fArgErr = 1;
        wTimerSubAddr &= 0x1F;
        break;
      case 't':
      case 'T':
        if (sscanf(&argv[i][2], "%lu/%lu", &dwTimerA, &dwTimerR) != 2)
          fArgErr = 1;
        else
          fTimer = 1;
        break;
      case 'm':
      case 'M':
        if (sscanf(&argv[i][2], "%lu/%lu", &dwTimeMsgA, &dwTimeMsgR) != 2)
          fArgErr = 1;
        else
          fTimeMsg = 1;
        break;
      default:
        if (sscanf(&argv[i][1], "%d", &nStatusTimeOut) != 1)
          fArgErr = 1;
        break;
      }
      break;
    case 'v':
    case 'V':
      switch (argv[i][1])
      {
      case 'm':
      case 'M':
        switch (argv[i][2])
        {
        case '+':
          fMemTest = 1;
          break;
        case '-':
          fMemTest = 0;
          break;
        default:
          fArgErr = 1;
          break;
        }
        break;
      default:
        fArgErr = 1;
        break;
      }
      break;
    case 'u':
    case 'U':
      psz = &argv[i][1];
      if (sscanf(psz, "%d", &n) != 0)
      {
        art[0] = n;
        cart = 1;
        while (*psz != '\0' && cart < 32 && fArgErr == 0)
        {
          while (isdigit(*++psz));
          if (*psz == ',')
          {
            ++psz;
            if (sscanf(psz, "%d", &n) != 0)
            {
              art[cart] = n;
              ++cart;
            }
            else
            {
              fArgErr = 1;
            }
          }
          else if (*psz == '-')
          {
            ++psz;
            if (sscanf(psz, "%d", &n) != 0)
            {
              while (art[cart-1] < n && cart < 32)
              {
                art[cart] = art[cart-1] + 1;
                ++cart;
              }
            }
            else
            {
              fArgErr = 1;
            }
          }
        }
        while (cart < crt)
        {
          art[cart] = art[cart-1] + 1;
          if (art[cart] > 30)
            art[cart] = 0;
          ++cart;
        }
      }
      else
        fArgErr = 1;
      break;
    default:
      if (sscanf(argv[i], "%d", &n) != 0)
      {
        switch (cn)
        {
        case 0:
          nbc = n;
          ++cn;
          fTryMT = 0;
          break;
        case 1:
          nrt[0] = n;
          psz = argv[i];
          crt = 1;
          cart = 1;
          while (*psz != '\0' && crt < 32 && fArgErr == 0)
          {
            while (isdigit(*++psz));
            if (*psz == ',')
            {
              ++psz;
              if (sscanf(psz, "%d", &n) != 0)
              {
                nrt[crt] = n;
                art[cart] = art[cart-1] + 1;
                if (art[cart] > 30)
                  art[cart] = 0;
                ++crt;
                ++cart;
              }
              else
              {
                fArgErr = 1;
              }
            }
            else if (*psz == '-')
            {
              ++psz;
              if (sscanf(psz, "%d", &n) != 0)
              {
                while (nrt[crt-1] < n && crt < 32)
                {
                  nrt[crt] = nrt[crt-1] + 1;
                  art[cart] = art[cart-1] + 1;
                  if (art[cart] > 30)
                    art[cart] = 0;
                  ++crt;
                  ++cart;
                }
              }
              else
              {
                fArgErr = 1;
              }
            }
          }
          ++cn;
          break;
        case 2:
          nmt = n;
          ++cn;
          fTryMT = 1;
          break;
        default:
          fArgErr = 1;
        }
      }
      else
        fArgErr = 1;
      break;
    }
  }
  if (fInstr)
  {
    wSubAddr0 = 0x10;
    wSubAddrMask = 0x0F;
  }
  else
  {
    wSubAddr0 = 0x00;
    wSubAddrMask = 0x1F;
  }
  if (fArgErr)
  {
    printf("Usage: randbcrt [D D[,-D] [D]] [a] [b] [uD[,-D]] [c+-] [g+-] [i+-] [f+-] [fmHHHH] [rr+-] [rrg+-] [eD] [tD] [mD-D] [ttD/D] [tmD/D] [tdD] [tr] [cs+-] [vm+-]\n"
           "Default: randbcrt 0 1 a b u10 c+ g+ i+ rr+ rrg+ vm+\n");
    goto stopn;
  }
  if (fBothBuses)
    fBusA = fBusB = 1;
#ifdef DOS 
  if (TmkInit("tmk.cfg"))
  {
    printf("TmkInit error\n");
    goto stop;
  }
#endif //DOS
#ifdef WINDOWS
  hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
  if (!hEvent)
  {
    printf("CreateEvent() failed!\n");
    goto stop;
  }
#endif //WINDOWS
#if defined(WINDOWS) || defined(LINUX) || defined(QNX6)
  if (TmkOpen())
  {
    printf("TmkOpen error\n");
    goto stop;
  }
  if (tmkconfig(nbc))
  {
    printf("tmkconfig(%d) error for BC\n", nbc);
    goto stop;
  }
  for (irt = 0; irt < crt; ++irt)
  {
    if (tmkconfig(nrt[irt]))
    {
      printf("tmkconfig(%d) error for RT\n", nrt[irt]);
      goto stop;
    }
  }
  if (fTryMT && tmkconfig(nmt))
  {
    printf("tmkconfig(%d) error for MT\n", nmt);
    goto stop;
  }
#endif //WINDOWSLINUXQNX6
#ifdef QNX4
  proxyMT = qnx_proxy_attach(0, 0, 0, -1);
  if (proxyMT == -1)
  {
    printf("qnx_proxy_attach error\n");
    goto stop;
  }
  if (TmkInit("tmk.cfg"))
  {
    printf("TmkInit error\n");
    goto stop;
  }
#endif //QNX4

  if (tmkselect(nbc))
  {
    printf("tmkselect(%d) error for BC\n", nbc);
    goto stop;
  }
#ifdef QNX4
  if (tmk_lock())
  {
   printf("tmk_lock error for BC\n");
   goto stop;
  }
  if (tmkdefmode(BC_MODE))
  {
   printf("tmkdefmode(BC_MODE) error\n");
   goto stop;
  }
#endif //QNX4
  if (bcreset())
  {
    printf("bcreset error\n");
    goto stop;
  }
  if (nStatusTimeOut != 0)
  {
    tmktimeout(nStatusTimeOut);
    nBCTimeOut = tmktimeout(GET_TIMEOUT);
  }

  for (irt = 0; irt < crt; ++irt)
  {
    if (tmkselect(nrt[irt]))
    {
      printf("tmkselect(%d) error for RT\n", nrt[irt]);
      goto stop;
    }
  #ifdef QNX4
    if (tmk_lock())
    {
     printf("tmk_lock error for RT\n");
     goto stop;
    }
    if (tmkdefmode(RT_MODE))
    {
     printf("tmkdefmode(RT_MODE) error\n");
     goto stop;
    }
  #endif //QNX4
    if (rtreset())
    {
      printf("rtreset error\n");
      goto stop;
    }
    if (nStatusTimeOut != 0)
    {
      tmktimeout(nStatusTimeOut);
      nRTTimeOut = tmktimeout(GET_TIMEOUT);
    }
  }

  if (fTryMT)
  {
    if (tmkselect(nmt))
    {
      printf("tmkselect(%d) error for MT\n", nmt);
      goto stop;
    }
#ifdef QNX4
    if (tmk_lock())
    {
     printf("tmk_lock error for MT\n");
     goto stop;
    }
    if (tmkdefmode(RT_MODE))
    {
     printf("tmkdefmode(MT_MODE) error\n");
     goto stop;
    }
#endif //QNX4
    if (mtreset())
    {
      printf("mtreset error\n");
      goto stop;
    }
    if (nStatusTimeOut != 0)
    {
      tmktimeout(nStatusTimeOut);
      nMTTimeOut = tmktimeout(GET_TIMEOUT);
    }
  }

  printf("randbcrt v2.02.");

  tmkselect(nbc);
#ifdef INTX
  printf("(bcstartx).\n");
#ifdef DOS
  bcdefintx(BCIntX);
#endif //DOS
#else
  printf("(bcstart).\n");
#ifdef DOS
  bcdefintnorm(BCInt);
  bcdefintexc(BCInt);
#endif //DOS
#endif
#ifdef WINDOWS
  tmkdefevent(hEvent, TRUE);
#endif //WINDOWS
#if defined(LINUX) || defined(QNX6)
  eventswait |= (1 << nbc);
#endif //LINUXQNX6 
#ifdef QNX4
  tmkdefproxy(proxyMT);
  tmkproxymode(TMK_PROXY_BUFFERED);
#endif //QNX4
  wBcMaxBase = bcgetmaxbase();
  printf("BC:%d", nbc);
  printf(" RT:%d", nrt[0]);
  for (irt = 1; irt < crt; ++irt)
    printf(",%d", nrt[irt]);
  printf("  Buses:");
  if (fBusA)
    printf("A");
  if (fBusB)
    printf("B");
  if (fXBuses)
    printf("X");
  printf("  BC bases:%d", wBcMaxBase + 1);
  if (nBCTimeOut != 0)
    printf("  BC TimeOut:%dus", nBCTimeOut);
  if (nRTTimeOut != 0)
    printf("  RT TimeOut:%dus", nRTTimeOut);
  printf("\n");
  printf("RT Addr:%d", art[0]);
  for (irt = 1; irt < crt; ++irt)
    printf(",%d", art[irt]);
  printf("\n");
  printf("RT busy flags: %c  Flag mask: %04X\n", (fFlag)?'+':'-', wFlagMask);
  printf("Mode commands: %c\n", (fCmds)?'+':'-');
  printf("Broadcast messages: %c\n", (fBrcst)?'+':'-');
  printf("RT-RT messages: %c\n", (fRtRt)?'+':'-');
  printf("RT-RT broadcast messages: %c\n", (fRtRtBrc)?'+':'-');
  printf("Instr. bit: %c\n", (fInstr)?'+':'-');
  printf("Max errors: %d\n", nMaxErr);
  if (fTimer)
  {
    printf("Timer diff: %lu us", dwTimerA);
    if (dwTimerR != 0L)
      printf(" + 1/%lu us\n", dwTimerR);
    else
      printf("\n");
  }
  if (fTimeMsg)
  {
    printf("TimeMsg diff: %lu us", dwTimeMsgA);
    if (dwTimeMsgR != 0L)
      printf(" + 1/%lu us\n", dwTimeMsgR);
    else
      printf("\n");
  }
  for (irt = 0; irt < crt; ++irt)
  {
    n2i[nrt[irt]] = irt;
    tmkselect(nrt[irt]);
#ifdef DOS
    rtdefintcmd(RTInt);
    rtdefintdata(RTInt);
    rtdefinterr(RTIntErr);
#endif
#ifdef WINDOWS
    tmkdefevent(hEvent, TRUE);
#endif //WINDOWS
#if defined(LINUX) || defined(QNX6)
    eventswait |= (1 << nrt[irt]);
#endif //LINUXQNX6
#ifdef QNX4
    tmkdefproxy(proxyMT);
    tmkproxymode(TMK_PROXY_BUFFERED);
#endif //QNX4
    rtdefaddress(art[irt]);
    rtdefirqmode(rtgetirqmode() & ~RT_DATA_BL);
    for (wSubAddr = 0x10; wSubAddr <= 0x1E; ++wSubAddr)
    {
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      rtclrflag();
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtclrflag();
    }
    if (fFlag)
      rtdefmode(rtgetmode() | RT_FLAG_MODE);
    else
      rtdefmode(rtgetmode() & ~RT_FLAG_MODE);
    if (fInstr)
      rtdefmode(rtgetmode() | RT_HBIT_MODE);
    else
      rtdefmode(rtgetmode() & ~RT_HBIT_MODE);
    rtputcmddata(CMD_TRANSMIT_VECTOR_WORD, 0xA05F);
  }
  if (fTryMT)
  {
    tmkselect(nmt);
    wMtMaxBase = mtgetmaxbase();
    for (wMtBase = 0; wMtBase < wMtMaxBase; ++wMtBase)
    {
      mtdefbase(wMtBase);
      mtdeflink((wMtBase + 1), CX_CONT | CX_NOINT | CX_SIG);
    }
    mtdefbase(wMtBase);
    mtdeflink(0, CX_CONT | CX_NOINT | CX_SIG);
#ifdef DOS
    mtdefintsig(MTIntSig);
#endif //DOS
#ifdef WINDOWS
    tmkdefevent(hEvent, TRUE);
#endif //WINDOWS
#if defined(LINUX) || defined(QNX6)
    eventswait |= (1 << nmt);
#endif //LINUXQNX6
#ifdef QNX4
    tmkdefproxy(proxyMT);
    tmkproxymode(TMK_PROXY_BUFFERED);
#endif //QNX4
//    if (fInstr)
//      mtdefmode(mtgetmode() | MT_HBIT_MODE);
//    else
//      mtdefmode(mtgetmode() & ~MT_HBIT_MODE);
    mtstartx(0, CX_CONT | CX_NOINT | CX_NOSIG);
    fMtActive = 1;
    printf("MT:%d  MT bases:%d", nmt, wMtMaxBase + 1);
    if (nMTTimeOut != 0)
      printf("  MT TimeOut:%dus", nMTTimeOut);
    printf("\n\n");
  }

  if (fTimer || fTimeMsg)
  {
    disable();
    tmkselect(nbc);
    tmktimer(TIMER_32BIT|TIMER_1US);
    for (irt = 0; irt < crt; ++irt)
    {
      tmkselect(nrt[irt]);
      tmktimer(TIMER_32BIT|TIMER_1US|fTimerSyn|wTimerSubAddr);
    }
    if (fMtActive)
    {
      tmkselect(nmt);
      tmktimer(TIMER_32BIT|TIMER_1US);
    }
    enable();
  }

  if (fTimer)
    CheckTimer();

  srand(1);
  nIntBC = 1;
  for (irt = 0; irt < crt; ++irt)
    nIntRT[irt] = 1;
  dwWaitIntRTsP = 0xFFFFFFFFL;
  dwIntRTs = 0xFFFFFFFFL;
  nIntMT = 1;
  wBase = 0;
  wMtBase = 0;
  wCtrlCodeP = 0xFFFF;
  nMsg = 0L;
  while (!kbhit())
  {
    if (crt > 1)
      irt1 = rand() % crt;
    else
      irt1 = 0;
    nrt1 = nrt[irt1];
    irt2 = irt1;
    dwWaitIntRTs = 0L;
    dwWaitIntRTs |= 1L << irt1; //n2i[nrt1];
    tmkselect(nbc);
    if (wBase > wBcMaxBase)
      wBase = 0;
    bcdefbase(wBase);
    wCtrlCode = rand() & 0xF;
    wLen = 0;
    switch (wCtrlCode)
    {
    case DATA_BC_RT:
      wSubAddr = (rand() & wSubAddrMask) + wSubAddr0;
      if (wSubAddr == 0x1F || wSubAddr == 0x00 || wSubAddr == wSubAddrP)
        continue;
      ++cDataBcRt;
      wLen = rand() & 0x1F;
      if (wLen == 0)
        wLen = 32;
      if (wTimerSubAddr == wSubAddr && wLen == 1)
        wLen = 2;
      buf[0] = CW(art[irt1], RT_RECEIVE, wSubAddr, wLen);
      for (i = 0; i < wLen + 2; ++i) // sw + extra word
        buf[i+1] = rand() + rand();
      bcputblk(0, buf, wLen + 3);
      buf[wLen+1] = CW(art[irt1], 0, 0, 0); // status
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(wLen+2, buf[wLen+2]);
      }
      break;
    case DATA_BC_RT_BRCST:
      if (!fBrcst)
        continue;
      nrt1 = -1;
      for (irt = 0; irt < crt; ++irt)
      {
        dwWaitIntRTs |= 1L << irt;
      }
      wSubAddr = (rand() & wSubAddrMask) + wSubAddr0;
      if (wSubAddr == 0x1F || wSubAddr == 0x00 || wSubAddr == wSubAddrP)
        continue;
      ++cDataBcRtBrcst;
      wLen = rand() & 0x1F;
      if (wLen == 0)
        wLen = 32;
      if (wTimerSubAddr == wSubAddr && wLen == 1)
        wLen = 2;
      buf[0] = CW(31, RT_RECEIVE, wSubAddr, wLen);
      for (i = 0; i < wLen + 2; ++i) // + 2 extra words
        buf[i+1] = rand() + rand();
      bcputblk(0, buf, wLen + 3);
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(wLen+1, buf[wLen+1]);
        mtputw(wLen+2, buf[wLen+2]);
      }
      break;
    case DATA_RT_BC:
      wSubAddr = (rand() & wSubAddrMask) + wSubAddr0;
      if (wSubAddr == 0x1F || wSubAddr == 0x00 || wSubAddr == wSubAddrP)
        continue;
      ++cDataRtBc;
      wLen = rand() & 0x1F;
      if (wLen == 0)
        wLen = 32;
      buf[0] = CW(art[irt1], RT_TRANSMIT, wSubAddr, wLen);
      bcputw(0, buf[0]);
      buf[1] = CW(art[irt1],  0, 0, 0);
      buf[wLen+2] = rand() + rand(); // + extra word
      bcputw(wLen+2, buf[wLen+2]);
      tmkselect(nrt1);
      for (i = 0; i < wLen; ++i)
        buf[i+2] = rand() + rand();
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtputblk(0, buf + 2, wLen);
      rtsetflag();
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(wLen+2, buf[wLen+2]);
      }
      break;
    case DATA_RT_RT:
      if (crt == 1)
        continue;
      if (!fRtRt)
        continue;
      do
        irt2 = rand() % crt;
      while (irt2 == irt1);
      nrt2 = nrt[irt2];
      dwWaitIntRTs |= 1L << irt2; //n2i[nrt2];
      wSubAddr = (rand() & wSubAddrMask) + wSubAddr0;
      if (wSubAddr == 0x1F || wSubAddr == 0x00 || wSubAddr == wSubAddrP)
        continue;
      ++cDataRtRt;
      wLen = rand() & 0x1F;
      if (wLen == 0)
        wLen = 32;
      if (wTimerSubAddr == wSubAddr && wLen == 1)
        wLen = 2;
      buf[0] = CW(art[irt2], RT_RECEIVE, wSubAddr, wLen);
      bcputw(0, buf[0]);
      buf[1] = CW(art[irt1], RT_TRANSMIT, wSubAddr, wLen);
      bcputw(1, buf[1]);
      buf[2] = CW(art[irt1], 0, 0, 0);
      buf[wLen+3] = CW(art[irt2], 0, 0, 0);
      bcputw(wLen+3, buf[wLen+3]);
      buf[wLen+4] = rand() + rand();  // + extra word
      bcputw(wLen+4, buf[wLen+4]);
      tmkselect(nrt1);
      for (i = 0; i < wLen; ++i)
        buf[i+3] = rand() + rand();
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtputblk(0, buf + 3, wLen);
      rtsetflag();
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(wLen+3, buf[wLen+3]);
        mtputw(wLen+4, buf[wLen+4]);
      }
      break;
    case DATA_RT_RT_BRCST:
      if (!fRtRtBrc)
        continue;
      nrt2 = -1;
      for (irt = 0; irt < crt; ++irt)
      {
        dwWaitIntRTs |= 1L << irt;
      }
      wSubAddr = (rand() & wSubAddrMask) + wSubAddr0;
      if (wSubAddr == 0x1F || wSubAddr == 0x00 || wSubAddr == wSubAddrP)
        continue;
      ++cDataRtRtBrcst;
      wLen = rand() & 0x1F;
      if (wLen == 0)
        wLen = 32;
      if (wTimerSubAddr == wSubAddr && wLen == 1)
        wLen = 2;
      buf[0] = CW(31, RT_RECEIVE, wSubAddr, wLen);
      bcputw(0, buf[0]);
      buf[1] = CW(art[irt1], RT_TRANSMIT, wSubAddr, wLen);
      bcputw(1, buf[1]);
      buf[2] = CW(art[irt1], 0, 0, 0);
      buf[wLen+3] = rand() + rand(); // + 2 extra words
      bcputw(wLen+3, buf[wLen+3]);
      buf[wLen+4] = rand() + rand(); 
      bcputw(wLen+4, buf[wLen+4]);
      tmkselect(nrt1);
      for (i = 0; i < wLen; ++i)
        buf[i+3] = rand() + rand();
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtputblk(0, buf + 3, wLen);
      rtsetflag();
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(wLen+3, buf[wLen+3]);
        mtputw(wLen+4, buf[wLen+4]);
      }
      break;
    case CTRL_C_A:
      if (!fCmds)
        continue;
      if (fCmdSeparate && (wCtrlCodeP == CTRL_C_A || wCtrlCodeP == CTRL_C_BRCST || wCtrlCodeP == CTRL_CD_A || wCtrlCodeP == CTRL_CD_BRCST))
        continue;
      ++cCtrlCA;
      buf[0] = CWM(art[irt1], CMD_SYNCHRONIZE);
      bcputw(0, buf[0]);
      buf[1] = rand() + rand(); // sw + extra word
      bcputw(1, buf[1]);
      buf[1] = CW(art[irt1], 0, 0, 0);
      buf[2] = rand() + rand();
      bcputw(2, buf[2]);
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(2, buf[2]);
      }
      break;
    case CTRL_C_BRCST:
      if (!fCmds)
        continue;
      if (!fBrcst)
        continue;
      if (fCmdSeparate && (wCtrlCodeP == CTRL_C_A || wCtrlCodeP == CTRL_C_BRCST || wCtrlCodeP == CTRL_CD_A || wCtrlCodeP == CTRL_CD_BRCST))
        continue;
      nrt1 = -1;
      for (irt = 0; irt < crt; ++irt)
      {
        dwWaitIntRTs |= 1L << irt;
      }
      ++cCtrlCBrcst;
      buf[0] = CWM(31, CMD_SYNCHRONIZE);
      bcputw(0, buf[0]);
      buf[1] = rand() + rand(); // + 2 extra words
      bcputw(1, buf[1]);
      buf[2] = rand() + rand();
      bcputw(2, buf[2]);
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(1, buf[1]);
        mtputw(2, buf[2]);
      }
      break;
    case CTRL_CD_A:
      if (!fCmds)
        continue;
      if (fCmdSeparate && (wCtrlCodeP == CTRL_C_A || wCtrlCodeP == CTRL_C_BRCST || wCtrlCodeP == CTRL_CD_A || wCtrlCodeP == CTRL_CD_BRCST))
        continue;
      if (wCtrlCodeP == CTRL_CD_A || wCtrlCodeP == CTRL_CD_BRCST)
        continue;
      ++cCtrlCDA;
      buf[0] = CWM(art[irt1], CMD_SYNCHRONIZE_WITH_DATA_WORD);
      bcputw(0, buf[0]);
      buf[1] = rand() + rand();
      bcputw(1, buf[1]);
      buf[2] = rand() + rand(); // sw + extra word
      bcputw(2, buf[2]);
      buf[2] = CW(art[irt1], 0, 0, 0);
      buf[3] = rand() + rand();
      bcputw(3, buf[3]);
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(3, buf[3]);
      }
      break;
    case CTRL_CD_BRCST:
      if (!fCmds)
        continue;
      if (!fBrcst)
        continue;
      if (fCmdSeparate && (wCtrlCodeP == CTRL_C_A || wCtrlCodeP == CTRL_C_BRCST || wCtrlCodeP == CTRL_CD_A || wCtrlCodeP == CTRL_CD_BRCST))
        continue;
      if (wCtrlCodeP == CTRL_CD_A || wCtrlCodeP == CTRL_CD_BRCST)
        continue;
      nrt1 = -1;
      for (irt = 0; irt < crt; ++irt)
      {
        dwWaitIntRTs |= 1L << irt;
      }
      ++cCtrlCDBrcst;
      buf[0] = CWM(31, CMD_SYNCHRONIZE_WITH_DATA_WORD);
      bcputw(0, buf[0]);
      buf[1] = rand() + rand();
      bcputw(1, buf[1]);
      buf[2] = rand() + rand(); // + 2 extra words
      bcputw(2, buf[2]);
      buf[3] = rand() + rand();
      bcputw(3, buf[3]);
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(2, buf[2]);
        mtputw(3, buf[3]);
      }
      break;
    case CTRL_C_AD:
      if (!fCmds)
        continue;
      if (wCtrlCodeP == CTRL_C_AD)
        continue;
      ++cCtrlCAD;
      buf[0] = CWM(art[irt1], CMD_TRANSMIT_VECTOR_WORD);
      bcputw(0, buf[0]);
      buf[1] = CW(art[irt1], 0, 0, 0);
      buf[2] = rand() + rand();
      buf[3] = rand() + rand(); // + extra word
      bcputw(3, buf[3]);
      tmkselect(nrt1);
      rtputcmddata(CMD_TRANSMIT_VECTOR_WORD, buf[2]);
      if (fMtActive)
      {
        tmkselect(nmt);
        mtdefbase(wMtBase);
        mtputw(3, buf[3]);
      }
      break;
    default:
      continue;
    }

    if (fTimer)
      CheckTimer();

    wChecked = 0;
    wCheckMode = rand() & 3;
    nCheckDir = rand() & 1;
    if (nCheckDir == 0)
      nCheckDir = -1;

    fStop = 0;
    fInt = 0;
//    tmkselect(nbc);
#ifdef DOS
#ifdef WAITWITHKBHIT
    dcWait = 0L;
#endif
    while (!nIntBC)
#ifdef WAITWITHKBHIT
    {
      if (dcWait == 100000L)
      {
        if (kbhit())
//         && getch() == 27)
          break;
        else
          dcWait = 0L;
      }
      else
        ++dcWait;
    }
#else
    ;
#endif
#endif //DOS
#if defined(WINDOWS) || defined(LINUX) || defined(QNX4) || defined(QNX6)
    while (nIntBC == 0 || dwIntRTs != dwWaitIntRTsP  || (fMtActive && nIntMT == 0))
    {
#ifdef WAITWITHKBHIT
      if (kbhit() && getch() == 27)
      {
        fStop = 1;
        break;
      }
#endif
      fInt = 0;
#ifdef QNX4
      proxy = Creceive(0, &msg, 0);
//      if (proxy != (pid_t)(-1))
      if (proxy == proxyMT)
        fInt = 1;
/*
      else
      {
        if (kbhit())
        {
          getch();
          fStop = 1;
        }
      }
*/
#endif //QNX4
#if defined(LINUX) || defined(QNX6)
      events = tmkwaitevents(eventswait, 1000);
      if (events == 0)
      {
        printf("\ninterrupt error! %d %08lX(of%08lX) %d\n", nIntBC, dwIntRTs, dwWaitIntRTsP, nIntMT);
        fStop = 1;
      }
      else if (events < 0)
      {
        printf("\ninterrupt cancel!\n");
        fStop = 1;
      }
      else
        fInt = 1;
#endif //LINUXQNX6
#ifdef WINDOWS
      switch (WaitForSingleObject(hEvent, 1000))
      {
      case WAIT_OBJECT_0:
        ResetEvent(hEvent);
        fInt = 1;
        break;
      case WAIT_TIMEOUT:
        printf("\ninterrupt error! %d %08X(of%08X) %d\n", nIntBC, dwIntRTs, dwWaitIntRTsP, nIntMT);
        fStop = 1;
        break;
      default:
        printf("\ninterrupt cancel!\n");
        fStop = 1;
        break;
      }
#endif //WINDOWS
      if (fStop)
        break;
      if (!fInt)
        continue;

      if (fMtActive && nIntMT == 0)
      {
        tmkselect(nmt);
//      do {
          tmkgetevd(&tmkEvD);
          switch (nIntMT = tmkEvD.nInt)
          {
          case 4:
            MTIntSig(0);
            break;
          }
//      } while (tmkEvD.nInt != 0);
      }

      if (dwIntRTs != dwWaitIntRTsP)
      {
        dwRTs = dwIntRTs ^ dwWaitIntRTsP;
        for (irt = 0; irt < crt; ++irt)
        {
          if (((1L << irt) & dwRTs) == 0L)
            continue;
          tmkselect(nrt[irt]);
  //      do {
            tmkgetevd(&tmkEvD);
            switch (nIntRT[irt] = tmkEvD.nInt)
            {
            case 1:
            case 3:
              RTInt(0);
              break;
            case 2:
              RTIntErr(0);
              break;
            }
  //      } while (tmkEvD.nInt != 0);
        }
      }

      if (nIntBC == 0)
      {
        tmkselect(nbc);
//      do {
          tmkgetevd(&tmkEvD);
          switch (nIntBC = tmkEvD.nInt)
          {
#ifdef INTX
          case 3:
            BCIntX(tmkEvD.bcx.wBase, tmkEvD.bcx.wResultX);
            break;
#else
          case 1:
          case 2:
            BCInt(tmkEvD.bc.wResult, 0, 0);
            break;
#endif
          }
//      } while (tmkEvD.nInt != 0);
      }
    }
#endif //WINDOWSLINUXQNX4QNX6
    if (fStop)
      break;

    if (dwdrttd != 0L)
    {
      dwdrtt = dwdrttd;
      dwdrttd = 0L;
    }
    if (dwdrtmd != 0L)
    {
      dwdrtm = dwdrtmd;
      dwdrtmd = 0L;
    }
    dwtrtmsyng = 0L;

    disable();

    if (fTimerSyn && ((buf[0] & 0x07FF) == (CWM(31, CMD_SYNCHRONIZE) & 0x07FF)))
    {
      tmkselect(nbc);
      dwt = tmkgettimer();
      if ((buf[0] & 0xF800) == 0xF800)
        dwtrtmsyng = dwt;
      tmktimer(TIMER_RESET);
      if (fMtActive)
      {
        tmkselect(nmt);
        tmktimer(TIMER_RESET);
      }
//      dwdrtm = 1L;
      dwdrtt = 29L;
      dwdrtmd = 36L;
    }
    if (wTimerSubAddr != 0 && (((buf[0] >> 5) & 0x3F) == wTimerSubAddr))
    {
      tmkselect(nbc);
      dwt = tmkgettimer();
      if (wCtrlCode == DATA_RT_RT || wCtrlCode == DATA_RT_RT_BRCST)
      {
        buf[3] = (unsigned short)dwt;
        buf[4] = (unsigned short)(dwt >> 16);
        tmkselect(nrt1);
        rtputblk(0, buf + 3, 2);
//        dwdrtm = 75L;
      }
      else
      {
        buf[1] = (unsigned short)dwt;
        buf[2] = (unsigned short)(dwt >> 16);
//        tmkselect(nbc);
        bcputblk(1, buf + 1, 2);
        dwdrtt = 51L;
        dwdrtmd = 58L;
      }
    }

    tmkselect(nbc);
    nIntBC = 0;
    for (irt = 0; irt < crt; ++irt)
      nIntRT[irt] = 0;
    dwIntRTs = 0L;
    dwWaitIntRTsP = dwWaitIntRTs;
    dwWaitIntRTs = 0L;
    nIntMT = 0;
    wResP = wRes;
    fBusP = fBus;
    if (fXBuses)
      fBusPMT = fBus ^ MY_BUS_B;
    else
      fBusPMT = fBus;
    fBus = rand() & MY_BUS_B;
    if (!fBusA)
      fBus = MY_BUS_B;
    if (!fBusB)
      fBus = MY_BUS_A;
    if (nMsg >= nMsgBeg && (nMsgEnd < 0 || nMsg <= nMsgEnd))
    {
#ifdef INTX
      bcstartx(wBase, wCtrlCode | fBus | CX_STOP | CX_NOSIG);
#else
      bcdefbus(fBus);
      bcstart(wBase, wCtrlCode);
#endif
      if (dwdrtm == 1L)
      {
        dwdrtm = tmkgettimer() + 25L;
        dwdrtt = dwdrtm;
      }
    }
    else
    {
      wCtrlCodeP = 0xFFFF;
      nIntBC = 1;
    }

    enable();

/*
    if (fTimerSyn && ((buf[0] & 0x07FF) == (CWM(31, CMD_SYNCHRONIZE) & 0x07FF)))
      fprintf(fileOut, "clrtimer %lu buf0=%04X cc=%X\n", dwt, buf[0], wCtrlCode);
    if (wTimerSubAddr != 0 && (((buf[0] >> 5) & 0x3F) == wTimerSubAddr))
      fprintf(fileOut, "updtimer %lu buf0=%04X cc=%X t=%04X wtsa=%04X\n", dwt, buf[0], wCtrlCode, ((buf[0] >> 5) & 0x3F), wTimerSubAddr);
*/

    if (fTimeMsg)
    {
      for (irt = 0; irt < crt; ++irt)
        fTimeMsgRT[irt] = 0;
    }
    switch (wCtrlCodeP)
    {
    case DATA_BC_RT:
    case DATA_BC_RT_BRCST:
      while (wChecked != 7)
      {
        fError = 0;
        switch (wCheckMode)
        {
        case 0:
          tmkselect(nbc);
          bcdefbase(wBaseP);
          bcgetblk(0, buf1, wLenP + 3);
          for (i = 0; i < wLenP + 3; ++i)
            if (bufP[i] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
            dwTimeMsgBC = bcgetmsgtime();
          if (fError)
          {
            bcgetblk(0, buf1, wLenP + 3);
            for (i = 0; i < wLenP + 3; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
            testmembc(wLenP + 3);
          wChecked |= 1;
          break;
        case 1:
          if (nrt1P == -1)
          {
            irta = 0;
            irtb = crt - 1;
          }
          else
          {
            irta = irt1P;
            irtb = irt1P;
          }
          for (irt = irta; irt <= irtb; ++irt)
          {
            tmkselect(nrt[irt]);
            rtdefsubaddr(RT_RECEIVE, wSubAddrP);
            rtgetblk(0, buf1, wLenP);
            if (fFlag)
            {
              wFlag = rtgetflag(RT_RECEIVE, wSubAddrP);
              if ((wFlag & wFlagMask) != (0x8000 | (wSubAddrP << 5) | (wLenP & 0x1F)))
              {
                fprintf(fileOut, "Error Flag(R,%d)=%04X; ", wSubAddrP, wFlag);
                i = 0;
                IncDataErr();
              }
            }
            rtclrflag();
            for (i = 0; i < wLenP; ++i)
              if (bufP[i+1] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
            {
              dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
              fTimeMsgRT[irt] = 1;
            }
            if (fError)
            {
              rtdefsubaddr(RT_RECEIVE, wSubAddrP);
              rtgetblk(0, buf1, wLenP);
              rtclrflag();
              for (i = 0; i < wLenP; ++i)
                if (bufP[i+1] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
            {
              rtdefsubaddr(RT_RECEIVE, wSubAddrP);
              testmemrt(wLenP);
            }
          }
          wChecked |= 2;
          break;
        case 2:
          if (fMtActive)
          {
            tmkselect(nmt);
            mtdefbase(wMtBaseP);
            wResMT = mtgetsw();
            mtgetblk(0, buf1, wLenP + 3);
            for (i = 0; i < wLenP + 3; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
              dwTimeMsgMT = mtgetmsgtime();
            if (fError)
            {
              mtgetblk(0, buf1, wLenP + 3);
              for (i = 0; i < wLenP + 3; ++i)
                if (bufP[i] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
              testmemmt(wLenP + 3);
          }
          wChecked |= 4;
          break;
        }
        wCheckMode = (wCheckMode + nCheckDir) & 3;
      }
      break;
    case DATA_RT_BC:
      while (wChecked != 7)
      {
        fError = 0;
        switch (wCheckMode)
        {
        case 0:
          tmkselect(nbc);
          bcdefbase(wBaseP);
          bcgetblk(0, buf1, wLenP + 3);
          for (i = 0; i < wLenP + 3; ++i)
            if (bufP[i] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
            dwTimeMsgBC = bcgetmsgtime();
          if (fError)
          {
            bcgetblk(0, buf1, wLenP + 3);
            for (i = 0; i < wLenP + 3; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
            testmembc(wLenP + 3);
          wChecked |= 1;
          break;
        case 1:
          irt = irt1P; //for IncDataErr
          tmkselect(nrt1P);
          rtdefsubaddr(RT_TRANSMIT, wSubAddrP);
          rtgetblk(0, buf1, wLenP);
          if (fFlag)
          {
            wFlag = rtgetflag(RT_TRANSMIT, wSubAddrP);
            if ((wFlag & wFlagMask) != (0x0000 | RT_TRANSMIT | (wSubAddrP << 5) | (wLenP & 0x1F)))
            {
              fprintf(fileOut, "Error Flag(T,%d)=%04X; ", wSubAddrP, wFlag);
              i = 0;
              IncDataErr();
            }
          }
//          rtclrflag();
          for (i = 0; i < wLenP; ++i)
            if (bufP[i+2] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
          {
            dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
            fTimeMsgRT[irt] = 1;
          }
          if (fError)
          {
            rtdefsubaddr(RT_TRANSMIT, wSubAddrP);
            rtgetblk(0, buf1, wLenP);
//            rtclrflag();
            for (i = 0; i < wLenP; ++i)
              if (bufP[i+2] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
          {
            rtdefsubaddr(RT_TRANSMIT, wSubAddrP);
            testmemrt(wLenP);
          }
          wChecked |= 2;
          break;
        case 2:
          if (fMtActive)
          {
            tmkselect(nmt);
            mtdefbase(wMtBaseP);
            wResMT = mtgetsw();
            mtgetblk(0, buf1, wLenP + 3);
            for (i = 0; i < wLenP + 3; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
              dwTimeMsgMT = mtgetmsgtime();
            if (fError)
            {
              mtgetblk(0, buf1, wLenP + 3);
              for (i = 0; i < wLenP + 3; ++i)
                if (bufP[i] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
              testmemmt(wLenP + 3);
          }
          wChecked |= 4;
          break;
        }
        wCheckMode = (wCheckMode + nCheckDir) & 3;
      }
      break;
    case DATA_RT_RT:
    case DATA_RT_RT_BRCST:
      while (wChecked != 7)
      {
        fError = 0;
        switch (wCheckMode)
        {
        case 0:
          tmkselect(nbc);
          bcdefbase(wBaseP);
          bcgetblk(0, buf1, wLenP + 5);
          for (i = 0; i < wLenP + 5; ++i)
            if (bufP[i] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
            dwTimeMsgBC = bcgetmsgtime();
          if (fError)
          {
            bcgetblk(0, buf1, wLenP + 5);
            for (i = 0; i < wLenP + 5; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
            testmembc(wLenP + 5);
          wChecked |= 1;
          break;
        case 1:
          irt = irt1P; //for IncDataErr
          tmkselect(nrt1P);
          rtdefsubaddr(RT_TRANSMIT, wSubAddrP);
          rtgetblk(0, buf1, wLenP);
          if (fFlag)
          {
            wFlag = rtgetflag(RT_TRANSMIT, wSubAddrP);
            if ((wFlag & wFlagMask) != (0x0000 | RT_TRANSMIT | (wSubAddrP << 5) | (wLenP & 0x1F)))
            {
              fprintf(fileOut, "Error Flag(T,%d)=%04X; ", wSubAddrP, wFlag);
              i = 0;
              IncDataErr();
            }
          }
//          rtclrflag();
          for (i = 0; i < wLenP; ++i)
            if (bufP[i+3] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
          {
            dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
            fTimeMsgRT[irt] = 2;
          }
          if (fError)
          {
            rtdefsubaddr(RT_TRANSMIT, wSubAddrP);
            rtgetblk(0, buf1, wLenP);
//            rtclrflag();
            for (i = 0; i < wLenP; ++i)
              if (bufP[i+3] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
          {
            rtdefsubaddr(RT_TRANSMIT, wSubAddrP);
            testmemrt(wLenP);
          }
          if (nrt2P == -1)
          {
            irta = 0;
            irtb = crt - 1;
          }
          else
          {
            irta = irt2P;
            irtb = irt2P;
          }
          for (irt = irta; irt <= irtb; ++irt)
          {
            if (nrt[irt] == nrt1P)
              continue;
            tmkselect(nrt[irt]);
            rtdefsubaddr(RT_RECEIVE, wSubAddrP);
            rtgetblk(0, buf1, wLenP);
            if (fFlag)
            {
              wFlag = rtgetflag(RT_RECEIVE, wSubAddrP);
              if ((wFlag & wFlagMask) != (0x8000 | (wSubAddrP << 5) | (wLenP & 0x1F)))
              {
                fprintf(fileOut, "Error Flag(R,%d)=%04X; ", wSubAddrP, wFlag);
                i = 0;
                IncDataErr();
              }
            }
            rtclrflag();
            for (i = 0; i < wLenP; ++i)
              if (bufP[i+3] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
            {
              dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
              fTimeMsgRT[irt] = 1;
            }
            if (fError)
            {
              rtdefsubaddr(RT_RECEIVE, wSubAddrP);
              rtgetblk(0, buf1, wLenP);
              rtclrflag();
              for (i = 0; i < wLenP; ++i)
                if (bufP[i+3] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
            {
              rtdefsubaddr(RT_RECEIVE, wSubAddrP);
              testmemrt(wLenP);
            }
          }
          wChecked |= 2;
          break;
        case 2:
          if (fMtActive)
          {
            tmkselect(nmt);
            mtdefbase(wMtBaseP);
            wResMT = mtgetsw();
            mtgetblk(0, buf1, wLenP + 5);
            for (i = 0; i < wLenP + 5; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
              dwTimeMsgMT = mtgetmsgtime();
            if (fError)
            {
              mtgetblk(0, buf1, wLenP + 5);
              for (i = 0; i < wLenP + 5; ++i)
                if (bufP[i] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
              testmemmt(wLenP + 5);
          }
          wChecked |= 4;
          break;
        }
        wCheckMode = (wCheckMode + nCheckDir) & 3;
      }
      break;
    case CTRL_C_A:
    case CTRL_C_BRCST:
      while (wChecked != 7)
      {
        fError = 0;
        switch (wCheckMode)
        {
        case 0:
          tmkselect(nbc);
          bcdefbase(wBaseP);
          bcgetblk(0, buf1, 3);
          for (i = 0; i < 3; ++i)
            if (bufP[i] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
            dwTimeMsgBC = bcgetmsgtime();
          if (fError)
          {
            bcgetblk(0, buf1, 3);
            for (i = 0; i < 3; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
            testmembc(3);
          wChecked |= 1;
          break;
        case 1:
//          irt = irt1P; //for IncDataErr
          if (nrt1P == -1)
          {
            irta = 0;
            irtb = crt - 1;
          }
          else
          {
            irta = irt1P;
            irtb = irt1P;
          }
          for (irt = irta; irt <= irtb; ++irt)
          {
            tmkselect(nrt[irt]);
            if (fTimeMsg)
            {
              rtdefsubaddr(RT_RECEIVE, 31);
              dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
              fTimeMsgRT[irt] = 1;
            }
            if (fMemTest)
            {
              wTestSA = 1;
              if (wTestSA == wSubAddr)
                ++wTestSA;
              rtdefsubaddr(RT_RECEIVE, wTestSA);
              testmemrt(0);
            }
          }
          wChecked |= 2;
          break;
        case 2:
          if (fMtActive)
          {
            tmkselect(nmt);
            mtdefbase(wMtBaseP);
            wResMT = mtgetsw();
            mtgetblk(0, buf1, 3);
            for (i = 0; i < 3; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
              dwTimeMsgMT = mtgetmsgtime();
            if (fError)
            {
              mtgetblk(0, buf1, 3);
              for (i = 0; i < 3; ++i)
                if (bufP[i] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
              testmemmt(3);
          }
          wChecked |= 4;
          break;
        }
        wCheckMode = (wCheckMode + nCheckDir) & 3;
      }
      break;
    case CTRL_CD_A:
    case CTRL_CD_BRCST:
      while (wChecked != 7)
      {
        fError = 0;
        switch (wCheckMode)
        {
        case 0:
          tmkselect(nbc);
          bcdefbase(wBaseP);
          bcgetblk(0, buf1, 4);
          for (i = 0; i < 4; ++i)
            if (bufP[i] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
            dwTimeMsgBC = bcgetmsgtime();
          if (fError)
          {
            bcgetblk(0, buf1, 4);
            for (i = 0; i < 4; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
            testmembc(4);
          wChecked |= 1;
          break;
        case 1:
          if (nrt1P == -1)
          {
            irta = 0;
            irtb = crt - 1;
          }
          else
          {
            irta = irt1P;
            irtb = irt1P;
          }
          for (irt = irta; irt <= irtb; ++irt)
          {
            tmkselect(nrt[irt]);
            buf1[0] = rtgetcmddata(CMD_SYNCHRONIZE_WITH_DATA_WORD);
            i = 0;
            if (bufP[1] != buf1[0])
              IncDataErr();
            if (fTimeMsg)
            {
              rtdefsubaddr(RT_RECEIVE, 31);
              dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
              fTimeMsgRT[irt] = 1;
            }
            if (fError)
            {
              buf1[0] = rtgetcmddata(CMD_SYNCHRONIZE_WITH_DATA_WORD);
              i = 0;
              if (bufP[1] != buf1[0])
                IncDataErr();
            }
            if (fMemTest)
            {
              wTestSA = 1;
              if (wTestSA == wSubAddr)
                ++wTestSA;
              rtdefsubaddr(RT_RECEIVE, wTestSA);
              testmemrt(0);
            }
          }
          wChecked |= 2;
          break;
        case 2:
          if (fMtActive)
          {
            tmkselect(nmt);
            mtdefbase(wMtBaseP);
            wResMT = mtgetsw();
            mtgetblk(0, buf1, 4);
            for (i = 0; i < 4; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
              dwTimeMsgMT = mtgetmsgtime();
            if (fError)
            {
              mtgetblk(0, buf1, 4);
              for (i = 0; i < 4; ++i)
                if (bufP[i] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
              testmemmt(4);
          }
          wChecked |= 4;
          break;
        }
        wCheckMode = (wCheckMode + nCheckDir) & 3;
      }
      break;
    case CTRL_C_AD:
      while (wChecked != 7)
      {
        fError = 0;
        switch (wCheckMode)
        {
        case 0:
          tmkselect(nbc);
          bcdefbase(wBaseP);
          bcgetblk(0, buf1, 4);
          for (i = 0; i < 4; ++i)
            if (bufP[i] != buf1[i])
              IncDataErr();
          if (fTimeMsg)
            dwTimeMsgBC = bcgetmsgtime();
          if (fError)
          {
            bcgetblk(0, buf1, 4);
            for (i = 0; i < 4; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
          }
          if (fMemTest)
            testmembc(4);
          wChecked |= 1;
          break;
        case 1:
//          irt = irt1P; //for IncDataErr
          irt = irt1P;
          tmkselect(nrt[irt]);
          if (fTimeMsg)
          {
            rtdefsubaddr(RT_TRANSMIT, 0);  //TVW
//            rtdefsubaddr(RT_TRANSMIT, 31); //TBITW
            dwTimeMsgRT[irt] = rtgetmsgtime() + dwdrtm;
            fTimeMsgRT[irt] = 1;
          }
          if (fMemTest)
          {
            wTestSA = 1;
            if (wTestSA == wSubAddr)
              ++wTestSA;
            rtdefsubaddr(RT_RECEIVE, wTestSA);
            testmemrt(0);
          }
          wChecked |= 2;
          break;
        case 2:
          if (fMtActive)
          {
            tmkselect(nmt);
            mtdefbase(wMtBaseP);
            wResMT = mtgetsw();
            mtgetblk(0, buf1, 4);
            for (i = 0; i < 4; ++i)
              if (bufP[i] != buf1[i])
                IncDataErr();
            if (fTimeMsg)
              dwTimeMsgMT = mtgetmsgtime();
            if (fError)
            {
              mtgetblk(0, buf1, 4);
              for (i = 0; i < 4; ++i)
                if (bufP[i] != buf1[i])
                  IncDataErr();
            }
            if (fMemTest)
              testmemmt(4);
          }
          wChecked |= 4;
          break;
        }
        wCheckMode = (wCheckMode + nCheckDir) & 3;
      }
      break;
    default:
      break;
    }

    if (fTimeMsg)
      CheckTimeMsg();

    if (fMtActive)
    {
      if (wCtrlCodeP != 0xFFFF)
      {
        if ((wResMT & 0xFC3F) != ((fBusPMT<<BUS_SHIFT) | (wCtrlCodeP<<10)))
        {
          fprintf(fileOut, "Error wResMT=%04X; %d; ", wResMT, wMtBaseP);
          wCheckMode = 2;
          i = 0;
          IncDataErr();
        }
      }
      wMtBaseP = wMtBase;
      ++wMtBase;
      if (wMtBase > wMtMaxBase)
        wMtBase = 0;
    }

    wCtrlCodeP = wCtrlCode;
    wBaseP = wBase;
    wSubAddrP = wSubAddr;
    wLenP = wLen;
    nrt1P = nrt1;
    nrt2P = nrt2;
    irt1P = irt1;
    irt2P = irt2;
    for (i = 0; i < 37; ++i)
      bufP[i] = buf[i];
    
    if (nMsgEnd >= 0L && nMsg > nMsgEnd)
      break;
    ++nMsg;
    ++wBase;

    if (cInts%1000 == 0)
    {
#ifdef QNX6
      printf("\x1B[1G");
#else
      gotoxy(1, wherey());
#endif
      if (fTimer)
        cprintf("Ints BC: %ld (-%ld), RT: %ld (-%ld). Errors: %ld, (%ld, %ld). T: %lu", cInts, cBadInts, cRtInts, cRTErrInts, cMemErr + cDataErrA + cDataErrB + cTimerErr + cTimeMsgErr, cDataErrA, cDataErrB, dwTimerMax);
      else
        cprintf("Ints BC: %ld (-%ld), RT: %ld (-%ld). Errors: %ld, (%ld, %ld)", cInts, cBadInts, cRtInts, cRTErrInts, cMemErr + cDataErrA + cDataErrB + cTimerErr + cTimeMsgErr, cDataErrA, cDataErrB);
      if (fMtActive)
      {
#ifdef QNX6
        printf("\x1B[1A");
        printf("\x1B[1G");
#else
        gotoxy(1, wherey()-1);
#endif  
        cprintf("Ints MT: %ld\n\r", cMtInts);
      }
#ifdef QNX6
      fflush(stdout);
#endif
    }
    if (nMaxErr && (int)(cMemErr+cDataErrA+cDataErrB+cBadInts+cRTErrInts) > nMaxErr)
      break;
  }
  while (kbhit())
    getch();
  if (fMtActive)
  {
    cprintf("\n\rInts MT: %ld", cMtInts);
  }
  if (fTimer)
    cprintf("\n\rInts BC: %ld (-%ld), RT: %ld (-%ld). Errors: %ld, (%ld, %ld). T: %lu\n", cInts, cBadInts, cRtInts, cRTErrInts, cMemErr + cDataErrA + cDataErrB + cTimerErr + cTimeMsgErr, cDataErrA, cDataErrB, dwTimerMax);
  else
    cprintf("\n\rInts BC: %ld (-%ld), RT: %ld (-%ld). Errors: %ld, (%ld, %ld)\n", cInts, cBadInts, cRtInts, cRTErrInts, cMemErr + cDataErrA + cDataErrB + cTimerErr + cTimeMsgErr, cDataErrA, cDataErrB);
  if (cBadInts == 0L && cMemErr == 0L && cDataErrA == 0L && cDataErrB == 0L && cRTErrInts == 0L)
    res = 0;
  stop:
  tmkselect(nbc);
  bcreset();
  for (irt = 0; irt < crt; ++irt)
  {
    tmkselect(nrt[irt]);
    bcreset();
  }
  if (fMtActive)
  {
    tmkselect(nmt);
    bcreset();
  }
  tmkdone(ALL_TMKS);
#if defined(WINDOWS) || defined(LINUX) || defined(QNX6)
  TmkClose();
#endif //WINDOWSLINUXQNX6
#ifdef WINDOWS
  if (hEvent)
    CloseHandle(hEvent);
#endif //WINDOWS
#ifdef QNX4
  if (proxyMT != (pid_t)(-1))
    qnx_proxy_detach(proxyMT);
  console_close(cc);
#endif //QNX4
  stopn:
  if (fileOut != NULL)
    fclose(fileOut);
  return res;
}
