/****************************************************************************/
/*      TMK.CPP. (c) ELCUS, 1994,2002.                                      */
/*      Uses TMKLL4 library.                                                */
/****************************************************************************/
//#define ELCUS

#ifdef ELCUS
//#define LPT_AT
#define LPT_SYN
#define LPT_INT_EXC
#endif //def ELCUS

#define TMK_CONFIGURATION_TABLE

#ifdef LPT_AT
#define LPT
#endif
#ifdef LPT_SYN
#define LPT
#endif
#ifdef LPT_INT_EXC
#define LPT
#endif

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <errno.h>
#include <process.h>
#include <stdlib.h>
#include <hw/inout.h>
#include <unistd.h>
#include <termios.h>
#include <sys/mman.h>

#include "tmkinit.c"
//#include "tmktest.c"

#define inportb(port)                        in8(port)
#define outportb(port, data)                 out8(port, data)
#define inport(port)                         in16(port)
#define outport(port, data)                  out16(port, data)

#define TMKCPP_MAX_BASE 1023
#define TMKCPP_MAX_NUM 3

#define CR 0x0D
#define LF 0x0A
#define CTRL_C 0x03
#define ESCAPE 0x1B
#define BACKSPACE 0x08
#define TAB 0x09

#define F01 0x3B
#define F02 0x3C
#define F03 0x3D
#define F04 0x3E
#define F05 0x3F
#define F06 0x40
#define F07 0x41
#define F08 0x42
#define F09 0x43
#define F10 0x44
#define PGUP 0x49
#define PGDN 0x51
#define HOME 0x47
#define END 0x4F
#define LEFT 0x4B
#define RIGHT 0x4D
#define UP 0x48
#define DOWN 0x50
#define GPLUSW 0x4E2B
#define GPLUS 0x4E


#define BC_BUF_SIZE 64                  /* BC buffer size */
#define BC_DUMP_SIZE 36
#define CC_SIZE 4
#define TIME_OUT 0x0300                 /* Interrupt wait timeout */

#define DUMP_WIDE 10

#define RT_BUF_SIZE 32                  /* RT buffer size */
#define RT_DUMP_SIZE 32
#define SW_SIZE 5
#define ZONE_MASK 0x0020
#define RT_MASK 0x0080

#define nMaxWin 1

#ifdef LPT
unsigned lpt_data_port, lpt_status_port, lpt_ctrl_port;
short lpt_num = 1;
void init_lpt();
void set_lpt_data(unsigned char data);
#endif

int nTest;
int TmkInit0();
void in_cmd(char *str);
unsigned short in_key();
void check_int();
void make_func(unsigned short key);
void make_ctrl(unsigned short key);
void make_cmd(char *str);
void make_quit(char *str);
void select_win(char *str);
void select_tmk(char *str);
void mode_bc(char *str);
void mode_rt(char *str);
//void mode_mt(char *str);
void comment(char *str);
void kbd_pause(char *str);
void fields_chg(char *str);
//void interrupt prtscr_brk(...);
void cmds_open(char *str);
void cmds_open2(char *str);
void exe_open(char *str);
void cmd_reset(char *str);
void buf_fill(char *str);
void buf_clear(char *str);
void buf_edit(char *str);
int mark_set(char *str, int *mark);
int end_ctrl(char *str);
void msg_out(char *msg);
void all_screen();
void out_func_str();
void out_mode();
void tmk_outpw(char *str);
#ifdef TMK_DAC
void tmk_outdac(char *str);
#endif
void set_io_delay(char *str);
inline void out_port(unsigned wPort);
inline void out_irq(unsigned wIrq);  
void out_type();                     
void out_fname();                    
void out_inn();                      
void out_buffer();                   
void bin_unpack(short x, short y, short adr, unsigned short data);
void out_dump(unsigned short *data);
void out_bin(unsigned short data, short num_digits);
void select_window(int nwin);
void set_max_err(char *str);
void set_stat_len(char *str);

/* BC functions */
void bc_fill_test();
void bc_help(char *str);                 
void bc_clear_ram();                     
int bc_ram_test(char *str);              
void bc_buf_rd(char *str);               
void bc_buf_wr(char *str);               
void sym(char *str);                     
void statistic_out(char *str);           
void statistic_err_out();                
void statistic_bad_out(char *str);       
void statistic_clear(char *str);         
int start_loop(char *str);               
int start_loop_file(char *str);          
int start_loop_n(unsigned long counter); 
int start_1(char *str);                  
int start();                             
void set_base(char *str);                
void set_count(char *str);               
void set_pause(char *str);               
void set_ctrl_code(char *str);           
void set_number(char *str);              
void out_maxerrs();
void out_number();                       
void out_base();                         
void out_count();                        
void out_glcount();                      
void out_pause();                        
void out_ctrl_code();                    
void bc_out_sw();                        
void bc_out_ram(int base);               
int correct_cc(unsigned short ctrl_code);           

/* RT functions */
void rt_fill_test();
void block_data_irq(char *str);          
void unblock_data_irq(char *str);        
void rt_clear_ram();                     
int rt_ram_test(char *str);              
void rt_help(char *str);                 
void rt_buf_rd(char *str);               
void rt_buf_wr(char *str);               
void set_flag(char *str);                
void rd_sw_loop(char *str);              
void wr_mr_loop(char *str);              
int set_subadr(char *str);               
void set_spage(char *str);               
void set_cpage(char *str);               
void set_page(char *str);                
void set_at(char *str);                  
int wr_at(unsigned short at);                       
void set_subadr_r(char *str);            
void set_subadr_t(char *str);            
void set_status_word(char *str);         
void set_sw_bits(char *str, unsigned short mask);   
void read_sw(char *str);                 
void read_sp(char *str);                 
void clear_sw_bits(char *str, unsigned short mask); 
void wr_status_word();                   
void out_rt_mode();
void out_page();                         
void out_subadr();                       
void out_at();                           
void out_status_word();                  
void rt_out_sw();                        
void rt_out_sp();                        
void rt_out_ram(int dir, int subadr);    

const BC_DUMP_STRINGS=BC_DUMP_SIZE/DUMP_WIDE+1;
const RT_DUMP_STRINGS=RT_DUMP_SIZE/DUMP_WIDE+1;
const BDUMP_X=10, BDUMP_Y=6;
int DUMP_STRINGS;
int DUMP_SIZE;

int fGoto = 0;
char szGoto[16];
char cmd_str[80];               
char old_cmd[80];               
char ex_fname[80];              
long cmd_count=1;               
long cur_count;                 
int str_ptr=0;                  
int fCmds_f = 0;

volatile unsigned short bc_sw=0xFFFF; 
volatile unsigned short bc_aw1=0xFFFF;
volatile unsigned short bc_aw2=0xFFFF;
unsigned short base;                       
int bus_num;                    
unsigned tmkMaxN = TMKCPP_MAX_NUM;
unsigned tmkMaxBase[TMKCPP_MAX_NUM+1]; 
unsigned char ctrl_code[TMKCPP_MAX_NUM+1][TMKCPP_MAX_BASE+1];

unsigned base_link[TMKCPP_MAX_NUM+1][TMKCPP_MAX_BASE+1];

unsigned long opause=0;
unsigned long pause1=0; 
                  

volatile int prtscr_flag=0;
volatile int int_num[4] = {0, 0, 0, 0};

#define BADLEN 100
#define ERRLEN 40
unsigned at_bad_mode[ERRLEN];
unsigned at_bad_base[ERRLEN];
unsigned at_bad_sa[ERRLEN];
unsigned at_bad_num[ERRLEN];
unsigned at_bad_good[ERRLEN];
unsigned at_bad_bad[ERRLEN];
volatile unsigned bad_sws[BADLEN];
volatile unsigned bad_aws[BADLEN];
volatile unsigned long bad_sts[BADLEN];
volatile unsigned long good_starts=0;
volatile unsigned long bad_starts=0; 
unsigned long to_errors=0;           
unsigned long data_err=0;
unsigned long channel_err=0;
unsigned long dwMaxErr=0;
int fStatErrStop=0;

unsigned short bcbuffer[2][64];
unsigned short rtbuffer[2][32];
unsigned short buffer[64]; 
unsigned short vbuffer[64];
int buf_adr=0;       
int buf_mark=0;      
int in_ed_word=3;    
int buf_size;        
int fields=1;        
                     
volatile unsigned rt_sp=0;                                  
volatile unsigned rt_sw=0xFFFF;
volatile unsigned rt_cmd=0;    
int fLock=0;
int dir;                       
int subadr;                    
int terminal_adr;              
int bram_page;                 
int cram_page;                 

int nwin;                      
int nmainwin = 0;              
int fInt = 0;
char chLU, chRU, chLD, chRD, chH , chV;

struct TW
{
 int nX;
 int nY;
 int nDX;
 int nDY;
 int nTMK;
 int nType;
 int nMode;
 int fVisible;
 int at_avail;
 char data_fname[13];
};

struct TW Window[nMaxWin+1] = { { 1, 1, 80, 11, 0, -1, UNDEFINED_MODE, 0, 0, "" }, 
                         { 1, 12, 80, 11, 0, -1, UNDEFINED_MODE, 0, 0, "" } };

FILE *in_file;                  
FILE *out_file;                 
FILE *cmd_file;                 

char szIDataFName[80] = "RTBC.DAT";
char szODataFName[80] = "BCRT.DAT";

char buf_str[100];
int fSkipCmds=0;  
int enter_mode=0; 
                  
                  
char ccs[16]={1, 1, 1, 1, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0};
                  
char *inp_err="Input error";
char *base_err="Wrong base number";
char *bus_num_err="Wrong bus number";
char *bad_ctrl_code="Wrong control code";
char *cc_no_def="Control code XXXX not defined";
char *mark_err="Wrong word address";
char *undef_cmd="Command doesn't exist";
char *const_err="Wrong constant";
char *cr_err="File creation error";
char *open_err="File open error";
char *format_err="File format error";
char *bc_reset_ok="Bus Controller reset OK";
char *rt_reset_ok="Remote Terminal reset OK";
char *subadr_err="Wrong subaddress";
char *bad_status_word="Error in status word";
char *no_int="Time-out exit";
char *int_ok="Interrupt";
char *kbd_break="Aborted by user";

#define TIMER_CTRL_PORT 0x43
#define TIMER0_PORT 0x40    
#define _30_MCSEC 72        
#define _660_MCSEC 1580     
#define _5000_MCSEC 11932
   
#define TEST_RTFL 1
#define TEST_MASK_RTFL 2
#define TEST_UNMASK_RTFL 3
#define TEST_SSFL 4
#define TEST_BUSY 5
#define TEST_SREQ 6
#define TEST_DNBA_OFF 7
#define TEST_DNBA_ON 8
#define TEST_RESET 9
#define TEST_SYNC 10
#define TEST_GET_VECTOR 11
#define TEST_GET_SELFTEST 12
#define TEST_SYNC_DATA 13
#define TEST_AT 14
#define TEST_BUSY1 15
#define TEST_NOBUSY1 16
#define TEST_COUNTER 17
#define TEST_RT_RT_BRCST 18
#define TEST_COUNTER_RT_BC 19
#define TEST_COUNTER_BC_RT 20
#define TEST_DNBA 21
#define TEST_BRCST_CMD 22
#define TEST_BRCST_BIT 23
#define TEST_ERROR 24
#define TEST_SYNC_DATA1 25
#define TEST_SYNC_DATA_BRCST 26
#define TEST_NO_RT_15 27
#define TEST_RT_15 28
#define TEST_NO_RT_0A 29
#define TEST_RT_0A 30
#define TEST_OTHER_AT 31
#define TEST_BLOCK_TR 32
#define TEST_UNBLOCK_TR 33
#define TEST_BLOCKED_TR 34
#define TEST_UNBLOCKED_TR 35
#define TEST_RT_DATA_IRQ 36
#define TEST_RT_DATA_IRQ_BL 37
#define TEST_RTFL_NI 38
#define TEST_SSFL_NI 39
#define TEST_BUSY_NI 40
#define TEST_SREQ_NI 41

#define DNB 0x400                  
#define SYNC 0x401                 
#define GET_SW 0x402               
#define START_SELFTEST 0x403       
#define BLOCK_TRANSMIT 0x404       
#define UNBLOCK_TRANSMIT 0x405     
#define MASK_RTFL 0x406            
#define UNMASK_RTFL 0x407          
#define RESET 0x408                
#define GET_VECTOR 0x410           
#define SYNC_DATA 0x011            
#define GET_CMD 0x412              
#define GET_SELFTEST 0x413         
#define BLOCK_SEL_TRANSMIT 0x04    
#define UNBLOCK_SEL_TRANSMIT 0x015 

int statistic_bc_rt(short st_base, short st_subadr, unsigned short st_data);
int statistic_rt_bc(short st_subadr, short st_base, unsigned short st_data);
void avt_bc(char *str);         
void avt_rt(char *str);         
void avt_ctrl(char *str);       
int cmp_ram_buf(int offset, int voffset, int size);

char *err_msg;
int bcwin, rtwin;
int bcnum, rtnum;
int rtadr, rtadr1, rtadr2;
unsigned ci_field;
int hb_mode = 1;
int subadr1, subadr2, subadr0, dir0, len;
int avt_out = 1;
int avt_ok;
int avt_err;
int fATArBlk = 1;
int fLPTSyn = 0;
int fReserv = 0;
int fSimpleRT = 0;
int fSimpleA = 0;
int fBcRt = 1;

unsigned nMainBus = BUS_A, nReservBus = BUS_B;

#define GL_COUNTER_INIT 500

  long GL_COUNTER = GL_COUNTER_INIT;            
  long GL_COUNTER2 = GL_COUNTER_INIT * 2;
  long GL_COUNTER3 = GL_COUNTER_INIT * 4;

int avtomat=0;            

unsigned long err_level=0;

//QNX 6 specific funcs
#define cprintf printf

#define BLACK          0x00
#define RED            0x01
#define GREEN          0x02
#define BROWN          0x03
#define BLUE           0x04
#define VIOLET         0x05
#define CYAN           0x06
#define LIGHTGRAY      0x07

#define DARKGRAY       0x08
#define LIGHTRED       0x09
#define LIGHTGREEN     0x0A
#define YELLOW         0x0B
#define LIGHTBLUE      0x0C
#define LIGHTVIOLET    0x0D
#define LIGHTCYAN      0x0E
#define WHITE          0x0F

struct termios saved_attr, cur_attr;
struct timespec biostime1;
int peek_character = -1;
int WinXSav, WinYSav;

int WinXMin = 1,
    WinXMax = 80,
    WinYMin = 1,
    WinYMax = 25;

void reset_input_mode()
{
  tcsetattr(STDIN_FILENO, TCSANOW, &saved_attr);
}

void set_input_mode()
{
  /* Make sure stdin is a terminal. */
  if (!isatty(STDIN_FILENO))
  {
    printf("Not a terminal.\n");
    exit(0);
  }

  tcgetattr(STDIN_FILENO, &saved_attr);
  atexit(reset_input_mode);

  cur_attr = saved_attr;
  cur_attr.c_lflag &= ~(ICANON|ECHO); /* Clear ICANON and ECHO. */
  cur_attr.c_cc[VMIN] = 1;
  cur_attr.c_cc[VTIME] = 0;
//  tcsetattr(STDIN_FILENO, TCSAFLUSH, &cur_attr);
  tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
}

set_output_mode()
{
 printf("\x1B)U");
 printf("\x1B~");
}

reset_output_mode()
{
 printf("\x1B)0");
 printf("\x1B}");
}

void gotoxy(int x, int y)
{
  WinXSav = x;
  WinYSav = y;
  printf("\x1B[%d;%dH", WinYMin - 1 + y, WinXMin - 1 + x);
  fflush(stdout);
}

int wherex()
{
  int x, y, nread;
  unsigned char inp[15];
 
  tcflush(STDIN_FILENO, TCIFLUSH);
  printf("\x1B[6n");
  fflush(stdout);
  nread = read(STDIN_FILENO, inp, 15);
//  printf("%c%c%c%c%c", inp[1],inp[2],inp[3],inp[4],inp[5]);
  sscanf(inp, "\x1B[%d;%dR", &y, &x);
//  printf("x %d y %d", x, y);
  x &= 0x7F;
//  y &= 0x7F;
  return x;
}

int wherey()
{
  int x, y, nread;
  unsigned char inp[15];
 
  tcflush(STDIN_FILENO, TCIFLUSH);
  printf("\x1B[6n");
  fflush(stdout);
  nread = read(STDIN_FILENO, inp, 15);
//  printf("%c%c%c%c%c", inp[1],inp[2],inp[3],inp[4],inp[5]);
  sscanf(inp, "\x1B[%d;%dR", &y, &x);
//  printf("x %d y %d", x, y);
//  x &= 0x7F;
  y &= 0x7F;
  return y;
}

void window(int xmin, int ymin, int xmax, int ymax)
{
  WinXMin = xmin,
  WinXMax = xmax,
  WinYMin = ymin,
  WinYMax = ymax;
}

void clrscr(void)
{
 int x,y;

 for (y = WinYMin; y<=WinYMax; y++)
 {
  //gotoxy(1,y-WinYMin+1);
  printf("\x1B[%d;%dH", y, 1);
  for (x=WinXMin; x<=WinXMax; x++)
   putchar(' ');
 } 
 gotoxy(1,1);
}

void clrscr_all(void)
{
 putchar(0x0C);
 fflush(stdout);
}

textcolor(int color)
{
 char intens = (color >> 3) & 1;

 color &= 0x7;
 if(intens)
   printf("\x1B[%d;%dm", 1, 1);
 else  
   printf("\x1B[%d;%dm", 21, 21);
 printf("\x1B[=%dF", color);
// fflush(stdout);
}

textbackground(int color)
{
 color &= 0x7;
 printf("\x1B[=%dG", color);
 fflush(stdout);
}

int kbhit()
{
  unsigned char ch;
  int nread;

//  if (peek_character != -1)
//    return 1;
  cur_attr.c_cc[VMIN] = 0;
  tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
  nread = read(STDIN_FILENO, &ch, 1);
  cur_attr.c_cc[VMIN] = 1;
  tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
  if (nread == 1)
  {
//    peek_character = ch;
    return 1;
  }
  return 0;
}

unsigned long biostime(int dummy1, long dummy2)
{
 struct timespec biostime2;

 clock_gettime(CLOCK_REALTIME, &biostime2);
 return ((biostime2.tv_sec-biostime1.tv_sec)*1000L+
         biostime2.tv_nsec/1000000L-biostime1.tv_nsec/1000000L)/55L;
}

void clreol(void)
{
/* int x;
 for (x=WinXMin; x<=WinXMax; x++)
  putchar(' ');
 gotoxy(1, WinYSav);*/
 int x, xsav, y;
 
 xsav = x = wherex();
 y = wherey();
 
 for (; x<=WinXMax; x++)
  putchar(' ');
 printf("\x1B[%d;%dH", y, xsav);
// fflush(stdout);
}

unsigned short bioskey_f12()
{
 unsigned short key, key1, key2;
 unsigned char inp[3];
 int nread;

 cur_attr.c_cc[VMIN] = 0;
 tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);
 nread = read(STDIN_FILENO, inp, 3);
 cur_attr.c_cc[VMIN] = 1;
 tcsetattr(STDIN_FILENO, TCSANOW, &cur_attr);

 if (nread == 3 && inp[0] == 0x1B && inp[1] == 0x4F && inp[2] == 0x41)
  prtscr_flag = 1;  
}

unsigned short bioskey()
{
 unsigned short key, key1, key2;
 unsigned char inp[5];
 int nread;

 tcflush(STDIN_FILENO, TCIFLUSH);
 nread = read(STDIN_FILENO, inp, 5);
 
 key = inp[0];
 key1 = inp[1];
 key2 = inp[2];
 
 if((key >= '0' && key <= '9') || (key >= 'a' && key <= 'z') ||(key >= 'A' && key <= 'Z'))
  goto gotkey;
  
 switch(key)
 {
  case 0x1B:
   if(nread == 1)
   {
    key = ESCAPE;
    goto gotkey;
   }
   else if(nread = 3)
   {
    switch(key1)
    {
     case 0x4F://SS3
      if(key2 >= 0x50 && key2 <= 0x59)//F1-F10
      {
       key = (F01 + (key2 & 0x0F)) << 8;
       goto gotkey;
      }
     break;
     case 0x5B://CSI 
      switch(key2)
      {
       case 0x44:
        key = LEFT << 8;
        goto gotkey;
       case 0x43:
        key = RIGHT << 8;
        goto gotkey;
       case 0x41:
        key = UP << 8;
        goto gotkey;
       case 0x42:
        key = DOWN << 8;
        goto gotkey;
       case 0x48:
        key = HOME << 8;
        goto gotkey;
       case 0x59:
        key = END << 8;
        goto gotkey;
       case 0x56:
        key = PGUP << 8;
        goto gotkey;
       case 0x55:
        key = PGDN << 8;
        goto gotkey;
       case 0x54:
        key = GPLUS << 8;
        goto gotkey;
      }
    }//key1
   }//nread = 3
  break; 
  case 0x09:
   key = TAB;
   goto gotkey;
  case 0x0A:
   key = CR;
   goto gotkey;
  case 0x7F:
   key = BACKSPACE;
   goto gotkey;
  case 0x2B:
//   key = GPLUSW;
   key = '+';
   goto gotkey;
  case ' ':
  case '<':
  case '>':
  case '/':
  case '?':
  case '\'':
  case '\"':
  case '#':
  case '(':
  case ')':
  case '-':
  case '*':
  case '$':
  case ';':
  case ':':
  case '!':
  case '=':
  case '@':
  case '~':
  case '_':
  case '`':
  case '%':
  case '^':
  case '&':
  case '[':
  case ']':
  case '{':
  case '}':
  case '.':
  case ',':
   goto gotkey; 
 }
 key = 0;
// printf("%d : %X ; %X ; %X ; %X ; %X ;", nread, ch[0], ch[1], ch[2], ch[3], ch[4] );  
gotkey:
 return key;
}

void CheckTmkEvent(int fWaitTime)
{
 TTmkEventData tmkEvD;
 int nSaveTmk;
 int nTmk;
 int hTMK = 0;
 unsigned int dwEvent;
// char str[30];//temp
 dwEvent = tmkwaitevents(TmkEvents, fWaitTime) & TmkEvents;
 for(; dwEvent != 0; hTMK++, dwEvent = dwEvent >> 1)
 {
   if((dwEvent & 0x01) == 0)
     continue;
//   sprintf(str, "Interrupt %d", hTMK);//temp
//   msg_out(str);//temp   
   nSaveTmk = tmkselected();
   nTmk = hTMK;
   if (nSaveTmk != nTmk)
     tmkselect(nTmk);
//    printf("TMK%d", nTmk);
   while (1)
   {
     tmkgetevd(&tmkEvD);
     if (tmkEvD.nInt == 0)
      break;
//     printf("INT%d ", tmkEvD.nInt);
     int_num[nTmk] = tmkEvD.nInt;
     switch (tmkEvD.wMode)
     {
     case BC_MODE:
      bc_sw = tmkEvD.bc.wResult;
      if (tmkEvD.nInt == 1)
       ++good_starts;
      else
      {
       bc_aw1 = tmkEvD.bc.wAW1;
       bc_aw2 = tmkEvD.bc.wAW2;
       if (bad_starts < (unsigned long)BADLEN)
       {
        bad_sts[(unsigned)bad_starts] = bad_starts + good_starts + 1L;
        bad_sws[(unsigned)bad_starts] = bc_sw;
        bad_aws[(unsigned)bad_starts] = bc_aw1;
       }
       ++bad_starts;
      }
      break;
     case RT_MODE:
      if (tmkEvD.nInt == 1)
      {
       rt_cmd = tmkEvD.rt.wCmd;
       rt_sw = rtgetstate();
      }
      else if (tmkEvD.nInt == 2)
      {
       rt_sw = tmkEvD.rt.wStatus;
      }
      else
      {
       rt_sw = rtgetstate();
      }
      break;
     }
   }//while(1)
   if (nSaveTmk != nTmk)
     tmkselect(nSaveTmk);
 }//for all TMKs
 //CheckInput();//if pressed F12
}
//End QNX6 specific funcs

unsigned inline get_timer()
{
 register t;

// _disable();
 outportb(TIMER_CTRL_PORT, 0x00);
 t = (unsigned)inportb(TIMER0_PORT);
 t |= (unsigned)inportb(TIMER0_PORT)<<8;
// _enable();
 return t;
}

int fBeep = 1;

void beep1()
{
 if (fBeep)
  putchar('\007');
}

void beep(char *str)
{
 int i, nBeeps;
 while (*str == '\t' || *str == ' ') str++;
 if (*str)
 {
  if (sscanf(str, "%u", &nBeeps) != 1)
  {
   msg_out(inp_err);
   return;
  }
 }
 else
  nBeeps = 1;
 for (i = 0; i < nBeeps; ++i)
 {
  putchar('\007');
  fflush(stdout); 
 }
}

#ifdef ELCUS
unsigned nATWords = 32;

void set_a_words(char *str)
{
 unsigned c;

 if (sscanf(str, "%u", &c) != 1 || c > 32)
 {
  msg_out(inp_err);
  return;
 }
 nATWords=c;
}
#endif //def ELCUS

#ifdef ELCUS
char szBC[] = "0";
char szRT[] = "0";
char szBus[] = "a";
char szInst[] = "i+";
char szCmds[] = "c+";
char szFlags[] = "f+";

int randbcrt(int bcnum, int rtnum, int fReserv, int hb_mode)
{
  int res;
  unsigned bus;
  int num, num1;

  num = tmkselected();
  tmkselect(bcnum);
  bus = bcgetbus();
  tmkdone(ALL_TMKS);

  window(1, 1, 80, 25);
  clrscr();
  szBC[0] = bcnum + '0';
  szRT[0] = rtnum + '0';
  szInst[1] = (hb_mode) ? '+' : '-';
  szCmds[1] = (fSimpleRT) ? '-' : '+';
  szFlags[1] = (fSimpleRT) ? '-' : '+';

  if (fReserv)
    res = spawnlp(P_WAIT, "./randbcrt", "./randbcrt", szBC, szRT, "m0-2000000", szInst, szCmds, szFlags, "e1", NULL);
  else
  {
    szBus[0] = (bus == BUS_A) ? 'a' : 'b';
    res = spawnlp(P_WAIT, "./randbcrt", "./randbcrt", szBC, szRT, szBus, "m0-2000000", szInst, szCmds, szFlags, "e1", NULL);
  }

  TmkInit0();
//  num1 = tmkselected();
  select_window(bcwin);
//  tmkselect(bcnum);
  bus_num = bus;
  out_number();
  bcdefbus(bus);
  fflush(stdout);
//  tmkselect(num1);
  return res;
}
#endif //def ELCUS

int test_start(int test_mode)
{
 int result = 1;
// unsigned cmdw;
 unsigned long p;
 int fWaitRtIntr = 0;
 int fRtIntr = 0;
 
 err_msg = NULL;
 switch (test_mode)
 {
 case TEST_RTFL:
 case TEST_SSFL:
 case TEST_BUSY:
 case TEST_SREQ:
 case TEST_DNBA_OFF:
 case TEST_DNBA_ON:
// case TEST_RESET:
 case TEST_SYNC:
 case TEST_GET_VECTOR:
 case TEST_GET_SELFTEST:
 case TEST_SYNC_DATA:
 case TEST_RT_DATA_IRQ:
  fRtIntr = 1;
 case TEST_RT_DATA_IRQ_BL:
 case TEST_OTHER_AT:
  fWaitRtIntr = 1;
  break;
 }
 if (fWaitRtIntr)
  CheckTmkEvent(0);
 int_num[rtnum] = 0;
 if (fWaitRtIntr)
  p = biostime(0, 0L);
 start_1("");
 if (fWaitRtIntr)
  while (int_num[rtnum] == 0 && (biostime(0, 0L) - p) < 5)CheckTmkEvent(0);

 if (int_num[bcnum] == 0)
 {
   err_msg = "No BC interrupt";
   return 1;
 }
 if (fRtIntr && int_num[rtnum] == 0)
 {
   err_msg = "No RT interrupt";
   return 1;
 }
// cmdw = bcgetw(0);
 switch (test_mode)
 {
 case TEST_RTFL:
 case TEST_RTFL_NI:
  if (int_num[bcnum] == 2 &&
      bc_aw1 == ((rtadr<<11) | RTFL_MASK) && 1)
//      rt_cmd == SYNC)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_MASK_RTFL:
  if (int_num[bcnum] == 1 && 1)
//      rt_cmd == MASK_RTFL)
   result = 0;
  break;
 case TEST_UNMASK_RTFL:
  if (int_num[bcnum] == 2 &&
      bc_aw1 == ((rtadr<<11) | RTFL_MASK) && 1)
//      rt_cmd == UNMASK_RTFL)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_SSFL:
 case TEST_SSFL_NI:
  if (int_num[bcnum] == 2 &&
      bc_aw1 == ((rtadr<<11) | SSFL_MASK) && 1)
//      rt_cmd == SYNC)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_BUSY:
 case TEST_BUSY_NI:
  if (int_num[bcnum] == 2 &&
      bc_aw1 == ((rtadr<<11) | BUSY_MASK) && 1)
//      rt_cmd == SYNC)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_SREQ:
 case TEST_SREQ_NI:
  if (int_num[bcnum] == 2 &&
      bc_aw1 == ((rtadr<<11) | SREQ_MASK) && 1)
//      rt_cmd == SYNC)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_DNBA_OFF:
  if (fSimpleRT && fSimpleA)
  {
    if (int_num[bcnum] == 2 &&
        bc_aw1 == ((rtadr<<11) | ERROR_MASK) &&
        bad_starts == 1001)
    {
     result = 0;
     good_starts++;
     bad_starts -= 1001;
     break;
    }
  }
  if (int_num[bcnum] == 1 &&
      rt_cmd == DNB)
   result = 0;
  break;
 case TEST_DNBA_ON:
  if (int_num[bcnum] == 2 &&
      bc_aw1 == ((rtadr<<11) | DNBA_MASK) &&
      rt_cmd == DNB)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_RESET:
  if (int_num[bcnum] == 1 && 1)
//      rt_cmd == RESET)
   result = 0;
  break;
 case TEST_SYNC:
  if (int_num[bcnum] == 1 &&
      rt_cmd == SYNC)
   result = 0;
  break;
 case TEST_GET_VECTOR:
  if (int_num[bcnum] == 1 &&
      bcgetw(2) == 0xFACE &&
      rt_cmd == GET_VECTOR)
   result = 0;
  break;
 case TEST_GET_SELFTEST:
  if (int_num[bcnum] == 1 &&
      (bcgetw(2) == 0xBABA || (fSimpleRT && bcgetw(2) == 0xFACE)) &&
      rt_cmd == GET_SELFTEST)
   result = 0;
  break;
 case TEST_SYNC_DATA:
  if (int_num[bcnum] == 1 &&
      rt_cmd == SYNC_DATA)
  {
   tmkselect(rtnum);
   if (rtgetcmddata(SYNC_DATA) == 0xA5A5 || (fSimpleRT && rtgetcmddata(0x0000) == 0xA5A5))
    result = 0;
   tmkselect(bcnum);
  }
  break;
 case TEST_OTHER_AT:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_TO_MASK)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_AT:
  if (int_num[bcnum] == 1 &&
      bcgetw(1) == (rtadr<<11))
   result = 0;
  break;
 case TEST_BUSY1:
  if (int_num[bcnum] == 2 &&
      ((dir == RT_RECEIVE && bc_sw == S_IB_MASK) ||
       (dir == RT_TRANSMIT && bc_sw == (S_IB_MASK | S_TO_MASK))) &&
        bc_aw1 == ((rtadr<<11) | BUSY_MASK))
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_NOBUSY1:
  if (int_num[bcnum] == 1)
  {
   result = 0;
  }
  break;
 case TEST_COUNTER:
  if (int_num[bcnum] == 1)
  {
   result = 0;
  }
  break;
 case TEST_COUNTER_RT_BC:
 case TEST_COUNTER_BC_RT:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_RT_RT_BRCST:
  if (int_num[bcnum] == 1 &&
      !cmp_ram_buf(0, 3, 32))
  {
   result = 0;
  }
  break;
 case TEST_DNBA:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_IB_MASK &&
      bc_aw1 == ((rtadr<<11) | DNBA_MASK))
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_BRCST_CMD:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_BRCST_BIT:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_IB_MASK &&
      bc_aw1 == ((rtadr<<11) | BRCST_MASK))
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_ERROR:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_IB_MASK &&
      bc_aw1 == ((rtadr<<11) | ERROR_MASK))
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_SYNC_DATA1:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_SYNC_DATA_BRCST:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_NO_RT_15:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_TO_MASK)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_RT_15:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_NO_RT_0A:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_TO_MASK)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_RT_0A:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_BLOCK_TR:
 case TEST_UNBLOCK_TR:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_BLOCKED_TR:
  if (int_num[bcnum] == 2 &&
      bc_sw == S_TO_MASK)
  {
   result = 0;
   good_starts++;
   bad_starts--;
  }
  break;
 case TEST_UNBLOCKED_TR:
  if (int_num[bcnum] == 1 &&
      bc_sw == 0)
  {
   result = 0;
  }
  break;
 case TEST_RT_DATA_IRQ:
  if (int_num[bcnum] == 1 &&
      int_num[rtnum] == 3)
  {
   result = 0;
  }
  break;
 case TEST_RT_DATA_IRQ_BL:
  if (int_num[bcnum] == 1 &&
      int_num[rtnum] == 0)
  {
   result = 0;
  }
  break;
 }
// test_err = !result;
 return result;
}

void make_test1(int start)
{
 unsigned data;
 int k;

 data = 0;
 for (k = start; k <= start+31; ++k)
 {
  buffer[k] = data;
  switch (data)
  {
  case 0x0000:
   data = 0x0001;
   break;
  case 0x8000:
   data = 0xAAAA;
   break;
  case 0xAAAA:
   data = 0x5555;
   break;
  case 0x5555:
   data = 0xAAAA;
   break;
  default:
   data <<= 1;
  }
 }
}

/************************************************************************/
/*                      Bus Controller Tests                            */
/************************************************************************/

void avt_bc(char *str)
{
 int counter, i, k, maxbase, err;
 unsigned long times, nBusSwapTime;

 while (*str == '\t' || *str == ' ') str++;
 if (*str)
 {
  if (sscanf(str, "%u", &times) != 1)
  {
   msg_out(inp_err);
   return;
  }
 }
 else
  times=1;
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 avt_ctrl("1");
 avt_ok = 0;
 select_window(bcwin);
 if (fReserv)
 {
  nReservBus = ((nMainBus=bcgetbus()) == BUS_A) ? BUS_B : BUS_A;
  bus_num = nMainBus;
  out_number();
  nBusSwapTime = times+1;
  times <<= 1;
 }
 select_window(rtwin);
 wr_at(rtadr=0x0A);
 out_at();
 set_status_word("0");
 comment("Bus Controller automatic test.");
 select_window(bcwin);
 statistic_clear("");
 if (hb_mode)
 {
  subadr1 = 0x10;
  subadr2 = 0x1E;
  ci_field = 0x1F<<5;
 }
 else
 {
  subadr1 = 0x01;
  subadr2 = 0x1E;
  ci_field = 0;
 }
 if (bc_ram_test(""))
 {
  err_msg = "RAM test didn't pass";
  goto fin;
 }
 do
 {
  select_window(bcwin);
  maxbase = tmkMaxBase[tmkselected()];
  buf_clear("");
  srand(1);
  subadr = subadr1;
  for (base = 0; base <= maxbase; base++)
  {
   bcdefbase(base);
   ctrl_code[bcnum][base] = DATA_BC_RT;
   buffer[0] = (rtadr<<11) | (RT_RECEIVE) | (subadr<<5);
   buffer[1] = base | (base<<8);
   for (k = 2; k <= 32; ++k)
    buffer[k] = rand() + rand();
   bcputblk(0, buffer, 33);
   if (++subadr > subadr2)
    subadr = subadr1;
  }
  subadr = subadr1;
  srand(1);
  err = 0;
  for (base = 0; base <= maxbase; base++)
  {
   select_window(bcwin);
   if (start_1(""))
   {
    err_msg = "Transmitting of test array from BC to RT didn't pass";
    goto fin;
   }
   select_window(rtwin);
   rtdefsubaddr(RT_RECEIVE, subadr);
   rtgetblk(0, buffer, 32);
   if (buffer[0] != (unsigned short)(base | (base<<8)))
   {
    err = 1;
    ++data_err;
    break;
   }
   for (k = 1; k <= 31; ++k)
    if (buffer[k] != rand() + rand())
    {
     err = 1;
     ++data_err;
     break;
    }
   if (err)
    break;
   if (++subadr > subadr2)
    subadr = subadr1;
  }
  if (err)
  {
   err_msg = "Test array transmitted to RT with errors";
   goto fin;
  }
  select_window(bcwin);
  bc_clear_ram();
  srand(1);
  subadr = subadr1;
  for (base = 0; base <= maxbase; base++)
  {
   select_window(rtwin);
   rtdefsubaddr(RT_TRANSMIT, subadr);
   buffer[0] = base | (base<<8);
   for (k = 1; k <= 31; ++k)
    buffer[k] = rand() + rand();
   rtputblk(0, buffer, 32);
   select_window(bcwin);
   bcdefbase(base);
   ctrl_code[bcnum][base] = DATA_RT_BC;
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5));
   if (start_1(""))
   {
    err_msg = "Receiving of test array from RT to BC didn't pass";
    goto fin;
   }
   if (++subadr > subadr2)
    subadr = subadr1;
  }
  srand(1);
  select_window(bcwin);
  for (base = 0; base <= maxbase; base++)
  {
   bcdefbase(base);
   bcgetblk(2, buffer, 32);
   if (buffer[0] != (unsigned short)(base | (base<<8)))
   {
    err = 1;
    ++data_err;
    break;
   }
   for (k = 1; k <= 31; ++k)
    if (buffer[k] != rand() + rand())
    {
     err = 1;
     ++data_err;
     break;
    }
   if (err)
    break;
   if (++subadr > subadr2)
    subadr = subadr1;
  }
  if (err)
  {
   err_msg = "Test array received from RT with errors";
   goto fin;
  }
  select_window(rtwin);
  rtdefsubaddr(dir=RT_TRANSMIT, subadr=0x10);
  for (k = 0; k <= 31; ++k)
   buffer[k] = k+1;
  rtputblk(0, buffer, 32);
  select_window(bcwin);
  bcdefbase(1);
  bcputblk(1, buffer, 32);
  bcdefbase(base=0);
  ctrl_code[bcnum][base] = DATA_RT_BC;
  for (len = 1; len <= 32; len++)
  {
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5) | (len & 0x1F));
   if (test_start(TEST_COUNTER_RT_BC))
   {
    if (err_msg == NULL)
      err_msg = "Data counter test (RT->BC message) didn't pass";
    goto fin;
   }
  }
  bcdefbase(base=1);
  ctrl_code[bcnum][base] = DATA_BC_RT;
  for (len = 1; len <= 32; len++)
  {
   bcputw(0, (rtadr<<11) | RT_RECEIVE | (subadr<<5) | (len & 0x1F));
   if (test_start(TEST_COUNTER_BC_RT))
   {
    if (err_msg == NULL)
      err_msg = "Data counter test (BC->RT message) didn't pass";
    goto fin;
   }
  }
  make_test1(3);
  select_window(rtwin);
  rtdefsubaddr(dir=RT_TRANSMIT, subadr=0x17);
  rtputblk(0, buffer+3, 32);
  select_window(bcwin);
  bcdefbase(base=2);
  ctrl_code[bcnum][base] = DATA_RT_RT_BRCST;
  bcputw(0, (0x1F<<11) | RT_RECEIVE | (subadr<<5));
  bcputw(1, (rtadr<<11) | RT_TRANSMIT | (subadr<<5));
  if (start_loop_n(GL_COUNTER))
  {
   err_msg = "Broadcast RT->RT message test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  if (cmp_ram_buf(3, 0, 32))
  {
   err_msg = "Test array in RT->RT message received with errors";
   goto fin;
  }
  select_window(bcwin);
  base = 3;
  bcdefbase(base);
  buf_clear("");
  select_window(rtwin);
  rtsetanswbits(RTFL);
  out_status_word();
  fflush(stdout);
  select_window(bcwin);
  ctrl_code[bcnum][base] = CTRL_C_A;
  bcputw(0, (rtadr<<11) | ci_field | UNBLOCK_TRANSMIT);
  if (test_start(TEST_RTFL_NI))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Terminal Flag' bit test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(RTFL);
  rtsetanswbits(SSFL);
  select_window(bcwin);
  if (test_start(TEST_SSFL_NI))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Subsystem Flag' bit test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(SSFL);
  rtsetanswbits(BUSY);
  select_window(bcwin);
  if (test_start(TEST_BUSY_NI))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Subsystem Busy' bit test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(BUSY);
  rtsetanswbits(SREQ);
  select_window(bcwin);
  if (test_start(TEST_SREQ_NI))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Service Request' bit test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(SREQ);
  if (!fSimpleRT)
  {
   rtsetanswbits(DNBA);
   select_window(bcwin);
   bcputw(0, (rtadr<<11) | ci_field | DNB);
   if (test_start(TEST_DNBA))
   {
   if (err_msg == NULL)
    err_msg = "Status with 'Dynamic Bus Control Acceptance' bit test didn't pass";
    goto fin;
   }
   select_window(rtwin);
   rtclranswbits(DNBA);
  }
  out_status_word();
  fflush(stdout);
  select_window(bcwin);
  ctrl_code[bcnum][base] = CTRL_C_BRCST;
  bcputw(0, (0x1F<<11) | ci_field | RESET);
  if (test_start(TEST_BRCST_CMD))
  {
   if (err_msg == NULL)
    err_msg = "'Broadcast Reset Remote Terminal' test didn't pass";
   goto fin;
  }
  ctrl_code[bcnum][base] = CTRL_C_A;
  bcputw(0, (rtadr<<11) | ci_field | GET_SW);
  if (test_start(TEST_BRCST_BIT))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Broadcast Command Received' bit test didn't pass";
   goto fin;
  }
  bcputw(0, ~RT_DIR_MASK & ((rtadr<<11) | ci_field | SYNC));
  if (test_start(TEST_ERROR))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Message Error' bit test didn't pass";
   goto fin;
  }
  ctrl_code[bcnum][base] = CTRL_CD_A;
  bcputw(0, (rtadr<<11) | ci_field | SYNC_DATA);
  bcputw(1, 0xAAAA);
  if (test_start(TEST_SYNC_DATA1))
  {
   if (err_msg == NULL)
    err_msg = "'Synchronize with Data AAAAh' test didn't pass";
   goto fin;
  }
  ctrl_code[bcnum][base] = CTRL_CD_BRCST;
  bcputw(0, (0x1F<<11) | ci_field | SYNC_DATA);
  bcputw(1, 0x5555);
  if (test_start(TEST_SYNC_DATA_BRCST))
  {
   if (err_msg == NULL)
    err_msg = "'Broadcast Synchronize with Data 5555h' test didn't pass";
   goto fin;
  }
  ctrl_code[bcnum][base] = CTRL_C_A;
  bcputw(0, (rtadr<<11) | ci_field | RESET);
  if (test_start(TEST_BRCST_CMD))
  {
   if (err_msg == NULL)
    err_msg = "Status with 'Broadcast Command Received' bit test didn't pass";
   goto fin;
  }
  all_screen();
  if (Window[rtwin].at_avail)
  {
   rtadr1 = 0x15;
   rtadr2 = 0x0A;
  }
  else
  {
 #ifdef LPT_AT
   rtadr1 = 0x15;
   rtadr2 = 0x0A;
 #else
   rtadr1 = (rtadr == 0) ? 0x1E : rtadr ^ 0x1F;
   rtadr2 = rtadr;
 #endif
  }
  ctrl_code[bcnum][base] = CTRL_C_A;
  bcputw(0, (rtadr1<<11) | ci_field | GET_SW);
  if (test_start(TEST_NO_RT_15))
  {
   if (err_msg == NULL)
    err_msg = "Missing RT with address 15h (10101) access test didn't pass";
   goto fin;
  }
 #ifndef LPT_AT
  if (Window[rtwin].at_avail)
 #endif
  {
   select_window(rtwin);
   wr_at(rtadr = rtadr1);
   select_window(bcwin);
   if (test_start(TEST_RT_15))
   {
   if (err_msg == NULL)
     err_msg = "RT with address 15h (10101) access test didn't pass";
    goto fin;
   }
   bcputw(0, (rtadr2<<11) | ci_field | GET_SW);
   if (test_start(TEST_NO_RT_0A))
   {
   if (err_msg == NULL)
    err_msg = "Missing RT with address 0Ah (01010) access test didn't pass";
    goto fin;
   }
  }
  select_window(rtwin);
  wr_at(rtadr = rtadr2);
  select_window(bcwin);
  bcputw(0, (rtadr2<<11) | ci_field | GET_SW);
  if (test_start(TEST_RT_0A))
  {
   if (err_msg == NULL)
     err_msg = "RT with address 0Ah (01010) access test didn't pass";
   goto fin;
  }
  CheckTmkEvent(0);
  int_num[rtnum] = 0;
  select_window(rtwin);

//  rtdefirqmode(RT_DATA_BL); //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  wr_at(rtadr);
//  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x10, 0, 0xAAAA)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x12, 2, 0x0000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x14, 4, 0x5555)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x16, 6, 0xFFFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x18, 8, 0x8000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x1A, 10, 0x7FFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(12, 0x10, 0xAAAA)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(14, 0x12, 0x0000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(16, 0x14, 0x5555)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(18, 0x16, 0xFFFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(20, 0x18, 0x8000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(22, 0x1A, 0x7FFF)) goto bad_statistic;
  if (channel_err > 0L)
   goto bad_statistic;
  select_window(bcwin);
  if (fReserv && (times == nBusSwapTime || times == 1))
  {
   unsigned nTempBus;
   bcdefbus(nReservBus);
   nTempBus = nMainBus;
   nMainBus = nReservBus;
   nReservBus = nTempBus;
   bus_num = nMainBus;
   out_number();
   fflush(stdout);
  }
 }
 while (--times);
#ifdef ELCUS
 if (fBcRt && *str)
 {
  if (randbcrt(bcnum, rtnum, fReserv, hb_mode))
  {
   err_msg = "Randbcrt test didn't pass";
   goto fin;
  }
 }
#endif //def ELCUS
 avt_ok = 1;
 err_msg = "Bus Controller test completed";
 goto fin;
 bad_statistic:
 err_msg = "'Statistics' test didn't pass";
 fin:
 if (prtscr_flag)
 {
  prtscr_flag = 0;
  err_msg = "Test aborted on F12";
 }
 check_int();
 select_window(nmainwin=bcwin);
 all_screen();
 select_window(rtwin);
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(nmainwin=bcwin);
 statistic_out("");
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 avt_err = !avt_ok;
}

/************************************************************************/
/*                      Remote Terminal Tests                           */
/************************************************************************/

int test_rt_busy()
{
 int test_result;

 test_result = 1;
 rtdefsubaddr(dir = RT_TRANSMIT, subadr = 0x11);
 select_window(bcwin);
 bcdefbase(base);
 ctrl_code[bcnum][base] = DATA_RT_BC;
 bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5));
 CheckTmkEvent(0);
 int_num[bcnum] = 0;
 bcstart(base, ctrl_code[bcnum][base]);
 tmkselect(rtnum);
 do
 {
  if (rtbusy()) test_result = 0;
  CheckTmkEvent(0);
 } 
 while (!int_num[bcnum]);
 select_window(rtwin);
 return test_result;
}

void avt_rt(char *str)
{
 int maxpage, k, err, page;
 unsigned long times, nBusSwapTime;

 while (*str == '\t' || *str == ' ') str++;
 if (*str)
 {
  if (sscanf(str, "%u", &times) != 1)
  {
   msg_out(inp_err);
   return;
  }
 }
 else
  times=1;
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 statistic_clear("");
 avt_ctrl("1");
 avt_ok = 0;
 select_window(bcwin);
 if (fReserv)
 {
  nReservBus = ((nMainBus=bcgetbus()) == BUS_A) ? BUS_B : BUS_A;
  bus_num = nMainBus;
  out_number();
  fflush(stdout);
  nBusSwapTime = times+1;
  times <<= 1;
 }
 select_window(rtwin);
 if (rt_ram_test(""))
 {
  err_msg = "RAM test didn't pass";
  goto fin;
 }
 wr_at(rtadr=0x0A);
 out_at();
 set_status_word("0"); 
 comment("Remote Terminal automatic test.");
 maxpage = rtgetmaxpage();
 if (hb_mode)
 {
  subadr1 = 0x10;
  subadr2 = 0x1E;
  ci_field = CI_MASK;
 }
 else
 {
  subadr1 = 0x01;
  subadr2 = 0x1E;
  ci_field = 0;
 }
 do
 {
  select_window(rtwin);
  srand(1);
  for (page = 0; page <= maxpage; page++)
  {
   rtdefpage(page);
   for(subadr = subadr1; subadr <= subadr2; subadr++)
   {
    rtdefsubaddr(RT_TRANSMIT, subadr);
    buffer[0] = (page<<14) | (subadr<<8) | (page<<6) | subadr | 0x2020;
    for (k = 1; k <= 31; ++k)
     buffer[k] = rand() + rand();
    rtputblk(0, buffer, 32);
   }
  }
  srand(1);
  for (page = 0; page <= maxpage; page++)
  {
   select_window(rtwin);
   rtdefpage(page);
   select_window(bcwin);
   bcdefbase(base=0);
   ctrl_code[bcnum][base] = DATA_RT_BC;
   for(subadr = subadr1; subadr <= subadr2; subadr++)
   {
    bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5));
    if (start_1(""))
    {
     err_msg = "Transmitting of test array from RT to BC didn't pass";
     goto fin;
    }
    vbuffer[0] = (page<<14) | (subadr<<8) | (page<<6) | subadr | 0x2020;
    for (k = 1; k <= 31; ++k)
     vbuffer[k] = rand() + rand();
    if (cmp_ram_buf(2, -1, 32))
    {
     err_msg = "Test array transmitted from RT with errors";
     goto fin;
    }
   }
  }
  for (page = 0; page <= maxpage; page++)
  {
   select_window(rtwin);
   rtdefpage(page);
   select_window(bcwin);
   bcdefbase(base=1);
   ctrl_code[bcnum][base] = DATA_BC_RT;
   for(subadr = subadr1; subadr <= subadr2; subadr++)
   {
    buffer[0] = (rtadr<<11) | RT_RECEIVE | (subadr<<5);
    buffer[1] = (page<<14) | (subadr<<8) | (page<<6) | subadr;
    for (k = 2; k <= 32; ++k)
     buffer[k] = rand() + rand();
    bcputblk(0, buffer, 33);
    if (start_1(""))
    {
     err_msg = "Receiving of test array from BC to RT didn't pass";
     goto fin;
    }
   }
  }
  srand(1);
  select_window(rtwin);
  for (page = 0; page <= maxpage; page++)
  {
   rtdefpage(page);
   for (subadr = subadr1; subadr <= subadr2; subadr++)
   {
    buffer[0] = (page<<14) | (subadr<<8) | (page<<6) | subadr | 0x2020;
    for (k = 1; k <= 31; ++k)
     buffer[k] = rand() + rand();
    rtdefsubaddr(RT_TRANSMIT, subadr);
    if (cmp_ram_buf(0, 0, 32))
    {
     err_msg = "Data in Tx subaddress has changed while receiving test array";
     goto fin;
    }
   }
  }
  for (page = 0; page <= maxpage; page++)
  {
   rtdefpage(page);
   for (subadr = subadr1; subadr <= subadr2; subadr++)
   {
    buffer[0] = (page<<14) | (subadr<<8) | (page<<6) | subadr;
    for (k = 1; k <= 31; ++k)
     buffer[k] = rand() + rand();
    rtdefsubaddr(RT_RECEIVE, subadr);
    if (cmp_ram_buf(0, 0, 32))
    {
     err_msg = "Test array received to RT with errors";
     goto fin;
    }
   }
  }
  set_page("0");
  rtsetanswbits(RTFL); // TF 
  select_window(bcwin);
  ctrl_code[bcnum][base] = CTRL_C_A;
  bcputw(0, (rtadr<<11) | ci_field | SYNC);
  if (test_start(TEST_RTFL))
  {
   if (err_msg == NULL)
    err_msg = "Status bit 'Terminal Flag' didn't set";
   goto fin;
  }
  bcputw(0, (rtadr<<11) | ci_field | MASK_RTFL);
  if (test_start(TEST_MASK_RTFL))
  {
   if (err_msg == NULL)
    err_msg = "'Inhibit Terminal Flag Bit' command didn't pass";
   goto fin;
  }
  bcputw(0, (rtadr<<11) | ci_field | UNMASK_RTFL);
  if (test_start(TEST_UNMASK_RTFL))
  {
   if (err_msg == NULL)
    err_msg = "'Override Inhibit Terminal Flag Bit' command didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(RTFL); // TF 
  rtsetanswbits(SSFL); // SF 
  select_window(bcwin);
  bcputw(0, (rtadr<<11) | ci_field | SYNC);
  if (test_start(TEST_SSFL))
  {
   if (err_msg == NULL)
    err_msg = "Status bit 'Subsystem Flag' didn't set";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(SSFL); // SF 
  rtsetanswbits(BUSY); // BS 
  select_window(bcwin);
  bcputw(0, (rtadr<<11) | ci_field | SYNC);
  if (test_start(TEST_BUSY))
  {
   if (err_msg == NULL)
    err_msg = "Status bit 'Subsystem Busy' didn't set";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(BUSY); // BS 
  rtsetanswbits(SREQ); // SR 
  select_window(bcwin);
  bcputw(0, (rtadr<<11) | ci_field | SYNC);
  if (test_start(TEST_SREQ))
  {
   if (err_msg == NULL)
    err_msg = "Status bit 'Service Request' didn't set";
   goto fin;
  }
  select_window(rtwin);
  rtclranswbits(SREQ); /* SR */
  select_window(bcwin);
  bcputw(0, (rtadr<<11) | ci_field | DNB);
  if (test_start(TEST_DNBA_OFF))
  {
   if (err_msg == NULL)
    err_msg = "Status bit 'Dynamic Bus Control Acceptance' set while RT disallowed it";
   goto fin;
  }
  if (!fSimpleRT)
  {
    select_window(rtwin);
    rtsetanswbits(DNBA); /* DN */
    select_window(bcwin);
    bcputw(0, (rtadr<<11) | ci_field | DNB);
    if (test_start(TEST_DNBA_ON))
    {
     if (err_msg == NULL)
      err_msg = "Status bit 'Dynamic Bus Control Acceptance' didn't set";
     goto fin;
    }
    select_window(rtwin);
    rtclranswbits(DNBA); 
  }
  select_window(bcwin);
  bcputw(0, (rtadr<<11) | ci_field | RESET);
  if (test_start(TEST_RESET))
  {
   if (err_msg == NULL)
      err_msg = "Status bit 'Dynamic Bus Control Acceptance' didn't reset on 'Reset RT' cmd";
   goto fin;
  }
  if (fReserv)
  {
   bcputw(0, (rtadr<<11) | ci_field | BLOCK_TRANSMIT);
   if (test_start(TEST_BLOCK_TR))
   {
    if (err_msg == NULL)
     err_msg = "'Transmitter shutdown' command1 didn't pass";
    goto fin;
   }
   bcdefbus(nReservBus);
   ctrl_code[bcnum][base] = DATA_RT_BC;
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (0x10<<5) | 1);
   if (test_start(TEST_BLOCKED_TR))
   {
    if (err_msg == NULL)
     err_msg = "Disabled transmitter test1 didn't pass";
    goto fin;
   }
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, (rtadr<<11) | ci_field | RESET);
   if (test_start(TEST_RESET))
   {
    if (err_msg == NULL)
     err_msg = "RT reset on disabled bus didn't pass";
    goto fin;
   }
   ctrl_code[bcnum][base] = DATA_RT_BC;
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (0x10<<5) | 1);
   if (test_start(TEST_UNBLOCKED_TR))
   {
    if (err_msg == NULL)
     err_msg = "Enabled transmitter test1 didn't pass";
    goto fin;
   }
   bcdefbus(nMainBus);
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, (rtadr<<11) | ci_field | BLOCK_TRANSMIT);
   if (test_start(TEST_BLOCK_TR))
   {
    if (err_msg == NULL)
     err_msg = "'Transmitter shutdown' command2 didn't pass";
    goto fin;
   }
   bcdefbus(nReservBus);
   ctrl_code[bcnum][base] = DATA_RT_BC;
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (0x10<<5) | 1);
   if (test_start(TEST_BLOCKED_TR))
   {
    if (err_msg == NULL)
     err_msg = "Disabled transmitter test2 didn't pass";
    goto fin;
   }
   bcdefbus(nMainBus);
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, (rtadr<<11) | ci_field | UNBLOCK_TRANSMIT);
   if (test_start(TEST_UNBLOCK_TR))
   {
    if (err_msg == NULL)
     err_msg = "'Override Transmitter shutdown' command2 didn't pass";
    goto fin;
   }
   bcdefbus(nReservBus);
   ctrl_code[bcnum][base] = DATA_RT_BC;
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (0x10<<5) | 1);
   if (test_start(TEST_UNBLOCKED_TR))
   {
    if (err_msg == NULL)
     err_msg = "Enabled transmitter test2 didn't pass";
    goto fin;
   }
   bcdefbus(nMainBus);
  }
  ctrl_code[bcnum][base] = CTRL_C_A;
  bcputw(0, (rtadr<<11) | ci_field | SYNC);
  if (test_start(TEST_SYNC))
  {
   if (err_msg == NULL)
    err_msg = "'Synchronize' command didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtputcmddata(GET_VECTOR, 0xFACE);
  rtputcmddata(GET_SELFTEST, 0xBABA);
  if (fSimpleRT)
  {
    rtputcmddata(0x0400, 0xFACE);
  }
  select_window(bcwin);
  ctrl_code[bcnum][base] = CTRL_C_AD;
  bcputw(0, (rtadr<<11) | ci_field | GET_VECTOR);
  if (test_start(TEST_GET_VECTOR))
  {
   if (err_msg == NULL)
    err_msg = "'Transmit Vector Word' command didn't pass";
   goto fin;
  }
  bcputw(0, (rtadr<<11) | ci_field | GET_SELFTEST);
  if (test_start(TEST_GET_SELFTEST))
  {
    err_msg = "'Transmit BIT Word' command didn't pass";
   goto fin;
  }
  ctrl_code[bcnum][base] = CTRL_CD_A;
  bcputw(0, (rtadr<<11) | ci_field | SYNC_DATA);
  bcputw(1, 0xA5A5);
  if (test_start(TEST_SYNC_DATA))
  {
   if (err_msg == NULL)
    err_msg = "'Synchronize with Data A5A5h' command didn't pass";
   goto fin;
  }
  ctrl_code[bcnum][base] = CTRL_C_A;
  for (rtadr1 = 1; rtadr1 != 32; rtadr1 <<= 1)
  {
   if (rtadr == rtadr1) continue;
   bcputw(0, (rtadr1<<11) | ci_field | SYNC);
   if (test_start(TEST_OTHER_AT))
   {
    if (err_msg == NULL)
     err_msg = "Other address RT access test didn't pass";
    goto fin;
   }
  }
 #ifndef LPT_AT
  if (Window[rtwin].at_avail)
 #endif
  {
   for (rtadr = 1; rtadr != 32; rtadr <<= 1)
   {
    select_window(rtwin);
    wr_at(rtadr);
    select_window(bcwin);
    ctrl_code[bcnum][base] = CTRL_C_A;
    bcputw(0, (rtadr<<11) | ci_field | SYNC);
    if (test_start(TEST_AT))
    {
     if (err_msg == NULL)
      err_msg = "RT address test didn't pass";
     goto fin;
    }
   }
  }
  select_window(rtwin);
  wr_at(rtadr = 0x0A);
  avt_out = 0;
  if (!fSimpleRT)
  {
   for (subadr0 = subadr1; subadr0 <= subadr2; subadr0++)
   {
    rtdefsubaddr(RT_TRANSMIT, subadr0);
    rtputw(0, 0x0000);
   }
   for (dir = RT_RECEIVE; ; dir = RT_TRANSMIT)
   {
    for (subadr = subadr1; ;)
    {
     for (subadr0 = subadr1; subadr0 <= subadr2; subadr0++)
     {
      rtdefsubaddr(RT_RECEIVE, subadr0);
      rtputw(0, 0x0000);
     }
     rtlock(dir, subadr);
     fLock=1;
     out_subadr();
     fflush(stdout);
     if (rtbusy())
     {
      err_msg = "Subaddress access disable bit didn't reset";
      goto fin;
     }
     select_window(bcwin);
     for (dir0 = RT_RECEIVE; ; dir0 = RT_TRANSMIT)
     {
      ctrl_code[bcnum][base] = (dir0 == RT_TRANSMIT) ? DATA_RT_BC : DATA_BC_RT;
      for (subadr0 = subadr1; subadr0 <= subadr2; subadr0++)
      {
       bcputw(0, (rtadr<<11) | dir0 | (subadr0<<5) | 1);
       bcputw(1, 0xFFFF);
       bcputw(2, 0xFFFF);
       if (dir0 == dir && subadr0 == subadr)
       {
        if (test_start(TEST_BUSY1))
        {
         if (err_msg == NULL)
          err_msg = "'BC access to locked subaddress' RAM arbiter test didn't pass";
         goto fin;
        }
       }
       else
       {
        if (test_start(TEST_NOBUSY1))
        {
         if (err_msg == NULL)
          err_msg = "'BC access to unlocked subaddress' RAM arbiter test didn't pass";
         goto fin;
        }
       }
      }
      if (dir0 == RT_TRANSMIT) break;
     }
     select_window(rtwin);
     if (dir == RT_RECEIVE)
      if (rtgetw(0) != 0x0000)
      {
       err_msg = "'BC access to locked subaddress' RAM arbiter test didn't pass";
       goto fin;
      }
     rtunlock();
     fLock=0;
     select_window(bcwin);
     dir0 = dir; subadr0 = subadr;
     ctrl_code[bcnum][base] = (dir0 == RT_TRANSMIT) ? DATA_RT_BC : DATA_BC_RT;
     bcputw(0, (rtadr<<11) | dir0 | (subadr0<<5) | 1);
     bcputw(1, 0xFFFF);
     bcputw(2, 0xFFFF);
     if (test_start(TEST_NOBUSY1))
     {
      if (err_msg == NULL)
       err_msg = "'BC access to unlocked subaddress' RAM arbiter test didn't pass";
      goto fin;
     }
     select_window(rtwin);
     for (subadr0 = subadr1; subadr0 <= subadr2; subadr0++)
     {
      rtdefsubaddr(RT_RECEIVE, subadr0);
      if (rtgetw(0) != 0xFFFF)
      {
       err_msg = "'BC access to unlocked subaddress' RAM arbiter test didn't pass";
       goto fin;
      }
     }
     if (subadr == 0x18)
      break;
     if (subadr == 0x10)
      subadr = 0x11;
     else
      subadr = ((subadr & 0x0F) << 1) | (subadr & 0x10);
    }
    if (dir == RT_TRANSMIT) break;
   }
   if (test_rt_busy())
   {
      err_msg = "Subaddress access disable bit didn't set during BC access";
    goto fin;
   }
  }
  avt_out = 1;
  select_window(rtwin);
  rtdefsubaddr(dir=RT_TRANSMIT, subadr=0x10);
  for (k = 0; k <= 31; ++k)
   buffer[k] = k+1;
  rtputblk(0, buffer, 32);
  select_window(bcwin);
  ctrl_code[bcnum][base] = DATA_RT_BC;
  for (len = 1; len <= 32; len++)
  {
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5) | (len & 0x1F));
   if (test_start(TEST_COUNTER))
   {
    if (err_msg == NULL)
     err_msg = "Data counter test didn't pass";
    goto fin;
   }
  }
  select_window(rtwin);
  if (rtdefirqmode(RT_GENER1_BL|RT_GENER2_BL) == 0)
  {
   CheckTmkEvent(0);
   int_num[rtnum]=0;
   select_window(bcwin);
   ctrl_code[bcnum][base] = DATA_BC_RT;
   bcputw(0, (rtadr<<11) | RT_RECEIVE | (subadr<<5));
   if (test_start(TEST_RT_DATA_IRQ))
   {
    if (err_msg == NULL)
     err_msg = "RT data receiving interrupt test didn't pass";
    goto fin;
   }
   select_window(rtwin);
   rtdefirqmode(RT_GENER1_BL|RT_GENER2_BL|RT_DATA_BL);
   CheckTmkEvent(0);
   int_num[rtnum]=0;
   select_window(bcwin);
   if (test_start(TEST_RT_DATA_IRQ_BL))
   {
    if (err_msg == NULL)
     err_msg = "RT data receiving interrupt mask test didn't pass";
    goto fin;
   }
   select_window(rtwin);
   rtdefirqmode(RT_GENER1_BL|RT_GENER2_BL);
   CheckTmkEvent(0);
   int_num[rtnum]=0;
   select_window(bcwin);
   ctrl_code[bcnum][base] = DATA_RT_BC;
   bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5));
   if (test_start(TEST_RT_DATA_IRQ))
   {
    if (err_msg == NULL)
     err_msg = "RT data transmitting interrupt test didn't pass";
    goto fin;
   }
   select_window(rtwin);
   rtdefirqmode(RT_GENER1_BL|RT_GENER2_BL|RT_DATA_BL);
   CheckTmkEvent(0);
   int_num[rtnum]=0;
   select_window(bcwin);
   if (test_start(TEST_RT_DATA_IRQ_BL))
   {
    if (err_msg == NULL)
     err_msg = "RT data transmitting interrupt mask test didn't pass";
    goto fin;
   }
  }
  select_window(rtwin);
  rtdefsubaddr(dir=RT_TRANSMIT, subadr=0x10);
  make_test1(0);
  rtputblk(0, buffer, 32);
  select_window(bcwin);
  bcdefbase(base=3);
  ctrl_code[bcnum][base] = DATA_RT_RT_BRCST;
  bcputw(0, (0x1F<<11) | RT_RECEIVE | (subadr<<5));
  bcputw(1, (rtadr<<11) | RT_TRANSMIT | (subadr<<5));
  if (start_loop_n(GL_COUNTER))
  {
   err_msg = "Broadcast RT->RT message test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtgetblk(0, buffer, 32);
  select_window(bcwin);
  if (cmp_ram_buf(0, 3, 32))
  {
   err_msg = "Test array in RT->RT message transmitted with errors";
   goto fin;
  }
  CheckTmkEvent(0);
  int_num[rtnum] = 0;
  select_window(rtwin);

//  rtdefirqmode(RT_DATA_BL); //!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

  wr_at(rtadr);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x10, 0, 0xAAAA)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x12, 2, 0x0000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x14, 4, 0x5555)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x16, 6, 0xFFFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x18, 8, 0x8000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x1A, 10, 0x7FFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(12, 0x10, 0xAAAA)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(14, 0x12, 0x0000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(16, 0x14, 0x5555)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(18, 0x16, 0xFFFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(20, 0x18, 0x8000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(22, 0x1A, 0x7FFF)) goto bad_statistic;
  if (channel_err > 0L)
   goto bad_statistic;
  select_window(bcwin);
  if (fReserv && (times == nBusSwapTime || times == 1))
  {
   unsigned nTempBus;
   bcdefbus(nReservBus);
   nTempBus = nMainBus;
   nMainBus = nReservBus;
   nReservBus = nTempBus;
   bus_num = nMainBus;
   out_number();
   fflush(stdout);
  }
 }
 while (--times);
#ifdef ELCUS
 if (fBcRt && *str)
 {
  if (randbcrt(bcnum, rtnum, fReserv, hb_mode))
  {
   err_msg = "Randbcrt test didn't pass";
   goto fin;
  }
 }
#endif //def ELCUS
 avt_ok = 1;
 err_msg = "Remote Terminal test completed";
 goto fin;
 bad_statistic:
 err_msg = "'Statistics' test didn't pass";
 fin:
 if (prtscr_flag)
 {
  prtscr_flag = 0;
  err_msg = "Test aborted on F12";
 }
 select_window(nmainwin=rtwin);
 check_int();
 all_screen();
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(bcwin);
 statistic_out("");
 select_window(nmainwin=rtwin);
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 avt_err = !avt_ok;
}

int statistic_bc_rt(short st_base, short st_subadr, unsigned short st_data)
{
 long cnt;
 unsigned time1;
 long ltime1;
 int k;
 int st_bcsubadr=st_subadr;
 int buf_base=0, buf_subadr=0;

 select_window(bcwin);
 gotoxy(1, 11);
 textcolor(CYAN);
 puts("Statistics accumulation. Press F12 to abort...");
// fflush(stdout);
 textcolor(LIGHTGRAY);
 base = st_base;
 out_base();
 ctrl_code[bcnum][st_base] = DATA_BC_RT;
 ctrl_code[bcnum][st_base^1] = DATA_BC_RT;
 out_ctrl_code();
 for (k = 1; k <= 32; ++k)
  buffer[k] = st_data;
 for (k = 0; k <= 32; ++k)
 {
  bcbuffer[0][k]=(st_base<<8)+k;
  bcbuffer[1][k]=((st_base^1)<<8)+k;
  if (k >= 32)
   continue;
  rtbuffer[0][k]=(st_subadr<<8)+k;
  rtbuffer[1][k]=((st_subadr^1)<<8)+k;
 }
 bcdefbase(st_base);
 buffer[0] = (rtadr)<<11 | RT_RECEIVE | (st_bcsubadr<<5);
 bcputblk(0, buffer, 33);
 out_buffer();
 fflush(stdout);
 for (cnt = 0; cnt <= GL_COUNTER; ++cnt)
 {
  bioskey_f12();
  if (prtscr_flag)
   cnt = GL_COUNTER;
  if (cnt < GL_COUNTER)
  {
   tmkselect(bcnum);
   CheckTmkEvent(0);
   int_num[bcnum] = 0;
   bcstart(st_base, DATA_BC_RT);
   ltime1 = biostime(0, 0L);
  }
  st_base ^= 1;
  buf_base ^= 1;
  st_subadr ^= 1;
  buf_subadr ^= 1;
  if (cnt < GL_COUNTER)
  {
   bcdefbase(st_base);
   buffer[0] = (rtadr)<<11 | RT_RECEIVE | (st_subadr<<5);
   bcputblk(0, bcbuffer[buf_base], 33);
   bcputblk(0, buffer, 33);
  }
//  else
//   --good_starts;
  if (cnt > 0)
  {
   tmkselect(rtnum);
   rtdefsubaddr(RT_RECEIVE, st_subadr);
   rtgetblk(0, vbuffer, 32);
   rtputblk(0, rtbuffer[buf_subadr], 32);
   for (k = 0; k <= 31; ++k)
   {
    if (vbuffer[k] != st_data)
    {
#ifdef LPT_SYN
     if (fLPTSyn)
     {
      set_lpt_data(0xFF);
      set_lpt_data(0);
     }
#endif
     if (channel_err<(unsigned long)ERRLEN)
     {
      at_bad_mode[(unsigned)channel_err] = DATA_BC_RT;
      at_bad_base[(unsigned)channel_err] = st_base ^ 1;
      at_bad_sa[(unsigned)channel_err] = st_subadr;
      at_bad_num[(unsigned)channel_err] = k;
      at_bad_good[(unsigned)channel_err] = st_data;
      at_bad_bad[(unsigned)channel_err] = vbuffer[k];
     }
     ++channel_err;
     if (fStatErrStop)
      cnt = GL_COUNTER;
    }
   }
   if (cnt == 1)
   {
    select_window(rtwin);
    out_subadr();
    out_buffer();
    select_window(bcwin);
    fflush(stdout);
   }
//   st_subadr ^= 1;
  }
  CheckTmkEvent(0);
  while (biostime(0, 0L) - ltime1 < 10)
  {
   CheckTmkEvent(0);
   if (int_num[bcnum])
    break;
  }  
  if (!int_num[bcnum] && cnt < GL_COUNTER)
   ++to_errors;
 }
 gotoxy(1, 11);
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  for(k = 76; k != 0; k--)
   putchar(0xCD);
 }
 else
 {
  for(k = 76; k != 0; k--)
   putchar(0xC4);
 } 
 fflush(stdout);
 textcolor(LIGHTGRAY);
 statistic_out("");
 return (bad_starts > 0 || int_num[rtnum] || prtscr_flag || (dwMaxErr && channel_err>=dwMaxErr));
}

int statistic_rt_bc(short st_subadr, short st_base, unsigned short st_data)
{
 long cnt;
 unsigned time1;
 long ltime1;
 int k;
 int buf_base=0, buf_subadr=0;

 select_window(rtwin);
 for (k = 0; k <= 31; ++k)
  vbuffer[k] = st_data;
 for (k = 0; k <= 33; ++k)
 {
  bcbuffer[0][k]=(st_base<<8)+k;
  bcbuffer[1][k]=((st_base^1)<<8)+k;
  if (k >= 32)
   continue;
  rtbuffer[0][k]=(st_subadr<<8)+k;
  rtbuffer[1][k]=((st_subadr^1)<<8)+k;
 }
 dir = RT_TRANSMIT;
 subadr = st_subadr;
 out_subadr();
 rtdefsubaddr(RT_TRANSMIT, st_subadr);
 rtputblk(0, vbuffer, 32);
 out_buffer();
 select_window(bcwin);
 gotoxy(1, 11);
 textcolor(CYAN);
 puts("Statistics accumulation. Press F12 to abort...");
// fflush(stdout);
 textcolor(LIGHTGRAY);
 base = st_base;
 out_base();
 ctrl_code[bcnum][st_base] = DATA_RT_BC;
 ctrl_code[bcnum][st_base^1] = DATA_RT_BC;
 out_ctrl_code();
 fflush(stdout);
 bcdefbase(st_base);
 bcputw(0, (rtadr)<<11 | RT_TRANSMIT | (st_subadr<<5));
 bcbuffer[0][0]=(rtadr)<<11 | RT_TRANSMIT | (st_subadr<<5);
 bcbuffer[1][0]=(rtadr)<<11 | RT_TRANSMIT | ((st_subadr ^ 1)<<5);
 for (cnt = 0; cnt <= GL_COUNTER; ++cnt)
 {
  bioskey_f12();
  if (prtscr_flag)
   cnt = GL_COUNTER;
  if (cnt < GL_COUNTER)
  {
   CheckTmkEvent(0);
   int_num[bcnum] = 0;
   bcstart(st_base, DATA_RT_BC);
   ltime1 = biostime(0, 0L);
  }
//  else
//   --good_starts;
  st_base ^= 1;
  buf_base ^= 1;
  bcdefbase(st_base);
  if (cnt > 0)
  {
   bcgetblk(2, buffer, 32);
   if (cnt == 1)
    out_buffer();
   fflush(stdout); 
  }
  bcputblk(0, bcbuffer[buf_base], 34);
  tmkselect(rtnum);
  st_subadr ^= 1;
  buf_subadr ^= 1;
  rtdefsubaddr(RT_TRANSMIT, st_subadr);
  rtputblk(0, rtbuffer[buf_subadr], 32);
  rtputblk(0, vbuffer, 32);
  tmkselect(bcnum);
  if (cnt > 0)
  {
   for (k = 0; k <= 31; ++k)
   {
    if (buffer[k] != st_data)
    {
#ifdef LPT_SYN
     if (fLPTSyn)
     {
      set_lpt_data(0xFF);
      set_lpt_data(0);
     }
#endif
     if (channel_err<(unsigned long)ERRLEN)
     {
      at_bad_mode[(unsigned)channel_err] = DATA_RT_BC;
      at_bad_base[(unsigned)channel_err] = st_base;
      at_bad_sa[(unsigned)channel_err] = st_subadr;
      at_bad_num[(unsigned)channel_err] = k;
      at_bad_good[(unsigned)channel_err] = st_data;
      at_bad_bad[(unsigned)channel_err] = buffer[k];
     }
     ++channel_err;
     if (fStatErrStop)
      cnt = GL_COUNTER;
    }
   }
  }
  CheckTmkEvent(0);
  while (biostime(0, 0L) - ltime1 < 10)
  {
   CheckTmkEvent(0);
   if (int_num[bcnum])
    break;
  }
  if (!int_num[bcnum] && cnt < GL_COUNTER)
   ++to_errors;
 }
 gotoxy(1, 11);
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  for(k = 76; k != 0; k--)
   putchar(0xCD);
 }
 else
 {
  for(k = 76; k != 0; k--)
   putchar(0xC4);
 } 
 textcolor(LIGHTGRAY);
 fflush(stdout);
 statistic_out("");
 return (bad_starts > 0 || int_num[rtnum] || prtscr_flag || (dwMaxErr && channel_err>=dwMaxErr));
}

void avt_stat(char *str)
{
 int counter, i, k, err;
 unsigned long times, nBusSwapTime;

 while (*str == '\t' || *str == ' ') str++;
 if (*str)
 {
  if (sscanf(str, "%u", &times) != 1)
  {
   msg_out(inp_err);
   return;
  }
 }
 else
  times=1;
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 avt_ctrl("1");
 avt_ok = 0;
 select_window(bcwin);
 if (fReserv)
 {
  nReservBus = ((nMainBus=bcgetbus()) == BUS_A) ? BUS_B : BUS_A;
  bus_num = nMainBus;
  out_number();
  nBusSwapTime = times+1;
  times <<= 1;
 }
 select_window(rtwin);
 wr_at(rtadr=0x0A); out_at();
 set_status_word("0");
 comment("'Statistics' automatic test.");
 select_window(bcwin);
 statistic_clear("");
 if (hb_mode)
 {
  subadr1 = 0x10;
  subadr2 = 0x1E;
  ci_field = 0x1F<<5;
 }
 else
 {
  subadr1 = 0x01;
  subadr2 = 0x1E;
  ci_field = 0;
 }
 do
 {
  select_window(rtwin);
  rtdefirqmode(rtgetirqmode()|TMK_IRQ_OFF); //iii
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x10, 0, 0xAAAA)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x12, 2, 0x0000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x14, 4, 0x5555)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x16, 6, 0xFFFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x18, 8, 0x8000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_rt_bc(0x1A, 10, 0x7FFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(12, 0x10, 0xAAAA)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(14, 0x12, 0x0000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(16, 0x14, 0x5555)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(18, 0x16, 0xFFFF)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(20, 0x18, 0x8000)) goto bad_statistic;
  select_window(rtwin);
  rt_fill_test();
  select_window(bcwin);
  bc_fill_test();
  if (statistic_bc_rt(22, 0x1A, 0x7FFF)) goto bad_statistic;
  if (channel_err > 0L)
   goto bad_statistic;
  select_window(bcwin);
  if (fReserv && (times == nBusSwapTime || times == 1))
  {
   unsigned nTempBus;
   bcdefbus(nReservBus);
   nTempBus = nMainBus;
   nMainBus = nReservBus;
   nReservBus = nTempBus;
   bus_num = nMainBus;
   out_number();
   fflush(stdout);
  }
 }
 while (--times);
 avt_ok = 1;
 err_msg = "'Statistics' test completed";
 goto fin;
 bad_statistic:
 err_msg = "'Statistics' test didn't pass";
 fin:
 if (prtscr_flag)
 {
  prtscr_flag = 0;
  err_msg = "Test aborted on F12";
 }
 check_int();
 select_window(nmainwin=bcwin);
 all_screen();
 select_window(rtwin);
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(nmainwin=bcwin);
 statistic_out("");
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 avt_err = !avt_ok;
}

void avt_flags(char *str)
{
 int maxpage, k, err, page;
 unsigned tsubadr;

 if (end_ctrl(str)) return;
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 statistic_clear("");
 avt_ctrl("1");
 avt_ok = 0;
 select_window(rtwin);
 rtreset();
// rt_clear_ram();
 wr_at(rtadr=0x0A); out_at();
 set_status_word("0");
 comment("Remote Terminal flag mode automatic test.");
 rtdefmode(rtgetmode()|RT_FLAG_MODE);
 rtdefpage(page=0);
 if (hb_mode)
 {
  subadr1 = 0x10;
  subadr2 = 0x1E;
  ci_field = CI_MASK;
 }
 else
 {
  subadr1 = 0x01;
  subadr2 = 0x1E;
  ci_field = 0;
 }
 for (subadr = subadr1; subadr <= subadr2; subadr++)
 {
  rtdefsubaddr(RT_TRANSMIT, subadr);
  buffer[0] = (page<<14) | (subadr<<8) | (page<<6) | subadr | 0x2020;
  rtputblk(0, buffer, 1);
  rtsetflag();
 }
 select_window(bcwin);
 bcreset();
 bc_clear_ram();
 bcdefbase(base=0);
 ctrl_code[bcnum][base] = DATA_RT_BC;
 for (subadr = subadr1; subadr <= subadr2; subadr++)
 {
  bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5) | 1);
  start_1("");
  if (int_num[bcnum] != 1)
  {
   err_msg = "RT->BC:Transmitting from subaddress with set flag didn't pass";
   goto fin;
  }
  select_window(rtwin);
  for (tsubadr = subadr1; tsubadr < subadr; tsubadr++)
  {
   if ((rtgetflag(RT_TRANSMIT, tsubadr)&RT_FLAG) != 0)
   {
    err_msg = "RT->BC:Earlier transmitted subaddress flag set";
    goto fin;
   }
  }
  if ((rtgetflag(RT_TRANSMIT, subadr)&RT_FLAG) != 0)
  {
   err_msg = "RT->BC:Transmitted subaddress flag didn't reset";
   goto fin;
  }
  for (tsubadr = subadr+1; tsubadr < subadr2; tsubadr++)
  {
   if ((rtgetflag(RT_TRANSMIT, tsubadr)&RT_FLAG) == 0)
   {
    err_msg = "RT->BC:Not yet transmitted subaddress flag reset";
    goto fin;
   }
  }
  select_window(bcwin);
 }
 bcdefbase(base=0);
 ctrl_code[bcnum][base] = DATA_RT_BC;
 for(subadr = subadr1; subadr <= subadr2; subadr++)
 {
  bcputw(0, (rtadr<<11) | RT_TRANSMIT | (subadr<<5) | 1);
  start_1("");
  if (int_num[bcnum] != 2 || bc_sw != (S_TO_MASK|S_IB_MASK))
  {
   err_msg = "RT->BC:Transmitting from subaddress with reset flag test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  for (tsubadr = subadr1; tsubadr <= subadr2; tsubadr++)
  {
   if ((rtgetflag(RT_TRANSMIT, tsubadr)&RT_FLAG) != 0)
   {
    err_msg = "RT->BC:Earlier transmitted subaddress flag set";
    goto fin;
   }
  }
  select_window(bcwin);
 }
 select_window(rtwin);
 rt_clear_ram();
 for (subadr = subadr1; subadr <= subadr2; subadr++)
 {
  rtdefsubaddr(RT_RECEIVE, subadr);
  rtclrflag();
 }
 select_window(bcwin);
 bcdefbase(base=1);
 ctrl_code[bcnum][base] = DATA_BC_RT;
 for (subadr = subadr1; subadr <= subadr2; subadr++)
 {
  buffer[0] = (rtadr<<11) | RT_RECEIVE | (subadr<<5) | 1;
  buffer[1] = (page<<14) | (subadr<<8) | (page<<6) | subadr;
  bcputblk(0, buffer, 2);
  start_1("");
  if (int_num[bcnum] != 1)
  {
   err_msg = "BC->RT:Receiving to subaddress with reset flag didn't pass";
   goto fin;
  }
  select_window(rtwin);
  for (tsubadr = subadr1; tsubadr < subadr; tsubadr++)
  {
   if ((rtgetflag(RT_RECEIVE, tsubadr)&RT_FLAG) == 0)
   {
    err_msg = "BC->RT:Earlier received subaddress flag reset";
    goto fin;
   }
  }
  if ((rtgetflag(RT_RECEIVE, subadr)&RT_FLAG) == 0)
  {
   err_msg = "BC->RT:Received subaddress flag didn't set";
   goto fin;
  }
  if (rtgetw(0) != ((page<<14) | (subadr<<8) | (page<<6) | subadr))
  {
   err_msg = "BC->RT:Data in Rx subaddress didn't change";
   goto fin;
  }
  for (tsubadr = subadr+1; tsubadr < subadr2; tsubadr++)
  {
   if ((rtgetflag(RT_RECEIVE, tsubadr)&RT_FLAG) != 0)
   {
    err_msg = "BC->RT:Not yet received subaddress flag set";
    goto fin;
   }
  }
  select_window(bcwin);
 }
 ctrl_code[bcnum][base] = DATA_BC_RT;
 for (subadr = subadr1; subadr <= subadr2; subadr++)
 {
  buffer[0] = (rtadr<<11) | RT_RECEIVE | (subadr<<5) | 1;
  buffer[1] = 0xFFFF;
  bcputblk(0, buffer, 2);
  start_1("");
  if (int_num[bcnum] != 2 || bc_sw != S_IB_MASK)
  {
   err_msg = "BC->RT:Receiving to subaddress with set flag test didn't pass";
   goto fin;
  }
  select_window(rtwin);
  rtdefsubaddr(RT_RECEIVE, subadr);
  if (rtgetw(0) == 0xFFFF)
  {
   err_msg = "BC->RT:Data were written in Rx subaddress with set flag";
   goto fin;
  }
  for (tsubadr = subadr1; tsubadr <= subadr2; tsubadr++)
  {
   if ((rtgetflag(RT_RECEIVE, tsubadr)&RT_FLAG) == 0)
   {
    err_msg = "BC->RT:Earlier received subaddress flag reset";
    goto fin;
   }
  }
  select_window(bcwin);
 }
 avt_ok = 1;
 err_msg = "Remote Terminal flag mode test completed";
 fin:
 select_window(rtwin);
 rtdefmode(rtgetmode()&(~RT_FLAG_MODE));
 check_int();
 all_screen();
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(bcwin);
 statistic_out("");
 select_window(nmainwin=rtwin);
 avt_ctrl("0");
 avt_err = !avt_ok;
}

#ifdef ELCUS
void avt_va996(char *str)
{
 int i, err;
 long ltime1, lmaxtime;
 unsigned minutes;

// if (end_ctrl(str)) return;
 while (*str == '\t' || *str == ' ') str++;
 if (*str)
 {
  if (sscanf(str, "%u", &minutes) != 1)
  {
   msg_out(inp_err);
   return;
  }
 }
 else
  minutes=1;
 lmaxtime = 182L*6L*(long)minutes;
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 avt_ctrl("1");
 avt_ok = 0;
 select_window(rtwin);
 wr_at(rtadr=0x0A); out_at();
 set_status_word("0");
 select_window(rtwin);
 comment("Transceiver automatic test.");
 select_window(bcwin);
 statistic_clear("");
 if (hb_mode)
 {
  subadr1 = 0x10;
  subadr2 = 0x1E;
  ci_field = 0x1F<<5;
 }
 else
 {
  subadr1 = 0x01;
  subadr2 = 0x1E;
  ci_field = 0;
 }
 set_base("0"); buf_fill("1, 32, AAAA");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5));
 set_base("1"); buf_fill("1, 32, 0000");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5));
 set_base("2"); buf_fill("1, 32, 5555");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5));
 set_base("3"); buf_fill("1, 32, FFFF");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5));
 set_base("4"); buf_fill("1, 32, 8000");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5));
 set_base("5"); buf_fill("1, 32, 7FFF");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5));
 ltime1=biostime(0, 0L);
 prtscr_flag = 0;
 while ((biostime(0, 0L)-ltime1)<lmaxtime && !prtscr_flag && bad_starts<100L)
 {
  for (i=0;i<GL_COUNTER && !prtscr_flag;)
  {
   for (base=0; base<=5; base++)
   {
   	CheckTmkEvent(0);
    int_num[bcnum] = 0;
    bcstart(base, ctrl_code[tmkselected()][base]);
    while (!int_num[bcnum] && !prtscr_flag)
    {
      CheckTmkEvent(0);
      bioskey_f12();
    }
    i++;
   }
   bioskey_f12();
  }
  statistic_out("");
 }
 set_base("0");
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 if (bad_starts>=100L)
 {
  err_msg = "Transceiver test didn't pass";
 }
 else if (prtscr_flag)
 {
  err_msg = "Test aborted on F12";
 }
 else
 {
  avt_ok = 1;
  err_msg = "Transceiver test completed";
 }
 check_int();
 select_window(bcwin);
 all_screen();
 select_window(rtwin);
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(nmainwin=bcwin);
 statistic_out("");
 avt_ctrl("0");
 avt_err = !avt_ok;
}

void avt_arb_rt_r(char *str)
{
 int i, errs;
 long starts = 0;
 int mode = 0;

 if (end_ctrl(str))
 {
  while (*str == '\t' || *str == ' ') str++;
  if (sscanf(str, "%d", &mode) != 1)
  {
   msg_out(mark_err); return;
  }
 }
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 avt_ctrl("1");
 avt_ok = 0;
 select_window(rtwin);
 wr_at(rtadr=0x0A); out_at();
 set_status_word("0");
 select_window(rtwin);
 set_subadr_r("10");
 comment("RT arbiter automatic test (reading).");
 select_window(bcwin);
 statistic_clear("");
 if (hb_mode)
 {
  subadr1 = 0x10;
  subadr2 = 0x1E;
  ci_field = 0x1F<<5;
 }
 else
 {
  subadr1 = 0x01;
  subadr2 = 0x1E;
  ci_field = 0;
 }
 set_base("1"); buf_fill("1, 32, FFFF");
 ctrl_code[tmkselected()][base] = DATA_BC_RT;
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x11<<5) | (nATWords & 0x1F));
 CheckTmkEvent(0);
 int_num[bcnum] = 0;
 tmkselect(rtnum);
 for (i=0; i<32; i++)
  buffer[i] = (i+1)+((i+1)<<8);
 rtdefsubaddr(RT_RECEIVE, 0x10);
 rtputblk(0, buffer, 32);
 tmkselect(bcnum);
 prtscr_flag = 0;
 while (!prtscr_flag && (dwMaxErr == 0L || bad_starts < dwMaxErr))
 {
  CheckTmkEvent(0);
  int_num[bcnum] = 0;
  bcstart(1, ctrl_code[tmkselected()][1]);
  tmkselect(rtnum);
  CheckTmkEvent(0);
  while (!int_num[bcnum] && !prtscr_flag)
  {
   if (fATArBlk)
    rtgetblk(0, vbuffer, nATWords);
   for (i=0; i<nATWords; i++)
   {
    if (!fATArBlk)
     vbuffer[i] = rtgetw(i);
    if (vbuffer[i] != buffer[i] && !mode)
    {
     if (channel_err<(unsigned long)ERRLEN)
     {
      at_bad_mode[(unsigned)channel_err] = DATA_BC_RT;
      at_bad_base[(unsigned)channel_err] = 1;
      at_bad_sa[(unsigned)channel_err] = 0x10;
      at_bad_num[(unsigned)channel_err] = i;
      at_bad_good[(unsigned)channel_err] = buffer[i];
      at_bad_bad[(unsigned)channel_err] = vbuffer[i];
     }
     channel_err++;
#ifdef LPT_SYN
     if (fLPTSyn)
     {
      set_lpt_data(0xFF);
      set_lpt_data(0);
     }
#endif
    }
   }
   bioskey_f12();
   CheckTmkEvent(0);
  }
  tmkselect(bcnum);
  if (!fLPTSyn && ((++starts)%100==0))
   statistic_out("");
  bioskey_f12();
 }
 set_base("1");
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 if (bad_starts>0L || channel_err>0L)
 {
  err_msg = "RT arbiter test didn't pass";
 }
 else if (prtscr_flag)
 {
  err_msg = "Test aborted on F12";
 }
 else
 {
  avt_ok = 1;
  err_msg = "RT arbiter test completed";
 }
 check_int();
 select_window(bcwin);
 all_screen();
 select_window(rtwin);
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(nmainwin=bcwin);
 statistic_out("");
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 avt_err = !avt_ok;
}

void avt_arb_rt_w(char *str)
{
 int i, errs;
 long starts = 0;
 int mode = 0;
 unsigned subadrmax;
 unsigned wLastCWBase;

 if (end_ctrl(str))
 {
  while (*str == '\t' || *str == ' ') str++;
  if (sscanf(str, "%d", &mode) != 1)
  {
   msg_out(mark_err); return;
  }
 }
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 avt_ctrl("1");
 avt_ok = 0;
 select_window(rtwin);
 wr_at(rtadr=0x0A); out_at();
 set_status_word("0");
 select_window(rtwin);
 set_subadr_r("10");
 comment("RT arbiter automatic test (writing).");
 select_window(bcwin);
 statistic_clear("");
 subadr1 = 0x10;
 subadrmax = subadr2 = 0x1E;
 ci_field = 0x1F<<5;
 set_base("1"); buf_fill("1, 32, FFFF");
 ctrl_code[bcnum][base] = DATA_BC_RT; 
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x10<<5) | (nATWords & 0x1F));
 wLastCWBase = 2;
 CheckTmkEvent(0);
 int_num[bcnum] = 0;
 for (i=0; i<32; i++)
 {
  buffer[i] = (i+1)+((i+1)<<8);
  vbuffer[i] = 0;
 }
 prtscr_flag = 0;
 while (!prtscr_flag && (dwMaxErr == 0L || bad_starts < dwMaxErr))
 {
  tmkselect(rtnum);
  for (subadr=subadr1; subadr<=subadrmax; subadr++)
  {
   rtdefsubaddr(RT_TRANSMIT, subadr);
   rtputblk(0, vbuffer, 32);
  }
  tmkselect(bcnum);
  CheckTmkEvent(0);
  int_num[bcnum] = 0;
  bcstart(1, ctrl_code[bcnum][1]);
  tmkselect(rtnum);
  subadr=subadr1;
  CheckTmkEvent(0);
  while (!int_num[bcnum] && subadr<=subadr2)
  {
   rtdefsubaddr(RT_TRANSMIT, subadr);
   rtputblk(0, buffer, 32);
   subadrmax=subadr;
   subadr++;
   CheckTmkEvent(0);
  }
  if (int_num[bcnum] == 2)
  {
    tmkselect(bcnum);
    if (wLastCWBase < tmkMaxBase[tmkselected()])
    {
      bcdefbase(wLastCWBase);
      bcputw(0, CWM(rtadr, CMD_TRANSMIT_LAST_COMMAND_WORD));
      bcputw(1, 0xFFFF);
      bcputw(2, 0xFFFF);
      int_num[bcnum] = 0;
      bcstart(wLastCWBase, CTRL_C_AD);
      while (!int_num[bcnum])CheckTmkEvent(0);
      ++wLastCWBase;
      bcdefbase(wLastCWBase);
      bcputw(0, CWM(rtadr, CMD_TRANSMIT_STATUS_WORD));
      bcputw(1, 0xFFFF);
      int_num[bcnum] = 0;
      bcstart(wLastCWBase, CTRL_C_A);
      while (!int_num[bcnum])CheckTmkEvent(0);
      ++wLastCWBase;
    }
    tmkselect(rtnum);
  }
  for (subadr=subadr1; subadr<=subadrmax; subadr++)
  {
   rtdefsubaddr(RT_TRANSMIT, subadr);
   rtgetblk(0, buffer+32, nATWords);
   for (i=0; i<nATWords; i++)
   {
    if (buffer[i+32] != buffer[i] && !mode)
    {
     if (channel_err<(unsigned long)ERRLEN)
     {
      at_bad_mode[(unsigned)channel_err] = DATA_BC_RT;
      at_bad_base[(unsigned)channel_err] = 1;
      at_bad_sa[(unsigned)channel_err] = subadr|RT_TRANSMIT;
      at_bad_num[(unsigned)channel_err] = i;
      at_bad_good[(unsigned)channel_err] = buffer[i];
      at_bad_bad[(unsigned)channel_err] = buffer[i+32];
     }
     channel_err++;
#ifdef LPT_SYN
     if (fLPTSyn)
     {
      set_lpt_data(0xFF);
      set_lpt_data(0);
     }
#endif
    }
   }
  }
  tmkselect(bcnum);
  if (!fLPTSyn && ((++starts)%100==0))
   statistic_out("");
  bioskey_f12(); 
 }
 set_base("1");
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 if (bad_starts>0L || channel_err>0L)
 {
  err_msg = "RT arbiter test didn't pass";
 }
 else if (prtscr_flag)
 {
  err_msg = "Test aborted on F12";
 }
 else
 {
  avt_ok = 1;
  err_msg = "RT arbiter test completed";
 }
 check_int();
 select_window(bcwin);
 all_screen();
 select_window(rtwin);
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(nmainwin=bcwin);
 statistic_out("");
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 avt_err = !avt_ok;
}

void avt_arb_rt_f(char *str)
{
 int i, errs;
 long starts = 0;
 int mode = 0;
 unsigned subadrmax;

 if (end_ctrl(str))
 {
  while (*str == '\t' || *str == ' ') str++;
  if (sscanf(str, "%d", &mode) != 1)
  {
   msg_out(mark_err); return;
  }
 }
 if (Window[0].nMode == BC_MODE)
  bcwin = 0;
 else if (Window[1].nMode == BC_MODE)
  bcwin = 1;
 else
 {
  msg_out("BC not defined");
  return;
 }
 if (Window[0].nMode == RT_MODE)
  rtwin = 0;
 else if (Window[1].nMode == RT_MODE)
  rtwin = 1;
 else
 {
  msg_out("RT not defined");
  return;
 }
 bcnum = Window[bcwin].nTMK;
 rtnum = Window[rtwin].nTMK;
 avt_ctrl("1");
 avt_ok = 0;
 select_window(rtwin);
 wr_at(rtadr=0x0A); out_at();
 set_status_word("0");
 select_window(rtwin);
 set_subadr_r("10");
 comment("RT arbiter automatic test (writing/reading).");
 select_window(bcwin);
 statistic_clear("");
 subadr1 = 0x10;
 subadrmax = subadr2 = 0x1E;
 ci_field = 0x1F<<5;
 set_base("1"); buf_fill("1, 32, FFFF");
 ctrl_code[bcnum][base] = DATA_BC_RT; 
 bcputw(0, (rtadr<<11) | RT_RECEIVE | (0x10<<5) | (nATWords & 0x1F));
 int_num[bcnum] = 0;
 for (i=0; i<32; i++)
 {
  buffer[i] = (i+1)+((i+1)<<8);
  vbuffer[i] = 0;
 }
 prtscr_flag = 0;
 while (!prtscr_flag && (dwMaxErr == 0L || bad_starts < dwMaxErr))
 {
  tmkselect(rtnum);
  for (subadr=subadr1; subadr<=subadrmax; subadr++)
  {
   rtdefsubaddr(RT_TRANSMIT, subadr);
   rtputblk(0, vbuffer, 32);
  }
  tmkselect(bcnum);
  CheckTmkEvent(0);
  int_num[bcnum] = 0;
  bcstart(1, ctrl_code[bcnum][1]);
  tmkselect(rtnum);
  subadr=subadr1;
  CheckTmkEvent(0);
  while (!int_num[bcnum] && subadr<=subadr2)
  {
   rtdefsubaddr(RT_TRANSMIT, subadr);
   for (i=0; i<32; i++)
   {
    rtputw(i, buffer[i]);
    if (rtgetw(i) != buffer[i] && !mode)
    {
     if (channel_err<(unsigned long)ERRLEN)
     {
      at_bad_mode[(unsigned)channel_err] = DATA_BC_RT;
      at_bad_base[(unsigned)channel_err] = 1;
      at_bad_sa[(unsigned)channel_err] = subadr|RT_TRANSMIT;
      at_bad_num[(unsigned)channel_err] = i;
      at_bad_good[(unsigned)channel_err] = buffer[i];
      at_bad_bad[(unsigned)channel_err] = buffer[i+32];
     }
     channel_err++;
#ifdef LPT_SYN
     if (fLPTSyn)
     {
      set_lpt_data(0xFF);
      set_lpt_data(0);
     }
#endif
    }
   }
   subadrmax=subadr;
   subadr++;
   CheckTmkEvent(0);
  }
  tmkselect(bcnum);
  if (!fLPTSyn && ((++starts)%100==0))
   statistic_out("");
  bioskey_f12(); 
 }
 set_base("1");
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 if (bad_starts>0L || channel_err>0L)
 {
  err_msg = "RT arbiter test didn't pass";
 }
 else if (prtscr_flag)
 {
  err_msg = "Test aborted on F12";
 }
 else
 {
  avt_ok = 1;
  err_msg = "RT arbiter test completed";
 }
 check_int();
 select_window(bcwin);
 all_screen();
 select_window(rtwin);
 beep1();
 if (avt_ok)
  textcolor(GREEN);
 else
  textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 select_window(nmainwin=bcwin);
 statistic_out("");
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 avt_err = !avt_ok;
}

void avt_ou400(char *str)
{
 int k, fLen32;
 long starts = 0, startnum;
 unsigned nWords, rtaddr = 10;
 unsigned waitaw, setaw;
 unsigned savebus;

 if (end_ctrl(str))
 {
  while (*str == '\t' || *str == ' ') str++;
  if (sscanf(str, "%ld", &starts) != 1)
  {
   msg_out(mark_err); return;
  }
 }
 avt_ok = 0;
 bcnum = tmkselected();
 savebus = bcgetbus();
 startnum = 0;
 prtscr_flag = 0;
 bcdefbase(base = 0);
 ctrl_code[bcnum][base] = CTRL_CD_A;
 bcputw(0, 0x53F1);
 bcputw(1, 0x0010);
 start_1("");
 statistic_clear("");
 start_1("");
 if (bad_starts > 0L || to_errors > 0L)
   goto ret;
 avt_ctrl("1");
 statistic_clear("");
 fLen32 = 1;
 do
 {
   if (fReserv)
     bcdefbus(rand() & BUS_B);
   bcdefbase(base = 0);
   ctrl_code[bcnum][base] = CTRL_CD_A;
   bcputw(0, 0x53F1);
   setaw = rand() & 0xF;
   bcputw(1, setaw);
   start();
   waitaw = 0x5000;
   if (setaw & 1)
     waitaw |= RTFL_MASK;
   if (setaw & 2)
     waitaw |= SSFL_MASK;
   if (setaw & 4)
     waitaw |= BUSY_MASK;
   if (setaw & 8)
     waitaw |= SREQ_MASK;
   bcdefbase(base = 1);
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, 0x57E8);
   start();
   if (waitaw != 0x5000)
   {
   	 if (int_num[bcnum] == 2 && bc_sw == S_IB_MASK && bc_aw1 == waitaw)
     {
       --bad_starts;
       ++good_starts;
     }
     else
     {
       if (int_num[bcnum] != 2)
       {
         ++bad_starts;
         --good_starts;
       }
     }
   }
   bcdefbase(base = 2);
   ctrl_code[bcnum][base] = CTRL_CD_A;
   bcputw(0, 0x53F1);
   bcputw(1, 0x0010);
   start();
   if (int_num[bcnum] == 2 && bc_sw == S_IB_MASK && bc_aw1 == waitaw)
   {
     --bad_starts;
     ++good_starts;
   }
   if (bad_starts > 0L)
     break;

   bcdefbase(base = 3);
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, 0x53E1); //illegal
   start();
   if (int_num[bcnum] == 2 && bc_sw == S_IB_MASK && bc_aw1 == 0x5400)
   {
     --bad_starts;
     ++good_starts;
   }
   else
   {
     if (int_num[bcnum] != 2)
     {
       ++bad_starts;
       --good_starts;
     }
     break;
   }

   bcdefbase(base = 4);
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, 0x57E2); //tos
   start();
   if (int_num[bcnum] == 2 && bc_sw == S_IB_MASK && bc_aw1 == 0x5400)
   {
     --bad_starts;
     ++good_starts;
   }
   else
   {
     if (int_num[bcnum] != 2)
     {
       ++bad_starts;
       --good_starts;
     }
     break;
   }

   bcdefbase(base = 5);
   ctrl_code[bcnum][base] = CTRL_C_AD;
   bcputw(0, 0x57F2); //tlc
   start();
   if (int_num[bcnum] == 2 && bc_sw == S_IB_MASK && bc_aw1 == 0x5400 && bcgetw(2) == 0x57E2)
   {
     --bad_starts;
     ++good_starts;
   }
   else
   {
     if (int_num[bcnum] != 2)
     {
       ++bad_starts;
       --good_starts;
     }
     break;
   }

   bcdefbase(base = 6);
   ctrl_code[bcnum][base] = CTRL_CD_A;
   bcputw(0, 0xFBF1); //syn d
   bcputw(1, 0x0010);
   start();
   if (int_num[bcnum] == 2 && bc_sw == S_TO_MASK)
   {
     --bad_starts;
     ++good_starts;
   }
   else
   {
     if (int_num[bcnum] != 2)
     {
       ++bad_starts;
       --good_starts;
     }
     break;
   }

   bcdefbase(base = 7);
   ctrl_code[bcnum][base] = CTRL_C_A;
   bcputw(0, 0x57E2); //tos
   start();
   if (int_num[bcnum] == 2 && bc_sw == S_IB_MASK && bc_aw1 == 0x5010)
   {
     --bad_starts;
     ++good_starts;
   }
   else
   {
     if (int_num[bcnum] != 2)
     {
       ++bad_starts;
       --good_starts;
     }
     break;
   }

   for (base = 0; base < 0xF; ++base)
   {
     if (fLen32)
       nWords = 32;
     else
       nWords = (rand() & 31) + 1;
     buffer[0] = CW(rtaddr, RT_RECEIVE, 0x10 + base, nWords);
     for (k = 1; k <= 32; ++k)
       buffer[k] = rand() + rand();
     bcdefbase(base);
     bcputblk(0, buffer, nWords + 1);
     while (int_num[bcnum] == 0)CheckTmkEvent(0);
     int_num[bcnum] = 0;
     bcstart(base, DATA_BC_RT);
   }
   while (int_num[bcnum] == 0)CheckTmkEvent(0);
   for (base = 0x10; base < 0x1F; ++ base)
   {
     bcdefbase(base - 0x10);
     bcgetblk(0, vbuffer, 33);
     if ((nWords = (vbuffer[0] & 31)) == 0)
       nWords = 32;
     bcdefbase(base);
     bcputw(0, CW(rtaddr, RT_TRANSMIT, base, nWords));
     int_num[bcnum] = 0;
     bcstart(base, DATA_RT_BC);
     while (int_num[bcnum] == 0)CheckTmkEvent(0);
     bcgetblk(2, buffer, nWords);
     for (k = 0; k < nWords; ++k)
     {
       if (buffer[k] != vbuffer[k+1])
       {
#ifdef LPT_SYN
         if (fLPTSyn)
         {
          set_lpt_data(0xFF);
          set_lpt_data(0);
         }
#endif
         if (channel_err<(unsigned long)ERRLEN)
         {
          at_bad_mode[(unsigned)channel_err] = DATA_RT_BC;
          at_bad_base[(unsigned)channel_err] = base;
          at_bad_sa[(unsigned)channel_err] = base;
          at_bad_num[(unsigned)channel_err] = k;
          at_bad_good[(unsigned)channel_err] = vbuffer[k+1];
          at_bad_bad[(unsigned)channel_err] = buffer[k];
         }
         ++channel_err;
       }
     }
   }
   fLen32 = !fLen32;
   ++startnum;
   if (startnum%10 == 0)
   {
     statistic_out("");
     bcdefbase(base = 0);
     ctrl_code[bcnum][base] = CTRL_CD_A;
     bcputw(0, 0x53F1);
     bcputw(1, 0x0010);
     start();
     ctrl_code[bcnum][base] = DATA_BC_RT;
     bcputw(0, 0x5222);
     bcputw(1, 0x0F5A);
     bcputw(1, 0xF0A5);
     start();
   }
   CheckTmkEvent(0);
   bioskey_f12();
   if (prtscr_flag || bad_starts > 0L || channel_err > 0L)
     break;
 }
 while (!starts || startnum < starts);
//? ctrl_code[bcnum][base] = DATA_RT_BC;

 ret:

 if (fReserv)
   bcdefbus(savebus);
 out_base();
 out_ctrl_code();
 bc_out_ram(base);

 if (bad_starts > 0L || to_errors > 0L || channel_err > 0L)
 {
   err_msg = "RT test didn't pass";
 }
 else
 {
   avt_ok = 1;
   err_msg = "RT test completed";
 }
 check_int();
/*
 all_screen();
*/
 beep1();
 if (channel_err > 0L)
  statistic_err_out();
 avt_ctrl("0");
 if (avt_ok)
   textcolor(GREEN);
 else
   textcolor(LIGHTRED);
 comment(err_msg);
 textcolor(LIGHTGRAY);
 statistic_out("");
 avt_err = !avt_ok;
}
#endif //def ELCUS

int cmp_ram_buf(int offset, int voffset, int size)
{
 int i;

 if (voffset >= 0)
 {
  switch (tmkgetmode())
  {
  case BC_MODE:
   bcgetblk(0, vbuffer, size+voffset);
   break;
  case RT_MODE:
   rtgetblk(0, vbuffer, size+voffset);
  }
 }
 else
  voffset = 0;
 for (i=0; i < size; i++)
  if (buffer[i+offset]!=vbuffer[i+voffset]) return 1;
 return 0;
}

void avt_ctrl(char *str)
{
 unsigned a;

 if (sscanf(str, "%u", &a)!=1)
 {
  msg_out(inp_err);
  return;
 }
 if (a!=0 && a!=1)
 {
  msg_out("Wrong variable value");
  return;
 }
 avtomat=a;
}

#ifdef LPT
void init_lpt()
{
 unsigned char *bios_mem;

 bios_mem = mmap(0, 256, PROT_READ, MAP_SHARED | MAP_PHYS, NOFD, 0x400);
 if(bios_mem != MAP_FAILED)
 {
   lpt_data_port = *((unsigned short *)(bios_mem + 8));
   munmap(bios_mem, 256);
 }
 else
  lpt_data_port = 0x378;//default
// lpt_data_port=peek(0x0040, 8+(lpt_num-1)*2);
 lpt_status_port=lpt_data_port+1;
 lpt_ctrl_port=lpt_data_port+2;
}

void set_lpt_data(unsigned char data)
{
 outportb(lpt_data_port, data);
}
#endif

void buf_fill(char *str)
{
 unsigned start, end, len, constant, i;

 while (*str == '\t' || *str == ' ') str++;
 if (sscanf(str, "%u", &start) != 1)
 {
  msg_out(mark_err); return;
 }
 if (start > buf_size-1)
 {
  msg_out(mark_err); return;
 }
 while (*str != ' ' && *str != ',') str++;
 while (*str == ' ' || *str == ',') str++;
 if (sscanf(str, "%u", &end) != 1)
 {
  msg_out(mark_err); return;
 }
 if (end < start || end > buf_size-1)
 {
  msg_out(mark_err); return;
 }
 while (*str != ' ' && *str != ',') str++;
 while (*str == ' ' || *str == ',') str++;
 if (sscanf(str, "%x", &constant) != 1)
 {
  msg_out(const_err); return;
 }
 len = end - start + 1;
 for (i = start; i <= end; i++)
  buffer[i]=constant;
 out_buffer();
 fflush(stdout);
 switch (Window[nwin].nMode)
 {
 case BC_MODE:
  bcdefbase(base);
  bcputblk(start, buffer+start, len);
  break;
 case RT_MODE:
  rtdefsubaddr(dir, subadr);
  rtputblk(start, buffer+start, len);
 }
}

void buf_clear(char *str)
{
 int i;

 if (end_ctrl(str)) return;
 for (i=64; i-- != 0; buffer[i]=0);
 buf_mark=0;
 in_ed_word=3;
 out_buffer();
 fflush(stdout);
 switch(Window[nwin].nMode)
 {
 case BC_MODE:
  bcdefbase(base);
  bcputblk(0, buffer, 64);
  break;
 case RT_MODE:
  rtdefsubaddr(dir, subadr);
  rtputblk(0, buffer, 32);
 }
}

int end_ctrl(char *str)
{
 while (*str == '\t' || *str == ' ') str++;
 if (*str)
 {
  msg_out(undef_cmd);
  return 1;
 }
 else
  return 0;
}

void clear_dump()
{
 int y, maxy;

 maxy = (avtomat) ? BDUMP_Y + 3 : BDUMP_Y + 4;
 for (y = BDUMP_Y - 1; y <= maxy; y++)
 {
  gotoxy(1, y);
  clreol();
 }
}

void buf_edit(char *str)
{
 static int in_word=3;  
 static int edit_mode=0;
 static int bit_num=15; 
 unsigned key, tetrada, bit;
 int tmkmode;
 char ch;

 switch (tmkmode = Window[nwin].nMode)
 {
 case BC_MODE:
  bc_out_ram(base);
  break;
 case RT_MODE:
  rt_out_ram(dir, subadr);
 }
 fflush(stdout);
 while (*str == '\t' || *str == ' ') str++;
 if (!mark_set(str, &buf_mark))
 {
  do
  {
   if (edit_mode)
   {
    bin_unpack(62, BDUMP_Y, buf_mark, buffer[buf_mark]);
    gotoxy(BDUMP_X-1+5*(buf_mark%DUMP_WIDE+1)-3, BDUMP_Y+buf_mark/DUMP_WIDE);
    cprintf("%04X", buffer[buf_mark]);
    gotoxy(61+(16-bit_num), BDUMP_Y+1);
   }
   else
   {
    bin_unpack(62, BDUMP_Y, buf_mark, buffer[buf_mark]);
    gotoxy(BDUMP_X-1+5*(buf_mark%DUMP_WIDE+1)-in_word, BDUMP_Y+buf_mark/DUMP_WIDE);
   }
   key=bioskey(0);
   if ((key & 0x00FF) && key != GPLUSW)
   {
    switch (key = toupper(key&0x00FF))
    {
    case 'Q':
    case ESCAPE:
                   key='Q';
                   break;
    case TAB:
                   if (edit_mode)
                   {
                    edit_mode=0;
                    in_word=bit_num/4;
                   }
                   else
                   {
                    edit_mode=1;
                    bit_num=in_word*4+3;
                   }
                   break;
    case CR:
                   edit_mode=0;
                   if (buf_mark != DUMP_SIZE-1)
                    ++buf_mark;
                   else
                    buf_mark=0;
                   break;
                  case ' ':
                   if (edit_mode) break;
                   if (in_word == 0)
                   {
                    if (buf_mark != DUMP_SIZE-1)
                    {
                     in_word=3;
                     buf_mark++;
                    }
                   }
                   else
                    in_word--;
                   break;
    case BACKSPACE:
                   if (edit_mode) break;
                   if (in_word == 3)
                   {
                    if (buf_mark != 0)
                    {
                     in_word=0;
                     buf_mark--;
                    }
                   }
                   else
                    in_word++;
                   break;
    default:
                   if (edit_mode)
                   {
                    if (key != '0' && key != '1') break;
                    bit=key-'0';
                    buffer[buf_mark]&=~(0x0001<<bit_num);
                    buffer[buf_mark]|=(bit<<bit_num);
                    if (bit_num != 0) bit_num--;
                    break;
                   }
                   if (key >= '0' && key <= '9')
                    tetrada=key-'0';
                   else if (key >= 'A' && key <= 'F')
                    tetrada=key-'A'+10;
                   else if (key >= 'a' && key <= 'f')
                    tetrada=key-'a'+10;
                   else
                    break;
                   putchar(key);
                   buffer[buf_mark]&=~(0x000F<<in_word*4);
                   buffer[buf_mark]|=(tetrada<<in_word*4);
                   if (in_word == 0)
                   {
                    if (buf_mark != DUMP_SIZE-1)
                    {
                     in_word=3;
                     buf_mark++;
                    }
                   }
                   else
                    in_word--;
                   break;
                  }
   }
   else
   {
    switch (key>>8)
    {
    case F01:
               clear_dump();

               gotoxy(1, BDUMP_Y);
               printf("   UP        SPACE - tetrada right, BACKSPACE - tetrada left, ");
               gotoxy(1, BDUMP_Y+1);
               printf("LEFT RIGHT - go to words, HOME - buffer begin, END - buffer end, ");
               gotoxy(1, BDUMP_Y+2);
               printf("  DOWN       TAB - HEX/BIN mode, Q(F10) - finish editing.");
               gotoxy(1, BDUMP_Y+3);
               switch (tmkmode)
               {
               case BC_MODE:
                printf("        PGUP, PGDN - change base.");
                break;
               case RT_MODE:
                printf("        PGUP, PGDN - change subaddress, GRAY PLUS - Tx/Rx.");
               }
               fflush(stdout);
               //while (!kbhit());
               bioskey(0);
               clear_dump();
               out_buffer();
               fflush(stdout);
               break;
    case LEFT:
               if (edit_mode)
               {
                if (bit_num != 15)
                 bit_num++;
                break;
               }
               if (buf_mark != 0) --buf_mark;
               else buf_mark=DUMP_SIZE-1;
               in_word = 3;
               break;
    case RIGHT:
               if (edit_mode)
               {
                if (bit_num != 0) bit_num--;
                break;
               }
               if (buf_mark != DUMP_SIZE-1) ++buf_mark;
               else buf_mark=0;
               in_word = 3;
               break;
    case UP:
               if (edit_mode)
               {
                if (buf_mark != 0) --buf_mark;
                else buf_mark=DUMP_SIZE-1;
                break;
               }
               if (buf_mark-DUMP_WIDE >= 0) buf_mark-=DUMP_WIDE;
               else
               {
                buf_mark+=(DUMP_WIDE*(DUMP_STRINGS-1));
                if (buf_mark > DUMP_SIZE-1) buf_mark-=DUMP_WIDE;
               }
               in_word = 3;
               break;
    case DOWN:
               if (edit_mode)
               {
                if (buf_mark != DUMP_SIZE-1) ++buf_mark;
                else buf_mark=0;
                break;
               }
               if (buf_mark+DUMP_WIDE <= DUMP_SIZE-1) buf_mark+=DUMP_WIDE;
               else
               {
                buf_mark-=(DUMP_WIDE*(DUMP_STRINGS-1));
                if (buf_mark < 0) buf_mark+=DUMP_WIDE;
               }
               in_word = 3;
               break;
    case HOME:
               if (edit_mode)
               {
                bit_num=15;
                break;
               }
               buf_mark=0;
               in_word = 3;
               break;
    case END:
               if (edit_mode)
               {
                bit_num=0;
                break;
               }
               buf_mark=DUMP_SIZE-1;
               in_word = 3;
               break;
    case GPLUS:
               if (tmkmode == RT_MODE)
               {
                rtputblk(0, buffer, 32);
                dir = (dir == RT_TRANSMIT) ? RT_RECEIVE : RT_TRANSMIT;
                rtdefsubaddr(dir, subadr);
                rtgetblk(0, buffer, 32);
                out_subadr();
                out_buffer();
                fflush(stdout);
               }
               break;
    case PGUP:
               switch (tmkmode)
               {
               case BC_MODE:
                if (base > 0)
                {
                 bcputblk(0, buffer, 36);
                 bcdefbase(--base);
                 bcgetblk(0, buffer, 36);
                 out_base();
                 out_ctrl_code();
                 out_buffer();
                 fflush(stdout);
                }
                break;
               case RT_MODE:
                if (subadr > 0)
                {
                 rtputblk(0, buffer, 32);
                 rtdefsubaddr(dir, --subadr);
                 rtgetblk(0, buffer, 32);
                 out_subadr();
                 out_buffer();
                 fflush(stdout);
                }
               }
               in_word = 3;
               break;
    case PGDN:
               switch (tmkmode)
               {
               case BC_MODE:
                if (base < tmkMaxBase[tmkselected()])
                {
                 bcputblk(0, buffer, 36);
                 bcdefbase(++base);
                 bcgetblk(0, buffer, 36);
                 out_base();
                 out_ctrl_code();
                 out_buffer();
                 fflush(stdout);
                }
                break;
               case RT_MODE:
                if (subadr < 31)
                {
                 rtputblk(0, buffer, 32);
                 rtdefsubaddr(dir, ++subadr);
                 rtgetblk(0, buffer, 32);
                 out_subadr();
                 out_buffer();
                 fflush(stdout);
                }
               }
               in_word = 3;
               break;
    case F10:
               key='Q';
               break;
    }
    continue;
   }
  }
  while (key != 'Q');
 }
 switch (tmkmode)
 {
 case BC_MODE:
  bcputblk(0, buffer, 36);
  break;
 case RT_MODE:
  rtputblk(0, buffer, 32);
 }
}

int mark_set(char *str, int *mark)
{
 unsigned i, constant;

 if (*str == '\0') return 0;
 if ((sscanf(str, "%u", &i)) != 1)
 {
  msg_out(inp_err);
  return 1;
 }
 if (i > DUMP_SIZE-1)
 {
  msg_out(mark_err);
  return 1;
 }
 *mark=i;
 while (*str != ' ' && *str != ',' && *str != '\0') str++;
 if (!*str) return 0;
 while (*str == ' ' || *str == ',') str++;
 if (sscanf(str, "%x", &constant) != 1) { msg_out(const_err); return 1; }
 buffer[*(mark)]=constant;
 out_buffer();
 fflush(stdout);
 return 1;
}

void out_func_str()
{
 int i;

 static char *bc_func_str[10]={  " Help ",  /* F01 */
                                 "  RAM ",  /* F02 */
                                 "Set RT",  /* F03 */
                                 "Window",  /* F04 */
                                 " LoopF",  /* F05 */
                                 " Start",  /* F06 */
                                 " Loop ",  /* F07 */
                                 " Reset",  /* F08 */
                                 "Fields",  /* F09 */
                                 "Exit"    /* F10 */
                              };
 static char *rt_func_str[10]={  " Help ",  /* F01 */
                                 "  RAM ",  /* F02 */
                                 "Set BC",  /* F03 */
                                 "Window",  /* F04 */
                                 "      ",  /* F05 */
                                 "  RSW ",  /* F06 */
                                 "  RM  ",  /* F07 */
                                 " Reset",  /* F08 */
                                 "Fields",  /* F09 */
                                 "Exit"    /* F10 */
                              };

 gotoxy(1, 25);
 for (i=1; i <= 10; i++)
 {
  cprintf("%u", i);
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  switch (Window[nwin].nMode)
  {
  case BC_MODE: cprintf("%s", bc_func_str[i-1]);
                break;
  case RT_MODE: cprintf("%s", rt_func_str[i-1]);
                break;
  }
  textbackground(BLACK);
  textcolor(LIGHTGRAY);
  putchar(' ');
 }
// fflush(stdout);
}

void hor_line(int maxi)
{
 register i;
 for (i = 1; i <= maxi; i++)
  putchar(chH);
 //fflush(stdout); 
}

void all_screen()
{
 int savenwin, nDX, nDY, i;

 savenwin = nwin;
 clrscr_all();
 window(1, 1, 80, 25);
 out_func_str();
 for (nwin = 0; nwin <= nMaxWin; nwin++)
 {
  if (!Window[nwin].fVisible)
   continue;
  select_window(nwin);
  if (nwin == savenwin)
  {
   textcolor(WHITE);
   chLU = 0xC9;
   chRU = 0xBB;
   chLD = 0xC8;
   chRD = 0xBC;
   chV = 0xBA;
   chH = 0xCD;
  }
  else
  {
   textcolor(LIGHTGRAY);
   chLU = 0xDA;
   chRU = 0xBF;
   chLD = 0xC0;
   chRD = 0xD9;
   chV = 0xB3;
   chH = 0xC4;
  }
  nDX = Window[nwin].nDX;
  nDY = Window[nwin].nDY;
  window(Window[nwin].nX, Window[nwin].nY, 
          Window[nwin].nX + nDX - 1, 
          Window[nwin].nY + nDY - 1);
  gotoxy(1, 1);
  putchar(chLU);
  hor_line(nDX - 2);
  putchar(chRU);
  for (i = 2; i < nDY; i++)
  {
   gotoxy(1, i);
   putchar(chV);
   gotoxy(nDX, i);
   putchar(chV);
  }
  gotoxy(1, nDY);
  putchar(chLD);
  hor_line(nDX - 2);
  putchar(chRD);
  window(Window[nwin].nX + 1, Window[nwin].nY, 
          Window[nwin].nX + nDX - 2, 
          Window[nwin].nY + nDY - 1);
  textcolor(LIGHTGRAY);
  out_mode();
  out_type();
  out_fname();
  out_inn();
  switch(Window[nwin].nMode)
  {
  case BC_MODE:
   out_maxerrs();
   out_count();
   out_glcount();
   out_number();
   out_base();
   out_ctrl_code();
   out_pause();
   bc_out_sw();
   bc_out_ram(base);
   break;
  case RT_MODE:
   out_subadr();
   out_at();
   out_page();
   out_rt_mode();
   out_status_word();
   rt_out_sw();
   rt_out_ram(dir, subadr);
   break;
  }
 }
 nwin = savenwin;
 select_window(nwin);
 window(Window[nwin].nX + 1, Window[nwin].nY, 
         Window[nwin].nX + Window[nwin].nDX - 2, 
         Window[nwin].nY + Window[nwin].nDY - 1);
 fflush(stdout);//!!!!
}

void bc_out_ram(int base)
{
 bcdefbase(base);
 bcgetblk(0, buffer, 36);
 out_buffer();
}

void rt_out_ram(int dir, int subadr)
{
 if (fLock)
   rtlock(dir, subadr);
 else
   rtdefsubaddr(dir, subadr);
 rtgetblk(0, buffer, 32);
 out_buffer();
}

void out_buffer()
{
 gotoxy(1, BDUMP_Y-1);
 printf("     RAM");
 gotoxy(BDUMP_X, BDUMP_Y-1);
 out_dump(buffer);
 bin_unpack(62, BDUMP_Y, buf_mark, buffer[buf_mark]);
// fflush(stdout);
}

void bin_unpack(short x, short y, short adr, unsigned short data)
{
 gotoxy(x, y);
 cprintf("%02Xh:%02u: %04X", adr, adr, data);
 gotoxy(x, y+1);
 out_bin(data, 16);
 gotoxy(x, y+2);
 printf("FEDCBA9876543210");
// fflush(stdout);
}

void bc_out_sw()
{
 char *pszRes;
 gotoxy(2, 4);
 printf("   Result: ");
 CheckTmkEvent(0);
 if (int_num[Window[nwin].nTMK])
  out_bin(bc_sw, 7);
 else
 {
  bc_sw = 0;
  printf("XXXXXXX");
 }
 if (bc_sw & S_ERAO_MASK)
  pszRes = "RT address error           ";
 else if (bc_sw & S_MEO_MASK)
  pszRes = "Manchester code error      ";
 else if (bc_sw & S_TO_MASK)
  pszRes = "No Status word/Data word(s)";
 else if (bc_sw & S_EM_MASK)
  pszRes = "Internal device error      ";
 else if (bc_sw & S_EBC_MASK)
  pszRes = "Echocheck error            ";
 else if (bc_sw & S_ELN_MASK)
  pszRes = "Extra Data word(s)         ";
 else
  pszRes = "                           ";
 if (bc_sw & S_IB_MASK)
  cprintf(" Set bit.  %s |", pszRes);
 else
  cprintf(" %s           |", pszRes);
// fflush(stdout); 
}

void out_inn()
{
 CheckTmkEvent(0);	
 gotoxy(65, 4);
 printf(" Interrupt: ");
 if (int_num[Window[nwin].nTMK])
  cprintf("%u", int_num[Window[nwin].nTMK]);
 else
  putchar('X');
// fflush(stdout);
}

void out_maxerrs()
{
 gotoxy(64, 2);
 printf("MaxErr:");
 if (dwMaxErr == 0L)
  printf(" ------");
 else if (dwMaxErr <= 999999L)
  cprintf(" %6ld", dwMaxErr);
 else
  printf(">999999");
// fflush(stdout);
}

void out_mode()
{
 gotoxy(2, 1);
 if (nwin == nmainwin)
  textcolor(WHITE);
 else
  textcolor(LIGHTGRAY);
 cprintf("%d%c", Window[nwin].nTMK, chH);
 if (Window[nwin].nMode == BC_MODE)
  printf("BUS CONTROLLER");
 else if (Window[nwin].nMode == RT_MODE)
  printf("REMOTE TERMINAL");
 textcolor(LIGHTGRAY);
// fflush(stdout);
}

inline void out_port(unsigned wPort)
{
 if (wPort && ~wPort)
  cprintf("%03Xh%c", wPort, chH);
// fflush(stdout);
}

inline void out_irq(unsigned wIrq)
{
 if (wIrq && ~wIrq)
  cprintf("Irq %d%c", wIrq, chH);
// fflush(stdout);
}

/*inline void out_iodelay()
{
 cprintf("IOD%3d%c", tmkiodelay(GET_IO_DELAY), chH);
 fflush(stdout);
}*/

inline void out_hw_ver()
{
 cprintf("Ver %3u%c", tmkgethwver(), chH);
// fflush(stdout);
}

void out_type()
{
 int nTMK = Window[nwin].nTMK;
 gotoxy(22, 1);
 if (nwin == nmainwin)
  textcolor(WHITE);
 else
  textcolor(LIGHTGRAY);
 cprintf("%s%c", aTmkConfig[nTMK].szName, chH);
 out_port(aTmkConfig[nTMK].wPorts1);
 out_port(aTmkConfig[nTMK].wPorts2);
 out_irq(aTmkConfig[nTMK].wIrq1);
 out_irq(aTmkConfig[nTMK].wIrq2);
 if (aTmkConfig[nTMK].nType >= TMKX)
/*   out_iodelay();
 else*/
   out_hw_ver();
 textcolor(LIGHTGRAY);
// fflush(stdout);
}

void out_count()
{
 gotoxy(47, 2);
 if (cmd_count <= 9999L)
   cprintf("Cycle: %04lu |", cmd_count);
 else
   printf("Cycle:>9999 |");
// fflush(stdout);
}

void out_glcount()
{
 if (Window[nwin].nMode == BC_MODE)
 {
  gotoxy(41, 3);
  cprintf("L: %08lu |", GL_COUNTER);
//  fflush(stdout);
 }
}

void out_fname()
{
 char ch;
 gotoxy(61, 1);
 printf("File:");
 if (nwin == nmainwin)
 {
  ch = 0xCD;
  textcolor(WHITE);
  printf("%c%c%c%c%c%c%c%c%c%c%c%c%c", ch, ch, ch, ch, ch, ch, ch, ch, ch, ch, ch, ch, ch);
  textcolor(LIGHTGRAY);
 }
 else
 {
  ch = 0xC4;
  printf("%c%c%c%c%c%c%c%c%c%c%c%c%c", ch, ch, ch, ch, ch, ch, ch, ch, ch, ch, ch, ch, ch);
 } 
 if (*Window[nwin].data_fname != '\0')
 {
  gotoxy(66, 1);
  cprintf("%s", Window[nwin].data_fname);
 }
// fflush(stdout);
}

void out_pause()
{
 gotoxy(28, 2);
 cprintf("Pause: %5u us  |", opause);
// fflush(stdout);
}

void out_base()
{
 gotoxy(2, 2);
 cprintf("Base: %03X->%03X |", base, base_link[tmkselected()][base]);
// fflush(stdout);
}

void out_number()
{
 gotoxy(19, 2);
 cprintf("BUS: %1u |", bus_num+1);
// fflush(stdout);
}

void out_ctrl_code()
{
 char *pszFmt;
 unsigned ctrl_code2 = ctrl_code[tmkselected()][base];
 gotoxy(2, 3);
 printf("  Control Code: ");
 if (correct_cc(ctrl_code2))
  out_bin(ctrl_code2, CC_SIZE);
 else
  printf("XXXX");
 switch (ctrl_code2)
 {
 case 0x0: pszFmt = "(BC->RT)       ";
           break;
 case 0x1: pszFmt = "(RT->BC)       ";
           break;
 case 0x2: pszFmt = "(RT->RT)       ";
           break;
 case 0x3: pszFmt = "(CW - SW)      ";
           break;
 case 0x4: pszFmt = "(CW+DW - SW)   ";
           break;
 case 0x5: pszFmt = "(CW - SW+DW)   ";
           break;
 case 0x8: pszFmt = "(BC->all RTs)  ";
           break;
 case 0xA: pszFmt = "(RT->all RTs)  ";
           break;
 case 0xB: pszFmt = "(CW,all RTs)   ";
           break;
 case 0xC: pszFmt = "(CW+DW,all RTs)";
           break;
 default:  pszFmt = "(Not defined)  ";
           break;
 }
 cprintf(" %s |", pszFmt);
// fflush(stdout);
}

int correct_cc(unsigned short ctrl_code)
{
 ctrl_code &= 0x000F; 
 return ccs[ctrl_code];
}

void out_page()
{
 gotoxy(54, 3);
 cprintf("   Page  Bus:%2u  PC:%2u", rtgetpagebus(), rtgetpagepc());
// fflush(stdout);
}

void out_rt_mode()
{
 gotoxy(52, 2);
 printf(" Mode: ");
 if (rtgetmode() & RT_FLAG_MODE && tmkError == 0)
  printf("FLAG ");
 else
  printf("     ");
 if (hb_mode)
  printf("HBIT ");
 else
  printf("     ");
 if ((rtgetmode() & RT_BRCST_MODE) && tmkError == 0)
  printf("BCST ");
 else
  printf("     ");
 if ((rtgetirqmode() & RT_DATA_BL) && tmkError == 0)
  printf("DTBL");
 else
  printf("    ");
// fflush(stdout);
}

void out_at()
{
 int at;
 gotoxy(29, 2);
 if ((at = rtgetaddress()) != -1)
// if (Window[nwin].at_avail)
  terminal_adr = at;
#ifndef LPT_AT
 else
 {
  printf("RT Address: UNKNOWN  |");
  return;
 }
#endif
 cprintf("RT Addr.: %02u (", terminal_adr);
 out_bin(terminal_adr, 5);
 printf(") |");
// fflush(stdout);
}

void rt_out_sw()
{
 gotoxy(2, 4);
 printf("     State word: ");
 out_bin(rt_sw, 16);
 printf(" |");
// fflush(stdout);
}

void rt_out_sp()
{
 gotoxy(35, 4);
 cprintf("%04X", rt_sp);
// fflush(stdout);
}

void out_subadr()
{
 gotoxy(2, 2);
 printf("Subaddr.: ");
 if (dir == RT_TRANSMIT)
  cprintf("%02X (Transm.)  |", subadr);
 else
  cprintf("%02X (Recv.)    |", subadr);
// fflush(stdout);
}

void out_status_word()
{
  unsigned status_word;

  status_word = rtgetanswbits();
  gotoxy(2, 3);
  printf(" Status: ");
  out_bin(status_word, SW_SIZE);
  if (status_word&DNBA)
   printf(" (DN ");
  else
   printf(" (-- ");
  if (status_word&RTFL)
   printf("TF ");
  else
   printf("-- ");
  if (status_word&SSFL)
   printf("SF ");
  else
   printf("-- ");
  if (status_word&BUSY)
   printf("BS ");
  else
   printf("-- ");
  if (status_word&SREQ)
   printf("SR) |");
  else
   printf("--) |");
}

void out_dump(unsigned short *data)
{
 int i;     
 int offset;
 int dump_y;
 

 gotoxy(BDUMP_X, BDUMP_Y - 1);
 for (i=0; i != DUMP_WIDE; cprintf("  %01X  ", i++));
 dump_y = BDUMP_Y; 
 for (offset=0; offset != DUMP_SIZE;)
 {
  gotoxy(1, dump_y);
  cprintf("     %02u: ", offset);
  for (i=0; (i != DUMP_WIDE) && (offset != DUMP_SIZE); i++, offset++)
   cprintf(" %04X", *(data+offset));
  dump_y++; 
 }
 //fflush(stdout);
}

void out_bin(unsigned short data, short num_digits)
{
 char string[16];
 int mask;
 int count;

 for (count=0, mask=1; count != 16; count++, mask<<= 1)
  string[count]=(data&mask)?'1':'0';
 if (fields && num_digits == 16)
 {
  count=num_digits;
  textcolor(CYAN);
  for (; count != 11; putchar(string[--count]));
  textcolor(LIGHTRED);
  putchar(string[--count]);
  textcolor(YELLOW);
  for (; count != 5; putchar(string[--count]));
  textcolor(GREEN);
  for (; count != 0; putchar(string[--count]));
  textcolor(LIGHTGRAY);
 }
 else
  for (count=num_digits; --count >= 0; putchar(string[count]));
}

void exe_open(char *str)
{
  char *pszArg, *psz1;
  char *argv[10];
  int iarg;
  int nExeResult;

  while (*str==' ' || *str=='\t') str++;
  if (*str=='\0')
  {
    msg_out(format_err);
    return;
  }
  iarg = 0;
  do
  {
    while (*str==' ' || *str=='\t') str++;
    if (*str!='\0')
    {
      argv[iarg] = (char *)malloc(32 * sizeof(char));
      psz1 = argv[iarg];
      while (*str!=' ' && *str!='\t' && *str!='\0')
       *psz1++ = *str++;
      *psz1 = '\0';
      ++iarg;
    }
  }
  while (*str!='\0');
  clrscr_all();
/*  if (strstr(argv[0], ".BAT") != NULL || strstr(argv[0], ".bat") != NULL)
  {
    int i;
    argv[iarg++] = new char[32];
    argv[iarg++] = new char[32];
    for (i = iarg-3; i>=0; --i)
      strcpy(argv[i+2], argv[i]);
    strcpy(argv[1], "/C");
    strcpy(argv[0], "command.com");
    argv[iarg] = NULL;
    nExeResult = spawnvp(P_WAIT, argv[0], argv);
  }
  else*/
  {
    argv[iarg] = NULL;
    nExeResult = spawnv(P_WAIT, argv[0], argv);
  }
  do
    free(argv[--iarg]);
  while (iarg>0);
  all_screen();
  if (nExeResult < 0)
  {
    msg_out(open_err);
    return;
  }
}

void cmds_open(char *str)
{
 while (*str == ' ' || *str == '\t') str++;
 if (enter_mode)
 {
  fclose(cmd_file);
  enter_mode=0;
 }
 if ((cmd_file=fopen(str, "rt")) == NULL)
 {
  msg_out(open_err);
  return;
 }
 strcpy(ex_fname, str);
 enter_mode=1;
}

void cmds_open_f(char *str)
{
 register i;
 while (*str == ' ' || *str == '\t') str++;
 if (strchr(str, '.'))
 {
   msg_out(inp_err);
   return;
 }
 prtscr_flag = 0;
 gotoxy(2, 11);
 textcolor(CYAN);
 printf("Waiting for command file. Press F12 to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 fCmds_f = 0;
 strcat(str, ".f");
 while ((access(str, 0)) != 0 && !prtscr_flag)bioskey_f12();
 if (!prtscr_flag)
 {  
   *strchr(str, '.') = '\0';
   cmds_open(str);
   fCmds_f = 1;
 }
 gotoxy(2, 11);
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  for(i = 76; i != 0; i--)
    putchar(0xCD);
 }
 else
 {
  for(i = 76; i != 0; i--)
    putchar(0xC4);
 }
 textcolor(LIGHTGRAY);
 fflush(stdout);
}

void cmds_close_f(char *str)
{
 register i;
 prtscr_flag = 0;
 gotoxy(2, 11);
 textcolor(CYAN);
 printf("Waiting for command file end. Press F12 to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 strcat(str, ".ff");
 if ((cmd_file=fopen(str, "wt")) == NULL)
 {
  msg_out(open_err);
  return;
 }
 fclose(cmd_file);
 *(strchr(str, '.') + 2) = '\0';
// strcat(str, ".f");
 while ((access(str, 0)) == 0 && !prtscr_flag)bioskey_f12();
// if (!prtscr_flag)
 {
   strcat(str, "f");
   unlink(str);
   *strchr(str, '.') = '\0';
 }
 gotoxy(2, 11);
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  for(i = 76; i != 0; i--)
    putchar(0xCD);
 }
 else
 {
  for(i = 76; i != 0; i--)
    putchar(0xC4);
 }
 textcolor(LIGHTGRAY);
 fflush(stdout);
}

void bc_fill_test()
{
 int base, savebase, maxbase, i;

 savebase=bcgetbase();
 maxbase=tmkMaxBase[tmkselected()];
 for (base=0; base<=maxbase; base++)
 {
  bcdefbase(base);
  for (i=0; i<=63; i++)
   bcputw(i, (base<<8)+i);
 }
 bcdefbase(savebase);
}

void rt_fill_test()
{
 int page, subadr, dir, savepage, savesubadr, maxpage, i;

 savepage=rtgetpage();
 savesubadr=rtgetsubaddr();
 maxpage=rtgetmaxpage();
 for (page=0; page<=maxpage; page++)
 {
  rtdefpage(page);
  for (subadr=0; subadr<=31; subadr++)
  {
   rtdefsubaddr(RT_RECEIVE, subadr);
   for (i=0; i<=31; i++)
    rtputw(i, (page<<11)+RT_RECEIVE+(subadr<<5)+i);
   rtdefsubaddr(RT_TRANSMIT, subadr);
   for (i=0; i<=31; i++)
    rtputw(i, (page<<11)+RT_TRANSMIT+(subadr<<5)+i);
  }
 }
 rtdefpage(savepage);
 rtdefsubaddr(savesubadr, savesubadr);
}

void bc_buf_rd(char *str)
{
 int ch;
 char *ptr;
 int ch_count;

 int ctrl_code2, offset;
 static unsigned buffer2[BC_BUF_SIZE];

 while (*str == ' ' || *str == '\t') str++;
 if ((in_file=fopen(str, "rt")) == NULL)
 {
  msg_out(open_err);
  return;
 }
 while (*str != '\0') str++;
 str--;
 for (; *str != ':' && *str != '\\' && *str != ' ' && *str != '\t'; str--);
 str++;
 strcpy(Window[nwin].data_fname, str);
 out_fname();
 fflush(stdout);
 fgets(buf_str, 80, in_file);
                             
 fgets(buf_str, 80, in_file);
 if ((fgets(buf_str, 80, in_file)) == NULL)
 {
  msg_out(format_err);
  return;
 }
 str=buf_str;
 while (*str == '\t' || *str == ' ') str++;
 ptr=str;
 while ((ch=*(ptr++)) != ' ')
 {
  if (ch != '0' && ch != '1')
  {
   msg_out(bad_ctrl_code);
   return;
  }
 }
 --ptr;
 if (ptr-str > CC_SIZE)
 {
  msg_out(bad_ctrl_code);
  return;
 }
 ptr=str;
 for (ctrl_code2=0; *ptr != ' '; ptr++)
 {
  ctrl_code2<<= 1;
  if (*ptr == '1') ctrl_code2++;
 }
 if (!correct_cc(ctrl_code2))
 {
  sprintf(cc_no_def, "Wrong control code");
  msg_out(cc_no_def);
  return;
 }

 fgets(buf_str, 80, in_file);
 offset=0;
 while (offset != BC_DUMP_SIZE)
 {
  if (fscanf(in_file, "%x ", &buffer2[offset]) != 1)
  {
   msg_out(format_err);
   return;
  }
  if ((++offset%DUMP_WIDE) == 0)
   while ((ch=fgetc(in_file)) != '\n')
    if (ch == EOF)
    {
     msg_out(format_err);
     return;
    }
 }
 ctrl_code[tmkselected()][base]=ctrl_code2;
 out_ctrl_code();
 for (offset=0; offset != BC_DUMP_SIZE; offset++)
  buffer[offset]=buffer2[offset];
 bcputblk(0, buffer, 36);
 out_buffer();
 fflush(stdout);
 fclose(in_file);
}

void bc_buf_wr(char *str)
{

 int i, offset;
 unsigned ctrl_code2 = ctrl_code[tmkselected()][base];

 while (*str == ' ' || *str == '\t') str++;
 if ((out_file=fopen(str, "wt")) == NULL)
 {
  msg_out(cr_err);
  return;
 }
 strcpy(Window[nwin].data_fname, str);
 out_fname();
 fflush(stdout);
 {
  int mask;
  int count;
  char ch;
  fprintf(out_file, "\n");
  fprintf(out_file, "Control Code:\n");
  if (correct_cc(ctrl_code2))
   for (count=0, mask=8; count != 4; count++, mask>>= 1)
    fprintf(out_file, "%c", ((ctrl_code2&mask)?'1':'0'));
  else
  {
   fprintf(out_file, "XXXX (Not defined)\n");
   goto out_data;
  }
  switch (ctrl_code2 & 0x0007)
  {
  case 0x0: fprintf(out_file, " (BC->RT");
            break;
  case 0x1: fprintf(out_file, " (RT->BC");
            break;
  case 0x2: fprintf(out_file, " (RT->RT");
            break;
  case 0x3: fprintf(out_file, " (CW->SW");
            break;
  case 0x4: fprintf(out_file, " (CW+DW->SW");
            break;
  case 0x5: fprintf(out_file, " (CW->SW+DW");
            break;
  }
  if (ctrl_code2 & 0x0008)
   fprintf(out_file, ", broadcast)\n");
   else fprintf(out_file, ")\n");
 }
 out_data:;
 fprintf(out_file, "Buffer:\n");
 for (offset=0; offset < BC_DUMP_SIZE;)
  {
    for (i=0; i < DUMP_WIDE; i++, ++offset)
      if (offset < BC_DUMP_SIZE)
        fprintf(out_file, "%04X ", buffer[offset]);
        else fprintf(out_file, "     ");
    fprintf(out_file, "   : %02u", offset-DUMP_WIDE);
    fprintf(out_file, "\n");
  }
 for (i=0; i != DUMP_WIDE;  fprintf(out_file, "  %01X  ", i++));
 fprintf(out_file, "\n");
 fclose(out_file);
}

void rt_buf_rd(char *str)
{
 int ch;
 char *ptr;

 int offset;
 unsigned buffer2[RT_BUF_SIZE];

 while (*str == ' ' || *str == '\t') str++;
 if ((in_file=fopen(str, "rt")) == NULL)
 {
  msg_out(open_err);
  return;
 }
 strcpy(Window[nwin].data_fname, str);
 out_fname();
 fflush(stdout);
 fgets(buf_str, 80, in_file);
 fgets(buf_str, 80, in_file);
 offset=0;
 while (offset != RT_DUMP_SIZE)
 {
  if (fscanf(in_file, "%x ", &buffer2[offset]) != 1)
  {
   msg_out(format_err);
   return;
  }
  if ((++offset%DUMP_WIDE) == 0)
   while ((ch=fgetc(in_file)) != '\n')
    if (ch == EOF)
    {
     msg_out(format_err);
     return;
    }
 }
 for (offset=0; offset != RT_DUMP_SIZE; offset++)
  buffer[offset]=buffer2[offset];
 rtputblk(0, buffer, 32);
 out_buffer();
 fflush(stdout);
 fclose(in_file);
}

void rt_buf_wr(char *str)
{

 int i, offset;

 while (*str == ' ' || *str == '\t') str++;
 if ((out_file=fopen(str, "wt")) == NULL)
 {
  msg_out(cr_err);
  return;
 }
 strcpy(Window[nwin].data_fname, str);
 out_fname();
 fflush(stdout);
 fprintf(out_file, "\nBuffer:\n");
 for (offset=0; offset < RT_DUMP_SIZE;)
 {
  for (i=0; i < DUMP_WIDE; i++, ++offset)
   if (offset < RT_DUMP_SIZE)
    fprintf(out_file, "%04X ", buffer[offset]);
   else
    fprintf(out_file, "     ");
  fprintf(out_file, "   : %02u", offset-DUMP_WIDE);
  fprintf(out_file, "\n");
 }
 for (i=0; i != DUMP_WIDE;  fprintf(out_file, "  %01X  ", i++));
 fprintf(out_file, "\n");
 fclose(out_file);
}

void set_base(char *str)
{
 unsigned i;

 if (sscanf(str, "%x", &i) != 1)
 {
  msg_out(inp_err);
  return;
 }
 if (i > tmkMaxBase[tmkselected()])
 {
  msg_out(base_err);
  return;
 }
 base=i;
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 fflush(stdout);
}

void set_ctrl_code(char *str)
{
 char ch, *ptr;
 int ctrl_code2;
 char cc_no_def[80];

 while (*str == '\t' || *str == ' ') str++;
 ptr=str;
 while ((ch=*(ptr++)) != '\0')
  if (ch != '0' && ch != '1')
  {
   msg_out(bad_ctrl_code);
   return;
  }
 --ptr;
 if (ptr-str > CC_SIZE)
 {
  msg_out(bad_ctrl_code);
  return;
 }
 ptr=str;
 for (ctrl_code2=0; *ptr != '\0'; ptr++)
 {
  ctrl_code2<<= 1;
  if (*ptr == '1') ctrl_code2++;
 }
 if (!correct_cc(ctrl_code2))
 {
  sprintf(cc_no_def, "Control code %s not defined", str);
  msg_out(cc_no_def);
  return;
 }
 ctrl_code[tmkselected()][base]=ctrl_code2;
 out_ctrl_code();
 fflush(stdout);
}

void set_number(char *str)
{
 unsigned i;

 if (sscanf(str, "%01x", &i) != 1)
 {
  msg_out(inp_err);
  return;
 }
 if (i > 2 || i == 0)
 {
  msg_out(bus_num_err);
  return;
 }
 bus_num = (i == 1) ? BUS_1 : BUS_2;
 if (bcdefbus(bus_num))
 {
  bus_num = BUS_1;
  msg_out(bus_num_err);
  return;
 }
 out_number();
 fflush(stdout);
}

void set_count(char *str)
{
 unsigned long c;

 if (sscanf(str, "%u", &c) != 1)
 {
  msg_out(inp_err);
  return;
 }
 cmd_count=c;
 out_count();
 fflush(stdout);
}

void set_pause(char *str)
{
 unsigned long p;

 if (sscanf(str, "%lu", &p) != 1)
 {
  msg_out(inp_err);
  return;
 }
 if (p > 999999)
 {
  msg_out("Maximum allowable pause - 999999 us.");
  return;
 }
 opause = p;
 pause1 = opause;//(unsigned)((unsigned long)p * 2L * 11932L / 10000L);
 out_pause();
 fflush(stdout);
}

void set_cpage(char *str)
{
 unsigned p;

 if (sscanf(str, "%u", &p) != 1)
 {
  msg_out(inp_err);
  return;
 }
 switch (rtdefpagebus(p))
 {
 case RT_BAD_FUNC:
  msg_out("Can not define separate page for bus channel");
  break;
 case RT_BAD_PAGE:
  msg_out("Wrong page number");
  break;
 case 0:
  cram_page=p;
  out_page();
  fflush(stdout);  
  break;
 }
}

void set_spage(char *str)
{
 unsigned p;

 if (sscanf(str, "%u", &p) != 1)
 {
  msg_out(inp_err);
  return;
 }
 switch (rtdefpagepc(p))
 {
 case RT_BAD_FUNC:
  msg_out("Can not define separate page for PC");
  break;
 case RT_BAD_PAGE:
  msg_out("Wrong page number");
  break;
 case 0:
  bram_page=p;
  out_page();
  rtdefsubaddr(dir, subadr);
  rt_out_ram(dir, subadr);
  fflush(stdout);
  break;
 }
}

void set_page(char *str)
{
 unsigned p;

 if (sscanf(str, "%u", &p) != 1)
 {
  msg_out(inp_err);
  return;
 }
 if (rtdefpage(p))
  msg_out("Wrong page number");
 else
 {
  cram_page=bram_page=p;
  out_page();
  rtdefsubaddr(dir, subadr);
  rt_out_ram(dir, subadr);
  fflush(stdout);
 }
}

int wr_at(unsigned short at)
{
 int res;

 switch (res = rtdefaddress(at))
 {
 case RT_BAD_FUNC:
#ifdef LPT_AT
  set_lpt_data(at);
  rtdefaddress(at);
  terminal_adr = at;
  res = 0;
#endif
 case RT_BAD_ADDRESS:
  break;
 case 0:
  terminal_adr = at;
 }
 return res;
}

void set_at(char *str)
{
 unsigned p;
 int res;

 if (sscanf(str, "%u", &p) != 1)
 {
  msg_out(inp_err);
  return;
 }
#ifndef LPT_AT
 if (Window[nwin].at_avail)
#endif
  if (wr_at(p))
   msg_out("Wrong RT address");
  else
   out_at();
#ifndef LPT_AT
 else
  msg_out("Wrong RT address set");
#endif
}

void set_subadr_r(char *str)
{
 if (set_subadr(str)) return;
 dir = RT_RECEIVE;
 rtdefsubaddr(dir, subadr);
 out_subadr();
 rt_out_ram(dir, subadr);
 fflush(stdout);
}

void set_subadr_t(char *str)
{
 if (set_subadr(str)) return;
 dir = RT_TRANSMIT;
 rtdefsubaddr(dir, subadr);
 out_subadr();
 rt_out_ram(dir, subadr);
 fflush(stdout);
}

int set_subadr(char *str)
{                        
 unsigned i;

 if (sscanf(str, "%x", &i) != 1)
 {
  msg_out(inp_err);
  return 1;
 }
 if (i > 31)
 {
  msg_out(subadr_err);
  return 1;
 }
 subadr=i;
 return 0;
}

void set_sw_bits(char *str, unsigned short mask)
{
 if (end_ctrl(str)) return;
 rtsetanswbits(mask);
 out_status_word();
 fflush(stdout);
}

void clear_sw_bits(char *str, unsigned short mask)
{
 if (end_ctrl(str)) return;
 rtclranswbits(mask);
 out_status_word();
 fflush(stdout);
}

void set_status_word(char *str)        
{
 char ch, *ptr;
 int status_word;

 while (*str == '\t' || *str == ' ') str++;
 ptr=str;
 while ((ch=*(ptr++)) != '\0')
  if (ch != '0' && ch != '1')
  {
   msg_out(bad_status_word);
   return;
  }
 --ptr;
 if (ptr-str > SW_SIZE)
 {
  msg_out(bad_status_word);
  return;
 }
 ptr=str;
 for (status_word=0; *ptr != '\0'; ptr++)
 {
  status_word<<= 1;
  if (*ptr == '1') status_word++;
 }
 rtclranswbits(~status_word);
 rtsetanswbits(status_word);
 out_status_word();
 fflush(stdout);
}

void select_window(int nwindow)
{
 nwin = nwindow;
/*
 if (avtomat)
  nmainwin = nwin;
*/
 tmkselect(Window[nwin].nTMK);
 switch (Window[nwin].nMode)
 {
 case BC_MODE:
  if (!avtomat)
   base = bcgetbase();
  DUMP_STRINGS = BC_DUMP_STRINGS;
  DUMP_SIZE = BC_DUMP_SIZE;
  buf_size = BC_BUF_SIZE;
  break;
 case RT_MODE:
  if (!avtomat)
  {
   subadr = rtgetsubaddr();
   dir = subadr & RT_TRANSMIT;
   subadr &= ~RT_TRANSMIT;
  }
  DUMP_STRINGS = RT_DUMP_STRINGS;
  DUMP_SIZE = RT_DUMP_SIZE;
  buf_size = RT_BUF_SIZE;
 }
 if (avtomat || fInt)
  window(Window[nwin].nX + 1, Window[nwin].nY, 
         Window[nwin].nX + Window[nwin].nDX - 3, 
         Window[nwin].nY + Window[nwin].nDY - 1);
}

void twait(unsigned long pause)
{
/* unsigned time1, dtime;

 time1 = get_timer();
 while (time1-get_timer() < pause);*/
 struct timespec time1, time2;
 unsigned long d_usec;
 
 clock_gettime(CLOCK_REALTIME, &time1);
 do
 {
  clock_gettime(CLOCK_REALTIME, &time2);
  d_usec=(time2.tv_sec-time1.tv_sec)*1000000L+
         time2.tv_nsec/1000L-time1.tv_nsec/1000L;
 }
 while (d_usec < pause); 
}

/*void BCIntNorm(unsigned nResult, unsigned nothing1, unsigned nothing2)
{
 int_num[tmkselected()] = 1;
 bc_sw = nResult;
 good_starts++;
 bcrestore();
 nothing1;
 nothing2;
}

void BCIntExc(unsigned nResult, unsigned AW1, unsigned AW2)
{
 int_num[tmkselected()] = 2;
 bc_sw = nResult;
 bc_aw1 = AW1;
 bc_aw2 = AW2;
 if (bad_starts < (unsigned long)BADLEN)
 {
  bad_sts[(unsigned)bad_starts] = bad_starts + good_starts + 1L;
  bad_sws[(unsigned)bad_starts] = bc_sw;
  bad_aws[(unsigned)bad_starts] = bc_aw1;
 }
 bad_starts++;
#ifdef LPT_INT_EXC
 set_lpt_data(0xFF);
 set_lpt_data(0);
#endif
 bcrestore();
}

void far RTIntCmd(unsigned nCmd)
{
 int_num[tmkselected()] = 1;
 rt_cmd = nCmd;
 rt_sw = rtgetstate();
 iii = 1;
 iis = rt_sw;
 rtrestore();
}

void far RTIntErr(unsigned nStatus)
{
 int_num[tmkselected()] = 2;
 rt_sw = nStatus;
 if ((rt_sw & (G1_MASK | G2_MASK)) != 0)
 {
   rtreset();
 }
 bad_starts += 1000L;
 iii = 2;
 iis = rt_sw;
 rtrestore();
}

void far RTIntData(unsigned nStatus)
{
 int_num[tmkselected()] = 3;
 rt_sw = nStatus;
 iii = 3;
 iis = rt_sw;
 rtrestore();
}*/

void reset_mode()
{
 int mode = tmkgetmode();
 *Window[nwin].data_fname = '\0';
 if (mode == BC_MODE)
 {
  Window[nwin].nMode = BC_MODE;
  bus_num=bcgetbus();
  base=bcgetbase();
  buf_size = BC_BUF_SIZE;
 }
 else if (mode == RT_MODE)
 {
  Window[nwin].nMode = RT_MODE;
  if (hb_mode)
   rtdefmode(rtgetmode()|RT_HBIT_MODE);
  else
   rtdefmode(rtgetmode()&(~RT_HBIT_MODE));
  rt_sw = rtgetstate();
  bram_page=cram_page=rtgetpage();
  subadr = rtgetsubaddr();
  dir = RT_TRANSMIT&subadr;
  subadr &= ~RT_TRANSMIT;
  Window[nwin].at_avail = (rtdefaddress(rtgetaddress())) ? 0 : 1;
  buf_size = RT_BUF_SIZE;
 }
}

void set_mode(int mode)
{
 *Window[nwin].data_fname = '\0';
 if (mode == BC_MODE)
 {
  bcreset();
  Window[nwin].nMode = BC_MODE;
  CheckTmkEvent(0);
  int_num[Window[nwin].nTMK] = 0;
  bcdefbus(bus_num=BUS_1);
  bcdefbase(base=0);
  buf_size = BC_BUF_SIZE;
 }
 else if (mode == RT_MODE)
 {
  rtreset();
  Window[nwin].nMode = RT_MODE;
  CheckTmkEvent(0);
  int_num[Window[nwin].nTMK] = 0;
  if (hb_mode)
   rtdefmode(rtgetmode()|RT_HBIT_MODE);
  else
   rtdefmode(rtgetmode()&(~RT_HBIT_MODE));
  rt_sw = rtgetstate();
  rtdefpage(bram_page=cram_page=0);
  rtdefsubaddr(dir=RT_RECEIVE, subadr=1);
  Window[nwin].at_avail = (rtdefaddress(0)) ? 0 : 1;
  buf_size = RT_BUF_SIZE;
  wr_at(10);
 }
}

char szCfgName[16];
char szCmd[16];

int TmkInit0()
{
 int iTMK;

 if (TmkInit(szCfgName))
 {
  printf("Configuration load error from the file %s\n", szCfgName);
  tmkdone(ALL_TMKS);
  TmkClose();
  exit(0);
 }
#ifdef LPT
 init_lpt();
#endif
 nwin = 0;
 if (tmkMaxN > tmkgetmaxn())
   tmkMaxN = tmkgetmaxn();
 for (iTMK = 0; iTMK <= tmkMaxN; iTMK++)
 {
  tmkMaxBase[iTMK] = TMKCPP_MAX_BASE;
  if (tmkselect(iTMK))
   continue;
  if (TMKCPP_MAX_BASE > bcgetmaxbase())
    tmkMaxBase[iTMK] = bcgetmaxbase();
  switch (aTmkConfig[iTMK].nType)
  {
  default:
   if (nTest <= 0)
    break;
  case TMK400:
  case TMKMPC:
  case RTMK400:
   if (nTest < 0)
    break;
/*   if (TMK_TuneIODelay(0))
   {
    while (kbhit())
     getch();
    printf("Initial TMK %d RAM test error.\n"
           "Can not determine I/O delay for TMK %d.\n"
           "Press any key to continue.\n",
           iTMK, iTMK);
    while (!kbhit());
    getch();
   }
   break;*/
  }
/*  bcdefintnorm(BCIntNorm);
  bcdefintexc(BCIntExc);
  rtdefintcmd(RTIntCmd);
  rtdefinterr(RTIntErr);
  rtdefintdata(RTIntData);*/
  if (nwin > nMaxWin)
   continue;
  if (nwin == bcwin)
   set_mode(BC_MODE);
  else
   set_mode(RT_MODE);
  Window[nwin].fVisible = 1;
  Window[nwin].nTMK = iTMK;
  Window[nwin++].nType = -1;
 }
 select_window(nmainwin);
 all_screen();
}


int main(int argc, char *argv[])
{
 unsigned long delay;
 int i;

 ThreadCtl(_NTO_TCTL_IO, 0);	
 set_input_mode();
 set_output_mode();
 clock_gettime(CLOCK_REALTIME, &biostime1);

 strcpy(szCfgName, "tmk.cfg");
 *szCmd = '\0';
 nTest = 0;
 for (i = 1; i < argc; ++i)
 {
   switch (argv[i][0])
   {
   case 'c':
   case 'C':
     strncpy(szCfgName, argv[i]+1, 16);
     break;
   case 'r':
   case 'R':
     strncpy(szCmd, argv[i]+1, 16);
     break;
   case 't':
   case 'T':
     switch (argv[i][1])
     {
     case '+':
       nTest = 1;
       break;
     case '-':
       nTest = -1;
       break;
     }
     break;
   }
 }
// textmode(C80);
 textcolor(LIGHTGRAY);
 textbackground(BLACK);
 clrscr();
// _wscroll = 0;
// oldvect3=getvect(0x05);   
// setvect(0x05, prtscr_brk);

 bcwin = 0;
 TmkInit0();
 while (1)
 {                  
  window(1, 1, 80, 25);
  if (*szCmd != '\0')
  {
    strcpy(cmd_str, szCmd);
    *szCmd = '\0';
  }
  else
    in_cmd(cmd_str);
  window(Window[nwin].nX + 1, Window[nwin].nY, 
          Window[nwin].nX + Window[nwin].nDX - 2, 
          Window[nwin].nY + Window[nwin].nDY - 1);
  make_cmd(cmd_str);
 }
}

void block_data_irq(char *str)
{
 if (end_ctrl(str)) return;
 rtdefirqmode(rtgetirqmode()|RT_DATA_BL);
//  out_mode();
}

void unblock_data_irq(char *str)
{
 if (end_ctrl(str)) return;
 rtdefirqmode(rtgetirqmode()&(~RT_DATA_BL));
//  out_mode();
}

void set_hbit_mode(char *str)
{
  int res;

  while (*str=='\t' || *str==' ') str++;
  switch (*str)
  {
  case '0': res = rtdefmode(rtgetmode()&(~RT_HBIT_MODE));
            hb_mode = 0;
            break;
  case '1': res = rtdefmode(rtgetmode()|RT_HBIT_MODE);
            hb_mode = 1;
            break;
  }
//  out_rt_mode();
  res;
}

void set_flag_mode(char *str)
{
  int res;

  while (*str=='\t' || *str==' ') str++;
  switch (*str)
  {
  case '0': res = rtdefmode(rtgetmode()&(~RT_FLAG_MODE));
            break;
  case '1': res = rtdefmode(rtgetmode()|RT_FLAG_MODE);
            break;
  }
//  out_mode();
  res;
}

void set_brcst_mode(char *str)
                              
{
  int res;

  while (*str=='\t' || *str==' ') str++;
  switch (*str)
  {
  case '0': res = rtdefmode(rtgetmode()&(~RT_BRCST_MODE));
            break;
  case '1': res = rtdefmode(rtgetmode()|RT_BRCST_MODE);
            break;
  }
//  out_mode();
  res;
}

void make_cmd(char *str)
{
 if (*cmd_str == '\0')
 {
  switch (Window[nwin].nMode)
  {
  case BC_MODE:
   out_base();
   out_ctrl_code();
   bc_out_ram(base);
   fflush(stdout);
   break;
  case RT_MODE:
   out_subadr();
   rt_out_ram(dir, subadr);
   fflush(stdout);
   break;
  }
 }
 else
  strcpy(old_cmd, cmd_str);
 while (*str == ' ' || *str == '\t') str++;
 if (*str == ':')
 {
  if (enter_mode && fGoto && !strcmpi(str+1, szGoto))
   fGoto = 0;
 }
 else if (fGoto)
  ;
 else if (!strcmpi(str, "Q"))
  make_quit("");
 else if (!strnicmp(str, "IOD ", 4))
  set_io_delay(str+4);
 else if (!strcmpi(str, "I"))
  cmd_reset("");
 else if (!strcmpi(str, "F"))
  fields_chg("");
 else if (!strcmpi(str, "BE"))
  buf_edit("");
 else if (!strnicmp(str, "BE ", 3))
  buf_edit(str+3);
 else if (!strcmpi(str, "BC"))
  buf_clear("");
 else if (!strnicmp(str, "BF ", 3))
  buf_fill(str+3);
 else if (!strnicmp(str, "SL ", 3))
  set_stat_len(str+3);
 else if (!strnicmp(str, "WIN ", 4))
  select_win(str+4);
 else if (!strnicmp(str, "TMK ", 4))
  select_tmk(str+4);
 else if (!strcmpi(str, "MBC"))
  mode_bc("");
 else if (!strcmpi(str, "MRT"))
  mode_rt("");
// else if (!strcmpi(str, "MMT"))
//  mode_mt("");
 else if (!strnicmp(str, "AVT ", 4))
  avt_ctrl(str+4);
 else if (!strnicmp(str, "ATBCSA", 6))
 {
  fReserv=0;
  fSimpleRT=1;
  fSimpleA=1;
  avt_bc(str+6);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "RATBCSA", 7))
 {
  fReserv=1;
  fSimpleRT=1;
  fSimpleA=1;
  avt_bc(str+7);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "ATRTSA", 6))
 {
  fReserv=0;
  fSimpleRT=1;
  fSimpleA=1;
  avt_rt(str+6);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "RATRTSA", 7))
 {
  fReserv=1;
  fSimpleRT=1;
  fSimpleA=1;
  avt_rt(str+7);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "ATBCS", 5))
 {
  fReserv=0;
  fSimpleRT=1;
  fSimpleA=0;
  avt_bc(str+5);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "RATBCS", 6))
 {
  fReserv=1;
  fSimpleRT=1;
  fSimpleA=0;
  avt_bc(str+6);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "ATRTS", 5))
 {
  fReserv=0;
  fSimpleRT=1;
  fSimpleA=0;
  avt_rt(str+5);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "RATRTS", 6))
 {
  fReserv=1;
  fSimpleRT=1;
  fSimpleA=0;
  avt_rt(str+6);
  fSimpleRT=0;
 }
 else if (!strnicmp(str, "ATBC", 4))
 {
  fReserv=0;
  avt_bc(str+4);
 }
 else if (!strnicmp(str, "RATBC", 5))
 {
  fReserv=1;
  avt_bc(str+5);
 }
 else if (!strnicmp(str, "ATRT", 4))
 {
  fReserv=0;
  avt_rt(str+4);
 }
 else if (!strnicmp(str, "RATRT", 5))
 {
  fReserv=1;
  avt_rt(str+5);
 }
#ifdef ELCUS
 else if (!strnicmp(str, "ATS1", 4))
 {
  fReserv=0;
  fStatErrStop=1;
  avt_stat(str+4);
  fStatErrStop=0;
 }
 else if (!strnicmp(str, "RATS1", 5))
 {
  fReserv=1;
  fStatErrStop=1;
  avt_stat(str+5);
  fStatErrStop=0;
 }
#endif //def ELCUS
 else if (!strnicmp(str, "ATS", 3))
 {
  fReserv=0;
  avt_stat(str+3);
 }
 else if (!strnicmp(str, "RATS", 4))
 {
  fReserv=1;
  avt_stat(str+4);
 }
#ifdef ELCUS
 else if (!strnicmp(str, "ATARR1", 6))
 {
  fATArBlk=0;
  avt_arb_rt_r(str+6);
 }
 else if (!strnicmp(str, "ATARR", 5))
 {
  fATArBlk=1;
  avt_arb_rt_r(str+5);
 }
 else if (!strnicmp(str, "ATARW", 5))
  avt_arb_rt_w(str+5);
 else if (!strnicmp(str, "ATARF", 5))
  avt_arb_rt_f(str+5);
 else if (!strnicmp(str, "BA", 2))
  avt_va996(str+2);
 else if (!strnicmp(str, "WORDS ", 6))
  set_a_words(str+6);
#endif //def ELCUS
 else if (!strnicmp(str, "ATFL", 4))
  avt_flags(str+4);
 else if (!strcmpi(str, "STOP?"))
 {
  if (enter_mode && (avt_err || to_errors>0L || bad_starts>0L ||
                     channel_err>0L || data_err>0L || (kbhit() /*&& getch() == ESCAPE*/)))//temp
   fSkipCmds=1;
 }
 else if (!strcmpi(str, "BCRT+"))
  fBcRt=1;
 else if (!strcmpi(str, "BCRT-"))
  fBcRt=0;
 else if (!strcmpi(str, "BEEP+"))
  fBeep=1;
 else if (!strcmpi(str, "BEEP-"))
  fBeep=0;
 else if (!strcmpi(str, "BEEP"))
  beep("1");
 else if (!strnicmp(str, "BEEP ", 5))
  beep(str+5);
#ifdef LPT_SYN
 else if (!strcmpi(str, "LP+"))
  fLPTSyn=1;
 else if (!strcmpi(str, "LP-"))
  fLPTSyn=0;
#endif
#ifdef ELCUS
 else if (!strnicmp(str, "OW ", 3))
  tmk_outpw(str+3);
#endif //def ELCUS
#ifdef TMK_DAC
 else if (!strnicmp(str, "DAC ", 4))
  tmk_outdac(str+4);
#endif TMK_DAC
 else if (!strcmpi(str, "P"))
  kbd_pause("");
 else if (!strnicmp(str, "P ", 2))
  kbd_pause(str+1);
 else if (!strnicmp(str, ";", 1))
  comment(str+1);
 else if (!strnicmp(str, "GOTO ", 5))
 {
  if (enter_mode)
  {
   fseek(cmd_file, 0L, SEEK_SET);
   fGoto = 1;
   strcpy(szGoto, str+5);
  }
 }
 else if (!strnicmp(str, "#", 1))
  ;
 else
 if (Window[nwin].nMode == BC_MODE)
 {
  if (!strnicmp(str, "SB ", 3))
   set_base(str+3);
  else if (!strnicmp(str, "ERR ", 4))
   set_max_err(str+4);
  else if (!strnicmp(str, "SN ", 3))
   set_number(str+3);
  else if (!strnicmp(str, "SP ", 3))
   set_pause(str+3);
  else if (!strnicmp(str, "SC ", 3))
   set_ctrl_code(str+3);
  else if (!strnicmp(str, "GLF", 3))
   start_loop_file(str+3);
  else if (!strnicmp(str, "GL", 2))
   start_loop(str+2);
  else if (!strcmpi(str, "G"))
   start_1("");
  else if (!strcmpi(str, "STO"))
   statistic_out("");
  else if (!strcmpi(str, "STBO"))
   statistic_bad_out("");
  else if (!strcmpi(str, "STC"))
   statistic_clear("");
  else if (!strnicmp(str, "R ", 2))
   bc_buf_rd(str+2);
  else if (!strnicmp(str, "W ", 2))
   bc_buf_wr(str+2);
  else if (!strnicmp(str, "R< ", 3) && cmd_count == 1)
   cmds_open(str+3);
  else if (!strnicmp(str, "R< ", 3) && cmd_count != 1)
   cmds_open2(str+3);
  else if (!strnicmp(str, "RF< ", 4))
   cmds_open_f(str+3);
  else if (!strnicmp(str, "C ", 2))
   set_count(str+2);
  else if (!strnicmp(str, "RE ", 3))
   exe_open(str+3);
  else if (!strcmpi(str, "T"))
   bc_ram_test("");
  else if (!strcmpi(str, "H"))
   bc_help("");
#ifdef ELCUS
  else if (!strnicmp(str, "SYM", 3))
   sym(str+3);
  else if (!strnicmp(str, "OU400", 5))
  {
   fReserv=0;
   avt_ou400(str+5);
  }
  else if (!strnicmp(str, "ROU400", 6))
  {
   fReserv=1;
   avt_ou400(str+6);
  }
#endif //def ELCUS
  else if (*str != '\0')
   msg_out(undef_cmd);
 }
 else if (Window[nwin].nMode == RT_MODE)
 {
  if (!strnicmp(str, "SW ", 3))
   set_status_word(str+3);
  else if (!strnicmp(str, "HBIT ", 5))
  {
    set_hbit_mode(str+5);
    out_rt_mode();
    fflush(stdout);
  }
  else if (!strnicmp(str, "FLAG ", 5))
  {
    set_flag_mode(str+5);
    out_rt_mode();
    fflush(stdout);
  }
  else if (!strnicmp(str, "REJ ", 4))
  {
    set_flag_mode(str+4);
    out_rt_mode();
    fflush(stdout);
  }
  else if (!strnicmp(str, "BCST ", 5))
  {
    set_brcst_mode(str+5);
    out_rt_mode();
    fflush(stdout);
  }
  else if (!strcmpi(str, "DTBL 1"))
  {
    block_data_irq("");
    out_rt_mode();
    fflush(stdout);
  }
  else if (!strcmpi(str, "DTBL 0"))
  {
    unblock_data_irq("");
    out_rt_mode();
    fflush(stdout);
  }
  else if (!strnicmp(str, "SFL", 3))
   set_flag(str+3);
#ifdef ELCUS
  else if (!strcmpi(str, "WRC"))
   wr_mr_loop(str+3);
  else if (!strcmpi(str, "RDC"))
   rd_sw_loop(str+3);
#endif //def ELCUS
  else if (!strcmpi(str, "SSR"))
   set_sw_bits(str+3, SREQ);
  else if (!strcmpi(str, "SBS"))
   set_sw_bits(str+3, BUSY);
  else if (!strcmpi(str, "SSF"))
   set_sw_bits(str+3, SSFL);
  else if (!strcmpi(str, "STF"))
   set_sw_bits(str+3, RTFL);
  else if (!strcmpi(str, "SDN"))
   set_sw_bits(str+3, DNBA);
  else if (!strcmpi(str, "CSR"))
   clear_sw_bits(str+3, SREQ);
  else if (!strcmpi(str, "CBS"))
   clear_sw_bits(str+3, BUSY);
  else if (!strcmpi(str, "CSF"))
   clear_sw_bits(str+3, SSFL);
  else if (!strcmpi(str, "CTF"))
   clear_sw_bits(str+3, RTFL);
  else if (!strcmpi(str, "CDN"))
   clear_sw_bits(str+3, DNBA);
  else if (!strcmpi(str, "SMR"))
  {
   rtlock(dir, subadr);
   fLock=1;
  }
  else if (!strcmpi(str, "CMR"))
  {
   rtunlock();
   fLock=0;
  }
  else if (!strnicmp(str, "SR ", 3))
   set_subadr_r(str+3);
  else if (!strnicmp(str, "ST ", 3))
   set_subadr_t(str+3);
  else if (!strnicmp(str, "SPG ", 4))
   set_spage(str+4);
  else if (!strnicmp(str, "CPG ", 4))
   set_cpage(str+4);
  else if (!strnicmp(str, "PG ", 3))
   set_page(str+3);
  else if (!strnicmp(str, "SAT ", 4))
   set_at(str+4);
  else if (!strcmpi(str, "RSW"))
   read_sw("");
  else if (!strnicmp(str, "STP", 3))
   read_sp(str+3);
  else if (!strnicmp(str, "R ", 2))
   rt_buf_rd(str+2);
  else if (!strnicmp(str, "W ", 2))
   rt_buf_wr(str+2);
  else if (!strnicmp(str, "R< ", 3))
   cmds_open(str+3);
  else if (!strnicmp(str, "RF< ", 4))
   cmds_open_f(str+3);
  else if (!strcmpi(str, "T"))
   rt_ram_test("");
  else if (!strcmpi(str, "H"))
   rt_help("");
  else if (*str != '\0')
   msg_out(undef_cmd);
 }
}

void make_quit(char *str)
{
 if (end_ctrl(str)) return;
// setvect(0x05, oldvect3);
 tmkdone(ALL_TMKS);
 TmkClose();
 window(1, 1, 80, 25);
 clrscr();
 printf("Program has finished.\n");
 reset_output_mode();
 exit(0);
}

void tmk_outpw(char *str)
{
 unsigned wAddr, wData;

 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%X", &wAddr) != 1)
 {
  msg_out(inp_err);
  return;
 }
 while (isxdigit(*str)) str++;
 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%X", &wData) != 1)
 {
  msg_out(inp_err);
  return;
 }
 outport(wAddr, wData);
}

#ifdef TMK_DAC
void tmk_outdac(char *str)
{
 unsigned wDac;

 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%X", &wDac) != 1)
 {
  msg_out(inp_err);
  return;
 }
 tmkdefdac(wDac);
}
#endif //def TMK_DAC

void set_io_delay(char *str)
{
 unsigned nDelay;

 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%u", &nDelay) != 1)
 {
  msg_out(inp_err);
  return;
 }
 //tmkiodelay(nDelay);
 out_type();
 fflush(stdout);
}

void set_max_err(char *str)
{
 unsigned long dwErrs;

 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%lu", &dwErrs) != 1)
 {
  msg_out(inp_err);
  return;
 }
 dwMaxErr=dwErrs;
 err_level = dwErrs;
 out_maxerrs();
 fflush(stdout);
}

void select_win(char *str)
{
 int nwin;
 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%u", &nwin) != 1)
 {
  msg_out(inp_err);
  return;
 }
 if (nwin > 1)
 {
  msg_out("Window number range is from 0 to 1");
  return;
 }
 nmainwin = nwin;
// int_num[Window[0].nTMK] = 0;
// int_num[Window[1].nTMK] = 0;
 select_window(nmainwin);
 all_screen();
}

void mode_bc(char *str)
{
 if (end_ctrl(str)) return;
 CheckTmkEvent(0);
 int_num[Window[nwin].nTMK] = 0;
 set_mode(BC_MODE);
 base = 0;
 bcdefbase(0);
 all_screen();
}

void mode_rt(char *str)
{
 if (end_ctrl(str)) return;
 set_mode(RT_MODE);
 cram_page = bram_page = 0;
 rtdefpage(0);
 dir = RT_RECEIVE;
 subadr = 1;
 rtdefsubaddr(dir, subadr);
 all_screen();
}

void select_tmk(char *str)
{
 int ntmk;

 while (*str == '\t' || *str == ' ') str++;
 if (*str == '\0' || sscanf(str, "%u", &ntmk) != 1)
 {
  msg_out(inp_err);
  return;
 }
 if (ntmk > 3)
 {
  msg_out("Device number range is from 0 to 3");
  return;
 }
 if (ntmk == Window[!nmainwin].nTMK)
 {
//  set_mode(Window[!nmainwin].nMode);
  msg_out("Can not define same board in both windows");
  return;
 }
 if (tmkselect(ntmk))
 {
  msg_out("Device with specified number has not defined in configuration file");
  return;
 }
 nwin = nmainwin;
 switch (tmkgetmode())
 {
 case BC_MODE:
 case RT_MODE:
  reset_mode();
  break;
 case UNDEFINED_MODE:
  set_mode(BC_MODE);
  break;
 }
 Window[nmainwin].nTMK = ntmk;
 Window[nmainwin].nType = -1;
 select_window(nmainwin);
 all_screen();
}

void set_stat_len(char *str)
{
 unsigned long cnt;

 while (*str == '\t' || *str == ' ') str++;
 if (*str != '\0')
 {
  if (sscanf(str, "%u", &cnt) != 1)
  {
   msg_out(inp_err);
   return;
  }
  GL_COUNTER = cnt;
  GL_COUNTER2 = cnt * 2;
  GL_COUNTER3 = cnt * 4;
 }
 out_glcount();
 fflush(stdout);
}

#ifdef ELCUS
void sym(char *str)
{
 unsigned long p;
 int cur_base;

 if (end_ctrl(str)) return;
 cur_base=base;
 set_base("0"); buf_fill("1, 32, AAAA");
 ctrl_code[tmkselected()][base] = DATA_BC_RT_BRCST; 
 bcputw(0, (0x1F<<11) | RT_RECEIVE | (0x11<<5));
 set_base("1"); buf_fill("1, 32, 0000");
 ctrl_code[tmkselected()][base] = DATA_BC_RT_BRCST;
 bcputw(0, (0x1F<<11) | RT_RECEIVE | (0x11<<5));
 set_base("2"); buf_fill("1, 32, 5555");
 ctrl_code[tmkselected()][base] = DATA_BC_RT_BRCST;
 bcputw(0, (0x1F<<11) | RT_RECEIVE | (0x11<<5));
 set_base("3"); buf_fill("1, 32, FFFF");
 ctrl_code[tmkselected()][base] = DATA_BC_RT_BRCST;
 bcputw(0, (0x1F<<11) | RT_RECEIVE | (0x11<<5));
 set_base("4"); buf_fill("1, 32, 8000");
 ctrl_code[tmkselected()][base] = DATA_BC_RT_BRCST;
 bcputw(0, (0x1F<<11) | RT_RECEIVE | (0x11<<5));
 set_base("5"); buf_fill("1, 32, 7FFF");
 ctrl_code[tmkselected()][base] = DATA_BC_RT_BRCST;
 bcputw(0, (0x1F<<11) | RT_RECEIVE | (0x11<<5));
 gotoxy(1, Window[nwin].nDY);
 textcolor(CYAN);
 cprintf("Symmetry test. Press F12 to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 prtscr_flag = 0;
 while (!prtscr_flag)
 {
  bioskey_f12();
  base=0; start();
  base=1; start();
  base=2; start();
  base=3; start();
  base=4; start();
  base=5; start();
 }
 prtscr_flag = 0;
 textcolor(WHITE);
 gotoxy(1, Window[nwin].nDY);
 hor_line(Window[nwin].nDX);
 textcolor(LIGHTGRAY);
 base=cur_base;
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 fflush(stdout);
}
#endif //def ELCUS

void bc_clear_ram()
{
 int k, maxbase;

 maxbase = tmkMaxBase[tmkselected()];
 for (k = 0; k <= 63; ++k)
  buffer[k] = 0;
 for (base = 0; base <= maxbase; base++)
 {
  bcdefbase(base);
  bcputblk(0, buffer, 64);
 }
 base = 0;
 bcdefbase(0);
 out_base();
 out_ctrl_code();
 out_buffer();
 fflush(stdout);
}

void rt_clear_ram()
{
 int k, page, maxpage;

 maxpage = rtgetmaxpage();
 for (k = 0; k <= 31; ++k)
  buffer[k] = 0;
 for (page = 0; page <= maxpage; page++)
 {
  rtdefpage(page);
  for (subadr = 0; subadr <= 31; subadr++)
  {
   rtdefsubaddr(RT_RECEIVE, subadr);
   rtputblk(0, buffer, 32);
   rtdefsubaddr(RT_TRANSMIT, subadr);
   rtputblk(0, buffer, 32);
  }
 }
 cram_page = bram_page = 0;
 rtdefpage(0);
 dir = RT_RECEIVE;
 subadr = 1;
 rtdefsubaddr(dir, subadr);
 out_page();
 out_subadr();
 out_buffer();
 fflush(stdout);
}

int bc_ram_test(char *str)
{
 int k, error, bases;

 if (end_ctrl(str)) return 0;
 bases = tmkMaxBase[tmkselected()] + 1;
 clear_dump();
 gotoxy(1, BDUMP_Y-3);
 hor_line(78);
 gotoxy(1, BDUMP_Y-2);
 clreol();
 printf("      0               1               2               3");
 gotoxy(1, BDUMP_Y-1);
 printf("Base: 0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF");
 gotoxy(1, BDUMP_Y);
 printf("  00:");
 gotoxy(1, BDUMP_Y+1);
 printf("  40:");
 gotoxy(1, BDUMP_Y+2);
 printf("  80:");
 gotoxy(1, BDUMP_Y+3);
 printf("  C0:");
 gotoxy(1, BDUMP_Y+4);
 printf("      Memory map: %c, %c - test passed, ", 0xB0, 0xB1);
 textcolor(RED); putchar('B');
 textcolor(LIGHTGRAY); printf(" - test failed.");
 srand(1);
 for (base = 0; base < bases; base++)
 {
  for (k = 0; k <= 63; ++k)
   buffer[k] = rand() + rand();
  bcdefbase(base);
  bcputblk(0, buffer, 64);
  if (base % 64 == 0)
   gotoxy(7, base / 64 + BDUMP_Y);
  putchar('.');
 }
 fflush(stdout);
 srand(1);
 for (base = 0; base < bases; base++)
 {
  bcdefbase(base);
  bcgetblk(0, buffer, 64);
  error = 0;
  for (k = 0; k <= 63; ++k)
  {
   if (buffer[k] != (rand() + rand()))
   {
    error = 1;
    ++data_err;
   }
  }
  if (base % 64 == 0)
   gotoxy(7, base / 64 + BDUMP_Y);
  if (error)
  {
   textcolor(RED); putchar('B'); textcolor(LIGHTGRAY);
  }
  else
   putchar(0xB0);
 }
 fflush(stdout); 
 if (!avtomat)
  msg_out("Normal RAM test completed");
 for (base = 0; base < bases; base++)
 {
  bcdefbase(base);
  bcgetblk(0, buffer, 64);
  for (k = 0; k <= 63; ++k)
   buffer[k] = ~buffer[k];
  bcputblk(0, buffer, 64);
  if (base % 64 == 0)
   gotoxy(7, base / 64 + BDUMP_Y);
  putchar('.');
 }
 fflush(stdout);
 srand(1);
 for (base = 0; base < bases; base++)
 {
  bcdefbase(base);
  bcgetblk(0, buffer, 64);
  error = 0;
  for (k = 0; k <= 63; ++k)
  {
   if (buffer[k] != (unsigned short)(~(rand() + rand())) )
   {
    error = 1;
    ++data_err;
   }
  }
  if (base % 64 == 0)
   gotoxy(7, base / 64 + BDUMP_Y);
  if (error)
  {
   textcolor(RED); putchar('B'); textcolor(LIGHTGRAY);
  }
  else
   putchar(0xB1);
 }
 fflush(stdout); 
 if (!avtomat)
  msg_out("Inverse RAM test completed");
 gotoxy(1, BDUMP_Y-3);
 clreol();
 gotoxy(1, BDUMP_Y-2);
 clreol();
 clear_dump();
// bc_clear_ram();
 base = 0;
 out_base();
 out_ctrl_code();
 bc_out_ram(base);
 bc_out_sw();
 out_inn();
 fflush(stdout);
 return (data_err>0L);
}

int rt_ram_test(char *str)
{
 int k, error, page, pages;

 if (end_ctrl(str)) return 0;
 pages = rtgetmaxpage() + 1;
 clear_dump();
 gotoxy(1, BDUMP_Y-3);
 hor_line(78);
 gotoxy(1, BDUMP_Y-2);
 clreol();
 printf("          0    RECEIVE    1    RECEIVE    0    TRANSMIT   1    TRANSMIT");
 gotoxy(1, BDUMP_Y-1);
 printf("Subaddr.: 0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF");
 gotoxy(1, BDUMP_Y);
 printf("  Page 0:");
 gotoxy(1, BDUMP_Y+1);
 printf("  Page 1:");
 gotoxy(1, BDUMP_Y+2);
 printf("  Page 2:");
 gotoxy(1, BDUMP_Y+3);
 printf("  Page 3:");
 gotoxy(1, BDUMP_Y+4);
 printf("          Memory map: %c, %c - test passed, ", 0xB0, 0xB1);
 textcolor(RED); putchar('B');
 textcolor(LIGHTGRAY); printf(" - test failed.");
 srand(1);
 for (page = 0; page < pages; page++)
 {
  rtdefpage(page);
  gotoxy(11, page + BDUMP_Y);
  for (dir = RT_RECEIVE; ; dir = RT_TRANSMIT)
  {
   for (subadr = 0; subadr <= 31; subadr++)
   {
    for (k = 0; k <= 31; ++k)
     buffer[k] = rand() + rand();
    rtdefsubaddr(dir, subadr);
    rtputblk(0, buffer, 32);
    if (page <= 3)
      putchar('.');
   }
   fflush(stdout);  
   if (dir == RT_TRANSMIT)
    break;
  }
 }
 srand(1);
 for (page = 0; page < pages; page++)
 {
  rtdefpage(page);
  gotoxy(11, page + BDUMP_Y);
  for (dir = RT_RECEIVE; ; dir = RT_TRANSMIT)
  {
   for (subadr = 0; subadr <= 31; subadr++)
   {
    rtdefsubaddr(dir, subadr);
    rtgetblk(0, buffer, 32);
    error = 0;
    for (k = 0; k <= 31; ++k)
    {
     if (buffer[k] != (rand() + rand()))
     {
      error = 1;
      ++data_err;
     }
    }
    if (page <= 3)
    {
     if (error)
     {
      textcolor(RED); putchar('B'); textcolor(LIGHTGRAY);
     }
     else
      putchar(0xB0);
    }
   }
   fflush(stdout);
   if (dir == RT_TRANSMIT)
    break;
  }
 }
 if (!avtomat)
  msg_out("Normal RAM test completed");
 for (page = 0; page < pages; page++)
 {
  rtdefpage(page);
  gotoxy(11, page + BDUMP_Y);
  for (dir = RT_RECEIVE; ; dir = RT_TRANSMIT)
  {
   for (subadr = 0; subadr <= 31; subadr++)
   {
    rtdefsubaddr(dir, subadr);
    rtgetblk(0, buffer, 32);
    for (k = 0; k <= 31; ++k)
     buffer[k] = ~buffer[k];
    rtputblk(0, buffer, 32);
    if (page <= 3)
     putchar('.');
   }
   fflush(stdout); 
   if (dir == RT_TRANSMIT)
    break;
  }
 }
 srand(1);
 for (page = 0; page < pages; page++)
 {
  rtdefpage(page);
  gotoxy(11, page + BDUMP_Y);
  for (dir = RT_RECEIVE; ; dir = RT_TRANSMIT)
  {
   for (subadr = 0; subadr <= 31; subadr++)
   {
    rtdefsubaddr(dir, subadr);
    rtgetblk(0, buffer, 32);
    error = 0;
    for (k = 0; k <= 31; ++k)
    {
     if (buffer[k] != (unsigned short) (~(rand() + rand())) )
     {
      error = 1;
      ++data_err;
     }
    }
    if (page <= 3)
    {
     if (error)
      {
       textcolor(RED); putchar('B'); textcolor(LIGHTGRAY);
      }
      else
       putchar(0xB1);
    }
   }
   fflush(stdout); 
   if (dir == RT_TRANSMIT)
    break;
  }
 }
 if (!avtomat)
  msg_out("Inverse RAM test completed");
 gotoxy(1, BDUMP_Y-3);
 clreol();
 gotoxy(1, BDUMP_Y-2);
 clreol();
 clear_dump();
// rt_clear_ram();
 dir = RT_RECEIVE;
 subadr = 0x10;
 out_subadr();
 rt_out_ram(dir, subadr);
 out_status_word();
 rt_out_sw();
 out_inn();
 fflush(stdout);
 return (data_err>0L);
}

void comment(char *str)
{
 if (!avtomat)
 {
  window(1, 1, 80, 25);
  gotoxy(1, 24);
  clreol();
  printf(str);
  window(Window[nwin].nX + 1, Window[nwin].nY, 
         Window[nwin].nX + Window[nwin].nDX - 3, 
         Window[nwin].nY + Window[nwin].nDY - 1);
 }
 else
 {
  gotoxy(1, 10);
  clreol();
  printf(str);
 }
 fflush(stdout);
}

void kbd_pause(char *str)
{
 unsigned long p;
 int key;

 while (*str == '\t' || *str == ' ') str++;
 if (*str != '\0')
 {                       
  if (sscanf(str, "%u", &p) != 1)
  {
   msg_out(inp_err);
   return;
  }
  for (; p-- ;);
  return;
 }
 gotoxy(1, 10);
 textcolor(CYAN);
 printf("Pause. ESC - return to command mode, other - continue execution.");
 textcolor(LIGHTGRAY);
 fflush(stdout);
// while (kbhit() == 0);
 key = bioskey();
 gotoxy(1, 10);
 clreol();
 fflush(stdout);
 if ((key & 0x00FF) == ESCAPE)
  if (enter_mode)
  {
   fclose(cmd_file);
   enter_mode=0;
  }
}

void statistic_err_out()
{
 int savenDY;
 unsigned i;
 unsigned nErrs;

 window(1, 1, 80, 23);
 clrscr();
 printf(" Mode %c Base%c SAdr.%c Nw.%cErr.%cData %c Mode %c Base% cSAdr.%c Nw.%cErr.%cData\015\012",
        0xB3, 0xB3, 0xB3, 0xB3, 0xB3,
        0xBA,
        0xB3, 0xB3, 0xB3, 0xB3, 0xB3);
 nErrs = (channel_err<(unsigned long)ERRLEN) ? (unsigned)channel_err : ERRLEN;
 for (i = 0; i < nErrs; i++)
 {
  if (at_bad_mode[i] == DATA_BC_RT)
   printf("BC->RT%c", 0xB3);
  else
   printf("RT->BC%c", 0xB3);
  cprintf(" %02Xh %c %03Xh %c %2d %c%04X%c%04X ", 
           at_bad_base[i], 0xB3, 
           at_bad_sa[i], 0xB3,
           at_bad_num[i], 0xB3,
           at_bad_bad[i], 0xB3,
           at_bad_good[i]);
  if (i & 1)
   printf("\015\012");
  else
   printf("%c", 0xBa);
 }
 savenDY = Window[nwin].nDY;
 Window[nwin].nDY = 23;
 msg_out("End of errors statistics");
 Window[nwin].nDY = savenDY;
 all_screen();
}

void statistic_bad_out(char *str)
{
 int savenDY;
 unsigned i;

 if (end_ctrl(str)) return;
 window(1, 1, 80, 23);
 clrscr();
 printf(" N start  %c State W.%c   Status Word    %c N start  %c State W.%c   Status Word\015\012", 0xB3, 0xB3, 0xBA, 0xB3, 0xB3);
 for (i = 0; (unsigned long)i < bad_starts && i < 42; i++)
 {
  cprintf("%9u %c ", bad_sts[i], 0xB3);
  out_bin(bad_sws[i], 7);
  printf(" %c ", 0xB3);
  out_bin(bad_aws[i], 16);
  if (i & 1)
   printf(" \015\012");
  else
   printf(" %c", 0xBA);
 }
 savenDY = Window[nwin].nDY;
 Window[nwin].nDY = 23;
 msg_out("End of exceptions statistics");
 Window[nwin].nDY = savenDY;
 all_screen();
}

void statistic_out(char *str)
{
 if (end_ctrl(str)) return;
 gotoxy(1, 10); clreol();
 cprintf("    Starts - %lu, interrupts_2 - %lu, ", good_starts+bad_starts+to_errors, bad_starts);
 cprintf("errors - %lu, TO_errors - %lu.", channel_err, to_errors);
 if (avtomat)
 {
   fflush(stdout);
   return;
 }  
 msg_out("Bus channel statistics");
 gotoxy(1, 10); clreol();
 fflush(stdout);
}

void statistic_clear(char *str)
{
 if (end_ctrl(str)) return;
 avt_err=0;
 to_errors=channel_err=data_err=good_starts=bad_starts=0L;
 gotoxy(1, 10); clreol();
 fflush(stdout);
}

void fields_chg(char *str)
{
 if (end_ctrl(str)) return;
 fields = !fields;
 all_screen();
}

void bc_help(char *str)
{
 int savenDY;

 if (end_ctrl(str)) return;
 window(1, 1, 80, 23);
 clrscr();
 printf("               Main commands in BC mode :\015\012");
 printf("TMK number_D - select device in current window\015\012");
 printf("ERR num_D, SL num_D, ATBC, ATRT, ATS - automatic test commands\015\012");
 printf("SC code_B   - set control code\015\012");
 printf("SB base_H   - set base\015\012");
 printf("SN number_D - set bus\015\012");
 printf("BE [adr_D, data_H] - edit buffer\015\012");
 printf("BC - clear buffer\015\012");
 printf("BF start_D, end_D, data_H - fill buffer\015\012");
 printf("I - reset Bus Controller\015\012");
 printf("G - single start\015\012");
 printf("GL - loop start\015\012");
 printf("SP pause_D - set pause between starts in a loop\015\012");
 printf("STO/STBO/STC - output/clear statistics\015\012");
 printf("T - test all RAM bases\015\012");
 printf("R filename - read buffer from file        W filename - write buffer to file\015\012");
 printf("R< filename - execute command file\015\012");
 printf("P [pause_D] - programmable pause\015\012");
 printf("C count_D - set command file counter\015\012");
 printf(";... - comment\015\012");
 printf("Q  - exit from program                    H  - help\015\012");
 savenDY = Window[nwin].nDY;
 Window[nwin].nDY = 23;
 msg_out("Help end");
 Window[nwin].nDY = savenDY;
 all_screen();
}

void rt_help(char *str)
{
 int savenDY;

 if (end_ctrl(str)) return;
 window(1, 1, 80, 23);
 clrscr();
 printf("                  Main commands in RT mode :\015\012");
 printf("TMK number_D - select device in current window\015\012");
 printf("SAT adr_D - set RT address\015\012");
 printf("FLAG 0/1, HBIT 0/1, BCST 0/1, DTBL 0/1 - set modes\015\012");
 printf("SW code_B - set status word\015\012");
 printf("Sbit_name/Cbit_name - set/clear status word bit, \015\012");
 printf("                      bit_name - BS, SR, TF, SF, DN\015\012");
 printf("PG/SPG/CPG page_D - set page/PC page/bus page\015\012");
 printf("SMR/CMR - lock/unlock current subaddress\015\012");
 printf("SR/ST subadr_H - set subaddress Rx/Tx\015\012");
 printf("BE [adr_D, data_H] - edit buffer\015\012");
 printf("BF start_D, end_D, data_H - fill buffer\015\012");
 printf("BC - clear buffer\015\012");
 printf("I - reset Remote Terminal\015\012");
 printf("RSW - read state word\015\012");
 printf("SFL - flag writing loop\015\012");
 printf("R filename - read buffer from file        W filename - write buffer to file\015\012");
 printf("R< filename - execute command file\015\012");
 printf("P [pause_D] - programmable pause\015\012");
 printf(";... - comment\015\012");
 printf("Q  - exit from program                    H  - help\015\012");
 savenDY = Window[nwin].nDY;
 Window[nwin].nDY = 23;
 msg_out("Help end");
 Window[nwin].nDY = savenDY;
 all_screen();
}

void cmds_open2(char *str)
{
 if (cmd_count == 0) return;
 cur_count=cmd_count;
 cmds_open(str);
}

int start_loop_n(unsigned long counter)
{
 register i;
 int ps_f;

 if (counter == 1) goto one_start;
 gotoxy(1, 11);
 textcolor(CYAN);
 printf("Loop start. Press F12 to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 prtscr_flag=0;
 while (counter == 0 || counter > 1)
 {
  start();
  bioskey_f12();
  if (pause1) twait(pause1);
  if (prtscr_flag) break;
  if (err_level && ((to_errors+channel_err+bad_starts) >= err_level)) break;
  if (counter) counter--;
 }
 gotoxy(1, 11);
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  for(i = 76; i != 0; i--)
    putchar(0xCD);
 }
 else
 {
  for(i = 76; i != 0; i--)
   putchar(0xC4);
 }
 textcolor(LIGHTGRAY);
 fflush(stdout);
 ps_f=prtscr_flag;
 prtscr_flag=0;
 one_start:
 if (!(err_level && ((to_errors+channel_err+bad_starts) >= err_level)))
  start_1("");
 statistic_out("");
// if ((to_errors+channel_err+bad_starts) <= err_level && !(ps_f && counter)) return 0;
 if ((to_errors+channel_err+bad_starts) == 0L && !(ps_f && counter)) return 0;
 else return 1;
}

int start_1(char *str)
{
 if (end_ctrl(str)) return 0;
 if (!avtomat)
 {
  gotoxy(1, 10);
  clreol();
 }
 out_base();
 out_ctrl_code();
 start();
 if (avtomat)
 {
  select_window(rtwin);
  out_at();
  out_inn();
  out_status_word();
  out_page();
  out_subadr();
  rt_out_sw();
  if (avt_out)
   rt_out_ram(dir, subadr);
  select_window(bcwin);
 }
 out_inn();
 bc_out_sw();
 bc_out_ram(base);
 fflush(stdout);//!!!!
 if (avtomat) statistic_out("");
 if ((to_errors+channel_err+bad_starts) < 1) return 0;
 else return 1;
}

int start_loop(char *str)
{
 unsigned long counter;

 while (*str == '\t' || *str == ' ') str++;
 counter=0;
 if (*str != '\0')
 {
  if (sscanf(str, "%u", &counter) != 1)
  {
   msg_out(inp_err);
   return 1;
  }
 }
 else counter = 0;
 return start_loop_n(counter);
}

int start_loop_file(char *str)
{
 unsigned long p;
 unsigned long counter;
 int ps_f;
 char label;
 char szt[8];
 unsigned cw, dw[33];
 int i, n;
 FILE *file;

 while (*str == '\t' || *str == ' ') str++;
 counter=0;
 if (*str != '\0')
 {  
  if (sscanf(str, "%u", &counter) != 1)
  {
   msg_out(inp_err);
   return 1;
  }
 }
 else counter = 0;
 cw = bcgetw(0);
 n = cw & 0x1F;
 if (n == 0)
   n = 32;
 if (cw & 0x0400)
  file = fopen(szIDataFName, "wt");
 else
  file = fopen(szODataFName, "rt");
 if (file == NULL)
 {
   msg_out(open_err);
   return 1;
 }
 if (counter == 1) goto one_start;
 gotoxy(1, 11);
 textcolor(CYAN);
 printf("Loop start. Press F12 to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 prtscr_flag=0;
 while (counter == 0 || counter > 1)
 {

  if ((cw & 0x0400) == RT_RECEIVE)
  {
    for (i = 0; i < n; ++i)
    {
      if (fgets(szt, 6, file) == 0)
      {
        fseek(file, 0L, SEEK_SET);
        if (fgets(szt, 6, file) == 0)
        {
          msg_out(format_err);
          fclose(file);
          return 1;
        }
      }
      if (szt[0] == '\n')
        break;
      if (szt[0] == ';')
      {
        --i;
        continue;
      }
      if (sscanf(szt, "%X", &dw[i]) != 1)
      {
        msg_out(format_err);
        fclose(file);
        return 1;
      }
    }
    bcputblk(1, dw, n);
  }

  start();

  if ((cw & 0x0400) == RT_TRANSMIT)
  {
    bcgetblk(1, dw, n+1);
    for (i = 0; i <= n; ++i)
    {
      if (fprintf(file, "%04X\n", dw[i]) == EOF)
      {
        msg_out(open_err);
        fclose(file);
        return 1;
      }
    }
    fprintf(file, "\n");
  }

  if (pause1) twait(pause1);
  if (prtscr_flag) break;
  if (err_level && ((to_errors+channel_err+bad_starts) >= err_level)) break;
  if (counter) counter--;
 }
 gotoxy(1, 11);
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  for(i = 76; i != 0; i--)
    putchar(0xCD);
 }
 else
 {
  for(i = 76; i != 0; i--)
    putchar(0xC4);
 }
 textcolor(LIGHTGRAY);
 fflush(stdout);
 ps_f=prtscr_flag;
 prtscr_flag=0;
 fclose(file);

 one_start:
 if (!(err_level && ((to_errors+channel_err+bad_starts) >= err_level)))
  start_1("");
 statistic_out("");
// if ((to_errors+channel_err+bad_starts) <= err_level && !(ps_f && counter)) return 0;
 if ((to_errors+channel_err+bad_starts) == 0L && !(ps_f && counter)) return 0;
 else return 1;
}

int start()
{
 unsigned long p;

 CheckTmkEvent(0);
 int_num[Window[nwin].nTMK] = 0;
//#ifdef LPT_SYN
// set_lpt_data(0xFF);
// set_lpt_data(0);
//#endif
 bcstart(base, ctrl_code[tmkselected()][base]);
 p = biostime(0, 0L);
 do
 {
  CheckTmkEvent(0);
  if (int_num[Window[nwin].nTMK] != 0) return 1;
 }
 while (biostime(0, 0L) - p < 10);
 bc_sw = 0;
 to_errors++;
 return 0;
}

/*void interrupt prtscr_brk(...)
{
 prtscr_flag = 1;
}*/

void cmd_reset(char *str)
{
 if (end_ctrl(str)) return;
 switch (Window[nwin].nMode)
 {
 case BC_MODE:
  bcreset();
  bcdefbase(base);
  if (!avtomat)
   msg_out(bc_reset_ok);
  break;
 case RT_MODE:
  rtreset();
  wr_at(terminal_adr);
  rtdefpage(bram_page);
  rtdefsubaddr(dir, subadr);
  if (!avtomat)
   msg_out(rt_reset_ok);
  break;
 }
}

void msg_out(char *msg)
{
 char tchH;
 gotoxy(1, Window[nwin].nDY);
 textcolor(CYAN);
 cprintf("%s. Press any key...", msg);
 fflush(stdout);
// while (!kbhit());
 bioskey(0);
 tchH = chH;
 if (nwin == nmainwin)
 {
  textcolor(WHITE);
  chH = 0xCD;
 } 
 else
 {
  textcolor(LIGHTGRAY);
  chH = 0xC4;
 } 
 gotoxy(1, Window[nwin].nDY);
 hor_line(Window[nwin].nDX - 2);
 textcolor(LIGHTGRAY);
 fflush(stdout);
 chH = tchH;
}

#ifdef ELCUS
void rd_sw_loop(char *str)
{
 if (end_ctrl(str)) return;
 gotoxy(1, 10);
 textcolor(CYAN);
 printf("Reading State Word Register. Press any key to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 while (kbhit() == 0)
  rt_sw = rtgetstate();
// bioskey(0);
 gotoxy(1, 10);
 clreol();
 rt_out_sw();
 fflush(stdout);
}

void wr_mr_loop(char *str)
{
 if (end_ctrl(str)) return;
 gotoxy(1, 10);
 textcolor(CYAN);
 printf("Writing Mode Register. Press any key to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 while (kbhit() == 0)
  rtunlock();
 fLock=0;
// bioskey(0);
 gotoxy(1, 10);
 clreol();
 fflush(stdout);
}
#endif //def ELCUS

void set_flag(char *str)
{
 if (end_ctrl(str)) return;
 gotoxy(1, 10);
 textcolor(CYAN);
 printf("Writing Flags. Press any key to abort...");
 textcolor(LIGHTGRAY);
 fflush(stdout);
 while (!kbhit())
 {
  if (dir == RT_TRANSMIT)
   rtsetflag();
  else
   rtclrflag();
 }
// bioskey(0);
 gotoxy(1, 10);
 clreol();
 fflush(stdout);
}

void read_sw(char *str)
{
 if (end_ctrl(str)) return;
 rt_sw = rtgetstate();
 rt_out_sw();
 fflush(stdout);
}

void read_sp(char *str)
{
 if (end_ctrl(str)) return;
 rt_sp = inport(aTmkConfig[Window[nmainwin].nTMK].wPorts1+0x8);
 rt_out_sp();
 fflush(stdout);
}

void check_int()
{
 int cx, cy, fRestore, savenwin;

 fRestore = 0;
 savenwin = nwin;
 CheckTmkEvent(0);
 for (nwin = 0; nwin <= nMaxWin; nwin++)
 {
  if (Window[nwin].nMode == RT_MODE && int_num[Window[nwin].nTMK])
  {
   if (Window[nwin].fVisible)
   {
    if (!fRestore)
    {
     fRestore = 1;
     cx=wherex(); cy=wherey();
    }
    fInt = 1;
    select_window(nwin);
    out_inn();
    rt_out_sw();
    fflush(stdout);
    if (!avtomat) msg_out("Interrupt");
    fInt = 0;
    int_num[Window[nwin].nTMK]=0;
   }
  }
 }
 nwin = savenwin;
 if (fRestore)
 {
  select_window(nwin);
  window(1, 1, 80, 25);
  gotoxy(cx, cy);
 }
}

unsigned short in_key()
{
 int key, cx, cy;

 if (enter_mode)
 {
  check_int();
  key=fgetc(cmd_file);
  if (key == EOF || fSkipCmds)
  {
   fclose(cmd_file);
   if (fCmds_f)
   {
    cmds_close_f(ex_fname);
    if (!prtscr_flag)
      cmds_open_f(ex_fname);
   }
   if (fCmds_f)
   {
     check_int();
     key=fgetc(cmd_file);
   }
   else
   {
    if (Window[nwin].nMode == BC_MODE && cmd_count != 1 && --cur_count != 0 && !fSkipCmds)
    {
     cx=wherex(); cy=wherey();
     select_window(nwin);
     gotoxy(59, 2);
     cprintf("%010lu", cur_count);
     window(1, 1, 80, 25);
     gotoxy(cx, cy);
     cmds_open(ex_fname);
     check_int();
     key=fgetc(cmd_file);
    }
    else
    {
     if (Window[nwin].nMode == BC_MODE)
     {
      cx=wherex(); cy=wherey();
      select_window(nwin);
      gotoxy(59, 2);
      cprintf("%010lu", cmd_count);
      window(1, 1, 80, 25);
      gotoxy(cx, cy);
     }
     enter_mode=0;
     fGoto=0;
     fSkipCmds=0;
//     while (kbhit() == 0) check_int();!!!!
     check_int();//temp
     key=bioskey(0);
    }
   }
  }
 }
 else
 {
//  while (kbhit() == 0) check_int();!!!!
  check_int();//temp
  key=bioskey();
 }
 return (unsigned short)key;
}

void in_cmd(char *str)
{
 unsigned short key;
 int fInCmd;
 char ch;

 str_ptr = 0;
 fInCmd = 0;
 do
 {
  if (!fInCmd)
  {
   window(1, 1, 80, 25);
   gotoxy(1, 23);
  
   printf("Command: ");
   cmd_str[str_ptr]='\0';
   cprintf(cmd_str);
   clreol();
   fflush(stdout);
  }
  fInCmd = 0;
  key = in_key();
  if ((key & 0x00FF) && key != GPLUSW)
  {
   if ((key&=0x00FF) < 0x20 && key != CR && key != LF)
   {
    make_ctrl(key);
    continue;
   }
   if(str_ptr > 69) 
    continue;
   key=str[str_ptr++]=/*toupper*/(key&=0x00FF);//temp
   putchar(key);
   fInCmd = 1;
   fflush(stdout);
  }
  else
  {
   window(Window[nwin].nX + 1, Window[nwin].nY, 
           Window[nwin].nX + Window[nwin].nDX - 2, 
           Window[nwin].nY + Window[nwin].nDY - 1);
   make_func(key>>8);
   continue;
  }
 }
 while (key != CR && key != LF);
 str[--str_ptr]='\0';
}

void make_ctrl(unsigned short key)
{
 switch (key)
 {
 case BACKSPACE:
  if (str_ptr != 0)
  {
   --str_ptr;
  }
  break;
 case ESCAPE:
  str_ptr=0;
  break;
 case TAB:
  str_ptr=0;
  nmainwin = !nmainwin;
  CheckTmkEvent(0);
  int_num[Window[0].nTMK] = 0;
  int_num[Window[1].nTMK] = 0;
  select_window(nmainwin);
  all_screen();
  break;
 }
}

void make_func(unsigned short key)
{
 switch (key)
 {
 case UP:
            strcpy(cmd_str, old_cmd);
            str_ptr=strlen(cmd_str);
            break;
 case F01:  switch (Window[nwin].nMode)
            {
            case BC_MODE:
             bc_help("");
             break;
            case RT_MODE:
             rt_help("");
             break;
            }
            break;
 case F02:  buf_edit("");
            break;
 case F03:  CheckTmkEvent(0);
            int_num[Window[nwin].nTMK] = 0;
            switch (Window[nwin].nMode)
            {
            case RT_MODE:
             set_mode(BC_MODE);
             base = 0;
             bcdefbase(0);
             all_screen();
             break;
            case BC_MODE:
             set_mode(RT_MODE);
             cram_page = bram_page = 0;
             rtdefpage(0);
             dir = RT_RECEIVE;
             subadr = 1;
             rtdefsubaddr(dir, subadr);
             all_screen();
             break;
            }
            break;
 case F04:
            str_ptr=0;
            nmainwin = !nmainwin;
            CheckTmkEvent(0);
            int_num[Window[0].nTMK] = 0;
            int_num[Window[1].nTMK] = 0;
            select_window(nmainwin);
            all_screen();
            break;
 case F05:  switch (Window[nwin].nMode)
            {
            case BC_MODE:
             start_loop_file("");
             break;
            case RT_MODE:
             break;
            }
            break;
            break;
 case F06:  switch (Window[nwin].nMode)
            {
            case BC_MODE:
             start_1("");
             break;
            case RT_MODE:
             read_sw("");
             break;
            }
            break;
 case F07:  switch (Window[nwin].nMode)
            {
            case BC_MODE:
             start_loop("");
             break;
            case RT_MODE:
             rtlock(dir, subadr);
             fLock=1;
             break;
            }
            break;
 case F08:  cmd_reset("");
            break;
 case F09:  fields_chg("");
            break;
 case F10:  make_quit("");
            break;
 case GPLUS:if (Window[nwin].nMode == RT_MODE)
            {
             dir = (dir == RT_TRANSMIT) ? RT_RECEIVE : RT_TRANSMIT;
             out_subadr();
             rt_out_ram(dir, subadr);
             fflush(stdout);
            }
            break;
 case PGUP: switch (Window[nwin].nMode)
            {
            case BC_MODE:
             if (base > 0)
             {
              base--;
              out_base();
              out_ctrl_code();
              bc_out_ram(base);
              fflush(stdout);
             }
             break;
            case RT_MODE:
             if (subadr > 0)
             {
              subadr--;
              out_subadr();
              rt_out_ram(dir, subadr);
              fflush(stdout);
             }
            }
            break;
 case PGDN: switch (Window[nwin].nMode)
            {
            case BC_MODE:
             if (base < tmkMaxBase[tmkselected()])
             {
              base++;
              out_base();
              out_ctrl_code();
              bc_out_ram(base);
              fflush(stdout);
             }
             break;
            case RT_MODE:
             if (subadr < 31)
             {
              subadr++;
              out_subadr();
              rt_out_ram(dir, subadr);
              fflush(stdout);
             }
            }
            break;
 }
}