#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "tmkinit.c"

#define RT_ADDR 10 /* RT address */

int i;
unsigned short awBuf[32];

const int fInstMode = 1;
HANDLE hRtEvent;
TTmkEventData tmkEvD;

int nTmk, nRT;
int nMinRT, nNRT, nMaxRT;
unsigned long dwMRT;

TMK_DATA wBase, wMaxBase, wSubAddr, wLen, wState, wStatus;
unsigned long dwGoodStarts = 0, dwBusyStarts = 0, dwErrStarts = 0, dwStatStarts = 0;
unsigned long dwPrinted = 0;

void main(int argc, char *argv[])
{
  if (argc != 3 || sscanf(argv[1], "%d", &nTmk) != 1 || sscanf(argv[2], "%d", &nRT) != 1)
  {
    printf("Usage: mrt4.exe D N\n");
    goto stop;
  }
/* Open driver */
  if (TmkOpen())
  {
    printf("TmkOpen error\n");
    goto stop;
  }
/* Open device */
  dwMRT = mrtconfig(nTmk);
  if (dwMRT == 0)
  {
    printf("mrtconfig error\n");
    goto stop;
  }
  nMinRT = dwMRT & 0xFFFF;
  nNRT = dwMRT >> 16;
  nMaxRT = nMinRT + nNRT - 1;
  if (tmkselect(nTmk))
  {
    printf("mrt tmkselect error\n");
    goto stop;
  }
/* Try to reset in MRT mode */
  if (mrtreset())
  {
    printf("mrtreset error\n");
    goto stop;
  }
/* Try to select RT */
  nRT += nMinRT;
  if (tmkselect(nRT))
  {
    printf("rt tmkselect error\n");
    goto stop;
  }
/* Set RT address, set flag mode, enable data irqs */
  rtdefaddress(RT_ADDR);
  rtdefmode(rtgetmode()|RT_FLAG_MODE);
//  rtdefmode(rtgetmode()&~RT_FLAG_MODE);
  rtdefirqmode(rtgetirqmode()&~RT_DATA_BL);

  for (wSubAddr = 1; wSubAddr <= 30; ++wSubAddr)
  {
/* Ready to receive, not ready to transmit */
    rtdefsubaddr(RT_RECEIVE, wSubAddr);
    rtclrflag();
    rtdefsubaddr(RT_TRANSMIT, wSubAddr);
    rtclrflag();
  }
/* Define event for interrupts */
  hRtEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
  if (!hRtEvent)
  {
    printf("CreateEvent error\n");
    goto stop;
  }
  tmkdefevent(hRtEvent, TRUE);


  while (!kbhit())
  {
/* Wait for an interrupt */
    switch (WaitForSingleObject(hRtEvent, 1000))
    {
    case WAIT_OBJECT_0:
/* New message has arrived */
      ResetEvent(hRtEvent);
      do
      {
/* Get interrupt data */
        tmkgetevd(&tmkEvD);
/* Check interrupt type */
        if (tmkEvD.nInt == 3)
        {
          ++dwGoodStarts;
          wSubAddr = (tmkEvD.rt.wStatus >> 5) &0x1F;
          wLen = tmkEvD.rt.wStatus & 0x1F;
          if (wLen == 0)
            wLen = 32;
          if ((tmkEvD.rt.wStatus & RT_DIR_MASK) == RT_RECEIVE)
          {
/* If we received some data then copy the data from Rx subaddres to */
/* Tx subaddress and process flags */
            if ((rtgetflag(RT_RECEIVE, wSubAddr) & RT_FLAG_MASK) == 0)
            {
              printf("Flag read error\n");
              goto stop;
            }
            rtdefsubaddr(RT_RECEIVE, wSubAddr);
            rtgetblk(0, awBuf, wLen);
            rtclrflag();
            rtdefsubaddr(RT_TRANSMIT, wSubAddr);
            rtputblk(0, awBuf, wLen);
            rtsetflag();
          }
        }
      }
/* Loop while we have not processed all interrupts */
      while (tmkEvD.nInt != 0);
      break;
    case WAIT_TIMEOUT:
/* No new messages */
      printf("\rGood: %ld", dwGoodStarts);
      break;
    default:
      printf("Interrupt wait error\n");
      goto stop;
    }
    if ((dwGoodStarts - dwPrinted) >= 1000)
    {
      printf("\rGood: %ld", dwGoodStarts);
      dwPrinted = dwGoodStarts;
    }
  }
  stop:
  printf("\nGood: %ld\n", dwGoodStarts);
  bcreset();
/* Close all opened things */
  CloseHandle(hRtEvent);
  tmkdone(ALL_TMKS);
  TmkClose();
}
