#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "tmkinit.c"

//#define RT_ADDR 10 /* RT address */

int i;
unsigned short awBuf[32];

const int fInstMode = 1;
HANDLE ahRtEvent[32];
TTmkEventData tmkEvD;
unsigned long dwEvent;

int nTmk, nRT;
int nMinRT, nNRT, nMaxRT;
unsigned long dwMRT;

TMK_DATA wBase, wMaxBase, wSubAddr, wLen, wState, wStatus;
unsigned long dwGoodStarts = 0, dwBusyStarts = 0, dwErrStarts = 0, dwStatStarts = 0;
unsigned long dwPrinted = 0;

void main(int argc, char *argv[])
{
  if (argc != 2 || sscanf(argv[1], "%d", &nTmk) != 1)
  {
    printf("Usage: mrt4am.exe D\n");
    goto stop;
  }
/* Open driver */
  if (TmkOpen())
  {
    printf("TmkOpen error\n");
    goto stop;
  }
/* Open device */
  dwMRT = mrtconfig(nTmk);
  if (dwMRT == 0)
  {
    printf("mrtconfig error\n");
    goto stop;
  }
  nMinRT = dwMRT & 0xFFFF;
  nNRT = dwMRT >> 16;
  nMaxRT = nMinRT + nNRT - 1;
  if (tmkselect(nTmk))
  {
    printf("mrt tmkselect error\n");
    goto stop;
  }
/* Try to reset in MRT mode */
  if (mrtreset())
  {
    printf("mrtreset error\n");
    goto stop;
  }
  for (nRT = nMinRT; nRT <= nMaxRT; ++nRT)
  {
  /* Try to select RT */
    if (tmkselect(nRT))
    {
      printf("rt tmkselect error\n");
      goto stop;
    }
  /* Set RT address, set flag mode, enable data irqs */
    rtdefaddress(nRT%32);
    printf("Setup TMK%d RT%d\n", nRT, nRT%32);
    rtdefmode(rtgetmode()|RT_FLAG_MODE);
  //  rtdefmode(rtgetmode()&~RT_FLAG_MODE);
    rtdefirqmode(rtgetirqmode()&~RT_DATA_BL);

    for (wSubAddr = 1; wSubAddr <= 30; ++wSubAddr)
    {
  /* Ready to receive, not ready to transmit */
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      rtclrflag();
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtclrflag();
    }
  }
/* Define event for interrupts */
  for (nRT = nMinRT; nRT <= nMaxRT; ++nRT)
  {
    ahRtEvent[nRT] = CreateEvent(NULL, TRUE, FALSE, NULL);
    if (!ahRtEvent[nRT])
    {
      printf("CreateEvent error\n");
      goto stop;
    }
    tmkselect(nRT);
    tmkdefevent(ahRtEvent[nRT], TRUE);
  }

  while (!kbhit())
  {
/* Wait for an interrupt */
    dwEvent = WaitForMultipleObjects(nNRT, &(ahRtEvent[nMinRT]), FALSE, 1000) - WAIT_OBJECT_0;
    if (dwEvent < (DWORD)nNRT)
    {
//    case WAIT_OBJECT_0:
/* New message has arrived */
      nRT = dwEvent + nMinRT;
      ResetEvent(ahRtEvent[nRT]);
      do
      {
/* Get interrupt data */
        {
          tmkselect(nRT);
          tmkgetevd(&tmkEvD);
          if (tmkEvD.nInt != 0)
          {
            printf(" Irq%d on RT%d\n", tmkEvD.nInt, nRT%32);
          }
        }
/* Check interrupt type */
        if (tmkEvD.nInt == 3)
        {
          ++dwGoodStarts;
          wSubAddr = (tmkEvD.rt.wStatus >> 5) &0x1F;
          wLen = tmkEvD.rt.wStatus & 0x1F;
          if (wLen == 0)
            wLen = 32;
          if ((tmkEvD.rt.wStatus & RT_DIR_MASK) == RT_RECEIVE)
          {
/* If we received some data then copy the data from Rx subaddres to */
/* Tx subaddress and process flags */
            if ((rtgetflag(RT_RECEIVE, wSubAddr) & RT_FLAG_MASK) == 0)
            {
              printf("Flag read error\n");
              goto stop;
            }
            rtdefsubaddr(RT_RECEIVE, wSubAddr);
            rtgetblk(0, awBuf, wLen);
            rtclrflag();
            rtdefsubaddr(RT_TRANSMIT, wSubAddr);
            rtputblk(0, awBuf, wLen);
            rtsetflag();
          }
        }
      }
/* Loop while we have not processed all interrupts */
      while (tmkEvD.nInt != 0);
    }
    else switch (dwEvent+WAIT_OBJECT_0)
    {
    case WAIT_TIMEOUT:
/* No new messages */
      printf("\rGood: %ld", dwGoodStarts);
      break;
    default:
      printf("Interrupt wait error\n");
      goto stop;
    }
    if ((dwGoodStarts - dwPrinted) >= 1000)
    {
      printf("\rGood: %ld", dwGoodStarts);
      dwPrinted = dwGoodStarts;
    }
  }
  stop:
  printf("\nGood: %ld\n", dwGoodStarts);
  bcreset();
/* Close all opened things */
  for (nRT = nMinRT; nRT <= nMaxRT; ++nRT)
    CloseHandle(ahRtEvent[nRT]);
  tmkdone(ALL_TMKS);
  TmkClose();
}
