{
*****************************************************************************
*      ELCUS, 2003.			                                    *
*      Interface to driver 1553BWDM.SYS for Windows 98/2000/XP              *	           
*****************************************************************************
}
unit WDMTMK2;
interface
uses Windows,SysUtils;

type
 TMK_DATA = word; {unsigned short}

const
 TMK_VERSION_MIN  = $0105; { v1.05 }
 TMK_VERSION      = $0132; { v1.50 }
 MAX_TMK_NUMBER   = 9;
 MIN_TMK_TYPE     = 2;
 MAX_TMK_TYPE     = 6;
 TMK400           = 2;
 TMKMPC           = 3;
 RTMK400          = 4;
 TMKX             = 5;
 TMKXI            = 6;
 ALL_TMKS         = $00FF;
 DATA_BC_RT       = $00;
 DATA_BC_RT_BRCST = $08;
 DATA_RT_BC       = $01;
 DATA_RT_RT       = $02;
 DATA_RT_RT_BRCST = $0A;
 CTRL_C_A         = $03;
 CTRL_C_BRCST     = $0B;
 CTRL_CD_A        = $04;
 CTRL_CD_BRCST    = $0C;
 CTRL_C_AD        = $05;

 BUS_A            = 0;
 BUS_B            = 1;
 BUS_1            = 0;
 BUS_2            = 1;

 S_ERAO_MASK      = $01;
 S_MEO_MASK       = $02;
 S_IB_MASK        = $04;
 S_TO_MASK        = $08;
 S_EM_MASK        = $10;
 S_EBC_MASK       = $20;
 S_DI_MASK        = $40;
 S_ELN_MASK       = $80;
 S_G1_MASK        = $8000;
 S_G2_MASK        = $4000;

 NWORDS_MASK      = $001F;
 CMD_MASK         = $001F;
 SUBADDR_MASK     = $03E0;
 CI_MASK          = $03E0;
 HBIT_MASK        = $0200;
 RT_DIR_MASK      = $0400;
 ADDRESS_MASK     = $F800;
 RTFL_MASK        = $0001;
 DNBA_MASK        = $0002;
 SSFL_MASK        = $0004;
 BUSY_MASK        = $0008;
 BRCST_MASK       = $0010;
 NULL_MASK        = $00E0;
 SREQ_MASK        = $0100;
 ERROR_MASK       = $0400;

 SREQ             = $01;
 BUSY             = $02;
 SSFL             = $04;
 RTFL             = $08;
 DNBA             = $10;

 CWB0             = $20;
 CWB1             = $40;

 BC_MODE          = $00;
 RT_MODE          = $80;
 MT_MODE          = $100;
 UNDEFINED_MODE   = $FFFF;

 RT_TRANSMIT      = $0400;
 RT_RECEIVE       = $0000;

 RT_ERROR_MASK    = $4000;

 RT_FLAG          = $8000;
 RT_FLAG_MASK     = $8000;

 RT_HBIT_MODE     = $0001;
 RT_FLAG_MODE     = $0002;
 RT_BRCST_MODE    = $0004;
 RT_DATA_BL       = $2000;
 RT_GENER1_BL     = $0004;
 RT_GENER2_BL     = $4000;
 BC_GENER1_BL     = $0004;
 BC_GENER2_BL     = $4000;
 MT_GENER1_BL     = $0004;
 MT_GENER2_BL     = $4000;
 TMK_IRQ_OFF      = $8000;

 CX_CC_MASK       = $000F;
 CX_CONT_MASK     = $0010;
 CX_BUS_MASK      = $0020;
 CX_SIG_MASK      = $8000;
 CX_INT_MASK      = $0020;

 CX_CONT          = $0010;
 CX_STOP          = $0000;
 CX_BUS_0         = $0000;
 CX_BUS_A         = $0000;
 CX_BUS_1         = $0020;
 CX_BUS_B         = $0020;
 CX_NOSIG         = $0000;
 CX_SIG           = $8000;
 CX_INT           = $0000;
 CX_NOINT         = $0020;

 SX_NOERR         = 0;
 SX_MEO           = 1;
 SX_TOA           = 2;
 SX_TOD           = 3;
 SX_ELN           = 4;
 SX_ERAO          = 5;
 SX_ESYN          = 6;
 SX_EBC           = 7;

 SX_ERR_MASK      = $0007;
 SX_IB_MASK       = $0008;
 SX_G1_MASK       = $0010;
 SX_G2_MASK       = $0020;
 SX_K2_MASK       = $0100;
 SX_K1_MASK       = $0200;
 SX_SCC_MASK      = $3C00;
 SX_ME_MASK       = $4000;
 SX_BUS_MASK      = $8000;

 SX_BUS_0         = $0000;
 SX_BUS_A         = $0000;
 SX_BUS_1         = $8000;
 SX_BUS_B         = $8000;

 GET_IO_DELAY     = $FFFF;

{/* CMD_ILLEGAL $000*/}
 CMD_DYNAMIC_BUS_CONTROL                             = $400;
 CMD_SYNCHRONIZE                                     = $401;
 CMD_TRANSMIT_STATUS_WORD                            = $402;
 CMD_INITIATE_SELF_TEST                              = $403;
 CMD_TRANSMITTER_SHUTDOWN                            = $404;
 CMD_OVERRIDE_TRANSMITTER_SHUTDOWN                   = $405;
 CMD_INHIBIT_TERMINAL_FLAG_BIT                       = $406;
 CMD_OVERRIDE_INHIBIT_TERMINAL_FLAG_BIT              = $407;
 CMD_RESET_REMOTE_TERMINAL                           = $408;
 CMD_TRANSMIT_VECTOR_WORD                            = $410;
 CMD_SYNCHRONIZE_WITH_DATA_WORD                      = $011;
 CMD_TRANSMIT_LAST_COMMAND_WORD                      = $412;
 CMD_TRANSMIT_BUILT_IN_TEST_WORD                     = $413;

 TMK_BAD_TYPE                                        = 1;
 TMK_BAD_IRQ                                         = 2;
 TMK_BAD_NUMBER                                      = 3;
 BC_BAD_BUS                                          = 4;
 BC_BAD_BASE                                         = 5;
 BC_BAD_LEN                                          = 6;
 RT_BAD_PAGE                                         = 7;
 RT_BAD_LEN                                          = 8;
 RT_BAD_ADDRESS                                      = 9;
 RT_BAD_FUNC                                         = 10;
 BC_BAD_FUNC                                         = 11;
 TMK_BAD_FUNC                                        = 12;

 VTMK_BAD_VERSION                                    = 13;
 VTMK_tmkconfig                                      = 2;
 VTMK_tmkdone                                        = 3;
 VTMK_tmkgetmaxn                                     = 4;
 VTMK_tmkselect                                      = 5;
 VTMK_tmkselected                                    = 6;
 VTMK_tmkgetmode                                     = 7;
 VTMK_tmksetcwbits                                   = 8;
 VTMK_tmkclrcwbits                                   = 9;
 VTMK_tmkgetcwbits                                   = 10;
 VTMK_tmkdefevent                                    = 11;
 VTMK_tmkgetevd                                      = 12;
 VTMK_bcreset                                        = 13;
 VTMK_bc_def_tldw                                    = 14;
 VTMK_bc_enable_di                                   = 15;
 VTMK_bc_disable_di                                  = 16;
 VTMK_bcdefirqmode                                   = 17;
 VTMK_bcgetirqmode                                   = 18;
 VTMK_bcgetmaxbase                                   = 19;
 VTMK_bcdefbase                                      = 20;
 VTMK_bcgetbase                                      = 21;
 VTMK_bcputw                                         = 22;
 VTMK_bcgetw                                         = 23;
 VTMK_bcgetansw                                      = 24;
 VTMK_bcputblk                                       = 25;
 VTMK_bcgetblk                                       = 26;
 VTMK_bcdefbus                                       = 27;
 VTMK_bcgetbus                                       = 28;
 VTMK_bcstart                                        = 29;
 VTMK_bcstartx                                       = 30;
 VTMK_bcdeflink                                      = 31;
 VTMK_bcgetlink                                      = 32;
 VTMK_bcstop                                         = 33;
 VTMK_bcgetstate                                     = 34;
 VTMK_rtreset                                        = 35;
 VTMK_rtdefirqmode                                   = 36;
 VTMK_rtgetirqmode                                   = 37;
 VTMK_rtdefmode                                      = 38;
 VTMK_rtgetmode                                      = 39;
 VTMK_rtgetmaxpage                                   = 40;
 VTMK_rtdefpage                                      = 41;
 VTMK_rtgetpage                                      = 42;
 VTMK_rtdefpagepc                                    = 43;
 VTMK_rtdefpagebus                                   = 44;
 VTMK_rtgetpagepc                                    = 45;
 VTMK_rtgetpagebus                                   = 46;
 VTMK_rtdefaddress                                   = 47;
 VTMK_rtgetaddress                                   = 48;
 VTMK_rtdefsubaddr                                   = 49;
 VTMK_rtgetsubaddr                                   = 50;
 VTMK_rtputw                                         = 51;
 VTMK_rtgetw                                         = 52;
 VTMK_rtputblk                                       = 53;
 VTMK_rtgetblk                                       = 54;
 VTMK_rtsetanswbits                                  = 55;
 VTMK_rtclranswbits                                  = 56;
 VTMK_rtgetanswbits                                  = 57;
 VTMK_rtgetflags                                     = 58;
 VTMK_rtputflags                                     = 59;
 VTMK_rtsetflag                                      = 60;
 VTMK_rtclrflag                                      = 61;
 VTMK_rtgetflag                                      = 62;
 VTMK_rtgetstate                                     = 63;
 VTMK_rtbusy                                         = 64;
 VTMK_rtlock                                         = 65;
 VTMK_rtunlock                                       = 66;
 VTMK_rtgetcmddata                                   = 67;
 VTMK_rtputcmddata                                   = 68;
 VTMK_mtreset                                        = 69;
 VTMK_mtdefirqmode                                   = 70;
 VTMK_mtgetirqmode                                   = 71;
 VTMK_mtgetmaxbase                                   = 72;
 VTMK_mtdefbase                                      = 73;
 VTMK_mtgetbase                                      = 74;
 VTMK_mtputw                                         = 75;
 VTMK_mtgetw                                         = 76;
 VTMK_mtgetsw                                        = 77;
 VTMK_mtputblk                                       = 78;
 VTMK_mtgetblk                                       = 79;
 VTMK_mtstartx                                       = 80;
 VTMK_mtdeflink                                      = 81;
 VTMK_mtgetlink                                      = 82;
 VTMK_mtstop                                         = 83;
 VTMK_mtgetstate                                     = 84;
 VTMK_tmkgetinfo                                     = 85;
 VTMK_GetVersion                                     = 86;





{
//
// Define the method codes for how buffers are passed for I/O and FS controls
//
}

 METHOD_BUFFERED     = 0;
 METHOD_IN_DIRECT    = 1;
 METHOD_OUT_DIRECT   = 2;
 METHOD_NEITHER      = 3;

{
//
// Define the access check value for any access
//
//
// The FILE_READ_ACCESS and FILE_WRITE_ACCESS constants are also defined in
// ntioapi.h as FILE_READ_DATA and FILE_WRITE_DATA. The values for these
// constants *MUST* always be in sync.
//
}


 FILE_ANY_ACCESS    = 0;
 FILE_READ_ACCESS   = ( $0001 );    { file & pipe}
 FILE_WRITE_ACCESS  = ( $0002 );    { file & pipe}

 TMK_KRNLDRVR              = $8000;
{
//
// Macro definition for defining IOCTL and FSCTL function control codes. Note
// that function codes 0-2047 are reserved for Microsoft Corporation, and
// 2048-4095 are reserved for customers.
//
}


 IOCTL_TMK_tmkconfig       = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkconfig+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkdone         = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkdone+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetmaxn      = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetmaxn+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkselect       = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkselect+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkselected     = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkselected+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetmode      = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmksetcwbits    = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmksetcwbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkclrcwbits    = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkclrcwbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetcwbits    = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetcwbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkdefevent     = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkdefevent+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetevd       = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetevd+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcreset         = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcreset+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bc_def_tldw     = ((TMK_KRNLDRVR shl 16) or ((VTMK_bc_def_tldw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bc_enable_di    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bc_enable_di+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bc_disable_di   = ((TMK_KRNLDRVR shl 16) or ((VTMK_bc_disable_di+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdefirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdefirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetmaxbase    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetmaxbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdefbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdefbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcputw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcputw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetansw       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetansw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcputblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcputblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdefbus        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdefbus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetbus        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetbus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcstart         = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcstart+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcstartx        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcstartx+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdeflink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdeflink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetlink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetlink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcstop          = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcstop+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetstate      = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetstate+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtreset         = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtreset+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefmode       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetmode       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetmaxpage    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetmaxpage+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefpage       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefpage+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetpage       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetpage+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefpagepc     = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefpagepc+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefpagebus    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefpagebus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetpagepc     = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetpagepc+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetpagebus    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetpagebus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefaddress    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefaddress+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetaddress    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetaddress+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefsubaddr    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefsubaddr+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetsubaddr    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetsubaddr+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtsetanswbits   = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtsetanswbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtclranswbits   = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtclranswbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetanswbits   = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetanswbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetflags      = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetflags+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputflags      = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputflags+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtsetflag       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtsetflag+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtclrflag       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtclrflag+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetflag       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetflag+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetstate      = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetstate+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtbusy          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtbusy+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtlock          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtlock+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtunlock        = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtunlock+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetcmddata    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetcmddata+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputcmddata    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputcmddata+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtreset         = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtreset+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtdefirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtdefirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetmaxbase    = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetmaxbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtdefbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtdefbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtputw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtputw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetsw         = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetsw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtputblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtputblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtstartx        = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtstartx+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtdeflink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtdeflink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetlink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetlink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtstop          = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtstop+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetstate      = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetstate+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetinfo      = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetinfo+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_GetVersion      = ((TMK_KRNLDRVR shl 16) or ((VTMK_GetVersion+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));





type

 DWORD = LongInt;

 PTmkConfigData = ^TTmkConfigData;
 TTmkConfigData = packed record
   nType: SmallInt;
   szName: array[0..9] of char;
   wPorts1:word;
   wPorts2:word;
   wIrq1:  word;
   wIrq2:  word;
   wIODelay:word;
end;

type
  nbc = record
    wResult:word;
    wAW1:word;
    wAW2:word;
end;

type
  nbcx = record
    wResultX:word;
    wBase:  word;
end;

type
  nrt = record
    wStatus:word;
    wCmd:word;
end;

type
  nmt = record
    wResultX:word;
    wBase:  word;
end;

type

 PTMKEventData = ^TTMKEventData;
 TTmkEventData =  packed record
  nInt:  integer;
  wMode: word;
  case integer of
    0:(bc:nbc;);
    1:(bcx:nbcx;);
    2:(rt:nrt;);
    3:(mt:nmt;);

end;


 var

tmkError:integer;
_VTMK4tmkNumber:integer;
_ahVTMK4Event:array[0..MAX_TMK_NUMBER+1] of THandle;
_hVTMK4VxD:array[0..MAX_TMK_NUMBER+1] of THandle;
TmkMaxNum,TmkCurNum:Word;



{/*****************Definitions***************************/}

 function TmkOpen:DWORD;
 procedure TmkClose;
 function tmkgetmaxn:integer;
 function tmkconfig(tmkNumber:integer):integer;
 function tmkdone(tmkNumber:integer):integer;
 function tmkselect(tmkNumber:integer):integer;
 function tmkselected:integer;
 function tmkgetmode:TMK_DATA;
 procedure tmksetcwbits( tmkSetControl : TMK_DATA);
 procedure tmkclrcwbits( tmkClrControl : TMK_DATA);
 function  tmkgetcwbits:TMK_DATA;
 procedure tmkdefevent(hEvent:tHandle;fEventSet:boolean);
 procedure tmkgetevd( pEvD:PTmkEventData );
 procedure tmkgetinfo(pConfD:PTmkConfigData);
 function bcreset:integer;
 procedure bc_def_tldw( wTLDW:TMK_DATA );
 procedure bc_enable_di;
 procedure bc_disable_di;
 function bcdefirqmode( bcIrqMode : TMK_DATA):integer;
 function bcgetirqmode:TMK_DATA;
 function bcgetmaxbase:TMK_DATA;
 function bcdefbase( bcBasePC : TMK_DATA ):integer;
 function bcgetbase:TMK_DATA;
 procedure bcputw( bcAddr, bcData : TMK_DATA);
 function bcgetw( bcAddr:TMK_DATA ):TMK_DATA;
 function bcgetansw( bcCtrlCode : TMK_DATA):DWORD;
 procedure bcputblk( bcAddr:TMK_DATA; var pcBuffer; cwLength:TMK_DATA );
 procedure bcgetblk( bcAddr:TMK_DATA; var pcBuffer; cwLength:TMK_DATA );
 function bcdefbus( bcBus :TMK_DATA):integer;
 function bcgetbus:TMK_DATA ;
 function bcstart( bcBase, bcCtrlCode :TMK_DATA ):integer;
 function bcstartx( bcBase,bcCtrlCode :TMK_DATA ):integer;
 function bcdeflink( bcBase,bcCtrlCode :TMK_DATA ):integer;
 function bcgetlink:DWORD;
 function bcstop:TMK_DATA;
 function bcgetstate:DWORD;
 function rtreset:integer;
 function rtdefirqmode( rtIrqMode :TMK_DATA):integer;
 function rtgetirqmode:TMK_DATA;
 function rtdefmode(rtMode :TMK_DATA):integer;
 function rtgetmode:TMK_DATA;
 function rtgetmaxpage:TMK_DATA;
 function rtdefpage( rtPage:TMK_DATA ):integer;
 function rtgetpage:TMK_DATA;
 function rtdefpagepc( rtPagePC :TMK_DATA):integer;
 function rtdefpagebus( rtPageBus : TMK_DATA):integer;
 function rtgetpagepc:TMK_DATA;
 function rtgetpagebus:TMK_DATA;
 function rtdefaddress( rtAddress : TMK_DATA):integer;
 function rtgetaddress:TMK_DATA;
 procedure rtdefsubaddr( rtDir, rtSubAddr : TMK_DATA);
 function rtgetsubaddr:TMK_DATA;
 procedure rtputw( rtAddr, rtData :TMK_DATA);
 function rtgetw( rtAddr:TMK_DATA ):TMK_DATA;
 procedure rtputblk( rtAddr:TMK_DATA;var pcBuffer; cwLength:TMK_DATA );
 procedure rtgetblk( rtAddr:TMK_DATA;var pcBuffer; cwLength:TMK_DATA );
 procedure rtsetanswbits(rtSetControl:TMK_DATA);
 procedure rtclranswbits(rtClrControl:TMK_DATA);
 function rtgetanswbits:TMK_DATA;
 procedure rtgetflags( var pcBuffer; rtDir,rtFlagMin,rtFlagMax:TMK_DATA );
 procedure rtputflags( var pcBuffer; rtDir,rtFlagMin,rtFlagMax:TMK_DATA );
 procedure rtsetflag;
 procedure rtclrflag;
 function rtgetflag( rtDir, rtSubAddr :TMK_DATA):TMK_DATA;
 function rtgetstate:TMK_DATA;
 function rtbusy:TMK_DATA;
 procedure rtlock( rtDir, rtSubAddr :TMK_DATA);
 procedure rtunlock;
 function rtgetcmddata( rtBusCommand:TMK_DATA ):TMK_DATA;
 procedure rtputcmddata( rtBusCommand, rtData :TMK_DATA);
 function mtreset:integer;
 function mtgetsw:TMK_DATA;

const
 mtdefirqmode:function( bcIrqMode : TMK_DATA):integer  = bcdefirqmode;
 mtgetirqmode:function:TMK_DATA  = bcgetirqmode;
 mtgetmaxbase:function:TMK_DATA  = bcgetmaxbase;
 mtdefbase:function(bcBasePC:TMK_DATA):integer   = bcdefbase;
 mtgetbase:function:TMK_DATA   = bcgetbase;
 mtputw:procedure(bcAddr,bcData:TMK_DATA)  = bcputw;
 mtgetw:function(bcAddr:TMK_DATA):TMK_DATA  = bcgetw;

 mtputblk:procedure(bcAddr:TMK_DATA;var pcBuffer;cwLength:TMK_DATA)  = bcputblk;
 mtgetblk:procedure(bcAddr:TMK_DATA;var pcBuffer;cwLength:TMK_DATA)  = bcgetblk;
 mtstartx:function(bcBase,bcCtrlCode:TMK_DATA):integer  = bcstartx;
 mtdeflink:function(bcBase,bcCtrlCode:TMK_DATA):integer  = bcdeflink;
 mtgetlink:function:DWORD  = bcgetlink;
 mtstop:function:TMK_DATA  = bcstop;
 mtgetstate:function:DWORD  = bcgetstate;

{
 CW(ADDR,DIR,SUBADDR,NWORDS) (((ADDR)<<11)|(DIR)|((SUBADDR)<<5)|((NWORDS)&$1F))
 CWM(ADDR,COMMAND) (((ADDR)<<11)|(CI_MASK)|(COMMAND))
}

function CW(ADDR,DIR,SUBADDR,NWORDS:TMK_DATA):TMK_DATA;
function CWM(ADDR,COMMAND:TMK_DATA):TMK_DATA;

implementation

function CW(ADDR,DIR,SUBADDR,NWORDS:TMK_DATA):TMK_DATA;
begin
CW:=((ADDR shl 11)or(DIR)or(SUBADDR shl 5)or(NWORDS and $1F));
end;

function CWM(ADDR,COMMAND:TMK_DATA):TMK_DATA;
begin
CWM:=((ADDR shl 11)or(CI_MASK)or(COMMAND));
end;

function TmkOpen:DWORD;

 var
   iTMK,nTMK:integer;
   tmkName:Pchar;
   mstr:string;

begin
 nTmk:=-1;
 for iTMK:=0 to (MAX_TMK_NUMBER-1) do
 begin
   mstr:='\\.\TMK1553BDevice'+inttostr(iTMK);
   //tmkName:=Pchar(mstr);  ,  .
   mstr := mstr+#0;
   tmkName:=StrPCopy(@mstr[1], mstr) ;
   _hVTMK4VxD[iTMK]:=CreateFile( tmkName,
                                GENERIC_READ or GENERIC_WRITE,
                                0,
                                nil,
                                OPEN_EXISTING,
                                FILE_ATTRIBUTE_NORMAL,
                                0);
   if ( _hVTMK4VxD[iTMK] <> INVALID_HANDLE_VALUE )
   then
     nTMK:=iTMK;
 end;

 if (nTMK=-1)
 then
   begin
     TmkOpen := 1;
     Exit;
   end;
 TmkMaxNum:=nTMK;
 for iTMK:=0 to TmkMaxNum do
 begin
   if (_hVTMK4VxD[iTMK] <> INVALID_HANDLE_VALUE)
   then
     begin
       _ahVTMK4Event[iTMK] := 0;
       CloseHandle(_hVTMK4VxD[iTMK]);
       _hVTMK4VxD[iTMK] := 0;
     end;
 end;

 TmkOpen:=0;
end;

procedure TmkClose;
 var
 iTMK:integer;

begin
  if (_hVTMK4VxD[TmkCurNum]<>0)
  then
    begin
      for iTMK:=0 to TmkMaxNum do
      begin
        CloseHandle(_hVTMK4VxD[iTMK]);
        _hVTMK4VxD[iTMK]:= 0;
        _ahVTMK4Event[iTMK]:=0;
      end;
    end;
end;

function tmkgetmaxn:integer;
begin
  tmkgetmaxn:=TmkMaxNum;
end;

function tmkconfig( tmkNumber:integer ):integer;

var
  _awVTMK4InBuf,_awVTMK4OutBuf:array [0..1] of word;
  _cbVTMK4Ret:DWORD;
  tmkName:Pchar;
  mstr:string;
begin
  if(_hVTMK4VxD[tmkNumber]<>0)
  then
    begin
      tmkconfig:=TMK_BAD_NUMBER;
      Exit;
    end;

  mstr:='\\.\TMK1553BDevice'+inttostr(tmkNumber);
  mstr := mstr+#0;
  tmkName:=StrPCopy(@mstr[1], mstr) ;
  _hVTMK4VxD[tmkNumber]:= CreateFile(tmkName,
                                     GENERIC_READ or GENERIC_WRITE,
                                     0,
                                     nil,
                                     OPEN_EXISTING,
                                     FILE_ATTRIBUTE_NORMAL,
                                     0);
  if (_hVTMK4VxD[tmkNumber] = INVALID_HANDLE_VALUE)
  then
    begin
      tmkconfig:=TMK_BAD_NUMBER;
      Exit;
    end
  else
    begin
      _awVTMK4InBuf[0]:= WORD(tmkNumber);
      DeviceIoControl(cardinal(_hVTMK4VxD[tmkNumber]), cardinal(IOCTL_TMK_tmkconfig),  @_awVTMK4InBuf[0], 2,
                      @_awVTMK4OutBuf[0], 2, cardinal(_cbVTMK4Ret), nil);
      if(_awVTMK4OutBuf[0]<>0)
      then
        tmkdone(tmkNumber);
      tmkconfig:= _awVTMK4OutBuf[0];
      Exit;
    end;

end;



function tmkdone( tmkNumber:integer ):integer;
var
 _awVTMK4InBuf,_awVTMK4OutBuf :array [0..1] of word;
 _cbVTMK4Ret:DWORD;
 iTMK:integer;
begin
  if (tmkNumber = ALL_TMKS)
  then
    begin
      for iTMK:= 0 to MAX_TMK_NUMBER do
      begin
        _awVTMK4InBuf[0]:=WORD(iTMK);
        DeviceIoControl(cardinal(_hVTMK4VxD[iTMK]), cardinal(IOCTL_TMK_tmkdone),  @_awVTMK4InBuf[0], 2,
                      @_awVTMK4OutBuf[0], 0, cardinal(_cbVTMK4Ret), nil);
        _ahVTMK4Event[iTMK]:= 0;
        CloseHandle(_hVTMK4VxD[iTMK]);
        _hVTMK4VxD[iTMK]:= 0;
      end;
    end
  else
    if ((tmkNumber >= 0) and (tmkNumber <= MAX_TMK_NUMBER))
    then
      begin
        _awVTMK4InBuf[0]:=WORD(tmkNumber);
        DeviceIoControl(cardinal(_hVTMK4VxD[tmkNumber]), cardinal(IOCTL_TMK_tmkdone),  @_awVTMK4InBuf[0], 2,
                      @_awVTMK4OutBuf[0], 0, cardinal(_cbVTMK4Ret), nil);
           _ahVTMK4Event[tmkNumber]:= 0;
           CloseHandle (_hVTMK4VxD[tmkNumber]);
           _hVTMK4VxD[tmkNumber]:= 0;
      end;
  tmkdone:=0
end;

function tmkselect(tmkNumber:integer):integer;
var
 _awVTMK4InBuf,_awVTMK4OutBuf :array [0..1] of word;
 _cbVTMK4Ret:DWORD;
begin
  if ((_hVTMK4VxD[tmkNumber] <> INVALID_HANDLE_VALUE) and
     (_hVTMK4VxD[tmkNumber] <> 0))
     then
       begin
         TmkCurNum:= tmkNumber;
	 //**************    **********************************************************
	_awVTMK4InBuf[0]:=TmkCurNum;
	DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkselect), @_awVTMK4InBuf[0], 2,
                                 @_awVTMK4OutBuf[0], 2, cardinal(_cbVTMK4Ret), nil);
	tmkselect:=_awVTMK4OutBuf[0];
        Exit;
	//*******************************************************************************************************************
       end
     else
       begin
         tmkselect:= TMK_BAD_NUMBER;
         Exit;
       end;
end;

function tmkselected:integer;
begin
  tmkselected:=TmkCurNum;
end;

function tmkgetmode:TMK_DATA;
var
 _awVTMK4InBuf,_awVTMK4OutBuf :array [0..1] of word;
 _cbVTMK4Ret:DWORD;

begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkgetmode), @_awVTMK4InBuf[0], 0, @_awVTMK4OutBuf[0], 2,
                  cardinal(_cbVTMK4Ret), nil);
  tmkgetmode:=_awVTMK4OutBuf[0];
end;

procedure tmkgetinfo(pConfD:PTmkConfigData);
var
 _awVTMK4InBuf:pointer;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=pConfD;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkgetinfo), @_awVTMK4InBuf, 4,
                  @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);

end;

procedure tmksetcwbits(  tmkSetControl:TMK_DATA );
var
 _awVTMK4InBuf:word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=tmkSetControl;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmksetcwbits), @_awVTMK4InBuf, 2,
                           @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);

end;

procedure tmkclrcwbits( tmkClrControl:TMK_DATA );
var
 _awVTMK4InBuf:word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=tmkClrControl;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkclrcwbits), @_awVTMK4InBuf, 2,
                           @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function tmkgetcwbits:TMK_DATA;
var
 _awVTMK4InBuf:word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkgetcwbits), @_awVTMK4InBuf, 0, @_awVTMK4OutBuf, 2,
                  cardinal(_cbVTMK4Ret), nil);
  tmkgetcwbits:= _awVTMK4OutBuf;
end;

procedure tmkdefevent(hEvent:tHandle;fEventSet:boolean);
var
 _awVTMK4InBuf:array[0..3] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
 hVxDEvent:DWORD;
 iTMK:integer;
begin
  //hVxDEvent := 0;
  if (hEvent <> 0) then
  begin
    for iTMK := 0 to MAX_TMK_NUMBER do
    begin
      if (hEvent = _ahVTMK4Event[iTMK])
      then
        break;
    end;

    if (iTMK > MAX_TMK_NUMBER) then
    begin
      hVxDEvent := DWORD(hEvent);
      _ahVTMK4Event[_VTMK4tmkNumber] := hEvent;
    end;
  end
  else
    begin
      _ahVTMK4Event[_VTMK4tmkNumber] := 0;
      hVxDEvent:= 0;
    end;

 _awVTMK4InBuf[0]:=LOWORD(hVxDEvent);
 _awVTMK4InBuf[1]:=HIWORD(hVxDEvent);
 _awVTMK4InBuf[2]:=byte(fEventSet);
 _awVTMK4InBuf[3]:=0;
 DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkdefevent), @_awVTMK4InBuf[0], 8,
                          @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);

end;

procedure tmkgetevd( pEvD:PTmkEventData );
type
 pInteger=^integer;
var
 _awVTMK4InBuf:word;
 _awVTMK4OutBuf:array[0..5] of word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_tmkgetevd), @_awVTMK4InBuf, 0,
                           @_awVTMK4OutBuf[0], 12, cardinal(_cbVTMK4Ret), nil);
  pEvD^.nInt := pInteger(@_awVTMK4OutBuf[0])^;
  pEvD^.wMode := _awVTMK4OutBuf[2];

  case pEvD^.wMode of

  BC_MODE:
    case pEvD^.nInt of
     1: pEvD^.bc.wResult := _awVTMK4OutBuf[3];
     2: begin
         pEvD^.bc.wResult := _awVTMK4OutBuf[3];
         pEvD^.bc.wAW1    := _awVTMK4OutBuf[4];
         pEvD^.bc.wAW2    := _awVTMK4OutBuf[5];
        end;
     3: begin
         pEvD^.bcx.wResultX := _awVTMK4OutBuf[3];
         pEvD^.bcx.wBase    := _awVTMK4OutBuf[4];
        end;
     4:  pEvD^.bcx.wBase := _awVTMK4OutBuf[3];
    end;
  MT_MODE:
    case pEvD^.nInt of
     3: begin
         pEvD^.mt.wResultX := _awVTMK4OutBuf[3];
         pEvD^.mt.wBase    := _awVTMK4OutBuf[4];
        end;
     4:  pEvD^.mt.wBase := _awVTMK4OutBuf[3];
    end;
  RT_MODE:
    case pEvD^.nInt of
     1:  pEvD^.rt.wCmd    := _awVTMK4OutBuf[3];
     2,3:pEvD^.rt.wStatus := _awVTMK4OutBuf[3];
    end;
  end;
end;

function bcreset:integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  if DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcreset), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then bcreset:=0
  else bcreset:=GetLastError;
end;

procedure bc_def_tldw( wTLDW :TMK_DATA );
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=wTLDW;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bc_def_tldw), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)

end;

procedure bc_enable_di;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bc_enable_di), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)

end;

procedure bc_disable_di;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bc_disable_di), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
end;

function bcdefirqmode( bcIrqMode : TMK_DATA ):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=bcIrqMode;
  if DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcdefirqmode), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then result:=0
  else result:=GetLastError;
end;

function bcgetirqmode:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetirqmode), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  bcgetirqmode:=_awVTMK4OutBuf;
end;

function bcgetmaxbase:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetmaxbase), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);

  bcgetmaxbase:= _awVTMK4OutBuf;
end;

function bcdefbase( bcBasePC : TMK_DATA ):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=bcBasePC;
  if DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcdefbase), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then bcdefbase:=0
  else bcdefbase:=GetLastError;
end;

function bcgetbase:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetbase), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  bcgetbase:= _awVTMK4OutBuf;
end;

procedure bcputw( bcAddr, bcData : TMK_DATA);
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=bcAddr;
  _awVTMK4InBuf[1]:=bcData;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcputw), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function bcgetw(  bcAddr : TMK_DATA):TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=bcAddr;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetw), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  bcgetw:= _awVTMK4OutBuf;
end;


function bcgetansw(  bcCtrlCode : TMK_DATA):DWORD;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:PDWORD;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=bcCtrlCode;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetansw), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 4, cardinal(_cbVTMK4Ret), nil);
  bcgetansw:= _awVTMK4OutBuf^;
end;

procedure bcputblk(bcAddr:TMK_DATA;var pcBuffer; cwLength:TMK_DATA );
var
 _awVTMK4InBuf:packed record
                       BA:word;
                       Buf:pointer;
                       Len:word;
                      end;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf.BA:=bcAddr;
  _awVTMK4InBuf.Buf:=ADDR(pcBuffer);
  _awVTMK4InBuf.Len:=cwLength;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcputblk), @_awVTMK4InBuf, 8,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);

end;

procedure bcgetblk(bcAddr:TMK_DATA;var pcBuffer; cwLength:TMK_DATA );
var
 _awVTMK4InBuf:packed record
                       BA:word;
                       Buf:pointer;
                       Len:word;
                      end;

 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf.BA:=bcAddr;
  _awVTMK4InBuf.Buf:=ADDR(pcBuffer);
  _awVTMK4InBuf.Len:=cwLength;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetblk), @_awVTMK4InBuf, 8,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function bcdefbus(  bcBus:TMK_DATA ):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=bcBus;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcdefbus), @_awVTMK4InBuf, 2,
                               @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then bcdefbus:=0
  else bcdefbus:=GetLastError;
end;

function bcgetbus:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetbus), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  bcgetbus:= _awVTMK4OutBuf;
end;

function bcstart( bcBase, bcCtrlCode:TMK_DATA ):integer;
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=bcBase;
  _awVTMK4InBuf[1]:=bcCtrlCode;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcstart), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then bcstart:=0
  else bcstart:=GetLastError;
end;

function bcstartx( bcBase, bcCtrlCode:TMK_DATA ):integer;
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=bcBase;
  _awVTMK4InBuf[1]:=bcCtrlCode;
  if DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcstartx), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then bcstartx:=0
  else bcstartx:=GetLastError;
end;

function bcdeflink( bcBase, bcCtrlCode:TMK_DATA ):integer;
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=bcBase;
  _awVTMK4InBuf[1]:=bcCtrlCode;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcdeflink), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then bcdeflink:=0
  else bcdeflink:=GetLastError;
end;

function bcgetlink:DWORD;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:^DWORD;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetlink), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 4, cardinal(_cbVTMK4Ret), nil);
  bcgetlink:= _awVTMK4OutBuf^;
end;

function bcstop:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcstop), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  bcstop:= _awVTMK4OutBuf;
end;

function bcgetstate:DWORD;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:^DWORD;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_bcgetstate), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 4, cardinal(_cbVTMK4Ret), nil);
  bcgetstate:=_awVTMK4OutBuf^;
end;

function rtreset:integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  if DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtreset), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtreset:=0
  else rtreset:=GetLastError;
end;

function rtdefirqmode(  rtIrqMode :TMK_DATA):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtIrqMode;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefirqmode), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtdefirqmode:=0
  else rtdefirqmode:=GetLastError;
end;

function rtgetirqmode:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetirqmode), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetirqmode:= _awVTMK4OutBuf;
end;

function rtdefmode( rtMode : TMK_DATA):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtMode;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefmode), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtdefmode:=0
  else rtdefmode:=GetLastError;
end;

function rtgetmode:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetmode), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetmode:= _awVTMK4OutBuf;
end;

function rtgetmaxpage:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetmaxpage), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetmaxpage:= _awVTMK4OutBuf;
end;

function rtdefpage(  rtPage : TMK_DATA):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtPage;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefpage), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtdefpage:=0
  else rtdefpage:=GetLastError;
end;

function rtgetpage:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetpage), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetpage:= _awVTMK4OutBuf;
end;

function rtdefpagepc(  rtPagePC :TMK_DATA):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtPagePC;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefpagepc), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtdefpagepc:=0
  else rtdefpagepc:=GetLastError;
end;

function rtdefpagebus(  rtPageBus :TMK_DATA):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtPageBus;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefpagebus), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtdefpagebus:=0
  else rtdefpagebus:=GetLastError;
end;

function rtgetpagepc:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetpagepc), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetpagepc:= _awVTMK4OutBuf;
end;

function rtgetpagebus:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetpagebus), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetpagebus:= _awVTMK4OutBuf;
end;

function rtdefaddress(  rtAddress :TMK_DATA):integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtAddress;
  if  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefaddress), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then rtdefaddress:=0
  else rtdefaddress:=GetLastError;
end;

function rtgetaddress:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetaddress), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetaddress:= _awVTMK4OutBuf;
end;

procedure rtdefsubaddr( rtDir, rtSubAddr : TMK_DATA);
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=rtDir;
  _awVTMK4InBuf[1]:=rtSubAddr;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtdefsubaddr), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function rtgetsubaddr:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetsubaddr), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetsubaddr :=_awVTMK4OutBuf;
end;

procedure rtputw( rtAddr, rtData : TMK_DATA);
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=rtAddr;
  _awVTMK4InBuf[1]:=rtData;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtputw), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function rtgetw( rtAddr:TMK_DATA ):TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtAddr;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetw), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetw:= _awVTMK4OutBuf;
end;

procedure rtputblk( rtAddr:TMK_DATA;var pcBuffer;cwLength:TMK_DATA);
var
 _awVTMK4InBuf:packed record
                       BA:word;
                       Buf:pointer;
                       Len:word;
                      end;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf.BA:=rtAddr;
  _awVTMK4InBuf.Buf:=ADDR(pcBuffer);
  _awVTMK4InBuf.Len:=cwLength;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtputblk), @_awVTMK4InBuf, 8,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtgetblk( rtAddr:TMK_DATA;var pcBuffer;cwLength:TMK_DATA);
var
 _awVTMK4InBuf:packed record
                       BA:word;
                       Buf:pointer;
                       Len:word;
                      end;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf.BA:=rtAddr;
  _awVTMK4InBuf.Buf:=ADDR(pcBuffer);
  _awVTMK4InBuf.Len:=cwLength;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetblk), @_awVTMK4InBuf, 8,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtsetanswbits(  rtSetControl:TMK_DATA );
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtSetControl;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtsetanswbits), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtclranswbits( rtClrControl:TMK_DATA );
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtClrControl;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtclranswbits), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function rtgetanswbits:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetanswbits), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetanswbits:= _awVTMK4OutBuf;
end;

procedure rtgetflags( var pcBuffer; rtDir, rtFlagMin, rtFlagMax:TMK_DATA );
var
 _awVTMK4InBuf: packed record
                  Buf:pointer;
                  Dir:word;
                  FMin:word;
                  FMax:word;
                end;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf.Buf:=ADDR(pcBuffer);
  _awVTMK4InBuf.Dir:=rtDir;
  _awVTMK4InBuf.FMin:=rtFlagMin;
  _awVTMK4InBuf.FMax:=rtFlagMax;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetflags), @_awVTMK4InBuf, 10,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtputflags( var pcBuffer; rtDir, rtFlagMin, rtFlagMax:TMK_DATA );
var
 _awVTMK4InBuf: packed record
                  Buf:pointer;
                  Dir:word;
                  FMin:word;
                  FMax:word;
                end;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf.Buf:=ADDR(pcBuffer);
  _awVTMK4InBuf.Dir:=rtDir;
  _awVTMK4InBuf.FMin:=rtFlagMin;
  _awVTMK4InBuf.FMax:=rtFlagMax;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtputflags), @_awVTMK4InBuf, 10,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtsetflag;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtsetflag), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtclrflag;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtclrflag), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function rtgetflag(rtDir,rtSubAddr:TMK_DATA):TMK_DATA;
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=rtDir;
  _awVTMK4InBuf[1]:=rtSubAddr;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetflag), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetflag:= _awVTMK4OutBuf;
end;

function rtgetstate:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetstate), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetstate:= _awVTMK4OutBuf;
end;

function rtbusy:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtbusy), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtbusy:= _awVTMK4OutBuf;
end;

procedure rtlock(rtDir,rtSubAddr:TMK_DATA);
var
 _awVTMK4InBuf:array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=rtDir;
  _awVTMK4InBuf[1]:=rtSubAddr;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtlock), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

procedure rtunlock;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtunlock), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function rtgetcmddata( rtBusCommand : TMK_DATA):TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf:=rtBusCommand;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtgetcmddata), @_awVTMK4InBuf, 2,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  rtgetcmddata:= _awVTMK4OutBuf;
end;

procedure rtputcmddata(rtBusCommand, rtData : TMK_DATA);
var
 _awVTMK4InBuf: array[0..1] of word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  _awVTMK4InBuf[0]:=rtBusCommand;
  _awVTMK4InBuf[1]:=rtData;
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_rtputcmddata), @_awVTMK4InBuf, 4,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil);
end;

function mtreset:integer;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  if DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_mtreset), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 0, cardinal(_cbVTMK4Ret), nil)
  then mtreset:=0
  else mtreset:=GetLastError;
end;

function mtgetsw:TMK_DATA;
var
 _awVTMK4InBuf: word;
 _awVTMK4OutBuf:word;
 _cbVTMK4Ret:DWORD;
begin
  DeviceIoControl(cardinal(_hVTMK4VxD[TmkCurNum]), cardinal(IOCTL_TMK_mtgetsw), @_awVTMK4InBuf, 0,
                              @_awVTMK4OutBuf, 2, cardinal(_cbVTMK4Ret), nil);
  mtgetsw:= _awVTMK4OutBuf;
end;


end.


