
/****************************************************************************/
/*      SIMPLTST v1.00 for Microsoft Windows NT. ELCUS, 1999.               */
/*      Performs simple test of functionality of the driver TMK1553B.SYS.   */
/*      Usage:                                                              */
/*        'SIMPLTST.EXE'   - performs test of the card 0,                   */
/*        'SIMPLTST.EXE 0' - performs test of the card 0,                   */
/*        'SIMPLTST.EXE 1' - performs test of the card 1,                   */
/*        etc.                                                              */
/****************************************************************************/

#include <windows.h>
#include <stdio.h>
#include "wdmtmk.h"

unsigned wBase, wAddr, wMaxBase, wPage, wMaxPage, wSubAddr;
int fError, cErrors, fEventResult;
HANDLE hEvent;

TTmkConfigData tmkCfg;
TTmkEventData tmkEvD;

int hTmk;

USHORT awBuf[64];

main(int argc, char *argv[])
{
  if (argc == 1 || sscanf(argv[1], "%d", &hTmk) != 1)
    hTmk = 0;

  hEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
  if (!hEvent)
  {
    printf("CreateEvent() failed!\n");
    goto SimpleTest_Exit;
  }

  if (TmkOpen())
  {
    printf("TmkOpen() failed!\n");
    goto SimpleTest_Exit;
  }
  printf("TmkOpen() successfull!\n");

  //
  //  Tell to the driver the number of the card we want test
  //

  if (tmkconfig(hTmk) != 0)
  {
    printf(
        "tmkconfig() failed!\n"
        "Somebody works with the card %d or this card doesn't exist in Registry\n",
        hTmk
        );
    TmkClose();
    goto SimpleTest_Exit;
  }

  tmkselect(hTmk);

  //
  //  Get and display some information about the selected card
  //

  tmkgetinfo(&tmkCfg);
  printf(
      "Card Number:     %d\n"
      "Card Type:       %d\n"
      "Card Name:       %s\n"
      "Card I/O Ports:  %X-%X",
      hTmk,
      tmkCfg.nType,
      tmkCfg.szName,
      tmkCfg.wPorts1, tmkCfg.wPorts1 + 0xF
      );
  if (tmkCfg.wPorts2 == 0xFFFF)
  {
    printf("\n");
  }
  else
  {
    printf(
        ", %X-%X\n",
        tmkCfg.wPorts2, tmkCfg.wPorts2 + 0xF
        );
  }
  if (tmkCfg.wIrq2 == 0xFF)
  {
    printf(
        "Card Interrupt:  %d\n",
        tmkCfg.wIrq1
        );
  }
  else
  {
    printf(
        "Card Interrupts: %d, %d\n",
        tmkCfg.wIrq1,
        tmkCfg.wIrq2
        );
  }
  printf(
      "Card I/O Delay:  %d\n\n",
      tmkCfg.wIODelay
      );

  cErrors = 0;

  //
  //  Now we'll test onboard RAM in Bus Controller mode
  //

  bcreset();

  wMaxBase = bcgetmaxbase();
  printf("bcMaxBase = %u\n", wMaxBase);

  fError = 0;

  for (wBase = 0; wBase <= wMaxBase; ++wBase)
  {
    bcdefbase(wBase);
    for (wAddr = 0; wAddr <= 63; ++wAddr)
    {
      bcputw(wAddr, wAddr|(wBase<<8));
    }
  }
  for (wBase = 0; wBase <= wMaxBase; ++wBase)
  {
    bcdefbase(wBase);
    for (wAddr = 0; wAddr <= 63; ++wAddr)
    {
      if (bcgetw(wAddr) != (wAddr|(wBase<<8)))
      {
        ++cErrors;
        fError = 1;
      }
    }
  }
  if (!fError)
    printf("bcputw()/bcgetw() test Ok!\n");
  else
    printf("bcputw()/bcgetw() test failed!\n");

  fError = 0;

  for (wBase = 0; wBase <= wMaxBase; ++wBase)
  {
    bcdefbase(wBase);
    for (wAddr = 0; wAddr <= 63; ++wAddr)
    {
      awBuf[63-wAddr] = wBase|(wAddr<<8);
    }
    bcputblk(0, awBuf, 64);
  }
  for (wBase = 0; wBase <= wMaxBase; ++wBase)
  {
    bcdefbase(wBase);
    bcgetblk(0, awBuf, 64);
    for (wAddr = 0; wAddr <= 63; ++wAddr)
    {
      if (awBuf[63-wAddr] != (wBase|(wAddr<<8)))
      {
        ++cErrors;
        fError = 1;
      }
    }
  }
  if (!fError)
    printf("bcputblk()/bcgetblk() test Ok!\n");
  else
    printf("bcputblk()/bcgetblk() test failed!\n");

  //
  //  Now we'll test onboard RAM in Remote Terminal mode
  //

  rtreset();

  wMaxPage = rtgetmaxpage();
  printf("rtMaxPage = %u\n", wMaxPage);

  fError = 0;

  for (wPage = 0; wPage <= wMaxPage; ++wPage)
  {
    rtdefpage(wPage);
    for (wSubAddr = 0; wSubAddr <= 0x1F; ++wSubAddr)
    {
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        rtputw(wAddr, wAddr|(wSubAddr<<8)|(wPage<<13));
      }
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        rtputw(wAddr, (wAddr+32)|(wSubAddr<<8)|(wPage<<13));
      }
    }
  }
  for (wPage = 0; wPage <= wMaxPage; ++wPage)
  {
    rtdefpage(wPage);
    for (wSubAddr = 0; wSubAddr <= 0x1F; ++wSubAddr)
    {
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        if (rtgetw(wAddr) != (wAddr|(wSubAddr<<8)|(wPage<<13)))
        {
          ++cErrors;
          fError = 1;
        }
      }
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        if (rtgetw(wAddr) != ((wAddr+32)|(wSubAddr<<8)|(wPage<<13)))
        {
          ++cErrors;
          fError = 1;
        }
      }
    }
  }
  if (!fError)
    printf("rtputw()/rtgetw() test Ok!\n");
  else
    printf("rtputw()/rtgetw() test failed!\n");

  fError = 0;

  for (wPage = 0; wPage <= wMaxPage; ++wPage)
  {
    rtdefpage(wPage);
    for (wSubAddr = 0; wSubAddr <= 0x1F; ++wSubAddr)
    {
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        awBuf[31-wAddr] = wSubAddr|(wAddr<<8)|(wPage<<13);
      }
      rtputblk(0, awBuf, 32);
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        awBuf[31-wAddr] = (wSubAddr+32)|(wAddr<<8)|(wPage<<13);
      }
      rtputblk(0, awBuf, 32);
    }
  }
  for (wPage = 0; wPage <= wMaxPage; ++wPage)
  {
    rtdefpage(wPage);
    for (wSubAddr = 0; wSubAddr <= 0x1F; ++wSubAddr)
    {
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      rtgetblk(0, awBuf, 32);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        if (awBuf[31-wAddr] != (wSubAddr|(wAddr<<8)|(wPage<<13)))
        {
          ++cErrors;
          fError = 1;
        }
      }
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtgetblk(0, awBuf, 32);
      for (wAddr = 0; wAddr <= 31; ++wAddr)
      {
        if (awBuf[31-wAddr] != ((wSubAddr+32)|(wAddr<<8)|(wPage<<13)))
        {
          ++cErrors;
          fError = 1;
        }
      }
    }
  }
  if (!fError)
    printf("rtputblk()/rtgetblk() test Ok!\n");
  else
    printf("rtputblk()/rtgetblk() test failed!\n");

  printf("Test errors = %d\n\n", cErrors);

  //
  //  Now we'll test interrupt in Bus Controller mode
  //

  bcreset();

  tmkdefevent(hEvent, TRUE);

  //
  //  Get Event Data with the nInt filed == 0 meaning we haven't
  //  unserved interrupts now
  //

  tmkgetevd(&tmkEvD);
  printf("Int: %d\n", tmkEvD.nInt);

  //
  //  Put in the base 0 the message 'SYNCHRONIZE' in broadcast mode
  //

  bcdefbase(0);
  bcputw(0, 0xFFE1);

  //
  //  Start the message from the base 0 with Control Code CTRL_C_BRCST
  //

  bcstart(0, CTRL_C_BRCST);

  //
  //  Waiting for interrupt (one second for example)
  //

  switch (WaitForSingleObject(hEvent,1000))
  {
  case WAIT_OBJECT_0:
    ResetEvent(hEvent);
    printf("We got interrupt!\n");
    break;
  case WAIT_TIMEOUT:
    printf("We didn't get interrupt!\n");
    break;
  default:
    printf("Somebody abandon our interrupt waiting!\n");
    break;
  }

  //
  //  Get Event Data with the nInt filed == 1 meaning we got
  //  normal interrupt from the Bus Controller
  //

  tmkgetevd(&tmkEvD);
  printf("Int: %d\n", tmkEvD.nInt);

  tmkdefevent(0,TRUE);

  tmkdone(ALL_TMKS);
  TmkClose();

  SimpleTest_Exit:

  if (hEvent)
    CloseHandle(hEvent);
}
