unit simpl;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,syncobjs, ComCtrls;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    Edit1: TEdit;
    UpDown1: TUpDown;
    Button1: TButton;
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  hEvent:THANDLE;
  event:TEvent;

implementation

uses WDMTMK;

{$R *.DFM}

procedure TForm1.FormActivate(Sender: TObject);

begin
  event:=TEvent.Create(nil,true,false,'event_TMK');
  hEvent:=event.Handle;
  Memo1.Lines.Add('');
end;

procedure TForm1.Button1Click(Sender: TObject);
const RT_ADDR=10;

var

bc:integer;
tmkEvD:TTmkEventData;
result:TWaitResult;
tmkCfg:TTmkConfigData;
str:string;
wBase,wAddr,wMaxBase,wPage,wMaxPage,wSubAddr:word;
fError,cErrors,fEventResult:integer;
awBuf:array[0..63] of word;
label SimpleTest_Exit;

begin
bc:=UpDown1.Position;
  Memo1.Clear;
  if (TmkOpen=0)
  then
    Memo1.Lines.Add('TmkOpen successfull !')
  else
    begin
      Memo1.Lines.Add('TmkOpen failed !');
      goto SimpleTest_Exit;
    end;

  if (tmkconfig(bc) <> 0)
  then
    begin
      Memo1.Lines.Add('tmkconfig() failed !');
      goto SimpleTest_Exit;
    end
  else
    Memo1.Lines.Add('tmkconfig() successfull !');

  tmkselect(bc);
  tmkgetinfo(@tmkCfg);

  str:='Card Number: '+IntToStr(bc);
  Memo1.Lines.Add(str);
  str:='Card Type: '+IntToStr(tmkCfg.nType);
  Memo1.Lines.Add(str);
  str:='Card Name: '+ String(tmkCfg.szName);
  Memo1.Lines.Add(str);
  str:='Card I/O Ports: '+IntToHex(tmkCfg.wPorts1,4)+' - '+
        IntToHex(tmkCfg.wPorts1+$F,4)+'  ';


  if (tmkCfg.wPorts2 = $FFFF)
  then
  str:=str
  else
    str:=str+IntToHex(tmkCfg.wPorts2,4)+' - '+IntToHex(tmkCfg.wPorts2+$F,4);

  Memo1.Lines.Add(str);

  if (tmkCfg.wIrq2 = $FF)
  then
    str:='Card Interrupt: '+IntToStr(tmkCfg.wIrq1)
  else
    str:='Card Interrupt: '+IntToStr(tmkCfg.wIrq1)+' '+
         IntToStr(tmkCfg.wIrq2);
  Memo1.Lines.Add(str);

  str:='Card I/O Delay: '+intToStr(tmkCfg.wIODelay);
  Memo1.Lines.Add(str);

  //
  //  Now we'll test onboard RAM in Bus Controller mode
  //
  bcreset();
  wMaxBase:=bcgetmaxbase();
  str:='bcMaxBase = '+IntToStr(wMaxBase);
  Memo1.Lines.Add(str);

  cErrors:=0;
  fError:=0;
  for wBase:=0 to wMaxBase do
  begin
    bcdefbase(wBase);
    for wAddr:=0 to 63 do
      bcputw(wAddr, wAddr or (wBase shl 8));
  end;

  for wBase:=0 to wMaxBase do
  begin
    bcdefbase(wBase);
    for wAddr:=0 to 63 do
      if ( bcgetw(wAddr)<>(wAddr or (wBase shl 8)) )
      then
        begin
          cErrors:=cErrors+1;
          fError:=1;
        end;
  end;

  if (fError=0)
  then
    Memo1.Lines.Add('bcputw()/bcgetw() test Ok!')
  else
    Memo1.Lines.Add('bcputw()/bcgetw() test failed!');

  fError:=0;
  for wBase:=0 to wMaxBase do
  begin
    bcdefbase(wBase);
    for wAddr:=0 to 63 do
      awBuf[63-wAddr]:= wBase or (wAddr shl 8);
    bcputblk(0, awBuf, 64);
  end;

  for wBase:=0 to wMaxBase do
  begin
    bcdefbase(wBase);
    bcgetblk(0,awBuf,64);
    for wAddr:=0 to 63 do
      if ( awBuf[63-wAddr]<>(wBase or (wAddr shl 8)) )
      then
        begin
          cErrors:=cErrors+1;
          fError:=1;
        end;
  end;

  if (fError=0)
  then
    Memo1.Lines.Add('bcputblk()/bcgetblk() test Ok!')
  else
    Memo1.Lines.Add('bcputblk()/bcgetblk() test failed!');

  //
  //  Now we'll test onboard RAM in Remote Terminal mode
  //
  rtreset();
  wMaxPage:=rtgetmaxpage();
  str:='rtMaxPage= '+ IntToStr(wMaxPage);
  Memo1.Lines.Add(str);
  fError:=0;

   for wPage:=0 to wMaxPage do
   begin
     rtdefpage(wPage);
     for wSubAddr:=0 to $1F do
     begin
       rtdefsubaddr(RT_RECEIVE, wSubAddr);
       for wAddr:= 0 to 31 do
       begin
         rtputw(wAddr, wAddr or (wSubAddr shl 8) or (wPage shl 13));
       end;
       rtdefsubaddr(RT_TRANSMIT, wSubAddr);
       for wAddr:= 0 to 31 do
       begin
         rtputw(wAddr, (wAddr+32) or (wSubAddr shl 8) or (wPage shl 13));
       end;
     end;
   end;

  for wPage:=0 to wMaxPage do
  begin
    rtdefpage(wPage);
    for wSubAddr:=0 to $1F do
    begin
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      for wAddr:=0 to 31 do
      begin
        if (rtgetw(wAddr) <> (wAddr or (wSubAddr shl 8) or (wPage shl 13)))
        then
          begin
            cErrors:=cErrors+1;
            fError:= 1;
          end;
      end;
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      for wAddr:=0 to 31 do
      begin
        if (rtgetw(wAddr) <> ((wAddr+32) or (wSubAddr shl 8)or (wPage shl 13)))
        then
          begin
            cErrors:=cErrors+1;
            fError:= 1;
          end;

      end;
    end;
  end;

  if (fError=0)
  then
    Memo1.Lines.Add('rtputw()/rtgetw() test Ok!')
  else
    Memo1.Lines.Add('rtputw()/rtgetw() test failed!');

  fError:=0;
  for wPage:= 0 to wMaxPage do
  begin
    rtdefpage(wPage);
    for wSubAddr:= 0 to $1F do
    begin
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      for wAddr:=0 to 31 do
      begin
        awBuf[31-wAddr]:= wSubAddr or (wAddr shl 8) or (wPage shl 13);
      end;
      rtputblk(0, awBuf, 32);
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      for wAddr:=0 to 31 do
      begin
        awBuf[31-wAddr]:= (wSubAddr+32) or (wAddr shl 8) or (wPage shl 13);
      end;
      rtputblk(0, awBuf, 32);
    end;
  end;

  for wPage:=0 to wMaxPage do
  begin
    rtdefpage(wPage);
    for wSubAddr:=0 to $1F do
    begin
      rtdefsubaddr(RT_RECEIVE, wSubAddr);
      rtgetblk(0, awBuf, 32);
      for wAddr:=0 to 31 do
      begin
        if (awBuf[31-wAddr] <> (wSubAddr or (wAddr shl 8) or (wPage shl 13)))
        then
          begin
            cErrors:=cErrors+1;
            fError:=1;
          end;

      end;
      rtdefsubaddr(RT_TRANSMIT, wSubAddr);
      rtgetblk(0, awBuf, 32);
      for wAddr:=0 to 31 do
      begin
        if (awBuf[31-wAddr] <> ((wSubAddr+32) or (wAddr shl 8) or (wPage shl 13)))
        then
          begin
            cErrors:=cErrors+1;
            fError:=1;
          end;  
      end;
    end;
  end;

  if (fError=0)
  then
    Memo1.Lines.Add('rtputblk()/rtgetblk() test Ok!')
  else
    Memo1.Lines.Add('rtputblk()/rtgetblk() test failed!');
  str:='Test errors = '+ IntToStr(cErrors);
  Memo1.Lines.Add(str);

  //
  //  Now we'll test interrupt in Bus Controller mode
  //

  bcreset();

  {event:=TEvent.Create(nil,true,false,'event_TMK');
  hEvent:=event.Handle;}
  tmkdefevent(hEvent,true);

  //
  //  Get Event Data with the nInt filed == 0 meaning we haven't
  //  unserved interrupts now
  //
  tmkgetevd(@tmkEvD);
  str:='Int: '+IntToStr(tmkEvD.nInt);
  Memo1.Lines.Add(str);

  //
  //  Put in the base 0 the message 'SYNCHRONIZE' in broadcast mode
  //

  bcdefbase(0);
  bcputw(0, $FFE1);

  //
  //  Start the message from the base 0 with Control Code CTRL_C_BRCST
  //

  bcstart(0, CTRL_C_BRCST);

  //
  //  Waiting for interrupt (one second for example)
  //
  result:=event.WaitFor(1000);

  if (result=wrSignaled)
  then
    Memo1.Lines.Add('We got interrupt!');
  if (result=wrTimeout)
  then
    Memo1.Lines.Add('We didn''t get interrupt!');
  if (result=wrAbandoned)
  then
    Memo1.Lines.Add('Somebody abandon our interrupt waiting!');
  if (result=WrError)
  then
    Memo1.Lines.Add('An error occurred while waiting!');

  //
  //  Get Event Data with the nInt filed == 1 meaning we got
  //  normal interrupt from the Bus Controller
  //

  tmkgetevd(@tmkEvD);
  str:='Int: '+ IntToStr(tmkEvD.nInt);
  Memo1.Lines.Add(str);

SimpleTest_Exit:

  tmkdefevent(0,TRUE);
  tmkdone(bc);
  TmkClose;


end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
event.Destroy();
end;

end.
