#include <stdafx.h>
#include <windows.h>
#include "Wdmtmk.h"


/****************************************************************************/
/*      ELCUS, 2003.			                                    */
/*      Interface to driver 1553BWDM.SYS for Windows 98/2000/XP	            */
/****************************************************************************/


/*****************Functions***************************/

 DWORD TmkOpen()
{
//  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
//  DWORD _cbVTMK4Ret;

//  DWORD dwErrorCode;
  int iTMK;
  int nTMK = -1;
  char tmkName[20];
  char cc = 0x5c;
  for (iTMK = 0; iTMK < MAX_TMK_NUMBER; ++iTMK)
  {
//     _asm {int 3}
     sprintf (tmkName,"%c%c.%cTMK1553BDevice%d",cc,cc,cc,iTMK);
     _hVTMK4VxD[iTMK] = CreateFile(tmkName,
                   GENERIC_READ | GENERIC_WRITE,
                   0,
                   NULL,
                   OPEN_EXISTING,
                   FILE_ATTRIBUTE_NORMAL,
                   NULL
                   );
     if (_hVTMK4VxD[iTMK] != INVALID_HANDLE_VALUE)
         nTMK = iTMK;
  }
  if (nTMK == -1) 
    return 1;
  TmkMaxNum = nTMK;
  for (iTMK = 0; iTMK <= TmkMaxNum; ++iTMK)
  {
  if (_hVTMK4VxD[iTMK] != INVALID_HANDLE_VALUE) 
    {
        _ahVTMK4Event[iTMK] = 0;
        CloseHandle(_hVTMK4VxD[iTMK]);
        _hVTMK4VxD[iTMK] = 0;
    }
  }

  return 0;
}

 void TmkClose()
{
  int iTMK;
  if (_hVTMK4VxD[TmkCurNum])
    for (iTMK = 0; iTMK <= TmkMaxNum; ++iTMK)
    {
      CloseHandle(_hVTMK4VxD[iTMK]);
      _ahVTMK4Event[iTMK] = 0;
      _hVTMK4VxD[iTMK] = 0;
    }
}

 int tmkgetmaxn()
{
    return TmkMaxNum;
}


 int tmkconfig( int tmkNumber )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[2];
  DWORD _cbVTMK4Ret;
  char tmkName[20];

  if(_hVTMK4VxD[tmkNumber]!=0)
  	return TMK_BAD_NUMBER;

  sprintf (tmkName,"%c%c.%cTMK1553BDevice%d",0x5c,0x5c,0x5c,tmkNumber);
  _hVTMK4VxD[tmkNumber] = CreateFile(tmkName,
                                     GENERIC_READ | GENERIC_WRITE,
                                     0,
                                     NULL,
                                     OPEN_EXISTING,
                                     FILE_ATTRIBUTE_NORMAL,
                                     NULL
                                     );
  if (_hVTMK4VxD[tmkNumber] ==INVALID_HANDLE_VALUE)
    return TMK_BAD_NUMBER;

  else
		{
		_awVTMK4InBuf[0] = (WORD)tmkNumber;
		DeviceIoControl(_hVTMK4VxD[tmkNumber], IOCTL_TMK_tmkconfig, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
		if(_awVTMK4OutBuf[0]!=0) 
			tmkdone(tmkNumber);
		return _awVTMK4OutBuf[0];
		}
}


 int tmkdone( int tmkNumber )
{
WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[2];
DWORD _cbVTMK4Ret;

  int iTMK;
  if (tmkNumber == ALL_TMKS)
  {
    for (iTMK = 0; iTMK <= MAX_TMK_NUMBER; ++iTMK)
    {
		_awVTMK4InBuf[0]=(WORD)iTMK;
		DeviceIoControl(_hVTMK4VxD[iTMK], IOCTL_TMK_tmkdone, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);

        _ahVTMK4Event[iTMK] = 0;
        CloseHandle(_hVTMK4VxD[iTMK]);
        _hVTMK4VxD[iTMK] = 0;
    }
  }
  else if (tmkNumber >= 0 && tmkNumber <= MAX_TMK_NUMBER)
       {
	     _awVTMK4InBuf[0]=(WORD)tmkNumber;
		DeviceIoControl(_hVTMK4VxD[tmkNumber], IOCTL_TMK_tmkdone, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);

           _ahVTMK4Event[tmkNumber] = 0;
           CloseHandle (_hVTMK4VxD[tmkNumber]);
           _hVTMK4VxD[tmkNumber] = 0;
       }
  return 0;

//  _awVTMK4InBuf[0]=(WORD)tmkNumber;
//  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkdone, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}

 int tmkselect( int tmkNumber )
{
  
	WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[2];
  DWORD _cbVTMK4Ret;

  if ((_hVTMK4VxD[tmkNumber] != INVALID_HANDLE_VALUE) &&
     (_hVTMK4VxD[tmkNumber] != 0))
    {
      TmkCurNum = tmkNumber;

	 //**************????????? ??? ????????? ????????????? ????**********************************************************
	_awVTMK4InBuf[0]=TmkCurNum; 
	DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkselect, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
	return _awVTMK4OutBuf[0];
	//*******************************************************************************************************************
    //return 0;
    }
  else 
    return TMK_BAD_NUMBER;
}

 int tmkselected()
{
//  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
//  DWORD _cbVTMK4Ret;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkselected, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
//  return (_VTMK4tmkNumber = (int)(_awVTMK4OutBuf[0]));
  return TmkCurNum;
}
 TMK_DATA tmkgetmode()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkgetmode, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void tmksetcwbits( TMK_DATA tmkSetControl )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=tmkSetControl;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmksetcwbits, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void tmkclrcwbits( TMK_DATA tmkClrControl )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=tmkClrControl;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkclrcwbits, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA tmkgetcwbits()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkgetcwbits, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void tmkdefevent( HANDLE hEvent, BOOL fEventSet )
{
  WORD _awVTMK4InBuf[4], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DWORD hVxDEvent;
  int iTMK;
  if (hEvent != 0)
  {
    for (iTMK = 0; iTMK <= MAX_TMK_NUMBER; ++iTMK)
    {
      if (hEvent == _ahVTMK4Event[iTMK])
        break;
    }
    if (iTMK > MAX_TMK_NUMBER)
    {
      hVxDEvent = (DWORD)hEvent;
      _ahVTMK4Event[_VTMK4tmkNumber] = hEvent;
    }
  }
  else
  {
    hVxDEvent = 0;
    _ahVTMK4Event[_VTMK4tmkNumber] = 0;
  }
  _awVTMK4InBuf[0]=LOWORD(hVxDEvent);
  _awVTMK4InBuf[1]=HIWORD(hVxDEvent);
  _awVTMK4InBuf[2]=LOWORD(fEventSet);
  _awVTMK4InBuf[3]=HIWORD(fEventSet);
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkdefevent, _awVTMK4InBuf, 8, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void tmkgetevd( TTmkEventData *pEvD )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[6];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkgetevd, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 12, &_cbVTMK4Ret, NULL);
  pEvD->nInt = ((DWORD*)(_awVTMK4OutBuf))[0];
  switch (pEvD->wMode = _awVTMK4OutBuf[2])
  {
  case BC_MODE:
    switch (pEvD->nInt)
    {
    case 1:
      pEvD->bc.wResult = _awVTMK4OutBuf[3];
      break;
    case 2:
      pEvD->bc.wResult = _awVTMK4OutBuf[3];
      pEvD->bc.wAW1 = _awVTMK4OutBuf[4];
      pEvD->bc.wAW2 = _awVTMK4OutBuf[5];
      break;
    case 3:
      pEvD->bcx.wResultX = _awVTMK4OutBuf[3];
      pEvD->bcx.wBase = _awVTMK4OutBuf[4];
      break;
    case 4:
      pEvD->bcx.wBase = _awVTMK4OutBuf[3];
      break;
    }
    break;
  case MT_MODE:
    switch (pEvD->nInt)
    {
    case 3:
      pEvD->mt.wResultX = _awVTMK4OutBuf[3];
      pEvD->mt.wBase = _awVTMK4OutBuf[4];
      break;
    case 4:
      pEvD->mt.wBase = _awVTMK4OutBuf[3];
      break;
    }
    break;
  case RT_MODE:
    switch (pEvD->nInt)
    {
    case 1:
      pEvD->rt.wCmd = _awVTMK4OutBuf[3];
      break;
    case 2:
    case 3:
      pEvD->rt.wStatus = _awVTMK4OutBuf[3];
      break;
    }
    break;
  }
}
 void tmkgetinfo(TTmkConfigData *pConfD)
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=LOWORD(pConfD);
  _awVTMK4InBuf[1]=HIWORD(pConfD);
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_tmkgetinfo, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}

/*
void bcdefintnorm( void (* UserNormBC)( TMK_DATA, TMK_DATA, TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefintnorm, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
void bcdefintexc( void (* UserExcBC)( TMK_DATA, TMK_DATA, TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefintexc, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
void bcdefintx( void (* UserXBC)( TMK_DATA, TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefintx, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
void bcdefintsig( void (* UserSigBC)( TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefintsig, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
*/
 int bcreset()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcreset, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 void bc_def_tldw( TMK_DATA wTLDW )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=wTLDW;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bc_def_tldw, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void bc_enable_di()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bc_enable_di, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void bc_disable_di()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bc_disable_di, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 int bcdefirqmode( TMK_DATA bcIrqMode )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcIrqMode;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefirqmode, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA bcgetirqmode()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetirqmode, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 TMK_DATA bcgetmaxbase()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetmaxbase, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 int bcdefbase( TMK_DATA bcBasePC )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcBasePC;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefbase, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA bcgetbase()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetbase, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void bcputw( TMK_DATA bcAddr, TMK_DATA bcData )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcAddr;
  _awVTMK4InBuf[1]=bcData;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcputw, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA bcgetw( TMK_DATA bcAddr )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcAddr;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetw, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 DWORD bcgetansw( TMK_DATA bcCtrlCode )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcCtrlCode;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetansw, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 4, &_cbVTMK4Ret, NULL);
  return (((DWORD*)(_awVTMK4OutBuf))[0]);
}
 void bcputblk( TMK_DATA bcAddr, void *pcBuffer, TMK_DATA cwLength )
{
  WORD _awVTMK4InBuf[4], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcAddr;
  _awVTMK4InBuf[1]=(WORD)(LOWORD(pcBuffer));
  _awVTMK4InBuf[2]=(WORD)(HIWORD(pcBuffer));
  _awVTMK4InBuf[3]=cwLength;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcputblk, _awVTMK4InBuf, 8, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void bcgetblk( TMK_DATA bcAddr, void *pcBuffer, TMK_DATA cwLength )
{
  WORD _awVTMK4InBuf[4], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcAddr;
  _awVTMK4InBuf[1]=(WORD)(LOWORD(pcBuffer));
  _awVTMK4InBuf[2]=(WORD)(HIWORD(pcBuffer));
  _awVTMK4InBuf[3]=cwLength;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetblk, _awVTMK4InBuf, 8, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 int bcdefbus( TMK_DATA bcBus )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcBus;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdefbus, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA bcgetbus()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetbus, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 int bcstart( TMK_DATA bcBase, TMK_DATA bcCtrlCode )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcBase;
  _awVTMK4InBuf[1]=bcCtrlCode;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcstart, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 int bcstartx( TMK_DATA bcBase, TMK_DATA bcCtrlCode )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcBase;
  _awVTMK4InBuf[1]=bcCtrlCode;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcstartx, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 int bcdeflink( TMK_DATA bcBase, TMK_DATA bcCtrlCode )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=bcBase;
  _awVTMK4InBuf[1]=bcCtrlCode;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcdeflink, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 DWORD bcgetlink()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[2];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetlink, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 4, &_cbVTMK4Ret, NULL);
  return (((DWORD*)(_awVTMK4OutBuf))[0]);
}
 TMK_DATA bcstop()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcstop, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 DWORD bcgetstate()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[2];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_bcgetstate, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 4, &_cbVTMK4Ret, NULL);
  return (((DWORD*)(_awVTMK4OutBuf))[0]);
}

/*
void rtdefintcmd( void (* UserCmdRT)( TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefintcmd, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
void rtdefinterr( void (* UserErrRT)( TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefinterr, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
void rtdefintdata( void (* UserDataRT)( TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefintdata, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
*/
 int rtreset()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtreset, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 int rtdefirqmode( TMK_DATA rtIrqMode )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtIrqMode;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefirqmode, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA rtgetirqmode()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetirqmode, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
} 
 int rtdefmode( TMK_DATA rtMode )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtMode;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefmode, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA rtgetmode()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetmode, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 TMK_DATA rtgetmaxpage()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetmaxpage, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 int rtdefpage( TMK_DATA rtPage )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtPage;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefpage, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA rtgetpage()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetpage, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 int rtdefpagepc( TMK_DATA rtPagePC )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtPagePC;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefpagepc, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 int rtdefpagebus( TMK_DATA rtPageBus )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtPageBus;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefpagebus, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA rtgetpagepc()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetpagepc, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 TMK_DATA rtgetpagebus()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetpagebus, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 int rtdefaddress( TMK_DATA rtAddress )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtAddress;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefaddress, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA rtgetaddress()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetaddress, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void rtdefsubaddr( TMK_DATA rtDir, TMK_DATA rtSubAddr)
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtDir;
  _awVTMK4InBuf[1]=rtSubAddr;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtdefsubaddr, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA rtgetsubaddr()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetsubaddr, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void rtputw( TMK_DATA rtAddr, TMK_DATA rtData )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtAddr;
  _awVTMK4InBuf[1]=rtData;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtputw, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA rtgetw( TMK_DATA rtAddr )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtAddr;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetw, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void rtputblk( TMK_DATA rtAddr, void *pcBuffer, TMK_DATA cwLength )
{
  WORD _awVTMK4InBuf[4], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtAddr;
  _awVTMK4InBuf[1]=(WORD)(LOWORD(pcBuffer));
  _awVTMK4InBuf[2]=(WORD)(HIWORD(pcBuffer));
  _awVTMK4InBuf[3]=cwLength;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtputblk, _awVTMK4InBuf, 8, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtgetblk( TMK_DATA rtAddr, void *pcBuffer, TMK_DATA cwLength )
{
  WORD _awVTMK4InBuf[4], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtAddr;
  _awVTMK4InBuf[1]=(WORD)(LOWORD(pcBuffer));
  _awVTMK4InBuf[2]=(WORD)(HIWORD(pcBuffer));
  _awVTMK4InBuf[3]=cwLength;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetblk, _awVTMK4InBuf, 8, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtsetanswbits( TMK_DATA rtSetControl )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtSetControl;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtsetanswbits, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtclranswbits( TMK_DATA rtClrControl )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtClrControl;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtclranswbits, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA rtgetanswbits()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetanswbits, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void rtgetflags( void *pcBuffer, TMK_DATA rtDir, TMK_DATA rtFlagMin, TMK_DATA rtFlagMax )
{
  WORD _awVTMK4InBuf[5], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=(WORD)(LOWORD(pcBuffer));
  _awVTMK4InBuf[1]=(WORD)(HIWORD(pcBuffer));
  _awVTMK4InBuf[2]=rtDir;
  _awVTMK4InBuf[3]=rtFlagMin;
  _awVTMK4InBuf[4]=rtFlagMax;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetflags, _awVTMK4InBuf, 10, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtputflags( void *pcBuffer, TMK_DATA rtDir, TMK_DATA rtFlagMin, TMK_DATA rtFlagMax )
{
  WORD _awVTMK4InBuf[5], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=(WORD)(LOWORD(pcBuffer));
  _awVTMK4InBuf[1]=(WORD)(HIWORD(pcBuffer));
  _awVTMK4InBuf[2]=rtDir;
  _awVTMK4InBuf[3]=rtFlagMin;
  _awVTMK4InBuf[4]=rtFlagMax;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtputflags, _awVTMK4InBuf, 10, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtsetflag()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtsetflag, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtclrflag()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtclrflag, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA rtgetflag( TMK_DATA rtDir, TMK_DATA rtSubAddr )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtDir;
  _awVTMK4InBuf[1]=rtSubAddr;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetflag, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 TMK_DATA rtgetstate()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetstate, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 TMK_DATA rtbusy()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtbusy, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void rtlock( TMK_DATA rtDir, TMK_DATA rtSubAddr )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtDir;
  _awVTMK4InBuf[1]=rtSubAddr;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtlock, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 void rtunlock()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtunlock, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
 TMK_DATA rtgetcmddata( TMK_DATA rtBusCommand )
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtBusCommand;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtgetcmddata, _awVTMK4InBuf, 2, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}
 void rtputcmddata( TMK_DATA rtBusCommand, TMK_DATA rtData )
{
  WORD _awVTMK4InBuf[2], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  _awVTMK4InBuf[0]=rtBusCommand;
  _awVTMK4InBuf[1]=rtData;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_rtputcmddata, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}

/*
void mtdefintx( void (* UserIntXMT)( TMK_DATA, TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_mtdefintx, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
void mtdefintsig( void (* UserSigMT)( TMK_DATA ) )
{
  ;
//  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_mtdefintsig, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL);
}
*/
 int mtreset()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  return (DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_mtreset, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 0, &_cbVTMK4Ret, NULL))?0:GetLastError();
}
 TMK_DATA mtgetsw()
{
  WORD _awVTMK4InBuf[1], _awVTMK4OutBuf[1];
  DWORD _cbVTMK4Ret;
  DeviceIoControl(_hVTMK4VxD[TmkCurNum], IOCTL_TMK_mtgetsw, _awVTMK4InBuf, 0, _awVTMK4OutBuf, 2, &_cbVTMK4Ret, NULL);
  return _awVTMK4OutBuf[0];
}


