{
*****************************************************************************
*      ELCUS, 2003.			                                    *
*      Interface to driver 1553BWDM.SYS for Windows 98/2000/XP              *	           
*****************************************************************************
}
unit WDMTMK;
interface
uses Windows;

type
 TMK_DATA = word; {unsigned short}

const
 TMK_VERSION_MIN  = $0105; { v1.05 }
 TMK_VERSION      = $0132; { v1.50 }
 MAX_TMK_NUMBER   = 9;
 MIN_TMK_TYPE     = 2;
 MAX_TMK_TYPE     = 6;
 TMK400           = 2;
 TMKMPC           = 3;
 RTMK400          = 4;
 TMKX             = 5;
 TMKXI            = 6;
 ALL_TMKS         = $00FF;
 DATA_BC_RT       = $00;
 DATA_BC_RT_BRCST = $08;
 DATA_RT_BC       = $01;
 DATA_RT_RT       = $02;
 DATA_RT_RT_BRCST = $0A;
 CTRL_C_A         = $03;
 CTRL_C_BRCST     = $0B;
 CTRL_CD_A        = $04;
 CTRL_CD_BRCST    = $0C;
 CTRL_C_AD        = $05;

 BUS_A            = 0;
 BUS_B            = 1;
 BUS_1            = 0;
 BUS_2            = 1;

 S_ERAO_MASK      = $01;
 S_MEO_MASK       = $02;
 S_IB_MASK        = $04;
 S_TO_MASK        = $08;
 S_EM_MASK        = $10;
 S_EBC_MASK       = $20;
 S_DI_MASK        = $40;
 S_ELN_MASK       = $80;
 S_G1_MASK        = $8000;
 S_G2_MASK        = $4000;

 NWORDS_MASK      = $001F;
 CMD_MASK         = $001F;
 SUBADDR_MASK     = $03E0;
 CI_MASK          = $03E0;
 HBIT_MASK        = $0200;
 RT_DIR_MASK      = $0400;
 ADDRESS_MASK     = $F800;
 RTFL_MASK        = $0001;
 DNBA_MASK        = $0002;
 SSFL_MASK        = $0004;
 BUSY_MASK        = $0008;
 BRCST_MASK       = $0010;
 NULL_MASK        = $00E0;
 SREQ_MASK        = $0100;
 ERROR_MASK       = $0400;

 SREQ             = $01;
 BUSY             = $02;
 SSFL             = $04;
 RTFL             = $08;
 DNBA             = $10;

 CWB0             = $20;
 CWB1             = $40;

 BC_MODE          = $00;
 RT_MODE          = $80;
 MT_MODE          = $100;
 UNDEFINED_MODE   = $FFFF;

 RT_TRANSMIT      = $0400;
 RT_RECEIVE       = $0000;

 RT_ERROR_MASK    = $4000;

 RT_FLAG          = $8000;
 RT_FLAG_MASK     = $8000;

 RT_HBIT_MODE     = $0001;
 RT_FLAG_MODE     = $0002;
 RT_BRCST_MODE    = $0004;
 RT_DATA_BL       = $2000;
 RT_GENER1_BL     = $0004;
 RT_GENER2_BL     = $4000;
 BC_GENER1_BL     = $0004;
 BC_GENER2_BL     = $4000;
 MT_GENER1_BL     = $0004;
 MT_GENER2_BL     = $4000;
 TMK_IRQ_OFF      = $8000;

 CX_CC_MASK       = $000F;
 CX_CONT_MASK     = $0010;
 CX_BUS_MASK      = $0020;
 CX_SIG_MASK      = $8000;
 CX_INT_MASK      = $0020;

 CX_CONT          = $0010;
 CX_STOP          = $0000;
 CX_BUS_0         = $0000;
 CX_BUS_A         = $0000;
 CX_BUS_1         = $0020;
 CX_BUS_B         = $0020;
 CX_NOSIG         = $0000;
 CX_SIG           = $8000;
 CX_INT           = $0000;
 CX_NOINT         = $0020;

 SX_NOERR         = 0;
 SX_MEO           = 1;
 SX_TOA           = 2;
 SX_TOD           = 3;
 SX_ELN           = 4;
 SX_ERAO          = 5;
 SX_ESYN          = 6;
 SX_EBC           = 7;

 SX_ERR_MASK      = $0007;
 SX_IB_MASK       = $0008;
 SX_G1_MASK       = $0010;
 SX_G2_MASK       = $0020;
 SX_K2_MASK       = $0100;
 SX_K1_MASK       = $0200;
 SX_SCC_MASK      = $3C00;
 SX_ME_MASK       = $4000;
 SX_BUS_MASK      = $8000;

 SX_BUS_0         = $0000;
 SX_BUS_A         = $0000;
 SX_BUS_1         = $8000;
 SX_BUS_B         = $8000;

 GET_IO_DELAY     = $FFFF;

{/* CMD_ILLEGAL $000*/}
 CMD_DYNAMIC_BUS_CONTROL                             = $400;
 CMD_SYNCHRONIZE                                     = $401;
 CMD_TRANSMIT_STATUS_WORD                            = $402;
 CMD_INITIATE_SELF_TEST                              = $403;
 CMD_TRANSMITTER_SHUTDOWN                            = $404;
 CMD_OVERRIDE_TRANSMITTER_SHUTDOWN                   = $405;
 CMD_INHIBIT_TERMINAL_FLAG_BIT                       = $406;
 CMD_OVERRIDE_INHIBIT_TERMINAL_FLAG_BIT              = $407;
 CMD_RESET_REMOTE_TERMINAL                           = $408;
 CMD_TRANSMIT_VECTOR_WORD                            = $410;
 CMD_SYNCHRONIZE_WITH_DATA_WORD                      = $011;
 CMD_TRANSMIT_LAST_COMMAND_WORD                      = $412;
 CMD_TRANSMIT_BUILT_IN_TEST_WORD                     = $413;

 TMK_BAD_TYPE                                        = 1;
 TMK_BAD_IRQ                                         = 2;
 TMK_BAD_NUMBER                                      = 3;
 BC_BAD_BUS                                          = 4;
 BC_BAD_BASE                                         = 5;
 BC_BAD_LEN                                          = 6;
 RT_BAD_PAGE                                         = 7;
 RT_BAD_LEN                                          = 8;
 RT_BAD_ADDRESS                                      = 9;
 RT_BAD_FUNC                                         = 10;
 BC_BAD_FUNC                                         = 11;
 TMK_BAD_FUNC                                        = 12;

 VTMK_BAD_VERSION                                    = 13;
 VTMK_tmkconfig                                      = 2;
 VTMK_tmkdone                                        = 3;
 VTMK_tmkgetmaxn                                     = 4;
 VTMK_tmkselect                                      = 5;
 VTMK_tmkselected                                    = 6;
 VTMK_tmkgetmode                                     = 7;
 VTMK_tmksetcwbits                                   = 8;
 VTMK_tmkclrcwbits                                   = 9;
 VTMK_tmkgetcwbits                                   = 10;
 VTMK_tmkdefevent                                    = 11;
 VTMK_tmkgetevd                                      = 12;
 VTMK_bcreset                                        = 13;
 VTMK_bc_def_tldw                                    = 14;
 VTMK_bc_enable_di                                   = 15;
 VTMK_bc_disable_di                                  = 16;
 VTMK_bcdefirqmode                                   = 17;
 VTMK_bcgetirqmode                                   = 18;
 VTMK_bcgetmaxbase                                   = 19;
 VTMK_bcdefbase                                      = 20;
 VTMK_bcgetbase                                      = 21;
 VTMK_bcputw                                         = 22;
 VTMK_bcgetw                                         = 23;
 VTMK_bcgetansw                                      = 24;
 VTMK_bcputblk                                       = 25;
 VTMK_bcgetblk                                       = 26;
 VTMK_bcdefbus                                       = 27;
 VTMK_bcgetbus                                       = 28;
 VTMK_bcstart                                        = 29;
 VTMK_bcstartx                                       = 30;
 VTMK_bcdeflink                                      = 31;
 VTMK_bcgetlink                                      = 32;
 VTMK_bcstop                                         = 33;
 VTMK_bcgetstate                                     = 34;
 VTMK_rtreset                                        = 35;
 VTMK_rtdefirqmode                                   = 36;
 VTMK_rtgetirqmode                                   = 37;
 VTMK_rtdefmode                                      = 38;
 VTMK_rtgetmode                                      = 39;
 VTMK_rtgetmaxpage                                   = 40;
 VTMK_rtdefpage                                      = 41;
 VTMK_rtgetpage                                      = 42;
 VTMK_rtdefpagepc                                    = 43;
 VTMK_rtdefpagebus                                   = 44;
 VTMK_rtgetpagepc                                    = 45;
 VTMK_rtgetpagebus                                   = 46;
 VTMK_rtdefaddress                                   = 47;
 VTMK_rtgetaddress                                   = 48;
 VTMK_rtdefsubaddr                                   = 49;
 VTMK_rtgetsubaddr                                   = 50;
 VTMK_rtputw                                         = 51;
 VTMK_rtgetw                                         = 52;
 VTMK_rtputblk                                       = 53;
 VTMK_rtgetblk                                       = 54;
 VTMK_rtsetanswbits                                  = 55;
 VTMK_rtclranswbits                                  = 56;
 VTMK_rtgetanswbits                                  = 57;
 VTMK_rtgetflags                                     = 58;
 VTMK_rtputflags                                     = 59;
 VTMK_rtsetflag                                      = 60;
 VTMK_rtclrflag                                      = 61;
 VTMK_rtgetflag                                      = 62;
 VTMK_rtgetstate                                     = 63;
 VTMK_rtbusy                                         = 64;
 VTMK_rtlock                                         = 65;
 VTMK_rtunlock                                       = 66;
 VTMK_rtgetcmddata                                   = 67;
 VTMK_rtputcmddata                                   = 68;
 VTMK_mtreset                                        = 69;
 VTMK_mtdefirqmode                                   = 70;
 VTMK_mtgetirqmode                                   = 71;
 VTMK_mtgetmaxbase                                   = 72;
 VTMK_mtdefbase                                      = 73;
 VTMK_mtgetbase                                      = 74;
 VTMK_mtputw                                         = 75;
 VTMK_mtgetw                                         = 76;
 VTMK_mtgetsw                                        = 77;
 VTMK_mtputblk                                       = 78;
 VTMK_mtgetblk                                       = 79;
 VTMK_mtstartx                                       = 80;
 VTMK_mtdeflink                                      = 81;
 VTMK_mtgetlink                                      = 82;
 VTMK_mtstop                                         = 83;
 VTMK_mtgetstate                                     = 84;
 VTMK_tmkgetinfo                                     = 85;
 VTMK_GetVersion                                     = 86;





{
//
// Define the method codes for how buffers are passed for I/O and FS controls
//
}

 METHOD_BUFFERED     = 0;
 METHOD_IN_DIRECT    = 1;
 METHOD_OUT_DIRECT   = 2;
 METHOD_NEITHER      = 3;

{
//
// Define the access check value for any access
//
//
// The FILE_READ_ACCESS and FILE_WRITE_ACCESS constants are also defined in
// ntioapi.h as FILE_READ_DATA and FILE_WRITE_DATA. The values for these
// constants *MUST* always be in sync.
//
}


 FILE_ANY_ACCESS    = 0;
 FILE_READ_ACCESS   = ( $0001 );    { file & pipe}
 FILE_WRITE_ACCESS  = ( $0002 );    { file & pipe}

 TMK_KRNLDRVR              = $8000;
{
//
// Macro definition for defining IOCTL and FSCTL function control codes. Note
// that function codes 0-2047 are reserved for Microsoft Corporation, and
// 2048-4095 are reserved for customers.
//
}


 IOCTL_TMK_tmkconfig       = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkconfig+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkdone         = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkdone+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetmaxn      = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetmaxn+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkselect       = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkselect+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkselected     = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkselected+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetmode      = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmksetcwbits    = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmksetcwbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkclrcwbits    = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkclrcwbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetcwbits    = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetcwbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkdefevent     = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkdefevent+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetevd       = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetevd+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcreset         = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcreset+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bc_def_tldw     = ((TMK_KRNLDRVR shl 16) or ((VTMK_bc_def_tldw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bc_enable_di    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bc_enable_di+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bc_disable_di   = ((TMK_KRNLDRVR shl 16) or ((VTMK_bc_disable_di+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdefirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdefirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetmaxbase    = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetmaxbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdefbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdefbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcputw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcputw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetansw       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetansw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcputblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcputblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdefbus        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdefbus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetbus        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetbus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcstart         = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcstart+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcstartx        = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcstartx+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcdeflink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcdeflink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetlink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetlink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcstop          = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcstop+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_bcgetstate      = ((TMK_KRNLDRVR shl 16) or ((VTMK_bcgetstate+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtreset         = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtreset+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefmode       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetmode       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetmaxpage    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetmaxpage+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefpage       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefpage+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetpage       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetpage+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefpagepc     = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefpagepc+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefpagebus    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefpagebus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetpagepc     = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetpagepc+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetpagebus    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetpagebus+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefaddress    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefaddress+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetaddress    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetaddress+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtdefsubaddr    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtdefsubaddr+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetsubaddr    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetsubaddr+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtsetanswbits   = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtsetanswbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtclranswbits   = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtclranswbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetanswbits   = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetanswbits+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetflags      = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetflags+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputflags      = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputflags+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtsetflag       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtsetflag+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtclrflag       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtclrflag+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetflag       = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetflag+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetstate      = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetstate+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtbusy          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtbusy+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtlock          = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtlock+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtunlock        = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtunlock+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtgetcmddata    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtgetcmddata+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_rtputcmddata    = ((TMK_KRNLDRVR shl 16) or ((VTMK_rtputcmddata+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtreset         = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtreset+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtdefirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtdefirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetirqmode    = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetirqmode+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetmaxbase    = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetmaxbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtdefbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtdefbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetbase       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetbase+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtputw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtputw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetw          = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetsw         = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetsw+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtputblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtputblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetblk        = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetblk+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtstartx        = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtstartx+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtdeflink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtdeflink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetlink       = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetlink+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtstop          = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtstop+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_mtgetstate      = ((TMK_KRNLDRVR shl 16) or ((VTMK_mtgetstate+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_tmkgetinfo      = ((TMK_KRNLDRVR shl 16) or ((VTMK_tmkgetinfo+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));
 IOCTL_TMK_GetVersion      = ((TMK_KRNLDRVR shl 16) or ((VTMK_GetVersion+$800) shl 2) or (METHOD_NEITHER) or (FILE_ANY_ACCESS shl 14));


type

 DWORD = LongInt;

 PTmkConfigData = ^TTmkConfigData;
 TTmkConfigData = packed record
   nType: SmallInt;
   szName: array[0..9] of char;
   wPorts1:word;
   wPorts2:word;
   wIrq1:  word;
   wIrq2:  word;
   wIODelay:word;
end;

type
  nbc = record
    wResult:word;
    wAW1:word;
    wAW2:word;
end;

type
  nbcx = record
    wResult:word;
    wBase:  word;
end;

type
  nrt = record
    wStatus:word;
    wCmd:word;
end;

type
  nmt = record
    wResult:word;
    wBase:  word;
end;

type

 PTMKEventData = ^TTMKEventData;
 TTmkEventData =  packed record
  nInt:  integer;
  wMode: word;
  case integer of
    0:(bc:nbc;);
    1:(bcx:nbcx;);
    2:(rt:nrt;);
    3:(mt:nmt;);

end;

 {var}

{kError:integer;
_VTMK4tmkNumber:integer;
_ahVTMK4Event:array[0..MAX_TMK_NUMBER] of THandle;
_hVTMK4VxD:array[0..MAX_TMK_NUMBER] of THandle;}
{mkMaxNum:Word;}
{mkCurNumWord:Word;}


{/*****************Definitions***************************/}

 function TmkOpen:DWORD;cdecl;external 'Wdmtmk.dll';
 procedure TmkClose;cdecl;external 'Wdmtmk.dll';
 function tmkgetmaxn:integer;cdecl;external 'Wdmtmk.dll';
 function tmkconfig(tmkNumber:integer):integer;cdecl;external 'Wdmtmk.dll';
 function tmkdone(tmkNumber:integer):integer;cdecl;external 'Wdmtmk.dll';
 function tmkselect(tmkNumber:integer):integer;cdecl;external 'Wdmtmk.dll';
 function tmkselected:integer;cdecl;external 'Wdmtmk.dll';
 function tmkgetmode:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure tmksetcwbits( tmkSetControl : TMK_DATA);cdecl;external 'Wdmtmk.dll';
 procedure tmkclrcwbits( tmkClrControl : TMK_DATA);cdecl;external 'Wdmtmk.dll';
 function  tmkgetcwbits:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure tmkdefevent(hEvent:tHandle;fEventSet:boolean);cdecl;external 'Wdmtmk.dll';
 procedure tmkgetevd( pEvD:PTmkEventData );cdecl;external 'Wdmtmk.dll';
 procedure tmkgetinfo(pConfD:PTmkConfigData);cdecl;external 'Wdmtmk.dll';
 function bcreset:integer;cdecl;external 'Wdmtmk.dll';
 procedure bc_def_tldw( wTLDW:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 procedure bc_enable_di;cdecl;external 'Wdmtmk.dll';
 procedure bc_disable_di;cdecl;external 'Wdmtmk.dll';
 function bcdefirqmode( bcIrqMode : TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function bcgetirqmode:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function bcgetmaxbase:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function bcdefbase( bcBasePC : TMK_DATA ):integer;cdecl;external 'Wdmtmk.dll';
 function bcgetbase:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure bcputw( bcAddr, bcData : TMK_DATA);cdecl;external 'Wdmtmk.dll';
 function bcgetw( bcAddr:TMK_DATA ):TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function bcgetansw( bcCtrlCode : TMK_DATA):DWORD;cdecl;external 'Wdmtmk.dll';
 procedure bcputblk( bcAddr:TMK_DATA; var pcBuffer; cwLength:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 procedure bcgetblk( bcAddr:TMK_DATA; var pcBuffer; cwLength:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 function bcdefbus( bcBus :TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function bcgetbus:TMK_DATA ;cdecl;external 'Wdmtmk.dll';
 function bcstart( bcBase, bcCtrlCode :TMK_DATA ):integer;cdecl;external 'Wdmtmk.dll';
 function bcstartx( bcBase,bcCtrlCode :TMK_DATA ):integer;cdecl;external 'Wdmtmk.dll';
 function bcdeflink( bcBase,bcCtrlCode :TMK_DATA ):integer;cdecl;external 'Wdmtmk.dll';
 function bcgetlink:DWORD;cdecl;external 'Wdmtmk.dll';
 function bcstop:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function bcgetstate:DWORD;cdecl;external 'Wdmtmk.dll';
 function rtreset:integer;cdecl;external 'Wdmtmk.dll';
 function rtdefirqmode( rtIrqMode :TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function rtgetirqmode:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtdefmode(rtMode :TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function rtgetmode:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtgetmaxpage:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtdefpage( rtPage:TMK_DATA ):integer;cdecl;external 'Wdmtmk.dll';
 function rtgetpage:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtdefpagepc( rtPagePC :TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function rtdefpagebus( rtPageBus : TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function rtgetpagepc:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtgetpagebus:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtdefaddress( rtAddress : TMK_DATA):integer;cdecl;external 'Wdmtmk.dll';
 function rtgetaddress:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure rtdefsubaddr( rtDir, rtSubAddr : TMK_DATA);cdecl;external 'Wdmtmk.dll';
 function rtgetsubaddr:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure rtputw( rtAddr, rtData :TMK_DATA);cdecl;external 'Wdmtmk.dll';
 function rtgetw( rtAddr:TMK_DATA ):TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure rtputblk( rtAddr:TMK_DATA;var pcBuffer; cwLength:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 procedure rtgetblk( rtAddr:TMK_DATA;var pcBuffer; cwLength:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 procedure rtsetanswbits(rtSetControl:TMK_DATA);cdecl;external 'Wdmtmk.dll';
 procedure rtclranswbits(rtClrControl:TMK_DATA);cdecl;external 'Wdmtmk.dll';
 function rtgetanswbits:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure rtgetflags( var pcBuffer; rtDir,rtFlagMin,rtFlagMax:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 procedure rtputflags( var pcBuffer; rtDir,rtFlagMin,rtFlagMax:TMK_DATA );cdecl;external 'Wdmtmk.dll';
 procedure rtsetflag;cdecl;external 'Wdmtmk.dll';
 procedure rtclrflag;cdecl;external 'Wdmtmk.dll';
 function rtgetflag( rtDir, rtSubAddr :TMK_DATA):TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtgetstate:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 function rtbusy:TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure rtlock( rtDir, rtSubAddr :TMK_DATA);cdecl;external 'Wdmtmk.dll';
 procedure rtunlock;cdecl;external 'Wdmtmk.dll';
 function rtgetcmddata( rtBusCommand:TMK_DATA ):TMK_DATA;cdecl;external 'Wdmtmk.dll';
 procedure rtputcmddata( rtBusCommand, rtData :TMK_DATA);cdecl;external 'Wdmtmk.dll';
 function mtreset:integer;cdecl;external 'Wdmtmk.dll';
 function mtgetsw:TMK_DATA;cdecl;external 'Wdmtmk.dll';

const
 mtdefirqmode:function( bcIrqMode : TMK_DATA):integer;cdecl = bcdefirqmode;
 mtgetirqmode:function:TMK_DATA;cdecl = bcgetirqmode;
 mtgetmaxbase:function:TMK_DATA;cdecl = bcgetmaxbase;
 mtdefbase:function(bcBasePC:TMK_DATA):integer;cdecl  = bcdefbase;
 mtgetbase:function:TMK_DATA;cdecl  = bcgetbase;
 mtputw:procedure(bcAddr,bcData:TMK_DATA);cdecl = bcputw;
 mtgetw:function(bcAddr:TMK_DATA):TMK_DATA;cdecl = bcgetw;

 mtputblk:procedure(bcAddr:TMK_DATA;var pcBuffer;cwLength:TMK_DATA);cdecl = bcputblk;
 mtgetblk:procedure(bcAddr:TMK_DATA;var pcBuffer;cwLength:TMK_DATA);cdecl = bcgetblk;
 mtstartx:function(bcBase,bcCtrlCode:TMK_DATA):integer;cdecl = bcstartx;
 mtdeflink:function(bcBase,bcCtrlCode:TMK_DATA):integer;cdecl = bcdeflink;
 mtgetlink:function:DWORD;cdecl = bcgetlink;
 mtstop:function:TMK_DATA;cdecl = bcstop;
 mtgetstate:function:DWORD;cdecl = bcgetstate;

{
 CW(ADDR,DIR,SUBADDR,NWORDS) (((ADDR)<<11)|(DIR)|((SUBADDR)<<5)|((NWORDS)&$1F))
 CWM(ADDR,COMMAND) (((ADDR)<<11)|(CI_MASK)|(COMMAND))
}

function CW(ADDR,DIR,SUBADDR,NWORDS:TMK_DATA):TMK_DATA;
function CWM(ADDR,COMMAND:TMK_DATA):TMK_DATA;

implementation

function CW(ADDR,DIR,SUBADDR,NWORDS:TMK_DATA):TMK_DATA;
begin
CW:=((ADDR shl 11)or(DIR)or(SUBADDR shl 5)or(NWORDS and $1F));
end;

function CWM(ADDR,COMMAND:TMK_DATA):TMK_DATA;
begin
CWM:=((ADDR shl 11)or(CI_MASK)or(COMMAND));
end;

end.


