#include <Ph.h>
#include <Pt.h>
#include <Ap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/dispatch.h>
#define EXTLABEL extern
#include "bcrtmain.h"
#include "qnx6tmk.c"


#define CMD_RESET 0x408
#define CMD_SYNC 0x401
#define CMD_SYNC_DATA 0x011
#define CMD_GET_VECTOR 0x410
#define MY_WAIT_EVENT
#define MAX_MT_SIZE 	SHRT_MAX
#define TIMEO  10000

int                 _ind;
char                m_Receiver[80];
char                m_Transmit[80];
char                m_Receive[80];
int                 m_rtAddress;
int	                m_tmkNumber;
int	                m_tmkMode;
unsigned            m_Period;
char                psz[160];
int                 cReceiveLines;
int                 nMaxTMK;
volatile int        nTmkNumber;
volatile unsigned   wTmkMode;
unsigned short      msgRtAddress, msgCtrlCode1, msgCtrlCode2, msgLength, msgCmd, msgResult, msgAW;
int                 msgInt;
int                 fRtSendInProgress, fBcStartDisable;
unsigned short      rtMsgIndex;
unsigned short      wPrevSReq[30];
char*               _Transmitter;
unsigned int        hEvent;

int BcEventTest()
{
 TTmkEventData tmkEvD;
 int result;

 msgCmd = 0xF800+CI_MASK+CMD_RESET;
 bcputw(0,msgCmd);
 bcstart(0,CTRL_C_BRCST);
 if(tmkwaitevents(hEvent, 100) == hEvent)
 {
  tmkgetevd(&tmkEvD);
  result = 1;
 }
 else
 {
  result = 0;
 }
 return result;
}

//-------------------------------------------------------------------------------------

void Responce_Table()
{
 PtAddCallback(wgt, Pt_CB_DESTROYED, OnDestr, 0);
 PtAddCallback(bt[0], Pt_CB_ARM, OnSend, 0);
 PtAddCallback(bt[1], Pt_CB_DISARM, Quit, 0);
 PtAddCallback(bt[2], Pt_CB_DISARM, OnAbout, 0);
 PtAddCallback(sys[0], Pt_CB_TIMER_ACTIVATE, OnTimer, 0);
 PtAddCallback(chk[1], Pt_CB_ARM, OnModebc, 0);
 PtAddCallback(chk[2], Pt_CB_ARM, OnModert, 0);
 PtAddCallback(lb[0],  Pt_CB_TEXT_CHANGED, OnSelchangeTmknumber, 0);
 PtAddCallback(lb[1],  Pt_CB_TEXT_CHANGED, OnSelchangeRtnumber, 0);
 PtAddCallback(txt[0], Pt_CB_TEXT_CHANGED, OnChangePeriod, 0);
 PtAddCallback(txt[1],  Pt_CB_ACTIVATE, OnSend, 0);
// PtAddCallback(sys[1], Pt_CB_TIMER_ACTIVATE, OnSend1, 0);
}

//-------------------------------------------------------------------------------------

int OnDestr(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 PtDestroyWidget(sys[0]);
 if (nTmkNumber >= 0 && nTmkNumber <= 3)
 {
  tmkdone(nTmkNumber);
 }
 TmkClose();
}

//-------------------------------------------------------------------------------------

int Quit(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 PtExit(-1);
}

//-------------------------------------------------------------------------------------

int Init()
{
 m_tmkNumber = -1;
 m_rtAddress = 0;
 m_tmkMode = 0;
 m_Period = 10;


 if (TmkOpen())
 {
  MessageBoxQ("TMK1553B Тест BC<->RT Ошибка", "Нет доступа к драйверу");
  PtExit( -1);
 }

 nMaxTMK = tmkgetmaxn();
 nTmkNumber = m_tmkNumber;
 wTmkMode = m_tmkMode;
 _Transmitter = "";
 cReceiveLines = 0;
 fBcStartDisable = 1;
 fRtSendInProgress = 0;
}

//-------------------------------------------------------------------------------------

//-------------------------------------------------------------------------------------
int OnModebc(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 int             i;
 
 if (wTmkMode != BC_MODE && nTmkNumber != -1)
 {
  bcreset();
  bcdefbase(0);
  {
   for (i=0; i <= 30; ++i)
    wPrevSReq[i] = 0;
  }
  if (!BcEventTest())
  {
   fBcStartDisable = 1;
   MessageBoxQ("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании");
  }
  else
   fBcStartDisable = 0;
  _Transmitter = "";
 }
 wTmkMode = BC_MODE;
}
//-------------------------------------------------------------------------------------
int OnModert(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 if (wTmkMode != RT_MODE && nTmkNumber != -1)
 {
  rtreset();
  rtputcmddata(CMD_GET_VECTOR,0);
  rtclranswbits(0xffff);
  rtdefaddress(m_rtAddress);
  rtdefpage(0);
  rtMsgIndex = 0;
  fRtSendInProgress = 0;
 }
 wTmkMode = RT_MODE;
}
//-------------------------------------------------------------------------------------
int OnSelchangeTmknumber(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 int                             i;
 PtArg_t                         arg;

 fBcStartDisable = 1;
 PtSetArg(&arg, Pt_ARG_TEXT_STRING, 0, 0);
 PtGetResources(widget, 1, &arg);
 
 if((char)(*(char *)arg.value) == '-')
	m_tmkNumber = -1;
 else
	m_tmkNumber = atoi((char*)(arg.value)); 

 if (m_tmkNumber != nTmkNumber)
 {
  if (nTmkNumber != -1)
  {
   tmkdone(nTmkNumber);
  }
  if (m_tmkNumber >= 0 && m_tmkNumber <= 3)
  {
   if (tmkconfig(m_tmkNumber) == 0)
   {
    tmkdone(nTmkNumber);
    tmkselect(m_tmkNumber);
    hEvent = 1 << m_tmkNumber;
    switch (wTmkMode)
    {
     case BC_MODE:
      bcreset();
      bcdefbase(0);
      for (i=0; i <= 30; ++i)
       wPrevSReq[i] = 0;
      if (!BcEventTest())
      {
       fBcStartDisable = 1;
       MessageBoxQ("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании");
      }
      else
      {
       fBcStartDisable = 0;
      }
      _Transmitter = "";
     break;
     case RT_MODE:
      rtreset();
      rtputcmddata(CMD_GET_VECTOR,0);
      rtclranswbits(0xffff);
      rtdefaddress(m_rtAddress);       
      rtdefpage(0);
      rtMsgIndex = 0;
      fRtSendInProgress = 0;
     break;
     case MT_MODE:
      mtreset();
     break;
    }
   }
   else
   {
    m_tmkNumber = -1;
    PtSetArg( &arg, Pt_ARG_CBOX_SEL_ITEM, 5, 0 );
    PtSetResources( widget, 1, &arg );
    MessageBoxQ("TMK1553B Тест BC<->RT Ошибка", "ТМК не может быть выбран");
   }
   nTmkNumber = m_tmkNumber;
  }
  else
  {
   nTmkNumber = m_tmkNumber = -1;
  }
 }
 fBcStartDisable = 0; 
}

//-------------------------------------------------------------------------------------
int OnSelchangeRtnumber(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 PtArg_t               arg;
 
 PtSetArg( &arg, Pt_ARG_TEXT_STRING, 0, 0 );
 PtGetResources( widget, 1, &arg );
 m_rtAddress = atoi((char *)(arg.value)); 

 if (nTmkNumber != -1 && wTmkMode == RT_MODE)
 {
  rtputcmddata(CMD_GET_VECTOR,0);
  rtclranswbits(0xffff);
  rtdefaddress(m_rtAddress);
  rtMsgIndex = 0;
  fRtSendInProgress = 0;
 }
}
//-------------------------------------------------------------------------------------
int OnChangePeriod(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 PtArg_t              arg;
 PtSetArg( &arg, Pt_ARG_TEXT_STRING, 0, 0 );
 PtGetResources( widget, 1, &arg );
 m_Period = atoi((char *)arg.value);
 
 if (m_Period >= 5 && m_Period <= 10000)
  PtSetResource(sys[0], Pt_ARG_TIMER_REPEAT,m_Period, 0);
}

//-------------------------------------------------------------------------------------
int OnSend(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 TTmkEventData                tmkEvD;
 PtMultiTextAttributes_t      attr;
 unsigned short               wSReq,fKK=0;
 PtArg_t                      arg;

 PtSetArg( &arg, Pt_ARG_CBOX_SEL_ITEM, 0, 0 );
 PtGetResources( lb[2], 1, &arg );
 
 if(arg.value==1)
  fKK = 1;
 else if((arg.value > 1) && (arg.value <= 33))
  msgRtAddress = arg.value -2;	

 PtSetArg( &arg, Pt_ARG_TEXT_STRING, 0, 0 );
 PtGetResources( txt[1], 1, &arg );
 sprintf(m_Transmit, "%s",(char *)arg.value);
 msgLength = (div( strlen(m_Transmit), 2).rem ) ? strlen(m_Transmit)/2+1 : strlen(m_Transmit)/2;

 if(nTmkNumber == -1)
  return 1;

 if(fKK) //KK->KK
 {
  sprintf(m_Transmit, "%s%c",(char*)arg.value,'\n');
  PtMultiTextModifyText(txt[2],0,0,-1,(char*)m_Transmit,strlen(m_Transmit),0,0);
  return 0;
 }

 if(wTmkMode == BC_MODE && !fBcStartDisable)
 {
  msgCtrlCode1 = DATA_BC_RT;
  msgCtrlCode2 = CTRL_CD_A;

  if ( (msgLength > 32 ) )
   msgLength = 32;
  msgCmd = (msgRtAddress<<11) + RT_RECEIVE + (0x10<<5) + (msgLength & NWORDS_MASK);
  bcdefbase(0);
  bcputw(0, msgCmd);   
  bcputblk(1, (unsigned short *)m_Transmit, msgLength);
  bcstart(0, msgCtrlCode1);
  if(tmkwaitevents(hEvent, 100) == hEvent)
  {
   tmkgetevd(&tmkEvD);
   msgInt = tmkEvD.nInt;
   msgResult = tmkEvD.bc.wResult;
   if (msgInt == 2)
    msgAW = tmkEvD.bc.wAW1;
  }
  else
  {
   msgInt = 0;
   MessageBoxQEx("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании\nВыход по таймауту...");
  }
  
  msgCmd = (msgRtAddress<<11)+CI_MASK+CMD_SYNC_DATA;
  bcputw(0,msgCmd);
  bcputw(1,0xF800+RT_RECEIVE+msgLength);
  bcstart(0,msgCtrlCode2);

  if(tmkwaitevents(hEvent,100) == hEvent)
  {
   tmkgetevd(&tmkEvD);
   msgInt = tmkEvD.nInt;
   msgResult = tmkEvD.bc.wResult;
   if (msgInt == 2)
    msgAW = tmkEvD.bc.wAW1;
  }
  else
  {
   msgInt = 0;
   MessageBoxQEx("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании\nВыход по таймауту...");
  }
 }
 else if (wTmkMode == RT_MODE && !fRtSendInProgress)
 {
  if ((msgLength   > 32) )
   msgLength = 32;
  if (++rtMsgIndex >= 32)
   rtMsgIndex = 1;
   
  wSReq = (msgRtAddress<<11) + RT_TRANSMIT + (rtMsgIndex<<5) + (msgLength & NWORDS_MASK);
  rtdefsubaddr(RT_TRANSMIT, 0x10);
  rtputblk(0, (unsigned short*)m_Transmit, msgLength);
  rtputcmddata(CMD_GET_VECTOR, wSReq);
  rtsetanswbits(SREQ);
  fRtSendInProgress = 1;
 }
 return 0;
}

//-------------------------------------------------------------------------------------

int OnTimer(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
 char                          str[50];
 PtArg_t                       arg;
 int                           mt_start, mt_end;
 int                           timeout;
 TTmkEventData                 tmkEvD;
 unsigned short                iRtAddress, wSReq, wRtCmdData;
 struct timespec               tp; 
 
 PtSetArg( &arg, Pt_ARG_TEXT_STRING, 0, 0 );
 PtGetResources( txt[2], 1, &arg );
 if(strlen((char *)arg.value) >= MAX_MT_SIZE)
 {
  arg.value=NULL;
  PtSetResources( txt[2], 1, &arg );	
 }

 if (nTmkNumber != -1)
 {
  switch (wTmkMode)
  {
  case BC_MODE:
   if (fBcStartDisable)
    break;
   for (iRtAddress = 0; iRtAddress <= 30; ++iRtAddress)
   {
    msgCmd = (iRtAddress<<11)+CI_MASK+CMD_GET_VECTOR;
    bcputw(0, msgCmd);
    bcstart(0, CTRL_C_AD);
    if(tmkwaitevents(hEvent, 100) == hEvent)
    {
     tmkgetevd(&tmkEvD);
     msgInt = tmkEvD.nInt;
     msgResult = tmkEvD.bc.wResult;
     if (msgInt == 2)
      msgAW = tmkEvD.bc.wAW1;
    }
    else
    {
     msgInt = 0;
     MessageBoxQEx("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании\nВыход по таймауту...");
    }
	
    if(msgInt <= 1 || (msgInt == 2 && (msgResult & S_IB_MASK) == 0))
     continue;
    if (msgInt == 2 && (msgResult == S_IB_MASK) && ((msgAW & ~ADDRESS_MASK) == SREQ_MASK))
    {
     wSReq = bcgetw(2);
     if ( wSReq == wPrevSReq[iRtAddress])
      continue;
     wPrevSReq[iRtAddress] = wSReq;
     if ((wSReq & ADDRESS_MASK) == (msgCmd & ADDRESS_MASK))
     {
      msgCtrlCode1 = DATA_RT_BC;
      msgCmd = (iRtAddress<<11)+RT_TRANSMIT+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      msgCtrlCode2 = 0xFFFF;
     }
     else if ((wSReq & ADDRESS_MASK) == 0xF800)
     {
      msgCtrlCode1 = DATA_RT_RT_BRCST;
      msgCmd = 0xF800+RT_RECEIVE+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      msgCmd = (iRtAddress<<11)+RT_TRANSMIT+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(1, msgCmd);
      msgCtrlCode2 = CTRL_CD_BRCST;
     }
     else 
     {
      msgCtrlCode1 = DATA_RT_RT;
      msgCmd = (wSReq & ADDRESS_MASK)+RT_RECEIVE+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      msgCmd = (iRtAddress<<11)+RT_TRANSMIT+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(1, msgCmd);
      msgCtrlCode2 = CTRL_CD_A;
     }
     bcstart(0, msgCtrlCode1);
     if(tmkwaitevents(hEvent, 100) == hEvent)
     {
      tmkgetevd(&tmkEvD);
      msgInt = tmkEvD.nInt;
      msgResult = tmkEvD.bc.wResult;
      if (msgInt == 2)
       msgAW = tmkEvD.bc.wAW1;
     }
     else
     {
      msgInt = 0;
      MessageBoxQEx("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании\nВыход по таймауту...");
     }
     if (msgCtrlCode2 != 0xFFFF)
     {
      msgCmd = (wSReq & ADDRESS_MASK)+CI_MASK+CMD_SYNC_DATA;
      wRtCmdData = (iRtAddress<<11)+RT_RECEIVE+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      bcputw(1, wRtCmdData);
      bcstart(0, msgCtrlCode2);
      if(tmkwaitevents(hEvent,100) == hEvent)
      {
       tmkgetevd(&tmkEvD);
       msgInt = tmkEvD.nInt;
       msgResult = tmkEvD.bc.wResult;
       if (msgInt == 2)
        msgAW = tmkEvD.bc.wAW1;
      }
      else
      {
       msgInt = 0;
       MessageBoxQEx("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании\nВыход по таймауту...");
      }
     }
     else if (msgInt == 2 && (msgResult == S_IB_MASK) && ((msgAW & ~ADDRESS_MASK) == SREQ_MASK))
     {
      if ((msgLength = wSReq & NWORDS_MASK) == 0)
       msgLength = 32;
      bcgetblk(2,(unsigned short *)(psz),msgLength);
      psz[msgLength*2] = '\0';
   	  PtMultiTextModifyText(txt[2],1,strlen(psz)+1,-1,psz,strlen(psz),0,0);
	  PtMultiTextModifyText(txt[2],0,0,-1,"\n",1,0,0);
     }
     
     msgCmd = (iRtAddress<<11) + CI_MASK + CMD_SYNC_DATA;
     wRtCmdData = (wSReq | RT_TRANSMIT) & ~(ADDRESS_MASK+NWORDS_MASK);
     bcputw(0, msgCmd);
     bcputw(1, wRtCmdData);
     bcstart(0, CTRL_CD_A);
     if(tmkwaitevents(hEvent,100) == hEvent)
     {
      tmkgetevd(&tmkEvD);
      msgInt = tmkEvD.nInt;
      msgResult = tmkEvD.bc.wResult;
      if (msgInt == 2)
       msgAW = tmkEvD.bc.wAW1;
     }
     else
     {
      msgInt = 0;
      MessageBoxQEx("TMK1553B Тест BC<->RT Ошибка","Не получено сообщение о прерывании\nВыход по таймауту...");
     }
    }
   }
  break;
  case RT_MODE:
   do
   {
    if(tmkwaitevents(hEvent, 100) == hEvent)
    {
     do
     {
      tmkgetevd(&tmkEvD);
      if (tmkEvD.nInt == 1)
      {
       switch (tmkEvD.rt.wCmd)
       {
       case CMD_SYNC_DATA:
        if ((wRtCmdData = rtgetcmddata(CMD_SYNC_DATA)) & RT_TRANSMIT)
        {
         rtclranswbits(SREQ);
         fRtSendInProgress = 0;
        }
        else
        {
         if ((msgLength = (wRtCmdData & NWORDS_MASK)) == 0)
          msgLength = 32;
         if ((wRtCmdData & ADDRESS_MASK) != (m_rtAddress<<11))
          rtdefsubaddr(RT_RECEIVE, 0x10);
         else
          rtdefsubaddr(RT_TRANSMIT, 0x10);
         rtgetblk(0,(unsigned short*)(psz),msgLength);
         psz[msgLength*2] = '\0';
    		 PtMultiTextModifyText(txt[2],0,0,-1,psz,strlen(psz),0,0);
		 PtMultiTextModifyText(txt[2],0,0,-1,"\n",1,0,0);
	    }
       break;
//       case CMD_GET_VECTOR:
       default:
        break;
       }//switch (tmkEvD.rt.wCmd)
       
      }//if (tmkEvD.nInt == 1)
     
     
     }
     while (tmkEvD.nInt != 0);
    }
    else
    {     
     tmkEvD.nInt = 0;
    }//switch(WaitForIntPulse(hEvent,0))
   }
   while (tmkEvD.nInt != 0);
  break;
  default:
   break;
  }
 }
}
 
///***** not use in this example************ 

 int OnSend1(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
 {
 static int index;
 PtArg_t arg;
 char str[50];
 if(wTmkMode!=BC_MODE)
	 return 0;
	 
PtSetArg( &arg, Pt_ARG_TEXT_STRING, 0, 0 );
PtGetResources( txt[1], 1, &arg );

index++;
if(index<10)
 sprintf(str,"%s%d",(char*)arg.value,index);
else
{
 memset(str,0,sizeof(str));
 index=0;
 }


//sprintf(str, "%d",tp.tv_nsec);
arg.value = (long)str;
PtSetResources( txt[1], 1, &arg );

OnSend(widget, data, cbinfo);
 }
 
 
int  OnAbout(PtWidget_t * widget, void * data, PtCallbackInfo_t *cbinfo)
{
static char * Elcus_Information = "Тест BC <--> RT\n\
ЗАО \"Электронная компания ЭЛКУС\"\t2003 г.";
MessageBoxQ("О Программе...", Elcus_Information);
} 

void MessageBoxQ(char* tittle, char* mess)
{
PtArg_t arg;
char const *btns[] = {"&OK",};
PtAlert(wgt, NULL,tittle,NULL,mess,NULL,1,btns,NULL,1,1,Pt_BLOCK_ALL|Pt_RELATIVE|Pt_CENTER);
}
 
void MessageBoxQEx(char* tittle, char* mess)
{
char const *btns[] = {"&Continue","&Exit"};
switch(PtAlert(wgt, NULL,tittle,NULL,mess,NULL,2,btns,NULL,1,2,Pt_BLOCK_ALL|Pt_RELATIVE|Pt_CENTER))
	{
	case 2: 
		PtExit(-1);
	break;
	}
}
 
 
