
/****************************************************************************/
/*      QNX6TMK.C v4.10 for QNX6. (c) ELCUS, 2002,2013.                     */
/*      Interface to driver tmk1553b v4.10 for QNX6.                        */
/****************************************************************************/

#ifndef _TMK1553B_
#define _TMK1553B_

#include <stdlib.h>
#include <devctl.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/neutrino.h>

#include "qnx6tmk.h"

#ifdef USE_TMK_ERROR
int tmkError;
#endif

HANDLE _hVTMK4VxD = 0;

/*****************Functions***************************/

int TmkOpen(void)
{
  DWORD _VTMK4Arg;
  int ErrorCode;
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  _hVTMK4VxD = open("/dev/tmk1553b",O_RDONLY);
  if (_hVTMK4VxD < 0)
  {
    ErrorCode = errno;
    _hVTMK4VxD = 0;
    return ErrorCode;
  }
  if ((devctl(_hVTMK4VxD, TMK_IOCGetVersion, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL)) != EOK ||
      _VTMK4Arg < TMK_VERSION_MIN)
  {
    close(_hVTMK4VxD);
    _hVTMK4VxD = 0;
    return VTMK_BAD_VERSION;
  }
  return 0;
}

void TmkClose(void)
{
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  if (_hVTMK4VxD)
  {
    close(_hVTMK4VxD);
    _hVTMK4VxD = 0;
  }
}

int tmkgetmaxn(void)
{
  WORD _VTMK4Arg;
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  devctl(_hVTMK4VxD, TMK_IOCtmkgetmaxn, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return _VTMK4Arg;
}

int tmkconfig(int tmkNumber)
{
  WORD _VTMK4Arg = tmkNumber;
  devctl(_hVTMK4VxD, TMK_IOCtmkconfig, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif
    _VTMK4Arg);
}

int tmkdone(int tmkNumber)
{
  WORD _VTMK4Arg = tmkNumber;
  devctl(_hVTMK4VxD, TMK_IOCtmkdone, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError = 
#endif
    _VTMK4Arg);
}

int tmkselect(int tmkNumber)
{
  WORD _VTMK4Arg = tmkNumber;
  devctl(_hVTMK4VxD, TMK_IOCtmkselect, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError  = 
#endif
    _VTMK4Arg);
}

int tmkselected(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCtmkselected, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return (int)(short)_VTMK4Arg;
}

TMK_DATA_RET tmkgetmode(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCtmkgetmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void tmksetcwbits(TMK_DATA tmkSetControl)
{
  WORD _VTMK4Arg = tmkSetControl;
  devctl(_hVTMK4VxD, TMK_IOCtmksetcwbits, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif
}

void tmkclrcwbits(TMK_DATA tmkClrControl)
{
  WORD _VTMK4Arg = tmkClrControl;
  devctl(_hVTMK4VxD, TMK_IOCtmksetcwbits, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

TMK_DATA_RET tmkgetcwbits(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCtmkgetcwbits, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int tmkwaitevents(int maskEvents, int fWait)
{
  int _VTMK4Arg[2];
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  _VTMK4Arg[0] = maskEvents;
  _VTMK4Arg[1] = fWait;
  devctl(_hVTMK4VxD, TMK_IOCtmkwaitevents, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return _VTMK4Arg[0];
}

int tmkwaiteventsm(int cEvents, void *pEvents, int fWait)
{
  WORD* _VTMK4Arg;
  int nBufSize;
  int nRet;
/*
  _awVTMK4InBuf[0] = cEvents;
  _awVTMK4InBuf[1] = fWait;
  _awVTMK4InBuf[2] = (WORD)(LOWORD(pEvents));
  _awVTMK4InBuf[3] = (WORD)(HIWORD(pEvents));
*/
  nBufSize = (sizeof(WORD)*cEvents + sizeof(int)*2);
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return 0;
  ((int*)_VTMK4Arg)[0] = cEvents;
  ((int*)_VTMK4Arg)[1] = fWait;
  memcpy(_VTMK4Arg + 4, pEvents, sizeof(WORD)*cEvents);
//  *((DWORD*)_VTMK4Arg) = (DWORD)(cEvents & 0xFFFF) | ((DWORD)fWait << 16);
//  _VTMK4Arg[1] = (ULONG)pEvents;
  devctl(_hVTMK4VxD, TMK_IOCtmkwaiteventsm, _VTMK4Arg, nBufSize, NULL);
  memcpy(pEvents, _VTMK4Arg + 4, sizeof(WORD)*cEvents);
  nRet = *((int*)_VTMK4Arg);
  free(_VTMK4Arg);
  return nRet;
}

/*
void tmkdefevent(HANDLE hEvent, BOOL fEventSet)
{
  WORD _awVTMK4InBuf[4], _awVTMK4OutBuf[1];
  int _VTMK4Arg;
  DWORD hVxDEvent;
  int iTMK;
  if (hEvent != 0)
  {
    for (iTMK = 0; iTMK <= MAX_TMK_NUMBER; ++iTMK)
    {
      if (hEvent == _ahVTMK4Event[iTMK])
        break;
    }
    if (iTMK > MAX_TMK_NUMBER)
    {
      hVxDEvent = (DWORD)hEvent;
      _ahVTMK4Event[_VTMK4tmkNumber] = hEvent;
    }
  }
  else
  {
    hVxDEvent = 0;
    _ahVTMK4Event[_VTMK4tmkNumber] = 0;
  }
  _awVTMK4InBuf[0] = LOWORD(hVxDEvent);
  _awVTMK4InBuf[1] = HIWORD(hVxDEvent);
  _awVTMK4InBuf[2] = LOWORD(fEventSet);
  _awVTMK4InBuf[3] = HIWORD(fEventSet);
  ioctl(_hVTMK4VxD, TMK_IOCtmkdefevent, _awVTMK4InBuf, 8, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
*/

void tmkgetevd(TTmkEventData *pEvD)
{
  WORD _awVTMK4OutBuf[8];
//  int _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCtmkgetevd, _awVTMK4OutBuf, sizeof(_awVTMK4OutBuf), NULL);
#ifdef USE_TMK_ERROR
  tmkError =  ((DWORD*)_awVTMK4OutBuf)[3];
#endif  
  pEvD->nInt = ((DWORD*)(_awVTMK4OutBuf))[0];
  switch (pEvD->wMode = _awVTMK4OutBuf[2])
  {
  case BC_MODE:
    switch (pEvD->nInt)
    {
    case 1:
      pEvD->bc.wResult = _awVTMK4OutBuf[3];
      break;
    case 2:
      pEvD->bc.wResult = _awVTMK4OutBuf[3];
      pEvD->bc.wAW1 = _awVTMK4OutBuf[4];
      pEvD->bc.wAW2 = _awVTMK4OutBuf[5];
      break;
    case 3:
      pEvD->bcx.wResultX = _awVTMK4OutBuf[3];
      pEvD->bcx.wBase = _awVTMK4OutBuf[4];
      break;
    case 4:
      pEvD->bcx.wBase = _awVTMK4OutBuf[3];
      break;
    }
    break;
  case MT_MODE:
    switch (pEvD->nInt)
    {
    case 3:
      pEvD->mt.wResultX = _awVTMK4OutBuf[3];
      pEvD->mt.wBase = _awVTMK4OutBuf[4];
      break;
    case 4:
      pEvD->mt.wBase = _awVTMK4OutBuf[3];
      break;
    }
    break;
  case RT_MODE:
    switch (pEvD->nInt)
    {
    case 1:
      pEvD->rt.wCmd = _awVTMK4OutBuf[3];
      pEvD->rt.wBuf = _awVTMK4OutBuf[4];
      break;
    case 2:
    case 3:
      pEvD->rt.wStatus = _awVTMK4OutBuf[3];
      pEvD->rt.wBuf = _awVTMK4OutBuf[4];
      break;
    }
    break;
  case MRT_MODE:
    pEvD->mrt.wStatus = _awVTMK4OutBuf[3];
    break;
  case UNDEFINED_MODE:
    pEvD->tmk.wRequest = _awVTMK4OutBuf[3];
    break;
  }
}
void tmkgetinfo(TTmkConfigData *pConfD)
{
#ifdef USE_TMK_ERROR
  tmkError = 0; 
#endif  
  devctl(_hVTMK4VxD, TMK_IOCtmkgetinfo, pConfD, sizeof(TTmkConfigData), NULL);
}

/*
void bcdefintnorm(void (* UserNormBC)(TMK_DATA, TMK_DATA, TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCbcdefintnorm, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
void bcdefintexc(void (* UserExcBC)(TMK_DATA, TMK_DATA, TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCbcdefintexc, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
void bcdefintx(void (* UserXBC)(TMK_DATA, TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCbcdefintx, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
void bcdefintsig(void (* UserSigBC)(TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCbcdefintsig, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
*/

int bcreset(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcreset, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError = 
#endif  
    _VTMK4Arg);
}

/*
void bc_def_tldw(TMK_DATA wTLDW)
{
  ioctl(_hVTMK4VxD, TMK_IOCbc_def_tldw, wTLDW);
}
void bc_enable_di(void)
{
  ioctl(_hVTMK4VxD, TMK_IOCbc_enable_di);
}
void bc_disable_di(void)
{
  ioctl(_hVTMK4VxD, TMK_IOCbc_disable_di);
}
*/

int bcdefirqmode(TMK_DATA bcIrqMode)
{
  TMK_DATA _VTMK4Arg = bcIrqMode;
  devctl(_hVTMK4VxD, TMK_IOCbcdefirqmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET bcgetirqmode(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcgetirqmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET bcgetmaxbase(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcgetmaxbase, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int bcdefbase(TMK_DATA bcBasePC)
{
  TMK_DATA _VTMK4Arg = bcBasePC;
  devctl(_hVTMK4VxD, TMK_IOCbcdefbase, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET bcgetbase(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcgetbase, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void bcputw(TMK_DATA bcAddr, TMK_DATA bcData)
{
  TMK_DATA _VTMK4Arg[2];
  _VTMK4Arg[0] = bcAddr;
  _VTMK4Arg[1] = bcData;
  devctl(_hVTMK4VxD, TMK_IOCbcputw, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[0]; 
#endif  
}

TMK_DATA_RET bcgetw(TMK_DATA bcAddr)
{
  TMK_DATA _VTMK4Arg = bcAddr;
  devctl(_hVTMK4VxD, TMK_IOCbcgetw, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

DWORD bcgetansw(TMK_DATA bcCtrlCode)
{
  DWORD _VTMK4Arg[2];
  _VTMK4Arg[0] = bcCtrlCode;
  devctl(_hVTMK4VxD, TMK_IOCbcgetansw, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

void bcputblk(TMK_DATA bcAddr, void *pcBuffer, TMK_DATA cwLength)
{
  WORD* _VTMK4Arg;
  int nBufSize;

  nBufSize = (sizeof(WORD)*(cwLength + 5));
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return;
  _VTMK4Arg[0] = bcAddr;
  _VTMK4Arg[1] = 0;
  _VTMK4Arg[2] = 0;
  _VTMK4Arg[3] = cwLength;
  _VTMK4Arg[4] = 0;
  memcpy(_VTMK4Arg+5, (TMK_DATA *)pcBuffer, sizeof(TMK_DATA)*cwLength);    
  devctl(_hVTMK4VxD, TMK_IOCbcputblk, _VTMK4Arg, nBufSize, NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[0];
#endif  
  free(_VTMK4Arg);
}

void bcgetblk(TMK_DATA bcAddr, void *pcBuffer, TMK_DATA cwLength)
{
  WORD* _VTMK4Arg;
  int nBufSize;

  nBufSize = (sizeof(WORD)*(cwLength + 4));
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return;
  _VTMK4Arg[0] = bcAddr;
  _VTMK4Arg[1] = 0;
  _VTMK4Arg[2] = 0;
  _VTMK4Arg[3] = cwLength;
  devctl(_hVTMK4VxD, TMK_IOCbcgetblk, _VTMK4Arg, nBufSize, NULL);
  memcpy((TMK_DATA *)pcBuffer, _VTMK4Arg, sizeof(TMK_DATA)*cwLength);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[cwLength];
#endif  
  free(_VTMK4Arg);
}

int bcdefbus(TMK_DATA bcBus)
{
  TMK_DATA _VTMK4Arg = bcBus;
  devctl(_hVTMK4VxD, TMK_IOCbcdefbus, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET bcgetbus(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcgetbus, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int bcstart(TMK_DATA bcBase, TMK_DATA bcCtrlCode)
{
  DWORD _VTMK4Arg = bcBase | (bcCtrlCode << 16);
  devctl(_hVTMK4VxD, TMK_IOCbcstart, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

int bcstartx(TMK_DATA bcBase, TMK_DATA bcCtrlCode)
{
  DWORD _VTMK4Arg = bcBase | (bcCtrlCode << 16);
  devctl(_hVTMK4VxD, TMK_IOCbcstartx, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

int bcdeflink(TMK_DATA bcBase, TMK_DATA bcCtrlCode)
{
  DWORD _VTMK4Arg = bcBase | (bcCtrlCode << 16);
  devctl(_hVTMK4VxD, TMK_IOCbcdeflink, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

DWORD bcgetlink(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCbcgetlink, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

TMK_DATA_RET bcstop(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcstop, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

DWORD bcgetstate(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCbcgetstate, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

/*
void rtdefintcmd(void (* UserCmdRT)(TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCrtdefintcmd, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
void rtdefinterr(void (* UserErrRT)(TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCrtdefinterr, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
void rtdefintdata(void (* UserDataRT)(TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCrtdefintdata, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
*/

int rtreset(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtreset, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError = 
#endif  
    _VTMK4Arg);
}

int rtdefirqmode(TMK_DATA rtIrqMode)
{
  TMK_DATA _VTMK4Arg = rtIrqMode;
  devctl(_hVTMK4VxD, TMK_IOCrtdefirqmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError = 
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetirqmode(void)
{
  TMK_DATA _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetirqmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdefmode(TMK_DATA rtMode)
{
  TMK_DATA _VTMK4Arg = rtMode;
  devctl(_hVTMK4VxD, TMK_IOCrtdefmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetmode(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetmode, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtgetmaxpage(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetmaxpage, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdefpage(TMK_DATA rtPage)
{
  TMK_DATA _VTMK4Arg = rtPage;
  devctl(_hVTMK4VxD, TMK_IOCrtdefpage, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetpage(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetpage, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdefpagepc(TMK_DATA rtPagePC)
{
  TMK_DATA _VTMK4Arg = rtPagePC;
  devctl(_hVTMK4VxD, TMK_IOCrtdefpagepc, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

int rtdefpagebus(TMK_DATA rtPageBus)
{
  TMK_DATA _VTMK4Arg = rtPageBus;
  devctl(_hVTMK4VxD, TMK_IOCrtdefpagebus, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetpagepc(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetpagepc, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtgetpagebus(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetpagebus, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdefaddress(TMK_DATA rtAddress)
{
  TMK_DATA _VTMK4Arg = rtAddress;
  devctl(_hVTMK4VxD, TMK_IOCrtdefaddress, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetaddress(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetaddress, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void rtdefsubaddr(TMK_DATA rtDir, TMK_DATA rtSubAddr)
{
  DWORD _VTMK4Arg = rtDir | (rtSubAddr << 16);
  devctl(_hVTMK4VxD, TMK_IOCrtdefsubaddr, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg; 
#endif  
}

TMK_DATA_RET rtgetsubaddr(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetsubaddr, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void rtputw(TMK_DATA rtAddr, TMK_DATA rtData)
{
  TMK_DATA _VTMK4Arg[2];
  _VTMK4Arg[0] = rtAddr;
  _VTMK4Arg[1] = rtData;
  devctl(_hVTMK4VxD, TMK_IOCrtputw, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[0];
#endif  
}

TMK_DATA_RET rtgetw(TMK_DATA rtAddr)
{
  TMK_DATA _VTMK4Arg = rtAddr;
  devctl(_hVTMK4VxD, TMK_IOCrtgetw, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void rtputblk(TMK_DATA rtAddr, void *pcBuffer, TMK_DATA cwLength)
{
  WORD* _VTMK4Arg;
  int nBufSize;

  nBufSize = (sizeof(WORD)*(cwLength + 5));
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return;
  _VTMK4Arg[0] = rtAddr;
  _VTMK4Arg[1] = 0;
  _VTMK4Arg[2] = 0;
  _VTMK4Arg[3] = cwLength;
  _VTMK4Arg[4] = 0;
  memcpy(_VTMK4Arg+5, (TMK_DATA *)pcBuffer, sizeof(TMK_DATA)*cwLength);    
  devctl(_hVTMK4VxD, TMK_IOCrtputblk, _VTMK4Arg, nBufSize, NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[0];
#endif  
  free(_VTMK4Arg);
}

void rtgetblk(TMK_DATA rtAddr, void *pcBuffer, TMK_DATA cwLength)
{
  WORD* _VTMK4Arg;
  int nBufSize;

  nBufSize = (sizeof(WORD)*(cwLength + 4));
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return;
  _VTMK4Arg[0] = rtAddr;
  _VTMK4Arg[1] = 0;
  _VTMK4Arg[2] = 0;
  _VTMK4Arg[3] = cwLength;
  devctl(_hVTMK4VxD, TMK_IOCrtgetblk, _VTMK4Arg, nBufSize, NULL);
  memcpy((TMK_DATA *)pcBuffer, _VTMK4Arg, sizeof(TMK_DATA)*cwLength);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[cwLength];
#endif  
  free(_VTMK4Arg);
}

void rtsetanswbits(TMK_DATA rtSetControl)
{
  TMK_DATA _VTMK4Arg = rtSetControl;
  devctl(_hVTMK4VxD, TMK_IOCrtsetanswbits, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

void rtclranswbits(TMK_DATA rtClrControl)
{
  TMK_DATA _VTMK4Arg = rtClrControl;
  devctl(_hVTMK4VxD, TMK_IOCrtclranswbits, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

TMK_DATA_RET rtgetanswbits(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetanswbits, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void rtgetflags(void *pcBuffer, TMK_DATA rtDir, TMK_DATA rtFlagMin, TMK_DATA rtFlagMax)
{
  WORD* _VTMK4Arg;
  int nBufSize;

  if(rtFlagMax < rtFlagMin || rtFlagMax > 31)
    return;
  nBufSize = (sizeof(WORD)*(rtFlagMax - rtFlagMin + 1 + 5));
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return;
  _VTMK4Arg[0] = 0;
  _VTMK4Arg[1] = 0;
  _VTMK4Arg[2] = rtDir;
  _VTMK4Arg[3] = rtFlagMin;
  _VTMK4Arg[4] = rtFlagMax;
  devctl(_hVTMK4VxD, TMK_IOCrtgetflags, _VTMK4Arg, nBufSize, NULL);
  memcpy((TMK_DATA *)pcBuffer, _VTMK4Arg, sizeof(TMK_DATA)*(rtFlagMax - rtFlagMin + 1));
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[rtFlagMax - rtFlagMin + 1];
#endif  
  free(_VTMK4Arg);
}

void rtputflags(void *pcBuffer, TMK_DATA rtDir, TMK_DATA rtFlagMin, TMK_DATA rtFlagMax)
{
  WORD* _VTMK4Arg;
  int nBufSize;

  if(rtFlagMax < rtFlagMin || rtFlagMax > 31)
    return;
  nBufSize = (sizeof(WORD)*(rtFlagMax - rtFlagMin + 1 + 5));
  _VTMK4Arg = (WORD*)malloc(nBufSize);
  if(_VTMK4Arg == NULL)
    return;
  _VTMK4Arg[0] = 0;
  _VTMK4Arg[1] = 0;
  _VTMK4Arg[2] = rtDir;
  _VTMK4Arg[3] = rtFlagMin;
  _VTMK4Arg[4] = rtFlagMax;
  memcpy(_VTMK4Arg+5, (TMK_DATA *)pcBuffer, sizeof(TMK_DATA)*(rtFlagMax - rtFlagMin + 1));
  devctl(_hVTMK4VxD, TMK_IOCrtputflags, _VTMK4Arg, nBufSize, NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[0];
#endif  
  free(_VTMK4Arg);
}

void rtsetflag(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtsetflag, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

void rtclrflag(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtclrflag, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

TMK_DATA_RET rtgetflag(TMK_DATA rtDir, TMK_DATA rtSubAddr)
{
  DWORD _VTMK4Arg = rtDir | (rtSubAddr << 16);
  devctl(_hVTMK4VxD, TMK_IOCrtgetflag, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtgetstate(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetstate, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtbusy(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtbusy, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void rtlock(TMK_DATA rtDir, TMK_DATA rtSubAddr)
{
  DWORD _VTMK4Arg = rtDir | (rtSubAddr << 16);
  devctl(_hVTMK4VxD, TMK_IOCrtlock, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

void rtunlock(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtunlock, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

TMK_DATA_RET rtgetcmddata(TMK_DATA rtBusCommand)
{
  TMK_DATA _VTMK4Arg = rtBusCommand;
  devctl(_hVTMK4VxD, TMK_IOCrtgetcmddata, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

void rtputcmddata(TMK_DATA rtBusCommand, TMK_DATA rtData)
{
  DWORD _VTMK4Arg = rtBusCommand | (rtData << 16);
  devctl(_hVTMK4VxD, TMK_IOCrtputcmddata, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif  
}

/*
void mtdefintx(void (* UserIntXMT)(TMK_DATA, TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCmtdefintx, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
void mtdefintsig(void (* UserSigMT)(TMK_DATA))
{
  ;
//  ioctl(_hVTMK4VxD, TMK_IOCmtdefintsig, _awVTMK4InBuf, 4, _awVTMK4OutBuf, 0, &_VTMK4Arg, NULL);
}
*/

int mtreset(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmtreset, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET mtgetsw(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmtgetsw, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtenable(TMK_DATA rtEnable)
{
  TMK_DATA _VTMK4Arg = rtEnable;
  devctl(_hVTMK4VxD, TMK_IOCrtenable, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

#ifdef _TMK1553B_MRT
int mrtgetmaxn(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmrtgetmaxn, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

DWORD mrtconfig(int mrtNumber)
{
  DWORD _VTMK4Arg[2];
  _VTMK4Arg[0] = mrtNumber;
  devctl(_hVTMK4VxD, TMK_IOCmrtconfig, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  if (_VTMK4Arg[1])
  {
#ifdef USE_TMK_ERROR
    tmkError = TMK_BAD_NUMBER;
#endif
    _VTMK4Arg[0] = 0;
  }
  return _VTMK4Arg[0];
}

int mrtselected(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmrtselected, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return (int)(short)_VTMK4Arg;
}

TMK_DATA_RET mrtgetstate(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmrtgetstate, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

void mrtdefbrcsubaddr0(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmrtdefbrcsubaddr0, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg;
#endif
}

int mrtreset(void)
{
  WORD _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmrtreset, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}
#endif //def _TMK1553B_MRT

TMK_DATA_RET tmktimer(TMK_DATA tmkTimerCtrl)
{
  TMK_DATA _VTMK4Arg = tmkTimerCtrl;
  devctl(_hVTMK4VxD, TMK_IOCtmktimer, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

DWORD tmkgettimer(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCtmkgettimer, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

TMK_DATA_RET tmkgettimerl(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCtmkgettimerl, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

DWORD bcgetmsgtime(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCbcgetmsgtime, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

DWORD rtgetmsgtime(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCrtgetmsgtime, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

TMK_DATA_RET tmkgethwver(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCtmkgethwver, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

DWORD tmkgetevtime(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCtmkgetevtime, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

TMK_DATA_RET tmkswtimer(TMK_DATA tmkSwTimerCtrl)
{
  TMK_DATA _VTMK4Arg = tmkSwTimerCtrl;
  devctl(_hVTMK4VxD, TMK_IOCtmkswtimer, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

DWORD tmkgetswtimer(void)
{
  DWORD _VTMK4Arg[2];
  devctl(_hVTMK4VxD, TMK_IOCtmkgetswtimer, _VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = _VTMK4Arg[1];
#endif  
  return _VTMK4Arg[0];
}

TMK_DATA_RET tmktimeout(TMK_DATA tmkTimeOut)
{
  TMK_DATA _VTMK4Arg = tmkTimeOut;
  devctl(_hVTMK4VxD, TMK_IOCtmktimeout, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

#ifdef _TMK1553B_MRT
int mrtdefbrcpage(TMK_DATA rtBrcPage)
{
  TMK_DATA _VTMK4Arg = rtBrcPage;
  devctl(_hVTMK4VxD, TMK_IOCmrtdefbrcpage, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif
    _VTMK4Arg);
}

TMK_DATA_RET mrtgetbrcpage(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCmrtgetbrcpage, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}
#endif //def _TMK1553B_MRT

TMK_DATA_RET bcgetmsgsw(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCbcgetmsgsw, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtgetmsgsw(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetmsgsw, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

TMK_DATA_RET rtgap(TMK_DATA rtGap)
{
  TMK_DATA _VTMK4Arg = rtGap;
  devctl(_hVTMK4VxD, TMK_IOCrtgap, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif
  return _VTMK4Arg;
}

TMK_DATA_RET rtallocsabuf(TMK_DATA rtBufModeSA, TMK_DATA rtBufSize)
{
  DWORD _VTMK4Arg = rtBufModeSA | (rtBufSize << 16);
  devctl(_hVTMK4VxD, TMK_IOCrtallocsabuf, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdefbuf(TMK_DATA rtBuf)
{
  TMK_DATA _VTMK4Arg = rtBuf;
  devctl(_hVTMK4VxD, TMK_IOCrtdefbuf, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetbuf(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetbuf, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdeflink(TMK_DATA rtLink) // Link = Buf | Ctrl ???
{
  TMK_DATA _VTMK4Arg = rtLink;
  devctl(_hVTMK4VxD, TMK_IOCrtdeflink, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetlink(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetlink, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

int rtdeflinkbus(TMK_DATA rtLinkBus) // Link = Buf | Ctrl ???
{
  TMK_DATA _VTMK4Arg = rtLinkBus;
  devctl(_hVTMK4VxD, TMK_IOCrtdeflinkbus, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
  return (
#ifdef USE_TMK_ERROR
    tmkError =
#endif  
    _VTMK4Arg);
}

TMK_DATA_RET rtgetlinkbus(void)
{
  TMK_DATA_RET _VTMK4Arg;
  devctl(_hVTMK4VxD, TMK_IOCrtgetlinkbus, &_VTMK4Arg, sizeof(_VTMK4Arg), NULL);
#ifdef USE_TMK_ERROR
  tmkError = 0;
#endif  
  return _VTMK4Arg;
}

#endif
