#include <windows.h>
#include <stdio.h>
#include <conio.h>
#include "tmkinit.c"

#define RT_ADDR 10 /* RT address */

int i;
unsigned short awBuf[32];

const int fInstMode = 1;
HANDLE hRtEvent;
TTmkEventData tmkEvD;

int nTmk;

TMK_DATA wBase, wMaxBase, wSubAddr, wLen, wState, wStatus;
unsigned long dwGoodStarts = 0, dwBusyStarts = 0, dwErrStarts = 0, dwStatStarts = 0;
unsigned long dwPrinted = 0;

void main()
{
/* Open driver */
  if (TmkOpen())
  {
    printf("TmkOpen error\n");
    goto stop;
  }
/* Read configuration file */
  if (TmkInit("rt.cfg"))
  {
    printf("TmkInit error\n");
    goto stop;
  }
/* Find first configured device */
  for (nTmk = 0; nTmk <= MAX_TMK_NUMBER; ++nTmk)
    if (!tmkselect(nTmk))
      break;
  if (nTmk > MAX_TMK_NUMBER)
  {
    printf("tmkselect error\n");
    goto stop;
  }
/* Try to reset in RT mode */
  if (rtreset())
  {
    printf("rtreset error\n");
    goto stop;
  }
/* Set RT address, set flag mode, enable data irqs */
  rtdefaddress(RT_ADDR);
  rtdefmode(rtgetmode()|RT_FLAG_MODE);
//  rtdefmode(rtgetmode()&~RT_FLAG_MODE);
  rtdefirqmode(rtgetirqmode()&~RT_DATA_BL);

  for (wSubAddr = 1; wSubAddr <= 30; ++wSubAddr)
  {
/* Ready to receive, not ready to transmit */
    rtdefsubaddr(RT_RECEIVE, wSubAddr);
    rtclrflag();
    rtdefsubaddr(RT_TRANSMIT, wSubAddr);
    rtclrflag();
  }
/* Define event for interrupts */
  hRtEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
  if (!hRtEvent)
  {
    printf("CreateEvent error\n");
    goto stop;
  }
  tmkdefevent(hRtEvent, TRUE);


  while (!kbhit())
  {
/* Wait for an interrupt */
    switch (WaitForSingleObject(hRtEvent, 1000))
    {
    case WAIT_OBJECT_0:
/* New message has arrived */
      ResetEvent(hRtEvent);
      do
      {
/* Get interrupt data */
        tmkgetevd(&tmkEvD);
/* Check interrupt type */
        if (tmkEvD.nInt == 3)
        {
          ++dwGoodStarts;
          wSubAddr = (tmkEvD.rt.wStatus >> 5) &0x1F;
          wLen = tmkEvD.rt.wStatus & 0x1F;
          if (wLen == 0)
            wLen = 32;
          if ((tmkEvD.rt.wStatus & RT_DIR_MASK) == RT_RECEIVE)
          {
/* If we received some data then copy the data from Rx subaddres to */
/* Tx subaddress and process flags */
            if ((rtgetflag(RT_RECEIVE, wSubAddr) & RT_FLAG_MASK) == 0)
            {
              printf("Flag read error\n");
              goto stop;
            }
            rtdefsubaddr(RT_RECEIVE, wSubAddr);
            rtgetblk(0, awBuf, wLen);
            rtclrflag();
            rtdefsubaddr(RT_TRANSMIT, wSubAddr);
            rtputblk(0, awBuf, wLen);
            rtsetflag();
          }
        }
      }
/* Loop while we have not processed all interrupts */
      while (tmkEvD.nInt != 0);
      break;
    case WAIT_TIMEOUT:
/* No new messages */
      printf("\rGood: %ld", dwGoodStarts);
      break;
    default:
      printf("Interrupt wait error\n");
      goto stop;
    }
    if ((dwGoodStarts - dwPrinted) >= 1000)
    {
      printf("\rGood: %ld", dwGoodStarts);
      dwPrinted = dwGoodStarts;
    }
  }
  stop:
  printf("\nGood: %ld\n", dwGoodStarts);
  bcreset();
/* Close all opened things */
  CloseHandle(hRtEvent);
  tmkdone(ALL_TMKS);
  TmkClose();
}
