// bcrtdlg.cpp : implementation file
//

#include "stdafx.h"
#include "bcrt.h"
#include "bcrtdlg.h"

#include <afxtempl.h>

#include <stdio.h>
#include "wdmtmkv2.cpp"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;             
#endif

#define MY_WAIT_EVENT

#define CMD_RESET 0x408
#define CMD_SYNC 0x401
#define CMD_SYNC_DATA 0x011
#define CMD_GET_VECTOR 0x410
typedef struct TSmsg1553
{
 CString Data;
} Tmsg1553;
CList<Tmsg1553,Tmsg1553&> msgList;
int cReceiveLines;
int nMaxTMK;
int nTmkNumber;
unsigned wTmkMode;
unsigned short msgRtAddress, msgCtrlCode1, msgCtrlCode2, msgLength, msgCmd, msgResult, msgAW;
int msgInt;
int fRtSendInProgress, fBcStartDisable;
unsigned short rtMsgIndex;
unsigned short wPrevSReq[30];
CString _Transmitter;
SECURITY_ATTRIBUTES sa4Event;
HANDLE hEvent;

int BcEventTest()
{
 TTmkEventData tmkEvD;
 int result;

 msgCmd = 0xF800+CI_MASK+CMD_RESET;
 bcputw(0,msgCmd);
 bcstart(0,CTRL_C_BRCST);
 switch (WaitForSingleObject(hEvent,200))
 {
 case WAIT_OBJECT_0:
  ResetEvent(hEvent);
  tmkgetevd(&tmkEvD);
  result = 1;
  break;
 case WAIT_TIMEOUT:
 default:
  result = 0;
 }
 return result;
}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
        CAboutDlg();

// Dialog Data
        //{{AFX_DATA(CAboutDlg)
        enum { IDD = IDD_ABOUTBOX };
        //}}AFX_DATA

// Implementation
protected:
        virtual void DoDataExchange(CDataExchange* pDX);        // DDX/DDV support
        //{{AFX_MSG(CAboutDlg)
        virtual BOOL OnInitDialog();
        //}}AFX_MSG
        DECLARE_MESSAGE_MAP()
};
          
CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
        //{{AFX_DATA_INIT(CAboutDlg)
        //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CAboutDlg)
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
        //{{AFX_MSG_MAP(CAboutDlg)
                // No message handlers
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg message handlers

BOOL CAboutDlg::OnInitDialog()
{
        CDialog::OnInitDialog();
        CenterWindow();
        
        // TODO: Add extra about dlg initialization here
        
        return TRUE;  // return TRUE  unless you set the focus to a control
}

/////////////////////////////////////////////////////////////////////////////
// CBcrtDlg dialog

CBcrtDlg::CBcrtDlg(CWnd* pParent /*=NULL*/)
        : CDialog(CBcrtDlg::IDD, pParent)
{
        //{{AFX_DATA_INIT(CBcrtDlg)
        m_Receiver = _T(" 0");
        m_rtAddress = 0;
        m_Transmit = _T("");
        m_Receive = _T("");
        m_tmkNumber = -1;
        m_tmkMode = 0;
        m_Period = 100;
        //}}AFX_DATA_INIT
        // Note that LoadIcon does not require a subsequent DestroyIcon in Win32
        m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CBcrtDlg::DoDataExchange(CDataExchange* pDX)
{
        CDialog::DoDataExchange(pDX);
        //{{AFX_DATA_MAP(CBcrtDlg)
        DDX_Control(pDX, IDC_SEND, m_Send);
        DDX_CBString(pDX, IDC_RECEIVER, m_Receiver);
        DDX_CBIndex(pDX, IDC_RTADDRESS, m_rtAddress);
        DDX_Text(pDX, IDC_TRANSMIT, m_Transmit);
        DDV_MaxChars(pDX, m_Transmit, 64);
        DDX_Text(pDX, IDC_RECEIVE, m_Receive);
        DDX_CBIndex(pDX, IDC_TMKNUMBER, m_tmkNumber);
        DDX_Radio(pDX, IDC_MODEBC, m_tmkMode);
        DDX_Text(pDX, IDC_PERIOD, m_Period);
        DDV_MinMaxUInt(pDX, m_Period, 50, 10000);
        //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CBcrtDlg, CDialog)
        //{{AFX_MSG_MAP(CBcrtDlg)
        ON_WM_SYSCOMMAND()
        ON_WM_PAINT()
        ON_WM_QUERYDRAGICON()
        ON_WM_CREATE()
        ON_WM_DESTROY()
        ON_CBN_SELCHANGE(IDC_TMKNUMBER, OnSelchangeTmknumber)
        ON_BN_CLICKED(IDC_MODEBC, OnModebc)
        ON_BN_CLICKED(IDC_MODERT, OnModert)
        ON_CBN_SELCHANGE(IDC_RTADDRESS, OnSelchangeRtaddress)
        ON_CBN_KILLFOCUS(IDC_TMKNUMBER, OnKillfocusTmknumber)
        ON_BN_CLICKED(IDC_SEND, OnSend)
        ON_EN_CHANGE(IDC_PERIOD, OnChangePeriod)
        ON_WM_TIMER()
        ON_BN_CLICKED(IDM_ABOUTBOX, OnAboutbox)
        //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBcrtDlg message handlers

BOOL CBcrtDlg::OnInitDialog()
{
        CDialog::OnInitDialog();
        CenterWindow();

        // Add "About..." menu item to system menu.

        // IDM_ABOUTBOX must be in the system command range.
        ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
        ASSERT(IDM_ABOUTBOX < 0xF000);

        CMenu* pSysMenu = GetSystemMenu(FALSE);
        CString strAboutMenu;
        strAboutMenu.LoadString(IDS_ABOUTBOX);
        if (!strAboutMenu.IsEmpty())
        {
                pSysMenu->AppendMenu(MF_SEPARATOR);
                pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
        }
        
        // TODO: Add extra initialization here
        
        return TRUE;  // return TRUE  unless you set the focus to a control
}

void CBcrtDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
        if ((nID & 0xFFF0) == IDM_ABOUTBOX)
        {
                CAboutDlg dlgAbout;
                dlgAbout.DoModal();
        }
        else
        {
                CDialog::OnSysCommand(nID, lParam);
        }
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CBcrtDlg::OnPaint() 
{
        if (IsIconic())
        {
                CPaintDC dc(this); // device context for painting

                SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

                // Center icon in client rectangle
                int cxIcon = GetSystemMetrics(SM_CXICON);
                int cyIcon = GetSystemMetrics(SM_CYICON);
                CRect rect;
                GetClientRect(&rect);
                int x = (rect.Width() - cxIcon + 1) / 2;
                int y = (rect.Height() - cyIcon + 1) / 2;

                // Draw the icon
                dc.DrawIcon(x, y, m_hIcon);
        }
        else
        {
                CDialog::OnPaint();
        }
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CBcrtDlg::OnQueryDragIcon()
{
        return (HCURSOR) m_hIcon;
}

int CBcrtDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
        if (CDialog::OnCreate(lpCreateStruct) == -1)
                return -1;
        
        // TODO: Add your specialized creation code here
 if (TmkOpen())
 {
  MessageBox("   TMK1553B","Test BC<->RT Error",MB_OK|MB_ICONSTOP);
  return -1;
 }
 sa4Event.nLength = sizeof(sa4Event);
 sa4Event.lpSecurityDescriptor = NULL;
 sa4Event.bInheritHandle = TRUE;
 if ( !(hEvent = CreateEvent(&sa4Event, TRUE, FALSE, NULL)) )
 {
  MessageBox("CreateEvent failed!","Test BC<->RT Error",MB_OK|MB_ICONSTOP);
  return -1;
 }
 nMaxTMK = tmkgetmaxn();
 nTmkNumber = m_tmkNumber;
 wTmkMode = m_tmkMode;
 _Transmitter = "";
 cReceiveLines = 0;
 fBcStartDisable = 1;
 fRtSendInProgress = 0;
 SetTimer(1, m_Period, NULL);
        
        return 0;
}

void CBcrtDlg::OnDestroy() 
{
        CDialog::OnDestroy();
        
        // TODO: Add your message handler code here
 KillTimer(1);
 if (nTmkNumber >= 0 && nTmkNumber <= MAX_TMK_NUMBER)
 {
  tmkdefevent(0,TRUE);
  tmkdone(nTmkNumber);
 }
 if (hEvent)
  CloseHandle(hEvent);
        TmkClose();
}

void CBcrtDlg::OnSelchangeTmknumber() 
{
        // TODO: Add your control notification handler code here
 UpdateData(TRUE);
 if (m_tmkNumber != nTmkNumber)
 {
  if (nTmkNumber != -1)
  {
   tmkdefevent(0,TRUE);
   tmkdone(nTmkNumber);
  }
  if (m_tmkNumber >= 0 && m_tmkNumber <= MAX_TMK_NUMBER)
  {
   if (tmkconfig(m_tmkNumber) == 0)
   {
    tmkselect(m_tmkNumber);
    tmkdefevent(hEvent,TRUE);
    switch (wTmkMode)
    {
    case BC_MODE:
     bcreset();
     bcdefbase(0);
     {
      for (int i=0; i <= 30; ++i)
       wPrevSReq[i] = 0;
     }
     if (!BcEventTest())
     {
      fBcStartDisable = 1;
      MessageBox("TestEvent failed!\n\rCheck configuration in Registry.","Test BC<->RT Error",MB_OK|MB_ICONSTOP);
     }
     else
      fBcStartDisable = 0;
     _Transmitter = "";
     break;
    case RT_MODE:
     rtreset();
     rtputcmddata(CMD_GET_VECTOR,0);
     rtclranswbits(0xffff);
     rtdefaddress(m_rtAddress);       
     rtdefpage(0);
     rtMsgIndex = 0;
     fRtSendInProgress = 0;
     sprintf(_Transmitter.GetBuffer(5), " %d",m_rtAddress);
     _Transmitter.ReleaseBuffer(-1);
     break;
    case MT_MODE:
     mtreset();
     break;
    }
   }
   else
   {
    m_tmkNumber = -1;
   }
   nTmkNumber = m_tmkNumber;
  }
  else
  {
   nTmkNumber = m_tmkNumber = -1;
  }
 }
 UpdateData(FALSE);
}

void CBcrtDlg::OnModebc() 
{
        // TODO: Add your control notification handler code here
        UpdateData(TRUE);
 if (wTmkMode != BC_MODE && nTmkNumber != -1)
 {
  bcreset();
  bcdefbase(0);
  {
   for (int i=0; i <= 30; ++i)
    wPrevSReq[i] = 0;
  }
  if (!BcEventTest())
  {
   fBcStartDisable = 1;
   MessageBox("TestEvent failed!\n\rCheck configuration in ControlPanel->System->MIL-STD-1553B.","Test BC<->RT Error",MB_OK|MB_ICONSTOP);
  }
  else
   fBcStartDisable = 0;
  _Transmitter = "";
 }
 wTmkMode = BC_MODE;
}

void CBcrtDlg::OnModert() 
{
        // TODO: Add your control notification handler code here
        UpdateData(TRUE);
 if (wTmkMode != RT_MODE && nTmkNumber != -1)
 {
  rtreset();
  rtputcmddata(CMD_GET_VECTOR,0);
  rtclranswbits(0xffff);
  rtdefaddress(m_rtAddress);
  rtdefpage(0);
  rtMsgIndex = 0;
  fRtSendInProgress = 0;
  sprintf(_Transmitter.GetBuffer(5), " %d",m_rtAddress);
  _Transmitter.ReleaseBuffer(-1);
 }
 wTmkMode = RT_MODE;
}

void CBcrtDlg::OnSelchangeRtaddress() 
{
        // TODO: Add your control notification handler code here
        UpdateData(TRUE);
 if (nTmkNumber != -1 && wTmkMode == RT_MODE)
 {
  rtputcmddata(CMD_GET_VECTOR,0);
  rtclranswbits(0xffff);
  rtdefaddress(m_rtAddress);
  rtMsgIndex = 0;
  fRtSendInProgress = 0;
  sprintf(_Transmitter.GetBuffer(5), " %d",m_rtAddress);
  _Transmitter.ReleaseBuffer(-1);
 }
}

void CBcrtDlg::OnKillfocusTmknumber() 
{
        // TODO: Add your control notification handler code here
        UpdateData(FALSE);
}

void CBcrtDlg::OnSend() 
{                                                                            
        // TODO: Add your control notification handler code here
 TTmkEventData tmkEvD;
 unsigned short wSReq;

        UpdateData(TRUE);
 if (nTmkNumber == -1)
  return;
 if (m_Transmit.GetLength() & 1)
  m_Transmit += " ";
 if (m_Receiver == _Transmitter)
 {
  m_Receive += m_Transmit + "\r\n";
  if (cReceiveLines == 8)
  {
   m_Receive = m_Receive.Right(m_Receive.GetLength() - m_Receive.Find('\r') - 2);
  }
  else
   ++cReceiveLines;
  UpdateData(FALSE);
 }
 else if (wTmkMode == BC_MODE && !fBcStartDisable)
 {
  if (m_Receiver == " ")
  {
   msgRtAddress = 31;
   msgCtrlCode1 = DATA_BC_RT_BRCST;
   msgCtrlCode2 = CTRL_CD_BRCST;
  }
  else
  {
   sscanf(LPCTSTR(m_Receiver)+3, "%d", &msgRtAddress);
   msgCtrlCode1 = DATA_BC_RT;
   msgCtrlCode2 = CTRL_CD_A;
  }
  if ((msgLength = (m_Transmit.GetLength()+1)/2) > 32 )
   msgLength = 32;
  msgCmd = (msgRtAddress<<11)+RT_RECEIVE+(0x10<<5)+(msgLength & NWORDS_MASK);;
  bcdefbase(0);
  bcputw(0,msgCmd);   
  bcputblk(1,(unsigned short*)LPCTSTR(m_Transmit),msgLength);
  bcstart(0,msgCtrlCode1);
#ifndef MY_WAIT_EVENT
  switch (WaitForSingleObject(hEvent,100))
#else
  do { switch (WaitForSingleObject(hEvent,0))
#endif
  {
  case WAIT_OBJECT_0:
   ResetEvent(hEvent);
   tmkgetevd(&tmkEvD);
   msgInt = tmkEvD.nInt;
   msgResult = tmkEvD.bc.wResult;
   if (msgInt == 2)
    msgAW = tmkEvD.bc.wAW1;
   break;
  case WAIT_TIMEOUT:
   msgInt = 0;
   break;
  default:
   msgInt = -1;
   break;
  }
#ifdef MY_WAIT_EVENT
  } while (msgInt == 0);
#endif
  msgCmd = (msgRtAddress<<11)+CI_MASK+CMD_SYNC_DATA;
  bcputw(0,msgCmd);
  bcputw(1,0xF800+RT_RECEIVE+msgLength);
  bcstart(0,msgCtrlCode2);
#ifndef MY_WAIT_EVENT
  switch (WaitForSingleObject(hEvent,100))
#else
  do { switch (WaitForSingleObject(hEvent,0))
#endif
  {
  case WAIT_OBJECT_0:
   ResetEvent(hEvent);
   tmkgetevd(&tmkEvD);
   msgInt = tmkEvD.nInt;
   msgResult = tmkEvD.bc.wResult;
   if (msgInt == 2)
    msgAW = tmkEvD.bc.wAW1;
   break;
  case WAIT_TIMEOUT:
   msgInt = 0;
   break;
  default:
   msgInt = -1;
   break;
  }
#ifdef MY_WAIT_EVENT
  } while (msgInt == 0);
#endif
 }
 else if (wTmkMode == RT_MODE && !fRtSendInProgress)
 {
  if (m_Receiver == " ")
   msgRtAddress = 31;
  else if (m_Receiver == "")
   msgRtAddress = m_rtAddress;
  else
  {
   sscanf(LPCTSTR(m_Receiver)+3, "%d", &msgRtAddress);
  }
  if ((msgLength = (m_Transmit.GetLength()+1)/2) > 32)
   msgLength = 32;
  if (++rtMsgIndex >= 32)
   rtMsgIndex = 1;
  wSReq = (msgRtAddress<<11)+RT_TRANSMIT+(rtMsgIndex<<5)+(msgLength & NWORDS_MASK);
  rtdefsubaddr(RT_TRANSMIT, 0x10);
  rtputblk(0,(unsigned short*)LPCTSTR(m_Transmit),msgLength);
  rtputcmddata(CMD_GET_VECTOR, wSReq);
  rtsetanswbits(SREQ);
  fRtSendInProgress = 1;
//  m_Send.SetCheck(1);
//  UpdateData(FALSE);
 } 
}   

void CBcrtDlg::OnChangePeriod() 
{
        // TODO: Add your control notification handler code here
        UpdateData(TRUE);
 if (m_Period >= 50 && m_Period <= 10000)
  SetTimer(1, m_Period, NULL);
}

void CBcrtDlg::OnTimer(UINT_PTR nIDEvent) 
{
        // TODO: Add your message handler code here and/or call default
 TTmkEventData tmkEvD;
 unsigned short iRtAddress, wSReq, wRtCmdData;

        if (nIDEvent == 1 && nTmkNumber != -1)
 {
  switch (wTmkMode)
  {
  case BC_MODE:
   if (fBcStartDisable)
    break;
   for (iRtAddress = 0; iRtAddress <= 30; ++iRtAddress)
   {
    msgCmd = (iRtAddress<<11)+CI_MASK+CMD_GET_VECTOR;
    bcputw(0, msgCmd);
    bcstart(0, CTRL_C_AD);
#ifndef MY_WAIT_EVENT
    switch (WaitForSingleObject(hEvent,100))
#else
    do { switch (WaitForSingleObject(hEvent,0))
#endif
    {
    case WAIT_OBJECT_0:
     ResetEvent(hEvent);
     tmkgetevd(&tmkEvD);
     msgInt = tmkEvD.nInt;
     msgResult = tmkEvD.bc.wResult;
     if (msgInt == 2)
      msgAW = tmkEvD.bc.wAW1;
     break;
    case WAIT_TIMEOUT:
     msgInt = 0;
     break;
    default:
     msgInt = -1;
     break;
    }
#ifdef MY_WAIT_EVENT
    } while (msgInt == 0);
#endif
    if (msgInt <= 1 || (msgInt == 2 && (msgResult & S_IB_MASK) == 0))
     continue;
    if (msgInt == 2 && (msgResult == S_IB_MASK) && ((msgAW & ~ADDRESS_MASK) == SREQ_MASK))
    {
     wSReq = bcgetw(2);
     if ( wSReq == wPrevSReq[iRtAddress])
      continue;
     wPrevSReq[iRtAddress] = wSReq;
     if ((wSReq & ADDRESS_MASK) == (msgCmd & ADDRESS_MASK))
     {
      msgCtrlCode1 = DATA_RT_BC;
      msgCmd = (iRtAddress<<11)+RT_TRANSMIT+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      msgCtrlCode2 = 0xFFFF;
     }
     else if ((wSReq & ADDRESS_MASK) == 0xF800)
     {
      msgCtrlCode1 = DATA_RT_RT_BRCST;
      msgCmd = 0xF800+RT_RECEIVE+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      msgCmd = (iRtAddress<<11)+RT_TRANSMIT+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(1, msgCmd);
      msgCtrlCode2 = CTRL_CD_BRCST;
     }
     else 
     {
      msgCtrlCode1 = DATA_RT_RT;
      msgCmd = (wSReq & ADDRESS_MASK)+RT_RECEIVE+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      msgCmd = (iRtAddress<<11)+RT_TRANSMIT+(0x10<<5)+(wSReq & NWORDS_MASK);
      bcputw(1, msgCmd);
      msgCtrlCode2 = CTRL_CD_A;
     }
     bcstart(0, msgCtrlCode1);
#ifndef MY_WAIT_EVENT
     switch (WaitForSingleObject(hEvent,100))
#else
     do { switch (WaitForSingleObject(hEvent,0))
#endif
     {
     case WAIT_OBJECT_0:
      ResetEvent(hEvent);
      tmkgetevd(&tmkEvD);
      msgInt = tmkEvD.nInt;
      msgResult = tmkEvD.bc.wResult;
      if (msgInt == 2)
       msgAW = tmkEvD.bc.wAW1;
      break;
     case WAIT_TIMEOUT:
      msgInt = 0;
      break;
     default:
      msgInt = -1;
      break;
     }
#ifdef MY_WAIT_EVENT
     } while (msgInt == 0);
#endif
     if (msgCtrlCode2 != 0xFFFF)
     {
      msgCmd = (wSReq & ADDRESS_MASK)+CI_MASK+CMD_SYNC_DATA;
      wRtCmdData = (iRtAddress<<11)+RT_RECEIVE+(wSReq & NWORDS_MASK);
      bcputw(0, msgCmd);
      bcputw(1, wRtCmdData);
      bcstart(0, msgCtrlCode2);
#ifndef MY_WAIT_EVENT
      switch (WaitForSingleObject(hEvent,100))
#else
      do { switch (WaitForSingleObject(hEvent,0))
#endif
      {
      case WAIT_OBJECT_0:
       ResetEvent(hEvent);
       tmkgetevd(&tmkEvD);
       msgInt = tmkEvD.nInt;
       msgResult = tmkEvD.bc.wResult;
       if (msgInt == 2)
        msgAW = tmkEvD.bc.wAW1;
       break;
      case WAIT_TIMEOUT:
       msgInt = 0;
       break;
      default:
       msgInt = -1;
       break;
      }
#ifdef MY_WAIT_EVENT
      } while (msgInt == 0);
#endif
     }
     else if (msgInt == 2 && (msgResult == S_IB_MASK) && ((msgAW & ~ADDRESS_MASK) == SREQ_MASK))
     {
      char *psz;
      if ((msgLength = wSReq & NWORDS_MASK) == 0)
       msgLength = 32;
      psz = m_Receive.GetBuffer(m_Receive.GetLength()+msgLength*2+1)+m_Receive.GetLength();
      bcgetblk(2,(unsigned short*)(psz),msgLength);
      psz[msgLength*2] = '\0';
      m_Receive.ReleaseBuffer(-1);
      m_Receive += "\r\n";
      if (cReceiveLines == 8)
      {
       m_Receive = m_Receive.Right(m_Receive.GetLength() - m_Receive.Find('\r') - 2);
      }
      else
       ++cReceiveLines;
      UpdateData(FALSE);
     }
     msgCmd = (iRtAddress<<11)+CI_MASK+CMD_SYNC_DATA;
     wRtCmdData = (wSReq | RT_TRANSMIT) & ~(ADDRESS_MASK+NWORDS_MASK);
     bcputw(0, msgCmd);
     bcputw(1, wRtCmdData);
     bcstart(0, CTRL_CD_A);
#ifndef MY_WAIT_EVENT
     switch (WaitForSingleObject(hEvent,100))
#else
     do { switch (WaitForSingleObject(hEvent,0))
#endif
     {
     case WAIT_OBJECT_0:
      ResetEvent(hEvent);
      tmkgetevd(&tmkEvD);
      msgInt = tmkEvD.nInt;
      msgResult = tmkEvD.bc.wResult;
      if (msgInt == 2)
       msgAW = tmkEvD.bc.wAW1;
      break;
     case WAIT_TIMEOUT:
      msgInt = 0;
      break;
     default:
      msgInt = -1;
      break;
     }
#ifdef MY_WAIT_EVENT
     } while (msgInt == 0);
#endif
    }
   }
   break;
  case RT_MODE:
   do
   {
    switch(WaitForSingleObject(hEvent,0))
    {
    case WAIT_OBJECT_0:
     ResetEvent(hEvent);
     do
     {
      tmkgetevd(&tmkEvD);
      if (tmkEvD.nInt == 1)
      {
       switch (tmkEvD.rt.wCmd)
       {
       case CMD_SYNC_DATA:
        if ((wRtCmdData = rtgetcmddata(CMD_SYNC_DATA)) & RT_TRANSMIT)
        {
         rtclranswbits(SREQ);
         fRtSendInProgress = 0;
//       m_Send.SetCheck(0);
//       UpdateData(FALSE);
        }
        else
        {
         char *psz;
         if ((msgLength = (wRtCmdData & NWORDS_MASK)) == 0)
          msgLength = 32;
         if ((wRtCmdData & ADDRESS_MASK) != (m_rtAddress<<11))
          rtdefsubaddr(RT_RECEIVE, 0x10);
         else
          rtdefsubaddr(RT_TRANSMIT, 0x10);
         psz = m_Receive.GetBuffer(m_Receive.GetLength()+msgLength*2+1)+m_Receive.GetLength();
         rtgetblk(0,(unsigned short*)(psz),msgLength);
         psz[msgLength*2] = '\0';
         m_Receive.ReleaseBuffer(-1);
         m_Receive += "\r\n";
         if (cReceiveLines == 8)
         {
          m_Receive = m_Receive.Right(m_Receive.GetLength() - m_Receive.Find('\r') - 2);
         }
         else
          ++cReceiveLines;
         UpdateData(FALSE);
        }
        break;
//       case CMD_GET_VECTOR:
       default:
        break;
       }
      }
     }
     while (tmkEvD.nInt != 0);
     break;
    case WAIT_TIMEOUT:
     tmkEvD.nInt = 0;
     break;
    default:
     tmkEvD.nInt = -1;
    }
   }
   while (tmkEvD.nInt != 0);
   break;
  default:
   break;
  }
 }
        CDialog::OnTimer(nIDEvent);
}

void CBcrtDlg::OnAboutbox() 
{
        // TODO: Add your control notification handler code here
                CAboutDlg dlgAbout;
                dlgAbout.DoModal();
}
