Unit Conv_U; {  楤 ८ࠧ ।⠢  }
Interface

  function Bin( X : byte ): String;	{ 㭪 뢮   ப  ୮ ଠ }
  function Bin_W( X : word ): String;   { 㭪 뢮 ᫮  ப  ୮ ଠ }
  function Bin_L( X : longint ): String;{ 㭪 뢮  ᫮  ப  ୮ ଠ }
  function Hex_B( X : byte ): String;   { 㭪 뢮   ப  ⭠筮 ଠ }
  function Hex_W( X : word ): String;	{ 㭪 뢮 ᫮  ப  ⭠筮 ଠ }
  function Hex_L( X : longint ): String;{ 㭪 뢮  ᫮  ப  ⭠筮 ଠ }
  function Val_W( X : word; N : byte ): String; { 㭪 뢮 ᫮  ப  筮 ଠ }
  Function Str_2_Hex( S : string ) : longint; { 㭪 ८ࠧ ப  ⭠筮 ଠ    設 ଠ }

Implementation
  Const
    Hex_Tab : array[0..15] of char =
                           ( '0', '1', '2', '3', '4', '5', '6', '7',
                             '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' );

  Function Ch_2_Hex( Ch : char ) : byte;
    Begin
    case ch of
      '0'..'9' :  begin
	Ch_2_Hex := ord( Ch )- ord( '0' );
        exit;
      end;
      'a'..'f' :  begin
        Ch_2_Hex := ord( Ch )- ord( 'a' ) + 10;
        exit;
      end;
      'A'..'F' :  begin
        Ch_2_Hex := ord( Ch )- ord( 'A' ) + 10;
        exit;
      end;
      else        begin
        Ch_2_Hex := $80;
      end;
    end;
  End;

  Function Str_2_Hex( S : string ) : longint; { 㭪 ८ࠧ }
  Var X : longint;            { ப  ⭠   ᫮}
      t, i, N : byte;
  Begin
    N := length( S );
    if  N = 0 then
    begin
      Str_2_Hex := 0;
      exit;
    end;
    if N > 8 then N:= 8;
    X := 0;
    i := 1;
    repeat
      t := Ch_2_Hex( S[ i ] );
      if t <= 15 then
        X := X shl 4 + t;
      inc ( i );
    Until  i > N;
    Str_2_Hex := X;
  End;

  function Bin( X : byte ): String;
  var
    i : integer;
    S : string;
  Begin
    S := '';
    for  i := 1 to 8 do
    begin
      S := char ( ( X and 1 ) + ord( '0' ) ) + S;
      X := X Shr 1;
    end;
    Bin := S;
  End; { function Bin( X : byte ): String; }


  function Bin_W( X : word ): String;
  var
    i : integer;
    S : string;
  Begin
    S := '';
    for  i := 1 to 16 do
    begin
      S := char ( ( X and 1 ) + ord( '0' ) ) + S;
      X := X Shr 1;
    end;
    Bin_W := S;
  End; { function Bin( X : byte ): String; }

 function Bin_L( X : longint ): String;
  var
    S : string;
  Begin { function Hex_L }
     S :=     Bin_W( X shr  16   );
     S := S + Bin_W( X and $FFFF );
    Bin_L:= S;
  End;  { function Hex_L }


Const exp10 : array[ 0 .. 5 ] of word = ( 0, 9, 99, 999, 9999, $FFFF);

function Val_W( X : word; N : byte ): String;
  Var
    S : string;
    i : byte;

  Begin
    if N = 0 then N := 1;
    if N < 5 then
      while exp10[ N ] < X do
        inc( N );
    S := '';
    for i := 1 to N do
      S := S + ' ';

    i := N ;

    repeat
      S[ i ] := Hex_Tab[ X mod 10 ];
      X := X div 10;
      dec( i );
    until X = 0 ;
    Val_W := S;

    {
    asm
      les       di, @Result
      mov       al, ' '
      xor       cx, cx
      mov       cl, N
      mov       byte ptr es:di, cl
      inc       di
      rep       stosb

      mov       ax, X


      or        ax, ax
    end;}
  End;  { function Val_W }

function Hex_B( X : byte ): String;
  Begin  { function Hex_W }
    Hex_B := Hex_Tab[  X shr 4 ] + Hex_Tab[  X and 15 ] ;
  End;  { function Hex_B }


function Hex_W( X : word ): String;
  var
    i : integer;
    S : string;
  Begin  { function Hex_W }
    S := '';
    i := 1;
    While ( i <= 4 ) {and ( X > 0 ) } do
    begin
      S := Hex_Tab[  X and 15 ] + S;
      X := X Shr 4;
      inc( i );
    end;
{    While ( i <= 4 )  do
    begin
      S := ' '+ S;
      inc( i );
    end;}
    Hex_W := S;
  End;  { function Hex_W }



function Hex_L( X : longint ): String;
  var
    S : string;
  Begin { function Hex_L }
     S :=     Hex_W( X shr  16   );
     S := S + Hex_W( X and $FFFF );
    Hex_L:= S;
  End;  { function Hex_L }


End.