Unit PIC_U; {  ࠡ  뭨ﬨ }
Interface
  function Irq_Set(     Irq_N : byte;       {  뢠 0 - 7, 8 - 15 }
                        New_Vect : pointer; {   뢠 }
                    Var Old_Vect : pointer; {   뢠 }
                    Var Old_Mask : byte     {   뢠   ࠭ }
                     ) : boolean ;
  { 楤 ⠭   뢠,
    ࠧ襭  ᮮ饣 뢠  ஫ 뢠 
     ⥪饣   筨
    楤 ஢ 祭  뢠  ⨬ }
  Procedure Irq_Restore( Irq_N : byte;
                         Old_Vect : pointer;
                         Old_Mask : byte
                     ) ;
    { 楤 ⠭ ண  뢠,
    ᪨  ஫ 뢠   ⥪饣   筨
    楤 ஢ 祭  뢠  ⨬ }


  Procedure Set_IMR ( Cntr_N , Mask : byte );
  Procedure Clr_Int ( Cntr_N : byte );
  Function  Get_IMR ( Cntr_N : byte ) : byte;
  Function  Get_IRR ( Cntr_N : byte ) : byte;
  Function  Get_ISR ( Cntr_N : byte ) : byte;

Implementation
Uses conv_U, DOS;

const
  Base_PIC : array[ 0 .. 1 ] of byte = ( $20, $A0 );
  Base_Int : array[ 0 .. 1 ] of byte = ( $08,  $70 );
  Mask : array[ 0..7] of byte = ( 1, 2, 4, 8, 16, 32, 64, 128);

  function Irq_Set(     Irq_N : byte;       {  뢠 0 - 7, 8 - 15 }
			New_Vect : pointer; {   뢠 }
		    Var Old_Vect : pointer; {   뢠 }
		    Var Old_Mask : byte     {   뢠   ࠭ }
		     ) : boolean ;
  { 楤 ⠭   뢠,
    ࠧ襭  ᮮ饣 뢠  ஫ 뢠 
     ⥪饣   筨
    楤 ஢ 祭  뢠  ⨬ }
  Var
    Cntr_N :  byte;
    Base_Cntr, Int_N : byte;
  begin
    if ( Irq_N >= 0  ) and             { ஢ઠ ⨬   }
       ( Irq_N <= 15 ) and
       ( Irq_N <> 2  )       then
    begin
      Cntr_N := Irq_N shr 3;    { ⠭  ஫ }
      Irq_N  := Irq_N and 7;
      Base_Cntr := Base_PIC[ Cntr_N ];
      Int_N     := Base_Int[ Cntr_N ] + Irq_N ;
      Irq_Set := True;
    end
    else
    begin
      Irq_Set := false;
      exit;
    end;
    GetIntVec( Int_N, Old_Vect );       { 祭 ண  뢠 }
    Old_Mask := Get_IMR( Cntr_N );      { 祭 ன ᪨ 뢠 }
    Set_IMR ( Cntr_N, Old_Mask or Mask[ Irq_N ] ) ;  { ⠭ 
		      ᪨ 뢠   饭 ᮬ }
    SetIntVec( Int_N, New_Vect );      { ⠭    뢠 }
    port[ base_Pic[ Cntr_N and 1 ] ] := $60 + Irq_N; {     뢠 }
    Set_IMR ( Cntr_N, Old_Mask and not( Mask[ Irq_N ]) ) ; { ⠭ 
		      ᪨ 뢠   ࠧ襭 ᮬ }
  end; { function Irq_Set }

  Procedure Irq_Restore( Irq_N : byte;
			 Old_Vect : pointer;
			 Old_Mask : byte
		     ) ;      { 楤 ன   ⠩஢ }
  Var
    Cntr_N :  byte;
    Base_Cntr, Int_N : byte;
  begin
    if ( Irq_N >= 0 ) and ( Irq_N <= 15 ) then
    begin
      Cntr_N := Irq_N shr 3;
      Irq_N := Irq_N and 7;
      Base_Cntr := Base_PIC[ Cntr_N ];
      Int_N     := Base_Int[ Cntr_N ] + Irq_N ;
    end
    else
    begin
      exit;
    end;
    Set_IMR ( Cntr_N, Old_Mask or Mask[ Irq_N ] ) ;
    SetIntVec( Int_N, Old_Vect );
    Set_IMR ( Cntr_N, Old_Mask ) ;
  end;

  Procedure Set_IMR ( Cntr_N , Mask :byte );
  Begin
    port[ base_Pic[ Cntr_N and 1 ] + 1 ] := Mask;
  End;

  Procedure Clr_Int ( Cntr_N : byte );
  Begin
    port[ base_Pic[ Cntr_N and 1 ] ] := $20;
  End;

  Function Get_Cntr_N ( Irq_N : byte ) : byte;
  Begin
    Get_Cntr_N := Irq_N shr 3;
  End;

  Function Get_IMR ( Cntr_N : byte ) : byte;
  Begin
    Get_IMR := port[ base_Pic[ Cntr_N and 1 ] + 1 ];
  End;

  Function Get_IRR ( Cntr_N : byte ) : byte;
  Begin
    port[ base_Pic[ Cntr_N and 1 ] ] := $0A;
    Get_IRR := port[ base_Pic[ Cntr_N and 1 ] ];
  End;
  Function Get_ISR ( Cntr_N : byte ) : byte;
  Begin
    port[ base_Pic[ Cntr_N and 1 ] ] := $0B;
    Get_ISR := port[ base_Pic[ Cntr_N and 1 ] ];
  End;

End.


